Charm
=====

Manage your Charm account and access The Charm Cloud.

<p align="center">
  <img src="https://stuff.charm.sh/charm-tool-github-header.png" width="300" alt="Charm Tool Header Treatment"><br>
  <a href="https://github.com/charmbracelet/charm/releases"><img src="https://img.shields.io/github/release/charmbracelet/charm.svg" alt="Latest Release"></a>
  <a href="https://pkg.go.dev/github.com/charmbracelet/charm?tab=doc"><img src="https://godoc.org/github.com/golang/gddo?status.svg" alt="GoDoc"></a>
  <a href="https://github.com/charmbracelet/charm/actions"><img src="https://github.com/charmbracelet/charm/workflows/build/badge.svg" alt="Build Status"></a>
</p>

<p align="center">
    <img src="https://stuff.charm.sh/charm-tool-github.gif" width="600" alt="Charm UI Trailer" />
</p>

## Installation

macOS and Linux users can use Homebrew:

```bash
brew install charmbracelet/homebrew-tap/charm
```

Or you can download a binary from the [releases][releases] page. macOS, Linux,
FreeBSD binaries are available, as well as Debian and RPM packages. ARM builds
are also available for Linux and FreeBSD.

Or just use `go get`:

```bash
go get github.com/charmbracelet/charm/cmd/charm
```

Bash/Zsh/Fish completion is also available. See `charm help completion`.

## Usage

Run without arguments for the TUI. Or, for shortcuts and additional functionality see the CLI usage at `charm help`.

## Encryption and Decryption

The Charm Tool (and Charm library) includes a simple, powerful encryption
interface. Data encrypted with Charm is decryptable only by machines linked to
your Charm account. Even we couldn’t decrypt your data if we somehow got our
hands on it.

```bash
# Encryption is easy
echo "Secret message" | charm encrypt

# Save an encrypted message to disk
echo "Secret message" | charm encrypt > secret_message.json

# Decryption is easy too
cat secret_message.json | charm decrypt

# You can encrypt any kind of data
charm encrypt < my_secret_photo.jpg > encrypted_photo.json

# Encrypt and compress
charm encrypt < secret_document.md | gzip > encrypted_document.json.gz

# Decompress, decrypt, and read wth Glow
gunzip encrypted_document.json.gz | charm decrypt | glow -p -
```

### How It Works

Encryption works by issuing symmetric keys (basically a generated password) and
encrypting it with the local SSH public key generated by this library.  That
encrypted key is then sent up to our server. We can’t read it since we don’t
have your private key. When you want to decrypt something or view your stash,
that key is downloaded from our server and decrypted locally using the SSH
private key. When you link accounts, the symmetric key is encrypted for each
new public key. This happens on your machine and not our server, so we never
see any unencrypted data.

## The Library

The Charm library is a simple API to the Charm Cloud for doing things like:

* Frictionless user identification
* User accounts linking
* Encrypt and decrypt data
* Simple SSH key generation
* Programatically read, write and delete from a user’s [Glow][glow] markdown stash

For more details and the full feature set check out [the Go docs][docs].

## License

[MIT](https://github.com/charmbracelet/charm/raw/master/LICENSE)

***

A [Charm](https://charm.sh) project.

<img alt="the Charm logo" src="https://stuff.charm.sh/charm-badge.jpg" width="400">

Charm热爱开源! / Charm loves open source!


[releases]: https://github.com/charmbracelet/charm/releases
[docs]: https://pkg.go.dev/github.com/charmbracelet/charm?tab=doc
[glow]: https://github.com/charmbracelet/glow
