// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// EXEC FAIL - compiles and builds but fails when executed.

	// Won't fix
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-4.c`:                         {}, // Unsupported vector type
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:                  {}, // Out-of-range float to int conversion, result not specified.
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/941014-2.c`:                    {}, // Prints value at uninitialized memory.
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:  {}, // Out-of-range float to int conversion, result not specified.
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/941014-2.c`:    {}, // Prints value at uninitialized memory.
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/return-addr.c`: {}, // Prints runtime-specific values.
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-basic.c`:                      {}, // Compiler specific bitfield union size.
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-trailing-zero.c`:              {}, // Compiler specific bitfield union size.
	`assets/github.com/vnmakarov/mir/c-tests/lacc/long-double-load.c`:                    {}, // Output is long double specific.
	`assets/github.com/vnmakarov/mir/c-tests/lacc/macro-paste.c`:                         {}, // Tests a particular positive value (24) returned by puts while it's specified to be only non negative on success.
	`assets/github.com/vnmakarov/mir/c-tests/lacc/whitespace.c`:                          {}, // Tests a particular positive value (24) returned by puts while it's specified to be only non negative on success.
	`assets/github.com/vnmakarov/mir/c-tests/new/issue23.c`:                              {}, // Output is long double specific.

	//TODO later musl version
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79327.c`:                 {}, // EXEC FAIL: SIGABRT: abort musl v0.6.0 does not support printf 'h' verb.
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79327.c`: {}, // EXEC FAIL: SIGABRT: abort
	`assets/github.com/vnmakarov/mir/c-tests/lacc/printstr.c`:                        {}, // EXEC FAIL: panic: libc_linux_amd64.go:1528:X__ctype_b_loc

	// BUILD FAIL - compiles but does not build.

	`assets/ccgo/bug/sqlite.c`: {}, // BUILD FAIL: exit status 1
	`assets/ccgo/bug/union3.c`: {}, // BUILD FAIL: exit status 1
	`assets/ccgo/bug/union4.c`: {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/anon-1.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-22.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zerolen-1.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-nest.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/anon-1.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-22.c`:  {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zerolen-1.c`:  {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0010-goto1.c`:             {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0011-switch1.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0028-inits14.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0028-inits15.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/lacc/goto.c`:                               {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/new/var-size-in-var-initializer.c`:         {}, // BUILD FAIL: exit status 1
	`assets/tcc-0.9.27/tests/tests2/81_types.c`:                                         {}, // BUILD FAIL: exit status 1
	`assets/tcc-0.9.27/tests/tests2/98_al_ax_extend.c`:                                  {}, // BUILD FAIL: exit status 1

	// COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/fasta-4.c`:                                             {}, // COMPILE FAIL: fasta-4.c.go:630:3: undefined: "fwrite_unlocked" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:                                        {}, // COMPILE FAIL: mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1489:unaryExpression: type.go:425:isValidType: type.go:458:isValidType1:)
	`assets/benchmarksgame-team.pages.debian.net/nbody-4.c`:                                             {}, // COMPILE FAIL: nbody-4.c.go:2089:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/benchmarksgame-team.pages.debian.net/nbody-8.c`:                                             {}, // COMPILE FAIL: nbody-8.c.go:2130:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`:                                {}, // COMPILE FAIL: reverse-complement-4.c.go:629:22: undefined: "__builtin_memmove" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000211-1.c`:                                 {}, // COMPILE FAIL: TODO (decl.go:687:initDeclarator: type.go:18:typedef: type.go:328:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000405-3.c`:                                 {}, // COMPILE FAIL: 20000405-3.c:1:1: unsupported alignment 32 of struct foo {entry array of 40 pointer to void} (type.go:512:structLiteral: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20001121-1.c`:                                 {}, // COMPILE FAIL: 20001121-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20001221-1.c`:                                 {}, // COMPILE FAIL: 20001221-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20001222-1.c`:                                 {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010118-1.c`:                                 {}, // COMPILE FAIL: 20010118-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                                 {}, // COMPILE FAIL: 20010202-1.c:3:5: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010226-1.c`:                                 {}, // COMPILE FAIL: 20010226-1.c:16:12: nested functions not supported (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010605-1.c`:                                 {}, // COMPILE FAIL: 20010605-1.c:9:9: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010903-2.c`:                                 {}, // COMPILE FAIL: 20010903-2.c:9:14: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20011023-1.c`:                                 {}, // COMPILE FAIL: 20011023-1.c:8:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20020309-1.c`:                                 {}, // COMPILE FAIL: 20020309-1.c:8:5: nested functions not supported (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030224-1.c`:                                 {}, // COMPILE FAIL: 20030224-1.c:6:25: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030418-1.c`:                                 {}, // COMPILE FAIL: 20030418-1.c:13:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030530-3.c`:                                 {}, // COMPILE FAIL: 20030530-3.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030716-1.c`:                                 {}, // COMPILE FAIL: 20030716-1.c:3:6: incomplete type: array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20031011-1.c`:                                 {}, // COMPILE FAIL: 20031011-1.c:15:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040310-1.c`:                                 {}, // COMPILE FAIL: 20040310-1.c:4:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                                 {}, // COMPILE FAIL: 20040317-1.c:1:5: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-3.c`:                                 {}, // COMPILE FAIL: 20040317-3.c:4:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040323-1.c`:                                 {}, // COMPILE FAIL: 20040323-1.c:10:16: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050119-1.c`:                                 {}, // COMPILE FAIL: 20050119-1.c:7:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050122-2.c`:                                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050510-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070919-1.c`:                                 {}, // COMPILE FAIL: TODO exprUintptr (expr.go:70:expr: expr.go:485:expr0: expr.go:1849:postfixExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20071107-1.c`:                                 {}, // COMPILE FAIL: 20071107-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20090907-1.c`:                                 {}, // COMPILE FAIL: TODO (type.go:512:structLiteral: type.go:266:typ0: type.go:328:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                                 {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110902.c`:                                   {}, // COMPILE FAIL: 20110902.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                                 {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920301-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920415-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920428-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-7.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920502-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920826-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920831-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/921012-1.c`:                                   {}, // COMPILE FAIL: 921012-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930118-1.c`:                                   {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930506-2.c`:                                   {}, // COMPILE FAIL: 930506-2.c:5:9: nested functions not supported (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/931018-1.c`:                                   {}, // COMPILE FAIL: 931018-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/941014-4.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950610-1.c`:                                   {}, // COMPILE FAIL: 950610-1.c:1:1: incomplete type: array of array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950613-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950919-1.c`:                                   {}, // COMPILE FAIL: 950919-1.c:2:10: assertions are a deprecated extension
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/951116-1.c`:                                   {}, // COMPILE FAIL: 951116-1.c:7:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                                   {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                                   {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/990517-1.c`:                                   {}, // COMPILE FAIL: 990517-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:3226:primaryExpression: expr.go:493:expr0: expr.go:1522:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:501:signature: type.go:48:typ2: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:70:expr: expr.go:493:expr0: expr.go:1522:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:70:expr: expr.go:493:expr0: expr.go:1522:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-6.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/ex.c`:                                         {}, // COMPILE FAIL: ex.c:12:19: too few arguments to function 'foo', type 'function(int, int) returning int' in 'foo ()' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-2.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-1.c`:                                   {}, // COMPILE FAIL: nested-1.c:15:24: incomplete type: array of char (type.go:413:isValidType: type.go:425:isValidType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-2.c`:                                   {}, // COMPILE FAIL: nested-2.c:9:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-3.c`:                                   {}, // COMPILE FAIL: nested-3.c:13:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pass.c`:                                       {}, // COMPILE FAIL: pass.c:13:10: too many arguments to function 'foo', type 'function(int, int, int) returning int' in 'foo ((int) & q, q, w, e, q, (int) &w)' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2685:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pc44485.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr17913.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21728.c`:                                    {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                                    {}, // COMPILE FAIL: TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (expr.go:78:expr: expr.go:128:convert: expr.go:261:convertMode:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:70:expr: expr.go:493:expr0: expr.go:1522:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27863.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27889.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:522:signature: type.go:48:typ2: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr28489.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr29128.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr30984.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr32571.c`:                                    {}, // COMPILE FAIL: pr32571.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr32919.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33173.c`:                                    {}, // COMPILE FAIL: pr33173.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33382.c`:                                    {}, // COMPILE FAIL: pr33382.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33855.c`:                                    {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34334.c`:                                    {}, // COMPILE FAIL: TODO (decl.go:687:initDeclarator: type.go:18:typedef: type.go:328:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35006.c`:                                    {}, // COMPILE FAIL: pr35006.c:9:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr37056.c`:                                    {}, // COMPILE FAIL: pr37056.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38360.c`:                                    {}, // COMPILE FAIL: pr38360.c:7:3: too few arguments to function 'fputs', type 'function(pointer to char, pointer to void) returning int' in 'fputs ("")' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr39845.c`:                                    {}, // COMPILE FAIL: TODO exprUintptr (expr.go:485:expr0: expr.go:1798:postfixExpression: expr.go:2174:postfixExpressionPSelect:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr40233.c`:                                    {}, // COMPILE FAIL: pr40233.c:2:1: unsupported alignment 64 of struct Frame {i aligned} (type.go:512:structLiteral: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr40321.c`:                                    {}, // COMPILE FAIL: pr40321.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:506:unionLiteral: type.go:325:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:506:unionLiteral: type.go:341:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:506:unionLiteral: type.go:341:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44038.c`:                                    {}, // COMPILE FAIL: pr44038.c:9:43: TODO (expr.go:487:expr0: expr.go:3216:primaryExpression: expr.go:3345:primaryExpressionStringConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr47428.c`:                                    {}, // COMPILE FAIL: pr47428.c:24:3: too few arguments to function 'fn', type 'function(int, int) returning int' in 'fn (0)' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr48641.c`:                                    {}, // COMPILE FAIL: TODO "(X__builtin_modfl(cgtls, (iqlibc.ppFloat64FromFloat64(1.5)), cgbp) != (*(*ppfloat64)(iqunsafe.ppPointer(cgbp))))" int exprBool -> long double exprDefault (expr.go:1126:equalityExpression: expr.go:78:expr: expr.go:149:convert:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51354.c`:                                    {}, // COMPILE FAIL: pr51354.c:15:6: unsupported alignment 32 of ai (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51694.c`:                                    {}, // COMPILE FAIL: pr51694.c:14:3: too few arguments to function 'foo', type 'function(int, pointer to function())' in 'foo (x)' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54559.c`:                                    {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr58164.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70190.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                                    {}, // COMPILE FAIL: pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                                  {}, // COMPILE FAIL: pr77754-1.c:5:13: incomplete type: array of array of int (decl.go:483:signature: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                                  {}, // COMPILE FAIL: pr77754-2.c:5:6: incomplete type: array of array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                                  {}, // COMPILE FAIL: pr77754-3.c:5:14: incomplete type: array of array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                                  {}, // COMPILE FAIL: pr77754-4.c:5:14: incomplete type: array of array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                                  {}, // COMPILE FAIL: pr77754-5.c:6:6: incomplete type: array of array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr79089.c`:                                    {}, // COMPILE FAIL: pr79089.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82052.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82564.c`:                                    {}, // COMPILE FAIL: pr82564.c:9:5: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84136.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                                    {}, // COMPILE FAIL: pr84305.c:3:34: TODO (expr.go:1724:postfixExpression: expr.go:1598:postfixExpressionIndex: expr.go:1546:mul:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                                    {}, // COMPILE FAIL: pr85704.c:9:26: TODO "tsC{}" struct C {c struct {}}, 0 exprDefault -> struct D {d int; e struct C; f int}, 8 exprDefault (pr85704.c:9:26:) (expr.go:78:expr: expr.go:132:convert: expr.go:304:convertType:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                                    {}, // COMPILE FAIL: pr85945.c:4:1: unsupported vector type: V (type.go:341:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:3599:primaryExpressionIntConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-5.c`:                                     {}, // COMPILE FAIL: simd-5.c:6:19: unsupported vector type: int (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                                     {}, // COMPILE FAIL: simd-6.c:5:11: unsupported vector type: vec (type.go:355:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                                      {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/statement-expression-1.c`:                     {}, // COMPILE FAIL: statement-expression-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:                          {}, // COMPILE FAIL: TODO exprLvalue (expr.go:3226:primaryExpression: expr.go:457:expr0: expr.go:2883:assignmentExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/uuarg.c`:                                      {}, // COMPILE FAIL: uuarg.c:4:10: too few arguments to function 'foo', type 'function(int, int, int, int, int, int, int, int, int) returning int' in 'foo ()' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                                   {}, // COMPILE FAIL: vector-1.c:3:1: unsupported vector type: float (type.go:266:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                                   {}, // COMPILE FAIL: vector-2.c:3:1: unsupported vector type: float (type.go:266:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                                   {}, // COMPILE FAIL: vector-4.c:7:47: unsupported vector type: signed char (type.go:42:typ: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                             {}, // COMPILE FAIL: vector-align-1.c:11:6: unsupported alignment 128 of char (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000703-1.c`:                                 {}, // COMPILE FAIL: 20000703-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                                 {}, // COMPILE FAIL: 20000822-1.c:12:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000917-1.c`:                                 {}, // COMPILE FAIL: TODO 20000917-1.c:38:18: from pointer to int3, exprUintptr to pointer to int3 exprVoid, src '&a', buf 'ppuintptr(iqunsafe.ppPointer(&(aaa)))' (expr.go:78:expr: expr.go:128:convert: expr.go:261:convertMode:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20001203-2.c`:                                 {}, // COMPILE FAIL: 20001203-2.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                                 {}, // COMPILE FAIL: 20010122-1.c.go:25:21: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                                 {}, // COMPILE FAIL: 20010209-1.c:6:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                                 {}, // COMPILE FAIL: 20010605-1.c:5:14: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:                                 {}, // COMPILE FAIL: 20010904-1.c:12:3: unsupported alignment 32 of Y (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                                 {}, // COMPILE FAIL: 20010904-2.c:12:3: unsupported alignment 32 of Y (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020314-1.c`:                                 {}, // COMPILE FAIL: 20020314-1.c.go:31:18: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020320-1.c`:                                 {}, // COMPILE FAIL: 20020320-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                                 {}, // COMPILE FAIL: 20020412-1.c:31:7: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20021113-1.c`:                                 {}, // COMPILE FAIL: 20021113-1.c.go:25:20: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:                                 {}, // COMPILE FAIL: 20030323-1.c.go:21:20: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                                 {}, // COMPILE FAIL: 20030330-1.c.go:25:4: undefined: "link_error" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                                 {}, // COMPILE FAIL: 20030501-1.c:7:9: nested functions not supported (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:                                 {}, // COMPILE FAIL: 20030811-1.c.go:29:24: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:3226:primaryExpression: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040223-1.c`:                                 {}, // COMPILE FAIL: 20040223-1.c.go:298:37: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                                 {}, // COMPILE FAIL: 20040423-1.c:13:22: incomplete type: array of int (type.go:413:isValidType: type.go:425:isValidType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                                 {}, // COMPILE FAIL: 20040520-1.c:6:13: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                                 {}, // COMPILE FAIL: 20040709-1.c.go:82:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                                 {}, // COMPILE FAIL: 20040709-2.c.go:81:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                                 {}, // COMPILE FAIL: 20040709-3.c.go:85:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (type.go:512:structLiteral: type.go:266:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (type.go:18:typedef: type.go:266:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                                 {}, // COMPILE FAIL: 20041218-2.c:7:17: incomplete type: array of char (type.go:413:isValidType: type.go:425:isValidType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                                 {}, // COMPILE FAIL: 20050316-1.c.go:21:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                                 {}, // COMPILE FAIL: 20050316-2.c.go:22:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                                 {}, // COMPILE FAIL: 20050316-3.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                                 {}, // COMPILE FAIL: 20050604-1.c:16:3: unsupported vector type: v4hi (type.go:341:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                                 {}, // COMPILE FAIL: 20050607-1.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                                 {}, // COMPILE FAIL: 20060420-1.c.go:26:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:                                 {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070824-1.c`:                                 {}, // COMPILE FAIL: 20070824-1.c.go:34:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                                 {}, // COMPILE FAIL: 20070919-1.c:31:7: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                                 {}, // COMPILE FAIL: 20080502-1.c.go:21:5: undefined: "__builtin_signbit" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                                 {}, // COMPILE FAIL: 20090219-1.c:12:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                                 {}, // COMPILE FAIL: 20101011-1.c.go:625:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                                 {}, // COMPILE FAIL: 20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (decl.go:307:functionDefinition: decl.go:327:functionDefinition0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                                   {}, // COMPILE FAIL: TODO BlockItemLabel (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                                   {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                                   {}, // COMPILE FAIL: 920612-2.c:6:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                                   {}, // COMPILE FAIL: 921017-1.c:7:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                                   {}, // COMPILE FAIL: 921215-1.c:5:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                                   {}, // COMPILE FAIL: TODO *cc.LabelDeclaration (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                                   {}, // COMPILE FAIL: 931002-1.c:10:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/941202-1.c`:                                   {}, // COMPILE FAIL: 941202-1.c.go:31:20: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/950906-1.c`:                                   {}, // COMPILE FAIL: 950906-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                                   {}, // COMPILE FAIL: 960416-1.c:57:23: internal error: t_be (expr.go:3208:primaryExpression: expr.go:3599:primaryExpressionIntConst: type.go:28:helper:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                                   {}, // COMPILE FAIL: 970217-1.c:1:1: incomplete type: array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                                   {}, // COMPILE FAIL: TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (expr.go:78:expr: expr.go:128:convert: expr.go:261:convertMode:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:                                   {}, // COMPILE FAIL: 991112-1.c.go:23:5: undefined: "__builtin_isprint" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/alias-2.c`:                                    {}, // COMPILE FAIL: alias-2.c.go:23:2: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/alias-3.c`:                                    {}, // COMPILE FAIL: alias-3.c.go:22:2: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/alias-4.c`:                                    {}, // COMPILE FAIL: alias-4.c.go:28:39: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                                    {}, // COMPILE FAIL: align-3.c:5:6: unsupported alignment 256 of function(void) (decl.go:307:functionDefinition: decl.go:327:functionDefinition0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/alloca-1.c`:                                   {}, // COMPILE FAIL: alloca-1.c.go:30:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:                            {}, // COMPILE FAIL: built-in-setjmp.c.go:23:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                           {}, // COMPILE FAIL: builtin-bitops-1.c.go:284:6: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // COMPILE FAIL: TODO *cc.InvalidType (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2665:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:                                       {}, // COMPILE FAIL: cbrt.c.go:116:13: undefined: "__builtin_cbrtl" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                                {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                                {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-2.c`:                                  {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-5.c`:                                  {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                                  {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                                  {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/compndlit-1.c`:                                {}, // COMPILE FAIL: compndlit-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ffs-1.c`:                                      {}, // COMPILE FAIL: ffs-1.c.go:20:5: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ffs-2.c`:                                      {}, // COMPILE FAIL: ffs-2.c.go:34:6: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                                  {}, // COMPILE FAIL: fprintf-2.c.go:580:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:                              {}, // COMPILE FAIL: frame-address.c.go:36:18: undefined: "__builtin_frame_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:                            {}, // COMPILE FAIL: 20010114-2.c.go:20:5: undefined: "__builtin_fabs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                            {}, // COMPILE FAIL: 20030331-1.c.go:22:5: undefined: "__builtin_fabs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                          {}, // COMPILE FAIL: compare-fp-1.c.go:31:26: undefined: "__builtin_islessgreater" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-1.c`:                              {}, // COMPILE FAIL: fp-cmp-1.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-2.c`:                              {}, // COMPILE FAIL: fp-cmp-2.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-3.c`:                              {}, // COMPILE FAIL: fp-cmp-3.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:                              {}, // COMPILE FAIL: fp-cmp-4.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:                             {}, // COMPILE FAIL: fp-cmp-4f.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:                             {}, // COMPILE FAIL: fp-cmp-4l.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:                              {}, // COMPILE FAIL: fp-cmp-5.c.go:28:9: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:                              {}, // COMPILE FAIL: fp-cmp-8.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:                             {}, // COMPILE FAIL: fp-cmp-8f.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:                             {}, // COMPILE FAIL: fp-cmp-8l.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:                                {}, // COMPILE FAIL: mzero4.c.go:49:18: undefined: "tan" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:                               {}, // COMPILE FAIL: pr38016.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                             {}, // COMPILE FAIL: pr72824-2.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                                    {}, // COMPILE FAIL: medce-1.c.go:36:2: undefined: "link_error" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:                               {}, // COMPILE FAIL: nest-align-1.c:25:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:                               {}, // COMPILE FAIL: nest-stdar-1.c:5:10: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                                 {}, // COMPILE FAIL: nestfunc-1.c:15:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                                 {}, // COMPILE FAIL: nestfunc-2.c:13:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                                 {}, // COMPILE FAIL: nestfunc-3.c:12:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                                 {}, // COMPILE FAIL: nestfunc-7.c:15:12: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:                                    {}, // COMPILE FAIL: pr17377.c.go:32:20: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr19449.c`:                                    {}, // COMPILE FAIL: pr19449.c.go:19:10: undefined: "__builtin_choose_expr" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                                  {}, // COMPILE FAIL: pr22061-1.c:4:6: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                                  {}, // COMPILE FAIL: pr22061-2.c:2:13: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                                  {}, // COMPILE FAIL: pr22061-3.c:4:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                                  {}, // COMPILE FAIL: pr22061-4.c:5:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                                    {}, // COMPILE FAIL: pr23135.c:19:14: unsupported vector type: vecint (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                                    {}, // COMPILE FAIL: TODO (type.go:597:defineUnionType: type.go:506:unionLiteral: type.go:328:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:                                    {}, // COMPILE FAIL: pr23467.c:3:1: unsupported alignment 8 of int (type.go:266:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                                    {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                                    {}, // COMPILE FAIL: TODO SelectionStatementSwitch (stmt.go:55:statement: stmt.go:418:selectionStatement: stmt.go:486:selectionStatementFlat:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                                    {}, // COMPILE FAIL: pr35456.c.go:36:7: undefined: "__builtin_signbit" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`:                                    {}, // COMPILE FAIL: pr36093.c:13:5: unsupported alignment 128 of Foo (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:                                    {}, // COMPILE FAIL: pr36321.c.go:23:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                                    {}, // COMPILE FAIL: pr37780.c.go:22:19: undefined: "__builtin_ctz" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:512:structLiteral: type.go:266:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                                    {}, // COMPILE FAIL: pr39228.c.go:24:9: undefined: "__builtin_isinff" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                                    {}, // COMPILE FAIL: pr41935.c:10:10: TODO (expr.go:1724:postfixExpression: expr.go:1598:postfixExpressionIndex: expr.go:1546:mul:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42614.c`:                                    {}, // COMPILE FAIL: undefined: "inlined_wrong" staticInternal (link.go:1396:print0: link.go:1328:print0: link.go:1255:name:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr43783.c`:                                    {}, // COMPILE FAIL: pr43783.c:8:9: unsupported alignment 16 of UINT192 (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                                    {}, // COMPILE FAIL: pr47237.c.go:31:2: undefined: "__builtin_apply" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                                    {}, // COMPILE FAIL: pr49218.c:11:9: unsupported alignment 16 of L (type.go:60:verifyTyp: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49644.c`:                                    {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                                    {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                                  {}, // COMPILE FAIL: pr53645-2.c:44:3: unsupported vector type: UV (type.go:355:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                                    {}, // COMPILE FAIL: pr53645.c:44:3: unsupported vector type: UV (type.go:355:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                                    {}, // COMPILE FAIL: pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:42:typ: type.go:355:typ0: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                                    {}, // COMPILE FAIL: pr60003.c.go:23:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                                    {}, // COMPILE FAIL: pr60960.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                                    {}, // COMPILE FAIL: pr61375.c:15:1: unsupported alignment 16 of unsigned __int128 (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61725.c`:                                    {}, // COMPILE FAIL: pr61725.c.go:21:9: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                                    {}, // COMPILE FAIL: pr63302.c:14:1: unsupported alignment 16 of __int128 (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                                    {}, // COMPILE FAIL: pr65170.c:12:1: unsupported alignment 16 of V (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                                    {}, // COMPILE FAIL: pr65427.c:4:3: unsupported vector type: V (type.go:42:typ: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                                    {}, // COMPILE FAIL: pr68381.c.go:22:5: undefined: "__builtin_mul_overflowUint16" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                                    {}, // COMPILE FAIL: pr70903.c.go:17:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                                    {}, // COMPILE FAIL: pr71554.c.go:35:5: undefined: "__builtin_mul_overflowUint32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                                  {}, // COMPILE FAIL: pr71626-1.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                                  {}, // COMPILE FAIL: pr71626-2.c.go:22:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                                    {}, // COMPILE FAIL: pr77767.c:4:1: incomplete type: array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:3610:primaryExpressionFloatConst: type.go:30:helper: type.go:162:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                                    {}, // COMPILE FAIL: pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                                    {}, // COMPILE FAIL: pr84169.c:9:3: unsupported alignment 16 of T (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                                    {}, // COMPILE FAIL: pr84748.c:6:6: unsupported alignment 16 of u128 (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                                    {}, // COMPILE FAIL: pr85169.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                                    {}, // COMPILE FAIL: pr85331.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                                  {}, // COMPILE FAIL: pr85582-2.c:12:1: unsupported alignment 16 of S (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                                  {}, // COMPILE FAIL: pr85582-3.c:12:1: unsupported alignment 16 of U (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr86528.c`:                                    {}, // COMPILE FAIL: pr86528.c.go:20:20: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                                    {}, // COMPILE FAIL: pr89434.c.go:26:2: undefined: "__builtin_mul_overflowInt32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                                   {}, // COMPILE FAIL: printf-2.c.go:593:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                               {}, // COMPILE FAIL: scal-to-vec1.c:34:28: unsupported vector type: short (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                               {}, // COMPILE FAIL: scal-to-vec2.c:35:28: unsupported vector type: char (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                               {}, // COMPILE FAIL: scal-to-vec3.c:20:28: unsupported vector type: float (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                                     {}, // COMPILE FAIL: simd-1.c:10:14: unsupported vector type: vecint (type.go:30:helper: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                                     {}, // COMPILE FAIL: simd-2.c:8:14: unsupported vector type: vecint (type.go:30:helper: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                                     {}, // COMPILE FAIL: simd-4.c.go:266:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                                     {}, // COMPILE FAIL: simd-5.c:5:9: unsupported vector type: Q (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                                     {}, // COMPILE FAIL: simd-6.c.go:17:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:                              {}, // COMPILE FAIL: string-opt-18.c.go:33:5: undefined: "mempcpy" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                                {}, // COMPILE FAIL: user-printf.c.go:589:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:                              {}, // COMPILE FAIL: va-arg-pack-1.c.go:178:5: undefined: "bar" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                              {}, // COMPILE FAIL: zero-struct-2.c:15:48: TODO "Xone_raw_spinlock(cgtls)" raw_spinlock_t, 0 exprDefault -> spinlock_t, 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:78:expr: expr.go:132:convert: expr.go:304:convertType:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000703-1.c`:                 {}, // COMPILE FAIL: gcc.c-torture/execute/20000703-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                 {}, // COMPILE FAIL: 20000822-1.c:12:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000917-1.c`:                 {}, // COMPILE FAIL: TODO 20000917-1.c:38:18: from pointer to int3, exprUintptr to pointer to int3 exprVoid, src '&a', buf 'ppuintptr(iqunsafe.ppPointer(&(aaa)))' (expr.go:78:expr: expr.go:128:convert: expr.go:261:convertMode:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20001203-2.c`:                 {}, // COMPILE FAIL: gcc.c-torture/execute/20001203-2.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                 {}, // COMPILE FAIL: 20010122-1.c.go:25:21: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                 {}, // COMPILE FAIL: 20010209-1.c:6:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                 {}, // COMPILE FAIL: 20010605-1.c:5:14: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:                 {}, // COMPILE FAIL: 20010904-1.c:12:3: unsupported alignment 32 of Y (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                 {}, // COMPILE FAIL: 20010904-2.c:12:3: unsupported alignment 32 of Y (type.go:355:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020314-1.c`:                 {}, // COMPILE FAIL: 20020314-1.c.go:31:18: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020320-1.c`:                 {}, // COMPILE FAIL: gcc.c-torture/execute/20020320-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                 {}, // COMPILE FAIL: 20020412-1.c:31:7: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20021113-1.c`:                 {}, // COMPILE FAIL: 20021113-1.c.go:25:20: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:                 {}, // COMPILE FAIL: 20030323-1.c.go:21:20: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                 {}, // COMPILE FAIL: 20030330-1.c.go:25:4: undefined: "link_error" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                 {}, // COMPILE FAIL: 20030501-1.c:7:9: nested functions not supported (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:                 {}, // COMPILE FAIL: 20030811-1.c.go:29:24: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:3226:primaryExpression: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040223-1.c`:                 {}, // COMPILE FAIL: 20040223-1.c.go:298:37: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                 {}, // COMPILE FAIL: 20040423-1.c:13:22: incomplete type: array of int (type.go:413:isValidType: type.go:425:isValidType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                 {}, // COMPILE FAIL: 20040520-1.c:6:13: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                 {}, // COMPILE FAIL: 20040709-1.c.go:82:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                 {}, // COMPILE FAIL: 20040709-2.c.go:81:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                 {}, // COMPILE FAIL: 20040709-3.c.go:85:5: undefined: "__builtin_classify_type" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (type.go:512:structLiteral: type.go:266:typ0: type.go:162:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (type.go:18:typedef: type.go:266:typ0: type.go:162:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                 {}, // COMPILE FAIL: 20041218-2.c:7:17: incomplete type: array of char (type.go:413:isValidType: type.go:425:isValidType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                 {}, // COMPILE FAIL: 20050316-1.c.go:21:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                 {}, // COMPILE FAIL: 20050316-2.c.go:22:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                 {}, // COMPILE FAIL: 20050316-3.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                 {}, // COMPILE FAIL: 20050604-1.c:16:3: unsupported vector type: v4hi (type.go:341:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                 {}, // COMPILE FAIL: 20050607-1.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                 {}, // COMPILE FAIL: 20060420-1.c.go:26:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:                 {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070824-1.c`:                 {}, // COMPILE FAIL: 20070824-1.c.go:34:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                 {}, // COMPILE FAIL: 20070919-1.c:31:7: invalid type size: -1 (type.go:42:typ: type.go:65:typ0: type.go:496:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                 {}, // COMPILE FAIL: 20080502-1.c.go:21:5: undefined: "__builtin_signbit" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                 {}, // COMPILE FAIL: 20090219-1.c:12:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                 {}, // COMPILE FAIL: 20101011-1.c.go:625:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                 {}, // COMPILE FAIL: 20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (decl.go:307:functionDefinition: decl.go:327:functionDefinition0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                   {}, // COMPILE FAIL: TODO BlockItemLabel (stmt.go:25:statement: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                   {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                   {}, // COMPILE FAIL: 920612-2.c:6:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                   {}, // COMPILE FAIL: 921017-1.c:7:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                   {}, // COMPILE FAIL: 921215-1.c:5:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                   {}, // COMPILE FAIL: TODO *cc.LabelDeclaration (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                   {}, // COMPILE FAIL: 931002-1.c:10:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/941202-1.c`:                   {}, // COMPILE FAIL: 941202-1.c.go:31:20: undefined: "alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/950906-1.c`:                   {}, // COMPILE FAIL: gcc.c-torture/execute/950906-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                   {}, // COMPILE FAIL: gcc.c-torture/execute/960416-1.c:57:23: internal error: t_be (expr.go:3208:primaryExpression: expr.go:3599:primaryExpressionIntConst: type.go:28:helper:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                   {}, // COMPILE FAIL: 970217-1.c:1:1: incomplete type: array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                   {}, // COMPILE FAIL: TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (expr.go:78:expr: expr.go:128:convert: expr.go:261:convertMode:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:70:expr: expr.go:493:expr0: expr.go:1498:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:                   {}, // COMPILE FAIL: 991112-1.c.go:23:5: undefined: "__builtin_isprint" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/alias-2.c`:                    {}, // COMPILE FAIL: alias-2.c.go:23:2: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/alias-3.c`:                    {}, // COMPILE FAIL: alias-3.c.go:22:2: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/alias-4.c`:                    {}, // COMPILE FAIL: alias-4.c.go:28:39: undefined: "b" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                    {}, // COMPILE FAIL: align-3.c:5:6: unsupported alignment 256 of function(void) (decl.go:307:functionDefinition: decl.go:327:functionDefinition0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/alloca-1.c`:                   {}, // COMPILE FAIL: alloca-1.c.go:30:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:            {}, // COMPILE FAIL: built-in-setjmp.c.go:23:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:           {}, // COMPILE FAIL: builtin-bitops-1.c.go:284:6: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // COMPILE FAIL: TODO *cc.InvalidType (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2665:postfixExpressionCall:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:                       {}, // COMPILE FAIL: cbrt.c.go:116:13: undefined: "__builtin_cbrtl" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-2.c`:                  {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-5.c`:                  {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                  {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                  {}, // COMPILE FAIL: TODO cc.Complex64Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/compndlit-1.c`:                {}, // COMPILE FAIL: gcc.c-torture/execute/compndlit-1.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ffs-1.c`:                      {}, // COMPILE FAIL: ffs-1.c.go:20:5: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ffs-2.c`:                      {}, // COMPILE FAIL: ffs-2.c.go:34:6: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                  {}, // COMPILE FAIL: fprintf-2.c.go:580:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:              {}, // COMPILE FAIL: frame-address.c.go:36:18: undefined: "__builtin_frame_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:            {}, // COMPILE FAIL: 20010114-2.c.go:20:5: undefined: "__builtin_fabs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:            {}, // COMPILE FAIL: 20030331-1.c.go:22:5: undefined: "__builtin_fabs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:          {}, // COMPILE FAIL: compare-fp-1.c.go:31:26: undefined: "__builtin_islessgreater" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-1.c`:              {}, // COMPILE FAIL: fp-cmp-1.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-2.c`:              {}, // COMPILE FAIL: fp-cmp-2.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-3.c`:              {}, // COMPILE FAIL: fp-cmp-3.c.go:640:2: undefined: "signal" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:              {}, // COMPILE FAIL: fp-cmp-4.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:             {}, // COMPILE FAIL: fp-cmp-4f.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:             {}, // COMPILE FAIL: fp-cmp-4l.c.go:31:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:              {}, // COMPILE FAIL: fp-cmp-5.c.go:28:9: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:              {}, // COMPILE FAIL: fp-cmp-8.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:             {}, // COMPILE FAIL: fp-cmp-8f.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:             {}, // COMPILE FAIL: fp-cmp-8l.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:                {}, // COMPILE FAIL: mzero4.c.go:49:18: undefined: "tan" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:               {}, // COMPILE FAIL: pr38016.c.go:41:5: undefined: "__builtin_isless" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:             {}, // COMPILE FAIL: pr72824-2.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                    {}, // COMPILE FAIL: medce-1.c.go:36:2: undefined: "link_error" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:               {}, // COMPILE FAIL: nest-align-1.c:25:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:               {}, // COMPILE FAIL: nest-stdar-1.c:5:10: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                 {}, // COMPILE FAIL: nestfunc-1.c:15:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                 {}, // COMPILE FAIL: nestfunc-2.c:13:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                 {}, // COMPILE FAIL: nestfunc-3.c:12:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                 {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                 {}, // COMPILE FAIL: nestfunc-7.c:15:12: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:                    {}, // COMPILE FAIL: pr17377.c.go:32:20: undefined: "__builtin_return_address" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr19449.c`:                    {}, // COMPILE FAIL: pr19449.c.go:19:10: undefined: "__builtin_choose_expr" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                  {}, // COMPILE FAIL: pr22061-1.c:4:6: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                  {}, // COMPILE FAIL: pr22061-2.c:2:13: incomplete type: array of array of char (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                  {}, // COMPILE FAIL: pr22061-3.c:4:7: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                  {}, // COMPILE FAIL: pr22061-4.c:5:8: nested functions not supported (decl.go:374:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:325:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                    {}, // COMPILE FAIL: pr23135.c:19:14: unsupported vector type: vecint (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                    {}, // COMPILE FAIL: TODO (type.go:597:defineUnionType: type.go:506:unionLiteral: type.go:328:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:                    {}, // COMPILE FAIL: pr23467.c:3:1: unsupported alignment 8 of int (type.go:266:typ0: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                    {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                    {}, // COMPILE FAIL: TODO SelectionStatementSwitch (stmt.go:55:statement: stmt.go:418:selectionStatement: stmt.go:486:selectionStatementFlat:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                    {}, // COMPILE FAIL: pr35456.c.go:36:7: undefined: "__builtin_signbit" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:                    {}, // COMPILE FAIL: pr36321.c.go:23:18: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                    {}, // COMPILE FAIL: pr37780.c.go:22:19: undefined: "__builtin_ctz" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:512:structLiteral: type.go:266:typ0: type.go:162:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                    {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:70:expr: expr.go:493:expr0: expr.go:1524:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                    {}, // COMPILE FAIL: pr39228.c.go:23:9: undefined: "__builtin_isinff" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                    {}, // COMPILE FAIL: pr41935.c:10:10: TODO (expr.go:1724:postfixExpression: expr.go:1598:postfixExpressionIndex: expr.go:1546:mul:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42614.c`:                    {}, // COMPILE FAIL: undefined: "inlined_wrong" staticInternal (link.go:1396:print0: link.go:1328:print0: link.go:1255:name:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                    {}, // COMPILE FAIL: pr47237.c.go:31:2: undefined: "__builtin_apply" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                    {}, // COMPILE FAIL: pr49218.c:11:9: unsupported alignment 16 of L (type.go:60:verifyTyp: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49644.c`:                    {}, // COMPILE FAIL: TODO cc.Complex128Value (expr.go:487:expr0: expr.go:3210:primaryExpression: expr.go:3633:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                    {}, // COMPILE FAIL: TODO BlockItemLabel (decl.go:337:functionDefinition0: stmt.go:286:compoundStatement: stmt.go:320:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                  {}, // COMPILE FAIL: pr53645-2.c:44:3: unsupported vector type: UV (type.go:355:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                    {}, // COMPILE FAIL: pr53645.c:44:3: unsupported vector type: UV (type.go:355:typ0: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                    {}, // COMPILE FAIL: pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (type.go:42:typ: type.go:355:typ0: type.go:162:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                    {}, // COMPILE FAIL: pr60003.c.go:23:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                    {}, // COMPILE FAIL: pr60960.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                    {}, // COMPILE FAIL: pr61375.c:15:1: unsupported alignment 16 of unsigned __int128 (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61725.c`:                    {}, // COMPILE FAIL: pr61725.c.go:21:9: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                    {}, // COMPILE FAIL: pr63302.c:14:1: unsupported alignment 16 of __int128 (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64242.c`:                    {}, // COMPILE FAIL: pr64242.c.go:27:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                    {}, // COMPILE FAIL: pr65170.c:12:1: unsupported alignment 16 of V (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                    {}, // COMPILE FAIL: pr65427.c:4:3: unsupported vector type: V (type.go:42:typ: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                    {}, // COMPILE FAIL: -: TODO (expr.go:851:conditionalExpression: expr.go:43:topExpr: expr.go:54:expr:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                    {}, // COMPILE FAIL: pr68381.c.go:22:5: undefined: "__builtin_mul_overflowUint16" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                    {}, // COMPILE FAIL: pr70903.c.go:17:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                    {}, // COMPILE FAIL: TODO <nil> (decl.go:307:functionDefinition: decl.go:329:functionDefinition0: decl.go:98:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                    {}, // COMPILE FAIL: pr71554.c.go:35:5: undefined: "__builtin_mul_overflowUint32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                  {}, // COMPILE FAIL: pr71626-1.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                  {}, // COMPILE FAIL: pr71626-2.c.go:22:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                    {}, // COMPILE FAIL: pr77767.c:4:1: incomplete type: array of int (type.go:477:isValidType1: type.go:401:isValidParamType: type.go:489:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:3610:primaryExpressionFloatConst: type.go:30:helper: type.go:162:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                    {}, // COMPILE FAIL: pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                    {}, // COMPILE FAIL: pr84169.c:9:3: unsupported alignment 16 of T (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84521.c`:                    {}, // COMPILE FAIL: pr84521.c.go:21:2: undefined: "__builtin_longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                    {}, // COMPILE FAIL: pr84748.c:6:6: unsupported alignment 16 of u128 (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                    {}, // COMPILE FAIL: pr85169.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                    {}, // COMPILE FAIL: pr85331.c.go:20:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                  {}, // COMPILE FAIL: pr85582-2.c:12:1: unsupported alignment 16 of S (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                  {}, // COMPILE FAIL: pr85582-3.c:12:1: unsupported alignment 16 of U (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr86528.c`:                    {}, // COMPILE FAIL: pr86528.c.go:20:20: undefined: "__builtin_alloca" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                    {}, // COMPILE FAIL: pr89434.c.go:26:2: undefined: "__builtin_mul_overflowInt32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr90311.c`:                    {}, // COMPILE FAIL: pr90311.c.go:28:2: undefined: "__builtin_add_overflowUint8" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-1.c`:                  {}, // COMPILE FAIL: pr91450-1.c.go:22:7: undefined: "__builtin_mul_overflowInt32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-2.c`:                  {}, // COMPILE FAIL: pr91450-2.c.go:22:5: undefined: "__builtin_mul_overflowInt32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91635.c`:                    {}, // COMPILE FAIL: pr91635.c.go:27:33: undefined: "__builtin_add_overflowInt32" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92618.c`:                    {}, // COMPILE FAIL: pr92618.c.go:33:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92904.c`:                    {}, // COMPILE FAIL: pr92904.c:12:10: unsupported alignment 16 of __int128 (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93213.c`:                    {}, // COMPILE FAIL: pr93213.c:11:1: unsupported alignment 16 of u128 (type.go:472:isValidType1: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93249.c`:                    {}, // COMPILE FAIL: pr93249.c.go:30:2: undefined: "__builtin_strncpy" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93434.c`:                    {}, // COMPILE FAIL: TODO "(!(((aai) != 0)))" int exprBool -> double exprDefault (expr.go:1126:equalityExpression: expr.go:78:expr: expr.go:149:convert:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94412.c`:                    {}, // COMPILE FAIL: pr94412.c.go:21:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-1.c`:                  {}, // COMPILE FAIL: pr94524-1.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-2.c`:                  {}, // COMPILE FAIL: pr94524-2.c.go:19:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94591.c`:                    {}, // COMPILE FAIL: pr94591.c.go:17:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr97325.c`:                    {}, // COMPILE FAIL: pr97325.c.go:20:10: undefined: "__builtin_ffs" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr98474.c`:                    {}, // COMPILE FAIL: pr98474.c:14:3: unsupported alignment 16 of T (type.go:42:typ: type.go:65:typ0: type.go:444:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                   {}, // COMPILE FAIL: printf-2.c.go:593:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:               {}, // COMPILE FAIL: scal-to-vec1.c:34:28: unsupported vector type: short (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:               {}, // COMPILE FAIL: scal-to-vec2.c:35:28: unsupported vector type: char (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:               {}, // COMPILE FAIL: scal-to-vec3.c:20:28: unsupported vector type: float (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                     {}, // COMPILE FAIL: simd-1.c:10:14: unsupported vector type: vecint (type.go:30:helper: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                     {}, // COMPILE FAIL: simd-2.c:8:14: unsupported vector type: vecint (type.go:30:helper: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                     {}, // COMPILE FAIL: simd-4.c.go:266:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                     {}, // COMPILE FAIL: simd-5.c:5:9: unsupported vector type: Q (type.go:60:verifyTyp: type.go:65:typ0: type.go:458:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                     {}, // COMPILE FAIL: simd-6.c.go:17:17: undefined: "main" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:              {}, // COMPILE FAIL: string-opt-18.c.go:33:5: undefined: "mempcpy" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                {}, // COMPILE FAIL: user-printf.c.go:589:15: undefined: "tmpnam" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:              {}, // COMPILE FAIL: va-arg-pack-1.c.go:178:5: undefined: "bar" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:              {}, // COMPILE FAIL: zero-struct-2.c:15:48: TODO "Xone_raw_spinlock(cgtls)" raw_spinlock_t, 0 exprDefault -> spinlock_t, 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:78:expr: expr.go:132:convert: expr.go:304:convertType:)
	`assets/github.com/vnmakarov/mir/c-benchmarks/except.c`:                                             {}, // COMPILE FAIL: except.c.go:585:3: undefined: "longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/anonymous-members.c`:                                  {}, // COMPILE FAIL: TODO exprUintptr (expr.go:485:expr0: expr.go:1798:postfixExpression: expr.go:2174:postfixExpressionPSelect:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/deref-compare-float.c`:                                {}, // COMPILE FAIL: TODO "((iqlibc.ppFloat64FromFloat64(0)) > (ppfloat64((*(*ppint32)(iqunsafe.ppPointer((Xi)))))))" int exprBool -> float exprDefault (expr.go:2880:assignmentExpression: expr.go:78:expr: expr.go:149:convert:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/float-compare-equal.c`:                                {}, // COMPILE FAIL: TODO "((ppfloat32(Xi)) == (*(*ppfloat32)(iqunsafe.ppPointer((Xf)))))" int exprBool -> float exprDefault (expr.go:2880:assignmentExpression: expr.go:78:expr: expr.go:149:convert:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-incomplete.c`:                                {}, // COMPILE FAIL: function-incomplete.c:6:9: too few arguments to function 'foo', type 'function(pointer to char) returning int' in 'foo()' (expr.go:485:expr0: expr.go:1793:postfixExpression: expr.go:2680:postfixExpressionCall:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/identifier.c`:                                         {}, // COMPILE FAIL: invalid object file: multiple defintions of c (ccgo.go:403:main: link.go:213:link: link.go:459:getFileSymbols:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-call.c`:                                    {}, // COMPILE FAIL: initialize-call.c:25:9: TODO "sigetobj(cgtls, (ppint32(2)), (ppint32(8)), (ppint32(1)))" struct obj {s array of 3 short}, 6 exprDefault -> struct {t struct obj}, 6 exprDefault (initialize-call.c:25:9:) (expr.go:78:expr: expr.go:132:convert: expr.go:304:convertType:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-string.c`:                                  {}, // COMPILE FAIL: initialize-string.c:14:14: TODO "\"wat\\x00\"" pointer to char, 8 exprDefault -> array of 7 char, 7 exprDefault (initialize-string.c:14:14:) (expr.go:78:expr: expr.go:132:convert: expr.go:304:convertType:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-addr.c`:                                        {}, // COMPILE FAIL: string-addr.c:4:16: TODO (expr.go:487:expr0: expr.go:3216:primaryExpression: expr.go:3345:primaryExpressionStringConst:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/stringify.c`:                                          {}, // COMPILE FAIL: TODO `'\xA'` -> invalid syntax (expr.go:487:expr0: expr.go:3212:primaryExpression: expr.go:3453:primaryExpressionCharConst:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/typedef-function.c`:                                   {}, // COMPILE FAIL: typedef-function.c.go:30:86: undefined: "isalnum" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c`:                                              {}, // COMPILE FAIL: setjmp.c.go:38:2: undefined: "longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp2.c`:                                             {}, // COMPILE FAIL: setjmp2.c.go:38:2: undefined: "longjmp" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/tcc-0.9.27/tests/tests2/24_math_library.c`:                                                  {}, // COMPILE FAIL: 24_math_library.c.go:299:53: undefined: "tan" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:)
	`assets/tcc-0.9.27/tests/tests2/76_dollars_in_identifiers.c`:                                        {}, // COMPILE FAIL: 76_dollars_in_identifiers.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/tcc-0.9.27/tests/tests2/85_asm-outside-function.c`:                                          {}, // COMPILE FAIL: 85_asm-outside-function.c.go:18:2: undefined: "vide" external (ccgo.go:403:main: link.go:242:link: link.go:704:link:) (ccgo.go:403:main: link.go:242:link: link.go:707:link:)
	`assets/tcc-0.9.27/tests/tests2/87_dead_code.c`:                                                     {}, // COMPILE FAIL: 87_dead_code.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/tcc-0.9.27/tests/tests2/88_codeopt.c`:                                                       {}, // COMPILE FAIL: 88_codeopt.c: gofmt: exit status 2 (asm_amd64.s:1598:goexit: compile.go:440:compile: compile.go:440:compile:)
	`assets/tcc-0.9.27/tests/tests2/94_generic.c`:                                                       {}, // COMPILE FAIL: TODO PrimaryExpressionGeneric (expr.go:70:expr: expr.go:487:expr0: expr.go:3247:primaryExpression:)
	`assets/tcc-0.9.27/tests/tests2/95_bitfields.c`:                                                     {}, // COMPILE FAIL: 95_bitfields.c:27:5: unsupported alignment 16 of char (type.go:413:isValidType: type.go:425:isValidType: type.go:444:isValidType1:)
	`assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c`:                                                  {}, // COMPILE FAIL: 95_bitfields.c:27:5: unsupported alignment 16 of char (type.go:413:isValidType: type.go:425:isValidType: type.go:444:isValidType1:)
}
