// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/organization.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Organization struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name               string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Description        string                 `protobuf:"bytes,5,opt,name=description,proto3"`
	xxx_hidden_Url                string                 `protobuf:"bytes,6,opt,name=url,proto3"`
	xxx_hidden_VerificationStatus VerificationStatus     `protobuf:"varint,7,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *Organization) Reset() {
	*x = Organization{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Organization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Organization) ProtoMessage() {}

func (x *Organization) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Organization) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Organization) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Organization) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *Organization) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Organization) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *Organization) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *Organization) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *Organization) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Organization) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Organization) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *Organization) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Organization) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *Organization) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *Organization) SetVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

func (x *Organization) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Organization) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *Organization) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Organization) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type Organization_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique, immutable
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// mutable
	UpdateTime *timestamppb.Timestamp
	// unique, mutable
	Name string
	// description is the user configurable description of the organization.
	Description string
	// url is the user configurable URL in the description of the organization,
	// always included the scheme and will not have a #fragment suffix.
	Url string
	// verification status of the organization, configurable by server admin.
	VerificationStatus VerificationStatus
}

func (b0 Organization_builder) Build() *Organization {
	m0 := &Organization{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	return m0
}

// OrganizationMembership is a nested structure that contains
// the organization and user membership information on that organization.
type OrganizationMembership struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Organization     *Organization          `protobuf:"bytes,1,opt,name=organization,proto3"`
	xxx_hidden_OrganizationRole OrganizationRole       `protobuf:"varint,2,opt,name=organization_role,json=organizationRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *OrganizationMembership) Reset() {
	*x = OrganizationMembership{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationMembership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationMembership) ProtoMessage() {}

func (x *OrganizationMembership) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OrganizationMembership) GetOrganization() *Organization {
	if x != nil {
		return x.xxx_hidden_Organization
	}
	return nil
}

func (x *OrganizationMembership) GetOrganizationRole() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OrganizationRole
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *OrganizationMembership) SetOrganization(v *Organization) {
	x.xxx_hidden_Organization = v
}

func (x *OrganizationMembership) SetOrganizationRole(v OrganizationRole) {
	x.xxx_hidden_OrganizationRole = v
}

func (x *OrganizationMembership) HasOrganization() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Organization != nil
}

func (x *OrganizationMembership) ClearOrganization() {
	x.xxx_hidden_Organization = nil
}

type OrganizationMembership_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organization     *Organization
	OrganizationRole OrganizationRole
}

func (b0 OrganizationMembership_builder) Build() *OrganizationMembership {
	m0 := &OrganizationMembership{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organization = b.Organization
	x.xxx_hidden_OrganizationRole = b.OrganizationRole
	return m0
}

type GetOrganizationRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOrganizationRequest) Reset() {
	*x = GetOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationRequest) ProtoMessage() {}

func (x *GetOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *GetOrganizationRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type GetOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 GetOrganizationRequest_builder) Build() *GetOrganizationRequest {
	m0 := &GetOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type GetOrganizationResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Organization *Organization          `protobuf:"bytes,1,opt,name=organization,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetOrganizationResponse) Reset() {
	*x = GetOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationResponse) ProtoMessage() {}

func (x *GetOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationResponse) GetOrganization() *Organization {
	if x != nil {
		return x.xxx_hidden_Organization
	}
	return nil
}

func (x *GetOrganizationResponse) SetOrganization(v *Organization) {
	x.xxx_hidden_Organization = v
}

func (x *GetOrganizationResponse) HasOrganization() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Organization != nil
}

func (x *GetOrganizationResponse) ClearOrganization() {
	x.xxx_hidden_Organization = nil
}

type GetOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organization *Organization
}

func (b0 GetOrganizationResponse_builder) Build() *GetOrganizationResponse {
	m0 := &GetOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organization = b.Organization
	return m0
}

type GetOrganizationByNameRequest struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetOrganizationByNameRequest) Reset() {
	*x = GetOrganizationByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationByNameRequest) ProtoMessage() {}

func (x *GetOrganizationByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationByNameRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetOrganizationByNameRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

type GetOrganizationByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
}

func (b0 GetOrganizationByNameRequest_builder) Build() *GetOrganizationByNameRequest {
	m0 := &GetOrganizationByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	return m0
}

type GetOrganizationByNameResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Organization *Organization          `protobuf:"bytes,1,opt,name=organization,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetOrganizationByNameResponse) Reset() {
	*x = GetOrganizationByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationByNameResponse) ProtoMessage() {}

func (x *GetOrganizationByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationByNameResponse) GetOrganization() *Organization {
	if x != nil {
		return x.xxx_hidden_Organization
	}
	return nil
}

func (x *GetOrganizationByNameResponse) SetOrganization(v *Organization) {
	x.xxx_hidden_Organization = v
}

func (x *GetOrganizationByNameResponse) HasOrganization() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Organization != nil
}

func (x *GetOrganizationByNameResponse) ClearOrganization() {
	x.xxx_hidden_Organization = nil
}

type GetOrganizationByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organization *Organization
}

func (b0 GetOrganizationByNameResponse_builder) Build() *GetOrganizationByNameResponse {
	m0 := &GetOrganizationByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organization = b.Organization
	return m0
}

type ListOrganizationsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListOrganizationsRequest) Reset() {
	*x = ListOrganizationsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsRequest) ProtoMessage() {}

func (x *ListOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListOrganizationsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListOrganizationsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListOrganizationsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListOrganizationsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListOrganizationsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListOrganizationsRequest_builder) Build() *ListOrganizationsRequest {
	m0 := &ListOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListOrganizationsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Organizations *[]*Organization       `protobuf:"bytes,1,rep,name=organizations,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListOrganizationsResponse) Reset() {
	*x = ListOrganizationsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsResponse) ProtoMessage() {}

func (x *ListOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		if x.xxx_hidden_Organizations != nil {
			return *x.xxx_hidden_Organizations
		}
	}
	return nil
}

func (x *ListOrganizationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListOrganizationsResponse) SetOrganizations(v []*Organization) {
	x.xxx_hidden_Organizations = &v
}

func (x *ListOrganizationsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organizations []*Organization
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListOrganizationsResponse_builder) Build() *ListOrganizationsResponse {
	m0 := &ListOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organizations = &b.Organizations
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListUserOrganizationsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId    string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListUserOrganizationsRequest) Reset() {
	*x = ListUserOrganizationsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserOrganizationsRequest) ProtoMessage() {}

func (x *ListUserOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserOrganizationsRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ListUserOrganizationsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListUserOrganizationsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListUserOrganizationsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListUserOrganizationsRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *ListUserOrganizationsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListUserOrganizationsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListUserOrganizationsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListUserOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the user whose organizations should be listed.
	UserId   string
	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListUserOrganizationsRequest_builder) Build() *ListUserOrganizationsRequest {
	m0 := &ListUserOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListUserOrganizationsResponse struct {
	state                    protoimpl.MessageState     `protogen:"opaque.v1"`
	xxx_hidden_Organizations *[]*OrganizationMembership `protobuf:"bytes,1,rep,name=organizations,proto3"`
	xxx_hidden_NextPageToken string                     `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListUserOrganizationsResponse) Reset() {
	*x = ListUserOrganizationsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserOrganizationsResponse) ProtoMessage() {}

func (x *ListUserOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserOrganizationsResponse) GetOrganizations() []*OrganizationMembership {
	if x != nil {
		if x.xxx_hidden_Organizations != nil {
			return *x.xxx_hidden_Organizations
		}
	}
	return nil
}

func (x *ListUserOrganizationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListUserOrganizationsResponse) SetOrganizations(v []*OrganizationMembership) {
	x.xxx_hidden_Organizations = &v
}

func (x *ListUserOrganizationsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListUserOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organizations []*OrganizationMembership
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListUserOrganizationsResponse_builder) Build() *ListUserOrganizationsResponse {
	m0 := &ListUserOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organizations = &b.Organizations
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetUserOrganizationRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId         string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetUserOrganizationRequest) Reset() {
	*x = GetUserOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserOrganizationRequest) ProtoMessage() {}

func (x *GetUserOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserOrganizationRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *GetUserOrganizationRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *GetUserOrganizationRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *GetUserOrganizationRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type GetUserOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the user whose membership should be retrieved.
	UserId string
	// The ID of the organization.
	OrganizationId string
}

func (b0 GetUserOrganizationRequest_builder) Build() *GetUserOrganizationRequest {
	m0 := &GetUserOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type GetUserOrganizationResponse struct {
	state                             protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OrganizationMembership *OrganizationMembership `protobuf:"bytes,1,opt,name=organization_membership,json=organizationMembership,proto3"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *GetUserOrganizationResponse) Reset() {
	*x = GetUserOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserOrganizationResponse) ProtoMessage() {}

func (x *GetUserOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUserOrganizationResponse) GetOrganizationMembership() *OrganizationMembership {
	if x != nil {
		return x.xxx_hidden_OrganizationMembership
	}
	return nil
}

func (x *GetUserOrganizationResponse) SetOrganizationMembership(v *OrganizationMembership) {
	x.xxx_hidden_OrganizationMembership = v
}

func (x *GetUserOrganizationResponse) HasOrganizationMembership() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_OrganizationMembership != nil
}

func (x *GetUserOrganizationResponse) ClearOrganizationMembership() {
	x.xxx_hidden_OrganizationMembership = nil
}

type GetUserOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OrganizationMembership *OrganizationMembership
}

func (b0 GetUserOrganizationResponse_builder) Build() *GetUserOrganizationResponse {
	m0 := &GetUserOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationMembership = b.OrganizationMembership
	return m0
}

type CreateOrganizationRequest struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *CreateOrganizationRequest) Reset() {
	*x = CreateOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationRequest) ProtoMessage() {}

func (x *CreateOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrganizationRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CreateOrganizationRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

type CreateOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Must be unique across organizations.
	Name string
}

func (b0 CreateOrganizationRequest_builder) Build() *CreateOrganizationRequest {
	m0 := &CreateOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	return m0
}

type CreateOrganizationResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Organization *Organization          `protobuf:"bytes,1,opt,name=organization,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *CreateOrganizationResponse) Reset() {
	*x = CreateOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationResponse) ProtoMessage() {}

func (x *CreateOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrganizationResponse) GetOrganization() *Organization {
	if x != nil {
		return x.xxx_hidden_Organization
	}
	return nil
}

func (x *CreateOrganizationResponse) SetOrganization(v *Organization) {
	x.xxx_hidden_Organization = v
}

func (x *CreateOrganizationResponse) HasOrganization() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Organization != nil
}

func (x *CreateOrganizationResponse) ClearOrganization() {
	x.xxx_hidden_Organization = nil
}

type CreateOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Organization *Organization
}

func (b0 CreateOrganizationResponse_builder) Build() *CreateOrganizationResponse {
	m0 := &CreateOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Organization = b.Organization
	return m0
}

type DeleteOrganizationRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteOrganizationRequest) Reset() {
	*x = DeleteOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationRequest) ProtoMessage() {}

func (x *DeleteOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteOrganizationRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *DeleteOrganizationRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type DeleteOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 DeleteOrganizationRequest_builder) Build() *DeleteOrganizationRequest {
	m0 := &DeleteOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type DeleteOrganizationResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteOrganizationResponse) Reset() {
	*x = DeleteOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationResponse) ProtoMessage() {}

func (x *DeleteOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteOrganizationResponse_builder) Build() *DeleteOrganizationResponse {
	m0 := &DeleteOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeleteOrganizationByNameRequest struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *DeleteOrganizationByNameRequest) Reset() {
	*x = DeleteOrganizationByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationByNameRequest) ProtoMessage() {}

func (x *DeleteOrganizationByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteOrganizationByNameRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *DeleteOrganizationByNameRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

type DeleteOrganizationByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
}

func (b0 DeleteOrganizationByNameRequest_builder) Build() *DeleteOrganizationByNameRequest {
	m0 := &DeleteOrganizationByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	return m0
}

type DeleteOrganizationByNameResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteOrganizationByNameResponse) Reset() {
	*x = DeleteOrganizationByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationByNameResponse) ProtoMessage() {}

func (x *DeleteOrganizationByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteOrganizationByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteOrganizationByNameResponse_builder) Build() *DeleteOrganizationByNameResponse {
	m0 := &DeleteOrganizationByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type AddOrganizationMemberRequest struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_UserId           string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_OrganizationRole OrganizationRole       `protobuf:"varint,3,opt,name=organization_role,json=organizationRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *AddOrganizationMemberRequest) Reset() {
	*x = AddOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOrganizationMemberRequest) ProtoMessage() {}

func (x *AddOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AddOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *AddOrganizationMemberRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *AddOrganizationMemberRequest) GetOrganizationRole() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OrganizationRole
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *AddOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *AddOrganizationMemberRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *AddOrganizationMemberRequest) SetOrganizationRole(v OrganizationRole) {
	x.xxx_hidden_OrganizationRole = v
}

type AddOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which the user will be added to.
	OrganizationId string
	// The ID of the user for which to be added to the organization.
	UserId string
	// The new role of the user in the organization.
	OrganizationRole OrganizationRole
}

func (b0 AddOrganizationMemberRequest_builder) Build() *AddOrganizationMemberRequest {
	m0 := &AddOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_OrganizationRole = b.OrganizationRole
	return m0
}

type AddOrganizationMemberResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddOrganizationMemberResponse) Reset() {
	*x = AddOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOrganizationMemberResponse) ProtoMessage() {}

func (x *AddOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type AddOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 AddOrganizationMemberResponse_builder) Build() *AddOrganizationMemberResponse {
	m0 := &AddOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UpdateOrganizationMemberRequest struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_UserId           string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_OrganizationRole OrganizationRole       `protobuf:"varint,3,opt,name=organization_role,json=organizationRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *UpdateOrganizationMemberRequest) Reset() {
	*x = UpdateOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationMemberRequest) ProtoMessage() {}

func (x *UpdateOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UpdateOrganizationMemberRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *UpdateOrganizationMemberRequest) GetOrganizationRole() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OrganizationRole
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *UpdateOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *UpdateOrganizationMemberRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *UpdateOrganizationMemberRequest) SetOrganizationRole(v OrganizationRole) {
	x.xxx_hidden_OrganizationRole = v
}

type UpdateOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which the member belongs to.
	OrganizationId string
	// The ID of the user for which to be updated the role.
	UserId string
	// The new role of the user in the organization.
	OrganizationRole OrganizationRole
}

func (b0 UpdateOrganizationMemberRequest_builder) Build() *UpdateOrganizationMemberRequest {
	m0 := &UpdateOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_OrganizationRole = b.OrganizationRole
	return m0
}

type UpdateOrganizationMemberResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationMemberResponse) Reset() {
	*x = UpdateOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationMemberResponse) ProtoMessage() {}

func (x *UpdateOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateOrganizationMemberResponse_builder) Build() *UpdateOrganizationMemberResponse {
	m0 := &UpdateOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type RemoveOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_UserId         string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *RemoveOrganizationMemberRequest) Reset() {
	*x = RemoveOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveOrganizationMemberRequest) ProtoMessage() {}

func (x *RemoveOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RemoveOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *RemoveOrganizationMemberRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *RemoveOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *RemoveOrganizationMemberRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

type RemoveOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which the member belongs to.
	OrganizationId string
	// The ID of the user for which to be removed the role.
	UserId string
}

func (b0 RemoveOrganizationMemberRequest_builder) Build() *RemoveOrganizationMemberRequest {
	m0 := &RemoveOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type RemoveOrganizationMemberResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveOrganizationMemberResponse) Reset() {
	*x = RemoveOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveOrganizationMemberResponse) ProtoMessage() {}

func (x *RemoveOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RemoveOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RemoveOrganizationMemberResponse_builder) Build() *RemoveOrganizationMemberResponse {
	m0 := &RemoveOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type SetOrganizationMemberRequest struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_UserId           string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_OrganizationRole OrganizationRole       `protobuf:"varint,3,opt,name=organization_role,json=organizationRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *SetOrganizationMemberRequest) Reset() {
	*x = SetOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOrganizationMemberRequest) ProtoMessage() {}

func (x *SetOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SetOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *SetOrganizationMemberRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *SetOrganizationMemberRequest) GetOrganizationRole() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OrganizationRole
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *SetOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *SetOrganizationMemberRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *SetOrganizationMemberRequest) SetOrganizationRole(v OrganizationRole) {
	x.xxx_hidden_OrganizationRole = v
}

type SetOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which the user's role will be set.
	OrganizationId string
	// The ID of the user whose role will be set.
	UserId string
	// The role to assign to the user.
	// Setting UNSPECIFIED means removing the user's role.
	OrganizationRole OrganizationRole
}

func (b0 SetOrganizationMemberRequest_builder) Build() *SetOrganizationMemberRequest {
	m0 := &SetOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_OrganizationRole = b.OrganizationRole
	return m0
}

type SetOrganizationMemberResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetOrganizationMemberResponse) Reset() {
	*x = SetOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOrganizationMemberResponse) ProtoMessage() {}

func (x *SetOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type SetOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 SetOrganizationMemberResponse_builder) Build() *SetOrganizationMemberResponse {
	m0 := &SetOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetOrganizationSettingsRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetOrganizationSettingsRequest) Reset() {
	*x = GetOrganizationSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationSettingsRequest) ProtoMessage() {}

func (x *GetOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationSettingsRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *GetOrganizationSettingsRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type GetOrganizationSettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to get the settings.
	OrganizationId string
}

func (b0 GetOrganizationSettingsRequest_builder) Build() *GetOrganizationSettingsRequest {
	m0 := &GetOrganizationSettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type GetOrganizationSettingsResponse struct {
	state                         protoimpl.MessageState                       `protogen:"opaque.v1"`
	xxx_hidden_RepositoryBaseRole RepositoryRole                               `protobuf:"varint,1,opt,name=repository_base_role,json=repositoryBaseRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_MembersCount       uint32                                       `protobuf:"varint,4,opt,name=members_count,json=membersCount,proto3"`
	xxx_hidden_IdpGroups          *[]*GetOrganizationSettingsResponse_IdPGroup `protobuf:"bytes,5,rep,name=idp_groups,json=idpGroups,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *GetOrganizationSettingsResponse) Reset() {
	*x = GetOrganizationSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationSettingsResponse) ProtoMessage() {}

func (x *GetOrganizationSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationSettingsResponse) GetRepositoryBaseRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RepositoryBaseRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *GetOrganizationSettingsResponse) GetMembersCount() uint32 {
	if x != nil {
		return x.xxx_hidden_MembersCount
	}
	return 0
}

func (x *GetOrganizationSettingsResponse) GetIdpGroups() []*GetOrganizationSettingsResponse_IdPGroup {
	if x != nil {
		if x.xxx_hidden_IdpGroups != nil {
			return *x.xxx_hidden_IdpGroups
		}
	}
	return nil
}

func (x *GetOrganizationSettingsResponse) SetRepositoryBaseRole(v RepositoryRole) {
	x.xxx_hidden_RepositoryBaseRole = v
}

func (x *GetOrganizationSettingsResponse) SetMembersCount(v uint32) {
	x.xxx_hidden_MembersCount = v
}

func (x *GetOrganizationSettingsResponse) SetIdpGroups(v []*GetOrganizationSettingsResponse_IdPGroup) {
	x.xxx_hidden_IdpGroups = &v
}

type GetOrganizationSettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryBaseRole RepositoryRole
	// The number of members in the organization.
	MembersCount uint32
	// The IdP groups associated with the organization.
	IdpGroups []*GetOrganizationSettingsResponse_IdPGroup
}

func (b0 GetOrganizationSettingsResponse_builder) Build() *GetOrganizationSettingsResponse {
	m0 := &GetOrganizationSettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryBaseRole = b.RepositoryBaseRole
	x.xxx_hidden_MembersCount = b.MembersCount
	x.xxx_hidden_IdpGroups = &b.IdpGroups
	return m0
}

type UpdateOrganizationSettingsRequest struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId     string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_RepositoryBaseRole RepositoryRole         `protobuf:"varint,2,opt,name=repository_base_role,json=repositoryBaseRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_Description        *string                `protobuf:"bytes,5,opt,name=description,proto3,oneof"`
	xxx_hidden_Url                *string                `protobuf:"bytes,6,opt,name=url,proto3,oneof"`
	XXX_raceDetectHookData        protoimpl.RaceDetectHookData
	XXX_presence                  [1]uint32
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *UpdateOrganizationSettingsRequest) Reset() {
	*x = UpdateOrganizationSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationSettingsRequest) ProtoMessage() {}

func (x *UpdateOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationSettingsRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UpdateOrganizationSettingsRequest) GetRepositoryBaseRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RepositoryBaseRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *UpdateOrganizationSettingsRequest) GetDescription() string {
	if x != nil {
		if x.xxx_hidden_Description != nil {
			return *x.xxx_hidden_Description
		}
		return ""
	}
	return ""
}

func (x *UpdateOrganizationSettingsRequest) GetUrl() string {
	if x != nil {
		if x.xxx_hidden_Url != nil {
			return *x.xxx_hidden_Url
		}
		return ""
	}
	return ""
}

func (x *UpdateOrganizationSettingsRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *UpdateOrganizationSettingsRequest) SetRepositoryBaseRole(v RepositoryRole) {
	x.xxx_hidden_RepositoryBaseRole = v
}

func (x *UpdateOrganizationSettingsRequest) SetDescription(v string) {
	x.xxx_hidden_Description = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 4)
}

func (x *UpdateOrganizationSettingsRequest) SetUrl(v string) {
	x.xxx_hidden_Url = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 3, 4)
}

func (x *UpdateOrganizationSettingsRequest) HasDescription() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdateOrganizationSettingsRequest) HasUrl() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 3)
}

func (x *UpdateOrganizationSettingsRequest) ClearDescription() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_Description = nil
}

func (x *UpdateOrganizationSettingsRequest) ClearUrl() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 3)
	x.xxx_hidden_Url = nil
}

type UpdateOrganizationSettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to update the base roles.
	OrganizationId string
	// optional, no update to this base role will be made if this is unspecified.
	RepositoryBaseRole RepositoryRole
	// optional, update to description will only be made when this is present
	Description *string
	// optional, update to url will only be made when this is present
	Url *string
}

func (b0 UpdateOrganizationSettingsRequest_builder) Build() *UpdateOrganizationSettingsRequest {
	m0 := &UpdateOrganizationSettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_RepositoryBaseRole = b.RepositoryBaseRole
	if b.Description != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 4)
		x.xxx_hidden_Description = b.Description
	}
	if b.Url != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 3, 4)
		x.xxx_hidden_Url = b.Url
	}
	return m0
}

type UpdateOrganizationSettingsResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationSettingsResponse) Reset() {
	*x = UpdateOrganizationSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationSettingsResponse) ProtoMessage() {}

func (x *UpdateOrganizationSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateOrganizationSettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateOrganizationSettingsResponse_builder) Build() *UpdateOrganizationSettingsResponse {
	m0 := &UpdateOrganizationSettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type AddOrganizationGroupRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_GroupName      string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	xxx_hidden_RoleOverride   OrganizationRole       `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *AddOrganizationGroupRequest) Reset() {
	*x = AddOrganizationGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddOrganizationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOrganizationGroupRequest) ProtoMessage() {}

func (x *AddOrganizationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AddOrganizationGroupRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *AddOrganizationGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *AddOrganizationGroupRequest) GetRoleOverride() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *AddOrganizationGroupRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *AddOrganizationGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

func (x *AddOrganizationGroupRequest) SetRoleOverride(v OrganizationRole) {
	x.xxx_hidden_RoleOverride = v
}

type AddOrganizationGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to add the group.
	OrganizationId string
	// The name of the group to add.
	GroupName string
	// The role to associate with this organization group.
	//
	// Any user who maps to this organization via this group will be granted this role. If no role is
	// set, the user will be granted the 'member' role.
	RoleOverride OrganizationRole
}

func (b0 AddOrganizationGroupRequest_builder) Build() *AddOrganizationGroupRequest {
	m0 := &AddOrganizationGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_GroupName = b.GroupName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type AddOrganizationGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddOrganizationGroupResponse) Reset() {
	*x = AddOrganizationGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddOrganizationGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOrganizationGroupResponse) ProtoMessage() {}

func (x *AddOrganizationGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type AddOrganizationGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 AddOrganizationGroupResponse_builder) Build() *AddOrganizationGroupResponse {
	m0 := &AddOrganizationGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UpdateOrganizationGroupRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_GroupName      string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	xxx_hidden_RoleOverride   OrganizationRole       `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole,oneof"`
	XXX_raceDetectHookData    protoimpl.RaceDetectHookData
	XXX_presence              [1]uint32
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UpdateOrganizationGroupRequest) Reset() {
	*x = UpdateOrganizationGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationGroupRequest) ProtoMessage() {}

func (x *UpdateOrganizationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationGroupRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UpdateOrganizationGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *UpdateOrganizationGroupRequest) GetRoleOverride() OrganizationRole {
	if x != nil {
		if protoimpl.X.Present(&(x.XXX_presence[0]), 2) {
			return x.xxx_hidden_RoleOverride
		}
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *UpdateOrganizationGroupRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *UpdateOrganizationGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

func (x *UpdateOrganizationGroupRequest) SetRoleOverride(v OrganizationRole) {
	x.xxx_hidden_RoleOverride = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 3)
}

func (x *UpdateOrganizationGroupRequest) HasRoleOverride() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdateOrganizationGroupRequest) ClearRoleOverride() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_RoleOverride = OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

type UpdateOrganizationGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization to which this group belongs.
	OrganizationId string
	// The name of the group to update.
	GroupName string
	// The role to associate with this organization group.
	//
	// Setting this to 'UNSPECIFIED' will remove the override. Leaving this unset will not update this
	// property.
	RoleOverride *OrganizationRole
}

func (b0 UpdateOrganizationGroupRequest_builder) Build() *UpdateOrganizationGroupRequest {
	m0 := &UpdateOrganizationGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_GroupName = b.GroupName
	if b.RoleOverride != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 3)
		x.xxx_hidden_RoleOverride = *b.RoleOverride
	}
	return m0
}

type UpdateOrganizationGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationGroupResponse) Reset() {
	*x = UpdateOrganizationGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationGroupResponse) ProtoMessage() {}

func (x *UpdateOrganizationGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateOrganizationGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateOrganizationGroupResponse_builder) Build() *UpdateOrganizationGroupResponse {
	m0 := &UpdateOrganizationGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type RemoveOrganizationGroupRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_GroupName      string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *RemoveOrganizationGroupRequest) Reset() {
	*x = RemoveOrganizationGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveOrganizationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveOrganizationGroupRequest) ProtoMessage() {}

func (x *RemoveOrganizationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RemoveOrganizationGroupRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *RemoveOrganizationGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *RemoveOrganizationGroupRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *RemoveOrganizationGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

type RemoveOrganizationGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to remove the group.
	OrganizationId string
	// The name of the group to remove.
	GroupName string
}

func (b0 RemoveOrganizationGroupRequest_builder) Build() *RemoveOrganizationGroupRequest {
	m0 := &RemoveOrganizationGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_GroupName = b.GroupName
	return m0
}

type RemoveOrganizationGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveOrganizationGroupResponse) Reset() {
	*x = RemoveOrganizationGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveOrganizationGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveOrganizationGroupResponse) ProtoMessage() {}

func (x *RemoveOrganizationGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RemoveOrganizationGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RemoveOrganizationGroupResponse_builder) Build() *RemoveOrganizationGroupResponse {
	m0 := &RemoveOrganizationGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetOrganizationSettingsResponse_IdPGroup struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name         string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_RoleOverride OrganizationRole       `protobuf:"varint,2,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetOrganizationSettingsResponse_IdPGroup) Reset() {
	*x = GetOrganizationSettingsResponse_IdPGroup{}
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationSettingsResponse_IdPGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationSettingsResponse_IdPGroup) ProtoMessage() {}

func (x *GetOrganizationSettingsResponse_IdPGroup) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationSettingsResponse_IdPGroup) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetOrganizationSettingsResponse_IdPGroup) GetRoleOverride() OrganizationRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return OrganizationRole_ORGANIZATION_ROLE_UNSPECIFIED
}

func (x *GetOrganizationSettingsResponse_IdPGroup) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetOrganizationSettingsResponse_IdPGroup) SetRoleOverride(v OrganizationRole) {
	x.xxx_hidden_RoleOverride = v
}

type GetOrganizationSettingsResponse_IdPGroup_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the IdP group.
	Name string
	// The role override associated with this group.
	RoleOverride OrganizationRole
}

func (b0 GetOrganizationSettingsResponse_IdPGroup_builder) Build() *GetOrganizationSettingsResponse_IdPGroup {
	m0 := &GetOrganizationSettingsResponse_IdPGroup{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

var File_buf_alpha_registry_v1alpha1_organization_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_organization_proto_rawDesc = "" +
	"\n" +
	".buf/alpha/registry/v1alpha1/organization.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/registry/v1alpha1/role.proto\x1a5buf/alpha/registry/v1alpha1/verification_status.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xc2\x02\n" +
	"\fOrganization\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12;\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"updateTime\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12\x10\n" +
	"\x03url\x18\x06 \x01(\tR\x03url\x12`\n" +
	"\x13verification_status\x18\a \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x12verificationStatus\"\xc3\x01\n" +
	"\x16OrganizationMembership\x12M\n" +
	"\forganization\x18\x01 \x01(\v2).buf.alpha.registry.v1alpha1.OrganizationR\forganization\x12Z\n" +
	"\x11organization_role\x18\x02 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x10organizationRole\"(\n" +
	"\x16GetOrganizationRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"h\n" +
	"\x17GetOrganizationResponse\x12M\n" +
	"\forganization\x18\x01 \x01(\v2).buf.alpha.registry.v1alpha1.OrganizationR\forganization\"2\n" +
	"\x1cGetOrganizationByNameRequest\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"n\n" +
	"\x1dGetOrganizationByNameResponse\x12M\n" +
	"\forganization\x18\x01 \x01(\v2).buf.alpha.registry.v1alpha1.OrganizationR\forganization\"p\n" +
	"\x18ListOrganizationsRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\"\x94\x01\n" +
	"\x19ListOrganizationsResponse\x12O\n" +
	"\rorganizations\x18\x01 \x03(\v2).buf.alpha.registry.v1alpha1.OrganizationR\rorganizations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x8d\x01\n" +
	"\x1cListUserOrganizationsRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\xa2\x01\n" +
	"\x1dListUserOrganizationsResponse\x12Y\n" +
	"\rorganizations\x18\x01 \x03(\v23.buf.alpha.registry.v1alpha1.OrganizationMembershipR\rorganizations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"^\n" +
	"\x1aGetUserOrganizationRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12'\n" +
	"\x0forganization_id\x18\x02 \x01(\tR\x0eorganizationId\"\x8b\x01\n" +
	"\x1bGetUserOrganizationResponse\x12l\n" +
	"\x17organization_membership\x18\x01 \x01(\v23.buf.alpha.registry.v1alpha1.OrganizationMembershipR\x16organizationMembership\"/\n" +
	"\x19CreateOrganizationRequest\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"k\n" +
	"\x1aCreateOrganizationResponse\x12M\n" +
	"\forganization\x18\x01 \x01(\v2).buf.alpha.registry.v1alpha1.OrganizationR\forganization\"+\n" +
	"\x19DeleteOrganizationRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"\x1c\n" +
	"\x1aDeleteOrganizationResponse\"5\n" +
	"\x1fDeleteOrganizationByNameRequest\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"\"\n" +
	" DeleteOrganizationByNameResponse\"\xbc\x01\n" +
	"\x1cAddOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\x12Z\n" +
	"\x11organization_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x10organizationRole\"\x1f\n" +
	"\x1dAddOrganizationMemberResponse\"\xbf\x01\n" +
	"\x1fUpdateOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\x12Z\n" +
	"\x11organization_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x10organizationRole\"\"\n" +
	" UpdateOrganizationMemberResponse\"c\n" +
	"\x1fRemoveOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\"\"\n" +
	" RemoveOrganizationMemberResponse\"\xbc\x01\n" +
	"\x1cSetOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\x12Z\n" +
	"\x11organization_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x10organizationRole\"\x1f\n" +
	"\x1dSetOrganizationMemberResponse\"I\n" +
	"\x1eGetOrganizationSettingsRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"\xb1\x03\n" +
	"\x1fGetOrganizationSettingsResponse\x12]\n" +
	"\x14repository_base_role\x18\x01 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x12repositoryBaseRole\x12#\n" +
	"\rmembers_count\x18\x04 \x01(\rR\fmembersCount\x12d\n" +
	"\n" +
	"idp_groups\x18\x05 \x03(\v2E.buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.IdPGroupR\tidpGroups\x1ar\n" +
	"\bIdPGroup\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12R\n" +
	"\rrole_override\x18\x02 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\froleOverrideJ\x04\b\x02\x10\x03J\x04\b\x03\x10\x04R\x10plugin_base_roleR\x12template_base_role\"\xb3\x02\n" +
	"!UpdateOrganizationSettingsRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12]\n" +
	"\x14repository_base_role\x18\x02 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x12repositoryBaseRole\x12%\n" +
	"\vdescription\x18\x05 \x01(\tH\x00R\vdescription\x88\x01\x01\x12\x15\n" +
	"\x03url\x18\x06 \x01(\tH\x01R\x03url\x88\x01\x01B\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_urlJ\x04\b\x03\x10\x04J\x04\b\x04\x10\x05R\x10plugin_base_roleR\x12template_base_role\"$\n" +
	"\"UpdateOrganizationSettingsResponse\"\xb9\x01\n" +
	"\x1bAddOrganizationGroupRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\x12R\n" +
	"\rrole_override\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\froleOverride\"\x1e\n" +
	"\x1cAddOrganizationGroupResponse\"\xd3\x01\n" +
	"\x1eUpdateOrganizationGroupRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\x12W\n" +
	"\rrole_override\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleH\x00R\froleOverride\x88\x01\x01B\x10\n" +
	"\x0e_role_override\"!\n" +
	"\x1fUpdateOrganizationGroupResponse\"h\n" +
	"\x1eRemoveOrganizationGroupRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\"!\n" +
	"\x1fRemoveOrganizationGroupResponse2\xff\x13\n" +
	"\x13OrganizationService\x12\x81\x01\n" +
	"\x0fGetOrganization\x123.buf.alpha.registry.v1alpha1.GetOrganizationRequest\x1a4.buf.alpha.registry.v1alpha1.GetOrganizationResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15GetOrganizationByName\x129.buf.alpha.registry.v1alpha1.GetOrganizationByNameRequest\x1a:.buf.alpha.registry.v1alpha1.GetOrganizationByNameResponse\"\x03\x90\x02\x01\x12\x87\x01\n" +
	"\x11ListOrganizations\x125.buf.alpha.registry.v1alpha1.ListOrganizationsRequest\x1a6.buf.alpha.registry.v1alpha1.ListOrganizationsResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15ListUserOrganizations\x129.buf.alpha.registry.v1alpha1.ListUserOrganizationsRequest\x1a:.buf.alpha.registry.v1alpha1.ListUserOrganizationsResponse\"\x03\x90\x02\x01\x12\x8d\x01\n" +
	"\x13GetUserOrganization\x127.buf.alpha.registry.v1alpha1.GetUserOrganizationRequest\x1a8.buf.alpha.registry.v1alpha1.GetUserOrganizationResponse\"\x03\x90\x02\x01\x12\x8a\x01\n" +
	"\x12CreateOrganization\x126.buf.alpha.registry.v1alpha1.CreateOrganizationRequest\x1a7.buf.alpha.registry.v1alpha1.CreateOrganizationResponse\"\x03\x90\x02\x02\x12\x8a\x01\n" +
	"\x12DeleteOrganization\x126.buf.alpha.registry.v1alpha1.DeleteOrganizationRequest\x1a7.buf.alpha.registry.v1alpha1.DeleteOrganizationResponse\"\x03\x90\x02\x02\x12\x9c\x01\n" +
	"\x18DeleteOrganizationByName\x12<.buf.alpha.registry.v1alpha1.DeleteOrganizationByNameRequest\x1a=.buf.alpha.registry.v1alpha1.DeleteOrganizationByNameResponse\"\x03\x90\x02\x02\x12\x93\x01\n" +
	"\x15AddOrganizationMember\x129.buf.alpha.registry.v1alpha1.AddOrganizationMemberRequest\x1a:.buf.alpha.registry.v1alpha1.AddOrganizationMemberResponse\"\x03\x90\x02\x02\x12\x97\x01\n" +
	"\x18UpdateOrganizationMember\x12<.buf.alpha.registry.v1alpha1.UpdateOrganizationMemberRequest\x1a=.buf.alpha.registry.v1alpha1.UpdateOrganizationMemberResponse\x12\x9c\x01\n" +
	"\x18RemoveOrganizationMember\x12<.buf.alpha.registry.v1alpha1.RemoveOrganizationMemberRequest\x1a=.buf.alpha.registry.v1alpha1.RemoveOrganizationMemberResponse\"\x03\x90\x02\x02\x12\x8e\x01\n" +
	"\x15SetOrganizationMember\x129.buf.alpha.registry.v1alpha1.SetOrganizationMemberRequest\x1a:.buf.alpha.registry.v1alpha1.SetOrganizationMemberResponse\x12\x99\x01\n" +
	"\x17GetOrganizationSettings\x12;.buf.alpha.registry.v1alpha1.GetOrganizationSettingsRequest\x1a<.buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse\"\x03\x90\x02\x01\x12\x9d\x01\n" +
	"\x1aUpdateOrganizationSettings\x12>.buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsRequest\x1a?.buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsResponse\x12\x90\x01\n" +
	"\x14AddOrganizationGroup\x128.buf.alpha.registry.v1alpha1.AddOrganizationGroupRequest\x1a9.buf.alpha.registry.v1alpha1.AddOrganizationGroupResponse\"\x03\x90\x02\x02\x12\x99\x01\n" +
	"\x17UpdateOrganizationGroup\x12;.buf.alpha.registry.v1alpha1.UpdateOrganizationGroupRequest\x1a<.buf.alpha.registry.v1alpha1.UpdateOrganizationGroupResponse\"\x03\x90\x02\x02\x12\x99\x01\n" +
	"\x17RemoveOrganizationGroup\x12;.buf.alpha.registry.v1alpha1.RemoveOrganizationGroupRequest\x1a<.buf.alpha.registry.v1alpha1.RemoveOrganizationGroupResponse\"\x03\x90\x02\x02B\x9e\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x11OrganizationProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_buf_alpha_registry_v1alpha1_organization_proto_goTypes = []any{
	(*Organization)(nil),                             // 0: buf.alpha.registry.v1alpha1.Organization
	(*OrganizationMembership)(nil),                   // 1: buf.alpha.registry.v1alpha1.OrganizationMembership
	(*GetOrganizationRequest)(nil),                   // 2: buf.alpha.registry.v1alpha1.GetOrganizationRequest
	(*GetOrganizationResponse)(nil),                  // 3: buf.alpha.registry.v1alpha1.GetOrganizationResponse
	(*GetOrganizationByNameRequest)(nil),             // 4: buf.alpha.registry.v1alpha1.GetOrganizationByNameRequest
	(*GetOrganizationByNameResponse)(nil),            // 5: buf.alpha.registry.v1alpha1.GetOrganizationByNameResponse
	(*ListOrganizationsRequest)(nil),                 // 6: buf.alpha.registry.v1alpha1.ListOrganizationsRequest
	(*ListOrganizationsResponse)(nil),                // 7: buf.alpha.registry.v1alpha1.ListOrganizationsResponse
	(*ListUserOrganizationsRequest)(nil),             // 8: buf.alpha.registry.v1alpha1.ListUserOrganizationsRequest
	(*ListUserOrganizationsResponse)(nil),            // 9: buf.alpha.registry.v1alpha1.ListUserOrganizationsResponse
	(*GetUserOrganizationRequest)(nil),               // 10: buf.alpha.registry.v1alpha1.GetUserOrganizationRequest
	(*GetUserOrganizationResponse)(nil),              // 11: buf.alpha.registry.v1alpha1.GetUserOrganizationResponse
	(*CreateOrganizationRequest)(nil),                // 12: buf.alpha.registry.v1alpha1.CreateOrganizationRequest
	(*CreateOrganizationResponse)(nil),               // 13: buf.alpha.registry.v1alpha1.CreateOrganizationResponse
	(*DeleteOrganizationRequest)(nil),                // 14: buf.alpha.registry.v1alpha1.DeleteOrganizationRequest
	(*DeleteOrganizationResponse)(nil),               // 15: buf.alpha.registry.v1alpha1.DeleteOrganizationResponse
	(*DeleteOrganizationByNameRequest)(nil),          // 16: buf.alpha.registry.v1alpha1.DeleteOrganizationByNameRequest
	(*DeleteOrganizationByNameResponse)(nil),         // 17: buf.alpha.registry.v1alpha1.DeleteOrganizationByNameResponse
	(*AddOrganizationMemberRequest)(nil),             // 18: buf.alpha.registry.v1alpha1.AddOrganizationMemberRequest
	(*AddOrganizationMemberResponse)(nil),            // 19: buf.alpha.registry.v1alpha1.AddOrganizationMemberResponse
	(*UpdateOrganizationMemberRequest)(nil),          // 20: buf.alpha.registry.v1alpha1.UpdateOrganizationMemberRequest
	(*UpdateOrganizationMemberResponse)(nil),         // 21: buf.alpha.registry.v1alpha1.UpdateOrganizationMemberResponse
	(*RemoveOrganizationMemberRequest)(nil),          // 22: buf.alpha.registry.v1alpha1.RemoveOrganizationMemberRequest
	(*RemoveOrganizationMemberResponse)(nil),         // 23: buf.alpha.registry.v1alpha1.RemoveOrganizationMemberResponse
	(*SetOrganizationMemberRequest)(nil),             // 24: buf.alpha.registry.v1alpha1.SetOrganizationMemberRequest
	(*SetOrganizationMemberResponse)(nil),            // 25: buf.alpha.registry.v1alpha1.SetOrganizationMemberResponse
	(*GetOrganizationSettingsRequest)(nil),           // 26: buf.alpha.registry.v1alpha1.GetOrganizationSettingsRequest
	(*GetOrganizationSettingsResponse)(nil),          // 27: buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse
	(*UpdateOrganizationSettingsRequest)(nil),        // 28: buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsRequest
	(*UpdateOrganizationSettingsResponse)(nil),       // 29: buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsResponse
	(*AddOrganizationGroupRequest)(nil),              // 30: buf.alpha.registry.v1alpha1.AddOrganizationGroupRequest
	(*AddOrganizationGroupResponse)(nil),             // 31: buf.alpha.registry.v1alpha1.AddOrganizationGroupResponse
	(*UpdateOrganizationGroupRequest)(nil),           // 32: buf.alpha.registry.v1alpha1.UpdateOrganizationGroupRequest
	(*UpdateOrganizationGroupResponse)(nil),          // 33: buf.alpha.registry.v1alpha1.UpdateOrganizationGroupResponse
	(*RemoveOrganizationGroupRequest)(nil),           // 34: buf.alpha.registry.v1alpha1.RemoveOrganizationGroupRequest
	(*RemoveOrganizationGroupResponse)(nil),          // 35: buf.alpha.registry.v1alpha1.RemoveOrganizationGroupResponse
	(*GetOrganizationSettingsResponse_IdPGroup)(nil), // 36: buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.IdPGroup
	(*timestamppb.Timestamp)(nil),                    // 37: google.protobuf.Timestamp
	(VerificationStatus)(0),                          // 38: buf.alpha.registry.v1alpha1.VerificationStatus
	(OrganizationRole)(0),                            // 39: buf.alpha.registry.v1alpha1.OrganizationRole
	(RepositoryRole)(0),                              // 40: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_organization_proto_depIdxs = []int32{
	37, // 0: buf.alpha.registry.v1alpha1.Organization.create_time:type_name -> google.protobuf.Timestamp
	37, // 1: buf.alpha.registry.v1alpha1.Organization.update_time:type_name -> google.protobuf.Timestamp
	38, // 2: buf.alpha.registry.v1alpha1.Organization.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	0,  // 3: buf.alpha.registry.v1alpha1.OrganizationMembership.organization:type_name -> buf.alpha.registry.v1alpha1.Organization
	39, // 4: buf.alpha.registry.v1alpha1.OrganizationMembership.organization_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	0,  // 5: buf.alpha.registry.v1alpha1.GetOrganizationResponse.organization:type_name -> buf.alpha.registry.v1alpha1.Organization
	0,  // 6: buf.alpha.registry.v1alpha1.GetOrganizationByNameResponse.organization:type_name -> buf.alpha.registry.v1alpha1.Organization
	0,  // 7: buf.alpha.registry.v1alpha1.ListOrganizationsResponse.organizations:type_name -> buf.alpha.registry.v1alpha1.Organization
	1,  // 8: buf.alpha.registry.v1alpha1.ListUserOrganizationsResponse.organizations:type_name -> buf.alpha.registry.v1alpha1.OrganizationMembership
	1,  // 9: buf.alpha.registry.v1alpha1.GetUserOrganizationResponse.organization_membership:type_name -> buf.alpha.registry.v1alpha1.OrganizationMembership
	0,  // 10: buf.alpha.registry.v1alpha1.CreateOrganizationResponse.organization:type_name -> buf.alpha.registry.v1alpha1.Organization
	39, // 11: buf.alpha.registry.v1alpha1.AddOrganizationMemberRequest.organization_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	39, // 12: buf.alpha.registry.v1alpha1.UpdateOrganizationMemberRequest.organization_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	39, // 13: buf.alpha.registry.v1alpha1.SetOrganizationMemberRequest.organization_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	40, // 14: buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.repository_base_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	36, // 15: buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.idp_groups:type_name -> buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.IdPGroup
	40, // 16: buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsRequest.repository_base_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	39, // 17: buf.alpha.registry.v1alpha1.AddOrganizationGroupRequest.role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	39, // 18: buf.alpha.registry.v1alpha1.UpdateOrganizationGroupRequest.role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	39, // 19: buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse.IdPGroup.role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	2,  // 20: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganization:input_type -> buf.alpha.registry.v1alpha1.GetOrganizationRequest
	4,  // 21: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationByName:input_type -> buf.alpha.registry.v1alpha1.GetOrganizationByNameRequest
	6,  // 22: buf.alpha.registry.v1alpha1.OrganizationService.ListOrganizations:input_type -> buf.alpha.registry.v1alpha1.ListOrganizationsRequest
	8,  // 23: buf.alpha.registry.v1alpha1.OrganizationService.ListUserOrganizations:input_type -> buf.alpha.registry.v1alpha1.ListUserOrganizationsRequest
	10, // 24: buf.alpha.registry.v1alpha1.OrganizationService.GetUserOrganization:input_type -> buf.alpha.registry.v1alpha1.GetUserOrganizationRequest
	12, // 25: buf.alpha.registry.v1alpha1.OrganizationService.CreateOrganization:input_type -> buf.alpha.registry.v1alpha1.CreateOrganizationRequest
	14, // 26: buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganization:input_type -> buf.alpha.registry.v1alpha1.DeleteOrganizationRequest
	16, // 27: buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganizationByName:input_type -> buf.alpha.registry.v1alpha1.DeleteOrganizationByNameRequest
	18, // 28: buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.AddOrganizationMemberRequest
	20, // 29: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationMemberRequest
	22, // 30: buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.RemoveOrganizationMemberRequest
	24, // 31: buf.alpha.registry.v1alpha1.OrganizationService.SetOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.SetOrganizationMemberRequest
	26, // 32: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationSettings:input_type -> buf.alpha.registry.v1alpha1.GetOrganizationSettingsRequest
	28, // 33: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationSettings:input_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsRequest
	30, // 34: buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationGroup:input_type -> buf.alpha.registry.v1alpha1.AddOrganizationGroupRequest
	32, // 35: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationGroup:input_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationGroupRequest
	34, // 36: buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationGroup:input_type -> buf.alpha.registry.v1alpha1.RemoveOrganizationGroupRequest
	3,  // 37: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganization:output_type -> buf.alpha.registry.v1alpha1.GetOrganizationResponse
	5,  // 38: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationByName:output_type -> buf.alpha.registry.v1alpha1.GetOrganizationByNameResponse
	7,  // 39: buf.alpha.registry.v1alpha1.OrganizationService.ListOrganizations:output_type -> buf.alpha.registry.v1alpha1.ListOrganizationsResponse
	9,  // 40: buf.alpha.registry.v1alpha1.OrganizationService.ListUserOrganizations:output_type -> buf.alpha.registry.v1alpha1.ListUserOrganizationsResponse
	11, // 41: buf.alpha.registry.v1alpha1.OrganizationService.GetUserOrganization:output_type -> buf.alpha.registry.v1alpha1.GetUserOrganizationResponse
	13, // 42: buf.alpha.registry.v1alpha1.OrganizationService.CreateOrganization:output_type -> buf.alpha.registry.v1alpha1.CreateOrganizationResponse
	15, // 43: buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganization:output_type -> buf.alpha.registry.v1alpha1.DeleteOrganizationResponse
	17, // 44: buf.alpha.registry.v1alpha1.OrganizationService.DeleteOrganizationByName:output_type -> buf.alpha.registry.v1alpha1.DeleteOrganizationByNameResponse
	19, // 45: buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.AddOrganizationMemberResponse
	21, // 46: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationMemberResponse
	23, // 47: buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.RemoveOrganizationMemberResponse
	25, // 48: buf.alpha.registry.v1alpha1.OrganizationService.SetOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.SetOrganizationMemberResponse
	27, // 49: buf.alpha.registry.v1alpha1.OrganizationService.GetOrganizationSettings:output_type -> buf.alpha.registry.v1alpha1.GetOrganizationSettingsResponse
	29, // 50: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationSettings:output_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationSettingsResponse
	31, // 51: buf.alpha.registry.v1alpha1.OrganizationService.AddOrganizationGroup:output_type -> buf.alpha.registry.v1alpha1.AddOrganizationGroupResponse
	33, // 52: buf.alpha.registry.v1alpha1.OrganizationService.UpdateOrganizationGroup:output_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationGroupResponse
	35, // 53: buf.alpha.registry.v1alpha1.OrganizationService.RemoveOrganizationGroup:output_type -> buf.alpha.registry.v1alpha1.RemoveOrganizationGroupResponse
	37, // [37:54] is the sub-list for method output_type
	20, // [20:37] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_organization_proto_init() }
func file_buf_alpha_registry_v1alpha1_organization_proto_init() {
	if File_buf_alpha_registry_v1alpha1_organization_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[28].OneofWrappers = []any{}
	file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes[32].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_organization_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_organization_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_organization_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_organization_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_organization_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_organization_proto = out.File
	file_buf_alpha_registry_v1alpha1_organization_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_organization_proto_depIdxs = nil
}
