// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/image.proto

package registryv1alpha1

import (
	v1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/image/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ImageMask is used in GetImageRequest to specify which parts of an image
// should be masked in responses.
type ImageMask int32

const (
	ImageMask_IMAGE_MASK_UNSPECIFIED ImageMask = 0
	// IMAGE_MASK_MESSAGES refers to ImageFile's `google.protobuf.DescriptorProto
	// message_type` field.
	ImageMask_IMAGE_MASK_MESSAGES ImageMask = 1
	// IMAGE_MASK_ENUMS refers to ImageFile's `google.protobuf.EnumDescriptorProto
	// enum_type` field.
	ImageMask_IMAGE_MASK_ENUMS ImageMask = 2
	// IMAGE_MASK_SERVICES refers to ImageFile's
	// `google.protobuf.ServiceDescriptorProto service` field.
	ImageMask_IMAGE_MASK_SERVICES ImageMask = 3
)

// Enum value maps for ImageMask.
var (
	ImageMask_name = map[int32]string{
		0: "IMAGE_MASK_UNSPECIFIED",
		1: "IMAGE_MASK_MESSAGES",
		2: "IMAGE_MASK_ENUMS",
		3: "IMAGE_MASK_SERVICES",
	}
	ImageMask_value = map[string]int32{
		"IMAGE_MASK_UNSPECIFIED": 0,
		"IMAGE_MASK_MESSAGES":    1,
		"IMAGE_MASK_ENUMS":       2,
		"IMAGE_MASK_SERVICES":    3,
	}
)

func (x ImageMask) Enum() *ImageMask {
	p := new(ImageMask)
	*p = x
	return p
}

func (x ImageMask) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImageMask) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_image_proto_enumTypes[0].Descriptor()
}

func (ImageMask) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_image_proto_enumTypes[0]
}

func (x ImageMask) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetImageRequest struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner             string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository        string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference         string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	xxx_hidden_ExcludeImports    bool                   `protobuf:"varint,4,opt,name=exclude_imports,json=excludeImports,proto3"`
	xxx_hidden_ExcludeSourceInfo bool                   `protobuf:"varint,5,opt,name=exclude_source_info,json=excludeSourceInfo,proto3"`
	xxx_hidden_Types             []string               `protobuf:"bytes,6,rep,name=types,proto3"`
	xxx_hidden_IncludeMask       []ImageMask            `protobuf:"varint,7,rep,packed,name=include_mask,json=includeMask,proto3,enum=buf.alpha.registry.v1alpha1.ImageMask"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *GetImageRequest) Reset() {
	*x = GetImageRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_image_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageRequest) ProtoMessage() {}

func (x *GetImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_image_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetImageRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetImageRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetImageRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetImageRequest) GetExcludeImports() bool {
	if x != nil {
		return x.xxx_hidden_ExcludeImports
	}
	return false
}

func (x *GetImageRequest) GetExcludeSourceInfo() bool {
	if x != nil {
		return x.xxx_hidden_ExcludeSourceInfo
	}
	return false
}

func (x *GetImageRequest) GetTypes() []string {
	if x != nil {
		return x.xxx_hidden_Types
	}
	return nil
}

func (x *GetImageRequest) GetIncludeMask() []ImageMask {
	if x != nil {
		return x.xxx_hidden_IncludeMask
	}
	return nil
}

func (x *GetImageRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetImageRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetImageRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *GetImageRequest) SetExcludeImports(v bool) {
	x.xxx_hidden_ExcludeImports = v
}

func (x *GetImageRequest) SetExcludeSourceInfo(v bool) {
	x.xxx_hidden_ExcludeSourceInfo = v
}

func (x *GetImageRequest) SetTypes(v []string) {
	x.xxx_hidden_Types = v
}

func (x *GetImageRequest) SetIncludeMask(v []ImageMask) {
	x.xxx_hidden_IncludeMask = v
}

type GetImageRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
	// Exclude files from imported buf modules in this image.
	ExcludeImports bool
	// Exclude source_code_info fields from each ImageFile.
	ExcludeSourceInfo bool
	// When specified the returned image will only contain the necessary files and
	// descriptors in those files to describe these types. Accepts messages, enums
	// and services. All types must be defined in the buf module, types in
	// dependencies are not accepted.
	//
	// At this time specifying `types` requires `exclude_source_info` to be set to
	// true.
	Types []string
	// When not empty, the returned image's files will only include
	// *DescriptorProto fields for the elements specified here. The masks are
	// applied without regard for dependencies between types. For example, if
	// `IMAGE_MASK_MESSAGES` is specified without `IMAGE_MASK_ENUMS` the resulting
	// image will NOT contain enum definitions even if they are referenced from
	// message fields.
	IncludeMask []ImageMask
}

func (b0 GetImageRequest_builder) Build() *GetImageRequest {
	m0 := &GetImageRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_ExcludeImports = b.ExcludeImports
	x.xxx_hidden_ExcludeSourceInfo = b.ExcludeSourceInfo
	x.xxx_hidden_Types = b.Types
	x.xxx_hidden_IncludeMask = b.IncludeMask
	return m0
}

type GetImageResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Image *v1.Image              `protobuf:"bytes,1,opt,name=image,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetImageResponse) Reset() {
	*x = GetImageResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_image_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageResponse) ProtoMessage() {}

func (x *GetImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_image_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetImageResponse) GetImage() *v1.Image {
	if x != nil {
		return x.xxx_hidden_Image
	}
	return nil
}

func (x *GetImageResponse) SetImage(v *v1.Image) {
	x.xxx_hidden_Image = v
}

func (x *GetImageResponse) HasImage() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Image != nil
}

func (x *GetImageResponse) ClearImage() {
	x.xxx_hidden_Image = nil
}

type GetImageResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Image *v1.Image
}

func (b0 GetImageResponse_builder) Build() *GetImageResponse {
	m0 := &GetImageResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Image = b.Image
	return m0
}

var File_buf_alpha_registry_v1alpha1_image_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_image_proto_rawDesc = "" +
	"\n" +
	"'buf/alpha/registry/v1alpha1/image.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1ebuf/alpha/image/v1/image.proto\"\x9f\x02\n" +
	"\x0fGetImageRequest\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x1e\n" +
	"\n" +
	"repository\x18\x02 \x01(\tR\n" +
	"repository\x12\x1c\n" +
	"\treference\x18\x03 \x01(\tR\treference\x12'\n" +
	"\x0fexclude_imports\x18\x04 \x01(\bR\x0eexcludeImports\x12.\n" +
	"\x13exclude_source_info\x18\x05 \x01(\bR\x11excludeSourceInfo\x12\x14\n" +
	"\x05types\x18\x06 \x03(\tR\x05types\x12I\n" +
	"\finclude_mask\x18\a \x03(\x0e2&.buf.alpha.registry.v1alpha1.ImageMaskR\vincludeMask\"C\n" +
	"\x10GetImageResponse\x12/\n" +
	"\x05image\x18\x01 \x01(\v2\x19.buf.alpha.image.v1.ImageR\x05image*o\n" +
	"\tImageMask\x12\x1a\n" +
	"\x16IMAGE_MASK_UNSPECIFIED\x10\x00\x12\x17\n" +
	"\x13IMAGE_MASK_MESSAGES\x10\x01\x12\x14\n" +
	"\x10IMAGE_MASK_ENUMS\x10\x02\x12\x17\n" +
	"\x13IMAGE_MASK_SERVICES\x10\x032|\n" +
	"\fImageService\x12l\n" +
	"\bGetImage\x12,.buf.alpha.registry.v1alpha1.GetImageRequest\x1a-.buf.alpha.registry.v1alpha1.GetImageResponse\"\x03\x90\x02\x01B\x97\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\n" +
	"ImageProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_image_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_image_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_alpha_registry_v1alpha1_image_proto_goTypes = []any{
	(ImageMask)(0),           // 0: buf.alpha.registry.v1alpha1.ImageMask
	(*GetImageRequest)(nil),  // 1: buf.alpha.registry.v1alpha1.GetImageRequest
	(*GetImageResponse)(nil), // 2: buf.alpha.registry.v1alpha1.GetImageResponse
	(*v1.Image)(nil),         // 3: buf.alpha.image.v1.Image
}
var file_buf_alpha_registry_v1alpha1_image_proto_depIdxs = []int32{
	0, // 0: buf.alpha.registry.v1alpha1.GetImageRequest.include_mask:type_name -> buf.alpha.registry.v1alpha1.ImageMask
	3, // 1: buf.alpha.registry.v1alpha1.GetImageResponse.image:type_name -> buf.alpha.image.v1.Image
	1, // 2: buf.alpha.registry.v1alpha1.ImageService.GetImage:input_type -> buf.alpha.registry.v1alpha1.GetImageRequest
	2, // 3: buf.alpha.registry.v1alpha1.ImageService.GetImage:output_type -> buf.alpha.registry.v1alpha1.GetImageResponse
	3, // [3:4] is the sub-list for method output_type
	2, // [2:3] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_image_proto_init() }
func file_buf_alpha_registry_v1alpha1_image_proto_init() {
	if File_buf_alpha_registry_v1alpha1_image_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_image_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_image_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_image_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_image_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_image_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_image_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_image_proto = out.File
	file_buf_alpha_registry_v1alpha1_image_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_image_proto_depIdxs = nil
}
