package cmd

import "github.com/chriswalz/complete/v3"

var b = &complete.CompTree{Desc: "", Sub: map[string]*complete.CompTree{"index-pack": {Desc: "", Sub: map[string]*complete.CompTree{},
	Flags: map[string]*complete.CompTree{
		"o":       {Desc: `write generated pack index into specified file`},
		"v":       {Desc: `display progress on stderr`},
		"stdin":   {Desc: `read pack from stdin and instead write to specified file`},
		"strict":  {Desc: `die if the pack contains broken objects or links`},
		"threads": {Desc: `specify number of threads to use`},
	},
},
	"pack-objects": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"all-progress":             {Desc: `show progress meter during object writing p`},
			"to":                       {Desc: `ncremental, but only ignore u`},
			"delta-islands":            {Desc: `respect islands during delta compression`},
			"include-tag":              {Desc: `include tag objects that refer to objects t`},
			"local":                    {Desc: `ncremental, but only ignore u`},
			"shallow":                  {Desc: `create packs suitable for shallow fetches`},
			"threads":                  {Desc: `specify number of threads for searching for`},
			"unpack-unreachable":       {Desc: `unpack unreachable objects newer than speci`},
			"reflog":                   {Desc: `include objects referred by reflog entries`},
			"all-progress-implied":     {Desc: `rogress`},
			"but":                      {Desc: `rogress`},
			"filter":                   {Desc: `omit certain objects from pack file`},
			"honor-pack-keep":          {Desc: `ignore objects in local pack with .keep fil`},
			"indexed-objects":          {Desc: `include objects referred to by the index`},
			"non-empty":                {Desc: `only create a package if it contains at lea`},
			"progress":                 {Desc: `show progress meter`},
			"sparse":                   {Desc: `use sparse reachability algorithm`},
			"all":                      {Desc: `include all refs as well as revisions alrea`},
			"only":                     {Desc: `rogress`},
			"depth":                    {Desc: `maximum delta depth`},
			"exclude-promisor-objects": {Desc: `don't pack objects in promisor packfiles`},
			"missing":                  {Desc: `specify how missing objects are handled`},
			"no-reuse-delta":           {Desc: `don't reuse existing deltas, but compute th`},
			"like":                     {Desc: `rogress`},
			"if":                       {Desc: `rogress`},
			"quiet":                    {Desc: `don't report progress`},
			"use-bitmap-index":         {Desc: `use a bitmap index if available to speed up`},
			"all-progress,":            {Desc: `rogress`},
			"keep-true-parents":        {Desc: `pack parents hidden by grafts`},
			"window":                   {Desc: `limit pack window by objects`},
			"write-bitmap-index":       {Desc: `write a bitmap index together with the pack`},
			"q":                        {Desc: `don't report progress`},
			"window-memory":            {Desc: `specify window size in memory`},
			"delta-base-offset":        {Desc: `use delta-base-offset packing`},
			"incremental":              {Desc: `ignore objects that have already been packe`},
			"keep-unreachable":         {Desc: `keep unreachable`},
			"similar":                  {Desc: `ncremental, but only ignore u`},
			"max-pack-size":            {Desc: `specify maximum size of each output pack fi`},
			"pack-loose-unreachable":   {Desc: `pack loose unreachable objects`},
			"compression":              {Desc: `specify compression level`},
			"keep-pack":                {Desc: `ignore named pack`},
			"no-reuse-object":          {Desc: `don't reuse existing object data`},
			"revs":                     {Desc: `read revision arguments from standard input`},
			"stdout":                   {Desc: `output pack to stdout`},
			"unpacked":                 {Desc: `limit objects to pack to those not already`},
		},
	},
	"range-diff": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"break-rewrites":           {Desc: `break complete rewrite changes into pai`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"raw":                      {Desc: `generate default raw diff output`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"follow":                   {Desc: `continue listing the history of a file`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk`},
			"output-indicator-context": {Desc: `specify the character to indicate a con`},
			"no-dual-color":            {Desc: `use simple diff colors`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"color-moved":              {Desc: `color moved lines differently`},
			"line-prefix":              {Desc: `prepend additional prefix to every line`},
			"B":                        {Desc: `break complete rewrite changes into pai`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"z":                        {Desc: `use NUL termination on output`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the inde`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular express`},
			"a":                        {Desc: `treat all files as text`},
			"to":                       {Desc: `ull-index, output bin`},
			"C":                        {Desc: `detect copies as well as renames with g`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"p":                        {Desc: `generate diff in patch format`},
			"G":                        {Desc: `look for differences whose added or rem`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 ot`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"s":                        {Desc: `suppress diff output`},
			"output":                   {Desc: `undocumented`},
			"in":                       {Desc: `ull-index, output bin`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"S":                        {Desc: `look for differences that add or remove`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all change`},
			"relative":                 {Desc: `exclude changes outside and output rela`},
			"word-diff":                {Desc: `show word diff`},
			"creation-factor":          {Desc: `specify weighting for creation`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"name-only":                {Desc: `show only names of changed files`},
			"find-object":              {Desc: `look for differences that change the nu`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace e`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored whe`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"name-status":              {Desc: `show only names and status of changed f`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-prefix":                {Desc: `do not show any source or destination p`},
			"patch":                    {Desc: `generate diff in patch format`},
			"find-copies":              {Desc: `detect copies as well as renames with g`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"full-index":               {Desc: `show full object name of pre- and post-`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"unified":                  {Desc: `generate diff with given lines of conte`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove bl`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be exe`},
			"no-renames":               {Desc: `turn off rename detection`},
			"no-textconv":              {Desc: `do not allow external text conversion f`},
			"addition":                 {Desc: `ull-index, output bin`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"submodule":                {Desc: `select output format for submodule diff`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"no-patch":                 {Desc: `suppress diff output`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"textconv":                 {Desc: `allow external text conversion filters`},
			"check":                    {Desc: `warn if changes introduce trailing whit`},
			"color-words":              {Desc: `show colored-word diff`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"M":                        {Desc: `detect renames with given scope`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing`},
			"U":                        {Desc: `generate diff with given lines of conte`},
			"minimal":                  {Desc: `spend extra time to make sure the small`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defaul`},
			"summary":                  {Desc: `generate condensed summary of extended`},
			"O":                        {Desc: `output patch in the order of glob-patte`},
			"R":                        {Desc: `do a reverse diff`},
			"for":                      {Desc: `irstat=cumulative`},
			"ext-diff":                 {Desc: `allow external diff helper to be execut`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old`},
			"u":                        {Desc: `generate diff in patch format`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph wi`},
			"text":                     {Desc: `treat all files as text`},
			"binary":                   {Desc: `ull-index, output bin`},
			"color":                    {Desc: `show colored diff`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"l":                        {Desc: `limit number of rename/copy targets to`},
		},
	},
	"repack": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"local":              {Desc: `ocal option to git pack-objects`},
			"l":                  {Desc: `ocal option to git pack-objects`},
			"unpack-unreachable": {Desc: `with -A, don't loosen objects older than specifie`},
			"f":                  {Desc: `o-reuse-delta option to git pack-objects`},
			"A":                  {Desc: `pack all objects into a single pack, but unreacha`},
			"F":                  {Desc: `o-reuse-object option to git pack-objects`},
			"a":                  {Desc: `pack all objects into a single pack`},
			"delta-islands":      {Desc: `elta-islands to git-pack-objects`},
			"threads":            {Desc: `limit maximum number of threads`},
			"window":             {Desc: `number of objects to consider when doing delta co`},
			"window-memory":      {Desc: `scale window size dynamically to not use more tha`},
			"q":                  {Desc: `pass -q option to git pack-objects`},
			"write-bitmap-index": {Desc: `write a bitmap index`},
			"b":                  {Desc: `write a bitmap index`},
			"pass":               {Desc: `o-reuse-delta option to git pack-objects`},
			"keep-unreachable":   {Desc: `with -a, repack unreachable objects`},
			"k":                  {Desc: `with -a, repack unreachable objects`},
			"pack-kept-objects":  {Desc: `repack objects in packs marked with .keep`},
			"quiet":              {Desc: `pass -q option to git pack-objects`},
			"d":                  {Desc: `remove redundant packs after packing`},
			"n":                  {Desc: `don't update server information`},
			"i":                  {Desc: `elta-islands to git-pack-objects`},
			"depth":              {Desc: `maximum delta depth`},
			"keep-pack":          {Desc: `ignore named pack`},
			"max-pack-size":      {Desc: `maximum size of each output packfile`},
		},
	},
	"bisect": {Desc: "", Sub: map[string]*complete.CompTree{"good": {Desc: "mark current or given revision as good", Sub: map[string]*complete.CompTree{}},
		"help":      {Desc: "display a short usage description", Sub: map[string]*complete.CompTree{}},
		"next":      {Desc: "find next bisection to test and check it out", Sub: map[string]*complete.CompTree{}},
		"replay":    {Desc: "replay a bisection log", Sub: map[string]*complete.CompTree{}},
		"reset":     {Desc: "finish bisection search and return to the given branch (or", Sub: map[string]*complete.CompTree{}},
		"terms":     {Desc: "show currently used good/bad terms", Sub: map[string]*complete.CompTree{}},
		"visualize": {Desc: "show the remaining revisions in gitk", Sub: map[string]*complete.CompTree{}},
		"bad":       {Desc: "mark current or given revision as bad", Sub: map[string]*complete.CompTree{}},
		"run":       {Desc: "run evaluation script", Sub: map[string]*complete.CompTree{}},
		"skip":      {Desc: "choose a nearby commit", Sub: map[string]*complete.CompTree{}},
		"start":     {Desc: "reset bisection state and start a new bisection", Sub: map[string]*complete.CompTree{}},
		"log":       {Desc: "show log of the current bisection", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"show-index": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"hash-object": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stdin":       {Desc: `read object from standard input`},
			"stdin-paths": {Desc: `read file names from standard input instead of from comman`},
			"t":           {Desc: `type of object to create`},
			"w":           {Desc: `write object to object database`},
			"literally":   {Desc: `just hash any random garbage to create corrupt objects for`},
			"no-filters":  {Desc: `hash contents as is, ignoring any input filters`},
			"path":        {Desc: `hash object as if it were located at given path`},
		},
	},
	"clean": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"interactive": {Desc: `show what would be done and clean files interactively`},
			"i":           {Desc: `show what would be done and clean files interactively`},
			"q":           {Desc: `don't print names of files removed`},
			"X":           {Desc: `remove only ignored files`},
			"x":           {Desc: `also remove ignored files`},
			"n":           {Desc: `only show what would and what would not be removed`},
			"force":       {Desc: `required when clean.requireForce is true (default)`},
			"f":           {Desc: `required when clean.requireForce is true (default)`},
			"quiet":       {Desc: `don't print names of files removed`},
			"d":           {Desc: `also remove untracked directories`},
			"dry-run":     {Desc: `only show what would and what would not be removed`},
			"exclude":     {Desc: `skip files matching specified pattern`},
			"e":           {Desc: `skip files matching specified pattern`},
		},
	},
	"ls-files": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stage":                 {Desc: `show stage files in output`},
			"with-tree":             {Desc: `treat paths removed since given tree-ish as st`},
			"f":                     {Desc: `indicate status of each file using lowercase f`},
			"z":                     {Desc: `use NUL termination on output`},
			"c":                     {Desc: `show cached files in output`},
			"x":                     {Desc: `skip files matching given pattern`},
			"exclude-from":          {Desc: `skip files matching patterns in given file`},
			"others":                {Desc: `show other files in output`},
			"d":                     {Desc: `show deleted files in output`},
			"ignored":               {Desc: `show ignored files in output`},
			"recurse-submodules":    {Desc: `recurse through submodules`},
			"u":                     {Desc: `show unmerged files in output`},
			"killed":                {Desc: `show killed files in output`},
			"directory":             {Desc: `if a whole directory is classified as "other",`},
			"error-unmatch":         {Desc: `if any file does not appear in index, treat th`},
			"X":                     {Desc: `skip files matching patterns in given file`},
			"i":                     {Desc: `show ignored files in output`},
			"exclude":               {Desc: `skip files matching given pattern`},
			"k":                     {Desc: `show killed files in output`},
			"m":                     {Desc: `show modified files in output`},
			"cached":                {Desc: `show cached files in output`},
			"exclude-per-directory": {Desc: `skip directories matching patterns in given fi`},
			"full-name":             {Desc: `force paths to be output relative to the proje`},
			"debug":                 {Desc: `show debugging data`},
			"s":                     {Desc: `show stage files in output`},
			"unmerged":              {Desc: `show unmerged files in output`},
			"v":                     {Desc: `indicate status of each file using lowercase f`},
			"modified":              {Desc: `show modified files in output`},
			"o":                     {Desc: `show other files in output`},
			"abbrev":                {Desc: `set minimum SHA1 display-length`},
			"deleted":               {Desc: `show deleted files in output`},
			"eol":                   {Desc: `show line endings of files`},
			"exclude-standard":      {Desc: `skip files in standard Git exclusion lists`},
		},
	},
	"mailsplit": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"d":       {Desc: `specify number of leading zeros`},
			"f":       {Desc: `skip the first N numbers`},
			"o":       {Desc: `directory in which to place individual messages`},
			"keep-cr": {Desc: `do not remove CR from lines ending with CR+LF`},
			"b":       {Desc: `if file does not begin with "From " line, assume it is a singl`},
		},
	},
	"mktag": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"rebase": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"keep-empty":                    {Desc: `keep empty commits in the result`},
			"autostash":                     {Desc: `stash uncommitted changes before rebas`},
			"gpg-sign":                      {Desc: `GPG-sign the commit`},
			"keep-base":                     {Desc: `use the merge-base of upstream and bra`},
			"f":                             {Desc: `force rebase even if current branch de`},
			"rerere-autoupdate":             {Desc: `update the index with reused conflict`},
			"no-gpg-sign":                   {Desc: `don't GPG-sign the commit`},
			"no-stat":                       {Desc: `don't show diffstat of what changed up`},
			"no-verify":                     {Desc: `bypass the pre-rebase hook`},
			"quiet":                         {Desc: `suppress all output`},
			"verbose":                       {Desc: `output additional information`},
			"merge-base":                    {Desc: `ork-point to refine`},
			"i":                             {Desc: `make a list of commits to be rebased a`},
			"k":                             {Desc: `keep empty commits in the result`},
			"q":                             {Desc: `suppress all output`},
			"root":                          {Desc: `rebase all reachable commits`},
			"show-current-patch":            {Desc: `show the patch file being applied or m`},
			"s":                             {Desc: `use given merge strategy`},
			"X":                             {Desc: `pass merge-strategy-specific option to`},
			"allow-empty-message":           {Desc: `allow rebasing commits with empty mess`},
			"m":                             {Desc: `use merging strategies to rebase`},
			"n":                             {Desc: `don't show diffstat of what changed up`},
			"fork-point":                    {Desc: `ork-point to refine`},
			"use":                           {Desc: `ork-point to refine`},
			"S":                             {Desc: `GPG-sign the commit`},
			"ignore-date":                   {Desc: `use current timestamp for author date`},
			"no-autostash":                  {Desc: `don't stash uncommitted changes before`},
			"abort":                         {Desc: `abort current rebase`},
			"continue":                      {Desc: `continue after resolving merge conflic`},
			"x":                             {Desc: `with -i: append "exec <cmd>" after eac`},
			"quit":                          {Desc: `abort but keep HEAD where it is`},
			"whitespace":                    {Desc: `detect a new or modified line that has`},
			"C":                             {Desc: `ensure that given lines of surrounding`},
			"strategy":                      {Desc: `use given merge strategy`},
			"v":                             {Desc: `output additional information`},
			"exec":                          {Desc: `with -i: append "exec <cmd>" after eac`},
			"interactive":                   {Desc: `make a list of commits to be rebased a`},
			"signoff":                       {Desc: `add Signed-off-by: line to the commit`},
			"strategy-option":               {Desc: `pass merge-strategy-specific option to`},
			"onto":                          {Desc: `start new branch with HEAD equal to gi`},
			"rebase-merges":                 {Desc: `try to rebase merges instead of skippi`},
			"r":                             {Desc: `try to rebase merges instead of skippi`},
			"ignore-whitespace":             {Desc: `ignore whitespace in context`},
			"merge":                         {Desc: `use merging strategies to rebase`},
			"no-ff":                         {Desc: `cherry-pick all rebased commits with -`},
			"reschedule-failed-exec":        {Desc: `automatically re-schedule any 'exec' t`},
			"skip":                          {Desc: `skip the current patch`},
			"committer-date-is-author-date": {Desc: `use author date as committer date`},
			"edit-todo":                     {Desc: `edit interactive instruction sheet in`},
			"force-rebase":                  {Desc: `force rebase even if current branch de`},
		},
	},
	"unpack-file": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"upload-pack": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"check-ref-format": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"allow-onelevel":    {Desc: `accept one-level refnames`},
			"branch":            {Desc: `expand previous branch syntax`},
			"no-allow-onelevel": {Desc: `do not accept one-level refnames`},
			"normalize":         {Desc: `normalize refname by removing leading slashes`},
			"refspec-pattern":   {Desc: `interpret <refname> as a reference name pattern for`},
			"h":                 {Desc: `display usage information`},
		},
	},
	"di": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"no-textconv":              {Desc: `do not allow external text conversion`},
			"quiet":                    {Desc: `disable all output`},
			"find-object":              {Desc: `look for differences that change the`},
			"U":                        {Desc: `generate diff with given lines of con`},
			"M":                        {Desc: `detect renames with given scope`},
			"cc":                       {Desc: `combined diff format for merge commit`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"check":                    {Desc: `warn if changes introduce trailing wh`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performi`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"3":                        {Desc: `diff against "their branch" version`},
			"ext-diff":                 {Desc: `allow external diff helper to be exec`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be e`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"output-indicator-context": {Desc: `specify the character to indicate a c`},
			"for":                      {Desc: `irstat=cumulative`},
			"w":                        {Desc: `ignore white space when comparing lin`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hu`},
			"no-index":                 {Desc: `show diff between two paths on the fi`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all chan`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lin`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove`},
			"color-moved":              {Desc: `color moved lines differently`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored w`},
			"cached":                   {Desc: `show diff between index and named com`},
			"binary":                   {Desc: `ull-index, output b`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the in`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"output":                   {Desc: `undocumented`},
			"text":                     {Desc: `treat all files as text`},
			"anchored":                 {Desc: `generate diffs using the "anchored di`},
			"to":                       {Desc: `ull-index, output b`},
			"color":                    {Desc: `show colored diff`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"minimal":                  {Desc: `spend extra time to make sure the sma`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"unified":                  {Desc: `generate diff with given lines of con`},
			"l":                        {Desc: `limit number of rename/copy targets t`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0`},
			"full-index":               {Desc: `show full object name of pre- and pos`},
			"no-patch":                 {Desc: `suppress diff output`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white spa`},
			"word-diff":                {Desc: `show word diff`},
			"G":                        {Desc: `look for differences whose added or r`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffst`},
			"1":                        {Desc: `diff against "base" version`},
			"0":                        {Desc: `omit diff output for unmerged entries`},
			"relative":                 {Desc: `exclude changes outside and output re`},
			"B":                        {Desc: `break complete rewrite changes into p`},
			"follow":                   {Desc: `continue listing the history of a fil`},
			"s":                        {Desc: `suppress diff output`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expre`},
			"p":                        {Desc: `generate diff in patch format`},
			"base":                     {Desc: `diff against "base" version`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-prefix":                {Desc: `do not show any source or destination`},
			"output-indicator-old":     {Desc: `specify the character to indicate a o`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"ours":                     {Desc: `diff against "our branch" version`},
			"numstat":                  {Desc: `generate more machine-friendly diffst`},
			"a":                        {Desc: `treat all files as text`},
			"in":                       {Desc: `ull-index, output b`},
			"break-rewrites":           {Desc: `break complete rewrite changes into p`},
			"c":                        {Desc: `combined diff format for merge commit`},
			"C":                        {Desc: `detect copies as well as renames with`},
			"raw":                      {Desc: `generate default raw diff output`},
			"name-only":                {Desc: `show only names of changed files`},
			"theirs":                   {Desc: `diff against "their branch" version`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"no-renames":               {Desc: `turn off rename detection`},
			"patience":                 {Desc: `generate diffs with patience algorith`},
			"find-copies":              {Desc: `detect copies as well as renames with`},
			"u":                        {Desc: `generate diff in patch format`},
			"S":                        {Desc: `look for differences that add or remo`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defa`},
			"submodule":                {Desc: `select output format for submodule di`},
			"O":                        {Desc: `output patch in the order of glob-pat`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end o`},
			"2":                        {Desc: `diff against "our branch" version`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace`},
			"diff-filter":              {Desc: `select certain kinds of files for dif`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"line-prefix":              {Desc: `prepend additional prefix to every li`},
			"z":                        {Desc: `use NUL termination on output`},
			"color-words":              {Desc: `show colored-word diff`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"R":                        {Desc: `do a reverse diff`},
			"summary":                  {Desc: `generate condensed summary of extende`},
			"textconv":                 {Desc: `allow external text conversion filter`},
			"addition":                 {Desc: `ull-index, output b`},
			"b":                        {Desc: `ignore changes in amount of white spa`},
			"name-status":              {Desc: `show only names and status of changed`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"staged":                   {Desc: `show diff between index and named com`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph`},
			"histogram":                {Desc: `generate diffs with histogram algorit`},
			"output-indicator-new":     {Desc: `specify the character to indicate a n`},
		},
	},
	"gc": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"no-prune":          {Desc: `do not prune any loose objects`},
			"prune":             {Desc: `prune loose objects older than given date`},
			"quiet":             {Desc: `suppress progress reporting`},
			"q":                 {Desc: `suppress progress reporting`},
			"aggressive":        {Desc: `more aggressively optimize`},
			"auto":              {Desc: `check whether housekeeping is required`},
			"keep-largest-pack": {Desc: `repack all other packs except the largest pack`},
		},
	},
	"write-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"missing-ok": {Desc: `ignore objects in index that are missing in object database`},
			"prefix":     {Desc: `write tree representing given sub-directory`},
		},
	},
	"check-attr": {Desc: "", Sub: map[string]*complete.CompTree{"crlf": {Desc: "line-ending convention", Sub: map[string]*complete.CompTree{}},
		"diff":   {Desc: "textual diff", Sub: map[string]*complete.CompTree{}},
		"filter": {Desc: "filters", Sub: map[string]*complete.CompTree{}},
		"ident":  {Desc: "ident substitution", Sub: map[string]*complete.CompTree{}},
		"merge":  {Desc: "merging strategy", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"stdin":  {Desc: `read file names from stdin instead of from command line`},
			"z":      {Desc: `terminate input and output records by a NUL character`},
			"all":    {Desc: `list all attributes that are associated with the specified pa`},
			"a":      {Desc: `list all attributes that are associated with the specified pa`},
			"cached": {Desc: `consider .gitattributes in the index only, ignoring the worki`},
		},
	},
	"fsck": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"root":              {Desc: `show root nodes`},
			"strict":            {Desc: `do strict checking`},
			"dangling":          {Desc: `print dangling objects (default)`},
			"name-objects":      {Desc: `show verbose names for reachable objects`},
			"no-dangling":       {Desc: `do not print dangling objects`},
			"unreachable":       {Desc: `show objects that are unreferenced in the object d`},
			"full":              {Desc: `check all object directories`},
			"progress":          {Desc: `show progress`},
			"tags":              {Desc: `show tags`},
			"cache":             {Desc: `consider objects recorded in the index as head nod`},
			"connectivity-only": {Desc: `check only connectivity`},
			"lost-found":        {Desc: `write dangling objects into .git/lost-found`},
			"no-reflogs":        {Desc: `do not consider commits referenced only by reflog`},
			"verbose":           {Desc: `output additional information`},
			"v":                 {Desc: `output additional information`},
		},
	},
	"llog": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"max-count":                {Desc: `maximum number of commits to display`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"parents":                  {Desc: `display parents of commit`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"output":                   {Desc: `undocumented`},
			"P":                        {Desc: `use perl regular expression`},
			"date-order":               {Desc: `display commits in date order`},
			"early-output":             {Desc: `undocumented`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"no-decorate":              {Desc: `do not print out ref names of any commits tha`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"count":                    {Desc: `display how many commits would have been list`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"patch":                    {Desc: `generate diff in patch format`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"all":                      {Desc: `rep, -`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"p":                        {Desc: `generate diff in patch format`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"bisect":                   {Desc: `ot refs/bise`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"since":                    {Desc: `show commits more recent than given date`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"M":                        {Desc: `detect renames with given scope`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"version":                  {Desc: `ull-history`},
			"before":                   {Desc: `show commits older than given date`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"no-patch":                 {Desc: `suppress diff output`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"decorate":                 {Desc: `print out ref names of any commits that are s`},
			"default":                  {Desc: `use argument as default revision`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"topo-order":               {Desc: `display commits in topological order`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"oneline":                  {Desc: `bbrev-commi`},
			"raw":                      {Desc: `generate default raw diff output`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"R":                        {Desc: `do a reverse diff`},
			"color":                    {Desc: `show colored diff`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"full-history":             {Desc: `do not prune history`},
			"u":                        {Desc: `generate diff in patch format`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"author":                   {Desc: `limit commits to those by given author`},
			"as":                       {Desc: `ot refs/bise`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"a":                        {Desc: `treat all files as text`},
			"all-match":                {Desc: `rep, -`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"no-max-parents":           {Desc: `reset limit`},
			"no-min-parents":           {Desc: `reset limit`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"invert-grep":              {Desc: `rep, -`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"simplify-merges":          {Desc: `ull-history`},
			"word-diff":                {Desc: `show word diff`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"z":                        {Desc: `use NUL termination on output`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"format":                   {Desc: `pretty print commit messages`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"no-renames":               {Desc: `turn off rename detection`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"i":                        {Desc: `match regexps ignoring case`},
			"in":                       {Desc: `ull-index, output binary di`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"color-moved":              {Desc: `color moved lines differently`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"if":                       {Desc: `ot refs/bise`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"color-words":              {Desc: `show colored-word diff`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"shorthand":                {Desc: `bbrev-commi`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"those":                    {Desc: `rep, -`},
			"cherry":                   {Desc: `o-m`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"text":                     {Desc: `treat all files as text`},
			"for":                      {Desc: `bbrev-commi`},
			"children":                 {Desc: `display children of commit`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"of":                       {Desc: `ull-history`},
			"after":                    {Desc: `show commits more recent than given date`},
			"matching":                 {Desc: `rep, -`},
			"pretend":                  {Desc: `ot refs/bise`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"milder":                   {Desc: `ull-history`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"limit":                    {Desc: `rep, -`},
			"commits":                  {Desc: `rep, -`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"s":                        {Desc: `suppress diff output`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"until":                    {Desc: `show commits older than given date`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"no-follow":                {Desc: `do not follow renames`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"h":                        {Desc: `display help`},
			"to":                       {Desc: `rep, -`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"merges":                   {Desc: `display only merge commits`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"name-only":                {Desc: `show only names of changed files`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"n":                        {Desc: `maximum number of commits to display`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"pretty":                   {Desc: `pretty print commit messages`},
		},
	},
	"mailinfo": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"m":                 {Desc: `copy the Message-ID header at the end of the commi`},
			"no-inbody-headers": {Desc: `undocumented`},
			"u":                 {Desc: `encode commit information in UTF-8`},
			"encoding":          {Desc: `encode commit information in given encoding`},
			"message-id":        {Desc: `copy the Message-ID header at the end of the commi`},
			"no-scissors":       {Desc: `do not remove everything in body before a scissors`},
			"scissors":          {Desc: `remove everything in body before a scissors line`},
			"b":                 {Desc: `limit stripping of bracketed strings to the word P`},
			"k":                 {Desc: `prevent removal of cruft from Subject: header`},
			"n":                 {Desc: `disable all charset re-coding of metadata`},
		},
	},
	"merge-index": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"o": {Desc: `skip failed merges`},
			"q": {Desc: `do not complain about failed merges`},
		},
	},
	"rum": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"autostash":                     {Desc: `stash uncommitted changes before rebas`},
			"gpg-sign":                      {Desc: `GPG-sign the commit`},
			"keep-base":                     {Desc: `use the merge-base of upstream and bra`},
			"X":                             {Desc: `pass merge-strategy-specific option to`},
			"s":                             {Desc: `use given merge strategy`},
			"committer-date-is-author-date": {Desc: `use author date as committer date`},
			"k":                             {Desc: `keep empty commits in the result`},
			"no-ff":                         {Desc: `cherry-pick all rebased commits with -`},
			"no-verify":                     {Desc: `bypass the pre-rebase hook`},
			"onto":                          {Desc: `start new branch with HEAD equal to gi`},
			"strategy":                      {Desc: `use given merge strategy`},
			"fork-point":                    {Desc: `ork-point to refine`},
			"q":                             {Desc: `suppress all output`},
			"r":                             {Desc: `try to rebase merges instead of skippi`},
			"verbose":                       {Desc: `output additional information`},
			"allow-empty-message":           {Desc: `allow rebasing commits with empty mess`},
			"exec":                          {Desc: `with -i: append "exec <cmd>" after eac`},
			"x":                             {Desc: `with -i: append "exec <cmd>" after eac`},
			"merge-base":                    {Desc: `ork-point to refine`},
			"interactive":                   {Desc: `make a list of commits to be rebased a`},
			"root":                          {Desc: `rebase all reachable commits`},
			"ignore-whitespace":             {Desc: `ignore whitespace in context`},
			"m":                             {Desc: `use merging strategies to rebase`},
			"no-stat":                       {Desc: `don't show diffstat of what changed up`},
			"strategy-option":               {Desc: `pass merge-strategy-specific option to`},
			"whitespace":                    {Desc: `detect a new or modified line that has`},
			"C":                             {Desc: `ensure that given lines of surrounding`},
			"i":                             {Desc: `make a list of commits to be rebased a`},
			"keep-empty":                    {Desc: `keep empty commits in the result`},
			"no-autostash":                  {Desc: `don't stash uncommitted changes before`},
			"rebase-merges":                 {Desc: `try to rebase merges instead of skippi`},
			"rerere-autoupdate":             {Desc: `update the index with reused conflict`},
			"reschedule-failed-exec":        {Desc: `automatically re-schedule any 'exec' t`},
			"f":                             {Desc: `force rebase even if current branch de`},
			"use":                           {Desc: `ork-point to refine`},
			"S":                             {Desc: `GPG-sign the commit`},
			"merge":                         {Desc: `use merging strategies to rebase`},
			"no-gpg-sign":                   {Desc: `don't GPG-sign the commit`},
			"signoff":                       {Desc: `add Signed-off-by: line to the commit`},
			"force-rebase":                  {Desc: `force rebase even if current branch de`},
			"ignore-date":                   {Desc: `use current timestamp for author date`},
			"n":                             {Desc: `don't show diffstat of what changed up`},
			"quiet":                         {Desc: `suppress all output`},
			"v":                             {Desc: `output additional information`},
		},
	},
	"var": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"GIT_COMMITTER_IDENT": {Desc: `name and email of committer`},
			"GIT_EDITOR":          {Desc: `text editor used by git commands`},
			"GIT_PAGER":           {Desc: `text viewer used by git commands`},
			"GIT_AUTHOR_IDENT":    {Desc: `name and email of author`},
		},
	},
	"verify-pack": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stat-only": {Desc: `do not verify pack contents; only display histogram of del`},
			"s":         {Desc: `do not verify pack contents; only display histogram of del`},
			"verbose":   {Desc: `show objects contained in pack`},
			"v":         {Desc: `show objects contained in pack`},
		},
	},
	"clone": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"bare":               {Desc: `make a bare GIT repository`},
			"branch":             {Desc: `point HEAD to the given branch`},
			"override":           {Desc: `ocal, as if file:/// URL was`},
			"o":                  {Desc: `use given remote name instead of "origin`},
			"single-branch":      {Desc: `clone only history leading up to the mai`},
			"config":             {Desc: `<key>=<value> set a configuration variab`},
			"dissociate":         {Desc: `make the newly-created repository indepe`},
			"no-local":           {Desc: `ocal, as if file:/// URL was`},
			"origin":             {Desc: `use given remote name instead of "origin`},
			"quiet":              {Desc: `operate quietly`},
			"reference":          {Desc: `reference repository`},
			"shared":             {Desc: `share the objects with the source reposi`},
			"c":                  {Desc: `<key>=<value> set a configuration variab`},
			"q":                  {Desc: `operate quietly`},
			"reference-if-able":  {Desc: `reference repository`},
			"b":                  {Desc: `point HEAD to the given branch`},
			"filter":             {Desc: `object filtering`},
			"local":              {Desc: `clone locally, hardlink refs and objects`},
			"l":                  {Desc: `clone locally, hardlink refs and objects`},
			"mirror":             {Desc: `clone refs into refs/* instead of refs/r`},
			"no-checkout":        {Desc: `do not checkout HEAD after clone is comp`},
			"recurse-submodules": {Desc: `initialize submodules in the clone`},
			"shallow-since":      {Desc: `shallow clone since a specific time`},
			"upload-pack":        {Desc: `specify path to git-upload-pack on remot`},
			"ipv4":               {Desc: `use IPv4 addresses only`},
			"6":                  {Desc: `use IPv6 addresses only`},
			"j":                  {Desc: `specify number of submodules cloned in p`},
			"no-tags":            {Desc: `don't clone any tags and make later fetc`},
			"u":                  {Desc: `specify path to git-upload-pack on remot`},
			"verbose":            {Desc: `always display the progressbar`},
			"template":           {Desc: `directory to use as a template for the o`},
			"no-hardlinks":       {Desc: `copy files instead of hardlinking when d`},
			"no-single-branch":   {Desc: `clone history leading up to each branch`},
			"progress":           {Desc: `output progress even if stderr is not a`},
			"remote-submodules":  {Desc: `any cloned submodules will use their rem`},
			"separate-git-dir":   {Desc: `place .git dir outside worktree`},
			"shallow-exclude":    {Desc: `shallow clone excluding commits reachabl`},
			"s":                  {Desc: `share the objects with the source reposi`},
			"v":                  {Desc: `always display the progressbar`},
			"4":                  {Desc: `use IPv4 addresses only`},
			"n":                  {Desc: `do not checkout HEAD after clone is comp`},
			"server-option":      {Desc: `send specified string to the server when`},
			"depth":              {Desc: `create a shallow clone, given number of`},
			"ipv6":               {Desc: `use IPv6 addresses only`},
			"jobs":               {Desc: `specify number of submodules cloned in p`},
			"recursive":          {Desc: `initialize all contained submodules`},
			"shallow-submodules": {Desc: `any cloned submodules will be shallow`},
		},
	},
	"ci": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"branch":              {Desc: `show branch information`},
			"patch":               {Desc: `use the interactive patch selection interfa`},
			"a":                   {Desc: `stage all modified and deleted paths`},
			"m":                   {Desc: `use the given message as the commit message`},
			"no-gpg-sign":         {Desc: `don't GPG-sign the commit`},
			"porcelain":           {Desc: `dry run with machine-readable output format`},
			"reuse-message":       {Desc: `use existing commit object with same log me`},
			"s":                   {Desc: `add Signed-off-by line at the end of the co`},
			"F":                   {Desc: `read commit message from given file`},
			"z":                   {Desc: `dry run with NULL-separated output format`},
			"all":                 {Desc: `stage all modified and deleted paths`},
			"template":            {Desc: `use file as a template commit message`},
			"include":             {Desc: `update the given files and commit the whole`},
			"n":                   {Desc: `bypass pre-commit and commit-msg hooks`},
			"dry-run":             {Desc: `only show list of paths that are to be comm`},
			"only":                {Desc: `commit only the given files`},
			"p":                   {Desc: `use the interactive patch selection interfa`},
			"no-verify":           {Desc: `bypass pre-commit and commit-msg hooks`},
			"null":                {Desc: `dry run with NULL-separated output format`},
			"q":                   {Desc: `suppress commit summary message`},
			"signoff":             {Desc: `add Signed-off-by line at the end of the co`},
			"untracked-files":     {Desc: `show files in untracked directories`},
			"allow-empty-message": {Desc: `allow recording a commit with an empty mess`},
			"interactive":         {Desc: `interactively update paths in the index fil`},
			"message":             {Desc: `use the given message as the commit message`},
			"t":                   {Desc: `use file as a template commit message`},
			"cleanup":             {Desc: `specify how the commit message should be cl`},
			"c":                   {Desc: `use existing commit object and edit log mes`},
			"no-ahead-behind":     {Desc: `don't display detailed ahead/behind counts`},
			"no-edit":             {Desc: `do not edit the commit message before commi`},
			"quiet":               {Desc: `suppress commit summary message`},
			"reedit-message":      {Desc: `use existing commit object and edit log mes`},
			"fixup":               {Desc: `construct a commit message for use with reb`},
			"u":                   {Desc: `show files in untracked directories`},
			"verbose":             {Desc: `show unified diff of all file changes`},
			"v":                   {Desc: `show unified diff of all file changes`},
			"allow-empty":         {Desc: `allow recording an empty commit`},
			"amend":               {Desc: `amend the tip of the current branch`},
			"date":                {Desc: `override the author date used in the commit`},
			"e":                   {Desc: `edit the commit message before committing`},
			"o":                   {Desc: `commit only the given files`},
			"C":                   {Desc: `use existing commit object with same log me`},
			"short":               {Desc: `dry run with short output format`},
			"gpg-sign":            {Desc: `GPG-sign the commit`},
			"no-post-rewrite":     {Desc: `bypass the post-rewrite hook`},
			"no-status":           {Desc: `do not include the output of git status in`},
			"edit":                {Desc: `edit the commit message before committing`},
			"i":                   {Desc: `update the given files and commit the whole`},
			"status":              {Desc: `include the output of git status in the com`},
			"file":                {Desc: `read commit message from given file`},
			"S":                   {Desc: `GPG-sign the commit`},
			"squash":              {Desc: `construct a commit message for use with reb`},
			"author":              {Desc: `override the author name used in the commit`},
		},
	},
	"gui": {Desc: "", Sub: map[string]*complete.CompTree{"blame": {Desc: "start a blame viewer", Sub: map[string]*complete.CompTree{}},
		"browser": {Desc: "start a tree browser", Sub: map[string]*complete.CompTree{}},
		"citool":  {Desc: "arrange to make one commit", Sub: map[string]*complete.CompTree{}},
		"version": {Desc: "display version information", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"merge-one-file": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"bundle": {Desc: "", Sub: map[string]*complete.CompTree{"create": {Desc: "create a bundle", Sub: map[string]*complete.CompTree{}},
		"list-heads": {Desc: "list references defined in bundle", Sub: map[string]*complete.CompTree{}},
		"unbundle":   {Desc: "unbundle a bundle to repository", Sub: map[string]*complete.CompTree{}},
		"verify":     {Desc: "check that a bundle is valid and will apply cleanly", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"for-each-ref": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"format":      {Desc: `output format of ref information`},
			"merged":      {Desc: `print only refs that are merged`},
			"no-contains": {Desc: `print only refs that don't contain specified commit`},
			"points-at":   {Desc: `print only refs which point at the given object`},
			"sort":        {Desc: `key to sort refs by`},
			"contains":    {Desc: `print only refs that contain specified commit`},
			"count":       {Desc: `maximum number of refs to iterate over`},
			"no-merged":   {Desc: `print only refs that are not merged`},
			"perl":        {Desc: `use string literals suitable for Perl`},
			"p":           {Desc: `use string literals suitable for Perl`},
			"s":           {Desc: `use string literals suitable for sh`},
			"color":       {Desc: `respect any colors specified in the format`},
			"ignore-case": {Desc: `sorting and filtering are case-insensitive`},
			"tcl":         {Desc: `use string literals suitable for Tcl`},
			"python":      {Desc: `use string literals suitable for Python`},
			"shell":       {Desc: `use string literals suitable for sh`},
		},
	},
	"lol": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"simplify-merges":          {Desc: `ull-history`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"name-only":                {Desc: `show only names of changed files`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"patch":                    {Desc: `generate diff in patch format`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"a":                        {Desc: `treat all files as text`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"parents":                  {Desc: `display parents of commit`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"no-follow":                {Desc: `do not follow renames`},
			"all":                      {Desc: `rep, -`},
			"matching":                 {Desc: `rep, -`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"z":                        {Desc: `use NUL termination on output`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"version":                  {Desc: `ull-history`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"cherry":                   {Desc: `o-m`},
			"format":                   {Desc: `pretty print commit messages`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"milder":                   {Desc: `ull-history`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"R":                        {Desc: `do a reverse diff`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"no-max-parents":           {Desc: `reset limit`},
			"of":                       {Desc: `ull-history`},
			"until":                    {Desc: `show commits older than given date`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"u":                        {Desc: `generate diff in patch format`},
			"color":                    {Desc: `show colored diff`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"default":                  {Desc: `use argument as default revision`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"P":                        {Desc: `use perl regular expression`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"in":                       {Desc: `ull-index, output binary di`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"children":                 {Desc: `display children of commit`},
			"color-words":              {Desc: `show colored-word diff`},
			"since":                    {Desc: `show commits more recent than given date`},
			"p":                        {Desc: `generate diff in patch format`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"h":                        {Desc: `display help`},
			"bisect":                   {Desc: `ot refs/bise`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"date-order":               {Desc: `display commits in date order`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"before":                   {Desc: `show commits older than given date`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"pretend":                  {Desc: `ot refs/bise`},
			"if":                       {Desc: `ot refs/bise`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"commits":                  {Desc: `rep, -`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"invert-grep":              {Desc: `rep, -`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"count":                    {Desc: `display how many commits would have been list`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"topo-order":               {Desc: `display commits in topological order`},
			"n":                        {Desc: `maximum number of commits to display`},
			"to":                       {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"early-output":             {Desc: `undocumented`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"merges":                   {Desc: `display only merge commits`},
			"output":                   {Desc: `undocumented`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"i":                        {Desc: `match regexps ignoring case`},
			"all-match":                {Desc: `rep, -`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"no-renames":               {Desc: `turn off rename detection`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"limit":                    {Desc: `rep, -`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"after":                    {Desc: `show commits more recent than given date`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"full-history":             {Desc: `do not prune history`},
			"M":                        {Desc: `detect renames with given scope`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"date":                     {Desc: `format of date output`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"raw":                      {Desc: `generate default raw diff output`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"word-diff":                {Desc: `show word diff`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-patch":                 {Desc: `suppress diff output`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"for":                      {Desc: `irstat=cumulative`},
			"color-moved":              {Desc: `color moved lines differently`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"s":                        {Desc: `suppress diff output`},
			"as":                       {Desc: `ot refs/bise`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-min-parents":           {Desc: `reset limit`},
			"text":                     {Desc: `treat all files as text`},
			"those":                    {Desc: `rep, -`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"submodule":                {Desc: `select output format for submodule difference`},
		},
	},
	"notes": {Desc: "", Sub: map[string]*complete.CompTree{"prune": {Desc: "remove all notes for non-existing/unreachable objects", Sub: map[string]*complete.CompTree{}},
		"add":     {Desc: "add notes for a given object", Sub: map[string]*complete.CompTree{}},
		"append":  {Desc: "append notes to a given object", Sub: map[string]*complete.CompTree{}},
		"get-ref": {Desc: "print the current notes ref", Sub: map[string]*complete.CompTree{}},
		"list":    {Desc: "list notes object for given object", Sub: map[string]*complete.CompTree{}},
		"merge":   {Desc: "merge the given notes ref into the current ref", Sub: map[string]*complete.CompTree{}},
		"remove":  {Desc: "remove notes for a given object", Sub: map[string]*complete.CompTree{}},
		"show":    {Desc: "show notes for a given object", Sub: map[string]*complete.CompTree{}},
		"copy":    {Desc: "copy notes from one object to another", Sub: map[string]*complete.CompTree{}},
		"edit":    {Desc: "edit notes for a given object", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"rev-parse": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"sq":                  {Desc: `output single shell-quoted line`},
			"symbolic":            {Desc: `output in a format as true to input as poss`},
			"tags":                {Desc: `show tag refs found in refs/tags/`},
			"after":               {Desc: `ax-age= parameter corresponding giv`},
			"q":                   {Desc: `suppress all output`},
			"as":                  {Desc: `ymbolic, but omit non-ref inputs`},
			"is-inside-git-dir":   {Desc: `show whether or not current working directo`},
			"short":               {Desc: `show only shorter unique name`},
			"no-flags":            {Desc: `do not output flag parameters`},
			"show-toplevel":       {Desc: `show absolute path of top-level directory`},
			"until":               {Desc: `in-age= parameter corresponding giv`},
			"branches":            {Desc: `show branch refs found in refs/heads/`},
			"default":             {Desc: `use given argument if there is no parameter`},
			"is-bare-repository":  {Desc: `show whether or not repository is bare`},
			"is-inside-work-tree": {Desc: `show whether or not current working directo`},
			"remotes":             {Desc: `show tag refs found in refs/remotes/`},
			"abbrev-ref":          {Desc: `a non-ambiguous short name of object`},
			"since":               {Desc: `ax-age= parameter corresponding giv`},
			"sq-quote":            {Desc: `use git rev-parse in shell quoting mode`},
			"not":                 {Desc: `toggle ^ prefix of object names`},
			"resolve-git-dir":     {Desc: `check if <path> is a valid repository or gi`},
			"revs-only":           {Desc: `do not output flags and parameters not mean`},
			"show-prefix":         {Desc: `show path of current directory relative to`},
			"verify":              {Desc: `verify parameter to be usable`},
			"show":                {Desc: `in-age= parameter corresponding giv`},
			"glob":                {Desc: `show all matching refs`},
			"no-revs":             {Desc: `do not output flags and parameters meant fo`},
			"symbolic-full-name":  {Desc: `ymbolic, but omit non-ref inputs`},
			"all":                 {Desc: `show all refs found in refs/`},
			"disambiguate":        {Desc: `show every object whose name begins with th`},
			"git-dir":             {Desc: `show $GIT_DIR if defined else show path to`},
			"quiet":               {Desc: `suppress all output`},
			"show-cdup":           {Desc: `show path of top-level directory relative t`},
			"h":                   {Desc: `display usage`},
			"before":              {Desc: `in-age= parameter corresponding giv`},
			"flags":               {Desc: `do not output non-flag parameters`},
			"same":                {Desc: `ymbolic, but omit non-ref inputs`},
			"local-env-vars":      {Desc: `list git environment variables local to rep`},
			"parseopt":            {Desc: `use git rev-parse in option parsing mode`},
		},
	},
	"send-emaily": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"mirror":           {Desc: `mirror all refs`},
			"no-signed":        {Desc: `don't GPG sign the push`},
			"quiet":            {Desc: `be more quiet`},
			"q":                {Desc: `be more quiet`},
			"receive-pack":     {Desc: `specify path to git-receive-pack on remote side`},
			"thin":             {Desc: `send a thin pack`},
			"dry-run":          {Desc: `do everything except actually sending the updat`},
			"force-with-lease": {Desc: `require old value of ref to be at specified val`},
			"progress":         {Desc: `force progress reporting`},
			"exec":             {Desc: `specify path to git-receive-pack on remote side`},
			"stateless-rpc":    {Desc: `use stateless RPC protocol`},
			"force":            {Desc: `update remote orphaned refs`},
			"f":                {Desc: `update remote orphaned refs`},
			"verbose":          {Desc: `produce verbose output`},
			"helper-status":    {Desc: `print status from remote helper`},
			"push-option":      {Desc: `specify option to transmit`},
			"n":                {Desc: `do everything except actually sending the updat`},
			"remote":           {Desc: `specify remote name`},
			"signed":           {Desc: `GPG sign the push`},
			"sign":             {Desc: `GPG sign the push`},
			"stdin":            {Desc: `read refs from stdin`},
			"v":                {Desc: `produce verbose output`},
			"all":              {Desc: `update all refs that exist locally`},
			"atomic":           {Desc: `request atomic transaction on remote side`},
		},
	},
	"squash": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"blog": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"version":                  {Desc: `ull-history`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"no-min-parents":           {Desc: `reset limit`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"before":                   {Desc: `show commits older than given date`},
			"cherry":                   {Desc: `o-m`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"P":                        {Desc: `use perl regular expression`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"of":                       {Desc: `ull-history`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"no-decorate":              {Desc: `do not print out ref names of any commits tha`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"author":                   {Desc: `limit commits to those by given author`},
			"children":                 {Desc: `display children of commit`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"s":                        {Desc: `suppress diff output`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"all":                      {Desc: `rep, -`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"date-order":               {Desc: `display commits in date order`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"R":                        {Desc: `do a reverse diff`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"parents":                  {Desc: `display parents of commit`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"M":                        {Desc: `detect renames with given scope`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"p":                        {Desc: `generate diff in patch format`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"until":                    {Desc: `show commits older than given date`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"raw":                      {Desc: `generate default raw diff output`},
			"text":                     {Desc: `treat all files as text`},
			"a":                        {Desc: `treat all files as text`},
			"as":                       {Desc: `ot refs/bise`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"oneline":                  {Desc: `bbrev-commi`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"merges":                   {Desc: `display only merge commits`},
			"all-match":                {Desc: `rep, -`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"in":                       {Desc: `ull-index, output binary di`},
			"decorate":                 {Desc: `print out ref names of any commits that are s`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"patch":                    {Desc: `generate diff in patch format`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"limit":                    {Desc: `rep, -`},
			"commits":                  {Desc: `rep, -`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"simplify-merges":          {Desc: `ull-history`},
			"color":                    {Desc: `show colored diff`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"no-renames":               {Desc: `turn off rename detection`},
			"if":                       {Desc: `ot refs/bise`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"shorthand":                {Desc: `bbrev-commi`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"after":                    {Desc: `show commits more recent than given date`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"since":                    {Desc: `show commits more recent than given date`},
			"u":                        {Desc: `generate diff in patch format`},
			"those":                    {Desc: `rep, -`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"word-diff":                {Desc: `show word diff`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"milder":                   {Desc: `ull-history`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"no-max-parents":           {Desc: `reset limit`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"matching":                 {Desc: `rep, -`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"h":                        {Desc: `display help`},
			"name-only":                {Desc: `show only names of changed files`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"count":                    {Desc: `display how many commits would have been list`},
			"format":                   {Desc: `pretty print commit messages`},
			"full-history":             {Desc: `do not prune history`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"no-follow":                {Desc: `do not follow renames`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"no-patch":                 {Desc: `suppress diff output`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"pretend":                  {Desc: `ot refs/bise`},
			"invert-grep":              {Desc: `rep, -`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"topo-order":               {Desc: `display commits in topological order`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"early-output":             {Desc: `undocumented`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"i":                        {Desc: `match regexps ignoring case`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"color-moved":              {Desc: `color moved lines differently`},
			"date":                     {Desc: `format of date output`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"to":                       {Desc: `rep, -`},
			"bisect":                   {Desc: `ot refs/bise`},
			"for":                      {Desc: `bbrev-commi`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"n":                        {Desc: `maximum number of commits to display`},
			"z":                        {Desc: `use NUL termination on output`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"output":                   {Desc: `undocumented`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"color-words":              {Desc: `show colored-word diff`},
			"default":                  {Desc: `use argument as default revision`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
		},
	},
	"prune": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"progress":                 {Desc: `show progress`},
			"verbose":                  {Desc: `report all removed objects`},
			"v":                        {Desc: `report all removed objects`},
			"dry-run":                  {Desc: `do not remove anything; just report what wo`},
			"n":                        {Desc: `do not remove anything; just report what wo`},
			"exclude-promisor-objects": {Desc: `limit traversal to objects outside promisor`},
			"expire":                   {Desc: `only expire loose objects older than specif`},
		},
	},
	"replace": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"convert-graft-file": {Desc: `convert existing graft file`},
			"d":                  {Desc: `delete existing replace refs`},
			"g":                  {Desc: `rewrite the parents of a commit`},
			"list":               {Desc: `list replace refs`},
			"pretty-print":       {Desc: `dit`},
			"f":                  {Desc: `overwrite existing replace ref`},
			"format":             {Desc: `use specified format`},
			"force":              {Desc: `overwrite existing replace ref`},
			"graft":              {Desc: `rewrite the parents of a commit`},
			"raw":                {Desc: `dit`},
			"don't":              {Desc: `dit`},
			"contents":           {Desc: `dit`},
			"delete":             {Desc: `delete existing replace refs`},
			"edit":               {Desc: `edit existing object and replace it with the new`},
			"for":                {Desc: `dit`},
			"e":                  {Desc: `edit existing object and replace it with the new`},
			"l":                  {Desc: `list replace refs`},
		},
	},
	"st": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"no-renames":        {Desc: `don't detect renames`},
			"s":                 {Desc: `output in short format`},
			"show-stash":        {Desc: `show stash information`},
			"u":                 {Desc: `show untracked files`},
			"find-renames":      {Desc: `detect renames, optionally set similarity index`},
			"ignore-submodules": {Desc: `ignore changes to submodules`},
			"ignored":           {Desc: `show ignored files as well`},
			"no-column":         {Desc: `don't display in columns`},
			"null":              {Desc: `use NUL termination on output`},
			"M":                 {Desc: `detect renames`},
			"column":            {Desc: `display in columns`},
			"no-ahead-behind":   {Desc: `don't display detailed ahead/behind counts relativ`},
			"z":                 {Desc: `use NUL termination on output`},
			"porcelain":         {Desc: `produce machine-readable output`},
			"short":             {Desc: `output in short format`},
			"untracked-files":   {Desc: `show untracked files`},
		},
	},
	"interpret-trailers": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"mergetool": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"print":     {Desc: `ool"`},
			"used":      {Desc: `ool"`},
			"with":      {Desc: `ool"`},
			"gui":       {Desc: `use merge.guitool variable instead of merge.tool`},
			"no-prompt": {Desc: `do not prompt before invocation of merge resolution progra`},
			"y":         {Desc: `do not prompt before invocation of merge resolution progra`},
			"g":         {Desc: `use merge.guitool variable instead of merge.tool`},
			"tool":      {Desc: `merge resolution program to use`},
			"tools":     {Desc: `ool"`},
			"that":      {Desc: `ool"`},
			"O":         {Desc: `process files in the order specified in file`},
			"t":         {Desc: `merge resolution program to use`},
			"tool-help": {Desc: `ool"`},
			"list":      {Desc: `ool"`},
			"merge":     {Desc: `ool"`},
			"may":       {Desc: `ool"`},
			"be":        {Desc: `ool"`},
			"prompt":    {Desc: `prompt before invocation of merge resolution program`},
			"a":         {Desc: `ool"`},
			"of":        {Desc: `ool"`},
		},
	},
	"filter-branch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"tree-filter":         {Desc: `filter for rewriting tree and its contents`},
			"original":            {Desc: `namespace where original commits will be stored`},
			"state-branch":        {Desc: `load mapping from old to new objects from specif`},
			"tag-name-filter":     {Desc: `filter for rewriting tag names`},
			"force":               {Desc: `force operation`},
			"parent-filter":       {Desc: `filter for rewriting parent list of commit`},
			"setup":               {Desc: `specify one time setup command`},
			"subdirectory-filter": {Desc: `only look at history that touches given director`},
			"d":                   {Desc: `temporary directory used for rewriting`},
			"f":                   {Desc: `force operation`},
			"index-filter":        {Desc: `filter for rewriting index`},
			"msg-filter":          {Desc: `filter for rewriting commit messages`},
			"prune-empty":         {Desc: `ignore empty generated commits`},
			"commit-filter":       {Desc: `filter for rewriting commit`},
			"env-filter":          {Desc: `filter for modifying environment in which commit`},
		},
	},
	"reset": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"N":                  {Desc: `record only the fact that removed paths will be a`},
			"keep":               {Desc: `ard, but keep local working tree changes`},
			"like":               {Desc: `ard, but keep local working tree changes`},
			"p":                  {Desc: `select diff hunks to remove from the index`},
			"quiet":              {Desc: `suppress all output`},
			"soft":               {Desc: `do not touch the index file nor the working tree`},
			"hard":               {Desc: `match the working tree and index to the given tre`},
			"intent-to-add":      {Desc: `record only the fact that removed paths will be a`},
			"merge":              {Desc: `reset out of a conflicted merge`},
			"mixed":              {Desc: `reset the index but not the working tree (default`},
			"patch":              {Desc: `select diff hunks to remove from the index`},
			"q":                  {Desc: `suppress all output`},
			"recurse-submodules": {Desc: `control recursive updating of submodules`},
		},
	},
	"apply": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"3":                   {Desc: `fall back on 3-way merge if patch fails`},
			"apply":               {Desc: `apply patches that would otherwise not be applie`},
			"exclude":             {Desc: `skip files matching specified pattern`},
			"as":                  {Desc: `tat but in decimal notation and compl`},
			"C":                   {Desc: `ensure at least N lines of context match before`},
			"build-fake-ancestor": {Desc: `build temporary index for blobs with ambiguous o`},
			"check":               {Desc: `check if patches are applicable (turns off "appl`},
			"allow-overlap":       {Desc: `allow overlapping hunks`},
			"cached":              {Desc: `apply patches without touching working tree`},
			"no-add":              {Desc: `ignore additions made by the patch`},
			"summary":             {Desc: `output summary of git-diff extended headers (tur`},
			"v":                   {Desc: `display progress on stderr`},
			"3way":                {Desc: `fall back on 3-way merge if patch fails`},
			"directory":           {Desc: `root to prepend to all filenames`},
			"inaccurate-eof":      {Desc: `work around missing-new-line-at-EOF bugs`},
			"stat":                {Desc: `output diffstat for input (turns off "apply")`},
			"unidiff-zero":        {Desc: `disable unified-diff-context check`},
			"index":               {Desc: `make sure that patch is applicable to index`},
			"reverse":             {Desc: `apply patches in reverse`},
			"p":                   {Desc: `remove N leading slashes from traditional diff p`},
			"z":                   {Desc: `use NUL termination on output`},
			"include":             {Desc: `include files matching specified pattern`},
			"numstat":             {Desc: `tat but in decimal notation and compl`},
			"recount":             {Desc: `do not trust line counts in hunk headers`},
			"R":                   {Desc: `apply patches in reverse`},
			"verbose":             {Desc: `display progress on stderr`},
			"ignore-whitespace":   {Desc: `ignore changes in whitespace in context lines`},
			"same":                {Desc: `tat but in decimal notation and compl`},
			"reject":              {Desc: `apply hunks that apply and leave rejected hunks`},
			"whitespace":          {Desc: `detect a new or modified line that ends with tra`},
		},
	},
	"shortlog": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"pretend":                  {Desc: `ot refs/bise`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"all":                      {Desc: `rep, -`},
			"date-order":               {Desc: `display commits in date order`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"patch":                    {Desc: `generate diff in patch format`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"parents":                  {Desc: `display parents of commit`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"cherry":                   {Desc: `o-m`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"no-patch":                 {Desc: `suppress diff output`},
			"all-match":                {Desc: `rep, -`},
			"color-words":              {Desc: `show colored-word diff`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"text":                     {Desc: `treat all files as text`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"a":                        {Desc: `treat all files as text`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"output":                   {Desc: `undocumented`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"since":                    {Desc: `show commits more recent than given date`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"n":                        {Desc: `maximum number of commits to display`},
			"count":                    {Desc: `display how many commits would have been list`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"z":                        {Desc: `use NUL termination on output`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"until":                    {Desc: `show commits older than given date`},
			"word-diff":                {Desc: `show word diff`},
			"to":                       {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"help":                     {Desc: `print a short usage message and exit`},
			"merges":                   {Desc: `display only merge commits`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"format":                   {Desc: `pretty print commit messages`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"color":                    {Desc: `show colored diff`},
			"full-history":             {Desc: `do not prune history`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"before":                   {Desc: `show commits older than given date`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"date":                     {Desc: `format of date output`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"w":                        {Desc: `linewrap the output`},
			"commits":                  {Desc: `rep, -`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"after":                    {Desc: `show commits more recent than given date`},
			"color-moved":              {Desc: `color moved lines differently`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"raw":                      {Desc: `generate default raw diff output`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"as":                       {Desc: `ot refs/bise`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"no-min-parents":           {Desc: `reset limit`},
			"of":                       {Desc: `ull-history`},
			"limit":                    {Desc: `rep, -`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"children":                 {Desc: `display children of commit`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"milder":                   {Desc: `ull-history`},
			"oneline":                  {Desc: `bbrev-commi`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-max-parents":           {Desc: `reset limit`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"email":                    {Desc: `show email address of each author`},
			"topo-order":               {Desc: `display commits in topological order`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"those":                    {Desc: `rep, -`},
			"bisect":                   {Desc: `ot refs/bise`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"name-only":                {Desc: `show only names of changed files`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"shorthand":                {Desc: `bbrev-commi`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"default":                  {Desc: `use argument as default revision`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"simplify-merges":          {Desc: `ull-history`},
			"P":                        {Desc: `use perl regular expression`},
			"M":                        {Desc: `detect renames with given scope`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"matching":                 {Desc: `rep, -`},
			"no-renames":               {Desc: `turn off rename detection`},
			"version":                  {Desc: `ull-history`},
			"invert-grep":              {Desc: `rep, -`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"s":                        {Desc: `suppress commit description`},
			"u":                        {Desc: `generate diff in patch format`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"in":                       {Desc: `ull-index, output binary di`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"p":                        {Desc: `generate diff in patch format`},
			"for":                      {Desc: `bbrev-commi`},
			"no-color":                 {Desc: `turn off colored diff`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"e":                        {Desc: `show email address of each author`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"numbered":                 {Desc: `sort according to number of commits`},
			"h":                        {Desc: `print a short usage message and exit`},
			"i":                        {Desc: `match regexps ignoring case`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"if":                       {Desc: `ot refs/bise`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"R":                        {Desc: `do a reverse diff`},
			"early-output":             {Desc: `undocumented`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
		},
	},
	"upload-archive": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"describe": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"broken":       {Desc: `describe HEAD, adding mark if broken`},
			"same":         {Desc: `andidates=0`},
			"tags":         {Desc: `use any ref found in "$GIT_DIR/refs/tags"`},
			"candidates":   {Desc: `consider up to given number of candidates`},
			"long":         {Desc: `always show full format, even for exact matches`},
			"match":        {Desc: `only consider tags matching glob pattern`},
			"exact-match":  {Desc: `andidates=0`},
			"only":         {Desc: `andidates=0`},
			"output":       {Desc: `andidates=0`},
			"exact":        {Desc: `andidates=0`},
			"matches,":     {Desc: `andidates=0`},
			"abbrev":       {Desc: `set minimum SHA1 display-length`},
			"all":          {Desc: `use any ref found in "$GIT_DIR/refs/"`},
			"always":       {Desc: `show uniquely abbreviated commit object as fallback`},
			"exclude":      {Desc: `don't consider tags matching glob pattern`},
			"first-parent": {Desc: `follow only the first parent of merge commits`},
			"as":           {Desc: `andidates=0`},
			"contains":     {Desc: `find the tag after the commit instead of before`},
			"debug":        {Desc: `display information about the searching strategy`},
			"dirty":        {Desc: `describe HEAD, adding mark if dirty`},
		},
	},
	"update-ref": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"create-reflog": {Desc: `create a reflog`},
			"no-deref":      {Desc: `overwrite ref itself, not what it points to`},
			"stdin":         {Desc: `reads instructions from standard input`},
			"d":             {Desc: `delete given reference after verifying its value`},
			"m":             {Desc: `update reflog for specified name with specified reason`},
		},
	},
	"cvsimport": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"M": {Desc: `attempt to detect merges based on the commit message with custom patt`},
			"k": {Desc: `remove keywords from source files in the CVS archive`},
			"m": {Desc: `attempt to detect merges based on the commit message`},
			"p": {Desc: `specify additional options for cvsps`},
			"r": {Desc: `the git remote to import into`},
			"z": {Desc: `specify timestamp fuzz factor to cvsps`},
			"A": {Desc: `specify author-conversion file`},
			"C": {Desc: `specify the git repository to import into`},
			"a": {Desc: `import all commits, including recent ones`},
			"d": {Desc: `specify the root of the CVS archive`},
			"o": {Desc: `specify the branch into which you wish to import`},
			"u": {Desc: `convert underscores in tag and branch names to dots`},
			"L": {Desc: `limit the number of commits imported`},
			"P": {Desc: `read cvsps output file`},
			"i": {Desc: `do not perform a checkout after importing`},
			"s": {Desc: `substitute the "/" character in branch names with given substitution`},
			"v": {Desc: `verbose output`},
			"R": {Desc: `generate cvs-revisions file mapping CVS revision numbers to commit ID`},
			"S": {Desc: `skip paths matching given regex`},
			"h": {Desc: `display usage information`},
		},
	},
	"diff-index": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"cached":                   {Desc: `don't consider the work tree at all`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"simplify-merges":          {Desc: `ull-history`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"no-color":                 {Desc: `turn off colored diff`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"output":                   {Desc: `undocumented`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"until":                    {Desc: `show commits older than given date`},
			"s":                        {Desc: `suppress diff output`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"default":                  {Desc: `use argument as default revision`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"oneline":                  {Desc: `bbrev-commi`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"patch":                    {Desc: `generate diff in patch format`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"before":                   {Desc: `show commits older than given date`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"matching":                 {Desc: `rep, -`},
			"pretend":                  {Desc: `ot refs/bise`},
			"text":                     {Desc: `treat all files as text`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"since":                    {Desc: `show commits more recent than given date`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-min-parents":           {Desc: `reset limit`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"milder":                   {Desc: `ull-history`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"z":                        {Desc: `use NUL termination on output`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"color-moved":              {Desc: `color moved lines differently`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"commits":                  {Desc: `rep, -`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"color-words":              {Desc: `show colored-word diff`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"no-max-parents":           {Desc: `reset limit`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"bisect":                   {Desc: `ot refs/bise`},
			"if":                       {Desc: `ot refs/bise`},
			"P":                        {Desc: `use perl regular expression`},
			"version":                  {Desc: `ull-history`},
			"of":                       {Desc: `ull-history`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"a":                        {Desc: `treat all files as text`},
			"n":                        {Desc: `maximum number of commits to display`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"children":                 {Desc: `display children of commit`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"topo-order":               {Desc: `display commits in topological order`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"cherry":                   {Desc: `o-m`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"all":                      {Desc: `rep, -`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"color":                    {Desc: `show colored diff`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"early-output":             {Desc: `undocumented`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"u":                        {Desc: `generate diff in patch format`},
			"those":                    {Desc: `rep, -`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"for":                      {Desc: `bbrev-commi`},
			"M":                        {Desc: `detect renames with given scope`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-patch":                 {Desc: `suppress diff output`},
			"no-renames":               {Desc: `turn off rename detection`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"to":                       {Desc: `rep, -`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"parents":                  {Desc: `display parents of commit`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"after":                    {Desc: `show commits more recent than given date`},
			"all-match":                {Desc: `rep, -`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"date-order":               {Desc: `display commits in date order`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"merges":                   {Desc: `display only merge commits`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"full-history":             {Desc: `do not prune history`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"p":                        {Desc: `generate diff in patch format`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"author":                   {Desc: `limit commits to those by given author`},
			"in":                       {Desc: `ull-index, output binary di`},
			"as":                       {Desc: `ot refs/bise`},
			"count":                    {Desc: `display how many commits would have been list`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"invert-grep":              {Desc: `rep, -`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"R":                        {Desc: `do a reverse diff`},
			"i":                        {Desc: `match regexps ignoring case`},
			"m":                        {Desc: `flag non-checked-out files as up-to-date`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"name-only":                {Desc: `show only names of changed files`},
			"date":                     {Desc: `format of date output`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"shorthand":                {Desc: `bbrev-commi`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"word-diff":                {Desc: `show word diff`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"raw":                      {Desc: `generate default raw diff output`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"limit":                    {Desc: `rep, -`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"format":                   {Desc: `pretty print commit messages`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"c":                        {Desc: `combined diff format for merge commits`},
		},
	},
	"lola": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"date-order":               {Desc: `display commits in date order`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"since":                    {Desc: `show commits more recent than given date`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"invert-grep":              {Desc: `rep, -`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"author":                   {Desc: `limit commits to those by given author`},
			"default":                  {Desc: `use argument as default revision`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"M":                        {Desc: `detect renames with given scope`},
			"p":                        {Desc: `generate diff in patch format`},
			"date":                     {Desc: `format of date output`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"full-history":             {Desc: `do not prune history`},
			"merges":                   {Desc: `display only merge commits`},
			"no-patch":                 {Desc: `suppress diff output`},
			"version":                  {Desc: `ull-history`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"commits":                  {Desc: `rep, -`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"patch":                    {Desc: `generate diff in patch format`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"milder":                   {Desc: `ull-history`},
			"all":                      {Desc: `rep, -`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"bisect":                   {Desc: `ot refs/bise`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"until":                    {Desc: `show commits older than given date`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"limit":                    {Desc: `rep, -`},
			"before":                   {Desc: `show commits older than given date`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"no-follow":                {Desc: `do not follow renames`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"i":                        {Desc: `match regexps ignoring case`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"after":                    {Desc: `show commits more recent than given date`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"as":                       {Desc: `ot refs/bise`},
			"color-moved":              {Desc: `color moved lines differently`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"color-words":              {Desc: `show colored-word diff`},
			"count":                    {Desc: `display how many commits would have been list`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"text":                     {Desc: `treat all files as text`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"n":                        {Desc: `maximum number of commits to display`},
			"early-output":             {Desc: `undocumented`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"no-renames":               {Desc: `turn off rename detection`},
			"R":                        {Desc: `do a reverse diff`},
			"u":                        {Desc: `generate diff in patch format`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"color":                    {Desc: `show colored diff`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"format":                   {Desc: `pretty print commit messages`},
			"parents":                  {Desc: `display parents of commit`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"no-max-parents":           {Desc: `reset limit`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"output":                   {Desc: `undocumented`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"for":                      {Desc: `irstat=cumulative`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"those":                    {Desc: `rep, -`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"h":                        {Desc: `display help`},
			"to":                       {Desc: `rep, -`},
			"pretend":                  {Desc: `ot refs/bise`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"all-match":                {Desc: `rep, -`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"name-only":                {Desc: `show only names of changed files`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"simplify-merges":          {Desc: `ull-history`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"matching":                 {Desc: `rep, -`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"in":                       {Desc: `ull-index, output binary di`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"word-diff":                {Desc: `show word diff`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"of":                       {Desc: `ull-history`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"raw":                      {Desc: `generate default raw diff output`},
			"topo-order":               {Desc: `display commits in topological order`},
			"P":                        {Desc: `use perl regular expression`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"if":                       {Desc: `ot refs/bise`},
			"cherry":                   {Desc: `o-m`},
			"children":                 {Desc: `display children of commit`},
			"no-min-parents":           {Desc: `reset limit`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"z":                        {Desc: `use NUL termination on output`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"a":                        {Desc: `treat all files as text`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"no-color":                 {Desc: `turn off colored diff`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"s":                        {Desc: `suppress diff output`},
		},
	},
	"rm": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"n":              {Desc: `do not actually remove the files, just show if they e`},
			"force":          {Desc: `override the up-to-date check`},
			"f":              {Desc: `override the up-to-date check`},
			"ignore-unmatch": {Desc: `exit with 0 status even if no files matched`},
			"q":              {Desc: `don't list removed files`},
			"cached":         {Desc: `only remove files from the index`},
			"dry-run":        {Desc: `do not actually remove the files, just show if they e`},
			"quiet":          {Desc: `don't list removed files`},
			"r":              {Desc: `allow recursive removal when a leading directory-name`},
		},
	},
	"cat-file": {Desc: "", Sub: map[string]*complete.CompTree{"blob": {Desc: "blob    commit  tag     tree", Sub: map[string]*complete.CompTree{}}},
		Flags: map[string]*complete.CompTree{
			"unordered":          {Desc: `atch-all-objects output`},
			"t":                  {Desc: `show type of given object`},
			"in-tree":            {Desc: `at`},
			"don't":              {Desc: `atch-all-objects output`},
			"textconv":           {Desc: `show content as transformed by a textconv filter`},
			"filters":            {Desc: `show content as transformed by filters`},
			"path":               {Desc: `ilters`},
			"use":                {Desc: `ilters`},
			"specific":           {Desc: `ilters`},
			"allow-unknown-type": {Desc: `allow query of broken/corrupt objects of unknown ty`},
			"batch-all-objects":  {Desc: `atch-check`},
			"symlinks":           {Desc: `at`},
			"order":              {Desc: `atch-all-objects output`},
			"textconv/":          {Desc: `ilters`},
			"s":                  {Desc: `show size of given object`},
			"batch":              {Desc: `at`},
			"objects":            {Desc: `atch-check`},
			"or":                 {Desc: `at`},
			"buffer":             {Desc: `disable flushing of output after each object`},
			"follow-symlinks":    {Desc: `at`},
			"for":                {Desc: `ilters`},
			"p":                  {Desc: `pretty-print given object`},
			"e":                  {Desc: `exit with zero status if object exists`},
			"all":                {Desc: `atch-check`},
			"follow":             {Desc: `at`},
			"(used":              {Desc: `at`},
			"a":                  {Desc: `ilters`},
			"show":               {Desc: `atch-check`},
			"with":               {Desc: `at`},
			"batch-check":        {Desc: `print SHA1, type and size (or in specified format)`},
		},
	},
	"fixup": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"flog": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"format":                   {Desc: `pretty print commit messages`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"u":                        {Desc: `generate diff in patch format`},
			"before":                   {Desc: `show commits older than given date`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"simplify-merges":          {Desc: `ull-history`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"all-match":                {Desc: `rep, -`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"name-only":                {Desc: `show only names of changed files`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"merges":                   {Desc: `display only merge commits`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"no-color":                 {Desc: `turn off colored diff`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"all":                      {Desc: `rep, -`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"h":                        {Desc: `display help`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"date-order":               {Desc: `display commits in date order`},
			"early-output":             {Desc: `undocumented`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"shorthand":                {Desc: `bbrev-commi`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"z":                        {Desc: `use NUL termination on output`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"M":                        {Desc: `detect renames with given scope`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"n":                        {Desc: `maximum number of commits to display`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"default":                  {Desc: `use argument as default revision`},
			"no-max-parents":           {Desc: `reset limit`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"i":                        {Desc: `match regexps ignoring case`},
			"p":                        {Desc: `generate diff in patch format`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"milder":                   {Desc: `ull-history`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"patch":                    {Desc: `generate diff in patch format`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"children":                 {Desc: `display children of commit`},
			"count":                    {Desc: `display how many commits would have been list`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"limit":                    {Desc: `rep, -`},
			"commits":                  {Desc: `rep, -`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"topo-order":               {Desc: `display commits in topological order`},
			"date":                     {Desc: `format of date output`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"full-history":             {Desc: `do not prune history`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"P":                        {Desc: `use perl regular expression`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"word-diff":                {Desc: `show word diff`},
			"color":                    {Desc: `show colored diff`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"oneline":                  {Desc: `bbrev-commi`},
			"output":                   {Desc: `undocumented`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"invert-grep":              {Desc: `rep, -`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"no-patch":                 {Desc: `suppress diff output`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"no-renames":               {Desc: `turn off rename detection`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"color-moved":              {Desc: `color moved lines differently`},
			"color-words":              {Desc: `show colored-word diff`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"no-follow":                {Desc: `do not follow renames`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"cherry":                   {Desc: `o-m`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"if":                       {Desc: `ot refs/bise`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"in":                       {Desc: `ull-index, output binary di`},
			"bisect":                   {Desc: `ot refs/bise`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"parents":                  {Desc: `display parents of commit`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"pretend":                  {Desc: `ot refs/bise`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"version":                  {Desc: `ull-history`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"R":                        {Desc: `do a reverse diff`},
			"s":                        {Desc: `suppress diff output`},
			"after":                    {Desc: `show commits more recent than given date`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"raw":                      {Desc: `generate default raw diff output`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"as":                       {Desc: `ot refs/bise`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"since":                    {Desc: `show commits more recent than given date`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"until":                    {Desc: `show commits older than given date`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"of":                       {Desc: `ull-history`},
			"a":                        {Desc: `treat all files as text`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"to":                       {Desc: `rep, -`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"for":                      {Desc: `bbrev-commi`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"those":                    {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"text":                     {Desc: `treat all files as text`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"matching":                 {Desc: `rep, -`},
			"no-min-parents":           {Desc: `reset limit`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
		},
	},
	"imap-send": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"curl":    {Desc: `use libcurl to communicate with the IMAP server`},
			"quiet":   {Desc: `be more quiet`},
			"q":       {Desc: `be more quiet`},
			"verbose": {Desc: `be more verbose`},
			"v":       {Desc: `be more verbose`},
		},
	},
	"instaweb": {Desc: "", Sub: map[string]*complete.CompTree{"restart": {Desc: "restart the HTTP-daemon and exit", Sub: map[string]*complete.CompTree{}},
		"start": {Desc: "start the HTTP-daemon and exit", Sub: map[string]*complete.CompTree{}},
		"stop":  {Desc: "stop the HTTP-daemon and exit", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"httpd":       {Desc: `HTTP-daemon command-line that will be executed`},
			"d":           {Desc: `HTTP-daemon command-line that will be executed`},
			"l":           {Desc: `bind the web server to 127.0.0.1`},
			"module-path": {Desc: `module path for the Apache HTTP-daemon`},
			"m":           {Desc: `module path for the Apache HTTP-daemon`},
			"p":           {Desc: `port to bind web server to`},
			"start":       {Desc: `start the HTTP-daemon and exit`},
			"browser":     {Desc: `web-browser command-line that will be executed`},
			"b":           {Desc: `web-browser command-line that will be executed`},
			"local":       {Desc: `bind the web server to 127.0.0.1`},
			"port":        {Desc: `port to bind web server to`},
			"restart":     {Desc: `restart the HTTP-daemon and exit`},
			"stop":        {Desc: `stop the HTTP-daemon and exit`},
		},
	},
	"patch-id": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"shell": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"unstage": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"br": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"abbrev":           {Desc: `set minimum SHA1 display-length`},
			"no-contains":      {Desc: `only list branches that don't contain the spec`},
			"no-track":         {Desc: `override the branch.autosetupmerge configurati`},
			"C":                {Desc: `copy a branch even if the new branch-name alre`},
			"delete":           {Desc: `delete a fully merged branch`},
			"f":                {Desc: `force the creation of a new branch`},
			"i":                {Desc: `sorting and filtering are case-insensitive`},
			"u":                {Desc: `set up configuration so that pull merges`},
			"track":            {Desc: `setup configuration so that pull merges from t`},
			"vv":               {Desc: `show SHA1 and commit subject line for each hea`},
			"d":                {Desc: `delete a fully merged branch`},
			"l":                {Desc: `list only branches matching glob`},
			"points-at":        {Desc: `only list tags of the given object`},
			"quiet":            {Desc: `be more quiet`},
			"unset-upstream":   {Desc: `remove upstream configuration`},
			"contains":         {Desc: `only list branches that contain the specified`},
			"c":                {Desc: `copy a branch and the corresponding reflog`},
			"merged":           {Desc: `only list branches that are fully contained by`},
			"m":                {Desc: `rename a branch and the corresponding reflog`},
			"no-color":         {Desc: `turn off branch coloring`},
			"no-merged":        {Desc: `don't list branches that are fully contained b`},
			"sort":             {Desc: `specify field to sort on`},
			"D":                {Desc: `delete a branch`},
			"color":            {Desc: `turn on branch coloring`},
			"copy":             {Desc: `copy a branch and the corresponding reflog`},
			"edit-description": {Desc: `edit branch description`},
			"no-abbrev":        {Desc: `don't abbreviate sha1s`},
			"remotes":          {Desc: `list or delete only remote-tracking branches`},
			"r":                {Desc: `list or delete only remote-tracking branches`},
			"verbose":          {Desc: `show SHA1 and commit subject line for each hea`},
			"v":                {Desc: `show SHA1 and commit subject line for each hea`},
			"column":           {Desc: `display tag listing in columns`},
			"force":            {Desc: `force the creation of a new branch`},
			"ignore-case":      {Desc: `sorting and filtering are case-insensitive`},
			"move":             {Desc: `rename a branch and the corresponding reflog`},
			"q":                {Desc: `be more quiet`},
			"t":                {Desc: `setup configuration so that pull merges from t`},
			"M":                {Desc: `rename a branch even if the new branch-name al`},
			"a":                {Desc: `list both remote-tracking branches and local b`},
			"create-reflog":    {Desc: `create the branch's reflog`},
			"show-current":     {Desc: `show current branch name`},
			"list":             {Desc: `list only branches matching glob`},
			"no-column":        {Desc: `don't display in columns`},
			"set-upstream-to":  {Desc: `set up configuration so that pull merges`},
		},
	},
	"mv": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"dry-run": {Desc: `only show what would happen`},
			"n":       {Desc: `only show what would happen`},
			"force":   {Desc: `rename/move even if targets exist`},
			"f":       {Desc: `rename/move even if targets exist`},
			"verbose": {Desc: `output additional information`},
			"v":       {Desc: `output additional information`},
			"k":       {Desc: `skip rename/move that would lead to errors`},
		},
	},
	"remote": {Desc: "", Sub: map[string]*complete.CompTree{"add": {Desc: "add a new remote", Sub: map[string]*complete.CompTree{}},
		"set-head":     {Desc: "set or delete default branch for a remote", Sub: map[string]*complete.CompTree{}},
		"set-url":      {Desc: "change URL for a remote", Sub: map[string]*complete.CompTree{}},
		"get-url":      {Desc: "retrieves the URLs for a remote", Sub: map[string]*complete.CompTree{}},
		"prune":        {Desc: "delete all stale tracking branches for a remote", Sub: map[string]*complete.CompTree{}},
		"remove":       {Desc: "remove a remote and all associated tracking branches", Sub: map[string]*complete.CompTree{}},
		"rename":       {Desc: "rename a remote and update all associated tracking branch", Sub: map[string]*complete.CompTree{}},
		"set-branches": {Desc: "change list of branches tracked by a remote", Sub: map[string]*complete.CompTree{}},
		"show":         {Desc: "show information about a given remote", Sub: map[string]*complete.CompTree{}},
		"update":       {Desc: "fetch updates for a set of remotes", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"verbose": {Desc: `show remote url after name`},
			"v":       {Desc: `show remote url after name`},
		},
	},
	"cherry-pick": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"cleanup":                {Desc: `specify how to strip spaces and #comments fro`},
			"continue":               {Desc: `resume revert or cherry-pick sequence`},
			"gpg-sign":               {Desc: `GPG-sign the commit`},
			"keep-redundant-commits": {Desc: `keep cherry-picked commits that will become e`},
			"no-gpg-sign":            {Desc: `don't GPG-sign the commit`},
			"strategy-option":        {Desc: `pass merge-strategy-specific option to merge`},
			"quit":                   {Desc: `end revert or cherry-pick sequence`},
			"signoff":                {Desc: `add Signed-off-by line at the end of the comm`},
			"strategy":               {Desc: `use given merge strategy`},
			"abort":                  {Desc: `cancel revert or cherry-pick sequence`},
			"edit":                   {Desc: `edit commit before committing the cherry-pick`},
			"ff":                     {Desc: `fast forward, if possible`},
			"m":                      {Desc: `specify mainline when cherry-picking a merge`},
			"rerere-autoupdate":      {Desc: `update index with reused conflict resolution`},
			"X":                      {Desc: `pass merge-strategy-specific option to merge`},
			"x":                      {Desc: `append information about what commit was cher`},
			"allow-empty":            {Desc: `preserve initially empty commits`},
			"allow-empty-message":    {Desc: `allow replaying a commit with an empty messag`},
			"e":                      {Desc: `edit commit before committing the cherry-pick`},
			"S":                      {Desc: `GPG-sign the commit`},
			"mainline":               {Desc: `specify mainline when cherry-picking a merge`},
			"no-commit":              {Desc: `do not make the actual commit`},
			"n":                      {Desc: `do not make the actual commit`},
			"s":                      {Desc: `use given merge strategy`},
			"skip":                   {Desc: `skip current commit and continue`},
		},
	},
	"lg": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"after":                    {Desc: `show commits more recent than given date`},
			"color-moved":              {Desc: `color moved lines differently`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"no-min-parents":           {Desc: `reset limit`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"no-color":                 {Desc: `turn off colored diff`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"limit":                    {Desc: `rep, -`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"author":                   {Desc: `limit commits to those by given author`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"z":                        {Desc: `use NUL termination on output`},
			"all":                      {Desc: `rep, -`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"p":                        {Desc: `generate diff in patch format`},
			"if":                       {Desc: `ot refs/bise`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"no-renames":               {Desc: `turn off rename detection`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"full-history":             {Desc: `do not prune history`},
			"shorthand":                {Desc: `bbrev-commi`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"text":                     {Desc: `treat all files as text`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"no-follow":                {Desc: `do not follow renames`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"count":                    {Desc: `display how many commits would have been list`},
			"until":                    {Desc: `show commits older than given date`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"i":                        {Desc: `match regexps ignoring case`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"raw":                      {Desc: `generate default raw diff output`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"color":                    {Desc: `show colored diff`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"P":                        {Desc: `use perl regular expression`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"milder":                   {Desc: `ull-history`},
			"M":                        {Desc: `detect renames with given scope`},
			"merges":                   {Desc: `display only merge commits`},
			"before":                   {Desc: `show commits older than given date`},
			"children":                 {Desc: `display children of commit`},
			"decorate":                 {Desc: `print out ref names of any commits that are s`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"no-patch":                 {Desc: `suppress diff output`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"of":                       {Desc: `ull-history`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"R":                        {Desc: `do a reverse diff`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"early-output":             {Desc: `undocumented`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"version":                  {Desc: `ull-history`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"pretend":                  {Desc: `ot refs/bise`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"oneline":                  {Desc: `bbrev-commi`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"in":                       {Desc: `ull-index, output binary di`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"name-only":                {Desc: `show only names of changed files`},
			"patch":                    {Desc: `generate diff in patch format`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"n":                        {Desc: `maximum number of commits to display`},
			"bisect":                   {Desc: `ot refs/bise`},
			"to":                       {Desc: `rep, -`},
			"matching":                 {Desc: `rep, -`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"commits":                  {Desc: `rep, -`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"format":                   {Desc: `pretty print commit messages`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"no-max-parents":           {Desc: `reset limit`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"color-words":              {Desc: `show colored-word diff`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"topo-order":               {Desc: `display commits in topological order`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"u":                        {Desc: `generate diff in patch format`},
			"those":                    {Desc: `rep, -`},
			"as":                       {Desc: `ot refs/bise`},
			"date-order":               {Desc: `display commits in date order`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"all-match":                {Desc: `rep, -`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"s":                        {Desc: `suppress diff output`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"h":                        {Desc: `display help`},
			"default":                  {Desc: `use argument as default revision`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"invert-grep":              {Desc: `rep, -`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"for":                      {Desc: `bbrev-commi`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"output":                   {Desc: `undocumented`},
			"parents":                  {Desc: `display parents of commit`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"word-diff":                {Desc: `show word diff`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"since":                    {Desc: `show commits more recent than given date`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"simplify-merges":          {Desc: `ull-history`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"a":                        {Desc: `treat all files as text`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"no-decorate":              {Desc: `do not print out ref names of any commits tha`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"cherry":                   {Desc: `o-m`},
		},
	},
	"tag": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"f":             {Desc: `replace existing tag`},
			"local-user":    {Desc: `create a tag, annotated and signed with the given key`},
			"s":             {Desc: `create a signed and annotated tag`},
			"u":             {Desc: `create a tag, annotated and signed with the given key`},
			"merged":        {Desc: `print only tags that are merged`},
			"v":             {Desc: `verify gpg signature of tags`},
			"annotate":      {Desc: `create an unsigned, annotated tag`},
			"d":             {Desc: `delete tags`},
			"force":         {Desc: `replace existing tag`},
			"ignore-case":   {Desc: `sorting and filtering are case-insensitive`},
			"cleanup":       {Desc: `specify how to strip spaces and #comments from message`},
			"no-contains":   {Desc: `only list tags that don't contain the specified commit`},
			"verify":        {Desc: `verify gpg signature of tags`},
			"n":             {Desc: `limit line output of annotation`},
			"column":        {Desc: `display tag listing in columns`},
			"contains":      {Desc: `only list tags that contain the specified commit`},
			"delete":        {Desc: `delete tags`},
			"list":          {Desc: `list tags matching pattern`},
			"file":          {Desc: `read tag message from given file`},
			"i":             {Desc: `sorting and filtering are case-insensitive`},
			"no-column":     {Desc: `do not display in columns`},
			"no-merged":     {Desc: `print only tags that are not merged`},
			"points-at":     {Desc: `only list tags of the given object`},
			"sort":          {Desc: `specify how the tags should be sorted`},
			"a":             {Desc: `create an unsigned, annotated tag`},
			"color":         {Desc: `respect any colors specified in the format`},
			"format":        {Desc: `specify format to use for the output`},
			"message":       {Desc: `specify tag message`},
			"create-reflog": {Desc: `create a reflog`},
			"F":             {Desc: `read tag message from given file`},
			"l":             {Desc: `list tags matching pattern`},
			"m":             {Desc: `specify tag message`},
			"edit":          {Desc: `force edit of tag message`},
			"e":             {Desc: `force edit of tag message`},
			"sign":          {Desc: `create a signed and annotated tag`},
		},
	},
	"verify-commit": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"raw":     {Desc: `print raw gpg status output`},
			"verbose": {Desc: `print contents of the commit object before validating it`},
			"v":       {Desc: `print contents of the commit object before validating it`},
		},
	},
	"whatchanged": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"matching":                 {Desc: `rep, -`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"oneline":                  {Desc: `bbrev-commi`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"color-moved":              {Desc: `color moved lines differently`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"no-min-parents":           {Desc: `reset limit`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"as":                       {Desc: `ot refs/bise`},
			"for":                      {Desc: `bbrev-commi`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"cherry":                   {Desc: `o-m`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"invert-grep":              {Desc: `rep, -`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"z":                        {Desc: `use NUL termination on output`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"all-match":                {Desc: `rep, -`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"color":                    {Desc: `show colored diff`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"no-max-parents":           {Desc: `reset limit`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"after":                    {Desc: `show commits more recent than given date`},
			"before":                   {Desc: `show commits older than given date`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"of":                       {Desc: `ull-history`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"n":                        {Desc: `maximum number of commits to display`},
			"those":                    {Desc: `rep, -`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"no-patch":                 {Desc: `suppress diff output`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"milder":                   {Desc: `ull-history`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"format":                   {Desc: `pretty print commit messages`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"name-only":                {Desc: `show only names of changed files`},
			"output":                   {Desc: `undocumented`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"M":                        {Desc: `detect renames with given scope`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"merges":                   {Desc: `display only merge commits`},
			"raw":                      {Desc: `generate default raw diff output`},
			"to":                       {Desc: `rep, -`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"pretend":                  {Desc: `ot refs/bise`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"full-history":             {Desc: `do not prune history`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"commits":                  {Desc: `rep, -`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"date":                     {Desc: `format of date output`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"date-order":               {Desc: `display commits in date order`},
			"no-renames":               {Desc: `turn off rename detection`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"version":                  {Desc: `ull-history`},
			"all":                      {Desc: `rep, -`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"bisect":                   {Desc: `ot refs/bise`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"parents":                  {Desc: `display parents of commit`},
			"text":                     {Desc: `treat all files as text`},
			"P":                        {Desc: `use perl regular expression`},
			"a":                        {Desc: `treat all files as text`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"simplify-merges":          {Desc: `ull-history`},
			"in":                       {Desc: `ull-index, output binary di`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"children":                 {Desc: `display children of commit`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"early-output":             {Desc: `undocumented`},
			"until":                    {Desc: `show commits older than given date`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"p":                        {Desc: `generate diff in patch format`},
			"u":                        {Desc: `generate diff in patch format`},
			"if":                       {Desc: `ot refs/bise`},
			"count":                    {Desc: `display how many commits would have been list`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"shorthand":                {Desc: `bbrev-commi`},
			"since":                    {Desc: `show commits more recent than given date`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"R":                        {Desc: `do a reverse diff`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"i":                        {Desc: `match regexps ignoring case`},
			"s":                        {Desc: `suppress diff output`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"author":                   {Desc: `limit commits to those by given author`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"default":                  {Desc: `use argument as default revision`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"no-color":                 {Desc: `turn off colored diff`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"word-diff":                {Desc: `show word diff`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"limit":                    {Desc: `rep, -`},
			"color-words":              {Desc: `show colored-word diff`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"patch":                    {Desc: `generate diff in patch format`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"topo-order":               {Desc: `display commits in topological order`},
		},
	},
	"blame": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"color-by-age":             {Desc: `color lines by age`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"to":                       {Desc: `rep, -`},
			"cherry":                   {Desc: `o-m`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"milder":                   {Desc: `ull-history`},
			"z":                        {Desc: `use NUL termination on output`},
			"all":                      {Desc: `rep, -`},
			"default":                  {Desc: `use argument as default revision`},
			"no-max-parents":           {Desc: `reset limit`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"as":                       {Desc: `ot refs/bise`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"parents":                  {Desc: `display parents of commit`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"P":                        {Desc: `use perl regular expression`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"u":                        {Desc: `generate diff in patch format`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"indent-heuristic":         {Desc: `use indent-based heuristic to improve diffs`},
			"progress":                 {Desc: `force progress reporting`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"color-lines":              {Desc: `color redundant metadata from previous line d`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"ignore-revs-file":         {Desc: `ignore revisions from file`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"incremental":              {Desc: `show results incrementally for machine proces`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"bisect":                   {Desc: `ot refs/bise`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"no-color":                 {Desc: `turn off colored diff`},
			"version":                  {Desc: `ull-history`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"text":                     {Desc: `treat all files as text`},
			"no-patch":                 {Desc: `suppress diff output`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"M":                        {Desc: `detect renames with given scope`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"ignore-rev":               {Desc: `ignore specified revision when blaming`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"porcelain":                {Desc: `show results designed for machine processing`},
			"contents":                 {Desc: `annotate against the given file if no rev is`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"show-number":              {Desc: `show the line number in the original commit`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"a":                        {Desc: `treat all files as text`},
			"l":                        {Desc: `show long rev`},
			"all-match":                {Desc: `rep, -`},
			"color-moved":              {Desc: `color moved lines differently`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"early-output":             {Desc: `undocumented`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"since":                    {Desc: `show commits more recent than given date`},
			"R":                        {Desc: `do a reverse diff`},
			"s":                        {Desc: `suppress author name and timestamp`},
			"limit":                    {Desc: `rep, -`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"color-words":              {Desc: `show colored-word diff`},
			"no-renames":               {Desc: `turn off rename detection`},
			"root":                     {Desc: `do not treat root commits as boundaries`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"children":                 {Desc: `display children of commit`},
			"no-min-parents":           {Desc: `reset limit`},
			"simplify-merges":          {Desc: `ull-history`},
			"in":                       {Desc: `ull-index, output binary di`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"merges":                   {Desc: `display only merge commits`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"word-diff":                {Desc: `show word diff`},
			"after":                    {Desc: `show commits more recent than given date`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"show-email":               {Desc: `show the author email instead of the author n`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"f":                        {Desc: `show the filename of the original commit`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"t":                        {Desc: `show raw timestamp`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"count":                    {Desc: `display how many commits would have been list`},
			"S":                        {Desc: `use revs from revs-file`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"if":                       {Desc: `ot refs/bise`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"date":                     {Desc: `format of date output`},
			"date-order":               {Desc: `display commits in date order`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"help":                     {Desc: `show help message`},
			"commits":                  {Desc: `rep, -`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"raw":                      {Desc: `generate default raw diff output`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"full-history":             {Desc: `do not prune history`},
			"line-porcelain":           {Desc: `show results designed for machine processing`},
			"those":                    {Desc: `rep, -`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"show-name":                {Desc: `show the filename of the original commit`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"until":                    {Desc: `show commits older than given date`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"patch":                    {Desc: `generate diff in patch format`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"oneline":                  {Desc: `bbrev-commi`},
			"of":                       {Desc: `ull-history`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"name-only":                {Desc: `show only names of changed files`},
			"output":                   {Desc: `undocumented`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"author":                   {Desc: `limit commits to those by given author`},
			"topo-order":               {Desc: `display commits in topological order`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"show-stats":               {Desc: `include additional statistics at the end of b`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"format":                   {Desc: `pretty print commit messages`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"L":                        {Desc: `annotate only the given line range`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"for":                      {Desc: `bbrev-commi`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"before":                   {Desc: `show commits older than given date`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"p":                        {Desc: `generate diff in patch format`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"shorthand":                {Desc: `bbrev-commi`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"matching":                 {Desc: `rep, -`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"score-debug":              {Desc: `output debugging information relating to -C a`},
			"n":                        {Desc: `maximum number of commits to display`},
			"invert-grep":              {Desc: `rep, -`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"pretend":                  {Desc: `ot refs/bise`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"h":                        {Desc: `show help message`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"color":                    {Desc: `show colored diff`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"e":                        {Desc: `show the author email instead of the author n`},
			"i":                        {Desc: `match regexps ignoring case`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
		},
	},
	"commit-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"gpg-sign":    {Desc: `GPG-sign the commit`},
			"S":           {Desc: `GPG-sign the commit`},
			"no-gpg-sign": {Desc: `don't GPG-sign the commit`},
			"F":           {Desc: `read commit log from specified file`},
			"h":           {Desc: `display usage`},
			"m":           {Desc: `specify paragraph of commit log message`},
			"p":           {Desc: `specify parent commit`},
		},
	},
	"config": {Desc: "", Sub: map[string]*complete.CompTree{"commit": {Desc: "git commit options", Sub: map[string]*complete.CompTree{}},
		"help":          {Desc: "git help options", Sub: map[string]*complete.CompTree{}},
		"i18n":          {Desc: "internationalization options", Sub: map[string]*complete.CompTree{}},
		"uploadpack":    {Desc: "git upload-pack options", Sub: map[string]*complete.CompTree{}},
		"alias":         {Desc: "command aliases", Sub: map[string]*complete.CompTree{}},
		"clean":         {Desc: "git clean options", Sub: map[string]*complete.CompTree{}},
		"http":          {Desc: "http options", Sub: map[string]*complete.CompTree{}},
		"interactive":   {Desc: "options controlling interactivity", Sub: map[string]*complete.CompTree{}},
		"merge":         {Desc: "git merge options", Sub: map[string]*complete.CompTree{}},
		"browser":       {Desc: "browser options", Sub: map[string]*complete.CompTree{}},
		"diff":          {Desc: "diff options", Sub: map[string]*complete.CompTree{}},
		"mailmap":       {Desc: "mailmap options", Sub: map[string]*complete.CompTree{}},
		"pack":          {Desc: "options controlling packing", Sub: map[string]*complete.CompTree{}},
		"remote":        {Desc: "remotes", Sub: map[string]*complete.CompTree{}},
		"showbranch":    {Desc: "showbranch options", Sub: map[string]*complete.CompTree{}},
		"web":           {Desc: "web options", Sub: map[string]*complete.CompTree{}},
		"am":            {Desc: "git am options", Sub: map[string]*complete.CompTree{}},
		"color":         {Desc: "color options", Sub: map[string]*complete.CompTree{}},
		"uploadarchive": {Desc: "git upload-archive options", Sub: map[string]*complete.CompTree{}},
		"log":           {Desc: "git log options", Sub: map[string]*complete.CompTree{}},
		"submodule":     {Desc: "git submodule options", Sub: map[string]*complete.CompTree{}},
		"core":          {Desc: "options controlling git core", Sub: map[string]*complete.CompTree{}},
		"imap":          {Desc: "IMAP options", Sub: map[string]*complete.CompTree{}},
		"pager":         {Desc: "pager options", Sub: map[string]*complete.CompTree{}},
		"push":          {Desc: "git push options", Sub: map[string]*complete.CompTree{}},
		"transfer":      {Desc: "options controlling transfers", Sub: map[string]*complete.CompTree{}},
		"advice":        {Desc: "options controlling advice", Sub: map[string]*complete.CompTree{}},
		"committer":     {Desc: "options controlling committer identity", Sub: map[string]*complete.CompTree{}},
		"url":           {Desc: "URL prefixes", Sub: map[string]*complete.CompTree{}},
		"pretty":        {Desc: "pretty formats", Sub: map[string]*complete.CompTree{}},
		"rerere":        {Desc: "git rerere options", Sub: map[string]*complete.CompTree{}},
		"branch":        {Desc: "branch options", Sub: map[string]*complete.CompTree{}},
		"notes":         {Desc: "git notes options", Sub: map[string]*complete.CompTree{}},
		"rebase":        {Desc: "git rebase options", Sub: map[string]*complete.CompTree{}},
		"gitcvs":        {Desc: "git-cvs options", Sub: map[string]*complete.CompTree{}},
		"gui":           {Desc: "git gui options", Sub: map[string]*complete.CompTree{}},
		"add":           {Desc: "git add options", Sub: map[string]*complete.CompTree{}},
		"apply":         {Desc: "git apply options", Sub: map[string]*complete.CompTree{}},
		"column":        {Desc: "column options", Sub: map[string]*complete.CompTree{}},
		"gpg":           {Desc: "gpg options", Sub: map[string]*complete.CompTree{}},
		"man":           {Desc: "man options", Sub: map[string]*complete.CompTree{}},
		"mergetool":     {Desc: "mergetools", Sub: map[string]*complete.CompTree{}},
		"pull":          {Desc: "git pull options", Sub: map[string]*complete.CompTree{}},
		"fetch":         {Desc: "git fetch options", Sub: map[string]*complete.CompTree{}},
		"guitool":       {Desc: "git gui tool options", Sub: map[string]*complete.CompTree{}},
		"init":          {Desc: "git init options", Sub: map[string]*complete.CompTree{}},
		"worktree":      {Desc: "git worktree options", Sub: map[string]*complete.CompTree{}},
		"status":        {Desc: "git status options", Sub: map[string]*complete.CompTree{}},
		"svn-remote":    {Desc: "git svn remotes", Sub: map[string]*complete.CompTree{}},
		"user":          {Desc: "options controlling user identity", Sub: map[string]*complete.CompTree{}},
		"versionsort":   {Desc: "tag sorting options", Sub: map[string]*complete.CompTree{}},
		"feature":       {Desc: "options modifying defaults for a group", Sub: map[string]*complete.CompTree{}},
		"format":        {Desc: "format options", Sub: map[string]*complete.CompTree{}},
		"remotes":       {Desc: "remotes groups", Sub: map[string]*complete.CompTree{}},
		"sendemail":     {Desc: "git send-email options", Sub: map[string]*complete.CompTree{}},
		"tar":           {Desc: "git tar-tree options", Sub: map[string]*complete.CompTree{}},
		"blame":         {Desc: "git blame options", Sub: map[string]*complete.CompTree{}},
		"receive":       {Desc: "git receive options", Sub: map[string]*complete.CompTree{}},
		"difftool":      {Desc: "difftools", Sub: map[string]*complete.CompTree{}},
		"gc":            {Desc: "git gc options", Sub: map[string]*complete.CompTree{}},
		"repack":        {Desc: "repack options", Sub: map[string]*complete.CompTree{}},
		"svn":           {Desc: "git svn options", Sub: map[string]*complete.CompTree{}},
		"author":        {Desc: "options controlling author identity", Sub: map[string]*complete.CompTree{}},
		"credential":    {Desc: "credential options", Sub: map[string]*complete.CompTree{}},
		"instaweb":      {Desc: "git web options", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"l":              {Desc: `list all variables set in config file`},
			"show-origin":    {Desc: `show origin of config`},
			"get-regexp":     {Desc: `et-all", but interpret "name" as a regula`},
			"list":           {Desc: `list all variables set in config file`},
			"includes":       {Desc: `respect "include.*" directives in config files whe`},
			"no-includes":    {Desc: `don't respect "include.*" directives`},
			"t":              {Desc: `ensure that incoming and outgoing values are canon`},
			"file":           {Desc: `use given config file`},
			"get-all":        {Desc: `get all matching values of the key`},
			"get-colorbool":  {Desc: `check if color should be used`},
			"null":           {Desc: `end values with NUL and newline between key and va`},
			"path":           {Desc: `setting is a path`},
			"unset":          {Desc: `remove the first matching value of the key`},
			"default":        {Desc: `et, use specified default value when entry`},
			"f":              {Desc: `use given config file`},
			"bool-or-int":    {Desc: `setting is an integer`},
			"with":           {Desc: `et, use specified default value when entry`},
			"e":              {Desc: `open config file for editing`},
			"get-color":      {Desc: `find color setting`},
			"get-urlmatch":   {Desc: `get value specific for the URL`},
			"name-only":      {Desc: `show variable names only`},
			"add":            {Desc: `add new value without altering any existing ones`},
			"bool":           {Desc: `setting is a boolean`},
			"remove-section": {Desc: `remove the given section`},
			"unset-all":      {Desc: `remove all matching values of the key`},
			"z":              {Desc: `end values with NUL and newline between key and va`},
			"rename-section": {Desc: `rename the given section`},
			"replace-all":    {Desc: `replace all values of the given key`},
			"type":           {Desc: `ensure that incoming and outgoing values are canon`},
			"edit":           {Desc: `open config file for editing`},
			"get":            {Desc: `get the first matching value of the key`},
			"local":          {Desc: `use local config file`},
			"worktree":       {Desc: `use per-worktree config file`},
			"blob":           {Desc: `read config from given blob object`},
			"int":            {Desc: `setting is an integer`},
			"global":         {Desc: `use user-global config file`},
			"system":         {Desc: `use system-wide config file`},
			"expiry-date":    {Desc: `setting is an expiry date`},
			"like":           {Desc: `et-all", but interpret "name" as a regula`},
		},
	},
	"rev-list": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"min-age":                  {Desc: `minimum age of commits to output`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"color-words":              {Desc: `show colored-word diff`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"missing":                  {Desc: `specify how missing objects are handled`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"until":                    {Desc: `show commits older than given date`},
			"n":                        {Desc: `maximum number of commits to display`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"as":                       {Desc: `isect, displaying shell-evalable c`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"children":                 {Desc: `display children of commit`},
			"early-output":             {Desc: `undocumented`},
			"no-max-parents":           {Desc: `reset limit`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"to":                       {Desc: `rep, -`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"count":                    {Desc: `display how many commits would have been list`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"color":                    {Desc: `show colored diff`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"no-renames":               {Desc: `turn off rename detection`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"z":                        {Desc: `use NUL termination on output`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"color-moved":              {Desc: `color moved lines differently`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"merges":                   {Desc: `display only merge commits`},
			"shorthand":                {Desc: `bbrev-commi`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"timestamp":                {Desc: `print raw commit timestamp`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"simplify-merges":          {Desc: `ull-history`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"progress":                 {Desc: `show progress reports as objects are consider`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"p":                        {Desc: `generate diff in patch format`},
			"M":                        {Desc: `detect renames with given scope`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"date":                     {Desc: `format of date output`},
			"print":                    {Desc: `ilter`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"name-only":                {Desc: `show only names of changed files`},
			"all":                      {Desc: `rep, -`},
			"of":                       {Desc: `ull-history`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"full-history":             {Desc: `do not prune history`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"list":                     {Desc: `ilter`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"previous":                 {Desc: `ilter argument`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"in":                       {Desc: `ull-index, output binary di`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"turn":                     {Desc: `ilter argument`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"no-filter":                {Desc: `ilter argument`},
			"no-min-parents":           {Desc: `reset limit`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"if":                       {Desc: `ot refs/bise`},
			"bisect-vars":              {Desc: `isect, displaying shell-evalable c`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"after":                    {Desc: `show commits more recent than given date`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"use-bitmap-index":         {Desc: `try to speed traversal using pack bitmap inde`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"s":                        {Desc: `suppress diff output`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"filter-print-omitted":     {Desc: `ilter`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"omitted":                  {Desc: `ilter`},
			"all-match":                {Desc: `rep, -`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"no-patch":                 {Desc: `suppress diff output`},
			"quiet":                    {Desc: `print nothing; exit status indicates if objec`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"topo-order":               {Desc: `display commits in topological order`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"same":                     {Desc: `isect, displaying shell-evalable c`},
			"date-order":               {Desc: `display commits in date order`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"any":                      {Desc: `ilter argument`},
			"no-object-names":          {Desc: `don't print the names of the object IDs that`},
			"author":                   {Desc: `limit commits to those by given author`},
			"bisect":                   {Desc: `ot refs/bise`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"milder":                   {Desc: `ull-history`},
			"text":                     {Desc: `treat all files as text`},
			"commits":                  {Desc: `rep, -`},
			"bisect-all":               {Desc: `display all commit objects between included a`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"patch":                    {Desc: `generate diff in patch format`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"limit":                    {Desc: `rep, -`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"matching":                 {Desc: `rep, -`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"i":                        {Desc: `match regexps ignoring case`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"those":                    {Desc: `rep, -`},
			"a":                        {Desc: `treat all files as text`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"off":                      {Desc: `ilter argument`},
			"version":                  {Desc: `ull-history`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"oneline":                  {Desc: `bbrev-commi`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"pretend":                  {Desc: `ot refs/bise`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"R":                        {Desc: `do a reverse diff`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"P":                        {Desc: `use perl regular expression`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"cherry":                   {Desc: `o-m`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"raw":                      {Desc: `generate default raw diff output`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"output":                   {Desc: `undocumented`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"parents":                  {Desc: `display parents of commit`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"default":                  {Desc: `use argument as default revision`},
			"filter":                   {Desc: `omit certain objects from pack file`},
			"invert-grep":              {Desc: `rep, -`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"for":                      {Desc: `bbrev-commi`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"format":                   {Desc: `pretty print commit messages`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"since":                    {Desc: `show commits more recent than given date`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"u":                        {Desc: `generate diff in patch format`},
			"before":                   {Desc: `show commits older than given date`},
			"header":                   {Desc: `display contents of commit in raw-format`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"by":                       {Desc: `ilter`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"word-diff":                {Desc: `show word diff`},
		},
	},
	"send-email": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"check-ignore": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"quiet":        {Desc: `do not output anything, just set exit status`},
			"q":            {Desc: `do not output anything, just set exit status`},
			"verbose":      {Desc: `output details about the matching pattern (if any) for`},
			"v":            {Desc: `output details about the matching pattern (if any) for`},
			"z":            {Desc: `make output format machine-parseable and treat input-pa`},
			"no-index":     {Desc: `do not look in the index when undertaking the checks`},
			"non-matching": {Desc: `show given paths which do not match any pattern`},
			"n":            {Desc: `show given paths which do not match any pattern`},
			"stdin":        {Desc: `read file names from stdin instead of from the command-`},
		},
	},
	"diff-files": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"no-min-parents":           {Desc: `reset limit`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"color":                    {Desc: `show colored diff`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"version":                  {Desc: `ull-history`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"cherry":                   {Desc: `o-m`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"no-max-parents":           {Desc: `reset limit`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"R":                        {Desc: `do a reverse diff`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"3":                        {Desc: `diff against "their branch" version`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"color-moved":              {Desc: `color moved lines differently`},
			"date-order":               {Desc: `display commits in date order`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"oneline":                  {Desc: `bbrev-commi`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"2":                        {Desc: `diff against "our branch" version`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"those":                    {Desc: `rep, -`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"no-renames":               {Desc: `turn off rename detection`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"M":                        {Desc: `detect renames with given scope`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"of":                       {Desc: `ull-history`},
			"for":                      {Desc: `bbrev-commi`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"milder":                   {Desc: `ull-history`},
			"since":                    {Desc: `show commits more recent than given date`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"simplify-merges":          {Desc: `ull-history`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"n":                        {Desc: `maximum number of commits to display`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"no-color":                 {Desc: `turn off colored diff`},
			"raw":                      {Desc: `generate default raw diff output`},
			"until":                    {Desc: `show commits older than given date`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"to":                       {Desc: `rep, -`},
			"pretend":                  {Desc: `ot refs/bise`},
			"date":                     {Desc: `format of date output`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"all-match":                {Desc: `rep, -`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"u":                        {Desc: `generate diff in patch format`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"count":                    {Desc: `display how many commits would have been list`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"output":                   {Desc: `undocumented`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"theirs":                   {Desc: `diff against "their branch" version`},
			"1":                        {Desc: `diff against "base" version`},
			"a":                        {Desc: `treat all files as text`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"children":                 {Desc: `display children of commit`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"after":                    {Desc: `show commits more recent than given date`},
			"limit":                    {Desc: `rep, -`},
			"early-output":             {Desc: `undocumented`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"merges":                   {Desc: `display only merge commits`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"bisect":                   {Desc: `ot refs/bise`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"patch":                    {Desc: `generate diff in patch format`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"all":                      {Desc: `rep, -`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"full-history":             {Desc: `do not prune history`},
			"shorthand":                {Desc: `bbrev-commi`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"p":                        {Desc: `generate diff in patch format`},
			"in":                       {Desc: `ull-index, output binary di`},
			"default":                  {Desc: `use argument as default revision`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"0":                        {Desc: `omit diff output for unmerged entries`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"topo-order":               {Desc: `display commits in topological order`},
			"word-diff":                {Desc: `show word diff`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"P":                        {Desc: `use perl regular expression`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"name-only":                {Desc: `show only names of changed files`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"no-patch":                 {Desc: `suppress diff output`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"format":                   {Desc: `pretty print commit messages`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"s":                        {Desc: `suppress diff output`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"as":                       {Desc: `ot refs/bise`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"z":                        {Desc: `use NUL termination on output`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"matching":                 {Desc: `rep, -`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"base":                     {Desc: `diff against "base" version`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"invert-grep":              {Desc: `rep, -`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"commits":                  {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"ours":                     {Desc: `diff against "our branch" version`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"i":                        {Desc: `match regexps ignoring case`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"color-words":              {Desc: `show colored-word diff`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"parents":                  {Desc: `display parents of commit`},
			"text":                     {Desc: `treat all files as text`},
			"before":                   {Desc: `show commits older than given date`},
			"if":                       {Desc: `ot refs/bise`},
		},
	},
	"branch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"delete":           {Desc: `delete a fully merged branch`},
			"merged":           {Desc: `only list branches that are fully contained by`},
			"no-color":         {Desc: `turn off branch coloring`},
			"no-column":        {Desc: `don't display in columns`},
			"points-at":        {Desc: `only list tags of the given object`},
			"M":                {Desc: `rename a branch even if the new branch-name al`},
			"create-reflog":    {Desc: `create the branch's reflog`},
			"no-contains":      {Desc: `only list branches that don't contain the spec`},
			"remotes":          {Desc: `list or delete only remote-tracking branches`},
			"D":                {Desc: `delete a branch`},
			"abbrev":           {Desc: `set minimum SHA1 display-length`},
			"list":             {Desc: `list only branches matching glob`},
			"q":                {Desc: `be more quiet`},
			"r":                {Desc: `list or delete only remote-tracking branches`},
			"set-upstream-to":  {Desc: `set up configuration so that pull merges`},
			"vv":               {Desc: `show SHA1 and commit subject line for each hea`},
			"copy":             {Desc: `copy a branch and the corresponding reflog`},
			"edit-description": {Desc: `edit branch description`},
			"l":                {Desc: `list only branches matching glob`},
			"move":             {Desc: `rename a branch and the corresponding reflog`},
			"no-abbrev":        {Desc: `don't abbreviate sha1s`},
			"color":            {Desc: `turn on branch coloring`},
			"d":                {Desc: `delete a fully merged branch`},
			"force":            {Desc: `force the creation of a new branch`},
			"quiet":            {Desc: `be more quiet`},
			"sort":             {Desc: `specify field to sort on`},
			"verbose":          {Desc: `show SHA1 and commit subject line for each hea`},
			"a":                {Desc: `list both remote-tracking branches and local b`},
			"contains":         {Desc: `only list branches that contain the specified`},
			"c":                {Desc: `copy a branch and the corresponding reflog`},
			"f":                {Desc: `force the creation of a new branch`},
			"no-track":         {Desc: `override the branch.autosetupmerge configurati`},
			"C":                {Desc: `copy a branch even if the new branch-name alre`},
			"i":                {Desc: `sorting and filtering are case-insensitive`},
			"t":                {Desc: `setup configuration so that pull merges from t`},
			"unset-upstream":   {Desc: `remove upstream configuration`},
			"column":           {Desc: `display tag listing in columns`},
			"ignore-case":      {Desc: `sorting and filtering are case-insensitive`},
			"m":                {Desc: `rename a branch and the corresponding reflog`},
			"no-merged":        {Desc: `don't list branches that are fully contained b`},
			"u":                {Desc: `set up configuration so that pull merges`},
			"show-current":     {Desc: `show current branch name`},
			"track":            {Desc: `setup configuration so that pull merges from t`},
			"v":                {Desc: `show SHA1 and commit subject line for each hea`},
		},
	},
	"ds": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"C":                        {Desc: `detect copies as well as renames with g`},
			"patch":                    {Desc: `generate diff in patch format`},
			"full-index":               {Desc: `show full object name of pre- and post-`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"in":                       {Desc: `ull-index, output bin`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"u":                        {Desc: `generate diff in patch format`},
			"p":                        {Desc: `generate diff in patch format`},
			"3":                        {Desc: `diff against "their branch" version`},
			"U":                        {Desc: `generate diff with given lines of conte`},
			"find-copies":              {Desc: `detect copies as well as renames with g`},
			"line-prefix":              {Desc: `prepend additional prefix to every line`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove bl`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the inde`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"s":                        {Desc: `suppress diff output`},
			"output":                   {Desc: `undocumented`},
			"theirs":                   {Desc: `diff against "their branch" version`},
			"R":                        {Desc: `do a reverse diff`},
			"color-moved":              {Desc: `color moved lines differently`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new`},
			"summary":                  {Desc: `generate condensed summary of extended`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph wi`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff`},
			"B":                        {Desc: `break complete rewrite changes into pai`},
			"no-patch":                 {Desc: `suppress diff output`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"unified":                  {Desc: `generate diff with given lines of conte`},
			"0":                        {Desc: `omit diff output for unmerged entries`},
			"to":                       {Desc: `ull-index, output bin`},
			"find-object":              {Desc: `look for differences that change the nu`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"z":                        {Desc: `use NUL termination on output`},
			"follow":                   {Desc: `continue listing the history of a file`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"check":                    {Desc: `warn if changes introduce trailing whit`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 ot`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk`},
			"2":                        {Desc: `diff against "our branch" version`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"ext-diff":                 {Desc: `allow external diff helper to be execut`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular express`},
			"for":                      {Desc: `irstat=cumulative`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace e`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing`},
			"no-textconv":              {Desc: `do not allow external text conversion f`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"quiet":                    {Desc: `disable all output`},
			"1":                        {Desc: `diff against "base" version`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all change`},
			"raw":                      {Desc: `generate default raw diff output`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"name-only":                {Desc: `show only names of changed files`},
			"relative":                 {Desc: `exclude changes outside and output rela`},
			"textconv":                 {Desc: `allow external text conversion filters`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of`},
			"no-prefix":                {Desc: `do not show any source or destination p`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"G":                        {Desc: `look for differences whose added or rem`},
			"O":                        {Desc: `output patch in the order of glob-patte`},
			"color":                    {Desc: `show colored diff`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be exe`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored whe`},
			"name-status":              {Desc: `show only names and status of changed f`},
			"ours":                     {Desc: `diff against "our branch" version`},
			"addition":                 {Desc: `ull-index, output bin`},
			"no-color":                 {Desc: `turn off colored diff`},
			"output-indicator-context": {Desc: `specify the character to indicate a con`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"no-renames":               {Desc: `turn off rename detection`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"minimal":                  {Desc: `spend extra time to make sure the small`},
			"binary":                   {Desc: `ull-index, output bin`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"submodule":                {Desc: `select output format for submodule diff`},
			"text":                     {Desc: `treat all files as text`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defaul`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"base":                     {Desc: `diff against "base" version`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"color-words":              {Desc: `show colored-word diff`},
			"M":                        {Desc: `detect renames with given scope`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"l":                        {Desc: `limit number of rename/copy targets to`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pai`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"a":                        {Desc: `treat all files as text`},
			"word-diff":                {Desc: `show word diff`},
			"S":                        {Desc: `look for differences that add or remove`},
		},
	},
	"fast-import": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"ls-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"abbrev":      {Desc: `set minimum SHA1 display-length`},
			"full-name":   {Desc: `output full path-names`},
			"l":           {Desc: `show object size of blob entries`},
			"d":           {Desc: `do not show children of given tree (implies -t)`},
			"r":           {Desc: `recurse into subdirectories`},
			"t":           {Desc: `show tree entries even when going to recurse th`},
			"z":           {Desc: `use NUL termination on output`},
			"full-tree":   {Desc: `do not limit listing to current working-directo`},
			"long":        {Desc: `show object size of blob entries`},
			"name-status": {Desc: `list only filenames, one per line`},
			"name-only":   {Desc: `list only filenames, one per line`},
		},
	},
	"merge-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"read-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"m":                  {Desc: `perform a merge, not just a read`},
			"q":                  {Desc: `suppress feedback messages`},
			"recurse-submodules": {Desc: `control recursive updating of submodules`},
			"reset":              {Desc: `perform a merge, not just a read, ignoring unmerg`},
			"no-sparse-checkout": {Desc: `display sparse checkout support`},
			"prefix":             {Desc: `read the contents of specified tree-ish under spe`},
			"quiet":              {Desc: `suppress feedback messages`},
			"v":                  {Desc: `display progress on standard error`},
			"debug-unpack":       {Desc: `debug unpack-trees`},
			"empty":              {Desc: `instead of reading tree object(s) into the index,`},
			"index-output":       {Desc: `write index in the named file instead of $GIT_IND`},
		},
	},
	"update-index": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"help":                  {Desc: `display usage information`},
			"ignore-submodules":     {Desc: `do not try to update submodules`},
			"stdin":                 {Desc: `read list of paths from standard input`},
			"fsmonitor":             {Desc: `enable or disable file system monitor`},
			"no-skip-worktree":      {Desc: `unset "skip-worktree" bit for given paths`},
			"unmerged":              {Desc: `if unmerged changes exists, ignore them instea`},
			"unresolve":             {Desc: `restore "unmerged" or "needs updating" state o`},
			"no-fsmonitor-valid":    {Desc: `clear fsmonitor valid bit`},
			"index-info":            {Desc: `read index information from stdin`},
			"remove":                {Desc: `remove files that are in the index but are mis`},
			"add":                   {Desc: `add files not already in index`},
			"test-untracked-cache":  {Desc: `test if the filesystem supports untracked cach`},
			"refresh":               {Desc: `refresh index`},
			"cacheinfo":             {Desc: `insert information directly into the cache`},
			"no-assume-unchanged":   {Desc: `unset "assume unchanged" bit for given paths`},
			"skip-worktree":         {Desc: `set "skip-worktree" bit for given paths`},
			"split-index":           {Desc: `enable/disable split index`},
			"assume-unchanged":      {Desc: `set "assume unchanged" bit for given paths`},
			"force-remove":          {Desc: `remove named paths even if present in worktree`},
			"fsmonitor-valid":       {Desc: `mark files as fsmonitor valid`},
			"info-only":             {Desc: `only insert files object-IDs into index`},
			"really-refresh":        {Desc: `refresh index, unconditionally checking stat i`},
			"verbose":               {Desc: `report what is being added and removed from th`},
			"chmod":                 {Desc: `set execute permissions on updated files`},
			"clear-resolve-undo":    {Desc: `forget saved unresolved conflicts`},
			"force-write-index":     {Desc: `write out the index even if is not flagged as`},
			"h":                     {Desc: `display usage information`},
			"q":                     {Desc: `continue refresh even when index needs update`},
			"again":                 {Desc: `run git-update-index on differing index entrie`},
			"force-untracked-cache": {Desc: `enable untracked cache without testing the fil`},
			"ignore-missing":        {Desc: `ignore missing files when refreshing the index`},
			"index-version":         {Desc: `write index in specified on-disk format versio`},
			"replace":               {Desc: `replace files already in index, if necessary`},
			"untracked-cache":       {Desc: `enable/disable untracked cache`},
			"g":                     {Desc: `run git-update-index on differing index entrie`},
		},
	},
	"add": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"no-ignore-removal": {Desc: `add, modify, and remove index entries to`},
			"patch":             {Desc: `like -i but go directly into patch mode`},
			"u":                 {Desc: `update the index just where it already h`},
			"i":                 {Desc: `add contents interactively to index`},
			"no-all":            {Desc: `ll" but ignore removals`},
			"intent-to-add":     {Desc: `record only that path will be added late`},
			"verbose":           {Desc: `show files as they are added`},
			"ignore-removal":    {Desc: `ll" but ignore removals`},
			"force":             {Desc: `allow adding otherwise ignored files`},
			"ignore-errors":     {Desc: `continue adding if an error occurs`},
			"N":                 {Desc: `record only that path will be added late`},
			"refresh":           {Desc: `do not add files, but refresh their stat`},
			"dry-run":           {Desc: `do not actually add files; only show whi`},
			"interactive":       {Desc: `add contents interactively to index`},
			"p":                 {Desc: `like -i but go directly into patch mode`},
			"e":                 {Desc: `open diff against index in editor`},
			"edit":              {Desc: `open diff against index in editor`},
			"f":                 {Desc: `allow adding otherwise ignored files`},
			"update":            {Desc: `update the index just where it already h`},
			"n":                 {Desc: `do not actually add files; only show whi`},
			"like":              {Desc: `ll" but ignore removals`},
			"v":                 {Desc: `show files as they are added`},
			"chmod":             {Desc: `override the executable bit of the liste`},
			"renormalize":       {Desc: `renormalize EOL of tracked files (implie`},
			"all":               {Desc: `add, modify, and remove index entries to`},
			"A":                 {Desc: `add, modify, and remove index entries to`},
		},
	},
	"commit": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"no-ahead-behind":     {Desc: `don't display detailed ahead/behind counts`},
			"status":              {Desc: `include the output of git status in the com`},
			"amend":               {Desc: `amend the tip of the current branch`},
			"reedit-message":      {Desc: `use existing commit object and edit log mes`},
			"C":                   {Desc: `use existing commit object with same log me`},
			"template":            {Desc: `use file as a template commit message`},
			"e":                   {Desc: `edit the commit message before committing`},
			"v":                   {Desc: `show unified diff of all file changes`},
			"m":                   {Desc: `use the given message as the commit message`},
			"a":                   {Desc: `stage all modified and deleted paths`},
			"author":              {Desc: `override the author name used in the commit`},
			"edit":                {Desc: `edit the commit message before committing`},
			"p":                   {Desc: `use the interactive patch selection interfa`},
			"c":                   {Desc: `use existing commit object and edit log mes`},
			"reuse-message":       {Desc: `use existing commit object with same log me`},
			"squash":              {Desc: `construct a commit message for use with reb`},
			"gpg-sign":            {Desc: `GPG-sign the commit`},
			"interactive":         {Desc: `interactively update paths in the index fil`},
			"no-post-rewrite":     {Desc: `bypass the post-rewrite hook`},
			"patch":               {Desc: `use the interactive patch selection interfa`},
			"quiet":               {Desc: `suppress commit summary message`},
			"no-status":           {Desc: `do not include the output of git status in`},
			"z":                   {Desc: `dry run with NULL-separated output format`},
			"signoff":             {Desc: `add Signed-off-by line at the end of the co`},
			"verbose":             {Desc: `show unified diff of all file changes`},
			"null":                {Desc: `dry run with NULL-separated output format`},
			"o":                   {Desc: `commit only the given files`},
			"porcelain":           {Desc: `dry run with machine-readable output format`},
			"cleanup":             {Desc: `specify how the commit message should be cl`},
			"F":                   {Desc: `read commit message from given file`},
			"u":                   {Desc: `show files in untracked directories`},
			"only":                {Desc: `commit only the given files`},
			"short":               {Desc: `dry run with short output format`},
			"t":                   {Desc: `use file as a template commit message`},
			"n":                   {Desc: `bypass pre-commit and commit-msg hooks`},
			"allow-empty-message": {Desc: `allow recording a commit with an empty mess`},
			"branch":              {Desc: `show branch information`},
			"date":                {Desc: `override the author date used in the commit`},
			"dry-run":             {Desc: `only show list of paths that are to be comm`},
			"q":                   {Desc: `suppress commit summary message`},
			"file":                {Desc: `read commit message from given file`},
			"S":                   {Desc: `GPG-sign the commit`},
			"include":             {Desc: `update the given files and commit the whole`},
			"i":                   {Desc: `update the given files and commit the whole`},
			"message":             {Desc: `use the given message as the commit message`},
			"no-verify":           {Desc: `bypass pre-commit and commit-msg hooks`},
			"allow-empty":         {Desc: `allow recording an empty commit`},
			"no-edit":             {Desc: `do not edit the commit message before commi`},
			"s":                   {Desc: `add Signed-off-by line at the end of the co`},
			"all":                 {Desc: `stage all modified and deleted paths`},
			"no-gpg-sign":         {Desc: `don't GPG-sign the commit`},
			"fixup":               {Desc: `construct a commit message for use with reb`},
			"untracked-files":     {Desc: `show files in untracked directories`},
		},
	},
	"cvsexportcommit": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"a": {Desc: `add authorship information`},
			"f": {Desc: `force the merge, even if files are not up to date`},
			"m": {Desc: `prepend the commit message with the provided prefix`},
			"p": {Desc: `be pedantic (paranoid) when applying patches`},
			"u": {Desc: `update affected files from CVS repository before attempting export`},
			"W": {Desc: `use current working directory for bot Git and CVS checkout`},
			"c": {Desc: `commit automatically if patch applied cleanly`},
			"d": {Desc: `set an alternative CVSROOT to use`},
			"h": {Desc: `display usage`},
			"k": {Desc: `reverse CVS keyword expansion`},
			"v": {Desc: `verbose output`},
			"w": {Desc: `specify location of CVS checkout to use for export`},
			"P": {Desc: `force the parent commit, even if it is not a direct parent`},
		},
	},
	"gst": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"http-push": {Desc: "", Sub: map[string]*complete.CompTree{"file:": {Desc: "file:      ftp://     gopher://  http://    https://", Sub: map[string]*complete.CompTree{}}},
		Flags: map[string]*complete.CompTree{
			"all":     {Desc: `verify that all objects in local ref history exist remotely`},
			"dry-run": {Desc: `do everything except actually sending the updates`},
			"force":   {Desc: `allow refs that are not ancestors to be updated`},
			"verbose": {Desc: `report the list of objects being walked locally and sent to re`},
			"D":       {Desc: `forcefully remove refs from remote repository`},
			"d":       {Desc: `remove refs from remote repository`},
		},
	},
	"merge": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"no-commit":                 {Desc: `perform the merge but do not commit the re`},
			"no-squash":                 {Desc: `merge and commit`},
			"no-verify":                 {Desc: `verify commit-msg hook`},
			"X":                         {Desc: `pass merge-strategy-specific option to mer`},
			"gpg-sign":                  {Desc: `GPG-sign the commit`},
			"message":                   {Desc: `set the commit message to be used for the`},
			"strategy-option":           {Desc: `pass merge-strategy-specific option to mer`},
			"commit":                    {Desc: `perform the merge and commit the result`},
			"no-ff":                     {Desc: `generate a merge commit even if the merge`},
			"no-gpg-sign":               {Desc: `don't GPG-sign the commit`},
			"n":                         {Desc: `do not show diffstat at the end of the mer`},
			"q":                         {Desc: `suppress all output`},
			"stat":                      {Desc: `show a diffstat at the end of the merge`},
			"s":                         {Desc: `use given merge strategy`},
			"continue":                  {Desc: `continue the current in-progress merge`},
			"file":                      {Desc: `read commit message from a file`},
			"F":                         {Desc: `read commit message from a file`},
			"log":                       {Desc: `add entries from shortlog to merge commit`},
			"quit":                      {Desc: `bort but leave index and working tree a`},
			"verbose":                   {Desc: `output additional information`},
			"abort":                     {Desc: `restore the original branch and abort the`},
			"m":                         {Desc: `set the commit message to be used for the`},
			"no-rerere-autoupdate":      {Desc: `do not allow the rerere mechanism to updat`},
			"no-stat":                   {Desc: `do not show diffstat at the end of the mer`},
			"squash":                    {Desc: `merge, but do not commit`},
			"ff":                        {Desc: `do not generate a merge commit if the merg`},
			"e":                         {Desc: `open an editor to change the commit messag`},
			"no-edit":                   {Desc: `don't open an editor to change the commit`},
			"no-verify-signatures":      {Desc: `do not verify the commits being merged`},
			"v":                         {Desc: `output additional information`},
			"cleanup":                   {Desc: `specify how to strip spaces and #comments`},
			"edit":                      {Desc: `open an editor to change the commit messag`},
			"S":                         {Desc: `GPG-sign the commit`},
			"no-log":                    {Desc: `do not list one-line descriptions of the c`},
			"progress":                  {Desc: `force progress reporting`},
			"rerere-autoupdate":         {Desc: `allow the rerere mechanism to update the i`},
			"signoff":                   {Desc: `add Signed-off-by:`},
			"strategy":                  {Desc: `use given merge strategy`},
			"allow-unrelated-histories": {Desc: `allow merging unrelated histories`},
			"quiet":                     {Desc: `suppress all output`},
			"verify-signatures":         {Desc: `verify the commits being merged or abort`},
			"ff-only":                   {Desc: `refuse to merge unless HEAD is up to date`},
		},
	},
	"merge-file": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"q":           {Desc: `do not warn about conflicts`},
			"p":           {Desc: `send merged file to standard output instead of overwriti`},
			"theirs":      {Desc: `resolve conflicts favoring their side of the lines`},
			"ours":        {Desc: `resolve conflicts favoring our side of the lines`},
			"quiet":       {Desc: `do not warn about conflicts`},
			"stdout":      {Desc: `send merged file to standard output instead of overwriti`},
			"union":       {Desc: `resolve conflicts favoring both sides of the lines`},
			"L":           {Desc: `label to use for the first file`},
			"diff3":       {Desc: `use a diff3 based merge`},
			"marker-size": {Desc: `specify length of conflict markers`},
		},
	},
	"push": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"exec":                {Desc: `path to git-receive-pack on remote`},
			"set-upstream":        {Desc: `add upstream reference for each branch that`},
			"signed":              {Desc: `GPG sign the push`},
			"thin":                {Desc: `try to minimize number of objects to be sent`},
			"4":                   {Desc: `use IPv4 addresses only`},
			"ipv6":                {Desc: `use IPv6 addresses only`},
			"porcelain":           {Desc: `produce machine-readable output`},
			"receive-pack":        {Desc: `path to git-receive-pack on remote`},
			"f":                   {Desc: `allow refs that are not ancestors to be upda`},
			"no-thin":             {Desc: `do not try to minimize number of objects to`},
			"no-signed":           {Desc: `don't GPG sign the push`},
			"dry-run":             {Desc: `do everything except actually send the updat`},
			"force":               {Desc: `allow refs that are not ancestors to be upda`},
			"force-with-lease":    {Desc: `allow refs that are not ancestors to be upda`},
			"no-force-with-lease": {Desc: `cancel all previous force-with-lease specifi`},
			"v":                   {Desc: `output additional information`},
			"6":                   {Desc: `use IPv6 addresses only`},
			"progress":            {Desc: `output progress information`},
			"o":                   {Desc: `transmit string to server to pass to pre/pos`},
			"repo":                {Desc: `default repository to use`},
			"delete":              {Desc: `delete all listed refs from the remote repos`},
			"n":                   {Desc: `do everything except actually send the updat`},
			"ipv4":                {Desc: `use IPv4 addresses only`},
			"sign":                {Desc: `GPG sign the push`},
			"follow-tags":         {Desc: `also push missing annotated tags reachable f`},
			"quiet":               {Desc: `suppress all output`},
			"verbose":             {Desc: `output additional information`},
			"atomic":              {Desc: `request atomic transaction on remote side`},
			"d":                   {Desc: `delete all listed refs from the remote repos`},
			"prune":               {Desc: `remove remote branches that do not have a lo`},
			"push-option":         {Desc: `transmit string to server to pass to pre/pos`},
			"recurse-submodules":  {Desc: `submodule handling`},
			"u":                   {Desc: `add upstream reference for each branch that`},
			"tags":                {Desc: `all tags under refs/tags are pushed`},
			"all":                 {Desc: `push all refs under refs/heads/`},
			"mirror":              {Desc: `push all refs under refs/heads/ and refs/tag`},
			"no-verify":           {Desc: `bypass the pre-push hook`},
			"q":                   {Desc: `suppress all output`},
		},
	},
	"am": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"ignore-whitespace":             {Desc: `ignore changes in whitespace in contex`},
			"no-utf8":                       {Desc: `pass -n to git mailinfo`},
			"reject":                        {Desc: `apply hunks that apply and leave rejec`},
			"show-current-patch":            {Desc: `show the patch being applied`},
			"p":                             {Desc: `remove N leading slashes from traditio`},
			"3":                             {Desc: `use 3-way merge if patch does not appl`},
			"committer-date-is-author-date": {Desc: `use author date as committer date`},
			"ignore-date":                   {Desc: `use committer date as author date`},
			"no-gpg-sign":                   {Desc: `don't GPG-sign the commit`},
			"patch-format":                  {Desc: `specify format patches are in`},
			"skip":                          {Desc: `skip the current patch`},
			"k":                             {Desc: `pass -k to git mailinfo`},
			"m":                             {Desc: `pass -m flag to git-mailinfo`},
			"no-keep-cr":                    {Desc: `eep-cr to git mailsplit`},
			"quiet":                         {Desc: `only print error messages`},
			"s":                             {Desc: `add Signed-off-by: line to the commit`},
			"abort":                         {Desc: `restore the original branch and abort`},
			"directory":                     {Desc: `root to prepend to all filenames`},
			"i":                             {Desc: `apply patches interactively`},
			"keep":                          {Desc: `pass -k to git mailinfo`},
			"quit":                          {Desc: `abort the patching operation but keep`},
			"c":                             {Desc: `strip everything before a scissors lin`},
			"resolved":                      {Desc: `continue after resolving patch failure`},
			"exclude":                       {Desc: `skip files matching specified pattern`},
			"include":                       {Desc: `include files matching specified patte`},
			"pass":                          {Desc: `eep-cr to git mailsplit`},
			"not":                           {Desc: `eep-cr to git mailsplit`},
			"gpg-sign":                      {Desc: `GPG-sign the commit`},
			"message-id":                    {Desc: `pass -m flag to git-mailinfo`},
			"scissors":                      {Desc: `strip everything before a scissors lin`},
			"utf8":                          {Desc: `pass -u to git mailinfo`},
			"interactive":                   {Desc: `apply patches interactively`},
			"keep-cr":                       {Desc: `eep-cr to git mailsplit`},
			"keep-non-patch":                {Desc: `pass -b to git mailinfo`},
			"no-scissors":                   {Desc: `ignore scissors lines`},
			"whitespace":                    {Desc: `detect a new or modified line that end`},
			"C":                             {Desc: `ensure at least N lines of context mat`},
			"3way":                          {Desc: `use 3-way merge if patch does not appl`},
			"S":                             {Desc: `GPG-sign the commit`},
			"do":                            {Desc: `eep-cr to git mailsplit`},
			"q":                             {Desc: `only print error messages`},
			"signoff":                       {Desc: `add Signed-off-by: line to the commit`},
			"u":                             {Desc: `pass -u to git mailinfo`},
		},
	},
	"stash": {Desc: "", Sub: map[string]*complete.CompTree{"list": {Desc: "list the stashes that you currently have", Sub: map[string]*complete.CompTree{}},
		"pop":    {Desc: "remove and apply a single stashed state from the stash list", Sub: map[string]*complete.CompTree{}},
		"create": {Desc: "create a stash without storing it in the ref namespace", Sub: map[string]*complete.CompTree{}},
		"drop":   {Desc: "remove a single stashed state from the stash list", Sub: map[string]*complete.CompTree{}},
		"save":   {Desc: "save your local modifications to a new stash", Sub: map[string]*complete.CompTree{}},
		"show":   {Desc: "show the changes recorded in the stash as a diff", Sub: map[string]*complete.CompTree{}},
		"apply":  {Desc: "apply the changes recorded in the stash", Sub: map[string]*complete.CompTree{}},
		"branch": {Desc: "branch off at the commit at which the stash was originally cr", Sub: map[string]*complete.CompTree{}},
		"clear":  {Desc: "remove all the stashed states", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"include-untracked": {Desc: `include untracked files`},
			"u":                 {Desc: `include untracked files`},
			"keep-index":        {Desc: `all changes already added to the index are left in`},
			"k":                 {Desc: `all changes already added to the index are left in`},
			"message":           {Desc: `specify stash description`},
			"m":                 {Desc: `specify stash description`},
			"no-keep-index":     {Desc: `all changes already added to the index are undone`},
			"a":                 {Desc: `include ignored files`},
			"p":                 {Desc: `interactively select hunks from diff between HEAD`},
			"q":                 {Desc: `suppress all output`},
			"patch":             {Desc: `interactively select hunks from diff between HEAD`},
			"quiet":             {Desc: `suppress all output`},
			"all":               {Desc: `include ignored files`},
		},
	},
	"worktree": {Desc: "", Sub: map[string]*complete.CompTree{"list": {Desc: "list details of each worktree", Sub: map[string]*complete.CompTree{}},
		"lock":   {Desc: "prevent a working tree from being pruned", Sub: map[string]*complete.CompTree{}},
		"move":   {Desc: "move a working tree to a new location", Sub: map[string]*complete.CompTree{}},
		"prune":  {Desc: "prune working tree information", Sub: map[string]*complete.CompTree{}},
		"remove": {Desc: "remove a working tree", Sub: map[string]*complete.CompTree{}},
		"unlock": {Desc: "allow working tree to be pruned, moved or deleted", Sub: map[string]*complete.CompTree{}},
		"add":    {Desc: "create a new working tree", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"rerere": {Desc: "", Sub: map[string]*complete.CompTree{"gc": {Desc: "prune old records of conflicted merges", Sub: map[string]*complete.CompTree{}},
		"remaining": {Desc: "print paths with conflicts that have not been autoresolved by", Sub: map[string]*complete.CompTree{}},
		"status":    {Desc: "print paths with conflicts whose merge resolution rerere will", Sub: map[string]*complete.CompTree{}},
		"clear":     {Desc: "reset metadata used by rerere", Sub: map[string]*complete.CompTree{}},
		"diff":      {Desc: "output diffs for the current state of the resolution", Sub: map[string]*complete.CompTree{}},
		"forget":    {Desc: "resets metadata used by rerere for specific conflict", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{},
	},
	"log": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"source":                   {Desc: `show which ref each commit is reached from`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"default":                  {Desc: `use argument as default revision`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"parents":                  {Desc: `display parents of commit`},
			"text":                     {Desc: `treat all files as text`},
			"color-words":              {Desc: `show colored-word diff`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"all":                      {Desc: `rep, -`},
			"for":                      {Desc: `bbrev-commi`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"color-moved":              {Desc: `color moved lines differently`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"output":                   {Desc: `undocumented`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"n":                        {Desc: `maximum number of commits to display`},
			"p":                        {Desc: `generate diff in patch format`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"pretend":                  {Desc: `ot refs/bise`},
			"full-history":             {Desc: `do not prune history`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"count":                    {Desc: `display how many commits would have been list`},
			"simplify-merges":          {Desc: `ull-history`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"topo-order":               {Desc: `display commits in topological order`},
			"commits":                  {Desc: `rep, -`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"no-max-parents":           {Desc: `reset limit`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"no-decorate":              {Desc: `do not print out ref names of any commits tha`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"h":                        {Desc: `display help`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"no-follow":                {Desc: `do not follow renames`},
			"matching":                 {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"in":                       {Desc: `ull-index, output binary di`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"cherry":                   {Desc: `o-m`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"format":                   {Desc: `pretty print commit messages`},
			"oneline":                  {Desc: `bbrev-commi`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"date":                     {Desc: `format of date output`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"before":                   {Desc: `show commits older than given date`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"if":                       {Desc: `ot refs/bise`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"P":                        {Desc: `use perl regular expression`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"version":                  {Desc: `ull-history`},
			"all-match":                {Desc: `rep, -`},
			"merges":                   {Desc: `display only merge commits`},
			"no-color":                 {Desc: `turn off colored diff`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"until":                    {Desc: `show commits older than given date`},
			"those":                    {Desc: `rep, -`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"word-diff":                {Desc: `show word diff`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"date-order":               {Desc: `display commits in date order`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"z":                        {Desc: `use NUL termination on output`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"raw":                      {Desc: `generate default raw diff output`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"u":                        {Desc: `generate diff in patch format`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"a":                        {Desc: `treat all files as text`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"name-only":                {Desc: `show only names of changed files`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"R":                        {Desc: `do a reverse diff`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"patch":                    {Desc: `generate diff in patch format`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"children":                 {Desc: `display children of commit`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"as":                       {Desc: `ot refs/bise`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"shorthand":                {Desc: `bbrev-commi`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"decorate":                 {Desc: `print out ref names of any commits that are s`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"no-patch":                 {Desc: `suppress diff output`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"color":                    {Desc: `show colored diff`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"after":                    {Desc: `show commits more recent than given date`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"limit":                    {Desc: `rep, -`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"s":                        {Desc: `suppress diff output`},
			"invert-grep":              {Desc: `rep, -`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"i":                        {Desc: `match regexps ignoring case`},
			"early-output":             {Desc: `undocumented`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"bisect":                   {Desc: `ot refs/bise`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"of":                       {Desc: `ull-history`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"no-min-parents":           {Desc: `reset limit`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"no-renames":               {Desc: `turn off rename detection`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"to":                       {Desc: `rep, -`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"milder":                   {Desc: `ull-history`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"since":                    {Desc: `show commits more recent than given date`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"M":                        {Desc: `detect renames with given scope`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
		},
	},
	"mktree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"batch":   {Desc: `allow creation of more than one tree`},
			"missing": {Desc: `allow missing objects`},
			"z":       {Desc: `read NUL-terminated ls-tree -z output`},
		},
	},
	"parse-remote": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"svn": {Desc: "", Sub: map[string]*complete.CompTree{"branch": {Desc: "create a branch in the SVN repository", Sub: map[string]*complete.CompTree{}},
		"dcommit":        {Desc: "commit diffs from given head onto SVN repository", Sub: map[string]*complete.CompTree{}},
		"init":           {Desc: "initialize an empty git repository with additional svn da", Sub: map[string]*complete.CompTree{}},
		"propset":        {Desc: "set the value of a property on a file or directory - will", Sub: map[string]*complete.CompTree{}},
		"show-ignore":    {Desc: "output svn:ignore in format of a toplevel .gitignore file", Sub: map[string]*complete.CompTree{}},
		"commit-diff":    {Desc: "commit diff of two tree-ishs", Sub: map[string]*complete.CompTree{}},
		"find-rev":       {Desc: "output git commit corresponding to the given SVN revision", Sub: map[string]*complete.CompTree{}},
		"info":           {Desc: "show information about a file or directory", Sub: map[string]*complete.CompTree{}},
		"mkdirs":         {Desc: "recreate empty directories that Git cannot track", Sub: map[string]*complete.CompTree{}},
		"propget":        {Desc: "get a given SVN property for a file", Sub: map[string]*complete.CompTree{}},
		"show-externals": {Desc: "show the subversion externals", Sub: map[string]*complete.CompTree{}},
		"gc":             {Desc: "compress git-svn-related information", Sub: map[string]*complete.CompTree{}},
		"migrate":        {Desc: "migrate configuration/metadata/layout from previous versi", Sub: map[string]*complete.CompTree{}},
		"proplist":       {Desc: "list the SVN properties stored for a file or directory", Sub: map[string]*complete.CompTree{}},
		"rebase":         {Desc: "fetch revs from SVN parent of HEAD and rebase current wor", Sub: map[string]*complete.CompTree{}},
		"set-tree":       {Desc: "commit given commit or tree to SVN repository", Sub: map[string]*complete.CompTree{}},
		"blame":          {Desc: "show what revision and author last modified each line of", Sub: map[string]*complete.CompTree{}},
		"clone":          {Desc: "same as init, followed by fetch", Sub: map[string]*complete.CompTree{}},
		"create-ignore":  {Desc: "recursively finds the svn:ignore property and creates .gi", Sub: map[string]*complete.CompTree{}},
		"fetch":          {Desc: "fetch revisions from the SVN remote", Sub: map[string]*complete.CompTree{}},
		"log":            {Desc: "output SVN log-messages", Sub: map[string]*complete.CompTree{}},
		"reset":          {Desc: "undo effect of fetch back to specific revision", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"help":    {Desc: `display usage information`},
			"H":       {Desc: `display usage information`},
			"h":       {Desc: `display usage information`},
			"version": {Desc: `display version information`},
			"V":       {Desc: `display version information`},
		},
	},
	"symbolic-ref": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"q":      {Desc: `do not issue error if specified name is not a symbolic ref`},
			"short":  {Desc: `shorten the ref name (eg. refs/heads/master -> master)`},
			"m":      {Desc: `update reflog for specified name with specified reason`},
			"delete": {Desc: `delete symbolic ref`},
			"d":      {Desc: `delete symbolic ref`},
			"quiet":  {Desc: `do not issue error if specified name is not a symbolic ref`},
		},
	},
	"verify-tag": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"format":  {Desc: `specify format to use for the output`},
			"raw":     {Desc: `print raw gpg status output`},
			"verbose": {Desc: `print contents of the tag object before validating it`},
			"v":       {Desc: `print contents of the tag object before validating it`},
		},
	},
	"init": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"bare":             {Desc: `create a bare repository`},
			"quiet":            {Desc: `do not print any results to stdout`},
			"q":                {Desc: `do not print any results to stdout`},
			"separate-git-dir": {Desc: `create git dir elsewhere and link it using the gitd`},
			"shared":           {Desc: `share repository amongst several users`},
			"template":         {Desc: `directory to use as a template for the object datab`},
		},
	},
	"revert": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"continue":          {Desc: `resume revert or cherry-pick sequence`},
			"S":                 {Desc: `GPG-sign the commit`},
			"quit":              {Desc: `end revert or cherry-pick sequence`},
			"rerere-autoupdate": {Desc: `update the index with reused conflict resolution i`},
			"strategy":          {Desc: `use given merge strategy`},
			"strategy-option":   {Desc: `pass merge-strategy-specific option to merge strat`},
			"cleanup":           {Desc: `specify how to strip spaces and #comments from mes`},
			"mainline":          {Desc: `pick which parent is mainline`},
			"n":                 {Desc: `do not commit the reversion`},
			"signoff":           {Desc: `add Signed-off-by line at the end of the commit me`},
			"skip":              {Desc: `skip current commit and continue`},
			"X":                 {Desc: `pass merge-strategy-specific option to merge strat`},
			"edit":              {Desc: `edit the commit before committing the revert`},
			"e":                 {Desc: `edit the commit before committing the revert`},
			"gpg-sign":          {Desc: `GPG-sign the commit`},
			"m":                 {Desc: `pick which parent is mainline`},
			"no-commit":         {Desc: `do not commit the reversion`},
			"no-gpg-sign":       {Desc: `don't GPG-sign the commit`},
			"abort":             {Desc: `cancel revert or cherry-pick sequence`},
			"no-edit":           {Desc: `do not edit the commit message before committing t`},
			"s":                 {Desc: `add Signed-off-by line at the end of the commit me`},
		},
	},
	"show": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"L":                        {Desc: `trace the evolution of a line range or regex`},
			"no-decorate":              {Desc: `do not print out ref names of any commits tha`},
			"no-min-parents":           {Desc: `reset limit`},
			"text":                     {Desc: `treat all files as text`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"cherry":                   {Desc: `o-m`},
			"children":                 {Desc: `display children of commit`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"invert-grep":              {Desc: `rep, -`},
			"merges":                   {Desc: `display only merge commits`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"as":                       {Desc: `ot refs/bise`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"date-order":               {Desc: `display commits in date order`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"pretend":                  {Desc: `ot refs/bise`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"default":                  {Desc: `use argument as default revision`},
			"no-patch":                 {Desc: `suppress diff output`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"version":                  {Desc: `ull-history`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"author":                   {Desc: `limit commits to those by given author`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"commits":                  {Desc: `rep, -`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"decorate":                 {Desc: `print out ref names of any commits that are s`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"if":                       {Desc: `ot refs/bise`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"bisect":                   {Desc: `ot refs/bise`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"milder":                   {Desc: `ull-history`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"in":                       {Desc: `ull-index, output binary di`},
			"since":                    {Desc: `show commits more recent than given date`},
			"M":                        {Desc: `detect renames with given scope`},
			"all-match":                {Desc: `rep, -`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"limit":                    {Desc: `rep, -`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"s":                        {Desc: `suppress diff output`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"name-only":                {Desc: `show only names of changed files`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"h":                        {Desc: `display help`},
			"decorate-refs":            {Desc: `only decorate refs that match pattern`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"i":                        {Desc: `match regexps ignoring case`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"source":                   {Desc: `show which ref each commit is reached from`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"no-color":                 {Desc: `turn off colored diff`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"decorate-refs-exclude":    {Desc: `don't decorate refs that match pattern`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"matching":                 {Desc: `rep, -`},
			"quiet":                    {Desc: `suppress diff output`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"p":                        {Desc: `generate diff in patch format`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"topo-order":               {Desc: `display commits in topological order`},
			"word-diff":                {Desc: `show word diff`},
			"full-history":             {Desc: `do not prune history`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"count":                    {Desc: `display how many commits would have been list`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"color-moved":              {Desc: `color moved lines differently`},
			"until":                    {Desc: `show commits older than given date`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"a":                        {Desc: `treat all files as text`},
			"n":                        {Desc: `maximum number of commits to display`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"those":                    {Desc: `rep, -`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"no-max-parents":           {Desc: `reset limit`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"parents":                  {Desc: `display parents of commit`},
			"color":                    {Desc: `show colored diff`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"z":                        {Desc: `use NUL termination on output`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"all":                      {Desc: `rep, -`},
			"before":                   {Desc: `show commits older than given date`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"oneline":                  {Desc: `bbrev-commi`},
			"patch":                    {Desc: `generate diff in patch format`},
			"date":                     {Desc: `format of date output`},
			"shorthand":                {Desc: `bbrev-commi`},
			"q":                        {Desc: `suppress diff output`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"output":                   {Desc: `undocumented`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"simplify-merges":          {Desc: `ull-history`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"P":                        {Desc: `use perl regular expression`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"of":                       {Desc: `ull-history`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"after":                    {Desc: `show commits more recent than given date`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"format":                   {Desc: `pretty print commit messages`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"early-output":             {Desc: `undocumented`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"to":                       {Desc: `rep, -`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"no-renames":               {Desc: `turn off rename detection`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"no-follow":                {Desc: `do not follow renames`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"R":                        {Desc: `do a reverse diff`},
			"u":                        {Desc: `generate diff in patch format`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"for":                      {Desc: `bbrev-commi`},
			"color-words":              {Desc: `show colored-word diff`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"raw":                      {Desc: `generate default raw diff output`},
			"G":                        {Desc: `look for differences whose added or removed l`},
		},
	},
	"cp": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"allow-empty-message":    {Desc: `allow replaying a commit with an empty messag`},
			"continue":               {Desc: `resume revert or cherry-pick sequence`},
			"n":                      {Desc: `do not make the actual commit`},
			"no-gpg-sign":            {Desc: `don't GPG-sign the commit`},
			"quit":                   {Desc: `end revert or cherry-pick sequence`},
			"S":                      {Desc: `GPG-sign the commit`},
			"m":                      {Desc: `specify mainline when cherry-picking a merge`},
			"strategy-option":        {Desc: `pass merge-strategy-specific option to merge`},
			"x":                      {Desc: `append information about what commit was cher`},
			"abort":                  {Desc: `cancel revert or cherry-pick sequence`},
			"edit":                   {Desc: `edit commit before committing the cherry-pick`},
			"e":                      {Desc: `edit commit before committing the cherry-pick`},
			"gpg-sign":               {Desc: `GPG-sign the commit`},
			"keep-redundant-commits": {Desc: `keep cherry-picked commits that will become e`},
			"mainline":               {Desc: `specify mainline when cherry-picking a merge`},
			"no-commit":              {Desc: `do not make the actual commit`},
			"strategy":               {Desc: `use given merge strategy`},
			"allow-empty":            {Desc: `preserve initially empty commits`},
			"cleanup":                {Desc: `specify how to strip spaces and #comments fro`},
			"ff":                     {Desc: `fast forward, if possible`},
			"rerere-autoupdate":      {Desc: `update index with reused conflict resolution`},
			"signoff":                {Desc: `add Signed-off-by line at the end of the comm`},
			"s":                      {Desc: `use given merge strategy`},
			"skip":                   {Desc: `skip current commit and continue`},
			"X":                      {Desc: `pass merge-strategy-specific option to merge`},
		},
	},
	"prune-packed": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"quiet":   {Desc: `do not display progress on standard error`},
			"q":       {Desc: `do not display progress on standard error`},
			"dry-run": {Desc: `only list objects that would be removed`},
			"n":       {Desc: `only list objects that would be removed`},
		},
	},
	"pull": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stat":                       {Desc: `show a diffstat at the end of the merge`},
			"strategy":                   {Desc: `use given merge strategy`},
			"verify-signatures":          {Desc: `verify the commits being merged or abort`},
			"6":                          {Desc: `use IPv6 addresses only`},
			"refmap":                     {Desc: `specify refspec to map refs to remote tra`},
			"n":                          {Desc: `do not show diffstat at the end of the me`},
			"progress":                   {Desc: `force progress reporting`},
			"unshallow":                  {Desc: `convert a shallow clone to a complete one`},
			"gpg-sign":                   {Desc: `GPG-sign the commit`},
			"log":                        {Desc: `add entries from shortlog to merge commit`},
			"no-recurse-submodules":      {Desc: `disable recursive fetching of submodules`},
			"set-upstream":               {Desc: `set upstream for git pull/fetch`},
			"f":                          {Desc: `force overwrite of local reference`},
			"S":                          {Desc: `GPG-sign the commit`},
			"ipv6":                       {Desc: `use IPv6 addresses only`},
			"no-edit":                    {Desc: `don't open an editor to change the commit`},
			"no-gpg-sign":                {Desc: `don't GPG-sign the commit`},
			"no-verify-signatures":       {Desc: `do not verify the commits being merged`},
			"prune":                      {Desc: `remove any remote tracking branches that`},
			"rebase":                     {Desc: `perform a rebase after fetching`},
			"depth":                      {Desc: `deepen the history of a shallow repositor`},
			"ipv4":                       {Desc: `use IPv4 addresses only`},
			"update-head-ok":             {Desc: `allow updates of current branch head`},
			"u":                          {Desc: `allow updates of current branch head`},
			"update-shallow":             {Desc: `accept refs that update .git/shallow`},
			"autostash":                  {Desc: `automatically stash/stash pop before and`},
			"dry-run":                    {Desc: `show what would be done, without making a`},
			"recurse-submodules":         {Desc: `specify when to fetch commits of submodul`},
			"recurse-submodules-default": {Desc: `provide internal temporary non-negative v`},
			"r":                          {Desc: `perform a rebase after fetching`},
			"jobs":                       {Desc: `specify number of submodules fetched in p`},
			"X":                          {Desc: `pass merge-strategy-specific option to me`},
			"cleanup":                    {Desc: `specify how to strip spaces and #comments`},
			"4":                          {Desc: `use IPv4 addresses only`},
			"j":                          {Desc: `specify number of submodules fetched in p`},
			"q":                          {Desc: `suppress all output`},
			"show-forced-updates":        {Desc: `check for forced-updates on all updated b`},
			"commit":                     {Desc: `perform the merge and commit the result`},
			"ff":                         {Desc: `do not generate a merge commit if the mer`},
			"quiet":                      {Desc: `suppress all output`},
			"tags":                       {Desc: `fetch remote tags`},
			"t":                          {Desc: `fetch remote tags`},
			"a":                          {Desc: `append ref names and object names of fetc`},
			"no-rebase":                  {Desc: `do not perform a rebase after fetching`},
			"no-stat":                    {Desc: `do not show diffstat at the end of the me`},
			"strategy-option":            {Desc: `pass merge-strategy-specific option to me`},
			"no-tags":                    {Desc: `disable automatic tag following`},
			"signoff":                    {Desc: `add Signed-off-by:`},
			"p":                          {Desc: `remove any remote tracking branches that`},
			"squash":                     {Desc: `merge, but do not commit`},
			"s":                          {Desc: `use given merge strategy`},
			"verbose":                    {Desc: `output additional information`},
			"append":                     {Desc: `append ref names and object names of fetc`},
			"keep":                       {Desc: `keep downloaded pack`},
			"no-squash":                  {Desc: `merge and commit`},
			"submodule-prefix":           {Desc: `prepend <path> to paths printed in inform`},
			"k":                          {Desc: `keep downloaded pack`},
			"no-log":                     {Desc: `do not list one-line descriptions of the`},
			"no-commit":                  {Desc: `perform the merge but do not commit the r`},
			"no-ff":                      {Desc: `generate a merge commit even if the merge`},
			"upload-pack":                {Desc: `specify path to git-upload-pack on remote`},
			"all":                        {Desc: `fetch all remotes`},
			"force":                      {Desc: `force overwrite of local reference`},
			"ff-only":                    {Desc: `refuse to merge unless HEAD is up to date`},
			"v":                          {Desc: `output additional information`},
			"allow-unrelated-histories":  {Desc: `allow merging unrelated histories`},
			"edit":                       {Desc: `open an editor to change the commit messa`},
		},
	},
	"fetch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"ipv6":                       {Desc: `use IPv6 addresses only`},
			"no-tags":                    {Desc: `disable automatic tag following`},
			"set-upstream":               {Desc: `set upstream for git pull/fetch`},
			"update-head-ok":             {Desc: `allow updates of current branch head`},
			"deepen":                     {Desc: `deepen history of shallow clone`},
			"dry-run":                    {Desc: `show what would be done, without making a`},
			"m":                          {Desc: `fetch from multiple remotes`},
			"show-forced-updates":        {Desc: `check for forced-updates on all updated b`},
			"j":                          {Desc: `specify number of submodules fetched in p`},
			"keep":                       {Desc: `keep downloaded pack`},
			"q":                          {Desc: `suppress all output`},
			"unshallow":                  {Desc: `convert a shallow clone to a complete one`},
			"update-shallow":             {Desc: `accept refs that update .git/shallow`},
			"v":                          {Desc: `output additional information`},
			"n":                          {Desc: `disable automatic tag following`},
			"p":                          {Desc: `remove any remote tracking branches that`},
			"4":                          {Desc: `use IPv4 addresses only`},
			"6":                          {Desc: `use IPv6 addresses only`},
			"negotiation-tip":            {Desc: `only report refs reachable from specified`},
			"quiet":                      {Desc: `suppress all output`},
			"server-option":              {Desc: `send specified string to the server when`},
			"upload-pack":                {Desc: `specify path to git-upload-pack on remote`},
			"all":                        {Desc: `fetch all remotes`},
			"filter":                     {Desc: `object filtering`},
			"'gc":                        {Desc: `uto' after fetching`},
			"depth":                      {Desc: `deepen the history of a shallow repositor`},
			"k":                          {Desc: `keep downloaded pack`},
			"multiple":                   {Desc: `fetch from multiple remotes`},
			"prune":                      {Desc: `remove any remote tracking branches that`},
			"o":                          {Desc: `send specified string to the server when`},
			"append":                     {Desc: `append ref names and object names of fetc`},
			"run":                        {Desc: `uto' after fetching`},
			"no-recurse-submodules":      {Desc: `disable recursive fetching of submodules`},
			"progress":                   {Desc: `force progress reporting`},
			"shallow-exclude":            {Desc: `deepen history of shallow clone by exclud`},
			"t":                          {Desc: `fetch remote tags`},
			"u":                          {Desc: `allow updates of current branch head`},
			"a":                          {Desc: `append ref names and object names of fetc`},
			"force":                      {Desc: `force overwrite of local reference`},
			"jobs":                       {Desc: `specify number of submodules fetched in p`},
			"recurse-submodules-default": {Desc: `provide internal temporary non-negative v`},
			"refmap":                     {Desc: `specify refspec to map refs to remote tra`},
			"shallow-since":              {Desc: `deepen history of shallow repository base`},
			"submodule-prefix":           {Desc: `prepend <path> to paths printed in inform`},
			"auto-gc":                    {Desc: `uto' after fetching`},
			"ipv4":                       {Desc: `use IPv4 addresses only`},
			"P":                          {Desc: `prune local tags no longer on remote and`},
			"recurse-submodules":         {Desc: `specify when to fetch commits of submodul`},
			"tags":                       {Desc: `fetch remote tags`},
			"verbose":                    {Desc: `output additional information`},
			"f":                          {Desc: `force overwrite of local reference`},
			"prune-tags":                 {Desc: `prune local tags no longer on remote and`},
		},
	},
	"difftool": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"ext-diff":                 {Desc: `allow external diff helper to be exec`},
			"cached":                   {Desc: `show diff between index and named com`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph`},
			"base":                     {Desc: `diff against "base" version`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored w`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"no-index":                 {Desc: `show diff between two paths on the fi`},
			"R":                        {Desc: `do a reverse diff`},
			"1":                        {Desc: `diff against "base" version`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"no-patch":                 {Desc: `suppress diff output`},
			"u":                        {Desc: `generate diff in patch format`},
			"S":                        {Desc: `look for differences that add or remo`},
			"d":                        {Desc: `diff a whole tree by preparing a temp`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"G":                        {Desc: `look for differences whose added or r`},
			"color-moved":              {Desc: `color moved lines differently`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"unified":                  {Desc: `generate diff with given lines of con`},
			"addition":                 {Desc: `ull-index, output b`},
			"line-prefix":              {Desc: `prepend additional prefix to every li`},
			"t":                        {Desc: `merge resolution program to use`},
			"c":                        {Desc: `combined diff format for merge commit`},
			"trust-exit-code":          {Desc: `make git-difftool exit when diff tool`},
			"find-object":              {Desc: `look for differences that change the`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expre`},
			"a":                        {Desc: `treat all files as text`},
			"M":                        {Desc: `detect renames with given scope`},
			"color-words":              {Desc: `show colored-word diff`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lin`},
			"to":                       {Desc: `ull-index, output b`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"cc":                       {Desc: `combined diff format for merge commit`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"no-renames":               {Desc: `turn off rename detection`},
			"raw":                      {Desc: `generate default raw diff output`},
			"U":                        {Desc: `generate diff with given lines of con`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hu`},
			"find-copies":              {Desc: `detect copies as well as renames with`},
			"theirs":                   {Desc: `diff against "their branch" version`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"no-symlinks":              {Desc: `make copies of instead of symlinks to`},
			"quiet":                    {Desc: `disable all output`},
			"relative":                 {Desc: `exclude changes outside and output re`},
			"tool-help":                {Desc: `print a list of diff tools that may b`},
			"for":                      {Desc: `irstat=cumulative`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"numstat":                  {Desc: `generate more machine-friendly diffst`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all chan`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"textconv":                 {Desc: `allow external text conversion filter`},
			"C":                        {Desc: `detect copies as well as renames with`},
			"w":                        {Desc: `ignore white space when comparing lin`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the in`},
			"name-only":                {Desc: `show only names of changed files`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"0":                        {Desc: `omit diff output for unmerged entries`},
			"color":                    {Desc: `show colored diff`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performi`},
			"output-indicator-context": {Desc: `specify the character to indicate a c`},
			"p":                        {Desc: `generate diff in patch format`},
			"symlinks":                 {Desc: `make symlinks to instead of copies of`},
			"binary":                   {Desc: `ull-index, output b`},
			"l":                        {Desc: `limit number of rename/copy targets t`},
			"prompt":                   {Desc: `prompt before invocation of diff tool`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"no-color":                 {Desc: `turn off colored diff`},
			"s":                        {Desc: `suppress diff output`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"O":                        {Desc: `output patch in the order of glob-pat`},
			"anchored":                 {Desc: `generate diffs using the "anchored di`},
			"output-indicator-new":     {Desc: `specify the character to indicate a n`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffst`},
			"y":                        {Desc: `do not prompt before invocation of di`},
			"gui":                      {Desc: `use diff.guitool instead of diff.tool`},
			"g":                        {Desc: `use diff.guitool instead of diff.tool`},
			"histogram":                {Desc: `generate diffs with histogram algorit`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"z":                        {Desc: `use NUL termination on output`},
			"full-index":               {Desc: `show full object name of pre- and pos`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"follow":                   {Desc: `continue listing the history of a fil`},
			"patience":                 {Desc: `generate diffs with patience algorith`},
			"staged":                   {Desc: `show diff between index and named com`},
			"dir-diff":                 {Desc: `diff a whole tree by preparing a temp`},
			"no-prompt":                {Desc: `do not prompt before invocation of di`},
			"ours":                     {Desc: `diff against "our branch" version`},
			"3":                        {Desc: `diff against "their branch" version`},
			"tool":                     {Desc: `merge resolution program to use`},
			"check":                    {Desc: `warn if changes introduce trailing wh`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white spa`},
			"no-textconv":              {Desc: `do not allow external text conversion`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defa`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"minimal":                  {Desc: `spend extra time to make sure the sma`},
			"output":                   {Desc: `undocumented`},
			"break-rewrites":           {Desc: `break complete rewrite changes into p`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"2":                        {Desc: `diff against "our branch" version`},
			"summary":                  {Desc: `generate condensed summary of extende`},
			"text":                     {Desc: `treat all files as text`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be e`},
			"x":                        {Desc: `custom diff command to use`},
			"diff-filter":              {Desc: `select certain kinds of files for dif`},
			"submodule":                {Desc: `select output format for submodule di`},
			"extcmd":                   {Desc: `custom diff command to use`},
			"B":                        {Desc: `break complete rewrite changes into p`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end o`},
			"name-status":              {Desc: `show only names and status of changed`},
			"word-diff":                {Desc: `show word diff`},
			"in":                       {Desc: `ull-index, output b`},
			"b":                        {Desc: `ignore changes in amount of white spa`},
			"no-prefix":                {Desc: `do not show any source or destination`},
			"output-indicator-old":     {Desc: `specify the character to indicate a o`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
		},
	},
	"get-tar-commit-id": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"stripspace": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"c":              {Desc: `prepend comment character and blank to each line`},
			"strip-comments": {Desc: `also strip lines starting with #`},
			"s":              {Desc: `also strip lines starting with #`},
			"comment-lines":  {Desc: `prepend comment character and blank to each line`},
		},
	},
	"cvsserver": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"version":      {Desc: `display version information`},
			"V":            {Desc: `display version information`},
			"base-path":    {Desc: `path to prepend to requested CVSROOT`},
			"export-all":   {Desc: `do not check for gitcvs.enabled`},
			"help":         {Desc: `display usage information`},
			"H":            {Desc: `display usage information`},
			"h":            {Desc: `display usage information`},
			"strict-paths": {Desc: `do not allow recursing into subdirectories`},
		},
	},
	"diff-tree": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"for":                      {Desc: `bbrev-commi`},
			"default":                  {Desc: `use argument as default revision`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"since":                    {Desc: `show commits more recent than given date`},
			"v":                        {Desc: `display commit message before differences`},
			"children":                 {Desc: `display children of commit`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-commit-id":             {Desc: `do not display commit IDs`},
			"i":                        {Desc: `match regexps ignoring case`},
			"those":                    {Desc: `rep, -`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"date":                     {Desc: `format of date output`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"raw":                      {Desc: `generate default raw diff output`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"until":                    {Desc: `show commits older than given date`},
			"output":                   {Desc: `undocumented`},
			"z":                        {Desc: `use NUL termination on output`},
			"all":                      {Desc: `rep, -`},
			"before":                   {Desc: `show commits older than given date`},
			"always":                   {Desc: `always show commit itself and commit log mess`},
			"full-history":             {Desc: `do not prune history`},
			"parents":                  {Desc: `display parents of commit`},
			"s":                        {Desc: `do not show differences`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"p":                        {Desc: `generate diff in patch format`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"merges":                   {Desc: `display only merge commits`},
			"name-only":                {Desc: `show only names of changed files`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"cherry":                   {Desc: `o-m`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"no-min-parents":           {Desc: `reset limit`},
			"if":                       {Desc: `ot refs/bise`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"no-max-parents":           {Desc: `reset limit`},
			"R":                        {Desc: `do a reverse diff`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"topo-order":               {Desc: `display commits in topological order`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"m":                        {Desc: `do not ignore merges`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"t":                        {Desc: `display tree objects in diff output`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"M":                        {Desc: `detect renames with given scope`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"of":                       {Desc: `ull-history`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"to":                       {Desc: `rep, -`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"commits":                  {Desc: `rep, -`},
			"author":                   {Desc: `limit commits to those by given author`},
			"as":                       {Desc: `ot refs/bise`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"shorthand":                {Desc: `bbrev-commi`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"a":                        {Desc: `treat all files as text`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"limit":                    {Desc: `rep, -`},
			"format":                   {Desc: `pretty print commit messages`},
			"P":                        {Desc: `use perl regular expression`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"word-diff":                {Desc: `show word diff`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"root":                     {Desc: `display root diff`},
			"no-renames":               {Desc: `turn off rename detection`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"u":                        {Desc: `generate diff in patch format`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"no-patch":                 {Desc: `suppress diff output`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"bisect":                   {Desc: `ot refs/bise`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"all-match":                {Desc: `rep, -`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"color-words":              {Desc: `show colored-word diff`},
			"combined-all-paths":       {Desc: `show name of file in all parents for combined`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"count":                    {Desc: `display how many commits would have been list`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"simplify-merges":          {Desc: `ull-history`},
			"milder":                   {Desc: `ull-history`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"matching":                 {Desc: `rep, -`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"color-moved":              {Desc: `color moved lines differently`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"patch":                    {Desc: `generate diff in patch format`},
			"text":                     {Desc: `treat all files as text`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"color":                    {Desc: `show colored diff`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"pretend":                  {Desc: `ot refs/bise`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"early-output":             {Desc: `undocumented`},
			"version":                  {Desc: `ull-history`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"n":                        {Desc: `maximum number of commits to display`},
			"after":                    {Desc: `show commits more recent than given date`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"in":                       {Desc: `ull-index, output binary di`},
			"oneline":                  {Desc: `bbrev-commi`},
			"date-order":               {Desc: `display commits in date order`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"invert-grep":              {Desc: `rep, -`},
			"r":                        {Desc: `recurse into subdirectories`},
		},
	},
	"fetch-pack": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"include-tag": {Desc: `download referenced annotated tags`},
			"keep":        {Desc: `do not invoke git-unpack-objects on received data`},
			"quiet":       {Desc: `make output less verbose`},
			"q":           {Desc: `make output less verbose`},
			"thin":        {Desc: `fetch a thin pack`},
			"v":           {Desc: `produce verbose output`},
			"all":         {Desc: `fetch all remote refs`},
			"depth":       {Desc: `limit fetching to ancestor-chains not longer than gi`},
			"k":           {Desc: `do not invoke git-unpack-objects on received data`},
			"no-progress": {Desc: `do not display progress`},
			"stdin":       {Desc: `take the list of refs from stdin`},
			"upload-pack": {Desc: `specify path to git-upload-pack on remote side`},
			"exec":        {Desc: `specify path to git-upload-pack on remote side`},
		},
	},
	"http-fetch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"v":       {Desc: `report what is downloaded`},
			"w":       {Desc: `write commit-id into the filename under "$GIT_DIR/refs/<filena`},
			"recover": {Desc: `recover from a failed fetch`},
			"stdin":   {Desc: `read commit ids and refs from standard input`},
			"a":       {Desc: `fetch all objects`},
			"c":       {Desc: `fetch commit objects`},
			"t":       {Desc: `fetch trees associated with commit objects`},
		},
	},
	"name-rev": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"all":          {Desc: `list all commits reachable from all refs`},
			"always":       {Desc: `show uniquely abbreviated commit object as fallback`},
			"refs":         {Desc: `only use refs matching given pattern`},
			"tags":         {Desc: `only use tags to name commits`},
			"exclude":      {Desc: `ignore refs matching specified pattern`},
			"name-only":    {Desc: `display only name of commits`},
			"no-refs":      {Desc: `clear any previous ref patterns given`},
			"no-undefined": {Desc: `die with non-zero return when a reference is undefined`},
			"stdin":        {Desc: `read from stdin and append revision-name`},
		},
	},
	"pack-redundant": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"quiltimport": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"author":         {Desc: `default author name and email address to use for patc`},
			"dry-run":        {Desc: `check patches and warn if they cannot be imported`},
			"n":              {Desc: `check patches and warn if they cannot be imported`},
			"keep-non-patch": {Desc: `pass -b to git mailinfo`},
			"patches":        {Desc: `set directory containing patches`},
			"series":         {Desc: `specify quilt series file`},
		},
	},
	"archimport": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"D": {Desc: `attempt to import trees that have been merged from`},
			"T": {Desc: `create tag for every commit`},
			"a": {Desc: `auto-register archives at http://mirrors.sourcecontrol.net`},
			"f": {Desc: `use fast patchset import strategy`},
			"h": {Desc: `display usage`},
			"o": {Desc: `use old-style branch names`},
			"t": {Desc: `use given directory as temporary directory`},
			"v": {Desc: `verbose output`},
		},
	},
	"daemon": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"grep": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"all-match":           {Desc: `all patterns must match`},
			"G":                   {Desc: `use basic regular expressions`},
			"E":                   {Desc: `use extended regular expressions`},
			"invert-match":        {Desc: `select non-matching lines`},
			"no-exclude-standard": {Desc: `search also in ignored files`},
			"f":                   {Desc: `read patterns from given file`},
			"after-context":       {Desc: `specify lines of trailing context`},
			"files-with-matches":  {Desc: `show only names of matching files`},
			"no-index":            {Desc: `search files in current directory,`},
			"recurse-submodules":  {Desc: `recursively search in each submodul`},
			"heading":             {Desc: `show the filename above the matches`},
			"only-matching":       {Desc: `show only matching part of line`},
			"p":                   {Desc: `show preceding line containing func`},
			"c":                   {Desc: `show number of matching lines in fi`},
			"W":                   {Desc: `show whole function where a match w`},
			"open-files-in-pager": {Desc: `open matching files in pager`},
			"word-regexp":         {Desc: `match only whole words`},
			"break":               {Desc: `print an empty line between matches`},
			"textconv":            {Desc: `honor textconv filter settings`},
			"threads":             {Desc: `use specified number of threads`},
			"context":             {Desc: `specify lines of context`},
			"name-only":           {Desc: `show only names of matching files`},
			"files-without-match": {Desc: `show only names of non-matching fil`},
			"parent-basename":     {Desc: `prepend parent project's basename t`},
			"show-function":       {Desc: `show preceding line containing func`},
			"a":                   {Desc: `process binary files as if they wer`},
			"i":                   {Desc: `ignore case when matching`},
			"line-number":         {Desc: `prefix the line number to matching`},
			"or":                  {Desc: `either pattern must match`},
			"perl-regexp":         {Desc: `use perl-compatible regexes`},
			"w":                   {Desc: `match only whole words`},
			"e":                   {Desc: `use the given pattern for matching`},
			"basic-regexp":        {Desc: `use basic regular expressions`},
			"no-color":            {Desc: `don't color matches`},
			"untracked":           {Desc: `search also in untracked files`},
			"z":                   {Desc: `output 0 after filenames`},
			"O":                   {Desc: `open matching files in pager`},
			"column":              {Desc: `show column number of first match`},
			"l":                   {Desc: `show only names of matching files`},
			"no-textconv":         {Desc: `don't honor textconv filter setting`},
			"P":                   {Desc: `use perl-compatible regexes`},
			"text":                {Desc: `process binary files as if they wer`},
			"H":                   {Desc: `show filenames`},
			"B":                   {Desc: `specify lines of leading context`},
			"C":                   {Desc: `specify lines of context`},
			"L":                   {Desc: `show only names of non-matching fil`},
			"h":                   {Desc: `suppress output of filenames`},
			"v":                   {Desc: `select non-matching lines`},
			"before-context":      {Desc: `specify lines of leading context`},
			"color":               {Desc: `color matches`},
			"count":               {Desc: `show number of matching lines in fi`},
			"exclude-standard":    {Desc: `exclude files standard ignore mecha`},
			"extended-regexp":     {Desc: `use extended regular expressions`},
			"fixed-strings":       {Desc: `use literal strings`},
			"o":                   {Desc: `show only matching part of line`},
			"I":                   {Desc: `don't match pattern in binary files`},
			"A":                   {Desc: `specify lines of trailing context`},
			"and":                 {Desc: `both patterns must match`},
			"full-name":           {Desc: `output paths relative to the projec`},
			"function-context":    {Desc: `show whole function where a match w`},
			"n":                   {Desc: `prefix the line number to matching`},
			"not":                 {Desc: `the following pattern must not matc`},
			"null":                {Desc: `output 0 after filenames`},
			"cached":              {Desc: `search blobs registered in index fi`},
			"F":                   {Desc: `use literal strings`},
			"ignore-case":         {Desc: `ignore case when matching`},
			"max-depth":           {Desc: `descend at most given levels of dir`},
		},
	},
	"ls-remote": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"heads":         {Desc: `show only refs under refs/heads`},
			"q":             {Desc: `don't print remote URL`},
			"sort":          {Desc: `specify field name to sort on`},
			"exit-code":     {Desc: `exit with status 2 when no matching refs are found in`},
			"quiet":         {Desc: `don't print remote URL`},
			"symref":        {Desc: `show underlying ref in addition to the object pointed`},
			"tags":          {Desc: `show only refs under refs/tags`},
			"t":             {Desc: `show only refs under refs/tags`},
			"get-url":       {Desc: `expand the URL of the given repository taking into acc`},
			"h":             {Desc: `show only refs under refs/heads`},
			"server-option": {Desc: `send specified string to the server when using protoco`},
			"o":             {Desc: `send specified string to the server when using protoco`},
			"refs":          {Desc: `don't show peeled tags`},
			"upload-pack":   {Desc: `specify path to git-upload-pack on remote side`},
		},
	},
	"receive-pack": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"q":              {Desc: `be quiet`},
			"advertise-refs": {Desc: `undocumented`},
			"stateless-rpc":  {Desc: `undocumented`},
			"quiet":          {Desc: `be quiet`},
		},
	},
	"reflog": {Desc: "", Sub: map[string]*complete.CompTree{"expire": {Desc: "prune old reflog entries", Sub: map[string]*complete.CompTree{}},
		"show":   {Desc: "show log of ref", Sub: map[string]*complete.CompTree{}},
		"delete": {Desc: "delete entries from reflog", Sub: map[string]*complete.CompTree{}},
		"exists": {Desc: "check whether a ref has a reflog", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"date-order":               {Desc: `display commits in date order`},
			"encoding":                 {Desc: `output log messages in given encoding`},
			"objects":                  {Desc: `display object ids of objects referenced by l`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new line`},
			"M":                        {Desc: `detect renames with given scope`},
			"n":                        {Desc: `maximum number of commits to display`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"fixed-strings":            {Desc: `don't interpret patterns as regexps`},
			"min-age":                  {Desc: `minimum age of commits to output`},
			"no-abbrev":                {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-textconv":              {Desc: `do not allow external text conversion filters`},
			"graph":                    {Desc: `display graphical representation of commit hi`},
			"since":                    {Desc: `show commits more recent than given date`},
			"topo-order":               {Desc: `display commits in topological order`},
			"unified":                  {Desc: `generate diff with given lines of context`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"no-renames":               {Desc: `turn off rename detection`},
			"relative-date":            {Desc: `show dates relative to current time`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"E":                        {Desc: `use POSIX extended regexps`},
			"u":                        {Desc: `generate diff in patch format`},
			"min-parents":              {Desc: `show only commits with at least specified num`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph width`},
			"stdin":                    {Desc: `additionally read commits from standard input`},
			"textconv":                 {Desc: `allow external text conversion filters to be`},
			"invert-grep":              {Desc: `rep, -`},
			"objects-edge":             {Desc: `display object ids of objects referenced by l`},
			"shorthand":                {Desc: `bbrev-commi`},
			"check":                    {Desc: `warn if changes introduce trailing whitespace`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"exclude":                  {Desc: `do not include refs matching glob`},
			"find-object":              {Desc: `look for differences that change the number o`},
			"ignore-missing":           {Desc: `ignore invalid object an ref names on command`},
			"R":                        {Desc: `do a reverse diff`},
			"no-notes":                 {Desc: `do not show notes that annotate commit`},
			"simplify-by-decoration":   {Desc: `show only commits that are referenced by a re`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"matching":                 {Desc: `rep, -`},
			"for":                      {Desc: `bbrev-commi`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk bound`},
			"no-merges":                {Desc: `don't display commits with more than one pare`},
			"l":                        {Desc: `limit number of rename/copy targets to run`},
			"author-date-order":        {Desc: `display commits in author date order`},
			"addition":                 {Desc: `ull-index, output binary di`},
			"name-only":                {Desc: `show only names of changed files`},
			"remotes":                  {Desc: `show all commits from refs/remotes`},
			"of":                       {Desc: `ull-history`},
			"a":                        {Desc: `treat all files as text`},
			"binary":                   {Desc: `ull-index, output binary di`},
			"glob":                     {Desc: `show all commits from refs matching glob`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"left-right":               {Desc: `mark which side of symmetric diff commit is r`},
			"output":                   {Desc: `undocumented`},
			"tags":                     {Desc: `show all commits from refs/tags`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"P":                        {Desc: `use perl regular expression`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored when perf`},
			"count":                    {Desc: `display how many commits would have been list`},
			"find-copies":              {Desc: `detect copies as well as renames with given s`},
			"max-age":                  {Desc: `maximum age of commits to output`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"z":                        {Desc: `use NUL termination on output`},
			"all":                      {Desc: `rep, -`},
			"refs/bisect/bad":          {Desc: `ot refs/bise`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"merges":                   {Desc: `display only merge commits`},
			"submodule":                {Desc: `select output format for submodule difference`},
			"show-signature":           {Desc: `validate GPG signature of commit`},
			"walk-reflogs":             {Desc: `walk reflog entries from most recent to oldes`},
			"ancestry-path":            {Desc: `only display commits that exists directly on`},
			"bisect":                   {Desc: `ot refs/bise`},
			"cherry":                   {Desc: `o-m`},
			"not":                      {Desc: `reverses meaning of ^ prefix for revisions th`},
			"line-prefix":              {Desc: `prepend additional prefix to every line of ou`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing move`},
			"text":                     {Desc: `treat all files as text`},
			"O":                        {Desc: `output patch in the order of glob-pattern lin`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff" algo`},
			"author":                   {Desc: `limit commits to those by given author`},
			"color":                    {Desc: `show colored diff`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"p":                        {Desc: `generate diff in patch format`},
			"U":                        {Desc: `generate diff with given lines of context`},
			"cc":                       {Desc: `combined diff format for merge commits`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"color-words":              {Desc: `show colored-word diff`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"use-mailmap":              {Desc: `use mailmap file to map author and committer`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"abbrev-commit":            {Desc: `show only partial prefixes of commit object n`},
			"color-moved":              {Desc: `color moved lines differently`},
			"extended-regexp":          {Desc: `use POSIX extended regexps`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"sparse":                   {Desc: `when paths are given, display only commits th`},
			"reflog":                   {Desc: `show all commits from reflogs`},
			"limit":                    {Desc: `rep, -`},
			"before":                   {Desc: `show commits older than given date`},
			"in":                       {Desc: `ull-index, output binary di`},
			"cherry-mark":              {Desc: `herry-pick but mark equivalent commit`},
			"no-walk":                  {Desc: `only display given revs, don't traverse their`},
			"patch":                    {Desc: `generate diff in patch format`},
			"patch-with-raw":           {Desc: `generate patch but also keep the default raw`},
			"raw":                      {Desc: `generate default raw diff output`},
			"those":                    {Desc: `rep, -`},
			"do-walk":                  {Desc: `only display given revs, traversing their anc`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove blank li`},
			"minimal":                  {Desc: `spend extra time to make sure the smallest po`},
			"no-max-parents":           {Desc: `reset limit`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace errors`},
			"full-diff":                {Desc: `show full commit diffs when using log -p, not`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of line`},
			"milder":                   {Desc: `ull-history`},
			"h":                        {Desc: `display usage`},
			"remove-empty":             {Desc: `stop when given path disappears from tree`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"after":                    {Desc: `show commits more recent than given date`},
			"commits":                  {Desc: `rep, -`},
			"pretend":                  {Desc: `ot refs/bise`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"no-min-parents":           {Desc: `reset limit`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expression`},
			"skip":                     {Desc: `skip given number of commits before output`},
			"regexp-ignore-case":       {Desc: `match regexps ignoring case`},
			"relative":                 {Desc: `exclude changes outside and output relative t`},
			"default":                  {Desc: `use argument as default revision`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ext-diff":                 {Desc: `allow external diff helper to be executed`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the index`},
			"left-only":                {Desc: `list only commits on the left side of a symme`},
			"g":                        {Desc: `walk reflog entries from most recent to oldes`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 otherwis`},
			"no-patch":                 {Desc: `suppress diff output`},
			"perl-regexp":              {Desc: `use perl regular expression`},
			"simplify-merges":          {Desc: `ull-history`},
			"single-worktree":          {Desc: `examine the current working tree only`},
			"C":                        {Desc: `detect copies as well as renames with given s`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"right-only":               {Desc: `list only commits on the right side of a symm`},
			"like":                     {Desc: `herry-pick but mark equivalent commit`},
			"max-count":                {Desc: `maximum number of commits to display`},
			"name-status":              {Desc: `show only names and status of changed files`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old line`},
			"to":                       {Desc: `rep, -`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be executed`},
			"show-linear-break":        {Desc: `show a barrier between commits from different`},
			"S":                        {Desc: `look for differences that add or remove the g`},
			"oneline":                  {Desc: `bbrev-commi`},
			"as":                       {Desc: `ot refs/bise`},
			"grep-reflog":              {Desc: `limit commits to ones whose reflog message ma`},
			"version":                  {Desc: `ull-history`},
			"until":                    {Desc: `show commits older than given date`},
			"reverse":                  {Desc: `display commits in reverse order`},
			"B":                        {Desc: `break complete rewrite changes into pairs of`},
			"all-match":                {Desc: `rep, -`},
			"cherry-pick":              {Desc: `omit any commit that introduces the same chan`},
			"early-output":             {Desc: `undocumented`},
			"no-color":                 {Desc: `turn off colored diff`},
			"output-indicator-context": {Desc: `specify the character to indicate a context l`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all changes in t`},
			"grep":                     {Desc: `limit commits to those with log messages matc`},
			"max-parents":              {Desc: `show only commits with at most specified numb`},
			"no-abbrev-commit":         {Desc: `show the full 40-byte hexadecimal commit obje`},
			"no-prefix":                {Desc: `do not show any source or destination prefix`},
			"notes":                    {Desc: `show notes that annotate commit, with optiona`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"G":                        {Desc: `look for differences whose added or removed l`},
			"F":                        {Desc: `don't interpret patterns as regexps`},
			"boundary":                 {Desc: `output uninteresting commits at boundary`},
			"full-history":             {Desc: `do not prune history`},
			"merge":                    {Desc: `after a failed merge, show refs that touch fi`},
			"pretty=oneline":           {Desc: `bbrev-commi`},
			"word-diff":                {Desc: `show word diff`},
			"first-parent":             {Desc: `follow only first parent from merge commits`},
			"format":                   {Desc: `pretty print commit messages`},
			"i":                        {Desc: `match regexps ignoring case`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pairs of`},
			"children":                 {Desc: `display children of commit`},
			"committer":                {Desc: `limit commits to those by given committer`},
			"dense":                    {Desc: `only display selected commits, plus meaningfu`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"s":                        {Desc: `suppress diff output`},
			"follow":                   {Desc: `continue listing the history of a file beyond`},
			"full-index":               {Desc: `show full object name of pre- and post-image`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"if":                       {Desc: `ot refs/bise`},
			"branches":                 {Desc: `show all commits from refs/heads`},
			"date":                     {Desc: `format of date output`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"summary":                  {Desc: `generate condensed summary of extended header`},
			"log-size":                 {Desc: `print log message size in bytes before the me`},
			"parents":                  {Desc: `display parents of commit`},
			"pretty":                   {Desc: `pretty print commit messages`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
		},
	},
	"co": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"ignore-skip-worktree-bits": {Desc: `don't limit pathspecs to sparse entries on`},
			"m":                         {Desc: `3way merge current branch, working tree an`},
			"no-track":                  {Desc: `override the branch.autosetupmerge configu`},
			"3":                         {Desc: `check out stage #3 for unmerged paths`},
			"B":                         {Desc: `create or update branch based at given com`},
			"conflict":                  {Desc: `erge, using given merge style`},
			"detach":                    {Desc: `detach the HEAD at named commit`},
			"merge":                     {Desc: `3way merge current branch, working tree an`},
			"ours":                      {Desc: `check out stage #2 for unmerged paths`},
			"recurse-submodules":        {Desc: `control recursive updating of submodules`},
			"as":                        {Desc: `erge, using given merge style`},
			"patch":                     {Desc: `interactively select hunks in diff between`},
			"theirs":                    {Desc: `check out stage #3 for unmerged paths`},
			"same":                      {Desc: `erge, using given merge style`},
			"q":                         {Desc: `suppress progress reporting`},
			"orphan":                    {Desc: `create a new orphan branch based at given`},
			"2":                         {Desc: `check out stage #2 for unmerged paths`},
			"p":                         {Desc: `interactively select hunks in diff between`},
			"progress":                  {Desc: `force progress reporting`},
			"d":                         {Desc: `detach the HEAD at named commit`},
			"no-overlay":                {Desc: `remove files from index or working tree th`},
			"track":                     {Desc: `set up configuration so pull merges from t`},
			"f":                         {Desc: `force branch switch/ignore unmerged entrie`},
			"ignore-other-worktrees":    {Desc: `don't check if another worktree is holding`},
			"t":                         {Desc: `set up configuration so pull merges from t`},
			"b":                         {Desc: `create a new branch based at given commit`},
			"force":                     {Desc: `force branch switch/ignore unmerged entrie`},
			"no-guess":                  {Desc: `don't second guess 'git checkout <no-such-`},
			"quiet":                     {Desc: `suppress progress reporting`},
		},
	},
	"fast-export": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"fake-missing-tagger":        {Desc: `fake a tagger when tags lack them`},
			"full-tree":                  {Desc: `output full tree for each commit`},
			"import-marks-if-exists":     {Desc: `load marks from file if it exists`},
			"C":                          {Desc: `detect copies as well as renames with given`},
			"import-marks":               {Desc: `load marks before processing input`},
			"no-data":                    {Desc: `do not output blocb objects, instead referr`},
			"reencode":                   {Desc: `specify how to handle encoding header in co`},
			"tag-of-filtered-object":     {Desc: `specify how to handle tags whose tagged obj`},
			"use-done-feature":           {Desc: `start with a "feature done" stanza, and ter`},
			"M":                          {Desc: `detect moving lines in the file as well`},
			"export-marks":               {Desc: `dump internal marks table when complete`},
			"refspec":                    {Desc: `apply refspec to exported refs`},
			"signed-tags":                {Desc: `specify how to handle signed tags`},
			"progress":                   {Desc: `insert progress statements`},
			"reference-excluded-parents": {Desc: `reference parents not in fast-export stream`},
			"show-original-ids":          {Desc: `show original object ids of blobs/commits`},
			"anonymize":                  {Desc: `anonymize output`},
			"mark-tags":                  {Desc: `label tags with mark ids`},
			"name-only":                  {Desc: `show variable names only`},
		},
	},
	"unpack-objects": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"n":      {Desc: `only list the objects that would be unpacked`},
			"q":      {Desc: `run quietly`},
			"r":      {Desc: `try recovering objects from corrupt packs`},
			"strict": {Desc: `do not write objects with broken content or links`},
		},
	},
	"checkout": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"conflict":                  {Desc: `erge, using given merge style`},
			"ignore-other-worktrees":    {Desc: `don't check if another worktree is holding`},
			"3":                         {Desc: `check out stage #3 for unmerged paths`},
			"same":                      {Desc: `erge, using given merge style`},
			"quiet":                     {Desc: `suppress progress reporting`},
			"ours":                      {Desc: `check out stage #2 for unmerged paths`},
			"patch":                     {Desc: `interactively select hunks in diff between`},
			"progress":                  {Desc: `force progress reporting`},
			"f":                         {Desc: `force branch switch/ignore unmerged entrie`},
			"recurse-submodules":        {Desc: `control recursive updating of submodules`},
			"theirs":                    {Desc: `check out stage #3 for unmerged paths`},
			"B":                         {Desc: `create or update branch based at given com`},
			"no-guess":                  {Desc: `don't second guess 'git checkout <no-such-`},
			"q":                         {Desc: `suppress progress reporting`},
			"2":                         {Desc: `check out stage #2 for unmerged paths`},
			"m":                         {Desc: `3way merge current branch, working tree an`},
			"no-track":                  {Desc: `override the branch.autosetupmerge configu`},
			"orphan":                    {Desc: `create a new orphan branch based at given`},
			"as":                        {Desc: `erge, using given merge style`},
			"detach":                    {Desc: `detach the HEAD at named commit`},
			"d":                         {Desc: `detach the HEAD at named commit`},
			"ignore-skip-worktree-bits": {Desc: `don't limit pathspecs to sparse entries on`},
			"merge":                     {Desc: `3way merge current branch, working tree an`},
			"p":                         {Desc: `interactively select hunks in diff between`},
			"t":                         {Desc: `set up configuration so pull merges from t`},
			"no-overlay":                {Desc: `remove files from index or working tree th`},
			"b":                         {Desc: `create a new branch based at given commit`},
			"force":                     {Desc: `force branch switch/ignore unmerged entrie`},
			"track":                     {Desc: `set up configuration so pull merges from t`},
		},
	},
	"request-pull": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"status": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"show-stash":        {Desc: `show stash information`},
			"M":                 {Desc: `detect renames`},
			"column":            {Desc: `display in columns`},
			"ignore-submodules": {Desc: `ignore changes to submodules`},
			"no-ahead-behind":   {Desc: `don't display detailed ahead/behind counts relativ`},
			"no-renames":        {Desc: `don't detect renames`},
			"porcelain":         {Desc: `produce machine-readable output`},
			"short":             {Desc: `output in short format`},
			"z":                 {Desc: `use NUL termination on output`},
			"untracked-files":   {Desc: `show untracked files`},
			"u":                 {Desc: `show untracked files`},
			"ignored":           {Desc: `show ignored files as well`},
			"find-renames":      {Desc: `detect renames, optionally set similarity index`},
			"no-column":         {Desc: `don't display in columns`},
			"null":              {Desc: `use NUL termination on output`},
			"s":                 {Desc: `output in short format`},
		},
	},
	"subtree": {Desc: "", Sub: map[string]*complete.CompTree{"merge": {Desc: "merge recent changes up to specified commit into the subtree", Sub: map[string]*complete.CompTree{}},
		"pull":  {Desc: "fetch from remote repository and merge recent changes into the sub", Sub: map[string]*complete.CompTree{}},
		"push":  {Desc: "does a split and git push", Sub: map[string]*complete.CompTree{}},
		"split": {Desc: "extract a new synthetic project history from a subtree", Sub: map[string]*complete.CompTree{}},
		"add":   {Desc: "create the subtree by importing its contents", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"quiet":  {Desc: `suppress progress output`},
			"q":      {Desc: `suppress progress output`},
			"d":      {Desc: `show debug messages`},
			"prefix": {Desc: `the path to the subtree in the repository to manipulate`},
			"P":      {Desc: `the path to the subtree in the repository to manipulate`},
		},
	},
	"http-backend": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"check-mailmap": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"diff": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"find-copies":              {Desc: `detect copies as well as renames with`},
			"b":                        {Desc: `ignore changes in amount of white spa`},
			"no-textconv":              {Desc: `do not allow external text conversion`},
			"S":                        {Desc: `look for differences that add or remo`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"no-prefix":                {Desc: `do not show any source or destination`},
			"M":                        {Desc: `detect renames with given scope`},
			"staged":                   {Desc: `show diff between index and named com`},
			"color-moved":              {Desc: `color moved lines differently`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-renames":               {Desc: `turn off rename detection`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"text":                     {Desc: `treat all files as text`},
			"0":                        {Desc: `omit diff output for unmerged entries`},
			"G":                        {Desc: `look for differences whose added or r`},
			"z":                        {Desc: `use NUL termination on output`},
			"base":                     {Desc: `diff against "base" version`},
			"B":                        {Desc: `break complete rewrite changes into p`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"ext-diff":                 {Desc: `allow external diff helper to be exec`},
			"output":                   {Desc: `undocumented`},
			"output-indicator-context": {Desc: `specify the character to indicate a c`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph`},
			"theirs":                   {Desc: `diff against "their branch" version`},
			"w":                        {Desc: `ignore white space when comparing lin`},
			"line-prefix":              {Desc: `prepend additional prefix to every li`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored w`},
			"for":                      {Desc: `irstat=cumulative`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lin`},
			"no-patch":                 {Desc: `suppress diff output`},
			"numstat":                  {Desc: `generate more machine-friendly diffst`},
			"1":                        {Desc: `diff against "base" version`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"2":                        {Desc: `diff against "our branch" version`},
			"R":                        {Desc: `do a reverse diff`},
			"follow":                   {Desc: `continue listing the history of a fil`},
			"histogram":                {Desc: `generate diffs with histogram algorit`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"unified":                  {Desc: `generate diff with given lines of con`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace`},
			"to":                       {Desc: `ull-index, output b`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"U":                        {Desc: `generate diff with given lines of con`},
			"O":                        {Desc: `output patch in the order of glob-pat`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"quiet":                    {Desc: `disable all output`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be e`},
			"cc":                       {Desc: `combined diff format for merge commit`},
			"check":                    {Desc: `warn if changes introduce trailing wh`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end o`},
			"output-indicator-old":     {Desc: `specify the character to indicate a o`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"word-diff":                {Desc: `show word diff`},
			"c":                        {Desc: `combined diff format for merge commit`},
			"color-words":              {Desc: `show colored-word diff`},
			"name-status":              {Desc: `show only names and status of changed`},
			"in":                       {Desc: `ull-index, output b`},
			"minimal":                  {Desc: `spend extra time to make sure the sma`},
			"l":                        {Desc: `limit number of rename/copy targets t`},
			"color":                    {Desc: `show colored diff`},
			"name-only":                {Desc: `show only names of changed files`},
			"cached":                   {Desc: `show diff between index and named com`},
			"break-rewrites":           {Desc: `break complete rewrite changes into p`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"summary":                  {Desc: `generate condensed summary of extende`},
			"3":                        {Desc: `diff against "their branch" version`},
			"diff-filter":              {Desc: `select certain kinds of files for dif`},
			"addition":                 {Desc: `ull-index, output b`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performi`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffst`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"anchored":                 {Desc: `generate diffs using the "anchored di`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove`},
			"u":                        {Desc: `generate diff in patch format`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0`},
			"binary":                   {Desc: `ull-index, output b`},
			"s":                        {Desc: `suppress diff output`},
			"output-indicator-new":     {Desc: `specify the character to indicate a n`},
			"p":                        {Desc: `generate diff in patch format`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defa`},
			"patience":                 {Desc: `generate diffs with patience algorith`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"C":                        {Desc: `detect copies as well as renames with`},
			"submodule":                {Desc: `select output format for submodule di`},
			"full-index":               {Desc: `show full object name of pre- and pos`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all chan`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white spa`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the in`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hu`},
			"no-index":                 {Desc: `show diff between two paths on the fi`},
			"relative":                 {Desc: `exclude changes outside and output re`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"ours":                     {Desc: `diff against "our branch" version`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular expre`},
			"raw":                      {Desc: `generate default raw diff output`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"a":                        {Desc: `treat all files as text`},
			"textconv":                 {Desc: `allow external text conversion filter`},
			"find-object":              {Desc: `look for differences that change the`},
		},
	},
	"fmt-merge-msg": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"file":    {Desc: `specify list of merged objects from file`},
			"F":       {Desc: `specify list of merged objects from file`},
			"log":     {Desc: `display one-line descriptions from actual commits being merg`},
			"message": {Desc: `use given message instead of branch names for first line in`},
			"m":       {Desc: `use given message instead of branch names for first line in`},
			"no-log":  {Desc: `do not display one-line descriptions from actual commits bei`},
		},
	},
	"archive": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"v":                   {Desc: `report progress to stderr`},
			"exec":                {Desc: `path to git-receive-pack on remote`},
			"format":              {Desc: `format of the resulting archive`},
			"list":                {Desc: `list available archive formats`},
			"verbose":             {Desc: `report progress to stderr`},
			"remote":              {Desc: `archive remote repository`},
			"worktree-attributes": {Desc: `look for attributes in .gitattributes in working`},
			"l":                   {Desc: `list available archive formats`},
			"output":              {Desc: `write archive to specified file`},
			"o":                   {Desc: `write archive to specified file`},
			"prefix":              {Desc: `prepend the given path prefix to each filename`},
		},
	},
	"format-patch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"p":                        {Desc: `generate diff in patch format`},
			"suffix":                   {Desc: `use the given suffix for filenames`},
			"unified":                  {Desc: `generate diff with given lines of conte`},
			"break-rewrites":           {Desc: `break complete rewrite changes into pai`},
			"ignore-space-change":      {Desc: `ignore changes in amount of white space`},
			"output-indicator-new":     {Desc: `specify the character to indicate a new`},
			"w":                        {Desc: `ignore white space when comparing lines`},
			"keep-subject":             {Desc: `don't strip/add [PATCH] from the first`},
			"o":                        {Desc: `store resulting files in given director`},
			"ext-diff":                 {Desc: `allow external diff helper to be execut`},
			"follow":                   {Desc: `continue listing the history of a file`},
			"histogram":                {Desc: `generate diffs with histogram algorithm`},
			"no-color-moved-ws":        {Desc: `don't ignore whitespace when performing`},
			"patch":                    {Desc: `generate diff in patch format`},
			"pickaxe-all":              {Desc: `when -S finds a change, show all change`},
			"range-diff":               {Desc: `insert range-diff against previous patc`},
			"submodule":                {Desc: `select output format for submodule diff`},
			"binary":                   {Desc: `ull-index, output bin`},
			"addition":                 {Desc: `ull-index, output bin`},
			"cover-letter":             {Desc: `generate a cover letter template`},
			"start-number":             {Desc: `start numbering patches at given number`},
			"a":                        {Desc: `treat all files as text`},
			"R":                        {Desc: `do a reverse diff`},
			"cumulative":               {Desc: `irstat=cumulative`},
			"inline":                   {Desc: `inline patches`},
			"v":                        {Desc: `mark the series as the <n>-th iteration`},
			"output-indicator-old":     {Desc: `specify the character to indicate a old`},
			"progress":                 {Desc: `show progress while generating patches`},
			"quiet":                    {Desc: `suppress the output of the names of gen`},
			"relative":                 {Desc: `exclude changes outside and output rela`},
			"word-diff-regex":          {Desc: `specify what constitutes a word`},
			"color-moved":              {Desc: `color moved lines differently`},
			"color-moved-ws":           {Desc: `configure how whitespace is ignored whe`},
			"output-indicator-context": {Desc: `specify the character to indicate a con`},
			"G":                        {Desc: `look for differences whose added or rem`},
			"no-thread":                {Desc: `do not thread messages`},
			"ws-error-highlight":       {Desc: `specify where to highlight whitespace e`},
			"C":                        {Desc: `detect copies as well as renames with g`},
			"M":                        {Desc: `detect renames with given scope`},
			"ignore-submodules":        {Desc: `ignore changes to submodules`},
			"numbered-files":           {Desc: `use only number for file name`},
			"u":                        {Desc: `generate diff in patch format`},
			"rename-empty":             {Desc: `use empty blobs as rename source`},
			"synonym":                  {Desc: `irstat=cumulative`},
			"dirstat-by-file":          {Desc: `generate dirstat by number of files`},
			"D":                        {Desc: `omit the preimage for deletes`},
			"pickaxe-regex":            {Desc: `treat argument of -S as regular express`},
			"ignore-space-at-eol":      {Desc: `ignore changes in whitespace at end of`},
			"patience":                 {Desc: `generate diffs with patience algorithm`},
			"in":                       {Desc: `ull-index, output bin`},
			"to":                       {Desc: `add To: header to email headers`},
			"diff-algorithm":           {Desc: `choose a diff algorithm`},
			"text":                     {Desc: `treat all files as text`},
			"S":                        {Desc: `look for differences that add or remove`},
			"find-copies":              {Desc: `detect copies as well as renames with g`},
			"find-renames":             {Desc: `detect renames with given scope`},
			"raw":                      {Desc: `generate default raw diff output`},
			"creation-factor":          {Desc: `for range-diff, specify weighting for c`},
			"textconv":                 {Desc: `allow external text conversion filters`},
			"thread":                   {Desc: `make the second and subsequent mails re`},
			"irreversible-delete":      {Desc: `omit the preimage for deletes`},
			"s":                        {Desc: `add Signed-off-by: line to the commit m`},
			"subject-prefix":           {Desc: `use the given prefix instead of [PATCH]`},
			"anchored":                 {Desc: `generate diffs using the "anchored diff`},
			"rfc":                      {Desc: `use [RFC PATCH] instead of [PATCH]`},
			"no-renames":               {Desc: `turn off rename detection`},
			"stdout":                   {Desc: `output the generated mbox on standard o`},
			"from":                     {Desc: `add From: header to email headers`},
			"no-binary":                {Desc: `do not output contents of changes in bi`},
			"no-indent-heuristic":      {Desc: `disable heuristic that shifts diff hunk`},
			"stat-count":               {Desc: `generate diffstat with limited lines`},
			"cc":                       {Desc: `add Cc: header to email headers`},
			"interdiff":                {Desc: `insert interdiff against previous patch`},
			"ita-invisible-in-index":   {Desc: `hide 'git add -N' entries from the inde`},
			"b":                        {Desc: `ignore changes in amount of white space`},
			"name-only":                {Desc: `show only names of changed files`},
			"stat":                     {Desc: `generate diffstat instead of patch`},
			"abbrev":                   {Desc: `set minimum SHA1 display-length`},
			"compact-summary":          {Desc: `generate compact summary in diffstat`},
			"full-index":               {Desc: `show full object name of pre- and post-`},
			"color":                    {Desc: `show colored diff`},
			"color-words":              {Desc: `show colored-word diff`},
			"reroll-count":             {Desc: `mark the series as the <n>-th iteration`},
			"ignore-cr-at-eol":         {Desc: `ignore carriage-return at end of line`},
			"signoff":                  {Desc: `add Signed-off-by: line to the commit m`},
			"check":                    {Desc: `warn if changes introduce trailing whit`},
			"diff-filter":              {Desc: `select certain kinds of files for diff`},
			"find-copies-harder":       {Desc: `try harder to find copies`},
			"summary":                  {Desc: `generate condensed summary of extended`},
			"add-header":               {Desc: `add an arbitrary header to email header`},
			"notes":                    {Desc: `append notes for the commit after the t`},
			"shortstat":                {Desc: `generate summary diffstat`},
			"stat-graph-width":         {Desc: `generate diffstat with a given graph wi`},
			"stat-width":               {Desc: `generate diffstat with a given width`},
			"zero-commit":              {Desc: `output all-zero hash in From header`},
			"l":                        {Desc: `limit number of rename/copy targets to`},
			"c":                        {Desc: `combined diff format for merge commits`},
			"numbered":                 {Desc: `name output in [PATCH n/m] format`},
			"patch-with-stat":          {Desc: `generate patch and prepend its diffstat`},
			"root":                     {Desc: `treat the revision argument as a range`},
			"signature":                {Desc: `add a signature`},
			"dst-prefix":               {Desc: `use given prefix for destination`},
			"line-prefix":              {Desc: `prepend additional prefix to every line`},
			"no-attach":                {Desc: `disable creation of attachments`},
			"no-patch":                 {Desc: `suppress diff output`},
			"src-prefix":               {Desc: `use given prefix for source`},
			"no-prefix":                {Desc: `do not show any source or destination p`},
			"no-signature":             {Desc: `do not add a signature`},
			"n":                        {Desc: `name output in [PATCH n/m] format`},
			"B":                        {Desc: `break complete rewrite changes into pai`},
			"dirstat":                  {Desc: `generate dirstat by amount of changes`},
			"ignore-if-in-upstream":    {Desc: `do not include a patch that matches a c`},
			"no-numbered":              {Desc: `name output in [PATCH] format`},
			"attach":                   {Desc: `create attachments instead of inlining`},
			"for":                      {Desc: `irstat=cumulative`},
			"ignore-blank-lines":       {Desc: `do not show hunks that add or remove bl`},
			"U":                        {Desc: `generate diff with given lines of conte`},
			"minimal":                  {Desc: `spend extra time to make sure the small`},
			"patch-with-raw":           {Desc: `generate patch but also keep the defaul`},
			"signature-file":           {Desc: `use contents of file as signature`},
			"z":                        {Desc: `use NUL termination on output`},
			"no-ext-diff":              {Desc: `disallow external diff helper to be exe`},
			"output-directory":         {Desc: `store resulting files in given director`},
			"q":                        {Desc: `suppress the output of the names of gen`},
			"name-status":              {Desc: `show only names and status of changed f`},
			"no-color":                 {Desc: `turn off colored diff`},
			"no-textconv":              {Desc: `do not allow external text conversion f`},
			"find-object":              {Desc: `look for differences that change the nu`},
			"inter-hunk-context":       {Desc: `combine hunks closer than n lines`},
			"word-diff":                {Desc: `show word diff`},
			"exit-code":                {Desc: `report exit code 1 if differences, 0 ot`},
			"numstat":                  {Desc: `generate more machine-friendly diffstat`},
			"output":                   {Desc: `undocumented`},
			"N":                        {Desc: `name output in [PATCH] format`},
			"O":                        {Desc: `output patch in the order of glob-patte`},
			"ignore-all-space":         {Desc: `ignore white space when comparing lines`},
			"in-reply-to":              {Desc: `make the first mail a reply to the give`},
			"k":                        {Desc: `don't strip/add [PATCH] from the first`},
		},
	},
	"merge-base": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"independent": {Desc: `display minimal subset of supplied commits with same anc`},
			"is-ancestor": {Desc: `tell if A is ancestor of B (by exit status)`},
			"octopus":     {Desc: `compute best common ancestors of all supplied commits`},
			"all":         {Desc: `display all common ancestors`},
			"a":           {Desc: `display all common ancestors`},
			"fork-point":  {Desc: `find the point at which B forked from ref A (uses reflog`},
		},
	},
	"show-ref": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"verify":           {Desc: `enable stricter reference checking`},
			"s":                {Desc: `only show the SHA-1 hash, not the reference name`},
			"heads":            {Desc: `show only refs/heads`},
			"q":                {Desc: `do not print any results`},
			"tags":             {Desc: `show only refs/tags`},
			"hash":             {Desc: `only show the SHA-1 hash, not the reference name`},
			"head":             {Desc: `show the HEAD reference, even if it would normally`},
			"quiet":            {Desc: `do not print any results`},
			"abbrev":           {Desc: `set minimum SHA1 display-length`},
			"dereference":      {Desc: `dereference tags into object IDs as well`},
			"d":                {Desc: `dereference tags into object IDs as well`},
			"exclude-existing": {Desc: `filter out existing refs from stdin`},
		},
	},
	"count-objects": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"human-readable": {Desc: `print sizes in human readable format`},
			"H":              {Desc: `print sizes in human readable format`},
			"verbose":        {Desc: `also report number of in-pack objects and objects tha`},
			"v":              {Desc: `also report number of in-pack objects and objects tha`},
		},
	},
	"cherry": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"abbrev":  {Desc: `set minimum SHA1 display-length`},
			"verbose": {Desc: `output additional information`},
			"v":       {Desc: `output additional information`},
		},
	},
	"citool": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"pack-refs": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{},
	},
	"show-branch": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"all":         {Desc: `show both remote-tracking branches and local branches`},
			"color":       {Desc: `color status sign of commits`},
			"r":           {Desc: `show remote-tracking branches`},
			"sparse":      {Desc: `output merges that are reachable from multiple tips bein`},
			"a":           {Desc: `show both remote-tracking branches and local branches`},
			"date-order":  {Desc: `show commits in commit-date order`},
			"list":        {Desc: `ore=-1)`},
			"any":         {Desc: `ore=-1)`},
			"ancestry":    {Desc: `ore=-1)`},
			"reflog":      {Desc: `show reflog entries for given ref`},
			"topics":      {Desc: `show only commits that are NOT on the first branch given`},
			"independent": {Desc: `show only the reference that can not be reached from any`},
			"no-color":    {Desc: `do not color status sign of commits`},
			"no-name":     {Desc: `do not show naming strings for each commit`},
			"remotes":     {Desc: `show remote-tracking branches`},
			"sha1-name":   {Desc: `name commits with unique prefix of object names`},
			"topo-order":  {Desc: `show commits in topological order`},
			"more":        {Desc: `go given number of commit beyond common ancestor (no anc`},
			"g":           {Desc: `show reflog entries for given ref`},
			"current":     {Desc: `include current branch to the list of revs`},
			"do":          {Desc: `ore=-1)`},
			"not":         {Desc: `ore=-1)`},
			"show":        {Desc: `ore=-1)`},
			"(":           {Desc: `ore=-1)`},
			"merge-base":  {Desc: `act like git merge-base -a, but with two heads`},
		},
	},
	"submodule": {Desc: "", Sub: map[string]*complete.CompTree{"deinit": {Desc: "unregister a submodule", Sub: map[string]*complete.CompTree{}},
		"set-branch":    {Desc: "set the default remote tracking branch for the submodule", Sub: map[string]*complete.CompTree{}},
		"sync":          {Desc: "synchronize submodule settings", Sub: map[string]*complete.CompTree{}},
		"update":        {Desc: "update a submodule", Sub: map[string]*complete.CompTree{}},
		"absorbgitdirs": {Desc: "move the git directory of a submodule into its superprojec", Sub: map[string]*complete.CompTree{}},
		"add":           {Desc: "add given repository as a submodule", Sub: map[string]*complete.CompTree{}},
		"foreach":       {Desc: "evaluate shell command in each checked-out submodule", Sub: map[string]*complete.CompTree{}},
		"init":          {Desc: "initialize a submodule", Sub: map[string]*complete.CompTree{}},
		"status":        {Desc: "show the status of a submodule", Sub: map[string]*complete.CompTree{}},
		"summary":       {Desc: "show commit summary between given commit and working tree/", Sub: map[string]*complete.CompTree{}},
	},
		Flags: map[string]*complete.CompTree{
			"quiet": {Desc: `suppress all output`},
			"q":     {Desc: `suppress all output`},
		},
	},
	"update-server-info": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"force": {Desc: `update the info files from scratch`},
			"f":     {Desc: `update the info files from scratch`},
		},
	},
	"checkout-index": {Desc: "", Sub: map[string]*complete.CompTree{},
		Flags: map[string]*complete.CompTree{
			"stage":     {Desc: `check out files from named stage`},
			"temp":      {Desc: `write content to temporary files`},
			"a":         {Desc: `check out all files in index`},
			"f":         {Desc: `force overwrite of existing files`},
			"prefix":    {Desc: `prefix to use when creating files`},
			"index":     {Desc: `update stat information in index`},
			"n":         {Desc: `do not checkout new files`},
			"force":     {Desc: `force overwrite of existing files`},
			"u":         {Desc: `update stat information in index`},
			"quiet":     {Desc: `no warning for existing files and files not in index`},
			"stdin":     {Desc: `read list of paths from the standard input`},
			"all":       {Desc: `check out all files in index`},
			"no-create": {Desc: `do not checkout new files`},
			"q":         {Desc: `no warning for existing files and files not in index`},
		},
	},
}}
