// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: protocoltypes.proto

package protocoltypes

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"

	pushtypes "berty.tech/berty/v2/go/pkg/pushtypes"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = proto.Marshal
	_ = fmt.Errorf
	_ = math.Inf
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type GroupType int32

const (
	// GroupTypeUndefined indicates that the value has not been set. For example, happens if group is replicated.
	GroupTypeUndefined GroupType = 0
	// GroupTypeAccount is the group managing an account, available to all its devices.
	GroupTypeAccount GroupType = 1
	// GroupTypeContact is the group created between two accounts, available to all their devices.
	GroupTypeContact GroupType = 2
	// GroupTypeMultiMember is a group containing an undefined number of members.
	GroupTypeMultiMember GroupType = 3
)

var GroupType_name = map[int32]string{
	0: "GroupTypeUndefined",
	1: "GroupTypeAccount",
	2: "GroupTypeContact",
	3: "GroupTypeMultiMember",
}

var GroupType_value = map[string]int32{
	"GroupTypeUndefined":   0,
	"GroupTypeAccount":     1,
	"GroupTypeContact":     2,
	"GroupTypeMultiMember": 3,
}

func (x GroupType) String() string {
	return proto.EnumName(GroupType_name, int32(x))
}

func (GroupType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{0}
}

type EventType int32

const (
	// EventTypeUndefined indicates that the value has not been set. Should not happen.
	EventTypeUndefined EventType = 0
	// EventTypeGroupMemberDeviceAdded indicates the payload includes that a member has added their device to the group
	EventTypeGroupMemberDeviceAdded EventType = 1
	// EventTypeGroupDeviceSecretAdded indicates the payload includes that a member has sent their device secret to another member
	EventTypeGroupDeviceSecretAdded EventType = 2
	// EventTypeAccountGroupJoined indicates the payload includes that the account has joined a group
	EventTypeAccountGroupJoined EventType = 101
	// EventTypeAccountGroupLeft indicates the payload includes that the account has left a group
	EventTypeAccountGroupLeft EventType = 102
	// EventTypeAccountContactRequestDisabled indicates the payload includes that the account has disabled incoming contact requests
	EventTypeAccountContactRequestDisabled EventType = 103
	// EventTypeAccountContactRequestEnabled indicates the payload includes that the account has enabled incoming contact requests
	EventTypeAccountContactRequestEnabled EventType = 104
	// EventTypeAccountContactRequestReferenceReset indicates the payload includes that the account has a new contact request rendezvous seed
	EventTypeAccountContactRequestReferenceReset EventType = 105
	// EventTypeAccountContactRequestEnqueued indicates the payload includes that the account will attempt to send a new contact request
	EventTypeAccountContactRequestOutgoingEnqueued EventType = 106
	// EventTypeAccountContactRequestSent indicates the payload includes that the account has sent a contact request
	EventTypeAccountContactRequestOutgoingSent EventType = 107
	// EventTypeAccountContactRequestReceived indicates the payload includes that the account has received a contact request
	EventTypeAccountContactRequestIncomingReceived EventType = 108
	// EventTypeAccountContactRequestIncomingDiscarded indicates the payload includes that the account has ignored a contact request
	EventTypeAccountContactRequestIncomingDiscarded EventType = 109
	// EventTypeAccountContactRequestAccepted indicates the payload includes that the account has accepted a contact request
	EventTypeAccountContactRequestIncomingAccepted EventType = 110
	// EventTypeAccountContactBlocked indicates the payload includes that the account has blocked a contact
	EventTypeAccountContactBlocked EventType = 111
	// EventTypeAccountContactUnblocked indicates the payload includes that the account has unblocked a contact
	EventTypeAccountContactUnblocked EventType = 112
	// EventTypeContactAliasKeyAdded indicates the payload includes that the contact group has received an alias key
	EventTypeContactAliasKeyAdded EventType = 201
	// EventTypeMultiMemberGroupAliasResolverAdded indicates the payload includes that a member of the group sent their alias proof
	EventTypeMultiMemberGroupAliasResolverAdded EventType = 301
	// EventTypeMultiMemberGroupInitialMemberAnnounced indicates the payload includes that a member has authenticated themselves as the group owner
	EventTypeMultiMemberGroupInitialMemberAnnounced EventType = 302
	// EventTypeMultiMemberGroupAdminRoleGranted indicates the payload includes that an admin of the group granted another member as an admin
	EventTypeMultiMemberGroupAdminRoleGranted EventType = 303
	// EventTypeAccountServiceTokenAdded indicates that a new service provider has been registered for this account
	EventTypeAccountServiceTokenAdded EventType = 401
	// EventTypeAccountServiceTokenRemoved indicates that a service provider is not available anymore
	EventTypeAccountServiceTokenRemoved EventType = 402
	// EventTypeGroupReplicating indicates that the group has been registered for replication on a server
	EventTypeGroupReplicating EventType = 403
	// EventTypePushMemberTokenUpdate
	EventTypePushMemberTokenUpdate EventType = 404
	// EventTypePushDeviceTokenRegistered
	EventTypePushDeviceTokenRegistered EventType = 405
	// EventTypePushDeviceServerRegistered
	EventTypePushDeviceServerRegistered EventType = 406
	// EventTypeGroupMetadataPayloadSent indicates the payload includes an app specific event, unlike messages stored on the message store it is encrypted using a static key
	EventTypeGroupMetadataPayloadSent EventType = 1001
)

var EventType_name = map[int32]string{
	0:    "EventTypeUndefined",
	1:    "EventTypeGroupMemberDeviceAdded",
	2:    "EventTypeGroupDeviceSecretAdded",
	101:  "EventTypeAccountGroupJoined",
	102:  "EventTypeAccountGroupLeft",
	103:  "EventTypeAccountContactRequestDisabled",
	104:  "EventTypeAccountContactRequestEnabled",
	105:  "EventTypeAccountContactRequestReferenceReset",
	106:  "EventTypeAccountContactRequestOutgoingEnqueued",
	107:  "EventTypeAccountContactRequestOutgoingSent",
	108:  "EventTypeAccountContactRequestIncomingReceived",
	109:  "EventTypeAccountContactRequestIncomingDiscarded",
	110:  "EventTypeAccountContactRequestIncomingAccepted",
	111:  "EventTypeAccountContactBlocked",
	112:  "EventTypeAccountContactUnblocked",
	201:  "EventTypeContactAliasKeyAdded",
	301:  "EventTypeMultiMemberGroupAliasResolverAdded",
	302:  "EventTypeMultiMemberGroupInitialMemberAnnounced",
	303:  "EventTypeMultiMemberGroupAdminRoleGranted",
	401:  "EventTypeAccountServiceTokenAdded",
	402:  "EventTypeAccountServiceTokenRemoved",
	403:  "EventTypeGroupReplicating",
	404:  "EventTypePushMemberTokenUpdate",
	405:  "EventTypePushDeviceTokenRegistered",
	406:  "EventTypePushDeviceServerRegistered",
	1001: "EventTypeGroupMetadataPayloadSent",
}

var EventType_value = map[string]int32{
	"EventTypeUndefined":                              0,
	"EventTypeGroupMemberDeviceAdded":                 1,
	"EventTypeGroupDeviceSecretAdded":                 2,
	"EventTypeAccountGroupJoined":                     101,
	"EventTypeAccountGroupLeft":                       102,
	"EventTypeAccountContactRequestDisabled":          103,
	"EventTypeAccountContactRequestEnabled":           104,
	"EventTypeAccountContactRequestReferenceReset":    105,
	"EventTypeAccountContactRequestOutgoingEnqueued":  106,
	"EventTypeAccountContactRequestOutgoingSent":      107,
	"EventTypeAccountContactRequestIncomingReceived":  108,
	"EventTypeAccountContactRequestIncomingDiscarded": 109,
	"EventTypeAccountContactRequestIncomingAccepted":  110,
	"EventTypeAccountContactBlocked":                  111,
	"EventTypeAccountContactUnblocked":                112,
	"EventTypeContactAliasKeyAdded":                   201,
	"EventTypeMultiMemberGroupAliasResolverAdded":     301,
	"EventTypeMultiMemberGroupInitialMemberAnnounced": 302,
	"EventTypeMultiMemberGroupAdminRoleGranted":       303,
	"EventTypeAccountServiceTokenAdded":               401,
	"EventTypeAccountServiceTokenRemoved":             402,
	"EventTypeGroupReplicating":                       403,
	"EventTypePushMemberTokenUpdate":                  404,
	"EventTypePushDeviceTokenRegistered":              405,
	"EventTypePushDeviceServerRegistered":             406,
	"EventTypeGroupMetadataPayloadSent":               1001,
}

func (x EventType) String() string {
	return proto.EnumName(EventType_name, int32(x))
}

func (EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{1}
}

type DebugInspectGroupLogType int32

const (
	DebugInspectGroupLogTypeUndefined DebugInspectGroupLogType = 0
	DebugInspectGroupLogTypeMessage   DebugInspectGroupLogType = 1
	DebugInspectGroupLogTypeMetadata  DebugInspectGroupLogType = 2
)

var DebugInspectGroupLogType_name = map[int32]string{
	0: "DebugInspectGroupLogTypeUndefined",
	1: "DebugInspectGroupLogTypeMessage",
	2: "DebugInspectGroupLogTypeMetadata",
}

var DebugInspectGroupLogType_value = map[string]int32{
	"DebugInspectGroupLogTypeUndefined": 0,
	"DebugInspectGroupLogTypeMessage":   1,
	"DebugInspectGroupLogTypeMetadata":  2,
}

func (x DebugInspectGroupLogType) String() string {
	return proto.EnumName(DebugInspectGroupLogType_name, int32(x))
}

func (DebugInspectGroupLogType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{2}
}

type ContactState int32

const (
	ContactStateUndefined ContactState = 0
	ContactStateToRequest ContactState = 1
	ContactStateReceived  ContactState = 2
	ContactStateAdded     ContactState = 3
	ContactStateRemoved   ContactState = 4
	ContactStateDiscarded ContactState = 5
	ContactStateBlocked   ContactState = 6
)

var ContactState_name = map[int32]string{
	0: "ContactStateUndefined",
	1: "ContactStateToRequest",
	2: "ContactStateReceived",
	3: "ContactStateAdded",
	4: "ContactStateRemoved",
	5: "ContactStateDiscarded",
	6: "ContactStateBlocked",
}

var ContactState_value = map[string]int32{
	"ContactStateUndefined": 0,
	"ContactStateToRequest": 1,
	"ContactStateReceived":  2,
	"ContactStateAdded":     3,
	"ContactStateRemoved":   4,
	"ContactStateDiscarded": 5,
	"ContactStateBlocked":   6,
}

func (x ContactState) String() string {
	return proto.EnumName(ContactState_name, int32(x))
}

func (ContactState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{3}
}

type Direction int32

const (
	UnknownDir  Direction = 0
	InboundDir  Direction = 1
	OutboundDir Direction = 2
	BiDir       Direction = 3
)

var Direction_name = map[int32]string{
	0: "UnknownDir",
	1: "InboundDir",
	2: "OutboundDir",
	3: "BiDir",
}

var Direction_value = map[string]int32{
	"UnknownDir":  0,
	"InboundDir":  1,
	"OutboundDir": 2,
	"BiDir":       3,
}

func (x Direction) String() string {
	return proto.EnumName(Direction_name, int32(x))
}

func (Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{4}
}

type InstanceGetConfiguration_SettingState int32

const (
	Unknown     InstanceGetConfiguration_SettingState = 0
	Enabled     InstanceGetConfiguration_SettingState = 1
	Disabled    InstanceGetConfiguration_SettingState = 2
	Unavailable InstanceGetConfiguration_SettingState = 3
)

var InstanceGetConfiguration_SettingState_name = map[int32]string{
	0: "Unknown",
	1: "Enabled",
	2: "Disabled",
	3: "Unavailable",
}

var InstanceGetConfiguration_SettingState_value = map[string]int32{
	"Unknown":     0,
	"Enabled":     1,
	"Disabled":    2,
	"Unavailable": 3,
}

func (x InstanceGetConfiguration_SettingState) String() string {
	return proto.EnumName(InstanceGetConfiguration_SettingState_name, int32(x))
}

func (InstanceGetConfiguration_SettingState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{36, 0}
}

type MonitorGroup_TypeEventMonitor int32

const (
	TypeEventMonitorUndefined      MonitorGroup_TypeEventMonitor = 0
	TypeEventMonitorAdvertiseGroup MonitorGroup_TypeEventMonitor = 1
	TypeEventMonitorPeerFound      MonitorGroup_TypeEventMonitor = 2
	TypeEventMonitorPeerJoin       MonitorGroup_TypeEventMonitor = 3
	TypeEventMonitorPeerLeave      MonitorGroup_TypeEventMonitor = 4
)

var MonitorGroup_TypeEventMonitor_name = map[int32]string{
	0: "TypeEventMonitorUndefined",
	1: "TypeEventMonitorAdvertiseGroup",
	2: "TypeEventMonitorPeerFound",
	3: "TypeEventMonitorPeerJoin",
	4: "TypeEventMonitorPeerLeave",
}

var MonitorGroup_TypeEventMonitor_value = map[string]int32{
	"TypeEventMonitorUndefined":      0,
	"TypeEventMonitorAdvertiseGroup": 1,
	"TypeEventMonitorPeerFound":      2,
	"TypeEventMonitorPeerJoin":       3,
	"TypeEventMonitorPeerLeave":      4,
}

func (x MonitorGroup_TypeEventMonitor) String() string {
	return proto.EnumName(MonitorGroup_TypeEventMonitor_name, int32(x))
}

func (MonitorGroup_TypeEventMonitor) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 0}
}

type PeerList_Feature int32

const (
	UnknownFeature PeerList_Feature = 0
	BertyFeature   PeerList_Feature = 1
	BLEFeature     PeerList_Feature = 2
	LocalFeature   PeerList_Feature = 3
	TorFeature     PeerList_Feature = 4
	QuicFeature    PeerList_Feature = 5
)

var PeerList_Feature_name = map[int32]string{
	0: "UnknownFeature",
	1: "BertyFeature",
	2: "BLEFeature",
	3: "LocalFeature",
	4: "TorFeature",
	5: "QuicFeature",
}

var PeerList_Feature_value = map[string]int32{
	"UnknownFeature": 0,
	"BertyFeature":   1,
	"BLEFeature":     2,
	"LocalFeature":   3,
	"TorFeature":     4,
	"QuicFeature":    5,
}

func (x PeerList_Feature) String() string {
	return proto.EnumName(PeerList_Feature_name, int32(x))
}

func (PeerList_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 0}
}

// Account describes all the secrets that identifies an Account
type Account struct {
	// group specifies which group is used to manage the account
	Group *Group `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// account_private_key, private part is used to signs handshake, signs device, create contacts group keys via ECDH -- public part is used to have a shareable identity
	AccountPrivateKey []byte `protobuf:"bytes,2,opt,name=account_private_key,json=accountPrivateKey,proto3" json:"account_private_key,omitempty"`
	// alias_private_key, private part is use to derive group members private keys, signs alias proofs, public part can be shared to contacts to prove identity
	AliasPrivateKey []byte `protobuf:"bytes,3,opt,name=alias_private_key,json=aliasPrivateKey,proto3" json:"alias_private_key,omitempty"`
	// public_rendezvous_seed, rendezvous seed used for direct communication
	PublicRendezvousSeed []byte   `protobuf:"bytes,4,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Account) Reset()         { *m = Account{} }
func (m *Account) String() string { return proto.CompactTextString(m) }
func (*Account) ProtoMessage()    {}
func (*Account) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{0}
}

func (m *Account) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *Account) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Account.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *Account) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Account.Merge(m, src)
}

func (m *Account) XXX_Size() int {
	return m.Size()
}

func (m *Account) XXX_DiscardUnknown() {
	xxx_messageInfo_Account.DiscardUnknown(m)
}

var xxx_messageInfo_Account proto.InternalMessageInfo

func (m *Account) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *Account) GetAccountPrivateKey() []byte {
	if m != nil {
		return m.AccountPrivateKey
	}
	return nil
}

func (m *Account) GetAliasPrivateKey() []byte {
	if m != nil {
		return m.AliasPrivateKey
	}
	return nil
}

func (m *Account) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

// Group define a group and is enough to invite someone to it
type Group struct {
	// public_key is the identifier of the group, it signs the group secret and the initial member of a multi-member group
	PublicKey []byte `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// secret is the symmetric secret of the group, which is used to encrypt the metadata
	Secret []byte `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	// secret_sig is the signature of the secret used to ensure the validity of the group
	SecretSig []byte `protobuf:"bytes,3,opt,name=secret_sig,json=secretSig,proto3" json:"secret_sig,omitempty"`
	// group_type specifies the type of the group, used to determine how device secrets are generated
	GroupType GroupType `protobuf:"varint,4,opt,name=group_type,json=groupType,proto3,enum=berty.protocol.v1.GroupType" json:"group_type,omitempty"`
	// sign_pub is the signature public key used to verify entries, not required when secret and secret_sig are provided
	SignPub []byte `protobuf:"bytes,5,opt,name=sign_pub,json=signPub,proto3" json:"sign_pub,omitempty"`
	// link_key is the secret key used to exchange group updates and links to attachments, useful for replication services
	LinkKey []byte `protobuf:"bytes,6,opt,name=link_key,json=linkKey,proto3" json:"link_key,omitempty"`
	// link_key_sig is the signature of the link_key using the group private key
	LinkKeySig           []byte   `protobuf:"bytes,7,opt,name=link_key_sig,json=linkKeySig,proto3" json:"link_key_sig,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{1}
}

func (m *Group) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Group.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(m, src)
}

func (m *Group) XXX_Size() int {
	return m.Size()
}

func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetPublicKey() []byte {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *Group) GetSecret() []byte {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *Group) GetSecretSig() []byte {
	if m != nil {
		return m.SecretSig
	}
	return nil
}

func (m *Group) GetGroupType() GroupType {
	if m != nil {
		return m.GroupType
	}
	return GroupTypeUndefined
}

func (m *Group) GetSignPub() []byte {
	if m != nil {
		return m.SignPub
	}
	return nil
}

func (m *Group) GetLinkKey() []byte {
	if m != nil {
		return m.LinkKey
	}
	return nil
}

func (m *Group) GetLinkKeySig() []byte {
	if m != nil {
		return m.LinkKeySig
	}
	return nil
}

type GroupHeadsExport struct {
	// public_key is the identifier of the group, it signs the group secret and the initial member of a multi-member group
	PublicKey []byte `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// sign_pub is the signature public key used to verify entries
	SignPub []byte `protobuf:"bytes,2,opt,name=sign_pub,json=signPub,proto3" json:"sign_pub,omitempty"`
	// metadata_heads_cids are the heads of the metadata store that should be restored from an export
	MetadataHeadsCIDs [][]byte `protobuf:"bytes,3,rep,name=metadata_heads_cids,json=metadataHeadsCids,proto3" json:"metadata_heads_cids,omitempty"`
	// messages_heads_cids are the heads of the metadata store that should be restored from an export
	MessagesHeadsCIDs [][]byte `protobuf:"bytes,4,rep,name=messages_heads_cids,json=messagesHeadsCids,proto3" json:"messages_heads_cids,omitempty"`
	// link_key
	LinkKey              []byte   `protobuf:"bytes,5,opt,name=link_key,json=linkKey,proto3" json:"link_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupHeadsExport) Reset()         { *m = GroupHeadsExport{} }
func (m *GroupHeadsExport) String() string { return proto.CompactTextString(m) }
func (*GroupHeadsExport) ProtoMessage()    {}
func (*GroupHeadsExport) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{2}
}

func (m *GroupHeadsExport) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupHeadsExport) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupHeadsExport.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupHeadsExport) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupHeadsExport.Merge(m, src)
}

func (m *GroupHeadsExport) XXX_Size() int {
	return m.Size()
}

func (m *GroupHeadsExport) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupHeadsExport.DiscardUnknown(m)
}

var xxx_messageInfo_GroupHeadsExport proto.InternalMessageInfo

func (m *GroupHeadsExport) GetPublicKey() []byte {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *GroupHeadsExport) GetSignPub() []byte {
	if m != nil {
		return m.SignPub
	}
	return nil
}

func (m *GroupHeadsExport) GetMetadataHeadsCIDs() [][]byte {
	if m != nil {
		return m.MetadataHeadsCIDs
	}
	return nil
}

func (m *GroupHeadsExport) GetMessagesHeadsCIDs() [][]byte {
	if m != nil {
		return m.MessagesHeadsCIDs
	}
	return nil
}

func (m *GroupHeadsExport) GetLinkKey() []byte {
	if m != nil {
		return m.LinkKey
	}
	return nil
}

// GroupMetadata is used in GroupEnvelope and only readable by invited group members
type GroupMetadata struct {
	// event_type defines which event type is used
	EventType EventType `protobuf:"varint,1,opt,name=event_type,json=eventType,proto3,enum=berty.protocol.v1.EventType" json:"event_type,omitempty"`
	// the serialization depends on event_type, event is symmetrically encrypted
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// sig is the signature of the payload, it depends on the event_type for the used key
	Sig []byte `protobuf:"bytes,3,opt,name=sig,proto3" json:"sig,omitempty"`
	// protocol_metadata is protocol layer data
	ProtocolMetadata     *ProtocolMetadata `protobuf:"bytes,4,opt,name=protocol_metadata,json=protocolMetadata,proto3" json:"protocol_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GroupMetadata) Reset()         { *m = GroupMetadata{} }
func (m *GroupMetadata) String() string { return proto.CompactTextString(m) }
func (*GroupMetadata) ProtoMessage()    {}
func (*GroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{3}
}

func (m *GroupMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMetadata.Merge(m, src)
}

func (m *GroupMetadata) XXX_Size() int {
	return m.Size()
}

func (m *GroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMetadata proto.InternalMessageInfo

func (m *GroupMetadata) GetEventType() EventType {
	if m != nil {
		return m.EventType
	}
	return EventTypeUndefined
}

func (m *GroupMetadata) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *GroupMetadata) GetSig() []byte {
	if m != nil {
		return m.Sig
	}
	return nil
}

func (m *GroupMetadata) GetProtocolMetadata() *ProtocolMetadata {
	if m != nil {
		return m.ProtocolMetadata
	}
	return nil
}

// GroupEnvelope is a publicly exposed structure containing a group metadata event
type GroupEnvelope struct {
	// nonce is used to encrypt the message
	Nonce []byte `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// event is encrypted using a symmetric key shared among group members
	Event []byte `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// encrypted_attachment_cids is a list of attachment CIDs encrypted specifically for replication services
	EncryptedAttachmentCIDs [][]byte `protobuf:"bytes,3,rep,name=encrypted_attachment_cids,json=encryptedAttachmentCids,proto3" json:"encrypted_attachment_cids,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *GroupEnvelope) Reset()         { *m = GroupEnvelope{} }
func (m *GroupEnvelope) String() string { return proto.CompactTextString(m) }
func (*GroupEnvelope) ProtoMessage()    {}
func (*GroupEnvelope) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{4}
}

func (m *GroupEnvelope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupEnvelope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupEnvelope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupEnvelope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupEnvelope.Merge(m, src)
}

func (m *GroupEnvelope) XXX_Size() int {
	return m.Size()
}

func (m *GroupEnvelope) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupEnvelope.DiscardUnknown(m)
}

var xxx_messageInfo_GroupEnvelope proto.InternalMessageInfo

func (m *GroupEnvelope) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

func (m *GroupEnvelope) GetEvent() []byte {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *GroupEnvelope) GetEncryptedAttachmentCIDs() [][]byte {
	if m != nil {
		return m.EncryptedAttachmentCIDs
	}
	return nil
}

// MessageHeaders is used in MessageEnvelope and only readable by invited group members
type MessageHeaders struct {
	// counter is the current counter value for the specified device
	Counter uint64 `protobuf:"varint,1,opt,name=counter,proto3" json:"counter,omitempty"`
	// device_pk is the public key of the device sending the message
	DevicePK []byte `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// sig is the signature of the encrypted message using the device's private key
	Sig []byte `protobuf:"bytes,3,opt,name=sig,proto3" json:"sig,omitempty"`
	// metadata allow to pass custom informations
	Metadata             map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MessageHeaders) Reset()         { *m = MessageHeaders{} }
func (m *MessageHeaders) String() string { return proto.CompactTextString(m) }
func (*MessageHeaders) ProtoMessage()    {}
func (*MessageHeaders) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{5}
}

func (m *MessageHeaders) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MessageHeaders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MessageHeaders.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MessageHeaders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageHeaders.Merge(m, src)
}

func (m *MessageHeaders) XXX_Size() int {
	return m.Size()
}

func (m *MessageHeaders) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageHeaders.DiscardUnknown(m)
}

var xxx_messageInfo_MessageHeaders proto.InternalMessageInfo

func (m *MessageHeaders) GetCounter() uint64 {
	if m != nil {
		return m.Counter
	}
	return 0
}

func (m *MessageHeaders) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *MessageHeaders) GetSig() []byte {
	if m != nil {
		return m.Sig
	}
	return nil
}

func (m *MessageHeaders) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type ProtocolMetadata struct {
	// attachments_secrets is a list of secret keys used retrieve attachments
	AttachmentsSecrets   [][]byte `protobuf:"bytes,1,rep,name=attachments_secrets,json=attachmentsSecrets,proto3" json:"attachments_secrets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProtocolMetadata) Reset()         { *m = ProtocolMetadata{} }
func (m *ProtocolMetadata) String() string { return proto.CompactTextString(m) }
func (*ProtocolMetadata) ProtoMessage()    {}
func (*ProtocolMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{6}
}

func (m *ProtocolMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ProtocolMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProtocolMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ProtocolMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProtocolMetadata.Merge(m, src)
}

func (m *ProtocolMetadata) XXX_Size() int {
	return m.Size()
}

func (m *ProtocolMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ProtocolMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ProtocolMetadata proto.InternalMessageInfo

func (m *ProtocolMetadata) GetAttachmentsSecrets() [][]byte {
	if m != nil {
		return m.AttachmentsSecrets
	}
	return nil
}

// EncryptedMessage is used in MessageEnvelope and only readable by groups members that joined before the message was sent
type EncryptedMessage struct {
	// plaintext is the app layer data
	Plaintext []byte `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	// protocol_metadata is protocol layer data
	ProtocolMetadata     *ProtocolMetadata `protobuf:"bytes,2,opt,name=protocol_metadata,json=protocolMetadata,proto3" json:"protocol_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *EncryptedMessage) Reset()         { *m = EncryptedMessage{} }
func (m *EncryptedMessage) String() string { return proto.CompactTextString(m) }
func (*EncryptedMessage) ProtoMessage()    {}
func (*EncryptedMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{7}
}

func (m *EncryptedMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *EncryptedMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptedMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *EncryptedMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptedMessage.Merge(m, src)
}

func (m *EncryptedMessage) XXX_Size() int {
	return m.Size()
}

func (m *EncryptedMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptedMessage.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptedMessage proto.InternalMessageInfo

func (m *EncryptedMessage) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

func (m *EncryptedMessage) GetProtocolMetadata() *ProtocolMetadata {
	if m != nil {
		return m.ProtocolMetadata
	}
	return nil
}

// MessageEnvelope is a publicly exposed structure containing a group secure message
type MessageEnvelope struct {
	// message_headers is an encrypted serialization using a symmetric key of a MessageHeaders message
	MessageHeaders []byte `protobuf:"bytes,1,opt,name=message_headers,json=messageHeaders,proto3" json:"message_headers,omitempty"`
	// message is an encrypted message, only readable by group members who previously received the appropriate chain key
	Message []byte `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// nonce is a nonce for message headers
	Nonce []byte `protobuf:"bytes,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// encrypted_attachment_cids is a list of attachment CIDs encrypted specifically for replication services
	EncryptedAttachmentCIDs [][]byte `protobuf:"bytes,4,rep,name=encrypted_attachment_cids,json=encryptedAttachmentCids,proto3" json:"encrypted_attachment_cids,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *MessageEnvelope) Reset()         { *m = MessageEnvelope{} }
func (m *MessageEnvelope) String() string { return proto.CompactTextString(m) }
func (*MessageEnvelope) ProtoMessage()    {}
func (*MessageEnvelope) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{8}
}

func (m *MessageEnvelope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MessageEnvelope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MessageEnvelope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MessageEnvelope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageEnvelope.Merge(m, src)
}

func (m *MessageEnvelope) XXX_Size() int {
	return m.Size()
}

func (m *MessageEnvelope) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageEnvelope.DiscardUnknown(m)
}

var xxx_messageInfo_MessageEnvelope proto.InternalMessageInfo

func (m *MessageEnvelope) GetMessageHeaders() []byte {
	if m != nil {
		return m.MessageHeaders
	}
	return nil
}

func (m *MessageEnvelope) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *MessageEnvelope) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

func (m *MessageEnvelope) GetEncryptedAttachmentCIDs() [][]byte {
	if m != nil {
		return m.EncryptedAttachmentCIDs
	}
	return nil
}

// EventContext adds context (its id, its parents and its attachments) to an event
type EventContext struct {
	// id is the CID of the underlying OrbitDB event
	ID []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// id are the the CIDs of the underlying parents of the OrbitDB event
	ParentIDs [][]byte `protobuf:"bytes,2,rep,name=parent_ids,json=parentIds,proto3" json:"parent_ids,omitempty"`
	// group_pk receiving the event
	GroupPK []byte `protobuf:"bytes,3,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// attachment_cids is a list of attachment that can be retrieved
	AttachmentCIDs       [][]byte `protobuf:"bytes,4,rep,name=attachment_cids,json=attachmentCids,proto3" json:"attachment_cids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventContext) Reset()         { *m = EventContext{} }
func (m *EventContext) String() string { return proto.CompactTextString(m) }
func (*EventContext) ProtoMessage()    {}
func (*EventContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{9}
}

func (m *EventContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *EventContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *EventContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventContext.Merge(m, src)
}

func (m *EventContext) XXX_Size() int {
	return m.Size()
}

func (m *EventContext) XXX_DiscardUnknown() {
	xxx_messageInfo_EventContext.DiscardUnknown(m)
}

var xxx_messageInfo_EventContext proto.InternalMessageInfo

func (m *EventContext) GetID() []byte {
	if m != nil {
		return m.ID
	}
	return nil
}

func (m *EventContext) GetParentIDs() [][]byte {
	if m != nil {
		return m.ParentIDs
	}
	return nil
}

func (m *EventContext) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *EventContext) GetAttachmentCIDs() [][]byte {
	if m != nil {
		return m.AttachmentCIDs
	}
	return nil
}

// AppMetadata is an app defined message, accessible to future group members
type AppMetadata struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// message is the payload
	Message              []byte   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMetadata) Reset()         { *m = AppMetadata{} }
func (m *AppMetadata) String() string { return proto.CompactTextString(m) }
func (*AppMetadata) ProtoMessage()    {}
func (*AppMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{10}
}

func (m *AppMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMetadata.Merge(m, src)
}

func (m *AppMetadata) XXX_Size() int {
	return m.Size()
}

func (m *AppMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AppMetadata proto.InternalMessageInfo

func (m *AppMetadata) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AppMetadata) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

// ContactAddAliasKey is an event type where ones shares their alias public key
type ContactAddAliasKey struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// alias_pk is the alias key which will be used to verify a contact identity
	AliasPK              []byte   `protobuf:"bytes,2,opt,name=alias_pk,json=aliasPk,proto3" json:"alias_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactAddAliasKey) Reset()         { *m = ContactAddAliasKey{} }
func (m *ContactAddAliasKey) String() string { return proto.CompactTextString(m) }
func (*ContactAddAliasKey) ProtoMessage()    {}
func (*ContactAddAliasKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{11}
}

func (m *ContactAddAliasKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactAddAliasKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactAddAliasKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactAddAliasKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactAddAliasKey.Merge(m, src)
}

func (m *ContactAddAliasKey) XXX_Size() int {
	return m.Size()
}

func (m *ContactAddAliasKey) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactAddAliasKey.DiscardUnknown(m)
}

var xxx_messageInfo_ContactAddAliasKey proto.InternalMessageInfo

func (m *ContactAddAliasKey) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *ContactAddAliasKey) GetAliasPK() []byte {
	if m != nil {
		return m.AliasPK
	}
	return nil
}

// GroupAddMemberDevice is an event which indicates to a group a new device (and eventually a new member) is joining it
// When added on AccountGroup, this event should be followed by appropriate GroupAddMemberDevice and GroupAddDeviceSecret events
type GroupAddMemberDevice struct {
	// member_pk is the member sending the event
	MemberPK []byte `protobuf:"bytes,1,opt,name=member_pk,json=memberPk,proto3" json:"member_pk,omitempty"`
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// member_sig is used to prove the ownership of the member pk
	MemberSig            []byte   `protobuf:"bytes,3,opt,name=member_sig,json=memberSig,proto3" json:"member_sig,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAddMemberDevice) Reset()         { *m = GroupAddMemberDevice{} }
func (m *GroupAddMemberDevice) String() string { return proto.CompactTextString(m) }
func (*GroupAddMemberDevice) ProtoMessage()    {}
func (*GroupAddMemberDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{12}
}

func (m *GroupAddMemberDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupAddMemberDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupAddMemberDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupAddMemberDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAddMemberDevice.Merge(m, src)
}

func (m *GroupAddMemberDevice) XXX_Size() int {
	return m.Size()
}

func (m *GroupAddMemberDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAddMemberDevice.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAddMemberDevice proto.InternalMessageInfo

func (m *GroupAddMemberDevice) GetMemberPK() []byte {
	if m != nil {
		return m.MemberPK
	}
	return nil
}

func (m *GroupAddMemberDevice) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *GroupAddMemberDevice) GetMemberSig() []byte {
	if m != nil {
		return m.MemberSig
	}
	return nil
}

// DeviceSecret is encrypted for a specific member of the group
type DeviceSecret struct {
	// chain_key is the current value of the chain key of the group device
	ChainKey []byte `protobuf:"bytes,1,opt,name=chain_key,json=chainKey,proto3" json:"chain_key,omitempty"`
	// counter is the current value of the counter of the group device
	Counter              uint64   `protobuf:"varint,2,opt,name=counter,proto3" json:"counter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceSecret) Reset()         { *m = DeviceSecret{} }
func (m *DeviceSecret) String() string { return proto.CompactTextString(m) }
func (*DeviceSecret) ProtoMessage()    {}
func (*DeviceSecret) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{13}
}

func (m *DeviceSecret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DeviceSecret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeviceSecret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DeviceSecret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceSecret.Merge(m, src)
}

func (m *DeviceSecret) XXX_Size() int {
	return m.Size()
}

func (m *DeviceSecret) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceSecret.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceSecret proto.InternalMessageInfo

func (m *DeviceSecret) GetChainKey() []byte {
	if m != nil {
		return m.ChainKey
	}
	return nil
}

func (m *DeviceSecret) GetCounter() uint64 {
	if m != nil {
		return m.Counter
	}
	return 0
}

// GroupAddDeviceSecret is an event which indicates to a group member a device secret
type GroupAddDeviceSecret struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// dest_member_pk is the member who should receive the secret
	DestMemberPK []byte `protobuf:"bytes,2,opt,name=dest_member_pk,json=destMemberPk,proto3" json:"dest_member_pk,omitempty"`
	// payload is the serialization of Payload encrypted for the specified member
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAddDeviceSecret) Reset()         { *m = GroupAddDeviceSecret{} }
func (m *GroupAddDeviceSecret) String() string { return proto.CompactTextString(m) }
func (*GroupAddDeviceSecret) ProtoMessage()    {}
func (*GroupAddDeviceSecret) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{14}
}

func (m *GroupAddDeviceSecret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupAddDeviceSecret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupAddDeviceSecret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupAddDeviceSecret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAddDeviceSecret.Merge(m, src)
}

func (m *GroupAddDeviceSecret) XXX_Size() int {
	return m.Size()
}

func (m *GroupAddDeviceSecret) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAddDeviceSecret.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAddDeviceSecret proto.InternalMessageInfo

func (m *GroupAddDeviceSecret) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *GroupAddDeviceSecret) GetDestMemberPK() []byte {
	if m != nil {
		return m.DestMemberPK
	}
	return nil
}

func (m *GroupAddDeviceSecret) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// MultiMemberGroupAddAliasResolver indicates that a group member want to disclose their presence in the group to their contacts
type MultiMemberGroupAddAliasResolver struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// alias_resolver allows contact of an account to resolve the real identity behind an alias (Multi-Member Group Member)
	// Generated by both contacts and account independently using: hmac(aliasPK, GroupID)
	AliasResolver []byte `protobuf:"bytes,2,opt,name=alias_resolver,json=aliasResolver,proto3" json:"alias_resolver,omitempty"`
	// alias_proof ensures that the associated alias_resolver has been issued by the right account
	// Generated using aliasSKSig(GroupID)
	AliasProof           []byte   `protobuf:"bytes,3,opt,name=alias_proof,json=aliasProof,proto3" json:"alias_proof,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAddAliasResolver) Reset()         { *m = MultiMemberGroupAddAliasResolver{} }
func (m *MultiMemberGroupAddAliasResolver) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupAddAliasResolver) ProtoMessage()    {}
func (*MultiMemberGroupAddAliasResolver) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{15}
}

func (m *MultiMemberGroupAddAliasResolver) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAddAliasResolver) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAddAliasResolver.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAddAliasResolver) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAddAliasResolver.Merge(m, src)
}

func (m *MultiMemberGroupAddAliasResolver) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAddAliasResolver) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAddAliasResolver.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAddAliasResolver proto.InternalMessageInfo

func (m *MultiMemberGroupAddAliasResolver) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *MultiMemberGroupAddAliasResolver) GetAliasResolver() []byte {
	if m != nil {
		return m.AliasResolver
	}
	return nil
}

func (m *MultiMemberGroupAddAliasResolver) GetAliasProof() []byte {
	if m != nil {
		return m.AliasProof
	}
	return nil
}

// MultiMemberGrantAdminRole indicates that a group admin allows another group member to act as an admin
type MultiMemberGrantAdminRole struct {
	// device_pk is the device sending the event, signs the message, must be the device of an admin of the group
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// grantee_member_pk is the member public key of the member granted of the admin role
	GranteeMemberPK      []byte   `protobuf:"bytes,2,opt,name=grantee_member_pk,json=granteeMemberPk,proto3" json:"grantee_member_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGrantAdminRole) Reset()         { *m = MultiMemberGrantAdminRole{} }
func (m *MultiMemberGrantAdminRole) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGrantAdminRole) ProtoMessage()    {}
func (*MultiMemberGrantAdminRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{16}
}

func (m *MultiMemberGrantAdminRole) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGrantAdminRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGrantAdminRole.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGrantAdminRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGrantAdminRole.Merge(m, src)
}

func (m *MultiMemberGrantAdminRole) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGrantAdminRole) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGrantAdminRole.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGrantAdminRole proto.InternalMessageInfo

func (m *MultiMemberGrantAdminRole) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *MultiMemberGrantAdminRole) GetGranteeMemberPK() []byte {
	if m != nil {
		return m.GranteeMemberPK
	}
	return nil
}

// MultiMemberInitialMember indicates that a member is the group creator, this event is signed using the group ID private key
type MultiMemberInitialMember struct {
	// member_pk is the public key of the member who is the group creator
	MemberPK             []byte   `protobuf:"bytes,1,opt,name=member_pk,json=memberPk,proto3" json:"member_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberInitialMember) Reset()         { *m = MultiMemberInitialMember{} }
func (m *MultiMemberInitialMember) String() string { return proto.CompactTextString(m) }
func (*MultiMemberInitialMember) ProtoMessage()    {}
func (*MultiMemberInitialMember) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{17}
}

func (m *MultiMemberInitialMember) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberInitialMember) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberInitialMember.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberInitialMember) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberInitialMember.Merge(m, src)
}

func (m *MultiMemberInitialMember) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberInitialMember) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberInitialMember.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberInitialMember proto.InternalMessageInfo

func (m *MultiMemberInitialMember) GetMemberPK() []byte {
	if m != nil {
		return m.MemberPK
	}
	return nil
}

// GroupAddAdditionalRendezvousSeed indicates that an additional rendezvous point should be used for data synchronization
type GroupAddAdditionalRendezvousSeed struct {
	// device_pk is the device sending the event, signs the message, must be the device of an admin of the group
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// seed is the additional rendezvous point seed which should be used
	Seed                 []byte   `protobuf:"bytes,2,opt,name=seed,proto3" json:"seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAddAdditionalRendezvousSeed) Reset()         { *m = GroupAddAdditionalRendezvousSeed{} }
func (m *GroupAddAdditionalRendezvousSeed) String() string { return proto.CompactTextString(m) }
func (*GroupAddAdditionalRendezvousSeed) ProtoMessage()    {}
func (*GroupAddAdditionalRendezvousSeed) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{18}
}

func (m *GroupAddAdditionalRendezvousSeed) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupAddAdditionalRendezvousSeed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupAddAdditionalRendezvousSeed.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupAddAdditionalRendezvousSeed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAddAdditionalRendezvousSeed.Merge(m, src)
}

func (m *GroupAddAdditionalRendezvousSeed) XXX_Size() int {
	return m.Size()
}

func (m *GroupAddAdditionalRendezvousSeed) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAddAdditionalRendezvousSeed.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAddAdditionalRendezvousSeed proto.InternalMessageInfo

func (m *GroupAddAdditionalRendezvousSeed) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *GroupAddAdditionalRendezvousSeed) GetSeed() []byte {
	if m != nil {
		return m.Seed
	}
	return nil
}

// GroupRemoveAdditionalRendezvousSeed indicates that a previously added rendezvous point should be removed
type GroupRemoveAdditionalRendezvousSeed struct {
	// device_pk is the device sending the event, signs the message, must be the device of an admin of the group
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// seed is the additional rendezvous point seed which should be removed
	Seed                 []byte   `protobuf:"bytes,2,opt,name=seed,proto3" json:"seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupRemoveAdditionalRendezvousSeed) Reset()         { *m = GroupRemoveAdditionalRendezvousSeed{} }
func (m *GroupRemoveAdditionalRendezvousSeed) String() string { return proto.CompactTextString(m) }
func (*GroupRemoveAdditionalRendezvousSeed) ProtoMessage()    {}
func (*GroupRemoveAdditionalRendezvousSeed) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{19}
}

func (m *GroupRemoveAdditionalRendezvousSeed) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupRemoveAdditionalRendezvousSeed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupRemoveAdditionalRendezvousSeed.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupRemoveAdditionalRendezvousSeed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupRemoveAdditionalRendezvousSeed.Merge(m, src)
}

func (m *GroupRemoveAdditionalRendezvousSeed) XXX_Size() int {
	return m.Size()
}

func (m *GroupRemoveAdditionalRendezvousSeed) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupRemoveAdditionalRendezvousSeed.DiscardUnknown(m)
}

var xxx_messageInfo_GroupRemoveAdditionalRendezvousSeed proto.InternalMessageInfo

func (m *GroupRemoveAdditionalRendezvousSeed) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *GroupRemoveAdditionalRendezvousSeed) GetSeed() []byte {
	if m != nil {
		return m.Seed
	}
	return nil
}

// AccountGroupJoined indicates that the account is now part of a new group
type AccountGroupJoined struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// group describe the joined group
	Group                *Group   `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountGroupJoined) Reset()         { *m = AccountGroupJoined{} }
func (m *AccountGroupJoined) String() string { return proto.CompactTextString(m) }
func (*AccountGroupJoined) ProtoMessage()    {}
func (*AccountGroupJoined) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{20}
}

func (m *AccountGroupJoined) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountGroupJoined) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountGroupJoined.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountGroupJoined) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountGroupJoined.Merge(m, src)
}

func (m *AccountGroupJoined) XXX_Size() int {
	return m.Size()
}

func (m *AccountGroupJoined) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountGroupJoined.DiscardUnknown(m)
}

var xxx_messageInfo_AccountGroupJoined proto.InternalMessageInfo

func (m *AccountGroupJoined) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountGroupJoined) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

// AccountGroupJoined indicates that the account has left a group
type AccountGroupLeft struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// group_pk references the group left
	GroupPK              []byte   `protobuf:"bytes,2,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountGroupLeft) Reset()         { *m = AccountGroupLeft{} }
func (m *AccountGroupLeft) String() string { return proto.CompactTextString(m) }
func (*AccountGroupLeft) ProtoMessage()    {}
func (*AccountGroupLeft) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{21}
}

func (m *AccountGroupLeft) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountGroupLeft) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountGroupLeft.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountGroupLeft) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountGroupLeft.Merge(m, src)
}

func (m *AccountGroupLeft) XXX_Size() int {
	return m.Size()
}

func (m *AccountGroupLeft) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountGroupLeft.DiscardUnknown(m)
}

var xxx_messageInfo_AccountGroupLeft proto.InternalMessageInfo

func (m *AccountGroupLeft) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountGroupLeft) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

// AccountContactRequestDisabled indicates that the account should not be advertised on a public rendezvous point
type AccountContactRequestDisabled struct {
	// device_pk is the device sending the event, signs the message
	DevicePK             []byte   `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestDisabled) Reset()         { *m = AccountContactRequestDisabled{} }
func (m *AccountContactRequestDisabled) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestDisabled) ProtoMessage()    {}
func (*AccountContactRequestDisabled) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{22}
}

func (m *AccountContactRequestDisabled) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestDisabled) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestDisabled.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestDisabled) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestDisabled.Merge(m, src)
}

func (m *AccountContactRequestDisabled) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestDisabled) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestDisabled.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestDisabled proto.InternalMessageInfo

func (m *AccountContactRequestDisabled) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

// AccountContactRequestDisabled indicates that the account should be advertised on a public rendezvous point
type AccountContactRequestEnabled struct {
	// device_pk is the device sending the event, signs the message
	DevicePK             []byte   `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestEnabled) Reset()         { *m = AccountContactRequestEnabled{} }
func (m *AccountContactRequestEnabled) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestEnabled) ProtoMessage()    {}
func (*AccountContactRequestEnabled) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{23}
}

func (m *AccountContactRequestEnabled) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestEnabled) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestEnabled.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestEnabled) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestEnabled.Merge(m, src)
}

func (m *AccountContactRequestEnabled) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestEnabled) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestEnabled.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestEnabled proto.InternalMessageInfo

func (m *AccountContactRequestEnabled) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

// AccountContactRequestDisabled indicates that the account should be advertised on different public rendezvous points
type AccountContactRequestReferenceReset struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// public_rendezvous_seed is the new rendezvous point seed
	PublicRendezvousSeed []byte   `protobuf:"bytes,2,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestReferenceReset) Reset()         { *m = AccountContactRequestReferenceReset{} }
func (m *AccountContactRequestReferenceReset) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestReferenceReset) ProtoMessage()    {}
func (*AccountContactRequestReferenceReset) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{24}
}

func (m *AccountContactRequestReferenceReset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestReferenceReset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestReferenceReset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestReferenceReset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestReferenceReset.Merge(m, src)
}

func (m *AccountContactRequestReferenceReset) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestReferenceReset) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestReferenceReset.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestReferenceReset proto.InternalMessageInfo

func (m *AccountContactRequestReferenceReset) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestReferenceReset) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

// This event should be followed by an AccountGroupJoined event
// This event should be followed by a GroupAddMemberDevice event within the AccountGroup
// This event should be followed by a GroupAddDeviceSecret event within the AccountGroup
// AccountContactRequestEnqueued indicates that the account will attempt to send a contact request when a matching peer is discovered
type AccountContactRequestEnqueued struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// group_pk is the 1to1 group with the requested user
	GroupPK []byte `protobuf:"bytes,2,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// contact is a message describing how to connect to the other account
	Contact *ShareableContact `protobuf:"bytes,3,opt,name=contact,proto3" json:"contact,omitempty"`
	// own_metadata is the identifying metadata that will be shared to the other account
	OwnMetadata          []byte   `protobuf:"bytes,4,opt,name=own_metadata,json=ownMetadata,proto3" json:"own_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestEnqueued) Reset()         { *m = AccountContactRequestEnqueued{} }
func (m *AccountContactRequestEnqueued) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestEnqueued) ProtoMessage()    {}
func (*AccountContactRequestEnqueued) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{25}
}

func (m *AccountContactRequestEnqueued) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestEnqueued) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestEnqueued.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestEnqueued) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestEnqueued.Merge(m, src)
}

func (m *AccountContactRequestEnqueued) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestEnqueued) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestEnqueued.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestEnqueued proto.InternalMessageInfo

func (m *AccountContactRequestEnqueued) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestEnqueued) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *AccountContactRequestEnqueued) GetContact() *ShareableContact {
	if m != nil {
		return m.Contact
	}
	return nil
}

func (m *AccountContactRequestEnqueued) GetOwnMetadata() []byte {
	if m != nil {
		return m.OwnMetadata
	}
	return nil
}

// AccountContactRequestSent indicates that the account has sent a contact request
type AccountContactRequestSent struct {
	// device_pk is the device sending the account event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the contacted account
	ContactPK            []byte   `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestSent) Reset()         { *m = AccountContactRequestSent{} }
func (m *AccountContactRequestSent) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestSent) ProtoMessage()    {}
func (*AccountContactRequestSent) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{26}
}

func (m *AccountContactRequestSent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestSent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestSent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestSent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestSent.Merge(m, src)
}

func (m *AccountContactRequestSent) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestSent) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestSent.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestSent proto.InternalMessageInfo

func (m *AccountContactRequestSent) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestSent) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

// AccountContactRequestReceived indicates that the account has received a new contact request
type AccountContactRequestReceived struct {
	// device_pk is the device sending the account event (which received the contact request), signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the account sending the request
	ContactPK []byte `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	// TODO: is this necessary?
	// contact_rendezvous_seed is the rendezvous seed of the contact sending the request
	ContactRendezvousSeed []byte `protobuf:"bytes,3,opt,name=contact_rendezvous_seed,json=contactRendezvousSeed,proto3" json:"contact_rendezvous_seed,omitempty"`
	// TODO: is this necessary?
	// contact_metadata is the metadata specific to the app to identify the contact for the request
	ContactMetadata      []byte   `protobuf:"bytes,4,opt,name=contact_metadata,json=contactMetadata,proto3" json:"contact_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestReceived) Reset()         { *m = AccountContactRequestReceived{} }
func (m *AccountContactRequestReceived) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestReceived) ProtoMessage()    {}
func (*AccountContactRequestReceived) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{27}
}

func (m *AccountContactRequestReceived) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestReceived) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestReceived.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestReceived) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestReceived.Merge(m, src)
}

func (m *AccountContactRequestReceived) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestReceived) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestReceived.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestReceived proto.InternalMessageInfo

func (m *AccountContactRequestReceived) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestReceived) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

func (m *AccountContactRequestReceived) GetContactRendezvousSeed() []byte {
	if m != nil {
		return m.ContactRendezvousSeed
	}
	return nil
}

func (m *AccountContactRequestReceived) GetContactMetadata() []byte {
	if m != nil {
		return m.ContactMetadata
	}
	return nil
}

// AccountContactRequestDiscarded indicates that a contact request has been refused
type AccountContactRequestDiscarded struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the contact whom request is refused
	ContactPK            []byte   `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestDiscarded) Reset()         { *m = AccountContactRequestDiscarded{} }
func (m *AccountContactRequestDiscarded) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestDiscarded) ProtoMessage()    {}
func (*AccountContactRequestDiscarded) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{28}
}

func (m *AccountContactRequestDiscarded) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestDiscarded) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestDiscarded.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestDiscarded) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestDiscarded.Merge(m, src)
}

func (m *AccountContactRequestDiscarded) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestDiscarded) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestDiscarded.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestDiscarded proto.InternalMessageInfo

func (m *AccountContactRequestDiscarded) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestDiscarded) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

// This event should be followed by an AccountGroupJoined event
// This event should be followed by GroupAddMemberDevice and GroupAddDeviceSecret events within the AccountGroup
// AccountContactRequestAccepted indicates that a contact request has been accepted
type AccountContactRequestAccepted struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the contact whom request is accepted
	ContactPK []byte `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	// group_pk is the 1to1 group with the requester user
	GroupPK              []byte   `protobuf:"bytes,3,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactRequestAccepted) Reset()         { *m = AccountContactRequestAccepted{} }
func (m *AccountContactRequestAccepted) String() string { return proto.CompactTextString(m) }
func (*AccountContactRequestAccepted) ProtoMessage()    {}
func (*AccountContactRequestAccepted) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{29}
}

func (m *AccountContactRequestAccepted) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactRequestAccepted) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactRequestAccepted.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactRequestAccepted) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactRequestAccepted.Merge(m, src)
}

func (m *AccountContactRequestAccepted) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactRequestAccepted) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactRequestAccepted.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactRequestAccepted proto.InternalMessageInfo

func (m *AccountContactRequestAccepted) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactRequestAccepted) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

func (m *AccountContactRequestAccepted) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

// AccountContactBlocked indicates that a contact is blocked
type AccountContactBlocked struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the contact blocked
	ContactPK            []byte   `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactBlocked) Reset()         { *m = AccountContactBlocked{} }
func (m *AccountContactBlocked) String() string { return proto.CompactTextString(m) }
func (*AccountContactBlocked) ProtoMessage()    {}
func (*AccountContactBlocked) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{30}
}

func (m *AccountContactBlocked) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactBlocked) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactBlocked.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactBlocked) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactBlocked.Merge(m, src)
}

func (m *AccountContactBlocked) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactBlocked) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactBlocked.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactBlocked proto.InternalMessageInfo

func (m *AccountContactBlocked) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactBlocked) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

// AccountContactUnblocked indicates that a contact is unblocked
type AccountContactUnblocked struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// contact_pk is the contact unblocked
	ContactPK            []byte   `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountContactUnblocked) Reset()         { *m = AccountContactUnblocked{} }
func (m *AccountContactUnblocked) String() string { return proto.CompactTextString(m) }
func (*AccountContactUnblocked) ProtoMessage()    {}
func (*AccountContactUnblocked) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{31}
}

func (m *AccountContactUnblocked) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountContactUnblocked) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountContactUnblocked.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountContactUnblocked) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountContactUnblocked.Merge(m, src)
}

func (m *AccountContactUnblocked) XXX_Size() int {
	return m.Size()
}

func (m *AccountContactUnblocked) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountContactUnblocked.DiscardUnknown(m)
}

var xxx_messageInfo_AccountContactUnblocked proto.InternalMessageInfo

func (m *AccountContactUnblocked) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountContactUnblocked) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

// AccountServiceTokenAdded indicates a token has been added to the account
type AccountServiceTokenAdded struct {
	// device_pk is the device sending the event, signs the message
	DevicePK             []byte        `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	ServiceToken         *ServiceToken `protobuf:"bytes,2,opt,name=service_token,json=serviceToken,proto3" json:"service_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AccountServiceTokenAdded) Reset()         { *m = AccountServiceTokenAdded{} }
func (m *AccountServiceTokenAdded) String() string { return proto.CompactTextString(m) }
func (*AccountServiceTokenAdded) ProtoMessage()    {}
func (*AccountServiceTokenAdded) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{32}
}

func (m *AccountServiceTokenAdded) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountServiceTokenAdded) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountServiceTokenAdded.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountServiceTokenAdded) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountServiceTokenAdded.Merge(m, src)
}

func (m *AccountServiceTokenAdded) XXX_Size() int {
	return m.Size()
}

func (m *AccountServiceTokenAdded) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountServiceTokenAdded.DiscardUnknown(m)
}

var xxx_messageInfo_AccountServiceTokenAdded proto.InternalMessageInfo

func (m *AccountServiceTokenAdded) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountServiceTokenAdded) GetServiceToken() *ServiceToken {
	if m != nil {
		return m.ServiceToken
	}
	return nil
}

// AccountServiceTokenRemoved indicates a token has removed
type AccountServiceTokenRemoved struct {
	// device_pk is the device sending the event, signs the message
	DevicePK             []byte   `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	TokenID              string   `protobuf:"bytes,2,opt,name=token_id,json=tokenId,proto3" json:"token_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountServiceTokenRemoved) Reset()         { *m = AccountServiceTokenRemoved{} }
func (m *AccountServiceTokenRemoved) String() string { return proto.CompactTextString(m) }
func (*AccountServiceTokenRemoved) ProtoMessage()    {}
func (*AccountServiceTokenRemoved) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{33}
}

func (m *AccountServiceTokenRemoved) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AccountServiceTokenRemoved) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccountServiceTokenRemoved.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AccountServiceTokenRemoved) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountServiceTokenRemoved.Merge(m, src)
}

func (m *AccountServiceTokenRemoved) XXX_Size() int {
	return m.Size()
}

func (m *AccountServiceTokenRemoved) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountServiceTokenRemoved.DiscardUnknown(m)
}

var xxx_messageInfo_AccountServiceTokenRemoved proto.InternalMessageInfo

func (m *AccountServiceTokenRemoved) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *AccountServiceTokenRemoved) GetTokenID() string {
	if m != nil {
		return m.TokenID
	}
	return ""
}

type GroupReplicating struct {
	// device_pk is the device sending the event, signs the message
	DevicePK []byte `protobuf:"bytes,1,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// authentication_url indicates which server has been used for authentication
	AuthenticationURL string `protobuf:"bytes,2,opt,name=authentication_url,json=authenticationUrl,proto3" json:"authentication_url,omitempty"`
	// replication_server indicates which server will be used for replication
	ReplicationServer    string   `protobuf:"bytes,3,opt,name=replication_server,json=replicationServer,proto3" json:"replication_server,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupReplicating) Reset()         { *m = GroupReplicating{} }
func (m *GroupReplicating) String() string { return proto.CompactTextString(m) }
func (*GroupReplicating) ProtoMessage()    {}
func (*GroupReplicating) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{34}
}

func (m *GroupReplicating) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupReplicating) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupReplicating.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupReplicating) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupReplicating.Merge(m, src)
}

func (m *GroupReplicating) XXX_Size() int {
	return m.Size()
}

func (m *GroupReplicating) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupReplicating.DiscardUnknown(m)
}

var xxx_messageInfo_GroupReplicating proto.InternalMessageInfo

func (m *GroupReplicating) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *GroupReplicating) GetAuthenticationURL() string {
	if m != nil {
		return m.AuthenticationURL
	}
	return ""
}

func (m *GroupReplicating) GetReplicationServer() string {
	if m != nil {
		return m.ReplicationServer
	}
	return ""
}

type InstanceExportData struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceExportData) Reset()         { *m = InstanceExportData{} }
func (m *InstanceExportData) String() string { return proto.CompactTextString(m) }
func (*InstanceExportData) ProtoMessage()    {}
func (*InstanceExportData) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{35}
}

func (m *InstanceExportData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceExportData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceExportData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceExportData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceExportData.Merge(m, src)
}

func (m *InstanceExportData) XXX_Size() int {
	return m.Size()
}

func (m *InstanceExportData) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceExportData.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceExportData proto.InternalMessageInfo

type InstanceExportData_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceExportData_Request) Reset()         { *m = InstanceExportData_Request{} }
func (m *InstanceExportData_Request) String() string { return proto.CompactTextString(m) }
func (*InstanceExportData_Request) ProtoMessage()    {}
func (*InstanceExportData_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{35, 0}
}

func (m *InstanceExportData_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceExportData_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceExportData_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceExportData_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceExportData_Request.Merge(m, src)
}

func (m *InstanceExportData_Request) XXX_Size() int {
	return m.Size()
}

func (m *InstanceExportData_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceExportData_Request.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceExportData_Request proto.InternalMessageInfo

type InstanceExportData_Reply struct {
	ExportedData         []byte   `protobuf:"bytes,1,opt,name=exported_data,json=exportedData,proto3" json:"exported_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceExportData_Reply) Reset()         { *m = InstanceExportData_Reply{} }
func (m *InstanceExportData_Reply) String() string { return proto.CompactTextString(m) }
func (*InstanceExportData_Reply) ProtoMessage()    {}
func (*InstanceExportData_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{35, 1}
}

func (m *InstanceExportData_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceExportData_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceExportData_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceExportData_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceExportData_Reply.Merge(m, src)
}

func (m *InstanceExportData_Reply) XXX_Size() int {
	return m.Size()
}

func (m *InstanceExportData_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceExportData_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceExportData_Reply proto.InternalMessageInfo

func (m *InstanceExportData_Reply) GetExportedData() []byte {
	if m != nil {
		return m.ExportedData
	}
	return nil
}

type InstanceGetConfiguration struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGetConfiguration) Reset()         { *m = InstanceGetConfiguration{} }
func (m *InstanceGetConfiguration) String() string { return proto.CompactTextString(m) }
func (*InstanceGetConfiguration) ProtoMessage()    {}
func (*InstanceGetConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{36}
}

func (m *InstanceGetConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceGetConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceGetConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceGetConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGetConfiguration.Merge(m, src)
}

func (m *InstanceGetConfiguration) XXX_Size() int {
	return m.Size()
}

func (m *InstanceGetConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGetConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGetConfiguration proto.InternalMessageInfo

type InstanceGetConfiguration_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGetConfiguration_Request) Reset()         { *m = InstanceGetConfiguration_Request{} }
func (m *InstanceGetConfiguration_Request) String() string { return proto.CompactTextString(m) }
func (*InstanceGetConfiguration_Request) ProtoMessage()    {}
func (*InstanceGetConfiguration_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{36, 0}
}

func (m *InstanceGetConfiguration_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceGetConfiguration_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceGetConfiguration_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceGetConfiguration_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGetConfiguration_Request.Merge(m, src)
}

func (m *InstanceGetConfiguration_Request) XXX_Size() int {
	return m.Size()
}

func (m *InstanceGetConfiguration_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGetConfiguration_Request.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGetConfiguration_Request proto.InternalMessageInfo

type InstanceGetConfiguration_Reply struct {
	// account_pk is the public key of the current account
	AccountPK []byte `protobuf:"bytes,1,opt,name=account_pk,json=accountPk,proto3" json:"account_pk,omitempty"`
	// device_pk is the public key of the current device
	DevicePK []byte `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// account_group_pk is the public key of the account group
	AccountGroupPK       []byte                                `protobuf:"bytes,3,opt,name=account_group_pk,json=accountGroupPk,proto3" json:"account_group_pk,omitempty"`
	PeerID               string                                `protobuf:"bytes,4,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	Listeners            []string                              `protobuf:"bytes,5,rep,name=listeners,proto3" json:"listeners,omitempty"`
	BleEnabled           InstanceGetConfiguration_SettingState `protobuf:"varint,6,opt,name=ble_enabled,json=bleEnabled,proto3,enum=berty.protocol.v1.InstanceGetConfiguration_SettingState" json:"ble_enabled,omitempty"`
	WifiP2PEnabled       InstanceGetConfiguration_SettingState `protobuf:"varint,7,opt,name=wifi_p2p_enabled,json=wifiP2pEnabled,proto3,enum=berty.protocol.v1.InstanceGetConfiguration_SettingState" json:"wifi_p2p_enabled,omitempty"`
	MdnsEnabled          InstanceGetConfiguration_SettingState `protobuf:"varint,8,opt,name=mdns_enabled,json=mdnsEnabled,proto3,enum=berty.protocol.v1.InstanceGetConfiguration_SettingState" json:"mdns_enabled,omitempty"`
	RelayEnabled         InstanceGetConfiguration_SettingState `protobuf:"varint,9,opt,name=relay_enabled,json=relayEnabled,proto3,enum=berty.protocol.v1.InstanceGetConfiguration_SettingState" json:"relay_enabled,omitempty"`
	DevicePushToken      *PushServiceReceiver                  `protobuf:"bytes,10,opt,name=device_push_token,json=devicePushToken,proto3" json:"device_push_token,omitempty"`
	DevicePushServer     *PushServer                           `protobuf:"bytes,11,opt,name=device_push_server,json=devicePushServer,proto3" json:"device_push_server,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *InstanceGetConfiguration_Reply) Reset()         { *m = InstanceGetConfiguration_Reply{} }
func (m *InstanceGetConfiguration_Reply) String() string { return proto.CompactTextString(m) }
func (*InstanceGetConfiguration_Reply) ProtoMessage()    {}
func (*InstanceGetConfiguration_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{36, 1}
}

func (m *InstanceGetConfiguration_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *InstanceGetConfiguration_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceGetConfiguration_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *InstanceGetConfiguration_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGetConfiguration_Reply.Merge(m, src)
}

func (m *InstanceGetConfiguration_Reply) XXX_Size() int {
	return m.Size()
}

func (m *InstanceGetConfiguration_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGetConfiguration_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGetConfiguration_Reply proto.InternalMessageInfo

func (m *InstanceGetConfiguration_Reply) GetAccountPK() []byte {
	if m != nil {
		return m.AccountPK
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) GetAccountGroupPK() []byte {
	if m != nil {
		return m.AccountGroupPK
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) GetPeerID() string {
	if m != nil {
		return m.PeerID
	}
	return ""
}

func (m *InstanceGetConfiguration_Reply) GetListeners() []string {
	if m != nil {
		return m.Listeners
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) GetBleEnabled() InstanceGetConfiguration_SettingState {
	if m != nil {
		return m.BleEnabled
	}
	return Unknown
}

func (m *InstanceGetConfiguration_Reply) GetWifiP2PEnabled() InstanceGetConfiguration_SettingState {
	if m != nil {
		return m.WifiP2PEnabled
	}
	return Unknown
}

func (m *InstanceGetConfiguration_Reply) GetMdnsEnabled() InstanceGetConfiguration_SettingState {
	if m != nil {
		return m.MdnsEnabled
	}
	return Unknown
}

func (m *InstanceGetConfiguration_Reply) GetRelayEnabled() InstanceGetConfiguration_SettingState {
	if m != nil {
		return m.RelayEnabled
	}
	return Unknown
}

func (m *InstanceGetConfiguration_Reply) GetDevicePushToken() *PushServiceReceiver {
	if m != nil {
		return m.DevicePushToken
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) GetDevicePushServer() *PushServer {
	if m != nil {
		return m.DevicePushServer
	}
	return nil
}

type ContactRequestReference struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestReference) Reset()         { *m = ContactRequestReference{} }
func (m *ContactRequestReference) String() string { return proto.CompactTextString(m) }
func (*ContactRequestReference) ProtoMessage()    {}
func (*ContactRequestReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{37}
}

func (m *ContactRequestReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestReference.Merge(m, src)
}

func (m *ContactRequestReference) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestReference.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestReference proto.InternalMessageInfo

type ContactRequestReference_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestReference_Request) Reset()         { *m = ContactRequestReference_Request{} }
func (m *ContactRequestReference_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestReference_Request) ProtoMessage()    {}
func (*ContactRequestReference_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{37, 0}
}

func (m *ContactRequestReference_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestReference_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestReference_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestReference_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestReference_Request.Merge(m, src)
}

func (m *ContactRequestReference_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestReference_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestReference_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestReference_Request proto.InternalMessageInfo

type ContactRequestReference_Reply struct {
	// public_rendezvous_seed is the rendezvous seed used by the current account
	PublicRendezvousSeed []byte `protobuf:"bytes,1,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	// enabled indicates if incoming contact requests are enabled
	Enabled              bool     `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestReference_Reply) Reset()         { *m = ContactRequestReference_Reply{} }
func (m *ContactRequestReference_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestReference_Reply) ProtoMessage()    {}
func (*ContactRequestReference_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{37, 1}
}

func (m *ContactRequestReference_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestReference_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestReference_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestReference_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestReference_Reply.Merge(m, src)
}

func (m *ContactRequestReference_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestReference_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestReference_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestReference_Reply proto.InternalMessageInfo

func (m *ContactRequestReference_Reply) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

func (m *ContactRequestReference_Reply) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

type ContactRequestDisable struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDisable) Reset()         { *m = ContactRequestDisable{} }
func (m *ContactRequestDisable) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDisable) ProtoMessage()    {}
func (*ContactRequestDisable) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{38}
}

func (m *ContactRequestDisable) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDisable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDisable.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDisable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDisable.Merge(m, src)
}

func (m *ContactRequestDisable) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDisable) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDisable.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDisable proto.InternalMessageInfo

type ContactRequestDisable_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDisable_Request) Reset()         { *m = ContactRequestDisable_Request{} }
func (m *ContactRequestDisable_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDisable_Request) ProtoMessage()    {}
func (*ContactRequestDisable_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{38, 0}
}

func (m *ContactRequestDisable_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDisable_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDisable_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDisable_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDisable_Request.Merge(m, src)
}

func (m *ContactRequestDisable_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDisable_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDisable_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDisable_Request proto.InternalMessageInfo

type ContactRequestDisable_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDisable_Reply) Reset()         { *m = ContactRequestDisable_Reply{} }
func (m *ContactRequestDisable_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDisable_Reply) ProtoMessage()    {}
func (*ContactRequestDisable_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{38, 1}
}

func (m *ContactRequestDisable_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDisable_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDisable_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDisable_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDisable_Reply.Merge(m, src)
}

func (m *ContactRequestDisable_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDisable_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDisable_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDisable_Reply proto.InternalMessageInfo

type ContactRequestEnable struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestEnable) Reset()         { *m = ContactRequestEnable{} }
func (m *ContactRequestEnable) String() string { return proto.CompactTextString(m) }
func (*ContactRequestEnable) ProtoMessage()    {}
func (*ContactRequestEnable) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{39}
}

func (m *ContactRequestEnable) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestEnable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestEnable.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestEnable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestEnable.Merge(m, src)
}

func (m *ContactRequestEnable) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestEnable) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestEnable.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestEnable proto.InternalMessageInfo

type ContactRequestEnable_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestEnable_Request) Reset()         { *m = ContactRequestEnable_Request{} }
func (m *ContactRequestEnable_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestEnable_Request) ProtoMessage()    {}
func (*ContactRequestEnable_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{39, 0}
}

func (m *ContactRequestEnable_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestEnable_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestEnable_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestEnable_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestEnable_Request.Merge(m, src)
}

func (m *ContactRequestEnable_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestEnable_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestEnable_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestEnable_Request proto.InternalMessageInfo

type ContactRequestEnable_Reply struct {
	// public_rendezvous_seed is the rendezvous seed used by the current account
	PublicRendezvousSeed []byte   `protobuf:"bytes,1,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestEnable_Reply) Reset()         { *m = ContactRequestEnable_Reply{} }
func (m *ContactRequestEnable_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestEnable_Reply) ProtoMessage()    {}
func (*ContactRequestEnable_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{39, 1}
}

func (m *ContactRequestEnable_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestEnable_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestEnable_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestEnable_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestEnable_Reply.Merge(m, src)
}

func (m *ContactRequestEnable_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestEnable_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestEnable_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestEnable_Reply proto.InternalMessageInfo

func (m *ContactRequestEnable_Reply) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

type ContactRequestResetReference struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestResetReference) Reset()         { *m = ContactRequestResetReference{} }
func (m *ContactRequestResetReference) String() string { return proto.CompactTextString(m) }
func (*ContactRequestResetReference) ProtoMessage()    {}
func (*ContactRequestResetReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{40}
}

func (m *ContactRequestResetReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestResetReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestResetReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestResetReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestResetReference.Merge(m, src)
}

func (m *ContactRequestResetReference) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestResetReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestResetReference.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestResetReference proto.InternalMessageInfo

type ContactRequestResetReference_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestResetReference_Request) Reset()         { *m = ContactRequestResetReference_Request{} }
func (m *ContactRequestResetReference_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestResetReference_Request) ProtoMessage()    {}
func (*ContactRequestResetReference_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{40, 0}
}

func (m *ContactRequestResetReference_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestResetReference_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestResetReference_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestResetReference_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestResetReference_Request.Merge(m, src)
}

func (m *ContactRequestResetReference_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestResetReference_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestResetReference_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestResetReference_Request proto.InternalMessageInfo

type ContactRequestResetReference_Reply struct {
	// public_rendezvous_seed is the rendezvous seed used by the current account
	PublicRendezvousSeed []byte   `protobuf:"bytes,1,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestResetReference_Reply) Reset()         { *m = ContactRequestResetReference_Reply{} }
func (m *ContactRequestResetReference_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestResetReference_Reply) ProtoMessage()    {}
func (*ContactRequestResetReference_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{40, 1}
}

func (m *ContactRequestResetReference_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestResetReference_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestResetReference_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestResetReference_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestResetReference_Reply.Merge(m, src)
}

func (m *ContactRequestResetReference_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestResetReference_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestResetReference_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestResetReference_Reply proto.InternalMessageInfo

func (m *ContactRequestResetReference_Reply) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

type ContactRequestSend struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestSend) Reset()         { *m = ContactRequestSend{} }
func (m *ContactRequestSend) String() string { return proto.CompactTextString(m) }
func (*ContactRequestSend) ProtoMessage()    {}
func (*ContactRequestSend) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{41}
}

func (m *ContactRequestSend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestSend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestSend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestSend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestSend.Merge(m, src)
}

func (m *ContactRequestSend) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestSend) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestSend.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestSend proto.InternalMessageInfo

type ContactRequestSend_Request struct {
	// contact is a message describing how to connect to the other account
	Contact *ShareableContact `protobuf:"bytes,1,opt,name=contact,proto3" json:"contact,omitempty"`
	// own_metadata is the identifying metadata that will be shared to the other account
	OwnMetadata          []byte   `protobuf:"bytes,2,opt,name=own_metadata,json=ownMetadata,proto3" json:"own_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestSend_Request) Reset()         { *m = ContactRequestSend_Request{} }
func (m *ContactRequestSend_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestSend_Request) ProtoMessage()    {}
func (*ContactRequestSend_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{41, 0}
}

func (m *ContactRequestSend_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestSend_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestSend_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestSend_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestSend_Request.Merge(m, src)
}

func (m *ContactRequestSend_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestSend_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestSend_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestSend_Request proto.InternalMessageInfo

func (m *ContactRequestSend_Request) GetContact() *ShareableContact {
	if m != nil {
		return m.Contact
	}
	return nil
}

func (m *ContactRequestSend_Request) GetOwnMetadata() []byte {
	if m != nil {
		return m.OwnMetadata
	}
	return nil
}

type ContactRequestSend_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestSend_Reply) Reset()         { *m = ContactRequestSend_Reply{} }
func (m *ContactRequestSend_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestSend_Reply) ProtoMessage()    {}
func (*ContactRequestSend_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{41, 1}
}

func (m *ContactRequestSend_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestSend_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestSend_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestSend_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestSend_Reply.Merge(m, src)
}

func (m *ContactRequestSend_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestSend_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestSend_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestSend_Reply proto.InternalMessageInfo

type ContactRequestAccept struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestAccept) Reset()         { *m = ContactRequestAccept{} }
func (m *ContactRequestAccept) String() string { return proto.CompactTextString(m) }
func (*ContactRequestAccept) ProtoMessage()    {}
func (*ContactRequestAccept) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{42}
}

func (m *ContactRequestAccept) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestAccept) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestAccept.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestAccept) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestAccept.Merge(m, src)
}

func (m *ContactRequestAccept) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestAccept) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestAccept.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestAccept proto.InternalMessageInfo

type ContactRequestAccept_Request struct {
	// contact_pk is the identifier of the contact to accept the request from
	ContactPK            []byte   `protobuf:"bytes,1,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestAccept_Request) Reset()         { *m = ContactRequestAccept_Request{} }
func (m *ContactRequestAccept_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestAccept_Request) ProtoMessage()    {}
func (*ContactRequestAccept_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{42, 0}
}

func (m *ContactRequestAccept_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestAccept_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestAccept_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestAccept_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestAccept_Request.Merge(m, src)
}

func (m *ContactRequestAccept_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestAccept_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestAccept_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestAccept_Request proto.InternalMessageInfo

func (m *ContactRequestAccept_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type ContactRequestAccept_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestAccept_Reply) Reset()         { *m = ContactRequestAccept_Reply{} }
func (m *ContactRequestAccept_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestAccept_Reply) ProtoMessage()    {}
func (*ContactRequestAccept_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{42, 1}
}

func (m *ContactRequestAccept_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestAccept_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestAccept_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestAccept_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestAccept_Reply.Merge(m, src)
}

func (m *ContactRequestAccept_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestAccept_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestAccept_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestAccept_Reply proto.InternalMessageInfo

type ContactRequestDiscard struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDiscard) Reset()         { *m = ContactRequestDiscard{} }
func (m *ContactRequestDiscard) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDiscard) ProtoMessage()    {}
func (*ContactRequestDiscard) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{43}
}

func (m *ContactRequestDiscard) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDiscard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDiscard.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDiscard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDiscard.Merge(m, src)
}

func (m *ContactRequestDiscard) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDiscard) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDiscard.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDiscard proto.InternalMessageInfo

type ContactRequestDiscard_Request struct {
	// contact_pk is the identifier of the contact to ignore the request from
	ContactPK            []byte   `protobuf:"bytes,1,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDiscard_Request) Reset()         { *m = ContactRequestDiscard_Request{} }
func (m *ContactRequestDiscard_Request) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDiscard_Request) ProtoMessage()    {}
func (*ContactRequestDiscard_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{43, 0}
}

func (m *ContactRequestDiscard_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDiscard_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDiscard_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDiscard_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDiscard_Request.Merge(m, src)
}

func (m *ContactRequestDiscard_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDiscard_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDiscard_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDiscard_Request proto.InternalMessageInfo

func (m *ContactRequestDiscard_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type ContactRequestDiscard_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactRequestDiscard_Reply) Reset()         { *m = ContactRequestDiscard_Reply{} }
func (m *ContactRequestDiscard_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactRequestDiscard_Reply) ProtoMessage()    {}
func (*ContactRequestDiscard_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{43, 1}
}

func (m *ContactRequestDiscard_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactRequestDiscard_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactRequestDiscard_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactRequestDiscard_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactRequestDiscard_Reply.Merge(m, src)
}

func (m *ContactRequestDiscard_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactRequestDiscard_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactRequestDiscard_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactRequestDiscard_Reply proto.InternalMessageInfo

type ContactBlock struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactBlock) Reset()         { *m = ContactBlock{} }
func (m *ContactBlock) String() string { return proto.CompactTextString(m) }
func (*ContactBlock) ProtoMessage()    {}
func (*ContactBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{44}
}

func (m *ContactBlock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactBlock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactBlock.Merge(m, src)
}

func (m *ContactBlock) XXX_Size() int {
	return m.Size()
}

func (m *ContactBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactBlock.DiscardUnknown(m)
}

var xxx_messageInfo_ContactBlock proto.InternalMessageInfo

type ContactBlock_Request struct {
	// contact_pk is the identifier of the contact to block
	ContactPK            []byte   `protobuf:"bytes,1,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactBlock_Request) Reset()         { *m = ContactBlock_Request{} }
func (m *ContactBlock_Request) String() string { return proto.CompactTextString(m) }
func (*ContactBlock_Request) ProtoMessage()    {}
func (*ContactBlock_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{44, 0}
}

func (m *ContactBlock_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactBlock_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactBlock_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactBlock_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactBlock_Request.Merge(m, src)
}

func (m *ContactBlock_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactBlock_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactBlock_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactBlock_Request proto.InternalMessageInfo

func (m *ContactBlock_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type ContactBlock_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactBlock_Reply) Reset()         { *m = ContactBlock_Reply{} }
func (m *ContactBlock_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactBlock_Reply) ProtoMessage()    {}
func (*ContactBlock_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{44, 1}
}

func (m *ContactBlock_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactBlock_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactBlock_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactBlock_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactBlock_Reply.Merge(m, src)
}

func (m *ContactBlock_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactBlock_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactBlock_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactBlock_Reply proto.InternalMessageInfo

type ContactUnblock struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactUnblock) Reset()         { *m = ContactUnblock{} }
func (m *ContactUnblock) String() string { return proto.CompactTextString(m) }
func (*ContactUnblock) ProtoMessage()    {}
func (*ContactUnblock) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{45}
}

func (m *ContactUnblock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactUnblock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactUnblock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactUnblock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactUnblock.Merge(m, src)
}

func (m *ContactUnblock) XXX_Size() int {
	return m.Size()
}

func (m *ContactUnblock) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactUnblock.DiscardUnknown(m)
}

var xxx_messageInfo_ContactUnblock proto.InternalMessageInfo

type ContactUnblock_Request struct {
	// contact_pk is the identifier of the contact to unblock
	ContactPK            []byte   `protobuf:"bytes,1,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactUnblock_Request) Reset()         { *m = ContactUnblock_Request{} }
func (m *ContactUnblock_Request) String() string { return proto.CompactTextString(m) }
func (*ContactUnblock_Request) ProtoMessage()    {}
func (*ContactUnblock_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{45, 0}
}

func (m *ContactUnblock_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactUnblock_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactUnblock_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactUnblock_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactUnblock_Request.Merge(m, src)
}

func (m *ContactUnblock_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactUnblock_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactUnblock_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactUnblock_Request proto.InternalMessageInfo

func (m *ContactUnblock_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type ContactUnblock_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactUnblock_Reply) Reset()         { *m = ContactUnblock_Reply{} }
func (m *ContactUnblock_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactUnblock_Reply) ProtoMessage()    {}
func (*ContactUnblock_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{45, 1}
}

func (m *ContactUnblock_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactUnblock_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactUnblock_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactUnblock_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactUnblock_Reply.Merge(m, src)
}

func (m *ContactUnblock_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactUnblock_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactUnblock_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactUnblock_Reply proto.InternalMessageInfo

type ContactAliasKeySend struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactAliasKeySend) Reset()         { *m = ContactAliasKeySend{} }
func (m *ContactAliasKeySend) String() string { return proto.CompactTextString(m) }
func (*ContactAliasKeySend) ProtoMessage()    {}
func (*ContactAliasKeySend) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{46}
}

func (m *ContactAliasKeySend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactAliasKeySend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactAliasKeySend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactAliasKeySend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactAliasKeySend.Merge(m, src)
}

func (m *ContactAliasKeySend) XXX_Size() int {
	return m.Size()
}

func (m *ContactAliasKeySend) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactAliasKeySend.DiscardUnknown(m)
}

var xxx_messageInfo_ContactAliasKeySend proto.InternalMessageInfo

type ContactAliasKeySend_Request struct {
	// contact_pk is the identifier of the contact to send the alias public key to
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactAliasKeySend_Request) Reset()         { *m = ContactAliasKeySend_Request{} }
func (m *ContactAliasKeySend_Request) String() string { return proto.CompactTextString(m) }
func (*ContactAliasKeySend_Request) ProtoMessage()    {}
func (*ContactAliasKeySend_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{46, 0}
}

func (m *ContactAliasKeySend_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactAliasKeySend_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactAliasKeySend_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactAliasKeySend_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactAliasKeySend_Request.Merge(m, src)
}

func (m *ContactAliasKeySend_Request) XXX_Size() int {
	return m.Size()
}

func (m *ContactAliasKeySend_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactAliasKeySend_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ContactAliasKeySend_Request proto.InternalMessageInfo

func (m *ContactAliasKeySend_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type ContactAliasKeySend_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContactAliasKeySend_Reply) Reset()         { *m = ContactAliasKeySend_Reply{} }
func (m *ContactAliasKeySend_Reply) String() string { return proto.CompactTextString(m) }
func (*ContactAliasKeySend_Reply) ProtoMessage()    {}
func (*ContactAliasKeySend_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{46, 1}
}

func (m *ContactAliasKeySend_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ContactAliasKeySend_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContactAliasKeySend_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ContactAliasKeySend_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContactAliasKeySend_Reply.Merge(m, src)
}

func (m *ContactAliasKeySend_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ContactAliasKeySend_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ContactAliasKeySend_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ContactAliasKeySend_Reply proto.InternalMessageInfo

type MultiMemberGroupCreate struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupCreate) Reset()         { *m = MultiMemberGroupCreate{} }
func (m *MultiMemberGroupCreate) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupCreate) ProtoMessage()    {}
func (*MultiMemberGroupCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{47}
}

func (m *MultiMemberGroupCreate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupCreate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupCreate.Merge(m, src)
}

func (m *MultiMemberGroupCreate) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupCreate.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupCreate proto.InternalMessageInfo

type MultiMemberGroupCreate_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupCreate_Request) Reset()         { *m = MultiMemberGroupCreate_Request{} }
func (m *MultiMemberGroupCreate_Request) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupCreate_Request) ProtoMessage()    {}
func (*MultiMemberGroupCreate_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{47, 0}
}

func (m *MultiMemberGroupCreate_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupCreate_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupCreate_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupCreate_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupCreate_Request.Merge(m, src)
}

func (m *MultiMemberGroupCreate_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupCreate_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupCreate_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupCreate_Request proto.InternalMessageInfo

type MultiMemberGroupCreate_Reply struct {
	// group_pk is the identifier of the newly created group
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupCreate_Reply) Reset()         { *m = MultiMemberGroupCreate_Reply{} }
func (m *MultiMemberGroupCreate_Reply) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupCreate_Reply) ProtoMessage()    {}
func (*MultiMemberGroupCreate_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{47, 1}
}

func (m *MultiMemberGroupCreate_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupCreate_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupCreate_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupCreate_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupCreate_Reply.Merge(m, src)
}

func (m *MultiMemberGroupCreate_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupCreate_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupCreate_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupCreate_Reply proto.InternalMessageInfo

func (m *MultiMemberGroupCreate_Reply) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type MultiMemberGroupJoin struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupJoin) Reset()         { *m = MultiMemberGroupJoin{} }
func (m *MultiMemberGroupJoin) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupJoin) ProtoMessage()    {}
func (*MultiMemberGroupJoin) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{48}
}

func (m *MultiMemberGroupJoin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupJoin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupJoin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupJoin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupJoin.Merge(m, src)
}

func (m *MultiMemberGroupJoin) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupJoin) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupJoin.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupJoin proto.InternalMessageInfo

type MultiMemberGroupJoin_Request struct {
	// group is the information of the group to join
	Group                *Group   `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupJoin_Request) Reset()         { *m = MultiMemberGroupJoin_Request{} }
func (m *MultiMemberGroupJoin_Request) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupJoin_Request) ProtoMessage()    {}
func (*MultiMemberGroupJoin_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{48, 0}
}

func (m *MultiMemberGroupJoin_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupJoin_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupJoin_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupJoin_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupJoin_Request.Merge(m, src)
}

func (m *MultiMemberGroupJoin_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupJoin_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupJoin_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupJoin_Request proto.InternalMessageInfo

func (m *MultiMemberGroupJoin_Request) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

type MultiMemberGroupJoin_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupJoin_Reply) Reset()         { *m = MultiMemberGroupJoin_Reply{} }
func (m *MultiMemberGroupJoin_Reply) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupJoin_Reply) ProtoMessage()    {}
func (*MultiMemberGroupJoin_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{48, 1}
}

func (m *MultiMemberGroupJoin_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupJoin_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupJoin_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupJoin_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupJoin_Reply.Merge(m, src)
}

func (m *MultiMemberGroupJoin_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupJoin_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupJoin_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupJoin_Reply proto.InternalMessageInfo

type MultiMemberGroupLeave struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupLeave) Reset()         { *m = MultiMemberGroupLeave{} }
func (m *MultiMemberGroupLeave) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupLeave) ProtoMessage()    {}
func (*MultiMemberGroupLeave) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{49}
}

func (m *MultiMemberGroupLeave) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupLeave) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupLeave.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupLeave) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupLeave.Merge(m, src)
}

func (m *MultiMemberGroupLeave) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupLeave) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupLeave.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupLeave proto.InternalMessageInfo

type MultiMemberGroupLeave_Request struct {
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupLeave_Request) Reset()         { *m = MultiMemberGroupLeave_Request{} }
func (m *MultiMemberGroupLeave_Request) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupLeave_Request) ProtoMessage()    {}
func (*MultiMemberGroupLeave_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{49, 0}
}

func (m *MultiMemberGroupLeave_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupLeave_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupLeave_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupLeave_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupLeave_Request.Merge(m, src)
}

func (m *MultiMemberGroupLeave_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupLeave_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupLeave_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupLeave_Request proto.InternalMessageInfo

func (m *MultiMemberGroupLeave_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type MultiMemberGroupLeave_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupLeave_Reply) Reset()         { *m = MultiMemberGroupLeave_Reply{} }
func (m *MultiMemberGroupLeave_Reply) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupLeave_Reply) ProtoMessage()    {}
func (*MultiMemberGroupLeave_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{49, 1}
}

func (m *MultiMemberGroupLeave_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupLeave_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupLeave_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupLeave_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupLeave_Reply.Merge(m, src)
}

func (m *MultiMemberGroupLeave_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupLeave_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupLeave_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupLeave_Reply proto.InternalMessageInfo

type MultiMemberGroupAliasResolverDisclose struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAliasResolverDisclose) Reset()         { *m = MultiMemberGroupAliasResolverDisclose{} }
func (m *MultiMemberGroupAliasResolverDisclose) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupAliasResolverDisclose) ProtoMessage()    {}
func (*MultiMemberGroupAliasResolverDisclose) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{50}
}

func (m *MultiMemberGroupAliasResolverDisclose) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAliasResolverDisclose) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAliasResolverDisclose.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAliasResolverDisclose) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose.Merge(m, src)
}

func (m *MultiMemberGroupAliasResolverDisclose) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAliasResolverDisclose) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAliasResolverDisclose proto.InternalMessageInfo

type MultiMemberGroupAliasResolverDisclose_Request struct {
	// group_pk is the identifier of the group
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) Reset() {
	*m = MultiMemberGroupAliasResolverDisclose_Request{}
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) String() string {
	return proto.CompactTextString(m)
}
func (*MultiMemberGroupAliasResolverDisclose_Request) ProtoMessage() {}
func (*MultiMemberGroupAliasResolverDisclose_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{50, 0}
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Request.Merge(m, src)
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Request proto.InternalMessageInfo

func (m *MultiMemberGroupAliasResolverDisclose_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type MultiMemberGroupAliasResolverDisclose_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) Reset() {
	*m = MultiMemberGroupAliasResolverDisclose_Reply{}
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) String() string {
	return proto.CompactTextString(m)
}
func (*MultiMemberGroupAliasResolverDisclose_Reply) ProtoMessage() {}
func (*MultiMemberGroupAliasResolverDisclose_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{50, 1}
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Reply.Merge(m, src)
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAliasResolverDisclose_Reply proto.InternalMessageInfo

type MultiMemberGroupAdminRoleGrant struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAdminRoleGrant) Reset()         { *m = MultiMemberGroupAdminRoleGrant{} }
func (m *MultiMemberGroupAdminRoleGrant) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupAdminRoleGrant) ProtoMessage()    {}
func (*MultiMemberGroupAdminRoleGrant) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{51}
}

func (m *MultiMemberGroupAdminRoleGrant) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAdminRoleGrant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAdminRoleGrant.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAdminRoleGrant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant.Merge(m, src)
}

func (m *MultiMemberGroupAdminRoleGrant) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAdminRoleGrant) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAdminRoleGrant proto.InternalMessageInfo

type MultiMemberGroupAdminRoleGrant_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// member_pk is the identifier of the member which will be granted the admin role
	MemberPK             []byte   `protobuf:"bytes,2,opt,name=member_pk,json=memberPk,proto3" json:"member_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAdminRoleGrant_Request) Reset() {
	*m = MultiMemberGroupAdminRoleGrant_Request{}
}
func (m *MultiMemberGroupAdminRoleGrant_Request) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupAdminRoleGrant_Request) ProtoMessage()    {}
func (*MultiMemberGroupAdminRoleGrant_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{51, 0}
}

func (m *MultiMemberGroupAdminRoleGrant_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAdminRoleGrant_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAdminRoleGrant_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Request.Merge(m, src)
}

func (m *MultiMemberGroupAdminRoleGrant_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAdminRoleGrant_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Request proto.InternalMessageInfo

func (m *MultiMemberGroupAdminRoleGrant_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *MultiMemberGroupAdminRoleGrant_Request) GetMemberPK() []byte {
	if m != nil {
		return m.MemberPK
	}
	return nil
}

type MultiMemberGroupAdminRoleGrant_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) Reset()         { *m = MultiMemberGroupAdminRoleGrant_Reply{} }
func (m *MultiMemberGroupAdminRoleGrant_Reply) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupAdminRoleGrant_Reply) ProtoMessage()    {}
func (*MultiMemberGroupAdminRoleGrant_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{51, 1}
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Reply.Merge(m, src)
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupAdminRoleGrant_Reply proto.InternalMessageInfo

type MultiMemberGroupInvitationCreate struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupInvitationCreate) Reset()         { *m = MultiMemberGroupInvitationCreate{} }
func (m *MultiMemberGroupInvitationCreate) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupInvitationCreate) ProtoMessage()    {}
func (*MultiMemberGroupInvitationCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{52}
}

func (m *MultiMemberGroupInvitationCreate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupInvitationCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupInvitationCreate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupInvitationCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupInvitationCreate.Merge(m, src)
}

func (m *MultiMemberGroupInvitationCreate) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupInvitationCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupInvitationCreate.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupInvitationCreate proto.InternalMessageInfo

type MultiMemberGroupInvitationCreate_Request struct {
	// group_pk is the identifier of the group
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupInvitationCreate_Request) Reset() {
	*m = MultiMemberGroupInvitationCreate_Request{}
}
func (m *MultiMemberGroupInvitationCreate_Request) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupInvitationCreate_Request) ProtoMessage()    {}
func (*MultiMemberGroupInvitationCreate_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{52, 0}
}

func (m *MultiMemberGroupInvitationCreate_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupInvitationCreate_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupInvitationCreate_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupInvitationCreate_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupInvitationCreate_Request.Merge(m, src)
}

func (m *MultiMemberGroupInvitationCreate_Request) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupInvitationCreate_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupInvitationCreate_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupInvitationCreate_Request proto.InternalMessageInfo

func (m *MultiMemberGroupInvitationCreate_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type MultiMemberGroupInvitationCreate_Reply struct {
	// group is the invitation to the group
	Group                *Group   `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiMemberGroupInvitationCreate_Reply) Reset() {
	*m = MultiMemberGroupInvitationCreate_Reply{}
}
func (m *MultiMemberGroupInvitationCreate_Reply) String() string { return proto.CompactTextString(m) }
func (*MultiMemberGroupInvitationCreate_Reply) ProtoMessage()    {}
func (*MultiMemberGroupInvitationCreate_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{52, 1}
}

func (m *MultiMemberGroupInvitationCreate_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MultiMemberGroupInvitationCreate_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiMemberGroupInvitationCreate_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MultiMemberGroupInvitationCreate_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiMemberGroupInvitationCreate_Reply.Merge(m, src)
}

func (m *MultiMemberGroupInvitationCreate_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MultiMemberGroupInvitationCreate_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiMemberGroupInvitationCreate_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MultiMemberGroupInvitationCreate_Reply proto.InternalMessageInfo

func (m *MultiMemberGroupInvitationCreate_Reply) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

type AppMetadataSend struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMetadataSend) Reset()         { *m = AppMetadataSend{} }
func (m *AppMetadataSend) String() string { return proto.CompactTextString(m) }
func (*AppMetadataSend) ProtoMessage()    {}
func (*AppMetadataSend) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{53}
}

func (m *AppMetadataSend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMetadataSend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMetadataSend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMetadataSend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMetadataSend.Merge(m, src)
}

func (m *AppMetadataSend) XXX_Size() int {
	return m.Size()
}

func (m *AppMetadataSend) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMetadataSend.DiscardUnknown(m)
}

var xxx_messageInfo_AppMetadataSend proto.InternalMessageInfo

type AppMetadataSend_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// payload is the payload to send
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// attachment_cids is a list of attachment cids
	AttachmentCIDs       [][]byte `protobuf:"bytes,3,rep,name=attachment_cids,json=attachmentCids,proto3" json:"attachment_cids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMetadataSend_Request) Reset()         { *m = AppMetadataSend_Request{} }
func (m *AppMetadataSend_Request) String() string { return proto.CompactTextString(m) }
func (*AppMetadataSend_Request) ProtoMessage()    {}
func (*AppMetadataSend_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{53, 0}
}

func (m *AppMetadataSend_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMetadataSend_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMetadataSend_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMetadataSend_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMetadataSend_Request.Merge(m, src)
}

func (m *AppMetadataSend_Request) XXX_Size() int {
	return m.Size()
}

func (m *AppMetadataSend_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMetadataSend_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AppMetadataSend_Request proto.InternalMessageInfo

func (m *AppMetadataSend_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *AppMetadataSend_Request) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *AppMetadataSend_Request) GetAttachmentCIDs() [][]byte {
	if m != nil {
		return m.AttachmentCIDs
	}
	return nil
}

type AppMetadataSend_Reply struct {
	CID                  []byte   `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMetadataSend_Reply) Reset()         { *m = AppMetadataSend_Reply{} }
func (m *AppMetadataSend_Reply) String() string { return proto.CompactTextString(m) }
func (*AppMetadataSend_Reply) ProtoMessage()    {}
func (*AppMetadataSend_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{53, 1}
}

func (m *AppMetadataSend_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMetadataSend_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMetadataSend_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMetadataSend_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMetadataSend_Reply.Merge(m, src)
}

func (m *AppMetadataSend_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AppMetadataSend_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMetadataSend_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AppMetadataSend_Reply proto.InternalMessageInfo

func (m *AppMetadataSend_Reply) GetCID() []byte {
	if m != nil {
		return m.CID
	}
	return nil
}

type AppMessageSend struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMessageSend) Reset()         { *m = AppMessageSend{} }
func (m *AppMessageSend) String() string { return proto.CompactTextString(m) }
func (*AppMessageSend) ProtoMessage()    {}
func (*AppMessageSend) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{54}
}

func (m *AppMessageSend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMessageSend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMessageSend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMessageSend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMessageSend.Merge(m, src)
}

func (m *AppMessageSend) XXX_Size() int {
	return m.Size()
}

func (m *AppMessageSend) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMessageSend.DiscardUnknown(m)
}

var xxx_messageInfo_AppMessageSend proto.InternalMessageInfo

type AppMessageSend_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// payload is the payload to send
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// attachment_cids is a list of attachment cids
	AttachmentCIDs       [][]byte `protobuf:"bytes,3,rep,name=attachment_cids,json=attachmentCids,proto3" json:"attachment_cids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMessageSend_Request) Reset()         { *m = AppMessageSend_Request{} }
func (m *AppMessageSend_Request) String() string { return proto.CompactTextString(m) }
func (*AppMessageSend_Request) ProtoMessage()    {}
func (*AppMessageSend_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{54, 0}
}

func (m *AppMessageSend_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMessageSend_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMessageSend_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMessageSend_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMessageSend_Request.Merge(m, src)
}

func (m *AppMessageSend_Request) XXX_Size() int {
	return m.Size()
}

func (m *AppMessageSend_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMessageSend_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AppMessageSend_Request proto.InternalMessageInfo

func (m *AppMessageSend_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *AppMessageSend_Request) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *AppMessageSend_Request) GetAttachmentCIDs() [][]byte {
	if m != nil {
		return m.AttachmentCIDs
	}
	return nil
}

type AppMessageSend_Reply struct {
	CID                  []byte   `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppMessageSend_Reply) Reset()         { *m = AppMessageSend_Reply{} }
func (m *AppMessageSend_Reply) String() string { return proto.CompactTextString(m) }
func (*AppMessageSend_Reply) ProtoMessage()    {}
func (*AppMessageSend_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{54, 1}
}

func (m *AppMessageSend_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AppMessageSend_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AppMessageSend_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AppMessageSend_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppMessageSend_Reply.Merge(m, src)
}

func (m *AppMessageSend_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AppMessageSend_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AppMessageSend_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AppMessageSend_Reply proto.InternalMessageInfo

func (m *AppMessageSend_Reply) GetCID() []byte {
	if m != nil {
		return m.CID
	}
	return nil
}

type GroupMetadataEvent struct {
	// event_context contains context information about the event
	EventContext *EventContext `protobuf:"bytes,1,opt,name=event_context,json=eventContext,proto3" json:"event_context,omitempty"`
	// metadata contains the newly available metadata
	Metadata *GroupMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// event_clear clear bytes for the event
	Event                []byte   `protobuf:"bytes,3,opt,name=event,proto3" json:"event,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMetadataEvent) Reset()         { *m = GroupMetadataEvent{} }
func (m *GroupMetadataEvent) String() string { return proto.CompactTextString(m) }
func (*GroupMetadataEvent) ProtoMessage()    {}
func (*GroupMetadataEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{55}
}

func (m *GroupMetadataEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMetadataEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMetadataEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMetadataEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMetadataEvent.Merge(m, src)
}

func (m *GroupMetadataEvent) XXX_Size() int {
	return m.Size()
}

func (m *GroupMetadataEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMetadataEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMetadataEvent proto.InternalMessageInfo

func (m *GroupMetadataEvent) GetEventContext() *EventContext {
	if m != nil {
		return m.EventContext
	}
	return nil
}

func (m *GroupMetadataEvent) GetMetadata() *GroupMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GroupMetadataEvent) GetEvent() []byte {
	if m != nil {
		return m.Event
	}
	return nil
}

type GroupMessageEvent struct {
	// event_context contains context information about the event
	EventContext *EventContext `protobuf:"bytes,1,opt,name=event_context,json=eventContext,proto3" json:"event_context,omitempty"`
	// headers contains headers of the secure message
	Headers *MessageHeaders `protobuf:"bytes,2,opt,name=headers,proto3" json:"headers,omitempty"`
	// message contains the secure message payload
	Message              []byte   `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMessageEvent) Reset()         { *m = GroupMessageEvent{} }
func (m *GroupMessageEvent) String() string { return proto.CompactTextString(m) }
func (*GroupMessageEvent) ProtoMessage()    {}
func (*GroupMessageEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{56}
}

func (m *GroupMessageEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMessageEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMessageEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMessageEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMessageEvent.Merge(m, src)
}

func (m *GroupMessageEvent) XXX_Size() int {
	return m.Size()
}

func (m *GroupMessageEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMessageEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMessageEvent proto.InternalMessageInfo

func (m *GroupMessageEvent) GetEventContext() *EventContext {
	if m != nil {
		return m.EventContext
	}
	return nil
}

func (m *GroupMessageEvent) GetHeaders() *MessageHeaders {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *GroupMessageEvent) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

type GroupMetadataList struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMetadataList) Reset()         { *m = GroupMetadataList{} }
func (m *GroupMetadataList) String() string { return proto.CompactTextString(m) }
func (*GroupMetadataList) ProtoMessage()    {}
func (*GroupMetadataList) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{57}
}

func (m *GroupMetadataList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMetadataList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMetadataList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMetadataList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMetadataList.Merge(m, src)
}

func (m *GroupMetadataList) XXX_Size() int {
	return m.Size()
}

func (m *GroupMetadataList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMetadataList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMetadataList proto.InternalMessageInfo

type GroupMetadataList_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// since is the lower ID bound used to filter events
	// if not set, will return events since the beginning
	SinceID []byte `protobuf:"bytes,2,opt,name=since_id,json=sinceId,proto3" json:"since_id,omitempty"`
	// since_now will list only new event to come
	// since_id must not be set
	SinceNow bool `protobuf:"varint,3,opt,name=since_now,json=sinceNow,proto3" json:"since_now,omitempty"`
	// until is the upper ID bound used to filter events
	// if not set, will subscribe to new events to come
	UntilID []byte `protobuf:"bytes,4,opt,name=until_id,json=untilId,proto3" json:"until_id,omitempty"`
	// until_now will not list new event to come
	// until_id must not be set
	UntilNow bool `protobuf:"varint,5,opt,name=until_now,json=untilNow,proto3" json:"until_now,omitempty"`
	// reverse_order indicates whether the previous events should be returned in
	// reverse chronological order
	ReverseOrder         bool     `protobuf:"varint,6,opt,name=reverse_order,json=reverseOrder,proto3" json:"reverse_order,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMetadataList_Request) Reset()         { *m = GroupMetadataList_Request{} }
func (m *GroupMetadataList_Request) String() string { return proto.CompactTextString(m) }
func (*GroupMetadataList_Request) ProtoMessage()    {}
func (*GroupMetadataList_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{57, 0}
}

func (m *GroupMetadataList_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMetadataList_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMetadataList_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMetadataList_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMetadataList_Request.Merge(m, src)
}

func (m *GroupMetadataList_Request) XXX_Size() int {
	return m.Size()
}

func (m *GroupMetadataList_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMetadataList_Request.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMetadataList_Request proto.InternalMessageInfo

func (m *GroupMetadataList_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *GroupMetadataList_Request) GetSinceID() []byte {
	if m != nil {
		return m.SinceID
	}
	return nil
}

func (m *GroupMetadataList_Request) GetSinceNow() bool {
	if m != nil {
		return m.SinceNow
	}
	return false
}

func (m *GroupMetadataList_Request) GetUntilID() []byte {
	if m != nil {
		return m.UntilID
	}
	return nil
}

func (m *GroupMetadataList_Request) GetUntilNow() bool {
	if m != nil {
		return m.UntilNow
	}
	return false
}

func (m *GroupMetadataList_Request) GetReverseOrder() bool {
	if m != nil {
		return m.ReverseOrder
	}
	return false
}

type GroupMessageList struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMessageList) Reset()         { *m = GroupMessageList{} }
func (m *GroupMessageList) String() string { return proto.CompactTextString(m) }
func (*GroupMessageList) ProtoMessage()    {}
func (*GroupMessageList) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{58}
}

func (m *GroupMessageList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMessageList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMessageList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMessageList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMessageList.Merge(m, src)
}

func (m *GroupMessageList) XXX_Size() int {
	return m.Size()
}

func (m *GroupMessageList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMessageList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMessageList proto.InternalMessageInfo

type GroupMessageList_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// since is the lower ID bound used to filter events
	// if not set, will return events since the beginning
	SinceID []byte `protobuf:"bytes,2,opt,name=since_id,json=sinceId,proto3" json:"since_id,omitempty"`
	// since_now will list only new event to come
	// since_id must not be set
	SinceNow bool `protobuf:"varint,3,opt,name=since_now,json=sinceNow,proto3" json:"since_now,omitempty"`
	// until is the upper ID bound used to filter events
	// if not set, will subscribe to new events to come
	UntilID []byte `protobuf:"bytes,4,opt,name=until_id,json=untilId,proto3" json:"until_id,omitempty"`
	// until_now will not list new event to come
	// until_id must not be set
	UntilNow bool `protobuf:"varint,5,opt,name=until_now,json=untilNow,proto3" json:"until_now,omitempty"`
	// reverse_order indicates whether the previous events should be returned in
	// reverse chronological order
	ReverseOrder         bool     `protobuf:"varint,6,opt,name=reverse_order,json=reverseOrder,proto3" json:"reverse_order,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMessageList_Request) Reset()         { *m = GroupMessageList_Request{} }
func (m *GroupMessageList_Request) String() string { return proto.CompactTextString(m) }
func (*GroupMessageList_Request) ProtoMessage()    {}
func (*GroupMessageList_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{58, 0}
}

func (m *GroupMessageList_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupMessageList_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMessageList_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupMessageList_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMessageList_Request.Merge(m, src)
}

func (m *GroupMessageList_Request) XXX_Size() int {
	return m.Size()
}

func (m *GroupMessageList_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMessageList_Request.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMessageList_Request proto.InternalMessageInfo

func (m *GroupMessageList_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *GroupMessageList_Request) GetSinceID() []byte {
	if m != nil {
		return m.SinceID
	}
	return nil
}

func (m *GroupMessageList_Request) GetSinceNow() bool {
	if m != nil {
		return m.SinceNow
	}
	return false
}

func (m *GroupMessageList_Request) GetUntilID() []byte {
	if m != nil {
		return m.UntilID
	}
	return nil
}

func (m *GroupMessageList_Request) GetUntilNow() bool {
	if m != nil {
		return m.UntilNow
	}
	return false
}

func (m *GroupMessageList_Request) GetReverseOrder() bool {
	if m != nil {
		return m.ReverseOrder
	}
	return false
}

type GroupInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupInfo) Reset()         { *m = GroupInfo{} }
func (m *GroupInfo) String() string { return proto.CompactTextString(m) }
func (*GroupInfo) ProtoMessage()    {}
func (*GroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{59}
}

func (m *GroupInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupInfo.Merge(m, src)
}

func (m *GroupInfo) XXX_Size() int {
	return m.Size()
}

func (m *GroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GroupInfo proto.InternalMessageInfo

type GroupInfo_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// contact_pk is the identifier of the contact
	ContactPK            []byte   `protobuf:"bytes,2,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupInfo_Request) Reset()         { *m = GroupInfo_Request{} }
func (m *GroupInfo_Request) String() string { return proto.CompactTextString(m) }
func (*GroupInfo_Request) ProtoMessage()    {}
func (*GroupInfo_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{59, 0}
}

func (m *GroupInfo_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupInfo_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupInfo_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupInfo_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupInfo_Request.Merge(m, src)
}

func (m *GroupInfo_Request) XXX_Size() int {
	return m.Size()
}

func (m *GroupInfo_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_GroupInfo_Request proto.InternalMessageInfo

func (m *GroupInfo_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *GroupInfo_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type GroupInfo_Reply struct {
	// group is the group invitation, containing the group pk and its type
	Group *Group `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// member_pk is the identifier of the current member in the group
	MemberPK []byte `protobuf:"bytes,2,opt,name=member_pk,json=memberPk,proto3" json:"member_pk,omitempty"`
	// device_pk is the identifier of the current device in the group
	DevicePK             []byte   `protobuf:"bytes,3,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupInfo_Reply) Reset()         { *m = GroupInfo_Reply{} }
func (m *GroupInfo_Reply) String() string { return proto.CompactTextString(m) }
func (*GroupInfo_Reply) ProtoMessage()    {}
func (*GroupInfo_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{59, 1}
}

func (m *GroupInfo_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *GroupInfo_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupInfo_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *GroupInfo_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupInfo_Reply.Merge(m, src)
}

func (m *GroupInfo_Reply) XXX_Size() int {
	return m.Size()
}

func (m *GroupInfo_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupInfo_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_GroupInfo_Reply proto.InternalMessageInfo

func (m *GroupInfo_Reply) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *GroupInfo_Reply) GetMemberPK() []byte {
	if m != nil {
		return m.MemberPK
	}
	return nil
}

func (m *GroupInfo_Reply) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

type ActivateGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ActivateGroup) Reset()         { *m = ActivateGroup{} }
func (m *ActivateGroup) String() string { return proto.CompactTextString(m) }
func (*ActivateGroup) ProtoMessage()    {}
func (*ActivateGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{60}
}

func (m *ActivateGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ActivateGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivateGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ActivateGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivateGroup.Merge(m, src)
}

func (m *ActivateGroup) XXX_Size() int {
	return m.Size()
}

func (m *ActivateGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivateGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ActivateGroup proto.InternalMessageInfo

type ActivateGroup_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// local_only will open the group without enabling network interactions
	// with other members
	LocalOnly            bool     `protobuf:"varint,2,opt,name=local_only,json=localOnly,proto3" json:"local_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ActivateGroup_Request) Reset()         { *m = ActivateGroup_Request{} }
func (m *ActivateGroup_Request) String() string { return proto.CompactTextString(m) }
func (*ActivateGroup_Request) ProtoMessage()    {}
func (*ActivateGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{60, 0}
}

func (m *ActivateGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ActivateGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivateGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ActivateGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivateGroup_Request.Merge(m, src)
}

func (m *ActivateGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *ActivateGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivateGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ActivateGroup_Request proto.InternalMessageInfo

func (m *ActivateGroup_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *ActivateGroup_Request) GetLocalOnly() bool {
	if m != nil {
		return m.LocalOnly
	}
	return false
}

type ActivateGroup_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ActivateGroup_Reply) Reset()         { *m = ActivateGroup_Reply{} }
func (m *ActivateGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*ActivateGroup_Reply) ProtoMessage()    {}
func (*ActivateGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{60, 1}
}

func (m *ActivateGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ActivateGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivateGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ActivateGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivateGroup_Reply.Merge(m, src)
}

func (m *ActivateGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ActivateGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivateGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ActivateGroup_Reply proto.InternalMessageInfo

type DeactivateGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeactivateGroup) Reset()         { *m = DeactivateGroup{} }
func (m *DeactivateGroup) String() string { return proto.CompactTextString(m) }
func (*DeactivateGroup) ProtoMessage()    {}
func (*DeactivateGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{61}
}

func (m *DeactivateGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DeactivateGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeactivateGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DeactivateGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeactivateGroup.Merge(m, src)
}

func (m *DeactivateGroup) XXX_Size() int {
	return m.Size()
}

func (m *DeactivateGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DeactivateGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DeactivateGroup proto.InternalMessageInfo

type DeactivateGroup_Request struct {
	// group_pk is the identifier of the group
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeactivateGroup_Request) Reset()         { *m = DeactivateGroup_Request{} }
func (m *DeactivateGroup_Request) String() string { return proto.CompactTextString(m) }
func (*DeactivateGroup_Request) ProtoMessage()    {}
func (*DeactivateGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{61, 0}
}

func (m *DeactivateGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DeactivateGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeactivateGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DeactivateGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeactivateGroup_Request.Merge(m, src)
}

func (m *DeactivateGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *DeactivateGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_DeactivateGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_DeactivateGroup_Request proto.InternalMessageInfo

func (m *DeactivateGroup_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type DeactivateGroup_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeactivateGroup_Reply) Reset()         { *m = DeactivateGroup_Reply{} }
func (m *DeactivateGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*DeactivateGroup_Reply) ProtoMessage()    {}
func (*DeactivateGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{61, 1}
}

func (m *DeactivateGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DeactivateGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeactivateGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DeactivateGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeactivateGroup_Reply.Merge(m, src)
}

func (m *DeactivateGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *DeactivateGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_DeactivateGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_DeactivateGroup_Reply proto.InternalMessageInfo

type MonitorGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup) Reset()         { *m = MonitorGroup{} }
func (m *MonitorGroup) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup) ProtoMessage()    {}
func (*MonitorGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62}
}

func (m *MonitorGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup.Merge(m, src)
}

func (m *MonitorGroup) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup proto.InternalMessageInfo

type MonitorGroup_EventMonitorAdvertiseGroup struct {
	// local peer id advertised
	PeerID string `protobuf:"bytes,1,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// maddrs should describe peer maddrs
	Maddrs []string `protobuf:"bytes,2,rep,name=maddrs,proto3" json:"maddrs,omitempty"`
	// driver_name used to advertise the peer
	DriverName string `protobuf:"bytes,3,opt,name=driver_name,json=driverName,proto3" json:"driver_name,omitempty"`
	// event topic
	Topic                string   `protobuf:"bytes,4,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) Reset() {
	*m = MonitorGroup_EventMonitorAdvertiseGroup{}
}
func (m *MonitorGroup_EventMonitorAdvertiseGroup) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_EventMonitorAdvertiseGroup) ProtoMessage()    {}
func (*MonitorGroup_EventMonitorAdvertiseGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 0}
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_EventMonitorAdvertiseGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_EventMonitorAdvertiseGroup.Merge(m, src)
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_EventMonitorAdvertiseGroup.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_EventMonitorAdvertiseGroup proto.InternalMessageInfo

func (m *MonitorGroup_EventMonitorAdvertiseGroup) GetPeerID() string {
	if m != nil {
		return m.PeerID
	}
	return ""
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) GetMaddrs() []string {
	if m != nil {
		return m.Maddrs
	}
	return nil
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) GetDriverName() string {
	if m != nil {
		return m.DriverName
	}
	return ""
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

type MonitorGroup_EventMonitorPeerFound struct {
	// peer_id of the peer in this context
	PeerID string `protobuf:"bytes,1,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// maddrs of the peer in this context
	Maddrs []string `protobuf:"bytes,2,rep,name=maddrs,proto3" json:"maddrs,omitempty"`
	// driver_name used to found the peer
	DriverName string `protobuf:"bytes,3,opt,name=driver_name,json=driverName,proto3" json:"driver_name,omitempty"`
	// event topic
	Topic                string   `protobuf:"bytes,4,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_EventMonitorPeerFound) Reset()         { *m = MonitorGroup_EventMonitorPeerFound{} }
func (m *MonitorGroup_EventMonitorPeerFound) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_EventMonitorPeerFound) ProtoMessage()    {}
func (*MonitorGroup_EventMonitorPeerFound) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 1}
}

func (m *MonitorGroup_EventMonitorPeerFound) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_EventMonitorPeerFound) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_EventMonitorPeerFound.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_EventMonitorPeerFound) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerFound.Merge(m, src)
}

func (m *MonitorGroup_EventMonitorPeerFound) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_EventMonitorPeerFound) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerFound.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_EventMonitorPeerFound proto.InternalMessageInfo

func (m *MonitorGroup_EventMonitorPeerFound) GetPeerID() string {
	if m != nil {
		return m.PeerID
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerFound) GetMaddrs() []string {
	if m != nil {
		return m.Maddrs
	}
	return nil
}

func (m *MonitorGroup_EventMonitorPeerFound) GetDriverName() string {
	if m != nil {
		return m.DriverName
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerFound) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

type MonitorGroup_EventMonitorPeerJoin struct {
	// peer_id of the peer in this context
	PeerID string `protobuf:"bytes,1,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// maddrs of the peer in this context
	Maddrs []string `protobuf:"bytes,2,rep,name=maddrs,proto3" json:"maddrs,omitempty"`
	// event topic
	Topic string `protobuf:"bytes,3,opt,name=topic,proto3" json:"topic,omitempty"`
	// is_self indecitate if the given peer is you
	IsSelf               bool     `protobuf:"varint,4,opt,name=is_self,json=isSelf,proto3" json:"is_self,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_EventMonitorPeerJoin) Reset()         { *m = MonitorGroup_EventMonitorPeerJoin{} }
func (m *MonitorGroup_EventMonitorPeerJoin) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_EventMonitorPeerJoin) ProtoMessage()    {}
func (*MonitorGroup_EventMonitorPeerJoin) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 2}
}

func (m *MonitorGroup_EventMonitorPeerJoin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_EventMonitorPeerJoin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_EventMonitorPeerJoin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_EventMonitorPeerJoin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerJoin.Merge(m, src)
}

func (m *MonitorGroup_EventMonitorPeerJoin) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_EventMonitorPeerJoin) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerJoin.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_EventMonitorPeerJoin proto.InternalMessageInfo

func (m *MonitorGroup_EventMonitorPeerJoin) GetPeerID() string {
	if m != nil {
		return m.PeerID
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerJoin) GetMaddrs() []string {
	if m != nil {
		return m.Maddrs
	}
	return nil
}

func (m *MonitorGroup_EventMonitorPeerJoin) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerJoin) GetIsSelf() bool {
	if m != nil {
		return m.IsSelf
	}
	return false
}

type MonitorGroup_EventMonitorPeerLeave struct {
	// peer_id of the peer in this context
	PeerID string `protobuf:"bytes,1,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	// event topic
	Topic string `protobuf:"bytes,3,opt,name=topic,proto3" json:"topic,omitempty"`
	// is_self indecitate if the given peer is you
	IsSelf               bool     `protobuf:"varint,4,opt,name=is_self,json=isSelf,proto3" json:"is_self,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_EventMonitorPeerLeave) Reset()         { *m = MonitorGroup_EventMonitorPeerLeave{} }
func (m *MonitorGroup_EventMonitorPeerLeave) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_EventMonitorPeerLeave) ProtoMessage()    {}
func (*MonitorGroup_EventMonitorPeerLeave) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 3}
}

func (m *MonitorGroup_EventMonitorPeerLeave) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_EventMonitorPeerLeave) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_EventMonitorPeerLeave.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_EventMonitorPeerLeave) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerLeave.Merge(m, src)
}

func (m *MonitorGroup_EventMonitorPeerLeave) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_EventMonitorPeerLeave) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_EventMonitorPeerLeave.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_EventMonitorPeerLeave proto.InternalMessageInfo

func (m *MonitorGroup_EventMonitorPeerLeave) GetPeerID() string {
	if m != nil {
		return m.PeerID
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerLeave) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *MonitorGroup_EventMonitorPeerLeave) GetIsSelf() bool {
	if m != nil {
		return m.IsSelf
	}
	return false
}

type MonitorGroup_EventMonitor struct {
	Type                 MonitorGroup_TypeEventMonitor            `protobuf:"varint,1,opt,name=type,proto3,enum=berty.protocol.v1.MonitorGroup_TypeEventMonitor" json:"type,omitempty"`
	AdvertiseGroup       *MonitorGroup_EventMonitorAdvertiseGroup `protobuf:"bytes,2,opt,name=advertise_group,json=advertiseGroup,proto3" json:"advertise_group,omitempty"`
	PeerFound            *MonitorGroup_EventMonitorPeerFound      `protobuf:"bytes,3,opt,name=peer_found,json=peerFound,proto3" json:"peer_found,omitempty"`
	PeerJoin             *MonitorGroup_EventMonitorPeerJoin       `protobuf:"bytes,4,opt,name=peer_join,json=peerJoin,proto3" json:"peer_join,omitempty"`
	PeerLeave            *MonitorGroup_EventMonitorPeerLeave      `protobuf:"bytes,5,opt,name=peer_leave,json=peerLeave,proto3" json:"peer_leave,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *MonitorGroup_EventMonitor) Reset()         { *m = MonitorGroup_EventMonitor{} }
func (m *MonitorGroup_EventMonitor) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_EventMonitor) ProtoMessage()    {}
func (*MonitorGroup_EventMonitor) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 4}
}

func (m *MonitorGroup_EventMonitor) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_EventMonitor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_EventMonitor.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_EventMonitor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_EventMonitor.Merge(m, src)
}

func (m *MonitorGroup_EventMonitor) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_EventMonitor) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_EventMonitor.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_EventMonitor proto.InternalMessageInfo

func (m *MonitorGroup_EventMonitor) GetType() MonitorGroup_TypeEventMonitor {
	if m != nil {
		return m.Type
	}
	return TypeEventMonitorUndefined
}

func (m *MonitorGroup_EventMonitor) GetAdvertiseGroup() *MonitorGroup_EventMonitorAdvertiseGroup {
	if m != nil {
		return m.AdvertiseGroup
	}
	return nil
}

func (m *MonitorGroup_EventMonitor) GetPeerFound() *MonitorGroup_EventMonitorPeerFound {
	if m != nil {
		return m.PeerFound
	}
	return nil
}

func (m *MonitorGroup_EventMonitor) GetPeerJoin() *MonitorGroup_EventMonitorPeerJoin {
	if m != nil {
		return m.PeerJoin
	}
	return nil
}

func (m *MonitorGroup_EventMonitor) GetPeerLeave() *MonitorGroup_EventMonitorPeerLeave {
	if m != nil {
		return m.PeerLeave
	}
	return nil
}

type MonitorGroup_Request struct {
	// filter_group_pk, if set, will filter event by group PK
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_Request) Reset()         { *m = MonitorGroup_Request{} }
func (m *MonitorGroup_Request) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_Request) ProtoMessage()    {}
func (*MonitorGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 5}
}

func (m *MonitorGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_Request.Merge(m, src)
}

func (m *MonitorGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_Request proto.InternalMessageInfo

func (m *MonitorGroup_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type MonitorGroup_Reply struct {
	// monitor event
	Event *MonitorGroup_EventMonitor `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// group_pk is the identifier of the group
	GroupPK              []byte   `protobuf:"bytes,2,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitorGroup_Reply) Reset()         { *m = MonitorGroup_Reply{} }
func (m *MonitorGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*MonitorGroup_Reply) ProtoMessage()    {}
func (*MonitorGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{62, 6}
}

func (m *MonitorGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MonitorGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MonitorGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MonitorGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitorGroup_Reply.Merge(m, src)
}

func (m *MonitorGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *MonitorGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitorGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_MonitorGroup_Reply proto.InternalMessageInfo

func (m *MonitorGroup_Reply) GetEvent() *MonitorGroup_EventMonitor {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *MonitorGroup_Reply) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type DebugListGroups struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugListGroups) Reset()         { *m = DebugListGroups{} }
func (m *DebugListGroups) String() string { return proto.CompactTextString(m) }
func (*DebugListGroups) ProtoMessage()    {}
func (*DebugListGroups) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{63}
}

func (m *DebugListGroups) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugListGroups) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugListGroups.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugListGroups) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugListGroups.Merge(m, src)
}

func (m *DebugListGroups) XXX_Size() int {
	return m.Size()
}

func (m *DebugListGroups) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugListGroups.DiscardUnknown(m)
}

var xxx_messageInfo_DebugListGroups proto.InternalMessageInfo

type DebugListGroups_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugListGroups_Request) Reset()         { *m = DebugListGroups_Request{} }
func (m *DebugListGroups_Request) String() string { return proto.CompactTextString(m) }
func (*DebugListGroups_Request) ProtoMessage()    {}
func (*DebugListGroups_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{63, 0}
}

func (m *DebugListGroups_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugListGroups_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugListGroups_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugListGroups_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugListGroups_Request.Merge(m, src)
}

func (m *DebugListGroups_Request) XXX_Size() int {
	return m.Size()
}

func (m *DebugListGroups_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugListGroups_Request.DiscardUnknown(m)
}

var xxx_messageInfo_DebugListGroups_Request proto.InternalMessageInfo

type DebugListGroups_Reply struct {
	// group_pk is the public key of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// group_type is the type of the group
	GroupType GroupType `protobuf:"varint,2,opt,name=group_type,json=groupType,proto3,enum=berty.protocol.v1.GroupType" json:"group_type,omitempty"`
	// contact_pk is the contact public key if appropriate
	ContactPK            []byte   `protobuf:"bytes,3,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugListGroups_Reply) Reset()         { *m = DebugListGroups_Reply{} }
func (m *DebugListGroups_Reply) String() string { return proto.CompactTextString(m) }
func (*DebugListGroups_Reply) ProtoMessage()    {}
func (*DebugListGroups_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{63, 1}
}

func (m *DebugListGroups_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugListGroups_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugListGroups_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugListGroups_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugListGroups_Reply.Merge(m, src)
}

func (m *DebugListGroups_Reply) XXX_Size() int {
	return m.Size()
}

func (m *DebugListGroups_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugListGroups_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_DebugListGroups_Reply proto.InternalMessageInfo

func (m *DebugListGroups_Reply) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *DebugListGroups_Reply) GetGroupType() GroupType {
	if m != nil {
		return m.GroupType
	}
	return GroupTypeUndefined
}

func (m *DebugListGroups_Reply) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

type DebugInspectGroupStore struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugInspectGroupStore) Reset()         { *m = DebugInspectGroupStore{} }
func (m *DebugInspectGroupStore) String() string { return proto.CompactTextString(m) }
func (*DebugInspectGroupStore) ProtoMessage()    {}
func (*DebugInspectGroupStore) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{64}
}

func (m *DebugInspectGroupStore) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugInspectGroupStore) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugInspectGroupStore.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugInspectGroupStore) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugInspectGroupStore.Merge(m, src)
}

func (m *DebugInspectGroupStore) XXX_Size() int {
	return m.Size()
}

func (m *DebugInspectGroupStore) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugInspectGroupStore.DiscardUnknown(m)
}

var xxx_messageInfo_DebugInspectGroupStore proto.InternalMessageInfo

type DebugInspectGroupStore_Request struct {
	// group_pk is the identifier of the group
	GroupPK []byte `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	// log_type is the log to inspect
	LogType              DebugInspectGroupLogType `protobuf:"varint,2,opt,name=log_type,json=logType,proto3,enum=berty.protocol.v1.DebugInspectGroupLogType" json:"log_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *DebugInspectGroupStore_Request) Reset()         { *m = DebugInspectGroupStore_Request{} }
func (m *DebugInspectGroupStore_Request) String() string { return proto.CompactTextString(m) }
func (*DebugInspectGroupStore_Request) ProtoMessage()    {}
func (*DebugInspectGroupStore_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{64, 0}
}

func (m *DebugInspectGroupStore_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugInspectGroupStore_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugInspectGroupStore_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugInspectGroupStore_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugInspectGroupStore_Request.Merge(m, src)
}

func (m *DebugInspectGroupStore_Request) XXX_Size() int {
	return m.Size()
}

func (m *DebugInspectGroupStore_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugInspectGroupStore_Request.DiscardUnknown(m)
}

var xxx_messageInfo_DebugInspectGroupStore_Request proto.InternalMessageInfo

func (m *DebugInspectGroupStore_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *DebugInspectGroupStore_Request) GetLogType() DebugInspectGroupLogType {
	if m != nil {
		return m.LogType
	}
	return DebugInspectGroupLogTypeUndefined
}

type DebugInspectGroupStore_Reply struct {
	// cid is the CID of the IPFS log entry
	CID []byte `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	// parent_cids is the list of the parent entries
	ParentCIDs [][]byte `protobuf:"bytes,2,rep,name=parent_cids,json=parentCids,proto3" json:"parent_cids,omitempty"`
	// event_type metadata event type if subscribed to metadata events
	MetadataEventType EventType `protobuf:"varint,3,opt,name=metadata_event_type,json=metadataEventType,proto3,enum=berty.protocol.v1.EventType" json:"metadata_event_type,omitempty"`
	// device_pk is the public key of the device signing the entry
	DevicePK []byte `protobuf:"bytes,4,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	// payload is the un encrypted entry payload if available
	Payload              []byte   `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugInspectGroupStore_Reply) Reset()         { *m = DebugInspectGroupStore_Reply{} }
func (m *DebugInspectGroupStore_Reply) String() string { return proto.CompactTextString(m) }
func (*DebugInspectGroupStore_Reply) ProtoMessage()    {}
func (*DebugInspectGroupStore_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{64, 1}
}

func (m *DebugInspectGroupStore_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugInspectGroupStore_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugInspectGroupStore_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugInspectGroupStore_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugInspectGroupStore_Reply.Merge(m, src)
}

func (m *DebugInspectGroupStore_Reply) XXX_Size() int {
	return m.Size()
}

func (m *DebugInspectGroupStore_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugInspectGroupStore_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_DebugInspectGroupStore_Reply proto.InternalMessageInfo

func (m *DebugInspectGroupStore_Reply) GetCID() []byte {
	if m != nil {
		return m.CID
	}
	return nil
}

func (m *DebugInspectGroupStore_Reply) GetParentCIDs() [][]byte {
	if m != nil {
		return m.ParentCIDs
	}
	return nil
}

func (m *DebugInspectGroupStore_Reply) GetMetadataEventType() EventType {
	if m != nil {
		return m.MetadataEventType
	}
	return EventTypeUndefined
}

func (m *DebugInspectGroupStore_Reply) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *DebugInspectGroupStore_Reply) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

type DebugGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugGroup) Reset()         { *m = DebugGroup{} }
func (m *DebugGroup) String() string { return proto.CompactTextString(m) }
func (*DebugGroup) ProtoMessage()    {}
func (*DebugGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{65}
}

func (m *DebugGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugGroup.Merge(m, src)
}

func (m *DebugGroup) XXX_Size() int {
	return m.Size()
}

func (m *DebugGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DebugGroup proto.InternalMessageInfo

type DebugGroup_Request struct {
	// group_pk is the identifier of the group
	GroupPK              []byte   `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugGroup_Request) Reset()         { *m = DebugGroup_Request{} }
func (m *DebugGroup_Request) String() string { return proto.CompactTextString(m) }
func (*DebugGroup_Request) ProtoMessage()    {}
func (*DebugGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{65, 0}
}

func (m *DebugGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugGroup_Request.Merge(m, src)
}

func (m *DebugGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *DebugGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_DebugGroup_Request proto.InternalMessageInfo

func (m *DebugGroup_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type DebugGroup_Reply struct {
	// peer_ids is the list of peer ids connected to the same group
	PeerIDs              []string `protobuf:"bytes,1,rep,name=peer_ids,json=peerIds,proto3" json:"peer_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugGroup_Reply) Reset()         { *m = DebugGroup_Reply{} }
func (m *DebugGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*DebugGroup_Reply) ProtoMessage()    {}
func (*DebugGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{65, 1}
}

func (m *DebugGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugGroup_Reply.Merge(m, src)
}

func (m *DebugGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *DebugGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_DebugGroup_Reply proto.InternalMessageInfo

func (m *DebugGroup_Reply) GetPeerIDs() []string {
	if m != nil {
		return m.PeerIDs
	}
	return nil
}

type AuthExchangeResponse struct {
	AccessToken          string            `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	Scope                string            `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	Error                string            `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	ErrorDescription     string            `protobuf:"bytes,4,opt,name=error_description,json=errorDescription,proto3" json:"error_description,omitempty"`
	Services             map[string]string `protobuf:"bytes,5,rep,name=services,proto3" json:"services,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AuthExchangeResponse) Reset()         { *m = AuthExchangeResponse{} }
func (m *AuthExchangeResponse) String() string { return proto.CompactTextString(m) }
func (*AuthExchangeResponse) ProtoMessage()    {}
func (*AuthExchangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{66}
}

func (m *AuthExchangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthExchangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthExchangeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthExchangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthExchangeResponse.Merge(m, src)
}

func (m *AuthExchangeResponse) XXX_Size() int {
	return m.Size()
}

func (m *AuthExchangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthExchangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AuthExchangeResponse proto.InternalMessageInfo

func (m *AuthExchangeResponse) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *AuthExchangeResponse) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

func (m *AuthExchangeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *AuthExchangeResponse) GetErrorDescription() string {
	if m != nil {
		return m.ErrorDescription
	}
	return ""
}

func (m *AuthExchangeResponse) GetServices() map[string]string {
	if m != nil {
		return m.Services
	}
	return nil
}

type DebugAuthServiceSetToken struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugAuthServiceSetToken) Reset()         { *m = DebugAuthServiceSetToken{} }
func (m *DebugAuthServiceSetToken) String() string { return proto.CompactTextString(m) }
func (*DebugAuthServiceSetToken) ProtoMessage()    {}
func (*DebugAuthServiceSetToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{67}
}

func (m *DebugAuthServiceSetToken) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugAuthServiceSetToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugAuthServiceSetToken.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugAuthServiceSetToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugAuthServiceSetToken.Merge(m, src)
}

func (m *DebugAuthServiceSetToken) XXX_Size() int {
	return m.Size()
}

func (m *DebugAuthServiceSetToken) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugAuthServiceSetToken.DiscardUnknown(m)
}

var xxx_messageInfo_DebugAuthServiceSetToken proto.InternalMessageInfo

type DebugAuthServiceSetToken_Request struct {
	Token                *AuthExchangeResponse `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	AuthenticationURL    string                `protobuf:"bytes,2,opt,name=authentication_url,json=authenticationUrl,proto3" json:"authentication_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DebugAuthServiceSetToken_Request) Reset()         { *m = DebugAuthServiceSetToken_Request{} }
func (m *DebugAuthServiceSetToken_Request) String() string { return proto.CompactTextString(m) }
func (*DebugAuthServiceSetToken_Request) ProtoMessage()    {}
func (*DebugAuthServiceSetToken_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{67, 0}
}

func (m *DebugAuthServiceSetToken_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugAuthServiceSetToken_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugAuthServiceSetToken_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugAuthServiceSetToken_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugAuthServiceSetToken_Request.Merge(m, src)
}

func (m *DebugAuthServiceSetToken_Request) XXX_Size() int {
	return m.Size()
}

func (m *DebugAuthServiceSetToken_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugAuthServiceSetToken_Request.DiscardUnknown(m)
}

var xxx_messageInfo_DebugAuthServiceSetToken_Request proto.InternalMessageInfo

func (m *DebugAuthServiceSetToken_Request) GetToken() *AuthExchangeResponse {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *DebugAuthServiceSetToken_Request) GetAuthenticationURL() string {
	if m != nil {
		return m.AuthenticationURL
	}
	return ""
}

type DebugAuthServiceSetToken_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugAuthServiceSetToken_Reply) Reset()         { *m = DebugAuthServiceSetToken_Reply{} }
func (m *DebugAuthServiceSetToken_Reply) String() string { return proto.CompactTextString(m) }
func (*DebugAuthServiceSetToken_Reply) ProtoMessage()    {}
func (*DebugAuthServiceSetToken_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{67, 1}
}

func (m *DebugAuthServiceSetToken_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *DebugAuthServiceSetToken_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DebugAuthServiceSetToken_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *DebugAuthServiceSetToken_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugAuthServiceSetToken_Reply.Merge(m, src)
}

func (m *DebugAuthServiceSetToken_Reply) XXX_Size() int {
	return m.Size()
}

func (m *DebugAuthServiceSetToken_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugAuthServiceSetToken_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_DebugAuthServiceSetToken_Reply proto.InternalMessageInfo

type ShareableContact struct {
	// pk is the account to send a contact request to
	PK []byte `protobuf:"bytes,1,opt,name=pk,proto3" json:"pk,omitempty"`
	// public_rendezvous_seed is the rendezvous seed used by the account to send a contact request to
	PublicRendezvousSeed []byte `protobuf:"bytes,2,opt,name=public_rendezvous_seed,json=publicRendezvousSeed,proto3" json:"public_rendezvous_seed,omitempty"`
	// metadata is the metadata specific to the app to identify the contact for the request
	Metadata             []byte   `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShareableContact) Reset()         { *m = ShareableContact{} }
func (m *ShareableContact) String() string { return proto.CompactTextString(m) }
func (*ShareableContact) ProtoMessage()    {}
func (*ShareableContact) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{68}
}

func (m *ShareableContact) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ShareableContact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShareableContact.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ShareableContact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShareableContact.Merge(m, src)
}

func (m *ShareableContact) XXX_Size() int {
	return m.Size()
}

func (m *ShareableContact) XXX_DiscardUnknown() {
	xxx_messageInfo_ShareableContact.DiscardUnknown(m)
}

var xxx_messageInfo_ShareableContact proto.InternalMessageInfo

func (m *ShareableContact) GetPK() []byte {
	if m != nil {
		return m.PK
	}
	return nil
}

func (m *ShareableContact) GetPublicRendezvousSeed() []byte {
	if m != nil {
		return m.PublicRendezvousSeed
	}
	return nil
}

func (m *ShareableContact) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type ServiceTokenSupportedService struct {
	ServiceType          string   `protobuf:"bytes,1,opt,name=service_type,json=serviceType,proto3" json:"service_type,omitempty"`
	ServiceEndpoint      string   `protobuf:"bytes,2,opt,name=service_endpoint,json=serviceEndpoint,proto3" json:"service_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceTokenSupportedService) Reset()         { *m = ServiceTokenSupportedService{} }
func (m *ServiceTokenSupportedService) String() string { return proto.CompactTextString(m) }
func (*ServiceTokenSupportedService) ProtoMessage()    {}
func (*ServiceTokenSupportedService) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{69}
}

func (m *ServiceTokenSupportedService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServiceTokenSupportedService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceTokenSupportedService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServiceTokenSupportedService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceTokenSupportedService.Merge(m, src)
}

func (m *ServiceTokenSupportedService) XXX_Size() int {
	return m.Size()
}

func (m *ServiceTokenSupportedService) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceTokenSupportedService.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceTokenSupportedService proto.InternalMessageInfo

func (m *ServiceTokenSupportedService) GetServiceType() string {
	if m != nil {
		return m.ServiceType
	}
	return ""
}

func (m *ServiceTokenSupportedService) GetServiceEndpoint() string {
	if m != nil {
		return m.ServiceEndpoint
	}
	return ""
}

type ServiceToken struct {
	Token                string                          `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	AuthenticationURL    string                          `protobuf:"bytes,2,opt,name=authentication_url,json=authenticationUrl,proto3" json:"authentication_url,omitempty"`
	SupportedServices    []*ServiceTokenSupportedService `protobuf:"bytes,3,rep,name=supported_services,json=supportedServices,proto3" json:"supported_services,omitempty"`
	Expiration           int64                           `protobuf:"varint,4,opt,name=expiration,proto3" json:"expiration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *ServiceToken) Reset()         { *m = ServiceToken{} }
func (m *ServiceToken) String() string { return proto.CompactTextString(m) }
func (*ServiceToken) ProtoMessage()    {}
func (*ServiceToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{70}
}

func (m *ServiceToken) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServiceToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceToken.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServiceToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceToken.Merge(m, src)
}

func (m *ServiceToken) XXX_Size() int {
	return m.Size()
}

func (m *ServiceToken) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceToken.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceToken proto.InternalMessageInfo

func (m *ServiceToken) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *ServiceToken) GetAuthenticationURL() string {
	if m != nil {
		return m.AuthenticationURL
	}
	return ""
}

func (m *ServiceToken) GetSupportedServices() []*ServiceTokenSupportedService {
	if m != nil {
		return m.SupportedServices
	}
	return nil
}

func (m *ServiceToken) GetExpiration() int64 {
	if m != nil {
		return m.Expiration
	}
	return 0
}

type AuthServiceCompleteFlow struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceCompleteFlow) Reset()         { *m = AuthServiceCompleteFlow{} }
func (m *AuthServiceCompleteFlow) String() string { return proto.CompactTextString(m) }
func (*AuthServiceCompleteFlow) ProtoMessage()    {}
func (*AuthServiceCompleteFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{71}
}

func (m *AuthServiceCompleteFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceCompleteFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceCompleteFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceCompleteFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceCompleteFlow.Merge(m, src)
}

func (m *AuthServiceCompleteFlow) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceCompleteFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceCompleteFlow.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceCompleteFlow proto.InternalMessageInfo

type AuthServiceCompleteFlow_Request struct {
	CallbackURL          string   `protobuf:"bytes,1,opt,name=callback_url,json=callbackUrl,proto3" json:"callback_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceCompleteFlow_Request) Reset()         { *m = AuthServiceCompleteFlow_Request{} }
func (m *AuthServiceCompleteFlow_Request) String() string { return proto.CompactTextString(m) }
func (*AuthServiceCompleteFlow_Request) ProtoMessage()    {}
func (*AuthServiceCompleteFlow_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{71, 0}
}

func (m *AuthServiceCompleteFlow_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceCompleteFlow_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceCompleteFlow_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceCompleteFlow_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceCompleteFlow_Request.Merge(m, src)
}

func (m *AuthServiceCompleteFlow_Request) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceCompleteFlow_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceCompleteFlow_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceCompleteFlow_Request proto.InternalMessageInfo

func (m *AuthServiceCompleteFlow_Request) GetCallbackURL() string {
	if m != nil {
		return m.CallbackURL
	}
	return ""
}

type AuthServiceCompleteFlow_Reply struct {
	TokenID              string   `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3" json:"token_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceCompleteFlow_Reply) Reset()         { *m = AuthServiceCompleteFlow_Reply{} }
func (m *AuthServiceCompleteFlow_Reply) String() string { return proto.CompactTextString(m) }
func (*AuthServiceCompleteFlow_Reply) ProtoMessage()    {}
func (*AuthServiceCompleteFlow_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{71, 1}
}

func (m *AuthServiceCompleteFlow_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceCompleteFlow_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceCompleteFlow_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceCompleteFlow_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceCompleteFlow_Reply.Merge(m, src)
}

func (m *AuthServiceCompleteFlow_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceCompleteFlow_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceCompleteFlow_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceCompleteFlow_Reply proto.InternalMessageInfo

func (m *AuthServiceCompleteFlow_Reply) GetTokenID() string {
	if m != nil {
		return m.TokenID
	}
	return ""
}

type AuthServiceInitFlow struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceInitFlow) Reset()         { *m = AuthServiceInitFlow{} }
func (m *AuthServiceInitFlow) String() string { return proto.CompactTextString(m) }
func (*AuthServiceInitFlow) ProtoMessage()    {}
func (*AuthServiceInitFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{72}
}

func (m *AuthServiceInitFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceInitFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceInitFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceInitFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceInitFlow.Merge(m, src)
}

func (m *AuthServiceInitFlow) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceInitFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceInitFlow.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceInitFlow proto.InternalMessageInfo

type AuthServiceInitFlow_Request struct {
	AuthURL              string   `protobuf:"bytes,1,opt,name=auth_url,json=authUrl,proto3" json:"auth_url,omitempty"`
	Services             []string `protobuf:"bytes,3,rep,name=services,proto3" json:"services,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceInitFlow_Request) Reset()         { *m = AuthServiceInitFlow_Request{} }
func (m *AuthServiceInitFlow_Request) String() string { return proto.CompactTextString(m) }
func (*AuthServiceInitFlow_Request) ProtoMessage()    {}
func (*AuthServiceInitFlow_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{72, 0}
}

func (m *AuthServiceInitFlow_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceInitFlow_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceInitFlow_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceInitFlow_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceInitFlow_Request.Merge(m, src)
}

func (m *AuthServiceInitFlow_Request) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceInitFlow_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceInitFlow_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceInitFlow_Request proto.InternalMessageInfo

func (m *AuthServiceInitFlow_Request) GetAuthURL() string {
	if m != nil {
		return m.AuthURL
	}
	return ""
}

func (m *AuthServiceInitFlow_Request) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

type AuthServiceInitFlow_Reply struct {
	URL                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	SecureURL            bool     `protobuf:"varint,2,opt,name=secure_url,json=secureUrl,proto3" json:"secure_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthServiceInitFlow_Reply) Reset()         { *m = AuthServiceInitFlow_Reply{} }
func (m *AuthServiceInitFlow_Reply) String() string { return proto.CompactTextString(m) }
func (*AuthServiceInitFlow_Reply) ProtoMessage()    {}
func (*AuthServiceInitFlow_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{72, 1}
}

func (m *AuthServiceInitFlow_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AuthServiceInitFlow_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthServiceInitFlow_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AuthServiceInitFlow_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthServiceInitFlow_Reply.Merge(m, src)
}

func (m *AuthServiceInitFlow_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AuthServiceInitFlow_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthServiceInitFlow_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AuthServiceInitFlow_Reply proto.InternalMessageInfo

func (m *AuthServiceInitFlow_Reply) GetURL() string {
	if m != nil {
		return m.URL
	}
	return ""
}

func (m *AuthServiceInitFlow_Reply) GetSecureURL() bool {
	if m != nil {
		return m.SecureURL
	}
	return false
}

type ServicesTokenList struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServicesTokenList) Reset()         { *m = ServicesTokenList{} }
func (m *ServicesTokenList) String() string { return proto.CompactTextString(m) }
func (*ServicesTokenList) ProtoMessage()    {}
func (*ServicesTokenList) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{73}
}

func (m *ServicesTokenList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServicesTokenList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicesTokenList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServicesTokenList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicesTokenList.Merge(m, src)
}

func (m *ServicesTokenList) XXX_Size() int {
	return m.Size()
}

func (m *ServicesTokenList) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicesTokenList.DiscardUnknown(m)
}

var xxx_messageInfo_ServicesTokenList proto.InternalMessageInfo

type ServicesTokenList_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServicesTokenList_Request) Reset()         { *m = ServicesTokenList_Request{} }
func (m *ServicesTokenList_Request) String() string { return proto.CompactTextString(m) }
func (*ServicesTokenList_Request) ProtoMessage()    {}
func (*ServicesTokenList_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{73, 0}
}

func (m *ServicesTokenList_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServicesTokenList_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicesTokenList_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServicesTokenList_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicesTokenList_Request.Merge(m, src)
}

func (m *ServicesTokenList_Request) XXX_Size() int {
	return m.Size()
}

func (m *ServicesTokenList_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicesTokenList_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ServicesTokenList_Request proto.InternalMessageInfo

type ServicesTokenList_Reply struct {
	TokenID              string        `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3" json:"token_id,omitempty"`
	Service              *ServiceToken `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ServicesTokenList_Reply) Reset()         { *m = ServicesTokenList_Reply{} }
func (m *ServicesTokenList_Reply) String() string { return proto.CompactTextString(m) }
func (*ServicesTokenList_Reply) ProtoMessage()    {}
func (*ServicesTokenList_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{73, 1}
}

func (m *ServicesTokenList_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServicesTokenList_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicesTokenList_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServicesTokenList_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicesTokenList_Reply.Merge(m, src)
}

func (m *ServicesTokenList_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ServicesTokenList_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicesTokenList_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ServicesTokenList_Reply proto.InternalMessageInfo

func (m *ServicesTokenList_Reply) GetTokenID() string {
	if m != nil {
		return m.TokenID
	}
	return ""
}

func (m *ServicesTokenList_Reply) GetService() *ServiceToken {
	if m != nil {
		return m.Service
	}
	return nil
}

type ServicesTokenCode struct {
	Services             []string `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	CodeChallenge        string   `protobuf:"bytes,2,opt,name=code_challenge,json=codeChallenge,proto3" json:"code_challenge,omitempty"`
	TokenID              string   `protobuf:"bytes,3,opt,name=token_id,json=tokenId,proto3" json:"token_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServicesTokenCode) Reset()         { *m = ServicesTokenCode{} }
func (m *ServicesTokenCode) String() string { return proto.CompactTextString(m) }
func (*ServicesTokenCode) ProtoMessage()    {}
func (*ServicesTokenCode) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{74}
}

func (m *ServicesTokenCode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ServicesTokenCode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicesTokenCode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ServicesTokenCode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicesTokenCode.Merge(m, src)
}

func (m *ServicesTokenCode) XXX_Size() int {
	return m.Size()
}

func (m *ServicesTokenCode) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicesTokenCode.DiscardUnknown(m)
}

var xxx_messageInfo_ServicesTokenCode proto.InternalMessageInfo

func (m *ServicesTokenCode) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ServicesTokenCode) GetCodeChallenge() string {
	if m != nil {
		return m.CodeChallenge
	}
	return ""
}

func (m *ServicesTokenCode) GetTokenID() string {
	if m != nil {
		return m.TokenID
	}
	return ""
}

type ReplicationServiceRegisterGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceRegisterGroup) Reset()         { *m = ReplicationServiceRegisterGroup{} }
func (m *ReplicationServiceRegisterGroup) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceRegisterGroup) ProtoMessage()    {}
func (*ReplicationServiceRegisterGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{75}
}

func (m *ReplicationServiceRegisterGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceRegisterGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceRegisterGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceRegisterGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceRegisterGroup.Merge(m, src)
}

func (m *ReplicationServiceRegisterGroup) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceRegisterGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceRegisterGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceRegisterGroup proto.InternalMessageInfo

type ReplicationServiceRegisterGroup_Request struct {
	TokenID              string   `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3" json:"token_id,omitempty"`
	GroupPK              []byte   `protobuf:"bytes,2,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceRegisterGroup_Request) Reset() {
	*m = ReplicationServiceRegisterGroup_Request{}
}
func (m *ReplicationServiceRegisterGroup_Request) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceRegisterGroup_Request) ProtoMessage()    {}
func (*ReplicationServiceRegisterGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{75, 0}
}

func (m *ReplicationServiceRegisterGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceRegisterGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceRegisterGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceRegisterGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceRegisterGroup_Request.Merge(m, src)
}

func (m *ReplicationServiceRegisterGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceRegisterGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceRegisterGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceRegisterGroup_Request proto.InternalMessageInfo

func (m *ReplicationServiceRegisterGroup_Request) GetTokenID() string {
	if m != nil {
		return m.TokenID
	}
	return ""
}

func (m *ReplicationServiceRegisterGroup_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

type ReplicationServiceRegisterGroup_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceRegisterGroup_Reply) Reset()         { *m = ReplicationServiceRegisterGroup_Reply{} }
func (m *ReplicationServiceRegisterGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceRegisterGroup_Reply) ProtoMessage()    {}
func (*ReplicationServiceRegisterGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{75, 1}
}

func (m *ReplicationServiceRegisterGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceRegisterGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceRegisterGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceRegisterGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceRegisterGroup_Reply.Merge(m, src)
}

func (m *ReplicationServiceRegisterGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceRegisterGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceRegisterGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceRegisterGroup_Reply proto.InternalMessageInfo

type ReplicationServiceReplicateGroup struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceReplicateGroup) Reset()         { *m = ReplicationServiceReplicateGroup{} }
func (m *ReplicationServiceReplicateGroup) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceReplicateGroup) ProtoMessage()    {}
func (*ReplicationServiceReplicateGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{76}
}

func (m *ReplicationServiceReplicateGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceReplicateGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceReplicateGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceReplicateGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceReplicateGroup.Merge(m, src)
}

func (m *ReplicationServiceReplicateGroup) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceReplicateGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceReplicateGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceReplicateGroup proto.InternalMessageInfo

type ReplicationServiceReplicateGroup_Request struct {
	Group                *Group   `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceReplicateGroup_Request) Reset() {
	*m = ReplicationServiceReplicateGroup_Request{}
}
func (m *ReplicationServiceReplicateGroup_Request) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceReplicateGroup_Request) ProtoMessage()    {}
func (*ReplicationServiceReplicateGroup_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{76, 0}
}

func (m *ReplicationServiceReplicateGroup_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceReplicateGroup_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceReplicateGroup_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceReplicateGroup_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceReplicateGroup_Request.Merge(m, src)
}

func (m *ReplicationServiceReplicateGroup_Request) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceReplicateGroup_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceReplicateGroup_Request.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceReplicateGroup_Request proto.InternalMessageInfo

func (m *ReplicationServiceReplicateGroup_Request) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

type ReplicationServiceReplicateGroup_Reply struct {
	OK                   bool     `protobuf:"varint,1,opt,name=ok,proto3" json:"ok,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicationServiceReplicateGroup_Reply) Reset() {
	*m = ReplicationServiceReplicateGroup_Reply{}
}
func (m *ReplicationServiceReplicateGroup_Reply) String() string { return proto.CompactTextString(m) }
func (*ReplicationServiceReplicateGroup_Reply) ProtoMessage()    {}
func (*ReplicationServiceReplicateGroup_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{76, 1}
}

func (m *ReplicationServiceReplicateGroup_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *ReplicationServiceReplicateGroup_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationServiceReplicateGroup_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *ReplicationServiceReplicateGroup_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationServiceReplicateGroup_Reply.Merge(m, src)
}

func (m *ReplicationServiceReplicateGroup_Reply) XXX_Size() int {
	return m.Size()
}

func (m *ReplicationServiceReplicateGroup_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationServiceReplicateGroup_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationServiceReplicateGroup_Reply proto.InternalMessageInfo

func (m *ReplicationServiceReplicateGroup_Reply) GetOK() bool {
	if m != nil {
		return m.OK
	}
	return false
}

type SystemInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemInfo) Reset()         { *m = SystemInfo{} }
func (m *SystemInfo) String() string { return proto.CompactTextString(m) }
func (*SystemInfo) ProtoMessage()    {}
func (*SystemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77}
}

func (m *SystemInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo.Merge(m, src)
}

func (m *SystemInfo) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo proto.InternalMessageInfo

type SystemInfo_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemInfo_Request) Reset()         { *m = SystemInfo_Request{} }
func (m *SystemInfo_Request) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_Request) ProtoMessage()    {}
func (*SystemInfo_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 0}
}

func (m *SystemInfo_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_Request.Merge(m, src)
}

func (m *SystemInfo_Request) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_Request proto.InternalMessageInfo

type SystemInfo_Reply struct {
	Process              *SystemInfo_Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	P2P                  *SystemInfo_P2P     `protobuf:"bytes,2,opt,name=p2p,proto3" json:"p2p,omitempty"`
	OrbitDB              *SystemInfo_OrbitDB `protobuf:"bytes,3,opt,name=orbitdb,proto3" json:"orbitdb,omitempty"`
	Warns                []string            `protobuf:"bytes,4,rep,name=warns,proto3" json:"warns,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SystemInfo_Reply) Reset()         { *m = SystemInfo_Reply{} }
func (m *SystemInfo_Reply) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_Reply) ProtoMessage()    {}
func (*SystemInfo_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 1}
}

func (m *SystemInfo_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_Reply.Merge(m, src)
}

func (m *SystemInfo_Reply) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_Reply proto.InternalMessageInfo

func (m *SystemInfo_Reply) GetProcess() *SystemInfo_Process {
	if m != nil {
		return m.Process
	}
	return nil
}

func (m *SystemInfo_Reply) GetP2P() *SystemInfo_P2P {
	if m != nil {
		return m.P2P
	}
	return nil
}

func (m *SystemInfo_Reply) GetOrbitDB() *SystemInfo_OrbitDB {
	if m != nil {
		return m.OrbitDB
	}
	return nil
}

func (m *SystemInfo_Reply) GetWarns() []string {
	if m != nil {
		return m.Warns
	}
	return nil
}

type SystemInfo_OrbitDB struct {
	AccountMetadata      *SystemInfo_OrbitDB_ReplicationStatus `protobuf:"bytes,1,opt,name=account_metadata,json=accountMetadata,proto3" json:"account_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *SystemInfo_OrbitDB) Reset()         { *m = SystemInfo_OrbitDB{} }
func (m *SystemInfo_OrbitDB) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_OrbitDB) ProtoMessage()    {}
func (*SystemInfo_OrbitDB) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 2}
}

func (m *SystemInfo_OrbitDB) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_OrbitDB) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_OrbitDB.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_OrbitDB) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_OrbitDB.Merge(m, src)
}

func (m *SystemInfo_OrbitDB) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_OrbitDB) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_OrbitDB.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_OrbitDB proto.InternalMessageInfo

func (m *SystemInfo_OrbitDB) GetAccountMetadata() *SystemInfo_OrbitDB_ReplicationStatus {
	if m != nil {
		return m.AccountMetadata
	}
	return nil
}

type SystemInfo_OrbitDB_ReplicationStatus struct {
	Progress             int64    `protobuf:"varint,1,opt,name=progress,proto3" json:"progress,omitempty"`
	Maximum              int64    `protobuf:"varint,2,opt,name=maximum,proto3" json:"maximum,omitempty"`
	Buffered             int64    `protobuf:"varint,3,opt,name=buffered,proto3" json:"buffered,omitempty"`
	Queued               int64    `protobuf:"varint,4,opt,name=queued,proto3" json:"queued,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) Reset()         { *m = SystemInfo_OrbitDB_ReplicationStatus{} }
func (m *SystemInfo_OrbitDB_ReplicationStatus) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_OrbitDB_ReplicationStatus) ProtoMessage()    {}
func (*SystemInfo_OrbitDB_ReplicationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 2, 0}
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_OrbitDB_ReplicationStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_OrbitDB_ReplicationStatus.Merge(m, src)
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_OrbitDB_ReplicationStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_OrbitDB_ReplicationStatus proto.InternalMessageInfo

func (m *SystemInfo_OrbitDB_ReplicationStatus) GetProgress() int64 {
	if m != nil {
		return m.Progress
	}
	return 0
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) GetMaximum() int64 {
	if m != nil {
		return m.Maximum
	}
	return 0
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) GetBuffered() int64 {
	if m != nil {
		return m.Buffered
	}
	return 0
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) GetQueued() int64 {
	if m != nil {
		return m.Queued
	}
	return 0
}

type SystemInfo_P2P struct {
	ConnectedPeers       int64    `protobuf:"varint,1,opt,name=connected_peers,json=connectedPeers,proto3" json:"connected_peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemInfo_P2P) Reset()         { *m = SystemInfo_P2P{} }
func (m *SystemInfo_P2P) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_P2P) ProtoMessage()    {}
func (*SystemInfo_P2P) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 3}
}

func (m *SystemInfo_P2P) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_P2P) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_P2P.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_P2P) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_P2P.Merge(m, src)
}

func (m *SystemInfo_P2P) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_P2P) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_P2P.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_P2P proto.InternalMessageInfo

func (m *SystemInfo_P2P) GetConnectedPeers() int64 {
	if m != nil {
		return m.ConnectedPeers
	}
	return 0
}

type SystemInfo_Process struct {
	Version              string   `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	VcsRef               string   `protobuf:"bytes,2,opt,name=vcs_ref,json=vcsRef,proto3" json:"vcs_ref,omitempty"`
	UptimeMS             int64    `protobuf:"varint,3,opt,name=uptime_ms,json=uptimeMs,proto3" json:"uptime_ms,omitempty"`
	UserCPUTimeMS        int64    `protobuf:"varint,10,opt,name=user_cpu_time_ms,json=userCpuTimeMs,proto3" json:"user_cpu_time_ms,omitempty"`
	SystemCPUTimeMS      int64    `protobuf:"varint,11,opt,name=system_cpu_time_ms,json=systemCpuTimeMs,proto3" json:"system_cpu_time_ms,omitempty"`
	StartedAt            int64    `protobuf:"varint,12,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	RlimitCur            uint64   `protobuf:"varint,13,opt,name=rlimit_cur,json=rlimitCur,proto3" json:"rlimit_cur,omitempty"`
	NumGoroutine         int64    `protobuf:"varint,14,opt,name=num_goroutine,json=numGoroutine,proto3" json:"num_goroutine,omitempty"`
	Nofile               int64    `protobuf:"varint,15,opt,name=nofile,proto3" json:"nofile,omitempty"`
	TooManyOpenFiles     bool     `protobuf:"varint,16,opt,name=too_many_open_files,json=tooManyOpenFiles,proto3" json:"too_many_open_files,omitempty"`
	NumCPU               int64    `protobuf:"varint,17,opt,name=num_cpu,json=numCpu,proto3" json:"num_cpu,omitempty"`
	GoVersion            string   `protobuf:"bytes,18,opt,name=go_version,json=goVersion,proto3" json:"go_version,omitempty"`
	OperatingSystem      string   `protobuf:"bytes,19,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty"`
	HostName             string   `protobuf:"bytes,20,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	Arch                 string   `protobuf:"bytes,21,opt,name=arch,proto3" json:"arch,omitempty"`
	RlimitMax            uint64   `protobuf:"varint,22,opt,name=rlimit_max,json=rlimitMax,proto3" json:"rlimit_max,omitempty"`
	PID                  int64    `protobuf:"varint,23,opt,name=pid,proto3" json:"pid,omitempty"`
	PPID                 int64    `protobuf:"varint,24,opt,name=ppid,proto3" json:"ppid,omitempty"`
	Priority             int64    `protobuf:"varint,25,opt,name=priority,proto3" json:"priority,omitempty"`
	UID                  int64    `protobuf:"varint,26,opt,name=uid,proto3" json:"uid,omitempty"`
	WorkingDir           string   `protobuf:"bytes,27,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	SystemUsername       string   `protobuf:"bytes,28,opt,name=system_username,json=systemUsername,proto3" json:"system_username,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemInfo_Process) Reset()         { *m = SystemInfo_Process{} }
func (m *SystemInfo_Process) String() string { return proto.CompactTextString(m) }
func (*SystemInfo_Process) ProtoMessage()    {}
func (*SystemInfo_Process) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{77, 4}
}

func (m *SystemInfo_Process) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *SystemInfo_Process) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo_Process.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *SystemInfo_Process) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo_Process.Merge(m, src)
}

func (m *SystemInfo_Process) XXX_Size() int {
	return m.Size()
}

func (m *SystemInfo_Process) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo_Process.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo_Process proto.InternalMessageInfo

func (m *SystemInfo_Process) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *SystemInfo_Process) GetVcsRef() string {
	if m != nil {
		return m.VcsRef
	}
	return ""
}

func (m *SystemInfo_Process) GetUptimeMS() int64 {
	if m != nil {
		return m.UptimeMS
	}
	return 0
}

func (m *SystemInfo_Process) GetUserCPUTimeMS() int64 {
	if m != nil {
		return m.UserCPUTimeMS
	}
	return 0
}

func (m *SystemInfo_Process) GetSystemCPUTimeMS() int64 {
	if m != nil {
		return m.SystemCPUTimeMS
	}
	return 0
}

func (m *SystemInfo_Process) GetStartedAt() int64 {
	if m != nil {
		return m.StartedAt
	}
	return 0
}

func (m *SystemInfo_Process) GetRlimitCur() uint64 {
	if m != nil {
		return m.RlimitCur
	}
	return 0
}

func (m *SystemInfo_Process) GetNumGoroutine() int64 {
	if m != nil {
		return m.NumGoroutine
	}
	return 0
}

func (m *SystemInfo_Process) GetNofile() int64 {
	if m != nil {
		return m.Nofile
	}
	return 0
}

func (m *SystemInfo_Process) GetTooManyOpenFiles() bool {
	if m != nil {
		return m.TooManyOpenFiles
	}
	return false
}

func (m *SystemInfo_Process) GetNumCPU() int64 {
	if m != nil {
		return m.NumCPU
	}
	return 0
}

func (m *SystemInfo_Process) GetGoVersion() string {
	if m != nil {
		return m.GoVersion
	}
	return ""
}

func (m *SystemInfo_Process) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *SystemInfo_Process) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *SystemInfo_Process) GetArch() string {
	if m != nil {
		return m.Arch
	}
	return ""
}

func (m *SystemInfo_Process) GetRlimitMax() uint64 {
	if m != nil {
		return m.RlimitMax
	}
	return 0
}

func (m *SystemInfo_Process) GetPID() int64 {
	if m != nil {
		return m.PID
	}
	return 0
}

func (m *SystemInfo_Process) GetPPID() int64 {
	if m != nil {
		return m.PPID
	}
	return 0
}

func (m *SystemInfo_Process) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *SystemInfo_Process) GetUID() int64 {
	if m != nil {
		return m.UID
	}
	return 0
}

func (m *SystemInfo_Process) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *SystemInfo_Process) GetSystemUsername() string {
	if m != nil {
		return m.SystemUsername
	}
	return ""
}

type PeerList struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerList) Reset()         { *m = PeerList{} }
func (m *PeerList) String() string { return proto.CompactTextString(m) }
func (*PeerList) ProtoMessage()    {}
func (*PeerList) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78}
}

func (m *PeerList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList.Merge(m, src)
}

func (m *PeerList) XXX_Size() int {
	return m.Size()
}

func (m *PeerList) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList proto.InternalMessageInfo

type PeerList_Request struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerList_Request) Reset()         { *m = PeerList_Request{} }
func (m *PeerList_Request) String() string { return proto.CompactTextString(m) }
func (*PeerList_Request) ProtoMessage()    {}
func (*PeerList_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 0}
}

func (m *PeerList_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList_Request.Merge(m, src)
}

func (m *PeerList_Request) XXX_Size() int {
	return m.Size()
}

func (m *PeerList_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList_Request proto.InternalMessageInfo

type PeerList_Reply struct {
	Peers                []*PeerList_Peer `protobuf:"bytes,1,rep,name=peers,proto3" json:"peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PeerList_Reply) Reset()         { *m = PeerList_Reply{} }
func (m *PeerList_Reply) String() string { return proto.CompactTextString(m) }
func (*PeerList_Reply) ProtoMessage()    {}
func (*PeerList_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 1}
}

func (m *PeerList_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList_Reply.Merge(m, src)
}

func (m *PeerList_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PeerList_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList_Reply proto.InternalMessageInfo

func (m *PeerList_Reply) GetPeers() []*PeerList_Peer {
	if m != nil {
		return m.Peers
	}
	return nil
}

type PeerList_Peer struct {
	// id is the libp2p.PeerID.
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// routes are the list of active and known maddr.
	Routes []*PeerList_Route `protobuf:"bytes,2,rep,name=routes,proto3" json:"routes,omitempty"`
	// errors is a list of errors related to the peer.
	Errors []string `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
	// Features is a list of available features.
	Features []PeerList_Feature `protobuf:"varint,4,rep,packed,name=features,proto3,enum=berty.protocol.v1.PeerList_Feature" json:"features,omitempty"`
	// MinLatency is the minimum latency across all the peer routes.
	MinLatency int64 `protobuf:"varint,5,opt,name=min_latency,json=minLatency,proto3" json:"min_latency,omitempty"`
	// IsActive is true if at least one of the route is active.
	IsActive bool `protobuf:"varint,6,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// Direction is the aggregate of all the routes's direction.
	Direction            Direction `protobuf:"varint,7,opt,name=direction,proto3,enum=berty.protocol.v1.Direction" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *PeerList_Peer) Reset()         { *m = PeerList_Peer{} }
func (m *PeerList_Peer) String() string { return proto.CompactTextString(m) }
func (*PeerList_Peer) ProtoMessage()    {}
func (*PeerList_Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 2}
}

func (m *PeerList_Peer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList_Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList_Peer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList_Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList_Peer.Merge(m, src)
}

func (m *PeerList_Peer) XXX_Size() int {
	return m.Size()
}

func (m *PeerList_Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList_Peer proto.InternalMessageInfo

func (m *PeerList_Peer) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *PeerList_Peer) GetRoutes() []*PeerList_Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *PeerList_Peer) GetErrors() []string {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *PeerList_Peer) GetFeatures() []PeerList_Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *PeerList_Peer) GetMinLatency() int64 {
	if m != nil {
		return m.MinLatency
	}
	return 0
}

func (m *PeerList_Peer) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *PeerList_Peer) GetDirection() Direction {
	if m != nil {
		return m.Direction
	}
	return UnknownDir
}

type PeerList_Route struct {
	// IsActive indicates whether the address is currently used or just known.
	IsActive bool `protobuf:"varint,1,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// Address is the multiaddress via which we are connected with the peer.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Direction is which way the connection was established.
	Direction Direction `protobuf:"varint,3,opt,name=direction,proto3,enum=berty.protocol.v1.Direction" json:"direction,omitempty"`
	// Latency is the last known round trip time to the peer in ms.
	Latency int64 `protobuf:"varint,4,opt,name=latency,proto3" json:"latency,omitempty"`
	// Streams returns list of streams established with the peer.
	Streams              []*PeerList_Stream `protobuf:"bytes,5,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PeerList_Route) Reset()         { *m = PeerList_Route{} }
func (m *PeerList_Route) String() string { return proto.CompactTextString(m) }
func (*PeerList_Route) ProtoMessage()    {}
func (*PeerList_Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 3}
}

func (m *PeerList_Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList_Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList_Route.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList_Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList_Route.Merge(m, src)
}

func (m *PeerList_Route) XXX_Size() int {
	return m.Size()
}

func (m *PeerList_Route) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList_Route.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList_Route proto.InternalMessageInfo

func (m *PeerList_Route) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *PeerList_Route) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PeerList_Route) GetDirection() Direction {
	if m != nil {
		return m.Direction
	}
	return UnknownDir
}

func (m *PeerList_Route) GetLatency() int64 {
	if m != nil {
		return m.Latency
	}
	return 0
}

func (m *PeerList_Route) GetStreams() []*PeerList_Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type PeerList_Stream struct {
	// id is an identifier used to write protocol headers in streams.
	ID                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerList_Stream) Reset()         { *m = PeerList_Stream{} }
func (m *PeerList_Stream) String() string { return proto.CompactTextString(m) }
func (*PeerList_Stream) ProtoMessage()    {}
func (*PeerList_Stream) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{78, 4}
}

func (m *PeerList_Stream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PeerList_Stream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerList_Stream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PeerList_Stream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerList_Stream.Merge(m, src)
}

func (m *PeerList_Stream) XXX_Size() int {
	return m.Size()
}

func (m *PeerList_Stream) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerList_Stream.DiscardUnknown(m)
}

var xxx_messageInfo_PeerList_Stream proto.InternalMessageInfo

func (m *PeerList_Stream) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

type AttachmentPrepare struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentPrepare) Reset()         { *m = AttachmentPrepare{} }
func (m *AttachmentPrepare) String() string { return proto.CompactTextString(m) }
func (*AttachmentPrepare) ProtoMessage()    {}
func (*AttachmentPrepare) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{79}
}

func (m *AttachmentPrepare) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentPrepare) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentPrepare.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentPrepare) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentPrepare.Merge(m, src)
}

func (m *AttachmentPrepare) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentPrepare) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentPrepare.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentPrepare proto.InternalMessageInfo

type AttachmentPrepare_Request struct {
	// block is a plaintext block to append
	Block []byte `protobuf:"bytes,1,opt,name=block,proto3" json:"block,omitempty"`
	// disable_encryption tells the protocol to store the file as plain text
	DisableEncryption    bool     `protobuf:"varint,2,opt,name=disable_encryption,json=disableEncryption,proto3" json:"disable_encryption,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentPrepare_Request) Reset()         { *m = AttachmentPrepare_Request{} }
func (m *AttachmentPrepare_Request) String() string { return proto.CompactTextString(m) }
func (*AttachmentPrepare_Request) ProtoMessage()    {}
func (*AttachmentPrepare_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{79, 0}
}

func (m *AttachmentPrepare_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentPrepare_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentPrepare_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentPrepare_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentPrepare_Request.Merge(m, src)
}

func (m *AttachmentPrepare_Request) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentPrepare_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentPrepare_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentPrepare_Request proto.InternalMessageInfo

func (m *AttachmentPrepare_Request) GetBlock() []byte {
	if m != nil {
		return m.Block
	}
	return nil
}

func (m *AttachmentPrepare_Request) GetDisableEncryption() bool {
	if m != nil {
		return m.DisableEncryption
	}
	return false
}

type AttachmentPrepare_Reply struct {
	// attachment_cid is the cid of the (encrypted) file
	AttachmentCID        []byte   `protobuf:"bytes,1,opt,name=attachment_cid,json=attachmentCid,proto3" json:"attachment_cid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentPrepare_Reply) Reset()         { *m = AttachmentPrepare_Reply{} }
func (m *AttachmentPrepare_Reply) String() string { return proto.CompactTextString(m) }
func (*AttachmentPrepare_Reply) ProtoMessage()    {}
func (*AttachmentPrepare_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{79, 1}
}

func (m *AttachmentPrepare_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentPrepare_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentPrepare_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentPrepare_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentPrepare_Reply.Merge(m, src)
}

func (m *AttachmentPrepare_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentPrepare_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentPrepare_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentPrepare_Reply proto.InternalMessageInfo

func (m *AttachmentPrepare_Reply) GetAttachmentCID() []byte {
	if m != nil {
		return m.AttachmentCID
	}
	return nil
}

type AttachmentRetrieve struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentRetrieve) Reset()         { *m = AttachmentRetrieve{} }
func (m *AttachmentRetrieve) String() string { return proto.CompactTextString(m) }
func (*AttachmentRetrieve) ProtoMessage()    {}
func (*AttachmentRetrieve) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{80}
}

func (m *AttachmentRetrieve) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentRetrieve) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentRetrieve.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentRetrieve) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentRetrieve.Merge(m, src)
}

func (m *AttachmentRetrieve) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentRetrieve) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentRetrieve.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentRetrieve proto.InternalMessageInfo

type AttachmentRetrieve_Request struct {
	// attachment_cid is the cid of the (encrypted) file
	AttachmentCID        []byte   `protobuf:"bytes,1,opt,name=attachment_cid,json=attachmentCid,proto3" json:"attachment_cid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentRetrieve_Request) Reset()         { *m = AttachmentRetrieve_Request{} }
func (m *AttachmentRetrieve_Request) String() string { return proto.CompactTextString(m) }
func (*AttachmentRetrieve_Request) ProtoMessage()    {}
func (*AttachmentRetrieve_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{80, 0}
}

func (m *AttachmentRetrieve_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentRetrieve_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentRetrieve_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentRetrieve_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentRetrieve_Request.Merge(m, src)
}

func (m *AttachmentRetrieve_Request) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentRetrieve_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentRetrieve_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentRetrieve_Request proto.InternalMessageInfo

func (m *AttachmentRetrieve_Request) GetAttachmentCID() []byte {
	if m != nil {
		return m.AttachmentCID
	}
	return nil
}

type AttachmentRetrieve_Reply struct {
	// block is a plaintext block to append
	Block                []byte   `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachmentRetrieve_Reply) Reset()         { *m = AttachmentRetrieve_Reply{} }
func (m *AttachmentRetrieve_Reply) String() string { return proto.CompactTextString(m) }
func (*AttachmentRetrieve_Reply) ProtoMessage()    {}
func (*AttachmentRetrieve_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{80, 1}
}

func (m *AttachmentRetrieve_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *AttachmentRetrieve_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachmentRetrieve_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *AttachmentRetrieve_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachmentRetrieve_Reply.Merge(m, src)
}

func (m *AttachmentRetrieve_Reply) XXX_Size() int {
	return m.Size()
}

func (m *AttachmentRetrieve_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachmentRetrieve_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_AttachmentRetrieve_Reply proto.InternalMessageInfo

func (m *AttachmentRetrieve_Reply) GetBlock() []byte {
	if m != nil {
		return m.Block
	}
	return nil
}

// Progress define a generic object that can be used to display a progress bar for long-running actions.
type Progress struct {
	State                string   `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	Doing                string   `protobuf:"bytes,2,opt,name=doing,proto3" json:"doing,omitempty"`
	Progress             float32  `protobuf:"fixed32,3,opt,name=progress,proto3" json:"progress,omitempty"`
	Completed            uint64   `protobuf:"varint,4,opt,name=completed,proto3" json:"completed,omitempty"`
	Total                uint64   `protobuf:"varint,5,opt,name=total,proto3" json:"total,omitempty"`
	Delay                uint64   `protobuf:"varint,6,opt,name=delay,proto3" json:"delay,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Progress) Reset()         { *m = Progress{} }
func (m *Progress) String() string { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()    {}
func (*Progress) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{81}
}

func (m *Progress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *Progress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Progress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *Progress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Progress.Merge(m, src)
}

func (m *Progress) XXX_Size() int {
	return m.Size()
}

func (m *Progress) XXX_DiscardUnknown() {
	xxx_messageInfo_Progress.DiscardUnknown(m)
}

var xxx_messageInfo_Progress proto.InternalMessageInfo

func (m *Progress) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *Progress) GetDoing() string {
	if m != nil {
		return m.Doing
	}
	return ""
}

func (m *Progress) GetProgress() float32 {
	if m != nil {
		return m.Progress
	}
	return 0
}

func (m *Progress) GetCompleted() uint64 {
	if m != nil {
		return m.Completed
	}
	return 0
}

func (m *Progress) GetTotal() uint64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *Progress) GetDelay() uint64 {
	if m != nil {
		return m.Delay
	}
	return 0
}

type MemberWithDevices struct {
	MemberPK             []byte   `protobuf:"bytes,1,opt,name=member_pk,json=memberPk,proto3" json:"member_pk,omitempty"`
	DevicePKs            [][]byte `protobuf:"bytes,2,rep,name=devices_pks,json=devicesPks,proto3" json:"devices_pks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MemberWithDevices) Reset()         { *m = MemberWithDevices{} }
func (m *MemberWithDevices) String() string { return proto.CompactTextString(m) }
func (*MemberWithDevices) ProtoMessage()    {}
func (*MemberWithDevices) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{82}
}

func (m *MemberWithDevices) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *MemberWithDevices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemberWithDevices.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *MemberWithDevices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemberWithDevices.Merge(m, src)
}

func (m *MemberWithDevices) XXX_Size() int {
	return m.Size()
}

func (m *MemberWithDevices) XXX_DiscardUnknown() {
	xxx_messageInfo_MemberWithDevices.DiscardUnknown(m)
}

var xxx_messageInfo_MemberWithDevices proto.InternalMessageInfo

func (m *MemberWithDevices) GetMemberPK() []byte {
	if m != nil {
		return m.MemberPK
	}
	return nil
}

func (m *MemberWithDevices) GetDevicePKs() [][]byte {
	if m != nil {
		return m.DevicePKs
	}
	return nil
}

type OutOfStoreMessage struct {
	CID                  []byte   `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	DevicePK             []byte   `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	Counter              uint64   `protobuf:"fixed64,3,opt,name=counter,proto3" json:"counter,omitempty"`
	Sig                  []byte   `protobuf:"bytes,4,opt,name=sig,proto3" json:"sig,omitempty"`
	Flags                uint32   `protobuf:"fixed32,5,opt,name=flags,proto3" json:"flags,omitempty"`
	EncryptedPayload     []byte   `protobuf:"bytes,6,opt,name=encrypted_payload,json=encryptedPayload,proto3" json:"encrypted_payload,omitempty"`
	Nonce                []byte   `protobuf:"bytes,7,opt,name=nonce,proto3" json:"nonce,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutOfStoreMessage) Reset()         { *m = OutOfStoreMessage{} }
func (m *OutOfStoreMessage) String() string { return proto.CompactTextString(m) }
func (*OutOfStoreMessage) ProtoMessage()    {}
func (*OutOfStoreMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{83}
}

func (m *OutOfStoreMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *OutOfStoreMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutOfStoreMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *OutOfStoreMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutOfStoreMessage.Merge(m, src)
}

func (m *OutOfStoreMessage) XXX_Size() int {
	return m.Size()
}

func (m *OutOfStoreMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_OutOfStoreMessage.DiscardUnknown(m)
}

var xxx_messageInfo_OutOfStoreMessage proto.InternalMessageInfo

func (m *OutOfStoreMessage) GetCID() []byte {
	if m != nil {
		return m.CID
	}
	return nil
}

func (m *OutOfStoreMessage) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

func (m *OutOfStoreMessage) GetCounter() uint64 {
	if m != nil {
		return m.Counter
	}
	return 0
}

func (m *OutOfStoreMessage) GetSig() []byte {
	if m != nil {
		return m.Sig
	}
	return nil
}

func (m *OutOfStoreMessage) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OutOfStoreMessage) GetEncryptedPayload() []byte {
	if m != nil {
		return m.EncryptedPayload
	}
	return nil
}

func (m *OutOfStoreMessage) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

type PushServiceReceiver struct {
	// token_type is the type of the token used, it allows us to act as a proxy to the appropriate push server
	TokenType pushtypes.PushServiceTokenType `protobuf:"varint,1,opt,name=token_type,json=tokenType,proto3,enum=berty.push.v1.PushServiceTokenType" json:"token_type,omitempty"`
	// bundle_id is the app identifier
	BundleID string `protobuf:"bytes,2,opt,name=bundle_id,json=bundleId,proto3" json:"bundle_id,omitempty"`
	// token is the device identifier used
	Token []byte `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
	// recipient_public_key is the public key which will be used to encrypt the payload
	RecipientPublicKey   []byte   `protobuf:"bytes,4,opt,name=recipient_public_key,json=recipientPublicKey,proto3" json:"recipient_public_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushServiceReceiver) Reset()         { *m = PushServiceReceiver{} }
func (m *PushServiceReceiver) String() string { return proto.CompactTextString(m) }
func (*PushServiceReceiver) ProtoMessage()    {}
func (*PushServiceReceiver) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{84}
}

func (m *PushServiceReceiver) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushServiceReceiver) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushServiceReceiver.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushServiceReceiver) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushServiceReceiver.Merge(m, src)
}

func (m *PushServiceReceiver) XXX_Size() int {
	return m.Size()
}

func (m *PushServiceReceiver) XXX_DiscardUnknown() {
	xxx_messageInfo_PushServiceReceiver.DiscardUnknown(m)
}

var xxx_messageInfo_PushServiceReceiver proto.InternalMessageInfo

func (m *PushServiceReceiver) GetTokenType() pushtypes.PushServiceTokenType {
	if m != nil {
		return m.TokenType
	}
	return pushtypes.PushServiceTokenType_PushTokenUndefined
}

func (m *PushServiceReceiver) GetBundleID() string {
	if m != nil {
		return m.BundleID
	}
	return ""
}

func (m *PushServiceReceiver) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *PushServiceReceiver) GetRecipientPublicKey() []byte {
	if m != nil {
		return m.RecipientPublicKey
	}
	return nil
}

type PushServer struct {
	ServerKey            []byte   `protobuf:"bytes,1,opt,name=server_key,json=serverKey,proto3" json:"server_key,omitempty"`
	ServiceAddr          string   `protobuf:"bytes,2,opt,name=service_addr,json=serviceAddr,proto3" json:"service_addr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushServer) Reset()         { *m = PushServer{} }
func (m *PushServer) String() string { return proto.CompactTextString(m) }
func (*PushServer) ProtoMessage()    {}
func (*PushServer) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{85}
}

func (m *PushServer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushServer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushServer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushServer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushServer.Merge(m, src)
}

func (m *PushServer) XXX_Size() int {
	return m.Size()
}

func (m *PushServer) XXX_DiscardUnknown() {
	xxx_messageInfo_PushServer.DiscardUnknown(m)
}

var xxx_messageInfo_PushServer proto.InternalMessageInfo

func (m *PushServer) GetServerKey() []byte {
	if m != nil {
		return m.ServerKey
	}
	return nil
}

func (m *PushServer) GetServiceAddr() string {
	if m != nil {
		return m.ServiceAddr
	}
	return ""
}

type PushDeviceTokenRegistered struct {
	Token *PushServiceReceiver `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// device_pk is the public key of the device sending the message
	DevicePK             []byte   `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushDeviceTokenRegistered) Reset()         { *m = PushDeviceTokenRegistered{} }
func (m *PushDeviceTokenRegistered) String() string { return proto.CompactTextString(m) }
func (*PushDeviceTokenRegistered) ProtoMessage()    {}
func (*PushDeviceTokenRegistered) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{86}
}

func (m *PushDeviceTokenRegistered) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushDeviceTokenRegistered) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushDeviceTokenRegistered.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushDeviceTokenRegistered) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushDeviceTokenRegistered.Merge(m, src)
}

func (m *PushDeviceTokenRegistered) XXX_Size() int {
	return m.Size()
}

func (m *PushDeviceTokenRegistered) XXX_DiscardUnknown() {
	xxx_messageInfo_PushDeviceTokenRegistered.DiscardUnknown(m)
}

var xxx_messageInfo_PushDeviceTokenRegistered proto.InternalMessageInfo

func (m *PushDeviceTokenRegistered) GetToken() *PushServiceReceiver {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *PushDeviceTokenRegistered) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

type PushDeviceServerRegistered struct {
	Server *PushServer `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	// device_pk is the public key of the device sending the message
	DevicePK             []byte   `protobuf:"bytes,2,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushDeviceServerRegistered) Reset()         { *m = PushDeviceServerRegistered{} }
func (m *PushDeviceServerRegistered) String() string { return proto.CompactTextString(m) }
func (*PushDeviceServerRegistered) ProtoMessage()    {}
func (*PushDeviceServerRegistered) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{87}
}

func (m *PushDeviceServerRegistered) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushDeviceServerRegistered) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushDeviceServerRegistered.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushDeviceServerRegistered) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushDeviceServerRegistered.Merge(m, src)
}

func (m *PushDeviceServerRegistered) XXX_Size() int {
	return m.Size()
}

func (m *PushDeviceServerRegistered) XXX_DiscardUnknown() {
	xxx_messageInfo_PushDeviceServerRegistered.DiscardUnknown(m)
}

var xxx_messageInfo_PushDeviceServerRegistered proto.InternalMessageInfo

func (m *PushDeviceServerRegistered) GetServer() *PushServer {
	if m != nil {
		return m.Server
	}
	return nil
}

func (m *PushDeviceServerRegistered) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

type PushMemberTokenUpdate struct {
	Server *PushServer `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	Token  []byte      `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
	// device_pk is the public key of the device sending the message
	DevicePK             []byte   `protobuf:"bytes,3,opt,name=device_pk,json=devicePk,proto3" json:"device_pk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushMemberTokenUpdate) Reset()         { *m = PushMemberTokenUpdate{} }
func (m *PushMemberTokenUpdate) String() string { return proto.CompactTextString(m) }
func (*PushMemberTokenUpdate) ProtoMessage()    {}
func (*PushMemberTokenUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{88}
}

func (m *PushMemberTokenUpdate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushMemberTokenUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushMemberTokenUpdate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushMemberTokenUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushMemberTokenUpdate.Merge(m, src)
}

func (m *PushMemberTokenUpdate) XXX_Size() int {
	return m.Size()
}

func (m *PushMemberTokenUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_PushMemberTokenUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_PushMemberTokenUpdate proto.InternalMessageInfo

func (m *PushMemberTokenUpdate) GetServer() *PushServer {
	if m != nil {
		return m.Server
	}
	return nil
}

func (m *PushMemberTokenUpdate) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *PushMemberTokenUpdate) GetDevicePK() []byte {
	if m != nil {
		return m.DevicePK
	}
	return nil
}

type PushReceive struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushReceive) Reset()         { *m = PushReceive{} }
func (m *PushReceive) String() string { return proto.CompactTextString(m) }
func (*PushReceive) ProtoMessage()    {}
func (*PushReceive) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{89}
}

func (m *PushReceive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushReceive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushReceive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushReceive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushReceive.Merge(m, src)
}

func (m *PushReceive) XXX_Size() int {
	return m.Size()
}

func (m *PushReceive) XXX_DiscardUnknown() {
	xxx_messageInfo_PushReceive.DiscardUnknown(m)
}

var xxx_messageInfo_PushReceive proto.InternalMessageInfo

type PushReceive_Request struct {
	Payload              []byte   `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushReceive_Request) Reset()         { *m = PushReceive_Request{} }
func (m *PushReceive_Request) String() string { return proto.CompactTextString(m) }
func (*PushReceive_Request) ProtoMessage()    {}
func (*PushReceive_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{89, 0}
}

func (m *PushReceive_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushReceive_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushReceive_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushReceive_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushReceive_Request.Merge(m, src)
}

func (m *PushReceive_Request) XXX_Size() int {
	return m.Size()
}

func (m *PushReceive_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PushReceive_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PushReceive_Request proto.InternalMessageInfo

func (m *PushReceive_Request) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

type PushReceive_Reply struct {
	Message              *OutOfStoreMessage `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Cleartext            []byte             `protobuf:"bytes,2,opt,name=cleartext,proto3" json:"cleartext,omitempty"`
	GroupPublicKey       []byte             `protobuf:"bytes,3,opt,name=group_public_key,json=groupPublicKey,proto3" json:"group_public_key,omitempty"`
	AlreadyReceived      bool               `protobuf:"varint,4,opt,name=already_received,json=alreadyReceived,proto3" json:"already_received,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PushReceive_Reply) Reset()         { *m = PushReceive_Reply{} }
func (m *PushReceive_Reply) String() string { return proto.CompactTextString(m) }
func (*PushReceive_Reply) ProtoMessage()    {}
func (*PushReceive_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{89, 1}
}

func (m *PushReceive_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushReceive_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushReceive_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushReceive_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushReceive_Reply.Merge(m, src)
}

func (m *PushReceive_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PushReceive_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PushReceive_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PushReceive_Reply proto.InternalMessageInfo

func (m *PushReceive_Reply) GetMessage() *OutOfStoreMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *PushReceive_Reply) GetCleartext() []byte {
	if m != nil {
		return m.Cleartext
	}
	return nil
}

func (m *PushReceive_Reply) GetGroupPublicKey() []byte {
	if m != nil {
		return m.GroupPublicKey
	}
	return nil
}

func (m *PushReceive_Reply) GetAlreadyReceived() bool {
	if m != nil {
		return m.AlreadyReceived
	}
	return false
}

type PushSend struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushSend) Reset()         { *m = PushSend{} }
func (m *PushSend) String() string { return proto.CompactTextString(m) }
func (*PushSend) ProtoMessage()    {}
func (*PushSend) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{90}
}

func (m *PushSend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSend.Merge(m, src)
}

func (m *PushSend) XXX_Size() int {
	return m.Size()
}

func (m *PushSend) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSend.DiscardUnknown(m)
}

var xxx_messageInfo_PushSend proto.InternalMessageInfo

type PushSend_Request struct {
	CID                  []byte               `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	GroupPublicKey       []byte               `protobuf:"bytes,2,opt,name=group_public_key,json=groupPublicKey,proto3" json:"group_public_key,omitempty"`
	GroupMembers         []*MemberWithDevices `protobuf:"bytes,3,rep,name=group_members,json=groupMembers,proto3" json:"group_members,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PushSend_Request) Reset()         { *m = PushSend_Request{} }
func (m *PushSend_Request) String() string { return proto.CompactTextString(m) }
func (*PushSend_Request) ProtoMessage()    {}
func (*PushSend_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{90, 0}
}

func (m *PushSend_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSend_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSend_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSend_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSend_Request.Merge(m, src)
}

func (m *PushSend_Request) XXX_Size() int {
	return m.Size()
}

func (m *PushSend_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSend_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PushSend_Request proto.InternalMessageInfo

func (m *PushSend_Request) GetCID() []byte {
	if m != nil {
		return m.CID
	}
	return nil
}

func (m *PushSend_Request) GetGroupPublicKey() []byte {
	if m != nil {
		return m.GroupPublicKey
	}
	return nil
}

func (m *PushSend_Request) GetGroupMembers() []*MemberWithDevices {
	if m != nil {
		return m.GroupMembers
	}
	return nil
}

type PushSend_Reply struct {
	GroupMembers         []*MemberWithDevices `protobuf:"bytes,1,rep,name=group_members,json=groupMembers,proto3" json:"group_members,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PushSend_Reply) Reset()         { *m = PushSend_Reply{} }
func (m *PushSend_Reply) String() string { return proto.CompactTextString(m) }
func (*PushSend_Reply) ProtoMessage()    {}
func (*PushSend_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{90, 1}
}

func (m *PushSend_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSend_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSend_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSend_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSend_Reply.Merge(m, src)
}

func (m *PushSend_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PushSend_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSend_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PushSend_Reply proto.InternalMessageInfo

func (m *PushSend_Reply) GetGroupMembers() []*MemberWithDevices {
	if m != nil {
		return m.GroupMembers
	}
	return nil
}

type PushShareToken struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushShareToken) Reset()         { *m = PushShareToken{} }
func (m *PushShareToken) String() string { return proto.CompactTextString(m) }
func (*PushShareToken) ProtoMessage()    {}
func (*PushShareToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{91}
}

func (m *PushShareToken) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushShareToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushShareToken.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushShareToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushShareToken.Merge(m, src)
}

func (m *PushShareToken) XXX_Size() int {
	return m.Size()
}

func (m *PushShareToken) XXX_DiscardUnknown() {
	xxx_messageInfo_PushShareToken.DiscardUnknown(m)
}

var xxx_messageInfo_PushShareToken proto.InternalMessageInfo

type PushShareToken_Request struct {
	GroupPK              []byte               `protobuf:"bytes,1,opt,name=group_pk,json=groupPk,proto3" json:"group_pk,omitempty"`
	Server               *PushServer          `protobuf:"bytes,2,opt,name=server,proto3" json:"server,omitempty"`
	Receiver             *PushServiceReceiver `protobuf:"bytes,3,opt,name=receiver,proto3" json:"receiver,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PushShareToken_Request) Reset()         { *m = PushShareToken_Request{} }
func (m *PushShareToken_Request) String() string { return proto.CompactTextString(m) }
func (*PushShareToken_Request) ProtoMessage()    {}
func (*PushShareToken_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{91, 0}
}

func (m *PushShareToken_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushShareToken_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushShareToken_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushShareToken_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushShareToken_Request.Merge(m, src)
}

func (m *PushShareToken_Request) XXX_Size() int {
	return m.Size()
}

func (m *PushShareToken_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PushShareToken_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PushShareToken_Request proto.InternalMessageInfo

func (m *PushShareToken_Request) GetGroupPK() []byte {
	if m != nil {
		return m.GroupPK
	}
	return nil
}

func (m *PushShareToken_Request) GetServer() *PushServer {
	if m != nil {
		return m.Server
	}
	return nil
}

func (m *PushShareToken_Request) GetReceiver() *PushServiceReceiver {
	if m != nil {
		return m.Receiver
	}
	return nil
}

type PushShareToken_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushShareToken_Reply) Reset()         { *m = PushShareToken_Reply{} }
func (m *PushShareToken_Reply) String() string { return proto.CompactTextString(m) }
func (*PushShareToken_Reply) ProtoMessage()    {}
func (*PushShareToken_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{91, 1}
}

func (m *PushShareToken_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushShareToken_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushShareToken_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushShareToken_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushShareToken_Reply.Merge(m, src)
}

func (m *PushShareToken_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PushShareToken_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PushShareToken_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PushShareToken_Reply proto.InternalMessageInfo

type PushSetDeviceToken struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushSetDeviceToken) Reset()         { *m = PushSetDeviceToken{} }
func (m *PushSetDeviceToken) String() string { return proto.CompactTextString(m) }
func (*PushSetDeviceToken) ProtoMessage()    {}
func (*PushSetDeviceToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{92}
}

func (m *PushSetDeviceToken) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetDeviceToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetDeviceToken.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetDeviceToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetDeviceToken.Merge(m, src)
}

func (m *PushSetDeviceToken) XXX_Size() int {
	return m.Size()
}

func (m *PushSetDeviceToken) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetDeviceToken.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetDeviceToken proto.InternalMessageInfo

type PushSetDeviceToken_Request struct {
	Receiver             *PushServiceReceiver `protobuf:"bytes,1,opt,name=receiver,proto3" json:"receiver,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PushSetDeviceToken_Request) Reset()         { *m = PushSetDeviceToken_Request{} }
func (m *PushSetDeviceToken_Request) String() string { return proto.CompactTextString(m) }
func (*PushSetDeviceToken_Request) ProtoMessage()    {}
func (*PushSetDeviceToken_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{92, 0}
}

func (m *PushSetDeviceToken_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetDeviceToken_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetDeviceToken_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetDeviceToken_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetDeviceToken_Request.Merge(m, src)
}

func (m *PushSetDeviceToken_Request) XXX_Size() int {
	return m.Size()
}

func (m *PushSetDeviceToken_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetDeviceToken_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetDeviceToken_Request proto.InternalMessageInfo

func (m *PushSetDeviceToken_Request) GetReceiver() *PushServiceReceiver {
	if m != nil {
		return m.Receiver
	}
	return nil
}

type PushSetDeviceToken_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushSetDeviceToken_Reply) Reset()         { *m = PushSetDeviceToken_Reply{} }
func (m *PushSetDeviceToken_Reply) String() string { return proto.CompactTextString(m) }
func (*PushSetDeviceToken_Reply) ProtoMessage()    {}
func (*PushSetDeviceToken_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{92, 1}
}

func (m *PushSetDeviceToken_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetDeviceToken_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetDeviceToken_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetDeviceToken_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetDeviceToken_Reply.Merge(m, src)
}

func (m *PushSetDeviceToken_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PushSetDeviceToken_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetDeviceToken_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetDeviceToken_Reply proto.InternalMessageInfo

type PushSetServer struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushSetServer) Reset()         { *m = PushSetServer{} }
func (m *PushSetServer) String() string { return proto.CompactTextString(m) }
func (*PushSetServer) ProtoMessage()    {}
func (*PushSetServer) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{93}
}

func (m *PushSetServer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetServer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetServer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetServer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetServer.Merge(m, src)
}

func (m *PushSetServer) XXX_Size() int {
	return m.Size()
}

func (m *PushSetServer) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetServer.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetServer proto.InternalMessageInfo

type PushSetServer_Request struct {
	Server               *PushServer `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PushSetServer_Request) Reset()         { *m = PushSetServer_Request{} }
func (m *PushSetServer_Request) String() string { return proto.CompactTextString(m) }
func (*PushSetServer_Request) ProtoMessage()    {}
func (*PushSetServer_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{93, 0}
}

func (m *PushSetServer_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetServer_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetServer_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetServer_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetServer_Request.Merge(m, src)
}

func (m *PushSetServer_Request) XXX_Size() int {
	return m.Size()
}

func (m *PushSetServer_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetServer_Request.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetServer_Request proto.InternalMessageInfo

func (m *PushSetServer_Request) GetServer() *PushServer {
	if m != nil {
		return m.Server
	}
	return nil
}

type PushSetServer_Reply struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushSetServer_Reply) Reset()         { *m = PushSetServer_Reply{} }
func (m *PushSetServer_Reply) String() string { return proto.CompactTextString(m) }
func (*PushSetServer_Reply) ProtoMessage()    {}
func (*PushSetServer_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{93, 1}
}

func (m *PushSetServer_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *PushSetServer_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushSetServer_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *PushSetServer_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushSetServer_Reply.Merge(m, src)
}

func (m *PushSetServer_Reply) XXX_Size() int {
	return m.Size()
}

func (m *PushSetServer_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_PushSetServer_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_PushSetServer_Reply proto.InternalMessageInfo

type FirstLastCounters struct {
	First                uint64   `protobuf:"varint,1,opt,name=first,proto3" json:"first,omitempty"`
	Last                 uint64   `protobuf:"varint,2,opt,name=last,proto3" json:"last,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FirstLastCounters) Reset()         { *m = FirstLastCounters{} }
func (m *FirstLastCounters) String() string { return proto.CompactTextString(m) }
func (*FirstLastCounters) ProtoMessage()    {}
func (*FirstLastCounters) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{94}
}

func (m *FirstLastCounters) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *FirstLastCounters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FirstLastCounters.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *FirstLastCounters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FirstLastCounters.Merge(m, src)
}

func (m *FirstLastCounters) XXX_Size() int {
	return m.Size()
}

func (m *FirstLastCounters) XXX_DiscardUnknown() {
	xxx_messageInfo_FirstLastCounters.DiscardUnknown(m)
}

var xxx_messageInfo_FirstLastCounters proto.InternalMessageInfo

func (m *FirstLastCounters) GetFirst() uint64 {
	if m != nil {
		return m.First
	}
	return 0
}

func (m *FirstLastCounters) GetLast() uint64 {
	if m != nil {
		return m.Last
	}
	return 0
}

// OrbitDBMessageHeads is the payload sent on orbitdb to share peer's heads
type OrbitDBMessageHeads struct {
	// sealed box should contain encrypted Box
	SealedBox []byte `protobuf:"bytes,2,opt,name=sealed_box,json=sealedBox,proto3" json:"sealed_box,omitempty"`
	// current topic used
	RawRotation          []byte   `protobuf:"bytes,3,opt,name=raw_rotation,json=rawRotation,proto3" json:"raw_rotation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrbitDBMessageHeads) Reset()         { *m = OrbitDBMessageHeads{} }
func (m *OrbitDBMessageHeads) String() string { return proto.CompactTextString(m) }
func (*OrbitDBMessageHeads) ProtoMessage()    {}
func (*OrbitDBMessageHeads) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{95}
}

func (m *OrbitDBMessageHeads) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *OrbitDBMessageHeads) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrbitDBMessageHeads.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *OrbitDBMessageHeads) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrbitDBMessageHeads.Merge(m, src)
}

func (m *OrbitDBMessageHeads) XXX_Size() int {
	return m.Size()
}

func (m *OrbitDBMessageHeads) XXX_DiscardUnknown() {
	xxx_messageInfo_OrbitDBMessageHeads.DiscardUnknown(m)
}

var xxx_messageInfo_OrbitDBMessageHeads proto.InternalMessageInfo

func (m *OrbitDBMessageHeads) GetSealedBox() []byte {
	if m != nil {
		return m.SealedBox
	}
	return nil
}

func (m *OrbitDBMessageHeads) GetRawRotation() []byte {
	if m != nil {
		return m.RawRotation
	}
	return nil
}

type OrbitDBMessageHeads_Box struct {
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	Heads                []byte   `protobuf:"bytes,2,opt,name=heads,proto3" json:"heads,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrbitDBMessageHeads_Box) Reset()         { *m = OrbitDBMessageHeads_Box{} }
func (m *OrbitDBMessageHeads_Box) String() string { return proto.CompactTextString(m) }
func (*OrbitDBMessageHeads_Box) ProtoMessage()    {}
func (*OrbitDBMessageHeads_Box) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{95, 0}
}

func (m *OrbitDBMessageHeads_Box) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *OrbitDBMessageHeads_Box) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrbitDBMessageHeads_Box.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *OrbitDBMessageHeads_Box) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrbitDBMessageHeads_Box.Merge(m, src)
}

func (m *OrbitDBMessageHeads_Box) XXX_Size() int {
	return m.Size()
}

func (m *OrbitDBMessageHeads_Box) XXX_DiscardUnknown() {
	xxx_messageInfo_OrbitDBMessageHeads_Box.DiscardUnknown(m)
}

var xxx_messageInfo_OrbitDBMessageHeads_Box proto.InternalMessageInfo

func (m *OrbitDBMessageHeads_Box) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *OrbitDBMessageHeads_Box) GetHeads() []byte {
	if m != nil {
		return m.Heads
	}
	return nil
}

type RefreshContactRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshContactRequest) Reset()         { *m = RefreshContactRequest{} }
func (m *RefreshContactRequest) String() string { return proto.CompactTextString(m) }
func (*RefreshContactRequest) ProtoMessage()    {}
func (*RefreshContactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{96}
}

func (m *RefreshContactRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *RefreshContactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshContactRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *RefreshContactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshContactRequest.Merge(m, src)
}

func (m *RefreshContactRequest) XXX_Size() int {
	return m.Size()
}

func (m *RefreshContactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshContactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshContactRequest proto.InternalMessageInfo

type RefreshContactRequest_Peer struct {
	// id is the libp2p.PeerID.
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// list of peers multiaddrs.
	Addrs                []string `protobuf:"bytes,2,rep,name=addrs,proto3" json:"addrs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshContactRequest_Peer) Reset()         { *m = RefreshContactRequest_Peer{} }
func (m *RefreshContactRequest_Peer) String() string { return proto.CompactTextString(m) }
func (*RefreshContactRequest_Peer) ProtoMessage()    {}
func (*RefreshContactRequest_Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{96, 0}
}

func (m *RefreshContactRequest_Peer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *RefreshContactRequest_Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshContactRequest_Peer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *RefreshContactRequest_Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshContactRequest_Peer.Merge(m, src)
}

func (m *RefreshContactRequest_Peer) XXX_Size() int {
	return m.Size()
}

func (m *RefreshContactRequest_Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshContactRequest_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshContactRequest_Peer proto.InternalMessageInfo

func (m *RefreshContactRequest_Peer) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *RefreshContactRequest_Peer) GetAddrs() []string {
	if m != nil {
		return m.Addrs
	}
	return nil
}

type RefreshContactRequest_Request struct {
	ContactPK []byte `protobuf:"bytes,1,opt,name=contact_pk,json=contactPk,proto3" json:"contact_pk,omitempty"`
	// timeout in second
	Timeout              int64    `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshContactRequest_Request) Reset()         { *m = RefreshContactRequest_Request{} }
func (m *RefreshContactRequest_Request) String() string { return proto.CompactTextString(m) }
func (*RefreshContactRequest_Request) ProtoMessage()    {}
func (*RefreshContactRequest_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{96, 1}
}

func (m *RefreshContactRequest_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *RefreshContactRequest_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshContactRequest_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *RefreshContactRequest_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshContactRequest_Request.Merge(m, src)
}

func (m *RefreshContactRequest_Request) XXX_Size() int {
	return m.Size()
}

func (m *RefreshContactRequest_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshContactRequest_Request.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshContactRequest_Request proto.InternalMessageInfo

func (m *RefreshContactRequest_Request) GetContactPK() []byte {
	if m != nil {
		return m.ContactPK
	}
	return nil
}

func (m *RefreshContactRequest_Request) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

type RefreshContactRequest_Reply struct {
	// peers found and successfully connected.
	PeersFound           []*RefreshContactRequest_Peer `protobuf:"bytes,1,rep,name=peers_found,json=peersFound,proto3" json:"peers_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *RefreshContactRequest_Reply) Reset()         { *m = RefreshContactRequest_Reply{} }
func (m *RefreshContactRequest_Reply) String() string { return proto.CompactTextString(m) }
func (*RefreshContactRequest_Reply) ProtoMessage()    {}
func (*RefreshContactRequest_Reply) Descriptor() ([]byte, []int) {
	return fileDescriptor_8aa93e54ccb19003, []int{96, 2}
}

func (m *RefreshContactRequest_Reply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}

func (m *RefreshContactRequest_Reply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshContactRequest_Reply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}

func (m *RefreshContactRequest_Reply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshContactRequest_Reply.Merge(m, src)
}

func (m *RefreshContactRequest_Reply) XXX_Size() int {
	return m.Size()
}

func (m *RefreshContactRequest_Reply) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshContactRequest_Reply.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshContactRequest_Reply proto.InternalMessageInfo

func (m *RefreshContactRequest_Reply) GetPeersFound() []*RefreshContactRequest_Peer {
	if m != nil {
		return m.PeersFound
	}
	return nil
}

func init() {
	proto.RegisterEnum("berty.protocol.v1.GroupType", GroupType_name, GroupType_value)
	proto.RegisterEnum("berty.protocol.v1.EventType", EventType_name, EventType_value)
	proto.RegisterEnum("berty.protocol.v1.DebugInspectGroupLogType", DebugInspectGroupLogType_name, DebugInspectGroupLogType_value)
	proto.RegisterEnum("berty.protocol.v1.ContactState", ContactState_name, ContactState_value)
	proto.RegisterEnum("berty.protocol.v1.Direction", Direction_name, Direction_value)
	proto.RegisterEnum("berty.protocol.v1.InstanceGetConfiguration_SettingState", InstanceGetConfiguration_SettingState_name, InstanceGetConfiguration_SettingState_value)
	proto.RegisterEnum("berty.protocol.v1.MonitorGroup_TypeEventMonitor", MonitorGroup_TypeEventMonitor_name, MonitorGroup_TypeEventMonitor_value)
	proto.RegisterEnum("berty.protocol.v1.PeerList_Feature", PeerList_Feature_name, PeerList_Feature_value)
	proto.RegisterType((*Account)(nil), "berty.protocol.v1.Account")
	proto.RegisterType((*Group)(nil), "berty.protocol.v1.Group")
	proto.RegisterType((*GroupHeadsExport)(nil), "berty.protocol.v1.GroupHeadsExport")
	proto.RegisterType((*GroupMetadata)(nil), "berty.protocol.v1.GroupMetadata")
	proto.RegisterType((*GroupEnvelope)(nil), "berty.protocol.v1.GroupEnvelope")
	proto.RegisterType((*MessageHeaders)(nil), "berty.protocol.v1.MessageHeaders")
	proto.RegisterMapType((map[string]string)(nil), "berty.protocol.v1.MessageHeaders.MetadataEntry")
	proto.RegisterType((*ProtocolMetadata)(nil), "berty.protocol.v1.ProtocolMetadata")
	proto.RegisterType((*EncryptedMessage)(nil), "berty.protocol.v1.EncryptedMessage")
	proto.RegisterType((*MessageEnvelope)(nil), "berty.protocol.v1.MessageEnvelope")
	proto.RegisterType((*EventContext)(nil), "berty.protocol.v1.EventContext")
	proto.RegisterType((*AppMetadata)(nil), "berty.protocol.v1.AppMetadata")
	proto.RegisterType((*ContactAddAliasKey)(nil), "berty.protocol.v1.ContactAddAliasKey")
	proto.RegisterType((*GroupAddMemberDevice)(nil), "berty.protocol.v1.GroupAddMemberDevice")
	proto.RegisterType((*DeviceSecret)(nil), "berty.protocol.v1.DeviceSecret")
	proto.RegisterType((*GroupAddDeviceSecret)(nil), "berty.protocol.v1.GroupAddDeviceSecret")
	proto.RegisterType((*MultiMemberGroupAddAliasResolver)(nil), "berty.protocol.v1.MultiMemberGroupAddAliasResolver")
	proto.RegisterType((*MultiMemberGrantAdminRole)(nil), "berty.protocol.v1.MultiMemberGrantAdminRole")
	proto.RegisterType((*MultiMemberInitialMember)(nil), "berty.protocol.v1.MultiMemberInitialMember")
	proto.RegisterType((*GroupAddAdditionalRendezvousSeed)(nil), "berty.protocol.v1.GroupAddAdditionalRendezvousSeed")
	proto.RegisterType((*GroupRemoveAdditionalRendezvousSeed)(nil), "berty.protocol.v1.GroupRemoveAdditionalRendezvousSeed")
	proto.RegisterType((*AccountGroupJoined)(nil), "berty.protocol.v1.AccountGroupJoined")
	proto.RegisterType((*AccountGroupLeft)(nil), "berty.protocol.v1.AccountGroupLeft")
	proto.RegisterType((*AccountContactRequestDisabled)(nil), "berty.protocol.v1.AccountContactRequestDisabled")
	proto.RegisterType((*AccountContactRequestEnabled)(nil), "berty.protocol.v1.AccountContactRequestEnabled")
	proto.RegisterType((*AccountContactRequestReferenceReset)(nil), "berty.protocol.v1.AccountContactRequestReferenceReset")
	proto.RegisterType((*AccountContactRequestEnqueued)(nil), "berty.protocol.v1.AccountContactRequestEnqueued")
	proto.RegisterType((*AccountContactRequestSent)(nil), "berty.protocol.v1.AccountContactRequestSent")
	proto.RegisterType((*AccountContactRequestReceived)(nil), "berty.protocol.v1.AccountContactRequestReceived")
	proto.RegisterType((*AccountContactRequestDiscarded)(nil), "berty.protocol.v1.AccountContactRequestDiscarded")
	proto.RegisterType((*AccountContactRequestAccepted)(nil), "berty.protocol.v1.AccountContactRequestAccepted")
	proto.RegisterType((*AccountContactBlocked)(nil), "berty.protocol.v1.AccountContactBlocked")
	proto.RegisterType((*AccountContactUnblocked)(nil), "berty.protocol.v1.AccountContactUnblocked")
	proto.RegisterType((*AccountServiceTokenAdded)(nil), "berty.protocol.v1.AccountServiceTokenAdded")
	proto.RegisterType((*AccountServiceTokenRemoved)(nil), "berty.protocol.v1.AccountServiceTokenRemoved")
	proto.RegisterType((*GroupReplicating)(nil), "berty.protocol.v1.GroupReplicating")
	proto.RegisterType((*InstanceExportData)(nil), "berty.protocol.v1.InstanceExportData")
	proto.RegisterType((*InstanceExportData_Request)(nil), "berty.protocol.v1.InstanceExportData.Request")
	proto.RegisterType((*InstanceExportData_Reply)(nil), "berty.protocol.v1.InstanceExportData.Reply")
	proto.RegisterType((*InstanceGetConfiguration)(nil), "berty.protocol.v1.InstanceGetConfiguration")
	proto.RegisterType((*InstanceGetConfiguration_Request)(nil), "berty.protocol.v1.InstanceGetConfiguration.Request")
	proto.RegisterType((*InstanceGetConfiguration_Reply)(nil), "berty.protocol.v1.InstanceGetConfiguration.Reply")
	proto.RegisterType((*ContactRequestReference)(nil), "berty.protocol.v1.ContactRequestReference")
	proto.RegisterType((*ContactRequestReference_Request)(nil), "berty.protocol.v1.ContactRequestReference.Request")
	proto.RegisterType((*ContactRequestReference_Reply)(nil), "berty.protocol.v1.ContactRequestReference.Reply")
	proto.RegisterType((*ContactRequestDisable)(nil), "berty.protocol.v1.ContactRequestDisable")
	proto.RegisterType((*ContactRequestDisable_Request)(nil), "berty.protocol.v1.ContactRequestDisable.Request")
	proto.RegisterType((*ContactRequestDisable_Reply)(nil), "berty.protocol.v1.ContactRequestDisable.Reply")
	proto.RegisterType((*ContactRequestEnable)(nil), "berty.protocol.v1.ContactRequestEnable")
	proto.RegisterType((*ContactRequestEnable_Request)(nil), "berty.protocol.v1.ContactRequestEnable.Request")
	proto.RegisterType((*ContactRequestEnable_Reply)(nil), "berty.protocol.v1.ContactRequestEnable.Reply")
	proto.RegisterType((*ContactRequestResetReference)(nil), "berty.protocol.v1.ContactRequestResetReference")
	proto.RegisterType((*ContactRequestResetReference_Request)(nil), "berty.protocol.v1.ContactRequestResetReference.Request")
	proto.RegisterType((*ContactRequestResetReference_Reply)(nil), "berty.protocol.v1.ContactRequestResetReference.Reply")
	proto.RegisterType((*ContactRequestSend)(nil), "berty.protocol.v1.ContactRequestSend")
	proto.RegisterType((*ContactRequestSend_Request)(nil), "berty.protocol.v1.ContactRequestSend.Request")
	proto.RegisterType((*ContactRequestSend_Reply)(nil), "berty.protocol.v1.ContactRequestSend.Reply")
	proto.RegisterType((*ContactRequestAccept)(nil), "berty.protocol.v1.ContactRequestAccept")
	proto.RegisterType((*ContactRequestAccept_Request)(nil), "berty.protocol.v1.ContactRequestAccept.Request")
	proto.RegisterType((*ContactRequestAccept_Reply)(nil), "berty.protocol.v1.ContactRequestAccept.Reply")
	proto.RegisterType((*ContactRequestDiscard)(nil), "berty.protocol.v1.ContactRequestDiscard")
	proto.RegisterType((*ContactRequestDiscard_Request)(nil), "berty.protocol.v1.ContactRequestDiscard.Request")
	proto.RegisterType((*ContactRequestDiscard_Reply)(nil), "berty.protocol.v1.ContactRequestDiscard.Reply")
	proto.RegisterType((*ContactBlock)(nil), "berty.protocol.v1.ContactBlock")
	proto.RegisterType((*ContactBlock_Request)(nil), "berty.protocol.v1.ContactBlock.Request")
	proto.RegisterType((*ContactBlock_Reply)(nil), "berty.protocol.v1.ContactBlock.Reply")
	proto.RegisterType((*ContactUnblock)(nil), "berty.protocol.v1.ContactUnblock")
	proto.RegisterType((*ContactUnblock_Request)(nil), "berty.protocol.v1.ContactUnblock.Request")
	proto.RegisterType((*ContactUnblock_Reply)(nil), "berty.protocol.v1.ContactUnblock.Reply")
	proto.RegisterType((*ContactAliasKeySend)(nil), "berty.protocol.v1.ContactAliasKeySend")
	proto.RegisterType((*ContactAliasKeySend_Request)(nil), "berty.protocol.v1.ContactAliasKeySend.Request")
	proto.RegisterType((*ContactAliasKeySend_Reply)(nil), "berty.protocol.v1.ContactAliasKeySend.Reply")
	proto.RegisterType((*MultiMemberGroupCreate)(nil), "berty.protocol.v1.MultiMemberGroupCreate")
	proto.RegisterType((*MultiMemberGroupCreate_Request)(nil), "berty.protocol.v1.MultiMemberGroupCreate.Request")
	proto.RegisterType((*MultiMemberGroupCreate_Reply)(nil), "berty.protocol.v1.MultiMemberGroupCreate.Reply")
	proto.RegisterType((*MultiMemberGroupJoin)(nil), "berty.protocol.v1.MultiMemberGroupJoin")
	proto.RegisterType((*MultiMemberGroupJoin_Request)(nil), "berty.protocol.v1.MultiMemberGroupJoin.Request")
	proto.RegisterType((*MultiMemberGroupJoin_Reply)(nil), "berty.protocol.v1.MultiMemberGroupJoin.Reply")
	proto.RegisterType((*MultiMemberGroupLeave)(nil), "berty.protocol.v1.MultiMemberGroupLeave")
	proto.RegisterType((*MultiMemberGroupLeave_Request)(nil), "berty.protocol.v1.MultiMemberGroupLeave.Request")
	proto.RegisterType((*MultiMemberGroupLeave_Reply)(nil), "berty.protocol.v1.MultiMemberGroupLeave.Reply")
	proto.RegisterType((*MultiMemberGroupAliasResolverDisclose)(nil), "berty.protocol.v1.MultiMemberGroupAliasResolverDisclose")
	proto.RegisterType((*MultiMemberGroupAliasResolverDisclose_Request)(nil), "berty.protocol.v1.MultiMemberGroupAliasResolverDisclose.Request")
	proto.RegisterType((*MultiMemberGroupAliasResolverDisclose_Reply)(nil), "berty.protocol.v1.MultiMemberGroupAliasResolverDisclose.Reply")
	proto.RegisterType((*MultiMemberGroupAdminRoleGrant)(nil), "berty.protocol.v1.MultiMemberGroupAdminRoleGrant")
	proto.RegisterType((*MultiMemberGroupAdminRoleGrant_Request)(nil), "berty.protocol.v1.MultiMemberGroupAdminRoleGrant.Request")
	proto.RegisterType((*MultiMemberGroupAdminRoleGrant_Reply)(nil), "berty.protocol.v1.MultiMemberGroupAdminRoleGrant.Reply")
	proto.RegisterType((*MultiMemberGroupInvitationCreate)(nil), "berty.protocol.v1.MultiMemberGroupInvitationCreate")
	proto.RegisterType((*MultiMemberGroupInvitationCreate_Request)(nil), "berty.protocol.v1.MultiMemberGroupInvitationCreate.Request")
	proto.RegisterType((*MultiMemberGroupInvitationCreate_Reply)(nil), "berty.protocol.v1.MultiMemberGroupInvitationCreate.Reply")
	proto.RegisterType((*AppMetadataSend)(nil), "berty.protocol.v1.AppMetadataSend")
	proto.RegisterType((*AppMetadataSend_Request)(nil), "berty.protocol.v1.AppMetadataSend.Request")
	proto.RegisterType((*AppMetadataSend_Reply)(nil), "berty.protocol.v1.AppMetadataSend.Reply")
	proto.RegisterType((*AppMessageSend)(nil), "berty.protocol.v1.AppMessageSend")
	proto.RegisterType((*AppMessageSend_Request)(nil), "berty.protocol.v1.AppMessageSend.Request")
	proto.RegisterType((*AppMessageSend_Reply)(nil), "berty.protocol.v1.AppMessageSend.Reply")
	proto.RegisterType((*GroupMetadataEvent)(nil), "berty.protocol.v1.GroupMetadataEvent")
	proto.RegisterType((*GroupMessageEvent)(nil), "berty.protocol.v1.GroupMessageEvent")
	proto.RegisterType((*GroupMetadataList)(nil), "berty.protocol.v1.GroupMetadataList")
	proto.RegisterType((*GroupMetadataList_Request)(nil), "berty.protocol.v1.GroupMetadataList.Request")
	proto.RegisterType((*GroupMessageList)(nil), "berty.protocol.v1.GroupMessageList")
	proto.RegisterType((*GroupMessageList_Request)(nil), "berty.protocol.v1.GroupMessageList.Request")
	proto.RegisterType((*GroupInfo)(nil), "berty.protocol.v1.GroupInfo")
	proto.RegisterType((*GroupInfo_Request)(nil), "berty.protocol.v1.GroupInfo.Request")
	proto.RegisterType((*GroupInfo_Reply)(nil), "berty.protocol.v1.GroupInfo.Reply")
	proto.RegisterType((*ActivateGroup)(nil), "berty.protocol.v1.ActivateGroup")
	proto.RegisterType((*ActivateGroup_Request)(nil), "berty.protocol.v1.ActivateGroup.Request")
	proto.RegisterType((*ActivateGroup_Reply)(nil), "berty.protocol.v1.ActivateGroup.Reply")
	proto.RegisterType((*DeactivateGroup)(nil), "berty.protocol.v1.DeactivateGroup")
	proto.RegisterType((*DeactivateGroup_Request)(nil), "berty.protocol.v1.DeactivateGroup.Request")
	proto.RegisterType((*DeactivateGroup_Reply)(nil), "berty.protocol.v1.DeactivateGroup.Reply")
	proto.RegisterType((*MonitorGroup)(nil), "berty.protocol.v1.MonitorGroup")
	proto.RegisterType((*MonitorGroup_EventMonitorAdvertiseGroup)(nil), "berty.protocol.v1.MonitorGroup.EventMonitorAdvertiseGroup")
	proto.RegisterType((*MonitorGroup_EventMonitorPeerFound)(nil), "berty.protocol.v1.MonitorGroup.EventMonitorPeerFound")
	proto.RegisterType((*MonitorGroup_EventMonitorPeerJoin)(nil), "berty.protocol.v1.MonitorGroup.EventMonitorPeerJoin")
	proto.RegisterType((*MonitorGroup_EventMonitorPeerLeave)(nil), "berty.protocol.v1.MonitorGroup.EventMonitorPeerLeave")
	proto.RegisterType((*MonitorGroup_EventMonitor)(nil), "berty.protocol.v1.MonitorGroup.EventMonitor")
	proto.RegisterType((*MonitorGroup_Request)(nil), "berty.protocol.v1.MonitorGroup.Request")
	proto.RegisterType((*MonitorGroup_Reply)(nil), "berty.protocol.v1.MonitorGroup.Reply")
	proto.RegisterType((*DebugListGroups)(nil), "berty.protocol.v1.DebugListGroups")
	proto.RegisterType((*DebugListGroups_Request)(nil), "berty.protocol.v1.DebugListGroups.Request")
	proto.RegisterType((*DebugListGroups_Reply)(nil), "berty.protocol.v1.DebugListGroups.Reply")
	proto.RegisterType((*DebugInspectGroupStore)(nil), "berty.protocol.v1.DebugInspectGroupStore")
	proto.RegisterType((*DebugInspectGroupStore_Request)(nil), "berty.protocol.v1.DebugInspectGroupStore.Request")
	proto.RegisterType((*DebugInspectGroupStore_Reply)(nil), "berty.protocol.v1.DebugInspectGroupStore.Reply")
	proto.RegisterType((*DebugGroup)(nil), "berty.protocol.v1.DebugGroup")
	proto.RegisterType((*DebugGroup_Request)(nil), "berty.protocol.v1.DebugGroup.Request")
	proto.RegisterType((*DebugGroup_Reply)(nil), "berty.protocol.v1.DebugGroup.Reply")
	proto.RegisterType((*AuthExchangeResponse)(nil), "berty.protocol.v1.AuthExchangeResponse")
	proto.RegisterMapType((map[string]string)(nil), "berty.protocol.v1.AuthExchangeResponse.ServicesEntry")
	proto.RegisterType((*DebugAuthServiceSetToken)(nil), "berty.protocol.v1.DebugAuthServiceSetToken")
	proto.RegisterType((*DebugAuthServiceSetToken_Request)(nil), "berty.protocol.v1.DebugAuthServiceSetToken.Request")
	proto.RegisterType((*DebugAuthServiceSetToken_Reply)(nil), "berty.protocol.v1.DebugAuthServiceSetToken.Reply")
	proto.RegisterType((*ShareableContact)(nil), "berty.protocol.v1.ShareableContact")
	proto.RegisterType((*ServiceTokenSupportedService)(nil), "berty.protocol.v1.ServiceTokenSupportedService")
	proto.RegisterType((*ServiceToken)(nil), "berty.protocol.v1.ServiceToken")
	proto.RegisterType((*AuthServiceCompleteFlow)(nil), "berty.protocol.v1.AuthServiceCompleteFlow")
	proto.RegisterType((*AuthServiceCompleteFlow_Request)(nil), "berty.protocol.v1.AuthServiceCompleteFlow.Request")
	proto.RegisterType((*AuthServiceCompleteFlow_Reply)(nil), "berty.protocol.v1.AuthServiceCompleteFlow.Reply")
	proto.RegisterType((*AuthServiceInitFlow)(nil), "berty.protocol.v1.AuthServiceInitFlow")
	proto.RegisterType((*AuthServiceInitFlow_Request)(nil), "berty.protocol.v1.AuthServiceInitFlow.Request")
	proto.RegisterType((*AuthServiceInitFlow_Reply)(nil), "berty.protocol.v1.AuthServiceInitFlow.Reply")
	proto.RegisterType((*ServicesTokenList)(nil), "berty.protocol.v1.ServicesTokenList")
	proto.RegisterType((*ServicesTokenList_Request)(nil), "berty.protocol.v1.ServicesTokenList.Request")
	proto.RegisterType((*ServicesTokenList_Reply)(nil), "berty.protocol.v1.ServicesTokenList.Reply")
	proto.RegisterType((*ServicesTokenCode)(nil), "berty.protocol.v1.ServicesTokenCode")
	proto.RegisterType((*ReplicationServiceRegisterGroup)(nil), "berty.protocol.v1.ReplicationServiceRegisterGroup")
	proto.RegisterType((*ReplicationServiceRegisterGroup_Request)(nil), "berty.protocol.v1.ReplicationServiceRegisterGroup.Request")
	proto.RegisterType((*ReplicationServiceRegisterGroup_Reply)(nil), "berty.protocol.v1.ReplicationServiceRegisterGroup.Reply")
	proto.RegisterType((*ReplicationServiceReplicateGroup)(nil), "berty.protocol.v1.ReplicationServiceReplicateGroup")
	proto.RegisterType((*ReplicationServiceReplicateGroup_Request)(nil), "berty.protocol.v1.ReplicationServiceReplicateGroup.Request")
	proto.RegisterType((*ReplicationServiceReplicateGroup_Reply)(nil), "berty.protocol.v1.ReplicationServiceReplicateGroup.Reply")
	proto.RegisterType((*SystemInfo)(nil), "berty.protocol.v1.SystemInfo")
	proto.RegisterType((*SystemInfo_Request)(nil), "berty.protocol.v1.SystemInfo.Request")
	proto.RegisterType((*SystemInfo_Reply)(nil), "berty.protocol.v1.SystemInfo.Reply")
	proto.RegisterType((*SystemInfo_OrbitDB)(nil), "berty.protocol.v1.SystemInfo.OrbitDB")
	proto.RegisterType((*SystemInfo_OrbitDB_ReplicationStatus)(nil), "berty.protocol.v1.SystemInfo.OrbitDB.ReplicationStatus")
	proto.RegisterType((*SystemInfo_P2P)(nil), "berty.protocol.v1.SystemInfo.P2P")
	proto.RegisterType((*SystemInfo_Process)(nil), "berty.protocol.v1.SystemInfo.Process")
	proto.RegisterType((*PeerList)(nil), "berty.protocol.v1.PeerList")
	proto.RegisterType((*PeerList_Request)(nil), "berty.protocol.v1.PeerList.Request")
	proto.RegisterType((*PeerList_Reply)(nil), "berty.protocol.v1.PeerList.Reply")
	proto.RegisterType((*PeerList_Peer)(nil), "berty.protocol.v1.PeerList.Peer")
	proto.RegisterType((*PeerList_Route)(nil), "berty.protocol.v1.PeerList.Route")
	proto.RegisterType((*PeerList_Stream)(nil), "berty.protocol.v1.PeerList.Stream")
	proto.RegisterType((*AttachmentPrepare)(nil), "berty.protocol.v1.AttachmentPrepare")
	proto.RegisterType((*AttachmentPrepare_Request)(nil), "berty.protocol.v1.AttachmentPrepare.Request")
	proto.RegisterType((*AttachmentPrepare_Reply)(nil), "berty.protocol.v1.AttachmentPrepare.Reply")
	proto.RegisterType((*AttachmentRetrieve)(nil), "berty.protocol.v1.AttachmentRetrieve")
	proto.RegisterType((*AttachmentRetrieve_Request)(nil), "berty.protocol.v1.AttachmentRetrieve.Request")
	proto.RegisterType((*AttachmentRetrieve_Reply)(nil), "berty.protocol.v1.AttachmentRetrieve.Reply")
	proto.RegisterType((*Progress)(nil), "berty.protocol.v1.Progress")
	proto.RegisterType((*MemberWithDevices)(nil), "berty.protocol.v1.MemberWithDevices")
	proto.RegisterType((*OutOfStoreMessage)(nil), "berty.protocol.v1.OutOfStoreMessage")
	proto.RegisterType((*PushServiceReceiver)(nil), "berty.protocol.v1.PushServiceReceiver")
	proto.RegisterType((*PushServer)(nil), "berty.protocol.v1.PushServer")
	proto.RegisterType((*PushDeviceTokenRegistered)(nil), "berty.protocol.v1.PushDeviceTokenRegistered")
	proto.RegisterType((*PushDeviceServerRegistered)(nil), "berty.protocol.v1.PushDeviceServerRegistered")
	proto.RegisterType((*PushMemberTokenUpdate)(nil), "berty.protocol.v1.PushMemberTokenUpdate")
	proto.RegisterType((*PushReceive)(nil), "berty.protocol.v1.PushReceive")
	proto.RegisterType((*PushReceive_Request)(nil), "berty.protocol.v1.PushReceive.Request")
	proto.RegisterType((*PushReceive_Reply)(nil), "berty.protocol.v1.PushReceive.Reply")
	proto.RegisterType((*PushSend)(nil), "berty.protocol.v1.PushSend")
	proto.RegisterType((*PushSend_Request)(nil), "berty.protocol.v1.PushSend.Request")
	proto.RegisterType((*PushSend_Reply)(nil), "berty.protocol.v1.PushSend.Reply")
	proto.RegisterType((*PushShareToken)(nil), "berty.protocol.v1.PushShareToken")
	proto.RegisterType((*PushShareToken_Request)(nil), "berty.protocol.v1.PushShareToken.Request")
	proto.RegisterType((*PushShareToken_Reply)(nil), "berty.protocol.v1.PushShareToken.Reply")
	proto.RegisterType((*PushSetDeviceToken)(nil), "berty.protocol.v1.PushSetDeviceToken")
	proto.RegisterType((*PushSetDeviceToken_Request)(nil), "berty.protocol.v1.PushSetDeviceToken.Request")
	proto.RegisterType((*PushSetDeviceToken_Reply)(nil), "berty.protocol.v1.PushSetDeviceToken.Reply")
	proto.RegisterType((*PushSetServer)(nil), "berty.protocol.v1.PushSetServer")
	proto.RegisterType((*PushSetServer_Request)(nil), "berty.protocol.v1.PushSetServer.Request")
	proto.RegisterType((*PushSetServer_Reply)(nil), "berty.protocol.v1.PushSetServer.Reply")
	proto.RegisterType((*FirstLastCounters)(nil), "berty.protocol.v1.FirstLastCounters")
	proto.RegisterType((*OrbitDBMessageHeads)(nil), "berty.protocol.v1.OrbitDBMessageHeads")
	proto.RegisterType((*OrbitDBMessageHeads_Box)(nil), "berty.protocol.v1.OrbitDBMessageHeads.Box")
	proto.RegisterType((*RefreshContactRequest)(nil), "berty.protocol.v1.RefreshContactRequest")
	proto.RegisterType((*RefreshContactRequest_Peer)(nil), "berty.protocol.v1.RefreshContactRequest.Peer")
	proto.RegisterType((*RefreshContactRequest_Request)(nil), "berty.protocol.v1.RefreshContactRequest.Request")
	proto.RegisterType((*RefreshContactRequest_Reply)(nil), "berty.protocol.v1.RefreshContactRequest.Reply")
}

func init() { proto.RegisterFile("protocoltypes.proto", fileDescriptor_8aa93e54ccb19003) }

var fileDescriptor_8aa93e54ccb19003 = []byte{
	// 6459 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3d, 0x5b, 0x6c, 0x24, 0xd9,
	0x55, 0x5b, 0xdd, 0xb6, 0xbb, 0xfb, 0x74, 0xdb, 0x2e, 0xdf, 0xf1, 0xcc, 0xf4, 0xf4, 0xce, 0x8c,
	0x67, 0xcb, 0x3b, 0x3b, 0xb3, 0xb3, 0xb3, 0x9e, 0x89, 0xb3, 0x9b, 0x7d, 0x67, 0xe3, 0xd7, 0x0e,
	0xce, 0xcc, 0xec, 0xf4, 0x96, 0xc7, 0xe4, 0x05, 0xe9, 0x94, 0xab, 0xae, 0xdb, 0xb5, 0xae, 0xae,
	0xaa, 0x54, 0x55, 0x7b, 0xc6, 0x28, 0x59, 0xa4, 0x15, 0x24, 0x21, 0x81, 0xe5, 0x91, 0x04, 0x04,
	0xe2, 0x03, 0xf1, 0x81, 0x14, 0x29, 0x84, 0x87, 0x10, 0x0a, 0xfc, 0x80, 0xe0, 0x27, 0x3c, 0x24,
	0x22, 0xc4, 0x1f, 0x92, 0x15, 0xfc, 0x81, 0x44, 0x84, 0xc2, 0x43, 0x02, 0x09, 0x04, 0x12, 0xba,
	0xaf, 0xaa, 0x5b, 0xdd, 0x55, 0xed, 0x6e, 0x7b, 0x56, 0x08, 0xf1, 0xd7, 0xf7, 0xdc, 0xf3, 0xba,
	0xe7, 0x9e, 0xba, 0xf7, 0xdc, 0x7b, 0xcf, 0xb1, 0xe1, 0x94, 0x1f, 0x78, 0x91, 0x67, 0x7a, 0x4e,
	0xb4, 0xef, 0xe3, 0x70, 0x81, 0xb6, 0xd0, 0xcc, 0x16, 0x0e, 0xa2, 0xfd, 0x05, 0xd1, 0xb5, 0xb0,
	0xf7, 0x81, 0xc6, 0x6c, 0xdb, 0x6b, 0x7b, 0x14, 0x70, 0x83, 0xfc, 0x62, 0x7d, 0x8d, 0x69, 0xbf,
	0x1b, 0xee, 0x48, 0x94, 0xda, 0x5f, 0x28, 0x50, 0x5a, 0x32, 0x4d, 0xaf, 0xeb, 0x46, 0x68, 0x01,
	0xc6, 0xdb, 0x81, 0xd7, 0xf5, 0xeb, 0xca, 0x25, 0xe5, 0x6a, 0x75, 0xb1, 0xbe, 0xd0, 0xc7, 0x75,
	0xe1, 0x16, 0xe9, 0xd7, 0x19, 0x1a, 0x5a, 0x80, 0x53, 0x06, 0x23, 0x6d, 0xf9, 0x81, 0xbd, 0x67,
	0x44, 0xb8, 0xb5, 0x8b, 0xf7, 0xeb, 0x85, 0x4b, 0xca, 0xd5, 0x9a, 0x3e, 0xc3, 0xbb, 0x9a, 0xac,
	0xe7, 0x36, 0xde, 0x47, 0xd7, 0x60, 0xc6, 0x70, 0x6c, 0x23, 0x4c, 0x61, 0x17, 0x29, 0xf6, 0x34,
	0xed, 0x90, 0x70, 0x9f, 0x83, 0x33, 0x7e, 0x77, 0xcb, 0xb1, 0xcd, 0x56, 0x80, 0x5d, 0x0b, 0xff,
	0xd8, 0x9e, 0xd7, 0x0d, 0x5b, 0x21, 0xc6, 0x56, 0x7d, 0x8c, 0x12, 0xcc, 0xb2, 0x5e, 0x3d, 0xee,
	0xdc, 0xc0, 0xd8, 0xd2, 0xfe, 0x55, 0x81, 0x71, 0xaa, 0x22, 0xba, 0x00, 0xc0, 0xe9, 0x89, 0x10,
	0x85, 0xd2, 0x54, 0x18, 0x84, 0xb0, 0x3f, 0x03, 0x13, 0x21, 0x36, 0x03, 0x1c, 0x71, 0x6d, 0x79,
	0x8b, 0x90, 0xb1, 0x5f, 0xad, 0xd0, 0x6e, 0x73, 0xdd, 0x2a, 0x0c, 0xb2, 0x61, 0xb7, 0xd1, 0x2b,
	0x00, 0x74, 0xe8, 0x2d, 0x62, 0x42, 0xaa, 0xc9, 0xd4, 0xe2, 0xf9, 0x3c, 0x33, 0xdd, 0xdf, 0xf7,
	0xb1, 0x5e, 0x69, 0x8b, 0x9f, 0xe8, 0x1c, 0x94, 0x43, 0xbb, 0xed, 0xb6, 0xfc, 0xee, 0x56, 0x7d,
	0x9c, 0x72, 0x2e, 0x91, 0x76, 0xb3, 0xbb, 0x45, 0xba, 0x1c, 0xdb, 0xdd, 0xa5, 0xba, 0x4e, 0xb0,
	0x2e, 0xd2, 0x26, 0x9a, 0x5e, 0x82, 0x9a, 0xe8, 0xa2, 0x3a, 0x95, 0x68, 0x37, 0xf0, 0xee, 0x0d,
	0xbb, 0xad, 0xfd, 0x9b, 0x02, 0x2a, 0x15, 0xf8, 0x43, 0xd8, 0xb0, 0xc2, 0xb5, 0x87, 0xbe, 0x17,
	0x44, 0x47, 0x8d, 0x5f, 0xd6, 0xa5, 0x90, 0xd6, 0x65, 0x0d, 0x4e, 0x75, 0x70, 0x64, 0x58, 0x46,
	0x64, 0xb4, 0x76, 0x08, 0xc7, 0x96, 0x69, 0x5b, 0x61, 0xbd, 0x78, 0xa9, 0x78, 0xb5, 0xb6, 0x7c,
	0xfa, 0xf0, 0x60, 0x6e, 0xe6, 0x2e, 0xef, 0xa6, 0xf2, 0x56, 0xd6, 0x57, 0x43, 0x7d, 0xa6, 0x93,
	0x02, 0xd9, 0x56, 0xc8, 0xd8, 0x84, 0xa1, 0xd1, 0xc6, 0xa1, 0xcc, 0x66, 0x4c, 0x66, 0xc3, 0xba,
	0x53, 0x6c, 0x64, 0x10, 0x61, 0x23, 0x5b, 0x66, 0x3c, 0x65, 0x19, 0xed, 0xcf, 0x15, 0x98, 0xa4,
	0xe3, 0x16, 0xfa, 0x90, 0xe9, 0xc1, 0x7b, 0xd8, 0x8d, 0xd8, 0xf4, 0x28, 0xb9, 0xd3, 0xb3, 0x46,
	0x90, 0xd8, 0xf4, 0x60, 0xf1, 0x13, 0xd5, 0xa1, 0xe4, 0x1b, 0xfb, 0x8e, 0x67, 0x58, 0xc2, 0x22,
	0xbc, 0x89, 0x54, 0x28, 0x26, 0xde, 0x40, 0x7e, 0xa2, 0x26, 0xcc, 0x08, 0x7e, 0x2d, 0x31, 0x74,
	0xea, 0x0e, 0xd5, 0xc5, 0xf9, 0x0c, 0x79, 0x4d, 0xfe, 0x5b, 0x28, 0xaa, 0xab, 0x7e, 0x0f, 0x44,
	0xfb, 0x9a, 0x18, 0xcc, 0x9a, 0xbb, 0x87, 0x1d, 0xcf, 0xc7, 0x68, 0x16, 0xc6, 0x5d, 0xcf, 0x35,
	0x31, 0x9f, 0x3c, 0xd6, 0x20, 0x50, 0xaa, 0x32, 0xd7, 0x91, 0x35, 0xd0, 0xc7, 0xe0, 0x1c, 0x76,
	0xcd, 0x60, 0xdf, 0x8f, 0xb0, 0xd5, 0x32, 0xa2, 0xc8, 0x30, 0x77, 0x3a, 0xc4, 0x0e, 0xd2, 0xcc,
	0x3d, 0x7e, 0x78, 0x30, 0x77, 0x76, 0x4d, 0x20, 0x2d, 0xc5, 0x38, 0xd4, 0xf0, 0x67, 0x71, 0x46,
	0x87, 0x6d, 0x85, 0xda, 0xbf, 0x28, 0x30, 0xc5, 0xe7, 0x89, 0xcc, 0x09, 0x0e, 0x42, 0x62, 0x27,
	0xfa, 0x61, 0xe3, 0x80, 0x6a, 0x36, 0xa6, 0x8b, 0x26, 0x7a, 0x1a, 0x2a, 0x16, 0xde, 0xb3, 0x4d,
	0xdc, 0xf2, 0x77, 0x99, 0x7e, 0xcb, 0xb5, 0xc3, 0x83, 0xb9, 0xf2, 0x2a, 0x05, 0x36, 0x6f, 0xeb,
	0x65, 0xd6, 0xdd, 0xdc, 0xcd, 0x30, 0xe9, 0x6d, 0x28, 0x4b, 0x96, 0x2c, 0x5e, 0xad, 0x2e, 0xde,
	0xc8, 0xb0, 0x64, 0x5a, 0x97, 0x05, 0x61, 0xbe, 0x35, 0x37, 0x0a, 0xf6, 0xf5, 0x98, 0x41, 0xe3,
	0x15, 0x98, 0x4c, 0x75, 0x11, 0x79, 0xe2, 0x3b, 0xa8, 0xe8, 0xe4, 0x27, 0x31, 0xe4, 0x9e, 0xe1,
	0x74, 0x31, 0x55, 0xb4, 0xa2, 0xb3, 0xc6, 0xcb, 0x85, 0x17, 0x15, 0x6d, 0x05, 0xd4, 0xde, 0x09,
	0x43, 0x37, 0xe0, 0x54, 0x62, 0x56, 0xb2, 0x10, 0x91, 0x15, 0x21, 0xac, 0x2b, 0xc4, 0xb4, 0x3a,
	0x92, 0xba, 0x36, 0x58, 0x8f, 0xf6, 0xae, 0x02, 0x6a, 0x6c, 0x6d, 0xae, 0x35, 0x3a, 0x0f, 0x15,
	0xdf, 0x31, 0x6c, 0x37, 0xc2, 0x0f, 0xa3, 0xf8, 0x9b, 0x14, 0x80, 0x6c, 0xa7, 0x2a, 0x9c, 0xc4,
	0xa9, 0xfe, 0x54, 0x81, 0x69, 0x2e, 0x3b, 0x76, 0xab, 0x2b, 0x30, 0xcd, 0xbf, 0x32, 0xfa, 0x59,
	0xe2, 0x20, 0xe4, 0x9a, 0x4c, 0x75, 0xfa, 0xe6, 0x99, 0x43, 0xc4, 0xf7, 0xc0, 0x9b, 0x89, 0x67,
	0x16, 0x65, 0xcf, 0x1c, 0xe8, 0x83, 0x63, 0x27, 0xf0, 0xc1, 0x3f, 0x50, 0xa0, 0x46, 0xbf, 0xd8,
	0x15, 0x8f, 0x19, 0xea, 0x0c, 0x14, 0x6c, 0x8b, 0x69, 0xbd, 0x3c, 0x71, 0x78, 0x30, 0x57, 0x58,
	0x5f, 0xd5, 0x0b, 0xb6, 0x85, 0xae, 0x03, 0xf8, 0x46, 0x40, 0x64, 0x12, 0x91, 0x05, 0x2a, 0x72,
	0xf2, 0xf0, 0x60, 0xae, 0xd2, 0xa4, 0x50, 0x22, 0xa4, 0xc2, 0x10, 0xd6, 0xad, 0x10, 0x3d, 0x05,
	0x65, 0xb6, 0x96, 0xfb, 0xbb, 0x6c, 0x20, 0xcb, 0xd5, 0xc3, 0x83, 0xb9, 0x12, 0xfd, 0x08, 0x9b,
	0xb7, 0xf5, 0x12, 0xed, 0x6c, 0xee, 0xa2, 0x57, 0x60, 0x3a, 0x7b, 0x34, 0xe8, 0xf0, 0x60, 0x6e,
	0xaa, 0x67, 0x10, 0x53, 0x46, 0x5a, 0x77, 0x1d, 0xaa, 0x4b, 0x7e, 0xb2, 0x40, 0xa5, 0xbe, 0x10,
	0x65, 0xe0, 0x17, 0x92, 0x6b, 0x7e, 0xad, 0x0d, 0x88, 0x58, 0xc2, 0x30, 0xa3, 0x25, 0xcb, 0x5a,
	0x22, 0xfb, 0x26, 0x59, 0xd1, 0x47, 0x60, 0xfd, 0x14, 0x94, 0xf9, 0x3e, 0x2c, 0x3e, 0x53, 0x3a,
	0x72, 0xca, 0x8a, 0x8c, 0x9c, 0xed, 0xc5, 0xbb, 0xda, 0x57, 0x14, 0x98, 0xa5, 0xe6, 0x58, 0xb2,
	0xac, 0xbb, 0xb8, 0xb3, 0x85, 0x03, 0xc6, 0x8c, 0xc8, 0xea, 0xd0, 0x76, 0x8f, 0x2c, 0x86, 0x44,
	0x64, 0xb1, 0xee, 0xe6, 0xee, 0x28, 0x6b, 0xc2, 0x05, 0x00, 0xce, 0x55, 0xda, 0x7b, 0x19, 0x84,
	0x6c, 0x73, 0x6b, 0x50, 0x63, 0x44, 0xec, 0x13, 0x43, 0x8f, 0x43, 0xc5, 0xdc, 0x31, 0x6c, 0x57,
	0xda, 0xe0, 0xca, 0x14, 0x40, 0xac, 0x21, 0x2d, 0x52, 0x85, 0xd4, 0x22, 0xa5, 0x7d, 0x55, 0x1a,
	0x54, 0x8a, 0xdf, 0x08, 0x06, 0xfc, 0x10, 0x4c, 0x59, 0x38, 0x8c, 0x5a, 0x89, 0x11, 0xd8, 0xc8,
	0xd4, 0xc3, 0x83, 0xb9, 0xda, 0x2a, 0x0e, 0xa3, 0xd8, 0x10, 0x35, 0x2b, 0x69, 0xed, 0xca, 0x5b,
	0x4c, 0x31, 0xb5, 0xc5, 0x68, 0x5f, 0x57, 0xe0, 0xd2, 0xdd, 0xae, 0x13, 0xd9, 0x0c, 0x57, 0x28,
	0x48, 0xa7, 0x44, 0xc7, 0xa1, 0xe7, 0xec, 0xf5, 0xae, 0xaf, 0x83, 0x35, 0xbc, 0x0c, 0x53, 0x6c,
	0x8a, 0x03, 0x4e, 0xcc, 0x9d, 0x68, 0xd2, 0x48, 0x71, 0x9c, 0x83, 0xaa, 0x88, 0xc8, 0x3c, 0x6f,
	0x9b, 0x2b, 0x05, 0x3c, 0x16, 0xf3, 0xbc, 0x6d, 0xed, 0x8b, 0x0a, 0x9c, 0x4b, 0xe9, 0x65, 0xb8,
	0xd1, 0x92, 0xd5, 0xb1, 0x5d, 0xdd, 0x73, 0xf0, 0x28, 0x0a, 0xbd, 0x0e, 0x33, 0x6d, 0x42, 0x8c,
	0x71, 0x9f, 0xd5, 0x4e, 0x1d, 0x1e, 0xcc, 0x4d, 0xdf, 0x62, 0x9d, 0xb1, 0xe1, 0xa6, 0xdb, 0x29,
	0xc0, 0xae, 0xb6, 0x06, 0x75, 0x49, 0x91, 0x75, 0xd7, 0x8e, 0x6c, 0xc3, 0x61, 0x8d, 0x11, 0xfc,
	0x51, 0x33, 0xe0, 0x52, 0x6c, 0x5c, 0xcb, 0xb2, 0x23, 0xdb, 0x73, 0x0d, 0x27, 0x1d, 0x45, 0x8e,
	0x32, 0x2c, 0x04, 0x63, 0x34, 0x28, 0x65, 0xd6, 0xa5, 0xbf, 0x35, 0x0b, 0xe6, 0x59, 0x98, 0x8c,
	0x3b, 0xde, 0x1e, 0x7e, 0xbf, 0xa4, 0x78, 0x80, 0x78, 0xdc, 0x4e, 0x85, 0x7d, 0xd4, 0xb3, 0xdd,
	0xd1, 0x98, 0xc6, 0xd1, 0x7e, 0x61, 0xa8, 0x68, 0x5f, 0xc3, 0xa0, 0xca, 0x02, 0xef, 0xe0, 0xed,
	0x68, 0xc4, 0x45, 0x27, 0x5e, 0x6e, 0x0b, 0xf9, 0xcb, 0xad, 0xf6, 0x51, 0xb8, 0xc0, 0xc5, 0xf0,
	0x45, 0x4e, 0xc7, 0x9f, 0xed, 0xe2, 0x30, 0x5a, 0xb5, 0x43, 0x63, 0xcb, 0x19, 0x69, 0x88, 0xda,
	0x3a, 0x9c, 0xcf, 0xe4, 0xb5, 0xe6, 0x8e, 0xcc, 0xea, 0x0b, 0x0a, 0xcc, 0x67, 0xf2, 0xd2, 0xf1,
	0x36, 0x0e, 0xb0, 0x6b, 0x62, 0x1d, 0x87, 0xa3, 0xad, 0x22, 0xf9, 0x47, 0x9c, 0xc2, 0x80, 0x23,
	0xce, 0xdf, 0x28, 0x39, 0x06, 0x5a, 0x73, 0x3f, 0xdb, 0xc5, 0xdd, 0xd1, 0x7c, 0x60, 0xc8, 0x49,
	0x41, 0xaf, 0x91, 0xe5, 0x94, 0x0a, 0xa3, 0x6b, 0x44, 0x76, 0x40, 0xb2, 0xb1, 0x63, 0x04, 0x98,
	0x18, 0x56, 0xe8, 0x25, 0x68, 0xd0, 0x13, 0x50, 0xf3, 0x1e, 0xb8, 0xe9, 0x48, 0xb9, 0xa6, 0x57,
	0xbd, 0x07, 0x6e, 0x1c, 0xaa, 0x44, 0x70, 0x2e, 0x73, 0x54, 0x1b, 0x24, 0xbc, 0x1d, 0x61, 0x44,
	0xd7, 0x01, 0xb8, 0xd4, 0x64, 0x4c, 0x34, 0x06, 0xe0, 0x6c, 0x9b, 0xb7, 0xf5, 0x0a, 0x47, 0x68,
	0xee, 0x6a, 0x7f, 0x9b, 0x67, 0x4c, 0x1d, 0x9b, 0xd8, 0xde, 0x1b, 0xcd, 0x98, 0x23, 0x89, 0x46,
	0x1f, 0x82, 0xb3, 0x02, 0xbb, 0x77, 0xfa, 0xd9, 0x32, 0x7c, 0xda, 0x14, 0x1a, 0xf5, 0x2c, 0x1b,
	0xaa, 0xa0, 0xeb, 0xb1, 0xe7, 0x34, 0x87, 0xc7, 0x36, 0xdd, 0x87, 0x8b, 0x79, 0x9f, 0x92, 0x69,
	0x04, 0xd6, 0xfb, 0x38, 0x3a, 0xed, 0xd7, 0xf2, 0x0c, 0xbb, 0x64, 0x9a, 0x98, 0xc4, 0x78, 0xef,
	0x9f, 0x61, 0x87, 0x8c, 0xeb, 0x34, 0x1f, 0x4e, 0xa7, 0x35, 0x5c, 0x76, 0x3c, 0x73, 0xf7, 0xfd,
	0x34, 0x4a, 0x00, 0x67, 0xd3, 0x12, 0x37, 0xdd, 0xad, 0xf7, 0x5b, 0xe6, 0x57, 0x14, 0xa8, 0x73,
	0xa1, 0x1b, 0x38, 0x20, 0x2c, 0xee, 0x7b, 0xbb, 0xd8, 0x5d, 0xb2, 0x46, 0x9c, 0xfe, 0x55, 0x98,
	0x0c, 0x19, 0x7d, 0x2b, 0x22, 0x0c, 0xf8, 0xae, 0x31, 0x97, 0xb5, 0x0e, 0x48, 0x72, 0xf4, 0x5a,
	0x28, 0xb5, 0x34, 0x0f, 0x1a, 0x19, 0xca, 0xb0, 0x8d, 0x72, 0xd4, 0x85, 0x8b, 0xaa, 0xd1, 0xb2,
	0xd9, 0x6a, 0x59, 0x61, 0x93, 0x4c, 0xd9, 0xad, 0xaf, 0xea, 0x25, 0xda, 0xb9, 0x6e, 0x69, 0xbf,
	0x2b, 0xee, 0x46, 0x74, 0xec, 0x3b, 0xb6, 0x69, 0x44, 0xb6, 0xdb, 0x1e, 0x6d, 0xd8, 0xc8, 0xe8,
	0x46, 0x3b, 0xd8, 0x8d, 0x28, 0xb1, 0xe7, 0xb6, 0xba, 0x81, 0xc3, 0x25, 0xd2, 0x4b, 0x8c, 0xa5,
	0x54, 0xef, 0xa6, 0x7e, 0x47, 0x9f, 0x49, 0x13, 0x6c, 0x06, 0x0e, 0x7a, 0x16, 0x50, 0x20, 0xe4,
	0x7b, 0x6e, 0x8b, 0x98, 0x04, 0x07, 0xd4, 0x39, 0x2b, 0xfa, 0x8c, 0xd4, 0xb3, 0x41, 0x3b, 0xb4,
	0xbb, 0x80, 0xd6, 0xdd, 0x30, 0x32, 0x5c, 0x13, 0xb3, 0xdb, 0x9c, 0x55, 0x72, 0xa6, 0xad, 0x40,
	0x89, 0x7f, 0x43, 0x8d, 0xeb, 0x30, 0x4e, 0xc6, 0xb3, 0x8f, 0xe6, 0x61, 0x12, 0x53, 0x0c, 0x6c,
	0xb5, 0xe8, 0x4a, 0xc0, 0xe2, 0xe0, 0x9a, 0x00, 0x12, 0x42, 0xed, 0x07, 0x13, 0x50, 0x17, 0xfc,
	0x6e, 0x61, 0xe2, 0x7b, 0xdb, 0x76, 0xbb, 0x1b, 0x50, 0x89, 0x32, 0xd7, 0xff, 0x1e, 0x17, 0x6c,
	0xaf, 0x03, 0xc4, 0x17, 0x7b, 0xc2, 0x42, 0xd4, 0xc5, 0xf8, 0xe4, 0x11, 0x17, 0x13, 0xd7, 0x7b,
	0x23, 0x85, 0xf8, 0xaf, 0x82, 0x2a, 0x18, 0xf7, 0x7c, 0xa3, 0xec, 0x30, 0x25, 0xc5, 0x17, 0xcd,
	0xdb, 0xfa, 0x94, 0x21, 0xb7, 0x77, 0xd1, 0x3c, 0x94, 0x7c, 0x8c, 0x03, 0x32, 0xe7, 0x63, 0x74,
	0x06, 0xe0, 0xf0, 0x60, 0x6e, 0xa2, 0x89, 0x71, 0xb0, 0xbe, 0xaa, 0x4f, 0x90, 0xae, 0x75, 0x8b,
	0x9c, 0xb1, 0x1d, 0x3b, 0x8c, 0xb0, 0x4b, 0x4e, 0xb6, 0xe3, 0x97, 0x8a, 0x57, 0x2b, 0x7a, 0x02,
	0x40, 0x9f, 0x80, 0xea, 0x96, 0x83, 0x5b, 0x98, 0x05, 0x00, 0xf4, 0xae, 0x6d, 0x6a, 0xf1, 0xc5,
	0x0c, 0x27, 0xce, 0x33, 0xd8, 0xc2, 0x06, 0x8e, 0x88, 0x13, 0x6d, 0x44, 0x46, 0x84, 0x75, 0xd8,
	0x72, 0xb0, 0x08, 0x26, 0xb6, 0x40, 0x7d, 0x60, 0x6f, 0xdb, 0x2d, 0x7f, 0xd1, 0x8f, 0xf9, 0x97,
	0x4e, 0xc8, 0x7f, 0x8a, 0x70, 0x6c, 0x2e, 0xfa, 0x42, 0xc6, 0xa7, 0xa0, 0xd6, 0xb1, 0xdc, 0x30,
	0xe6, 0x5f, 0x3e, 0x21, 0xff, 0x2a, 0xe1, 0x26, 0x98, 0xff, 0x28, 0x4c, 0x06, 0xd8, 0x31, 0xf6,
	0x63, 0xee, 0x95, 0x13, 0x72, 0xaf, 0x51, 0x76, 0x82, 0xbd, 0x0e, 0x33, 0xc2, 0x4d, 0xba, 0xe1,
	0x0e, 0x5f, 0x45, 0x80, 0xae, 0x22, 0x4f, 0x65, 0x5d, 0x6f, 0x74, 0xc3, 0x1d, 0xbe, 0x48, 0xf0,
	0xcd, 0x38, 0xd0, 0xa7, 0xb9, 0x23, 0x75, 0xc3, 0x1d, 0xfa, 0xa5, 0xa3, 0xdb, 0x80, 0x64, 0x9e,
	0xfc, 0xc3, 0xaa, 0x52, 0xa6, 0x17, 0x06, 0x30, 0xc5, 0x81, 0xae, 0x26, 0xbc, 0xf8, 0x67, 0x77,
	0x0b, 0x6a, 0xb2, 0xfa, 0xa8, 0x0a, 0xa5, 0x4d, 0x77, 0xd7, 0xf5, 0x1e, 0xb8, 0xea, 0x63, 0xa4,
	0xc1, 0x07, 0xa2, 0x2a, 0xa8, 0x06, 0x65, 0x11, 0x8e, 0xaa, 0x05, 0x34, 0x0d, 0xd5, 0x4d, 0xd7,
	0xd8, 0x33, 0x6c, 0x87, 0x40, 0xd4, 0xa2, 0xf6, 0x79, 0x38, 0x9b, 0x13, 0x23, 0xca, 0x9f, 0xdb,
	0xc7, 0xc4, 0xd7, 0x96, 0x1f, 0x07, 0x2a, 0xf9, 0x71, 0x20, 0x39, 0x4b, 0x8a, 0x79, 0x22, 0xdf,
	0x5c, 0x59, 0x17, 0x4d, 0xed, 0x19, 0x38, 0x9d, 0x19, 0x3a, 0xcb, 0xc2, 0x4b, 0x5c, 0xb8, 0xf6,
	0x19, 0x98, 0xcd, 0x8a, 0x8d, 0x65, 0xdc, 0xd7, 0x4e, 0xa4, 0xa8, 0xb6, 0x03, 0xe7, 0x7b, 0xad,
	0x11, 0xe2, 0x6c, 0x93, 0x9c, 0x50, 0xd2, 0x97, 0x95, 0xf8, 0x66, 0x24, 0x89, 0x1e, 0xad, 0xc6,
	0x6e, 0x2c, 0x40, 0x8e, 0x63, 0x95, 0x47, 0x10, 0xc7, 0x16, 0xfa, 0xe2, 0xd8, 0xc4, 0xb0, 0x1f,
	0xef, 0x35, 0x2c, 0x8b, 0x7c, 0x1a, 0x2f, 0x24, 0xda, 0xa4, 0x77, 0x72, 0x65, 0xf0, 0x4e, 0x9e,
	0x70, 0xfe, 0x44, 0xc6, 0xfc, 0x92, 0x78, 0xee, 0x11, 0xb0, 0x6e, 0x42, 0x4d, 0x0e, 0x86, 0x1e,
	0x01, 0x47, 0x1d, 0xa6, 0xd2, 0xc1, 0xce, 0x23, 0xe0, 0xf9, 0x16, 0x9c, 0x12, 0x17, 0x60, 0xfc,
	0xf6, 0x8b, 0xce, 0xf3, 0x07, 0x12, 0xc6, 0x72, 0x0c, 0xa8, 0xe4, 0xc7, 0x80, 0x09, 0xcb, 0xfb,
	0x70, 0xa6, 0xf7, 0xfa, 0x65, 0x25, 0xc0, 0x46, 0x94, 0x72, 0xcf, 0x1b, 0xc2, 0x3d, 0x87, 0x64,
	0xaf, 0x7d, 0x12, 0x66, 0x7b, 0xb9, 0x92, 0x73, 0x7a, 0xe3, 0xa5, 0x44, 0xd3, 0x11, 0xdf, 0xdc,
	0x12, 0x8d, 0x37, 0xe0, 0x74, 0x2f, 0xef, 0x3b, 0xd8, 0xd8, 0xc3, 0x27, 0x32, 0x83, 0x09, 0x97,
	0xfb, 0x6e, 0xa1, 0xe4, 0x0b, 0x23, 0xe2, 0x69, 0x8e, 0x17, 0x9e, 0x4c, 0xc8, 0x17, 0x15, 0xb8,
	0xd8, 0x7f, 0xd7, 0xc5, 0xef, 0x94, 0xe8, 0x3d, 0x50, 0xe3, 0x47, 0x46, 0x66, 0x9f, 0xbe, 0x03,
	0x2a, 0x0c, 0xba, 0x03, 0x4a, 0x34, 0x79, 0x2f, 0xe3, 0xd6, 0x6d, 0xdd, 0xdd, 0xb3, 0x23, 0xba,
	0x99, 0x71, 0x07, 0x38, 0xc6, 0x50, 0x5f, 0x10, 0x8e, 0x32, 0xe2, 0xec, 0x6a, 0x7f, 0xac, 0xc0,
	0xb4, 0x74, 0x5f, 0x4c, 0xdd, 0xfa, 0x4b, 0xca, 0xe8, 0xc6, 0xc8, 0x7f, 0xcb, 0xca, 0xb8, 0xcd,
	0x2e, 0x0e, 0x7b, 0x9b, 0xdd, 0xd0, 0xc4, 0xb8, 0xce, 0x41, 0xd1, 0x8c, 0xaf, 0xe0, 0x4b, 0x87,
	0x07, 0x73, 0xc5, 0x95, 0xf5, 0x55, 0x9d, 0xc0, 0xb4, 0x3f, 0x52, 0x60, 0x8a, 0x0e, 0x81, 0x5e,
	0x56, 0xff, 0x5f, 0x1c, 0xc1, 0xb7, 0x14, 0x40, 0xa9, 0x77, 0x45, 0xfa, 0xf8, 0x40, 0x4e, 0x40,
	0xec, 0x71, 0xd1, 0xf4, 0x92, 0x07, 0x9c, 0xec, 0x13, 0x90, 0xfc, 0x5a, 0xa1, 0xd7, 0xb0, 0xfc,
	0x76, 0xf1, 0xaa, 0xf4, 0xcc, 0xc5, 0x8e, 0x50, 0x97, 0xf2, 0x9c, 0x22, 0x7e, 0xd8, 0x89, 0x29,
	0x92, 0xd7, 0xbf, 0xa2, 0xf4, 0xfa, 0xa7, 0xfd, 0xb6, 0x02, 0x33, 0x9c, 0x82, 0xbd, 0xf5, 0x3c,
	0x42, 0x7d, 0x5f, 0x81, 0x92, 0x78, 0x26, 0x62, 0xea, 0x3e, 0x71, 0xe4, 0xab, 0x9c, 0x2e, 0x28,
	0xe4, 0x37, 0x8c, 0x62, 0xfa, 0x0d, 0xe3, 0xdf, 0x13, 0x95, 0xd9, 0xd0, 0xee, 0xd8, 0x61, 0xd4,
	0xf8, 0xde, 0x31, 0x1c, 0xe5, 0x29, 0x28, 0x87, 0xb6, 0x6b, 0x62, 0x71, 0x12, 0xe4, 0x78, 0x1b,
	0x04, 0x46, 0x4e, 0x82, 0xb4, 0x73, 0xdd, 0x42, 0x8f, 0x43, 0x85, 0xe1, 0xb9, 0xde, 0x03, 0xaa,
	0x4d, 0x59, 0x67, 0x84, 0x6f, 0x7a, 0x0f, 0x08, 0x93, 0xae, 0x1b, 0xd9, 0x8e, 0x38, 0x5a, 0x70,
	0x26, 0x9b, 0x04, 0x46, 0x98, 0xd0, 0x4e, 0xc6, 0x84, 0xe1, 0x11, 0x26, 0xe3, 0x8c, 0x09, 0x05,
	0x10, 0x26, 0xf3, 0x24, 0x7e, 0xde, 0xc3, 0x41, 0x88, 0x5b, 0x5e, 0x60, 0xe1, 0x80, 0x9e, 0x2e,
	0xca, 0x24, 0x0a, 0xa6, 0xc0, 0x7b, 0x04, 0x96, 0x3c, 0xd6, 0x73, 0x9b, 0xfd, 0x7f, 0x19, 0xf7,
	0x7f, 0x29, 0x50, 0xe1, 0xeb, 0xeb, 0xb6, 0xd7, 0x68, 0x8d, 0x3e, 0xde, 0x91, 0xae, 0x3d, 0x1a,
	0x3f, 0xa3, 0x1c, 0x73, 0x09, 0x1e, 0x61, 0x1f, 0x49, 0x1f, 0x7c, 0x8b, 0x03, 0xaf, 0x8f, 0xdf,
	0x86, 0xc9, 0x25, 0x33, 0xa2, 0xd9, 0x2d, 0x54, 0x5a, 0xa3, 0x39, 0xba, 0x05, 0x2e, 0x00, 0x38,
	0x9e, 0x69, 0x38, 0x2d, 0xcf, 0x75, 0xf6, 0x79, 0xd0, 0x5f, 0xa1, 0x90, 0x7b, 0xae, 0xb3, 0x9f,
	0xec, 0x6a, 0x77, 0x61, 0x7a, 0x15, 0x1b, 0x29, 0x69, 0x27, 0xd9, 0xae, 0xbf, 0x0d, 0x50, 0xbb,
	0xeb, 0xb9, 0x76, 0xe4, 0xb1, 0x0d, 0xb2, 0xf1, 0x73, 0x0a, 0x34, 0xe8, 0x8a, 0xc1, 0xa1, 0x4b,
	0xd6, 0x1e, 0x0e, 0x22, 0x3b, 0x64, 0xb2, 0xe4, 0x53, 0xba, 0x92, 0x7b, 0x4a, 0x3f, 0x03, 0x13,
	0x1d, 0xc3, 0xb2, 0x02, 0xf6, 0x4c, 0x5b, 0xd1, 0x79, 0x0b, 0xcd, 0x41, 0xd5, 0x0a, 0xc8, 0x59,
	0xaf, 0xe5, 0x1a, 0x1d, 0xcc, 0xaf, 0x48, 0x80, 0x81, 0xde, 0x34, 0x3a, 0xf4, 0xed, 0x39, 0xf2,
	0x7c, 0xdb, 0x64, 0x37, 0x00, 0x3a, 0x6b, 0x34, 0xbe, 0xa2, 0xc0, 0x69, 0x59, 0x25, 0x22, 0xed,
	0x0d, 0xaf, 0xeb, 0x5a, 0xff, 0x2b, 0xda, 0xbc, 0xab, 0xc0, 0x6c, 0xaf, 0x36, 0x24, 0xee, 0x3b,
	0x99, 0x32, 0xb1, 0xac, 0xa2, 0x24, 0x0b, 0x9d, 0x85, 0x92, 0x4d, 0x8e, 0x46, 0xce, 0x36, 0xd5,
	0xa1, 0xac, 0x4f, 0xd8, 0xe1, 0x06, 0x76, 0xb6, 0x1b, 0xbb, 0xfd, 0x16, 0xa1, 0xf1, 0xe1, 0x70,
	0x4a, 0x8c, 0x28, 0xec, 0xdb, 0x45, 0xfe, 0x44, 0xcf, 0xa5, 0xa1, 0x55, 0x18, 0x93, 0x72, 0x70,
	0x6e, 0x66, 0xed, 0x19, 0x92, 0x4b, 0x2d, 0xdc, 0xdf, 0xf7, 0xb1, 0x4c, 0xaf, 0x53, 0x6a, 0x64,
	0xc2, 0xb4, 0x21, 0x9c, 0xab, 0x25, 0x3f, 0x56, 0xbd, 0x7c, 0x14, 0xc3, 0x7c, 0xff, 0xd4, 0xa7,
	0x8c, 0xb4, 0xbf, 0xde, 0x07, 0xa0, 0xf6, 0xd8, 0x26, 0xfe, 0xc2, 0x9f, 0x37, 0x9e, 0x1f, 0x85,
	0x7f, 0xec, 0x6c, 0x7a, 0xc5, 0x8f, 0xfd, 0xee, 0x2d, 0xa0, 0x8d, 0xd6, 0xdb, 0x9e, 0xed, 0xf2,
	0xcc, 0xa0, 0xe7, 0x46, 0x65, 0x4a, 0x7c, 0x46, 0x2f, 0xfb, 0xc2, 0x7b, 0x84, 0xa2, 0x0e, 0x99,
	0x46, 0xba, 0x0a, 0x1f, 0x43, 0x51, 0xea, 0x03, 0x4c, 0xd1, 0x63, 0x1f, 0x17, 0x42, 0xb1, 0xb6,
	0x2e, 0x8b, 0x70, 0x84, 0xad, 0xad, 0xd7, 0x47, 0x51, 0x46, 0xa4, 0x2e, 0x0d, 0xfb, 0x2e, 0xf8,
	0x3b, 0x0a, 0xa8, 0xbd, 0x6e, 0x82, 0x2e, 0xc0, 0xb9, 0x5e, 0xd8, 0xa6, 0x6b, 0xe1, 0x6d, 0xdb,
	0xc5, 0x96, 0xfa, 0x18, 0xd2, 0xe0, 0x62, 0x6f, 0x77, 0xda, 0x19, 0x54, 0x25, 0x8b, 0x45, 0x3c,
	0xa1, 0x6a, 0x01, 0x9d, 0x87, 0x7a, 0x56, 0x37, 0x99, 0x10, 0xb5, 0x98, 0x47, 0x4c, 0x2d, 0xab,
	0x8e, 0x69, 0xdf, 0x51, 0xc8, 0x52, 0xbc, 0xd5, 0x6d, 0x93, 0x5d, 0x9e, 0x0a, 0x0c, 0xe5, 0xf3,
	0xe4, 0x37, 0x94, 0x11, 0x0f, 0x94, 0xe8, 0xa3, 0xa9, 0xfc, 0xc3, 0xc2, 0xd1, 0xf9, 0x87, 0x6c,
	0x8b, 0xcc, 0x4c, 0x47, 0x4c, 0x6f, 0xa8, 0xc5, 0x23, 0xde, 0x11, 0xbe, 0x5c, 0x84, 0x33, 0x74,
	0x28, 0xeb, 0x6e, 0xe8, 0x63, 0x93, 0x8d, 0x66, 0x23, 0xf2, 0x02, 0xdc, 0xf8, 0xc2, 0x31, 0xa2,
	0x97, 0x0d, 0x28, 0x3b, 0x5e, 0x5b, 0x1e, 0xc6, 0x33, 0x19, 0xc3, 0xe8, 0x13, 0x78, 0xc7, 0x6b,
	0xd3, 0x51, 0x51, 0xa6, 0xbc, 0xa1, 0x97, 0x1c, 0xf6, 0xa3, 0xf1, 0xf7, 0xca, 0xd1, 0xd1, 0x3d,
	0xba, 0x01, 0x55, 0x9e, 0x24, 0x64, 0x26, 0x59, 0x42, 0x53, 0x87, 0x07, 0x73, 0xc0, 0xb2, 0x84,
	0xe8, 0xb1, 0x81, 0xe7, 0x11, 0xd1, 0x0c, 0xc4, 0x3b, 0x52, 0x3e, 0xa4, 0x94, 0x5d, 0x58, 0x1c,
	0x22, 0xbb, 0x30, 0x4e, 0x8b, 0x8c, 0x41, 0xe9, 0x98, 0x61, 0xec, 0xa8, 0x0c, 0x20, 0x71, 0x04,
	0x9a, 0x48, 0x67, 0x8b, 0xf8, 0x00, 0xd4, 0x34, 0xc7, 0xde, 0xdc, 0xe5, 0x9b, 0x0c, 0xbe, 0x19,
	0xb0, 0x64, 0x36, 0xfe, 0x8e, 0xc2, 0x76, 0x83, 0x50, 0x2f, 0xb1, 0xed, 0x20, 0xd4, 0x7e, 0xbd,
	0x00, 0xb3, 0x4b, 0xdd, 0x68, 0x67, 0xed, 0xa1, 0xb9, 0x63, 0xb8, 0x6d, 0xac, 0xe3, 0xd0, 0xf7,
	0xdc, 0x10, 0xa3, 0x27, 0xa0, 0x66, 0x98, 0x26, 0x0e, 0x43, 0x7e, 0xa1, 0xcb, 0x32, 0xec, 0xaa,
	0x0c, 0xc6, 0x2e, 0x69, 0x67, 0x61, 0x3c, 0x34, 0x3d, 0x3f, 0xce, 0xb4, 0xa3, 0x0d, 0x7a, 0x94,
	0x09, 0x02, 0x4f, 0x3c, 0x83, 0xb0, 0x06, 0x7a, 0x06, 0x66, 0xe8, 0x8f, 0x96, 0x85, 0x43, 0x33,
	0xb0, 0x7d, 0x72, 0x0e, 0xe7, 0x9b, 0xab, 0x4a, 0x3b, 0x56, 0x13, 0x38, 0x7a, 0x0b, 0xca, 0xfc,
	0x75, 0x89, 0xdd, 0xf4, 0x67, 0x2f, 0x87, 0x59, 0x6a, 0x8b, 0x37, 0xaa, 0x90, 0x27, 0x0e, 0x0a,
	0x36, 0x8d, 0x57, 0x60, 0x32, 0xd5, 0x35, 0x52, 0xe2, 0xe0, 0xef, 0x29, 0x50, 0xa7, 0xf3, 0x42,
	0x44, 0x72, 0x36, 0x1b, 0x38, 0xa2, 0x56, 0x68, 0xbc, 0xa7, 0xc8, 0xd7, 0x90, 0xe3, 0x89, 0xb5,
	0xaa, 0x8b, 0x57, 0x86, 0xd4, 0x5a, 0x67, 0x54, 0x8f, 0xe6, 0x51, 0x2a, 0x09, 0xf0, 0x3e, 0x07,
	0x6a, 0xef, 0x95, 0x27, 0x3a, 0x03, 0x85, 0xd8, 0x85, 0x68, 0x8a, 0x5d, 0xf3, 0xb6, 0x5e, 0xf0,
	0x8f, 0x99, 0xb3, 0x80, 0x1a, 0xd2, 0xa1, 0x97, 0x1d, 0x04, 0xe3, 0xb6, 0xe6, 0xc0, 0x79, 0xf9,
	0x2d, 0x70, 0xa3, 0xeb, 0xb3, 0xa7, 0x2b, 0x0e, 0x24, 0x0e, 0x16, 0x3f, 0x3c, 0x8a, 0x88, 0xa2,
	0xa2, 0x57, 0xc5, 0xb3, 0x22, 0xfb, 0xa6, 0x54, 0x81, 0x82, 0x5d, 0xcb, 0xf7, 0x6c, 0x9e, 0x1e,
	0x5b, 0xd1, 0xa7, 0x39, 0x7c, 0x8d, 0x83, 0xb5, 0xef, 0x2b, 0x50, 0x93, 0xc5, 0xb1, 0x40, 0x27,
	0x71, 0xdc, 0x47, 0x69, 0x61, 0xf4, 0x69, 0x40, 0xa1, 0x18, 0x4e, 0x2b, 0xf6, 0xd4, 0x62, 0x6e,
	0x72, 0xeb, 0x20, 0x3b, 0xe8, 0x33, 0x61, 0x0f, 0x24, 0x44, 0x17, 0x01, 0xf0, 0x43, 0xdf, 0x66,
	0x4f, 0x2f, 0xf4, 0x2b, 0x29, 0xea, 0x12, 0x44, 0xfb, 0x29, 0x05, 0xce, 0x4a, 0xae, 0xb8, 0xe2,
	0x75, 0x7c, 0x07, 0x47, 0xf8, 0x0d, 0xc7, 0x7b, 0xd0, 0x78, 0x2d, 0xf1, 0xc6, 0x45, 0xa8, 0x99,
	0x86, 0xe3, 0x6c, 0x19, 0xe6, 0x2e, 0x1d, 0x26, 0x8b, 0x0a, 0xa7, 0x0f, 0x0f, 0xe6, 0xaa, 0x2b,
	0x1c, 0x4e, 0x06, 0x58, 0x15, 0x48, 0xc4, 0x79, 0xe4, 0x05, 0x24, 0x7e, 0x88, 0x55, 0x06, 0x3c,
	0xc4, 0xfe, 0xbe, 0x02, 0xa7, 0x24, 0x5d, 0xd6, 0x5d, 0x3b, 0xa2, 0x7a, 0xdc, 0x4d, 0x2d, 0x5e,
	0xc4, 0x86, 0x92, 0x0e, 0x2c, 0x2d, 0xb1, 0x1b, 0xed, 0x10, 0xf9, 0x25, 0xd2, 0x49, 0xcc, 0xda,
	0x90, 0x3e, 0xfb, 0x22, 0x0d, 0x91, 0x93, 0xef, 0xb7, 0x29, 0xed, 0x00, 0x09, 0x1f, 0xba, 0x03,
	0x10, 0x1e, 0x04, 0x46, 0x36, 0xbe, 0x10, 0x9b, 0xdd, 0x00, 0xc7, 0x93, 0x5a, 0x66, 0x1b, 0xdf,
	0x06, 0x85, 0x12, 0xbc, 0x0a, 0x43, 0xd8, 0x0c, 0x1c, 0xed, 0xcb, 0x0a, 0xcc, 0x08, 0x8b, 0xd3,
	0x51, 0xd1, 0x13, 0xbb, 0xb4, 0x8b, 0xbf, 0x3d, 0xa2, 0x29, 0xd0, 0x4b, 0x50, 0xe2, 0xfa, 0x0e,
	0xfb, 0x88, 0x2e, 0xf0, 0xb5, 0x77, 0x7a, 0x74, 0x59, 0xf1, 0x2c, 0x9c, 0xb2, 0x87, 0x92, 0xb6,
	0x07, 0xba, 0x0c, 0x53, 0xa6, 0x67, 0xe1, 0x96, 0xb9, 0x63, 0x38, 0x0e, 0x76, 0xdb, 0x62, 0xd5,
	0x9a, 0x24, 0xd0, 0x15, 0x01, 0x4c, 0xa9, 0x5e, 0x1c, 0x30, 0x8b, 0x3f, 0xa9, 0xc0, 0x9c, 0x9e,
	0x7e, 0xaf, 0xa6, 0xef, 0x73, 0x6d, 0x3b, 0x8c, 0xf8, 0xfd, 0x69, 0xe3, 0x13, 0xa9, 0x19, 0x1d,
	0xca, 0x22, 0x43, 0xc6, 0x80, 0xc9, 0x92, 0xf5, 0x0e, 0x5c, 0xca, 0x52, 0x83, 0x41, 0xf8, 0x99,
	0xf7, 0x04, 0x97, 0xec, 0x73, 0x62, 0x4a, 0xcf, 0x40, 0xc1, 0x63, 0xcb, 0x60, 0x99, 0x2d, 0x83,
	0xf7, 0x6e, 0xeb, 0x05, 0x6f, 0x57, 0xfb, 0x16, 0x00, 0x6c, 0xec, 0x87, 0x11, 0xee, 0xd0, 0xeb,
	0x0c, 0xc9, 0x1b, 0xbe, 0x1f, 0xc7, 0x20, 0xaf, 0x43, 0xc9, 0x0f, 0x3c, 0xb2, 0x0d, 0x72, 0xb1,
	0x97, 0xb3, 0xa6, 0x39, 0x66, 0xb2, 0xd0, 0x64, 0xc8, 0xba, 0xa0, 0x42, 0xaf, 0x42, 0xd1, 0x5f,
	0xf4, 0x07, 0x5c, 0xbb, 0xc9, 0xc4, 0x8b, 0x4d, 0xe6, 0xe5, 0xcd, 0xc5, 0xa6, 0x4e, 0xc8, 0xd0,
	0x1d, 0x28, 0x79, 0xc1, 0x96, 0x1d, 0x59, 0x5b, 0xfc, 0x4c, 0x73, 0x84, 0xf8, 0x7b, 0x04, 0x79,
	0x75, 0x99, 0x59, 0x9e, 0x37, 0x74, 0xc1, 0x82, 0x2c, 0x93, 0x0f, 0x8c, 0xc0, 0x65, 0xa9, 0xcf,
	0x15, 0x9d, 0x35, 0x1a, 0xff, 0xa8, 0x80, 0x40, 0x45, 0x5b, 0xc9, 0xd3, 0x7e, 0xbc, 0xd6, 0xb3,
	0x71, 0xbf, 0x30, 0x94, 0xe0, 0x05, 0x79, 0x42, 0x23, 0x23, 0xea, 0x86, 0xfa, 0x34, 0x67, 0x18,
	0x3f, 0xae, 0x7d, 0x1e, 0x66, 0xfa, 0xb0, 0x88, 0xfb, 0xfb, 0x81, 0xd7, 0x0e, 0x84, 0xa1, 0x8b,
	0x7a, 0xdc, 0xa6, 0x17, 0x90, 0xc6, 0x43, 0xbb, 0xd3, 0xed, 0x50, 0x33, 0x16, 0x75, 0xd1, 0x24,
	0x54, 0x5b, 0xdd, 0xed, 0x6d, 0x1c, 0xf0, 0x7c, 0xab, 0xa2, 0x1e, 0xb7, 0xc9, 0x09, 0x9c, 0xa5,
	0xd2, 0xf1, 0x35, 0x95, 0xb7, 0x1a, 0x0b, 0x40, 0xcc, 0x8b, 0xae, 0xc0, 0xb4, 0xe9, 0xb9, 0x2e,
	0x36, 0xc9, 0xb2, 0x4e, 0x02, 0x24, 0x21, 0x77, 0x2a, 0x06, 0x93, 0xf8, 0x29, 0x6c, 0x7c, 0x69,
	0x02, 0x4a, 0x7c, 0x56, 0x89, 0x26, 0x7b, 0x38, 0x08, 0xc9, 0x42, 0xcd, 0x76, 0x1a, 0xd1, 0x24,
	0x87, 0xea, 0x3d, 0x33, 0x6c, 0x05, 0x78, 0x9b, 0x7f, 0x9b, 0x13, 0x7b, 0x66, 0xa8, 0xe3, 0x6d,
	0x12, 0x2a, 0x76, 0xfd, 0xc8, 0xee, 0xe0, 0x56, 0x27, 0x64, 0x3a, 0xb2, 0x50, 0x71, 0x93, 0x02,
	0xef, 0x6e, 0xe8, 0x65, 0xd6, 0x7d, 0x37, 0x44, 0x2f, 0x83, 0xda, 0x0d, 0x71, 0xd0, 0x32, 0xfd,
	0x6e, 0x4b, 0x50, 0x00, 0xa5, 0x98, 0x39, 0x3c, 0x98, 0x9b, 0xdc, 0x0c, 0x71, 0xb0, 0xd2, 0xdc,
	0xbc, 0xcf, 0xc8, 0x26, 0x09, 0xea, 0x8a, 0xdf, 0xbd, 0xcf, 0x68, 0x3f, 0x02, 0x28, 0xa4, 0xb3,
	0x91, 0xa2, 0xae, 0x52, 0x6a, 0x9a, 0x9a, 0xcb, 0xe6, 0x2a, 0xa1, 0x9f, 0x66, 0xe8, 0x09, 0x87,
	0x0b, 0x00, 0x61, 0x64, 0x04, 0x2c, 0xef, 0xbf, 0x5e, 0xa3, 0xb6, 0xa8, 0x70, 0xc8, 0x12, 0x2d,
	0x45, 0x0a, 0x1c, 0xbb, 0x63, 0x47, 0x2d, 0xb3, 0x1b, 0xd4, 0x27, 0x69, 0x3a, 0x76, 0x85, 0x41,
	0x56, 0xba, 0x01, 0x9a, 0x87, 0x49, 0xb7, 0xdb, 0x69, 0xb5, 0xbd, 0xc0, 0xeb, 0x46, 0xb6, 0x8b,
	0xeb, 0x53, 0x94, 0x41, 0xcd, 0xed, 0x76, 0x6e, 0x09, 0x18, 0x99, 0x12, 0xd7, 0xdb, 0xb6, 0x1d,
	0x5c, 0x9f, 0x66, 0x53, 0xc2, 0x5a, 0xe8, 0x59, 0x38, 0x15, 0x79, 0x5e, 0xab, 0x63, 0xb8, 0xfb,
	0x2d, 0xcf, 0xc7, 0x6e, 0x8b, 0x40, 0xc3, 0xba, 0x4a, 0x6f, 0x27, 0xd4, 0xc8, 0xf3, 0xee, 0x1a,
	0xee, 0xfe, 0x3d, 0x1f, 0xbb, 0x6f, 0x10, 0x38, 0x9a, 0x87, 0x12, 0x91, 0x65, 0xfa, 0xdd, 0xfa,
	0x0c, 0x1d, 0x20, 0xbd, 0xfb, 0x78, 0xb3, 0x4b, 0x46, 0xa7, 0x4f, 0xb8, 0x5d, 0x32, 0x28, 0xa2,
	0x6f, 0xdb, 0x6b, 0x89, 0xd9, 0x42, 0x74, 0x4e, 0x2a, 0x6d, 0xef, 0x87, 0xf9, 0x7c, 0x3d, 0x0d,
	0xaa, 0xe7, 0xe3, 0x80, 0xa6, 0x12, 0xb5, 0x98, 0x29, 0xea, 0xa7, 0x58, 0xb4, 0x11, 0xc3, 0x99,
	0xc9, 0xd0, 0xe3, 0x50, 0xd9, 0xf1, 0xc2, 0x88, 0xdd, 0x1e, 0xcd, 0x52, 0x9c, 0x32, 0x01, 0xd0,
	0xbb, 0x23, 0x04, 0x63, 0x46, 0x60, 0xee, 0xd4, 0x4f, 0x53, 0x38, 0xfd, 0x2d, 0x99, 0xaa, 0x63,
	0x3c, 0xac, 0x9f, 0x91, 0x4d, 0x75, 0xd7, 0x78, 0x48, 0x36, 0x35, 0xdf, 0xb6, 0xea, 0x67, 0xa9,
	0xea, 0xec, 0x73, 0x27, 0xc7, 0x1a, 0xdf, 0xb6, 0xd0, 0x79, 0x18, 0xf3, 0x49, 0x5f, 0x9d, 0xf6,
	0x95, 0x0f, 0x0f, 0xe6, 0xc6, 0x9a, 0xa4, 0x93, 0x42, 0xd9, 0x37, 0x62, 0x7b, 0x81, 0x1d, 0xed,
	0xd7, 0xcf, 0x89, 0x6f, 0x84, 0xb5, 0xe9, 0x4e, 0x69, 0x5b, 0xf5, 0x46, 0xc2, 0x74, 0x93, 0x30,
	0xed, 0xda, 0x16, 0x9a, 0x83, 0xea, 0x03, 0x2f, 0xd8, 0x25, 0x03, 0xb5, 0xec, 0xa0, 0xfe, 0x38,
	0xbb, 0xff, 0xe2, 0xa0, 0x55, 0x3b, 0x20, 0x9f, 0x02, 0xf7, 0x1d, 0xe2, 0x53, 0x74, 0x98, 0xe7,
	0x29, 0xd2, 0x14, 0x03, 0x6f, 0x72, 0xa8, 0xf6, 0xcf, 0xe3, 0x50, 0xa6, 0x27, 0xe3, 0x9e, 0xcd,
	0xf3, 0x75, 0xb1, 0x5a, 0x7e, 0x08, 0xc6, 0xc5, 0xa7, 0x54, 0xcc, 0x79, 0x14, 0x11, 0xf4, 0xf4,
	0x87, 0xce, 0xd0, 0x1b, 0xdf, 0x2c, 0xc0, 0x18, 0x69, 0x4b, 0x45, 0x21, 0x95, 0x54, 0x51, 0xc8,
	0x4b, 0x30, 0x41, 0x9c, 0x08, 0xb3, 0xa3, 0x5e, 0xf6, 0x42, 0x1a, 0x73, 0xd6, 0x09, 0xa6, 0xce,
	0x09, 0x88, 0xd3, 0xd1, 0x33, 0x87, 0x08, 0x33, 0x78, 0x0b, 0xbd, 0x0e, 0xe5, 0x6d, 0x6c, 0x44,
	0xdd, 0x00, 0xb3, 0xf5, 0x70, 0x2a, 0xbb, 0x3e, 0x47, 0x30, 0x7d, 0x83, 0xe1, 0xea, 0x31, 0x11,
	0xb1, 0x6b, 0xc7, 0x76, 0x5b, 0x8e, 0x11, 0x61, 0xd7, 0x64, 0x75, 0x6d, 0x45, 0x1d, 0x3a, 0xb6,
	0x7b, 0x87, 0x41, 0x88, 0xe3, 0xd8, 0x61, 0x8b, 0xde, 0xe1, 0x62, 0x7e, 0x9d, 0x5e, 0xb6, 0x43,
	0x7a, 0x83, 0x8c, 0xd1, 0xcb, 0x50, 0xb1, 0xec, 0x00, 0x9b, 0x34, 0xea, 0x2b, 0xe5, 0x1e, 0x43,
	0x57, 0x05, 0x8e, 0x9e, 0xa0, 0x37, 0xfe, 0x9a, 0x6c, 0x4f, 0x64, 0x74, 0x69, 0x11, 0x4a, 0x8f,
	0x88, 0x3a, 0x94, 0x0c, 0xcb, 0xa2, 0x4b, 0x2a, 0x5b, 0x93, 0x44, 0x33, 0x2d, 0xbc, 0x38, 0x92,
	0x70, 0xc2, 0x55, 0x0c, 0x99, 0x2d, 0xac, 0xa2, 0x89, 0x5e, 0x85, 0x52, 0x18, 0x05, 0xd8, 0xe8,
	0x88, 0x83, 0x9c, 0x36, 0xc8, 0xa0, 0x1b, 0x14, 0x55, 0x17, 0x24, 0x8d, 0x4b, 0x30, 0xc1, 0x40,
	0x79, 0x4e, 0xa0, 0x05, 0x50, 0xe2, 0xb3, 0x80, 0x10, 0x4c, 0xf1, 0xac, 0x1e, 0x0e, 0x51, 0x1f,
	0x43, 0x2a, 0xd4, 0x96, 0x89, 0x38, 0x01, 0x51, 0xd0, 0x14, 0xc0, 0xf2, 0x9d, 0x35, 0xd1, 0x2e,
	0x10, 0x8c, 0x3b, 0x9e, 0x69, 0x38, 0x02, 0x52, 0x24, 0x18, 0xf7, 0xbd, 0x40, 0xb4, 0xc7, 0xd0,
	0x34, 0x54, 0xdf, 0xea, 0xda, 0xa6, 0x00, 0x8c, 0x6b, 0xbf, 0xa1, 0xc0, 0x4c, 0xf2, 0x1a, 0xd9,
	0x0c, 0xb0, 0x6f, 0x04, 0xb8, 0xf1, 0x66, 0x12, 0x95, 0xcc, 0xc2, 0x38, 0xcd, 0x88, 0x10, 0x05,
	0x7e, 0xb4, 0x81, 0x9e, 0x05, 0x64, 0xb1, 0x7c, 0x9d, 0x16, 0x2f, 0x88, 0x22, 0x96, 0x66, 0xb7,
	0xfd, 0x33, 0xbc, 0x67, 0x2d, 0xee, 0x68, 0x2c, 0x89, 0x0f, 0xe8, 0x45, 0x98, 0x4a, 0x3f, 0x8b,
	0xf2, 0xd3, 0x1b, 0xdd, 0x00, 0x52, 0xaf, 0xa2, 0xfa, 0x64, 0xea, 0x51, 0x54, 0x7b, 0x08, 0x28,
	0xe9, 0xd7, 0x71, 0x14, 0xd8, 0x78, 0x0f, 0x37, 0x56, 0x12, 0x45, 0x8f, 0xcd, 0xba, 0x71, 0x41,
	0x68, 0x17, 0x8f, 0xb5, 0x20, 0x8d, 0x55, 0xfb, 0x55, 0x05, 0xca, 0x4d, 0xb1, 0x57, 0xcf, 0xc2,
	0x78, 0x18, 0x19, 0x91, 0x38, 0xe1, 0xb1, 0x06, 0x81, 0x5a, 0x9e, 0xed, 0xb6, 0xc5, 0x69, 0x9b,
	0x36, 0x52, 0x7b, 0x3e, 0x71, 0xc2, 0x82, 0xb4, 0xe7, 0x9f, 0x87, 0x8a, 0xc9, 0x4f, 0x3a, 0x6c,
	0x03, 0x1f, 0xd3, 0x13, 0x00, 0x3b, 0xef, 0x45, 0x86, 0x43, 0x3f, 0xba, 0x31, 0x9d, 0x35, 0xa8,
	0x14, 0xec, 0x18, 0xac, 0xf8, 0x76, 0x4c, 0x67, 0x0d, 0xcd, 0x85, 0x19, 0xf6, 0xea, 0xf3, 0x31,
	0x3b, 0xda, 0x61, 0x17, 0x34, 0xe1, 0x28, 0xb5, 0x4f, 0x0b, 0x50, 0x65, 0x97, 0x39, 0x61, 0xcb,
	0xdf, 0x4d, 0x15, 0xa4, 0x89, 0xdb, 0x9e, 0x50, 0x07, 0x8e, 0xd1, 0xdc, 0x0d, 0xb5, 0x03, 0x05,
	0x66, 0xee, 0x75, 0xa3, 0x7b, 0xdb, 0xf4, 0x5e, 0x4d, 0x14, 0x0d, 0x0e, 0xb8, 0xcb, 0x1a, 0x21,
	0xf3, 0x52, 0x2a, 0x88, 0x22, 0x06, 0x9b, 0x48, 0xaa, 0x36, 0x79, 0x29, 0xe6, 0x58, 0x52, 0x8a,
	0x39, 0x0b, 0xe3, 0xdb, 0x8e, 0xd1, 0x0e, 0xa9, 0x8d, 0x4a, 0x3a, 0x6b, 0xd0, 0xab, 0x99, 0xb8,
	0xbe, 0x2f, 0x7d, 0x31, 0xa5, 0xc6, 0x1d, 0x4d, 0xfe, 0x48, 0x1f, 0x97, 0x08, 0x96, 0xa4, 0x12,
	0x41, 0xed, 0x2f, 0x15, 0x38, 0x95, 0x91, 0xd7, 0x87, 0x96, 0x01, 0xd8, 0x39, 0x41, 0x7a, 0x33,
	0x88, 0x97, 0xd4, 0x6e, 0xb8, 0xd3, 0x93, 0x0f, 0x48, 0xcf, 0x0f, 0xec, 0x3a, 0x33, 0x12, 0x3f,
	0x89, 0x2d, 0xb6, 0xba, 0xae, 0xe5, 0xe0, 0x24, 0x25, 0x98, 0xda, 0x62, 0x99, 0x02, 0xd7, 0x57,
	0x49, 0x7c, 0x47, 0x7f, 0x59, 0xc9, 0x99, 0x9f, 0xbf, 0xa2, 0xb3, 0x33, 0xff, 0x4d, 0x98, 0x0d,
	0xb0, 0x69, 0xfb, 0x36, 0x71, 0x72, 0xa9, 0x76, 0x9a, 0x19, 0x06, 0xc5, 0x7d, 0x4d, 0x51, 0x44,
	0xad, 0xbd, 0x09, 0x90, 0xa4, 0x0f, 0xb2, 0xd2, 0x71, 0xf2, 0x4b, 0xae, 0xb8, 0x66, 0x90, 0xdb,
	0x78, 0x5f, 0xbe, 0xc7, 0x20, 0x6b, 0x29, 0xf7, 0x67, 0x71, 0x8f, 0xb1, 0x64, 0x59, 0x81, 0xf6,
	0x13, 0x0a, 0x9c, 0x23, 0x0c, 0xd9, 0xf4, 0xf1, 0xd4, 0x68, 0x76, 0xb4, 0xc2, 0x16, 0x7a, 0x35,
	0x7d, 0x69, 0x34, 0x6c, 0xce, 0x24, 0x1f, 0xdd, 0xf0, 0xae, 0xa2, 0xbd, 0x03, 0x8d, 0x44, 0x0b,
	0x9e, 0x2d, 0x99, 0xa8, 0xf1, 0x3c, 0x4c, 0xf0, 0x34, 0x4b, 0x65, 0x98, 0x34, 0x4b, 0x8e, 0x3c,
	0x8a, 0xfc, 0x9f, 0x55, 0xe0, 0x34, 0xe1, 0xc0, 0xbe, 0x28, 0x6a, 0x86, 0x4d, 0xdf, 0x22, 0x8b,
	0xc1, 0x31, 0x65, 0xc7, 0xf3, 0x5d, 0x90, 0xe7, 0x7b, 0x84, 0xd7, 0xdb, 0x7f, 0x52, 0xa0, 0x4a,
	0xf8, 0x72, 0xa3, 0x36, 0xe6, 0x93, 0xb5, 0x51, 0xba, 0xa4, 0x55, 0x52, 0x97, 0xb4, 0x8d, 0x3f,
	0x8c, 0x4f, 0x82, 0x1f, 0x4e, 0xd2, 0x20, 0x98, 0xde, 0x4f, 0x66, 0xe8, 0xdd, 0xf7, 0xe1, 0x27,
	0xf5, 0xb6, 0x64, 0x45, 0x73, 0x30, 0x09, 0xa7, 0x1f, 0x8a, 0xba, 0xef, 0x04, 0x80, 0xae, 0x82,
	0xca, 0x0f, 0xcf, 0x89, 0xcf, 0x32, 0xc7, 0x9e, 0x62, 0xe7, 0xe6, 0xb8, 0xe8, 0xff, 0x69, 0x50,
	0x0d, 0x27, 0xc0, 0x86, 0xb5, 0xdf, 0x0a, 0x78, 0x7d, 0x0b, 0x7f, 0xc7, 0x9b, 0xe6, 0x70, 0x51,
	0xf6, 0xa2, 0xfd, 0x27, 0x59, 0x99, 0xa9, 0x25, 0x5d, 0xab, 0xf1, 0xcb, 0xd2, 0xd5, 0xe5, 0x80,
	0xd5, 0x28, 0x4b, 0x91, 0x42, 0xa6, 0x22, 0xeb, 0x30, 0xc9, 0x30, 0xd9, 0x52, 0x29, 0xee, 0xc4,
	0x9e, 0xcc, 0x4c, 0x2d, 0xe9, 0x59, 0x80, 0xf5, 0x5a, 0x9b, 0xa5, 0x4f, 0x50, 0xca, 0x86, 0x2e,
	0x8c, 0xdc, 0xc7, 0x53, 0x39, 0x2e, 0x4f, 0xed, 0x3b, 0x0a, 0x4c, 0xd1, 0xc1, 0xef, 0x18, 0x01,
	0xfb, 0x0c, 0x1b, 0xdf, 0x3c, 0xc6, 0x1b, 0x47, 0xe2, 0xad, 0x85, 0x51, 0xbc, 0x75, 0x19, 0xca,
	0x7c, 0x76, 0x02, 0x7e, 0x72, 0x1f, 0xf6, 0x53, 0x8f, 0xe9, 0x92, 0x8b, 0x12, 0x07, 0x10, 0xc3,
	0x8c, 0xa4, 0x45, 0x45, 0xbe, 0x74, 0x93, 0xa5, 0x29, 0x27, 0x95, 0xf6, 0x49, 0x98, 0xe4, 0xd2,
	0xd8, 0x98, 0x1a, 0x1f, 0x49, 0x04, 0x1d, 0xef, 0xdb, 0x4d, 0x78, 0xbf, 0x06, 0x33, 0x6f, 0xd8,
	0x41, 0x18, 0xdd, 0x31, 0xc2, 0x68, 0x85, 0x6d, 0x5d, 0x34, 0x66, 0xd8, 0x26, 0x40, 0xfe, 0x97,
	0x08, 0x58, 0x83, 0x9c, 0xac, 0x1c, 0x23, 0x8c, 0x78, 0xe5, 0x2f, 0xfd, 0xad, 0xbd, 0xa7, 0xc0,
	0x29, 0x7e, 0xd3, 0x20, 0x65, 0x2b, 0xb1, 0xb3, 0x2b, 0x36, 0x1c, 0x6c, 0xb5, 0xb6, 0xbc, 0x87,
	0xe2, 0xe3, 0x62, 0x90, 0x65, 0xef, 0x21, 0x59, 0xb5, 0x03, 0xe3, 0x41, 0x2b, 0xf0, 0x58, 0x4a,
	0x20, 0xff, 0xb0, 0xaa, 0x81, 0xf1, 0x40, 0xe7, 0xa0, 0xc6, 0xf3, 0x50, 0x24, 0x98, 0x52, 0xc8,
	0xac, 0xa4, 0x43, 0xe6, 0x59, 0x18, 0xa7, 0x7f, 0x00, 0x43, 0x2c, 0x3f, 0xb4, 0xa1, 0xfd, 0x87,
	0x02, 0xa7, 0x75, 0xbc, 0x1d, 0xe0, 0x70, 0x27, 0x9d, 0xcd, 0xdb, 0x78, 0xee, 0x88, 0x13, 0xcd,
	0x2c, 0x8c, 0xcb, 0xf9, 0x01, 0xac, 0xd1, 0x78, 0xeb, 0x98, 0x69, 0xb5, 0x44, 0x71, 0x72, 0xe8,
	0xf7, 0xba, 0x91, 0xb8, 0x23, 0xe1, 0xcd, 0x24, 0x43, 0xfd, 0x4d, 0xa8, 0xd2, 0xd3, 0x16, 0x7f,
	0x23, 0x67, 0x5f, 0xd6, 0xb3, 0x19, 0x13, 0x98, 0x39, 0x20, 0x76, 0x5e, 0xa3, 0x6f, 0xd7, 0x21,
	0x7d, 0x56, 0xbd, 0x66, 0x43, 0xf2, 0x24, 0x89, 0xce, 0xf0, 0x6c, 0x3b, 0xd2, 0x90, 0x1f, 0x6f,
	0x67, 0x79, 0xa2, 0x14, 0x81, 0xf3, 0xc2, 0x10, 0x55, 0x49, 0x41, 0xb9, 0x18, 0xb5, 0x80, 0xea,
	0xbc, 0xa6, 0x9b, 0x40, 0xa5, 0x84, 0x4e, 0xb5, 0x78, 0xed, 0xaf, 0xca, 0x50, 0x49, 0x5e, 0xdf,
	0xce, 0x00, 0x8a, 0x1b, 0xb2, 0xac, 0x79, 0x98, 0x8b, 0xe1, 0xb7, 0x92, 0xa5, 0x80, 0x7d, 0x33,
	0xb4, 0x56, 0x4a, 0x55, 0xfa, 0x91, 0xe4, 0xf2, 0x71, 0x86, 0x54, 0x40, 0x73, 0xf0, 0x78, 0x8c,
	0xd4, 0x5f, 0x9f, 0xab, 0x62, 0x74, 0x01, 0xce, 0x65, 0x22, 0xdc, 0xc1, 0xdb, 0x91, 0xba, 0x8d,
	0xae, 0xc1, 0x53, 0xbd, 0xdd, 0xd9, 0x75, 0xb0, 0x6a, 0x1b, 0x3d, 0x0d, 0x97, 0x07, 0xe3, 0x8a,
	0x8a, 0x85, 0x1d, 0x74, 0x13, 0xae, 0x0f, 0x46, 0x4d, 0x97, 0xb1, 0xaa, 0x36, 0x5a, 0x84, 0x85,
	0xc1, 0x14, 0xf7, 0xba, 0x51, 0x9b, 0x04, 0xe3, 0xa2, 0xee, 0x54, 0x7d, 0x1b, 0x2d, 0xc0, 0xb5,
	0xe1, 0x68, 0x36, 0xb0, 0x1b, 0xa9, 0xbb, 0x47, 0xcb, 0x58, 0x77, 0x4d, 0xaf, 0x63, 0xbb, 0x6d,
	0xb1, 0x2f, 0xa9, 0x0e, 0xfa, 0x20, 0xdc, 0x18, 0x8e, 0x26, 0xae, 0x72, 0x54, 0x3b, 0xc3, 0x0b,
	0x12, 0xe5, 0x89, 0xaa, 0x8b, 0x34, 0xb8, 0x98, 0x43, 0xc3, 0x0b, 0x05, 0x55, 0x0f, 0x3d, 0x09,
	0x97, 0x72, 0x70, 0xe2, 0xd2, 0x3e, 0xd5, 0x47, 0x1a, 0x5c, 0x88, 0xb1, 0x7a, 0x12, 0xd7, 0x99,
	0xdb, 0xfc, 0x99, 0x82, 0x6e, 0xc2, 0x33, 0x31, 0xce, 0xc0, 0x14, 0x6c, 0x46, 0xf1, 0x9b, 0x05,
	0xf4, 0x9c, 0x64, 0x88, 0xfe, 0x24, 0x66, 0xa9, 0x3c, 0x7e, 0xc9, 0x75, 0xbd, 0xae, 0x6b, 0x62,
	0x4b, 0xfd, 0x56, 0x01, 0x2d, 0xc0, 0xd3, 0xf9, 0x72, 0x52, 0x49, 0xd8, 0xd8, 0x52, 0x7f, 0xab,
	0x80, 0x9e, 0x82, 0x27, 0x7a, 0x47, 0xd8, 0x57, 0x47, 0xa8, 0xfe, 0x7c, 0x11, 0x5d, 0x85, 0xf9,
	0x41, 0x78, 0xbc, 0xc4, 0x4f, 0xfd, 0x85, 0x22, 0xba, 0x28, 0x7d, 0x00, 0xbd, 0xa5, 0x79, 0xea,
	0x57, 0x8b, 0x68, 0x5e, 0xb2, 0x7b, 0x66, 0x18, 0xa8, 0x7e, 0xad, 0x88, 0xae, 0x80, 0x96, 0x42,
	0xca, 0x0c, 0x99, 0xd5, 0xaf, 0xa7, 0xf5, 0xca, 0x8f, 0x6a, 0xd5, 0x5f, 0x2c, 0xa6, 0x46, 0x9a,
	0x4a, 0x4d, 0xe5, 0x67, 0x1a, 0xea, 0xb3, 0xff, 0x50, 0xba, 0xf6, 0xd3, 0xe2, 0x95, 0x37, 0x23,
	0x31, 0x01, 0x5d, 0x86, 0x27, 0xf2, 0xfa, 0x7a, 0xd6, 0x9b, 0x3c, 0x34, 0xbe, 0x3b, 0xa9, 0x0a,
	0x71, 0xae, 0x7c, 0x24, 0xa6, 0x9a, 0x5a, 0xb8, 0xf6, 0x27, 0x4a, 0x5c, 0xb3, 0xc1, 0xca, 0x96,
	0xce, 0xc5, 0xe5, 0x21, 0xb4, 0x2d, 0x8b, 0xed, 0xe9, 0xba, 0xef, 0x71, 0xef, 0x57, 0x15, 0xb2,
	0x82, 0xca, 0x5d, 0xf1, 0x07, 0x57, 0x40, 0xa7, 0x61, 0x46, 0xee, 0x61, 0x33, 0x5e, 0x44, 0x67,
	0xe3, 0x22, 0x0c, 0x4e, 0xc0, 0x26, 0x78, 0xac, 0x57, 0x48, 0xf2, 0x19, 0x8e, 0xf7, 0xd2, 0x88,
	0xef, 0x68, 0xe2, 0xda, 0x2d, 0xa8, 0xc4, 0x37, 0x46, 0x68, 0x0a, 0x80, 0xdf, 0xd0, 0xac, 0xda,
	0x81, 0xfa, 0x18, 0x69, 0xaf, 0xbb, 0x5b, 0x64, 0xe3, 0x20, 0x6d, 0x05, 0x4d, 0x43, 0xf5, 0x5e,
	0x37, 0x8a, 0x01, 0x05, 0x54, 0x81, 0xf1, 0x65, 0x9b, 0xfc, 0x2c, 0x2e, 0xfe, 0xe0, 0x0a, 0x4c,
	0x8b, 0x3f, 0x8c, 0x23, 0x5e, 0x90, 0x83, 0xac, 0x72, 0x4a, 0xf4, 0xec, 0x80, 0xb2, 0xb6, 0x04,
	0x6d, 0x41, 0x6c, 0xca, 0xcf, 0x0c, 0x8b, 0xee, 0x3b, 0xfb, 0x37, 0x15, 0xf4, 0xae, 0x92, 0x5f,
	0x73, 0x89, 0x3e, 0x38, 0x4a, 0x45, 0x9d, 0x50, 0xe0, 0x03, 0xa3, 0x11, 0x91, 0x6d, 0xfb, 0xc7,
	0x73, 0xeb, 0xd0, 0xd0, 0x62, 0x06, 0xb7, 0x1c, 0xdc, 0x58, 0x83, 0x9b, 0x23, 0xd1, 0x10, 0x05,
	0xf6, 0x73, 0x2a, 0xd1, 0xd0, 0xd1, 0xac, 0x38, 0x66, 0x2c, 0x7c, 0x61, 0x04, 0x0a, 0x22, 0x7a,
	0x2f, 0xbb, 0xae, 0x0d, 0xdd, 0x38, 0x92, 0x0f, 0x43, 0x8c, 0x05, 0x3f, 0x3b, 0x3c, 0x01, 0x91,
	0xfb, 0x9e, 0x32, 0xb8, 0xdc, 0x0d, 0xbd, 0x30, 0x84, 0x15, 0x65, 0x82, 0x58, 0x91, 0xe7, 0x47,
	0x27, 0x24, 0x0a, 0xf9, 0x59, 0x35, 0x71, 0xe8, 0xe8, 0x51, 0x11, 0xb4, 0x81, 0xde, 0x9f, 0x89,
	0x9e, 0x69, 0x7a, 0xb6, 0xa9, 0x0e, 0x61, 0x7a, 0x86, 0x38, 0x82, 0xe9, 0x63, 0x82, 0x3c, 0x6f,
	0x23, 0x4b, 0xcf, 0x70, 0xde, 0x46, 0x30, 0x47, 0xf3, 0x36, 0x4e, 0x41, 0x44, 0x7f, 0x3a, 0x5d,
	0x37, 0x87, 0xae, 0xe4, 0xd3, 0x53, 0x84, 0x58, 0xd0, 0xe5, 0xa3, 0x11, 0x09, 0x7f, 0xab, 0xb7,
	0x8a, 0x0e, 0x3d, 0x9d, 0x4f, 0xc8, 0x51, 0x62, 0x19, 0x57, 0x86, 0x41, 0x25, 0x52, 0xc2, 0xcc,
	0xba, 0x3a, 0x34, 0xc0, 0x18, 0x32, 0x5e, 0x2c, 0xef, 0xfa, 0xd0, 0xf8, 0x44, 0xe8, 0xe7, 0xf2,
	0x2a, 0xef, 0x50, 0xd6, 0x8a, 0x97, 0x8d, 0x1a, 0x8b, 0xbe, 0x31, 0x0a, 0x09, 0xf7, 0xd5, 0xac,
	0x0a, 0x3d, 0x34, 0x0c, 0x23, 0x82, 0x38, 0xd0, 0x57, 0x73, 0x08, 0xb8, 0xaf, 0x66, 0x56, 0xef,
	0x65, 0xfa, 0x6a, 0x26, 0xe6, 0x40, 0x5f, 0xcd, 0xa3, 0x20, 0xa2, 0xbf, 0xa1, 0x0c, 0x59, 0xe4,
	0x87, 0x3e, 0x32, 0x04, 0xe7, 0x4c, 0xca, 0x58, 0xb7, 0x0f, 0x9f, 0x80, 0x03, 0xd1, 0xf5, 0x6b,
	0x47, 0x96, 0x0a, 0xa2, 0x97, 0x86, 0x11, 0x91, 0x22, 0x89, 0xb5, 0x7b, 0xe1, 0x38, 0xa4, 0x44,
	0xad, 0x5f, 0x19, 0xa2, 0x6e, 0x10, 0xbd, 0x32, 0x04, 0xf7, 0x5e, 0xa2, 0x58, 0xb5, 0x97, 0x8e,
	0x47, 0x4c, 0x94, 0x6b, 0xf7, 0x95, 0x10, 0xa2, 0x6b, 0x59, 0x09, 0x86, 0x69, 0x9c, 0x58, 0xf2,
	0xd5, 0xa1, 0x70, 0xf9, 0xa2, 0x94, 0x2e, 0xf4, 0xcb, 0x5c, 0x94, 0xd2, 0x28, 0x03, 0x17, 0xa5,
	0x3e, 0x54, 0x22, 0xe5, 0xed, 0x8c, 0x42, 0x31, 0x74, 0xfd, 0xa8, 0x9a, 0x39, 0xf6, 0x9a, 0x3b,
	0x60, 0x91, 0xed, 0x2f, 0xf0, 0xbb, 0xa9, 0xa0, 0x76, 0x7f, 0x6d, 0x16, 0x7a, 0x26, 0x9f, 0x38,
	0x46, 0x8a, 0x25, 0x3d, 0x79, 0x04, 0xb2, 0x10, 0xb4, 0x29, 0x15, 0x43, 0xa1, 0x5c, 0x22, 0x9a,
	0x1e, 0x23, 0x58, 0x6b, 0x47, 0x60, 0x11, 0x5b, 0x19, 0x3d, 0x55, 0x46, 0x28, 0x73, 0x32, 0x65,
	0x8c, 0x98, 0xfd, 0x53, 0x43, 0x60, 0x72, 0xef, 0xea, 0x29, 0x2e, 0xca, 0xf4, 0xae, 0x1e, 0x9c,
	0x81, 0xde, 0xd5, 0x8f, 0x4b, 0x04, 0x7d, 0x26, 0x5d, 0x75, 0x94, 0xb9, 0xa5, 0xa6, 0x8a, 0x0b,
	0x06, 0xcd, 0x76, 0x0f, 0x22, 0x8b, 0xd1, 0xed, 0xbe, 0xe4, 0xfc, 0x9c, 0xa1, 0xa4, 0x70, 0x8e,
	0x18, 0x4a, 0x2f, 0x2e, 0x13, 0xf5, 0x4e, 0x5e, 0xf2, 0x7c, 0xe6, 0x26, 0x97, 0x8d, 0x3a, 0x70,
	0x93, 0xcb, 0x25, 0x61, 0xf2, 0x3f, 0x2e, 0x27, 0x8c, 0xa3, 0xcb, 0x79, 0x0c, 0xd2, 0x86, 0x9c,
	0x3f, 0x0a, 0x8d, 0x4c, 0xd3, 0xbb, 0x03, 0x72, 0x9e, 0x33, 0x0f, 0x3a, 0x79, 0xc8, 0x03, 0x0f,
	0x3a, 0x03, 0x88, 0x88, 0x12, 0x1f, 0x97, 0xb3, 0xf1, 0xd0, 0x11, 0x89, 0x6e, 0x83, 0x86, 0x97,
	0x42, 0xe3, 0x21, 0x51, 0x46, 0xd6, 0x6a, 0x66, 0x48, 0x94, 0x81, 0x37, 0x30, 0x24, 0xca, 0xc6,
	0xe7, 0xe7, 0xb6, 0x9c, 0xb4, 0xdd, 0xcc, 0x73, 0x5b, 0x0e, 0xee, 0xc0, 0x73, 0x5b, 0x3e, 0x0d,
	0x51, 0xc0, 0xcb, 0x48, 0x79, 0xcd, 0x5c, 0x73, 0xfb, 0xb0, 0x62, 0xa1, 0xd7, 0x86, 0xc4, 0x66,
	0xfe, 0xf9, 0x4b, 0x47, 0xe7, 0x95, 0xa2, 0x97, 0x33, 0xef, 0x9b, 0x07, 0xd2, 0xc4, 0xda, 0xbc,
	0x78, 0x2c, 0x5a, 0x62, 0x0a, 0x3d, 0xc9, 0x5b, 0x42, 0x03, 0xb3, 0x7c, 0x84, 0xa8, 0xc1, 0xf9,
	0x45, 0xc2, 0xbc, 0x7d, 0x89, 0x21, 0x99, 0xe6, 0xed, 0xc3, 0x1a, 0x68, 0xde, 0x2c, 0x6c, 0xdf,
	0xd9, 0xbf, 0xaa, 0xa0, 0x20, 0x2b, 0xc3, 0x23, 0xf3, 0x0c, 0xd8, 0x8f, 0x36, 0xf0, 0x0c, 0x98,
	0x89, 0xce, 0xa6, 0xf4, 0x53, 0xa9, 0x27, 0x53, 0x94, 0xf7, 0xaa, 0xc4, 0xfb, 0x07, 0xee, 0xa0,
	0x69, 0x3c, 0x31, 0x2b, 0xfc, 0x75, 0x32, 0x7b, 0x56, 0x78, 0xe7, 0xe0, 0x59, 0x49, 0x90, 0x78,
	0x38, 0x93, 0x7e, 0xf4, 0xcb, 0x0c, 0x67, 0xd2, 0x28, 0x03, 0xc3, 0x99, 0x3e, 0x54, 0x7e, 0x1c,
	0xef, 0x7f, 0x90, 0xcb, 0x9c, 0x8a, 0x7e, 0xb4, 0x81, 0x53, 0x91, 0x89, 0xce, 0x83, 0x82, 0xd4,
	0xa3, 0x5c, 0x66, 0x50, 0x90, 0xc2, 0x18, 0x18, 0x14, 0xf4, 0x62, 0xf2, 0xd3, 0x4c, 0xe6, 0xcb,
	0x4f, 0xe6, 0x69, 0x26, 0xfb, 0x8d, 0x68, 0xd0, 0x69, 0x26, 0x8f, 0xc2, 0x77, 0xf6, 0x97, 0x5f,
	0xf8, 0xee, 0xdf, 0x5d, 0x7c, 0xec, 0x3b, 0x87, 0x17, 0x95, 0xef, 0x1e, 0x5e, 0x54, 0xbe, 0x77,
	0x78, 0x51, 0xf9, 0xe4, 0x65, 0xc6, 0x20, 0xc2, 0xe6, 0xce, 0x0d, 0xfa, 0xf3, 0x46, 0xdb, 0xbb,
	0xe1, 0xef, 0xb6, 0x6f, 0xa4, 0xfe, 0x71, 0xc2, 0xd6, 0x04, 0x6d, 0x7e, 0xf0, 0x7f, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x7e, 0x3d, 0x30, 0x15, 0x50, 0x61, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ context.Context
	_ grpc.ClientConn
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProtocolServiceClient is the client API for ProtocolService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProtocolServiceClient interface {
	// InstanceExportData exports instance data
	InstanceExportData(ctx context.Context, in *InstanceExportData_Request, opts ...grpc.CallOption) (ProtocolService_InstanceExportDataClient, error)
	// InstanceGetConfiguration gets current configuration of this protocol instance
	InstanceGetConfiguration(ctx context.Context, in *InstanceGetConfiguration_Request, opts ...grpc.CallOption) (*InstanceGetConfiguration_Reply, error)
	// ContactRequestReference retrieves the information required to create a reference (ie. included in a shareable link) to the current account
	ContactRequestReference(ctx context.Context, in *ContactRequestReference_Request, opts ...grpc.CallOption) (*ContactRequestReference_Reply, error)
	// ContactRequestDisable disables incoming contact requests
	ContactRequestDisable(ctx context.Context, in *ContactRequestDisable_Request, opts ...grpc.CallOption) (*ContactRequestDisable_Reply, error)
	// ContactRequestEnable enables incoming contact requests
	ContactRequestEnable(ctx context.Context, in *ContactRequestEnable_Request, opts ...grpc.CallOption) (*ContactRequestEnable_Reply, error)
	// ContactRequestResetReference changes the contact request reference
	ContactRequestResetReference(ctx context.Context, in *ContactRequestResetReference_Request, opts ...grpc.CallOption) (*ContactRequestResetReference_Reply, error)
	// ContactRequestSend attempt to send a contact request
	ContactRequestSend(ctx context.Context, in *ContactRequestSend_Request, opts ...grpc.CallOption) (*ContactRequestSend_Reply, error)
	// ContactRequestAccept accepts a contact request
	ContactRequestAccept(ctx context.Context, in *ContactRequestAccept_Request, opts ...grpc.CallOption) (*ContactRequestAccept_Reply, error)
	// ContactRequestDiscard ignores a contact request, without informing the other user
	ContactRequestDiscard(ctx context.Context, in *ContactRequestDiscard_Request, opts ...grpc.CallOption) (*ContactRequestDiscard_Reply, error)
	// ContactBlock blocks a contact from sending requests
	ContactBlock(ctx context.Context, in *ContactBlock_Request, opts ...grpc.CallOption) (*ContactBlock_Reply, error)
	// ContactUnblock unblocks a contact from sending requests
	ContactUnblock(ctx context.Context, in *ContactUnblock_Request, opts ...grpc.CallOption) (*ContactUnblock_Reply, error)
	// ContactAliasKeySend send an alias key to a contact, the contact will be able to assert that your account is being present on a multi-member group
	ContactAliasKeySend(ctx context.Context, in *ContactAliasKeySend_Request, opts ...grpc.CallOption) (*ContactAliasKeySend_Reply, error)
	// MultiMemberGroupCreate creates a new multi-member group
	MultiMemberGroupCreate(ctx context.Context, in *MultiMemberGroupCreate_Request, opts ...grpc.CallOption) (*MultiMemberGroupCreate_Reply, error)
	// MultiMemberGroupJoin joins a multi-member group
	MultiMemberGroupJoin(ctx context.Context, in *MultiMemberGroupJoin_Request, opts ...grpc.CallOption) (*MultiMemberGroupJoin_Reply, error)
	// MultiMemberGroupLeave leaves a multi-member group
	MultiMemberGroupLeave(ctx context.Context, in *MultiMemberGroupLeave_Request, opts ...grpc.CallOption) (*MultiMemberGroupLeave_Reply, error)
	// MultiMemberGroupAliasResolverDisclose discloses your alias resolver key
	MultiMemberGroupAliasResolverDisclose(ctx context.Context, in *MultiMemberGroupAliasResolverDisclose_Request, opts ...grpc.CallOption) (*MultiMemberGroupAliasResolverDisclose_Reply, error)
	// MultiMemberGroupAdminRoleGrant grants an admin role to a group member
	MultiMemberGroupAdminRoleGrant(ctx context.Context, in *MultiMemberGroupAdminRoleGrant_Request, opts ...grpc.CallOption) (*MultiMemberGroupAdminRoleGrant_Reply, error)
	// MultiMemberGroupInvitationCreate creates an invitation to a multi-member group
	MultiMemberGroupInvitationCreate(ctx context.Context, in *MultiMemberGroupInvitationCreate_Request, opts ...grpc.CallOption) (*MultiMemberGroupInvitationCreate_Reply, error)
	// AppMetadataSend adds an app event to the metadata store, the message is encrypted using a symmetric key and readable by future group members
	AppMetadataSend(ctx context.Context, in *AppMetadataSend_Request, opts ...grpc.CallOption) (*AppMetadataSend_Reply, error)
	// AppMessageSend adds an app event to the message store, the message is encrypted using a derived key and readable by current group members
	AppMessageSend(ctx context.Context, in *AppMessageSend_Request, opts ...grpc.CallOption) (*AppMessageSend_Reply, error)
	// GroupMetadataList replays previous and subscribes to new metadata events from the group
	GroupMetadataList(ctx context.Context, in *GroupMetadataList_Request, opts ...grpc.CallOption) (ProtocolService_GroupMetadataListClient, error)
	// GroupMessageList replays previous and subscribes to new message events from the group
	GroupMessageList(ctx context.Context, in *GroupMessageList_Request, opts ...grpc.CallOption) (ProtocolService_GroupMessageListClient, error)
	// GroupInfo retrieves information about a group
	GroupInfo(ctx context.Context, in *GroupInfo_Request, opts ...grpc.CallOption) (*GroupInfo_Reply, error)
	// ActivateGroup explicitly opens a group
	ActivateGroup(ctx context.Context, in *ActivateGroup_Request, opts ...grpc.CallOption) (*ActivateGroup_Reply, error)
	// DeactivateGroup closes a group
	DeactivateGroup(ctx context.Context, in *DeactivateGroup_Request, opts ...grpc.CallOption) (*DeactivateGroup_Reply, error)
	// Monitor Group events
	MonitorGroup(ctx context.Context, in *MonitorGroup_Request, opts ...grpc.CallOption) (ProtocolService_MonitorGroupClient, error)
	DebugListGroups(ctx context.Context, in *DebugListGroups_Request, opts ...grpc.CallOption) (ProtocolService_DebugListGroupsClient, error)
	DebugInspectGroupStore(ctx context.Context, in *DebugInspectGroupStore_Request, opts ...grpc.CallOption) (ProtocolService_DebugInspectGroupStoreClient, error)
	DebugGroup(ctx context.Context, in *DebugGroup_Request, opts ...grpc.CallOption) (*DebugGroup_Reply, error)
	DebugAuthServiceSetToken(ctx context.Context, in *DebugAuthServiceSetToken_Request, opts ...grpc.CallOption) (*DebugAuthServiceSetToken_Reply, error)
	SystemInfo(ctx context.Context, in *SystemInfo_Request, opts ...grpc.CallOption) (*SystemInfo_Reply, error)
	// AuthServiceInitFlow Initialize an authentication flow
	AuthServiceInitFlow(ctx context.Context, in *AuthServiceInitFlow_Request, opts ...grpc.CallOption) (*AuthServiceInitFlow_Reply, error)
	// AuthServiceCompleteFlow Completes an authentication flow
	AuthServiceCompleteFlow(ctx context.Context, in *AuthServiceCompleteFlow_Request, opts ...grpc.CallOption) (*AuthServiceCompleteFlow_Reply, error)
	// ServicesTokenList Retrieves the list of services tokens
	ServicesTokenList(ctx context.Context, in *ServicesTokenList_Request, opts ...grpc.CallOption) (ProtocolService_ServicesTokenListClient, error)
	// ReplicationServiceRegisterGroup Asks a replication service to distribute a group contents
	ReplicationServiceRegisterGroup(ctx context.Context, in *ReplicationServiceRegisterGroup_Request, opts ...grpc.CallOption) (*ReplicationServiceRegisterGroup_Reply, error)
	// PeerList returns a list of P2P peers
	PeerList(ctx context.Context, in *PeerList_Request, opts ...grpc.CallOption) (*PeerList_Reply, error)
	// AttachmentPrepare ...
	AttachmentPrepare(ctx context.Context, opts ...grpc.CallOption) (ProtocolService_AttachmentPrepareClient, error)
	// AttachmentRetrieve returns an attachment data
	AttachmentRetrieve(ctx context.Context, in *AttachmentRetrieve_Request, opts ...grpc.CallOption) (ProtocolService_AttachmentRetrieveClient, error)
	// PushReceive handles a push payload, decrypts it if possible
	PushReceive(ctx context.Context, in *PushReceive_Request, opts ...grpc.CallOption) (*PushReceive_Reply, error)
	// PushSend sends a push payload to a specified list of group members
	PushSend(ctx context.Context, in *PushSend_Request, opts ...grpc.CallOption) (*PushSend_Reply, error)
	// PushShareToken sends push tokens of own devices to a group
	PushShareToken(ctx context.Context, in *PushShareToken_Request, opts ...grpc.CallOption) (*PushShareToken_Reply, error)
	// PushSetDeviceToken registers a push token for the current device
	PushSetDeviceToken(ctx context.Context, in *PushSetDeviceToken_Request, opts ...grpc.CallOption) (*PushSetDeviceToken_Reply, error)
	// PushSetServer registers a push server for the current device
	PushSetServer(ctx context.Context, in *PushSetServer_Request, opts ...grpc.CallOption) (*PushSetServer_Reply, error)
	// RefreshContactRequest try to refresh the contact request for the given contact
	RefreshContactRequest(ctx context.Context, in *RefreshContactRequest_Request, opts ...grpc.CallOption) (*RefreshContactRequest_Reply, error)
}

type protocolServiceClient struct {
	cc *grpc.ClientConn
}

func NewProtocolServiceClient(cc *grpc.ClientConn) ProtocolServiceClient {
	return &protocolServiceClient{cc}
}

func (c *protocolServiceClient) InstanceExportData(ctx context.Context, in *InstanceExportData_Request, opts ...grpc.CallOption) (ProtocolService_InstanceExportDataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[0], "/berty.protocol.v1.ProtocolService/InstanceExportData", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceInstanceExportDataClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_InstanceExportDataClient interface {
	Recv() (*InstanceExportData_Reply, error)
	grpc.ClientStream
}

type protocolServiceInstanceExportDataClient struct {
	grpc.ClientStream
}

func (x *protocolServiceInstanceExportDataClient) Recv() (*InstanceExportData_Reply, error) {
	m := new(InstanceExportData_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) InstanceGetConfiguration(ctx context.Context, in *InstanceGetConfiguration_Request, opts ...grpc.CallOption) (*InstanceGetConfiguration_Reply, error) {
	out := new(InstanceGetConfiguration_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/InstanceGetConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestReference(ctx context.Context, in *ContactRequestReference_Request, opts ...grpc.CallOption) (*ContactRequestReference_Reply, error) {
	out := new(ContactRequestReference_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestReference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestDisable(ctx context.Context, in *ContactRequestDisable_Request, opts ...grpc.CallOption) (*ContactRequestDisable_Reply, error) {
	out := new(ContactRequestDisable_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestDisable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestEnable(ctx context.Context, in *ContactRequestEnable_Request, opts ...grpc.CallOption) (*ContactRequestEnable_Reply, error) {
	out := new(ContactRequestEnable_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestEnable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestResetReference(ctx context.Context, in *ContactRequestResetReference_Request, opts ...grpc.CallOption) (*ContactRequestResetReference_Reply, error) {
	out := new(ContactRequestResetReference_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestResetReference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestSend(ctx context.Context, in *ContactRequestSend_Request, opts ...grpc.CallOption) (*ContactRequestSend_Reply, error) {
	out := new(ContactRequestSend_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestSend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestAccept(ctx context.Context, in *ContactRequestAccept_Request, opts ...grpc.CallOption) (*ContactRequestAccept_Reply, error) {
	out := new(ContactRequestAccept_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestAccept", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactRequestDiscard(ctx context.Context, in *ContactRequestDiscard_Request, opts ...grpc.CallOption) (*ContactRequestDiscard_Reply, error) {
	out := new(ContactRequestDiscard_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactRequestDiscard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactBlock(ctx context.Context, in *ContactBlock_Request, opts ...grpc.CallOption) (*ContactBlock_Reply, error) {
	out := new(ContactBlock_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactBlock", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactUnblock(ctx context.Context, in *ContactUnblock_Request, opts ...grpc.CallOption) (*ContactUnblock_Reply, error) {
	out := new(ContactUnblock_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactUnblock", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ContactAliasKeySend(ctx context.Context, in *ContactAliasKeySend_Request, opts ...grpc.CallOption) (*ContactAliasKeySend_Reply, error) {
	out := new(ContactAliasKeySend_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ContactAliasKeySend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupCreate(ctx context.Context, in *MultiMemberGroupCreate_Request, opts ...grpc.CallOption) (*MultiMemberGroupCreate_Reply, error) {
	out := new(MultiMemberGroupCreate_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupCreate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupJoin(ctx context.Context, in *MultiMemberGroupJoin_Request, opts ...grpc.CallOption) (*MultiMemberGroupJoin_Reply, error) {
	out := new(MultiMemberGroupJoin_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupJoin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupLeave(ctx context.Context, in *MultiMemberGroupLeave_Request, opts ...grpc.CallOption) (*MultiMemberGroupLeave_Reply, error) {
	out := new(MultiMemberGroupLeave_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupLeave", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupAliasResolverDisclose(ctx context.Context, in *MultiMemberGroupAliasResolverDisclose_Request, opts ...grpc.CallOption) (*MultiMemberGroupAliasResolverDisclose_Reply, error) {
	out := new(MultiMemberGroupAliasResolverDisclose_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupAliasResolverDisclose", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupAdminRoleGrant(ctx context.Context, in *MultiMemberGroupAdminRoleGrant_Request, opts ...grpc.CallOption) (*MultiMemberGroupAdminRoleGrant_Reply, error) {
	out := new(MultiMemberGroupAdminRoleGrant_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupAdminRoleGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MultiMemberGroupInvitationCreate(ctx context.Context, in *MultiMemberGroupInvitationCreate_Request, opts ...grpc.CallOption) (*MultiMemberGroupInvitationCreate_Reply, error) {
	out := new(MultiMemberGroupInvitationCreate_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/MultiMemberGroupInvitationCreate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) AppMetadataSend(ctx context.Context, in *AppMetadataSend_Request, opts ...grpc.CallOption) (*AppMetadataSend_Reply, error) {
	out := new(AppMetadataSend_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/AppMetadataSend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) AppMessageSend(ctx context.Context, in *AppMessageSend_Request, opts ...grpc.CallOption) (*AppMessageSend_Reply, error) {
	out := new(AppMessageSend_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/AppMessageSend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) GroupMetadataList(ctx context.Context, in *GroupMetadataList_Request, opts ...grpc.CallOption) (ProtocolService_GroupMetadataListClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[1], "/berty.protocol.v1.ProtocolService/GroupMetadataList", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceGroupMetadataListClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_GroupMetadataListClient interface {
	Recv() (*GroupMetadataEvent, error)
	grpc.ClientStream
}

type protocolServiceGroupMetadataListClient struct {
	grpc.ClientStream
}

func (x *protocolServiceGroupMetadataListClient) Recv() (*GroupMetadataEvent, error) {
	m := new(GroupMetadataEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) GroupMessageList(ctx context.Context, in *GroupMessageList_Request, opts ...grpc.CallOption) (ProtocolService_GroupMessageListClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[2], "/berty.protocol.v1.ProtocolService/GroupMessageList", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceGroupMessageListClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_GroupMessageListClient interface {
	Recv() (*GroupMessageEvent, error)
	grpc.ClientStream
}

type protocolServiceGroupMessageListClient struct {
	grpc.ClientStream
}

func (x *protocolServiceGroupMessageListClient) Recv() (*GroupMessageEvent, error) {
	m := new(GroupMessageEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) GroupInfo(ctx context.Context, in *GroupInfo_Request, opts ...grpc.CallOption) (*GroupInfo_Reply, error) {
	out := new(GroupInfo_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/GroupInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ActivateGroup(ctx context.Context, in *ActivateGroup_Request, opts ...grpc.CallOption) (*ActivateGroup_Reply, error) {
	out := new(ActivateGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ActivateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) DeactivateGroup(ctx context.Context, in *DeactivateGroup_Request, opts ...grpc.CallOption) (*DeactivateGroup_Reply, error) {
	out := new(DeactivateGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/DeactivateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) MonitorGroup(ctx context.Context, in *MonitorGroup_Request, opts ...grpc.CallOption) (ProtocolService_MonitorGroupClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[3], "/berty.protocol.v1.ProtocolService/MonitorGroup", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceMonitorGroupClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_MonitorGroupClient interface {
	Recv() (*MonitorGroup_Reply, error)
	grpc.ClientStream
}

type protocolServiceMonitorGroupClient struct {
	grpc.ClientStream
}

func (x *protocolServiceMonitorGroupClient) Recv() (*MonitorGroup_Reply, error) {
	m := new(MonitorGroup_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) DebugListGroups(ctx context.Context, in *DebugListGroups_Request, opts ...grpc.CallOption) (ProtocolService_DebugListGroupsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[4], "/berty.protocol.v1.ProtocolService/DebugListGroups", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceDebugListGroupsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_DebugListGroupsClient interface {
	Recv() (*DebugListGroups_Reply, error)
	grpc.ClientStream
}

type protocolServiceDebugListGroupsClient struct {
	grpc.ClientStream
}

func (x *protocolServiceDebugListGroupsClient) Recv() (*DebugListGroups_Reply, error) {
	m := new(DebugListGroups_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) DebugInspectGroupStore(ctx context.Context, in *DebugInspectGroupStore_Request, opts ...grpc.CallOption) (ProtocolService_DebugInspectGroupStoreClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[5], "/berty.protocol.v1.ProtocolService/DebugInspectGroupStore", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceDebugInspectGroupStoreClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_DebugInspectGroupStoreClient interface {
	Recv() (*DebugInspectGroupStore_Reply, error)
	grpc.ClientStream
}

type protocolServiceDebugInspectGroupStoreClient struct {
	grpc.ClientStream
}

func (x *protocolServiceDebugInspectGroupStoreClient) Recv() (*DebugInspectGroupStore_Reply, error) {
	m := new(DebugInspectGroupStore_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) DebugGroup(ctx context.Context, in *DebugGroup_Request, opts ...grpc.CallOption) (*DebugGroup_Reply, error) {
	out := new(DebugGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/DebugGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) DebugAuthServiceSetToken(ctx context.Context, in *DebugAuthServiceSetToken_Request, opts ...grpc.CallOption) (*DebugAuthServiceSetToken_Reply, error) {
	out := new(DebugAuthServiceSetToken_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/DebugAuthServiceSetToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) SystemInfo(ctx context.Context, in *SystemInfo_Request, opts ...grpc.CallOption) (*SystemInfo_Reply, error) {
	out := new(SystemInfo_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/SystemInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) AuthServiceInitFlow(ctx context.Context, in *AuthServiceInitFlow_Request, opts ...grpc.CallOption) (*AuthServiceInitFlow_Reply, error) {
	out := new(AuthServiceInitFlow_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/AuthServiceInitFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) AuthServiceCompleteFlow(ctx context.Context, in *AuthServiceCompleteFlow_Request, opts ...grpc.CallOption) (*AuthServiceCompleteFlow_Reply, error) {
	out := new(AuthServiceCompleteFlow_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/AuthServiceCompleteFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) ServicesTokenList(ctx context.Context, in *ServicesTokenList_Request, opts ...grpc.CallOption) (ProtocolService_ServicesTokenListClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[6], "/berty.protocol.v1.ProtocolService/ServicesTokenList", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceServicesTokenListClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_ServicesTokenListClient interface {
	Recv() (*ServicesTokenList_Reply, error)
	grpc.ClientStream
}

type protocolServiceServicesTokenListClient struct {
	grpc.ClientStream
}

func (x *protocolServiceServicesTokenListClient) Recv() (*ServicesTokenList_Reply, error) {
	m := new(ServicesTokenList_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) ReplicationServiceRegisterGroup(ctx context.Context, in *ReplicationServiceRegisterGroup_Request, opts ...grpc.CallOption) (*ReplicationServiceRegisterGroup_Reply, error) {
	out := new(ReplicationServiceRegisterGroup_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/ReplicationServiceRegisterGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) PeerList(ctx context.Context, in *PeerList_Request, opts ...grpc.CallOption) (*PeerList_Reply, error) {
	out := new(PeerList_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PeerList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) AttachmentPrepare(ctx context.Context, opts ...grpc.CallOption) (ProtocolService_AttachmentPrepareClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[7], "/berty.protocol.v1.ProtocolService/AttachmentPrepare", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceAttachmentPrepareClient{stream}
	return x, nil
}

type ProtocolService_AttachmentPrepareClient interface {
	Send(*AttachmentPrepare_Request) error
	CloseAndRecv() (*AttachmentPrepare_Reply, error)
	grpc.ClientStream
}

type protocolServiceAttachmentPrepareClient struct {
	grpc.ClientStream
}

func (x *protocolServiceAttachmentPrepareClient) Send(m *AttachmentPrepare_Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *protocolServiceAttachmentPrepareClient) CloseAndRecv() (*AttachmentPrepare_Reply, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(AttachmentPrepare_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) AttachmentRetrieve(ctx context.Context, in *AttachmentRetrieve_Request, opts ...grpc.CallOption) (ProtocolService_AttachmentRetrieveClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProtocolService_serviceDesc.Streams[8], "/berty.protocol.v1.ProtocolService/AttachmentRetrieve", opts...)
	if err != nil {
		return nil, err
	}
	x := &protocolServiceAttachmentRetrieveClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ProtocolService_AttachmentRetrieveClient interface {
	Recv() (*AttachmentRetrieve_Reply, error)
	grpc.ClientStream
}

type protocolServiceAttachmentRetrieveClient struct {
	grpc.ClientStream
}

func (x *protocolServiceAttachmentRetrieveClient) Recv() (*AttachmentRetrieve_Reply, error) {
	m := new(AttachmentRetrieve_Reply)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *protocolServiceClient) PushReceive(ctx context.Context, in *PushReceive_Request, opts ...grpc.CallOption) (*PushReceive_Reply, error) {
	out := new(PushReceive_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PushReceive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) PushSend(ctx context.Context, in *PushSend_Request, opts ...grpc.CallOption) (*PushSend_Reply, error) {
	out := new(PushSend_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PushSend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) PushShareToken(ctx context.Context, in *PushShareToken_Request, opts ...grpc.CallOption) (*PushShareToken_Reply, error) {
	out := new(PushShareToken_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PushShareToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) PushSetDeviceToken(ctx context.Context, in *PushSetDeviceToken_Request, opts ...grpc.CallOption) (*PushSetDeviceToken_Reply, error) {
	out := new(PushSetDeviceToken_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PushSetDeviceToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) PushSetServer(ctx context.Context, in *PushSetServer_Request, opts ...grpc.CallOption) (*PushSetServer_Reply, error) {
	out := new(PushSetServer_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/PushSetServer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *protocolServiceClient) RefreshContactRequest(ctx context.Context, in *RefreshContactRequest_Request, opts ...grpc.CallOption) (*RefreshContactRequest_Reply, error) {
	out := new(RefreshContactRequest_Reply)
	err := c.cc.Invoke(ctx, "/berty.protocol.v1.ProtocolService/RefreshContactRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProtocolServiceServer is the server API for ProtocolService service.
type ProtocolServiceServer interface {
	// InstanceExportData exports instance data
	InstanceExportData(*InstanceExportData_Request, ProtocolService_InstanceExportDataServer) error
	// InstanceGetConfiguration gets current configuration of this protocol instance
	InstanceGetConfiguration(context.Context, *InstanceGetConfiguration_Request) (*InstanceGetConfiguration_Reply, error)
	// ContactRequestReference retrieves the information required to create a reference (ie. included in a shareable link) to the current account
	ContactRequestReference(context.Context, *ContactRequestReference_Request) (*ContactRequestReference_Reply, error)
	// ContactRequestDisable disables incoming contact requests
	ContactRequestDisable(context.Context, *ContactRequestDisable_Request) (*ContactRequestDisable_Reply, error)
	// ContactRequestEnable enables incoming contact requests
	ContactRequestEnable(context.Context, *ContactRequestEnable_Request) (*ContactRequestEnable_Reply, error)
	// ContactRequestResetReference changes the contact request reference
	ContactRequestResetReference(context.Context, *ContactRequestResetReference_Request) (*ContactRequestResetReference_Reply, error)
	// ContactRequestSend attempt to send a contact request
	ContactRequestSend(context.Context, *ContactRequestSend_Request) (*ContactRequestSend_Reply, error)
	// ContactRequestAccept accepts a contact request
	ContactRequestAccept(context.Context, *ContactRequestAccept_Request) (*ContactRequestAccept_Reply, error)
	// ContactRequestDiscard ignores a contact request, without informing the other user
	ContactRequestDiscard(context.Context, *ContactRequestDiscard_Request) (*ContactRequestDiscard_Reply, error)
	// ContactBlock blocks a contact from sending requests
	ContactBlock(context.Context, *ContactBlock_Request) (*ContactBlock_Reply, error)
	// ContactUnblock unblocks a contact from sending requests
	ContactUnblock(context.Context, *ContactUnblock_Request) (*ContactUnblock_Reply, error)
	// ContactAliasKeySend send an alias key to a contact, the contact will be able to assert that your account is being present on a multi-member group
	ContactAliasKeySend(context.Context, *ContactAliasKeySend_Request) (*ContactAliasKeySend_Reply, error)
	// MultiMemberGroupCreate creates a new multi-member group
	MultiMemberGroupCreate(context.Context, *MultiMemberGroupCreate_Request) (*MultiMemberGroupCreate_Reply, error)
	// MultiMemberGroupJoin joins a multi-member group
	MultiMemberGroupJoin(context.Context, *MultiMemberGroupJoin_Request) (*MultiMemberGroupJoin_Reply, error)
	// MultiMemberGroupLeave leaves a multi-member group
	MultiMemberGroupLeave(context.Context, *MultiMemberGroupLeave_Request) (*MultiMemberGroupLeave_Reply, error)
	// MultiMemberGroupAliasResolverDisclose discloses your alias resolver key
	MultiMemberGroupAliasResolverDisclose(context.Context, *MultiMemberGroupAliasResolverDisclose_Request) (*MultiMemberGroupAliasResolverDisclose_Reply, error)
	// MultiMemberGroupAdminRoleGrant grants an admin role to a group member
	MultiMemberGroupAdminRoleGrant(context.Context, *MultiMemberGroupAdminRoleGrant_Request) (*MultiMemberGroupAdminRoleGrant_Reply, error)
	// MultiMemberGroupInvitationCreate creates an invitation to a multi-member group
	MultiMemberGroupInvitationCreate(context.Context, *MultiMemberGroupInvitationCreate_Request) (*MultiMemberGroupInvitationCreate_Reply, error)
	// AppMetadataSend adds an app event to the metadata store, the message is encrypted using a symmetric key and readable by future group members
	AppMetadataSend(context.Context, *AppMetadataSend_Request) (*AppMetadataSend_Reply, error)
	// AppMessageSend adds an app event to the message store, the message is encrypted using a derived key and readable by current group members
	AppMessageSend(context.Context, *AppMessageSend_Request) (*AppMessageSend_Reply, error)
	// GroupMetadataList replays previous and subscribes to new metadata events from the group
	GroupMetadataList(*GroupMetadataList_Request, ProtocolService_GroupMetadataListServer) error
	// GroupMessageList replays previous and subscribes to new message events from the group
	GroupMessageList(*GroupMessageList_Request, ProtocolService_GroupMessageListServer) error
	// GroupInfo retrieves information about a group
	GroupInfo(context.Context, *GroupInfo_Request) (*GroupInfo_Reply, error)
	// ActivateGroup explicitly opens a group
	ActivateGroup(context.Context, *ActivateGroup_Request) (*ActivateGroup_Reply, error)
	// DeactivateGroup closes a group
	DeactivateGroup(context.Context, *DeactivateGroup_Request) (*DeactivateGroup_Reply, error)
	// Monitor Group events
	MonitorGroup(*MonitorGroup_Request, ProtocolService_MonitorGroupServer) error
	DebugListGroups(*DebugListGroups_Request, ProtocolService_DebugListGroupsServer) error
	DebugInspectGroupStore(*DebugInspectGroupStore_Request, ProtocolService_DebugInspectGroupStoreServer) error
	DebugGroup(context.Context, *DebugGroup_Request) (*DebugGroup_Reply, error)
	DebugAuthServiceSetToken(context.Context, *DebugAuthServiceSetToken_Request) (*DebugAuthServiceSetToken_Reply, error)
	SystemInfo(context.Context, *SystemInfo_Request) (*SystemInfo_Reply, error)
	// AuthServiceInitFlow Initialize an authentication flow
	AuthServiceInitFlow(context.Context, *AuthServiceInitFlow_Request) (*AuthServiceInitFlow_Reply, error)
	// AuthServiceCompleteFlow Completes an authentication flow
	AuthServiceCompleteFlow(context.Context, *AuthServiceCompleteFlow_Request) (*AuthServiceCompleteFlow_Reply, error)
	// ServicesTokenList Retrieves the list of services tokens
	ServicesTokenList(*ServicesTokenList_Request, ProtocolService_ServicesTokenListServer) error
	// ReplicationServiceRegisterGroup Asks a replication service to distribute a group contents
	ReplicationServiceRegisterGroup(context.Context, *ReplicationServiceRegisterGroup_Request) (*ReplicationServiceRegisterGroup_Reply, error)
	// PeerList returns a list of P2P peers
	PeerList(context.Context, *PeerList_Request) (*PeerList_Reply, error)
	// AttachmentPrepare ...
	AttachmentPrepare(ProtocolService_AttachmentPrepareServer) error
	// AttachmentRetrieve returns an attachment data
	AttachmentRetrieve(*AttachmentRetrieve_Request, ProtocolService_AttachmentRetrieveServer) error
	// PushReceive handles a push payload, decrypts it if possible
	PushReceive(context.Context, *PushReceive_Request) (*PushReceive_Reply, error)
	// PushSend sends a push payload to a specified list of group members
	PushSend(context.Context, *PushSend_Request) (*PushSend_Reply, error)
	// PushShareToken sends push tokens of own devices to a group
	PushShareToken(context.Context, *PushShareToken_Request) (*PushShareToken_Reply, error)
	// PushSetDeviceToken registers a push token for the current device
	PushSetDeviceToken(context.Context, *PushSetDeviceToken_Request) (*PushSetDeviceToken_Reply, error)
	// PushSetServer registers a push server for the current device
	PushSetServer(context.Context, *PushSetServer_Request) (*PushSetServer_Reply, error)
	// RefreshContactRequest try to refresh the contact request for the given contact
	RefreshContactRequest(context.Context, *RefreshContactRequest_Request) (*RefreshContactRequest_Reply, error)
}

// UnimplementedProtocolServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProtocolServiceServer struct{}

func (*UnimplementedProtocolServiceServer) InstanceExportData(req *InstanceExportData_Request, srv ProtocolService_InstanceExportDataServer) error {
	return status.Errorf(codes.Unimplemented, "method InstanceExportData not implemented")
}

func (*UnimplementedProtocolServiceServer) InstanceGetConfiguration(ctx context.Context, req *InstanceGetConfiguration_Request) (*InstanceGetConfiguration_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstanceGetConfiguration not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestReference(ctx context.Context, req *ContactRequestReference_Request) (*ContactRequestReference_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestReference not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestDisable(ctx context.Context, req *ContactRequestDisable_Request) (*ContactRequestDisable_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestDisable not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestEnable(ctx context.Context, req *ContactRequestEnable_Request) (*ContactRequestEnable_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestEnable not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestResetReference(ctx context.Context, req *ContactRequestResetReference_Request) (*ContactRequestResetReference_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestResetReference not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestSend(ctx context.Context, req *ContactRequestSend_Request) (*ContactRequestSend_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestSend not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestAccept(ctx context.Context, req *ContactRequestAccept_Request) (*ContactRequestAccept_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestAccept not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactRequestDiscard(ctx context.Context, req *ContactRequestDiscard_Request) (*ContactRequestDiscard_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactRequestDiscard not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactBlock(ctx context.Context, req *ContactBlock_Request) (*ContactBlock_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactBlock not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactUnblock(ctx context.Context, req *ContactUnblock_Request) (*ContactUnblock_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactUnblock not implemented")
}

func (*UnimplementedProtocolServiceServer) ContactAliasKeySend(ctx context.Context, req *ContactAliasKeySend_Request) (*ContactAliasKeySend_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContactAliasKeySend not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupCreate(ctx context.Context, req *MultiMemberGroupCreate_Request) (*MultiMemberGroupCreate_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupCreate not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupJoin(ctx context.Context, req *MultiMemberGroupJoin_Request) (*MultiMemberGroupJoin_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupJoin not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupLeave(ctx context.Context, req *MultiMemberGroupLeave_Request) (*MultiMemberGroupLeave_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupLeave not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupAliasResolverDisclose(ctx context.Context, req *MultiMemberGroupAliasResolverDisclose_Request) (*MultiMemberGroupAliasResolverDisclose_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupAliasResolverDisclose not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupAdminRoleGrant(ctx context.Context, req *MultiMemberGroupAdminRoleGrant_Request) (*MultiMemberGroupAdminRoleGrant_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupAdminRoleGrant not implemented")
}

func (*UnimplementedProtocolServiceServer) MultiMemberGroupInvitationCreate(ctx context.Context, req *MultiMemberGroupInvitationCreate_Request) (*MultiMemberGroupInvitationCreate_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MultiMemberGroupInvitationCreate not implemented")
}

func (*UnimplementedProtocolServiceServer) AppMetadataSend(ctx context.Context, req *AppMetadataSend_Request) (*AppMetadataSend_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AppMetadataSend not implemented")
}

func (*UnimplementedProtocolServiceServer) AppMessageSend(ctx context.Context, req *AppMessageSend_Request) (*AppMessageSend_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AppMessageSend not implemented")
}

func (*UnimplementedProtocolServiceServer) GroupMetadataList(req *GroupMetadataList_Request, srv ProtocolService_GroupMetadataListServer) error {
	return status.Errorf(codes.Unimplemented, "method GroupMetadataList not implemented")
}

func (*UnimplementedProtocolServiceServer) GroupMessageList(req *GroupMessageList_Request, srv ProtocolService_GroupMessageListServer) error {
	return status.Errorf(codes.Unimplemented, "method GroupMessageList not implemented")
}

func (*UnimplementedProtocolServiceServer) GroupInfo(ctx context.Context, req *GroupInfo_Request) (*GroupInfo_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupInfo not implemented")
}

func (*UnimplementedProtocolServiceServer) ActivateGroup(ctx context.Context, req *ActivateGroup_Request) (*ActivateGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateGroup not implemented")
}

func (*UnimplementedProtocolServiceServer) DeactivateGroup(ctx context.Context, req *DeactivateGroup_Request) (*DeactivateGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeactivateGroup not implemented")
}

func (*UnimplementedProtocolServiceServer) MonitorGroup(req *MonitorGroup_Request, srv ProtocolService_MonitorGroupServer) error {
	return status.Errorf(codes.Unimplemented, "method MonitorGroup not implemented")
}

func (*UnimplementedProtocolServiceServer) DebugListGroups(req *DebugListGroups_Request, srv ProtocolService_DebugListGroupsServer) error {
	return status.Errorf(codes.Unimplemented, "method DebugListGroups not implemented")
}

func (*UnimplementedProtocolServiceServer) DebugInspectGroupStore(req *DebugInspectGroupStore_Request, srv ProtocolService_DebugInspectGroupStoreServer) error {
	return status.Errorf(codes.Unimplemented, "method DebugInspectGroupStore not implemented")
}

func (*UnimplementedProtocolServiceServer) DebugGroup(ctx context.Context, req *DebugGroup_Request) (*DebugGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DebugGroup not implemented")
}

func (*UnimplementedProtocolServiceServer) DebugAuthServiceSetToken(ctx context.Context, req *DebugAuthServiceSetToken_Request) (*DebugAuthServiceSetToken_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DebugAuthServiceSetToken not implemented")
}

func (*UnimplementedProtocolServiceServer) SystemInfo(ctx context.Context, req *SystemInfo_Request) (*SystemInfo_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SystemInfo not implemented")
}

func (*UnimplementedProtocolServiceServer) AuthServiceInitFlow(ctx context.Context, req *AuthServiceInitFlow_Request) (*AuthServiceInitFlow_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuthServiceInitFlow not implemented")
}

func (*UnimplementedProtocolServiceServer) AuthServiceCompleteFlow(ctx context.Context, req *AuthServiceCompleteFlow_Request) (*AuthServiceCompleteFlow_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuthServiceCompleteFlow not implemented")
}

func (*UnimplementedProtocolServiceServer) ServicesTokenList(req *ServicesTokenList_Request, srv ProtocolService_ServicesTokenListServer) error {
	return status.Errorf(codes.Unimplemented, "method ServicesTokenList not implemented")
}

func (*UnimplementedProtocolServiceServer) ReplicationServiceRegisterGroup(ctx context.Context, req *ReplicationServiceRegisterGroup_Request) (*ReplicationServiceRegisterGroup_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicationServiceRegisterGroup not implemented")
}

func (*UnimplementedProtocolServiceServer) PeerList(ctx context.Context, req *PeerList_Request) (*PeerList_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeerList not implemented")
}

func (*UnimplementedProtocolServiceServer) AttachmentPrepare(srv ProtocolService_AttachmentPrepareServer) error {
	return status.Errorf(codes.Unimplemented, "method AttachmentPrepare not implemented")
}

func (*UnimplementedProtocolServiceServer) AttachmentRetrieve(req *AttachmentRetrieve_Request, srv ProtocolService_AttachmentRetrieveServer) error {
	return status.Errorf(codes.Unimplemented, "method AttachmentRetrieve not implemented")
}

func (*UnimplementedProtocolServiceServer) PushReceive(ctx context.Context, req *PushReceive_Request) (*PushReceive_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushReceive not implemented")
}

func (*UnimplementedProtocolServiceServer) PushSend(ctx context.Context, req *PushSend_Request) (*PushSend_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushSend not implemented")
}

func (*UnimplementedProtocolServiceServer) PushShareToken(ctx context.Context, req *PushShareToken_Request) (*PushShareToken_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushShareToken not implemented")
}

func (*UnimplementedProtocolServiceServer) PushSetDeviceToken(ctx context.Context, req *PushSetDeviceToken_Request) (*PushSetDeviceToken_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushSetDeviceToken not implemented")
}

func (*UnimplementedProtocolServiceServer) PushSetServer(ctx context.Context, req *PushSetServer_Request) (*PushSetServer_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushSetServer not implemented")
}

func (*UnimplementedProtocolServiceServer) RefreshContactRequest(ctx context.Context, req *RefreshContactRequest_Request) (*RefreshContactRequest_Reply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshContactRequest not implemented")
}

func RegisterProtocolServiceServer(s *grpc.Server, srv ProtocolServiceServer) {
	s.RegisterService(&_ProtocolService_serviceDesc, srv)
}

func _ProtocolService_InstanceExportData_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InstanceExportData_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).InstanceExportData(m, &protocolServiceInstanceExportDataServer{stream})
}

type ProtocolService_InstanceExportDataServer interface {
	Send(*InstanceExportData_Reply) error
	grpc.ServerStream
}

type protocolServiceInstanceExportDataServer struct {
	grpc.ServerStream
}

func (x *protocolServiceInstanceExportDataServer) Send(m *InstanceExportData_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_InstanceGetConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstanceGetConfiguration_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).InstanceGetConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/InstanceGetConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).InstanceGetConfiguration(ctx, req.(*InstanceGetConfiguration_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestReference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestReference_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestReference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestReference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestReference(ctx, req.(*ContactRequestReference_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestDisable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestDisable_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestDisable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestDisable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestDisable(ctx, req.(*ContactRequestDisable_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestEnable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestEnable_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestEnable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestEnable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestEnable(ctx, req.(*ContactRequestEnable_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestResetReference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestResetReference_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestResetReference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestResetReference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestResetReference(ctx, req.(*ContactRequestResetReference_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestSend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestSend_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestSend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestSend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestSend(ctx, req.(*ContactRequestSend_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestAccept_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestAccept_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestAccept(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestAccept",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestAccept(ctx, req.(*ContactRequestAccept_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactRequestDiscard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactRequestDiscard_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactRequestDiscard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactRequestDiscard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactRequestDiscard(ctx, req.(*ContactRequestDiscard_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactBlock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactBlock_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactBlock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactBlock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactBlock(ctx, req.(*ContactBlock_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactUnblock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactUnblock_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactUnblock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactUnblock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactUnblock(ctx, req.(*ContactUnblock_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ContactAliasKeySend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactAliasKeySend_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ContactAliasKeySend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ContactAliasKeySend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ContactAliasKeySend(ctx, req.(*ContactAliasKeySend_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupCreate_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupCreate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupCreate(ctx, req.(*MultiMemberGroupCreate_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupJoin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupJoin_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupJoin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupJoin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupJoin(ctx, req.(*MultiMemberGroupJoin_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupLeave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupLeave_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupLeave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupLeave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupLeave(ctx, req.(*MultiMemberGroupLeave_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupAliasResolverDisclose_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupAliasResolverDisclose_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupAliasResolverDisclose(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupAliasResolverDisclose",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupAliasResolverDisclose(ctx, req.(*MultiMemberGroupAliasResolverDisclose_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupAdminRoleGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupAdminRoleGrant_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupAdminRoleGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupAdminRoleGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupAdminRoleGrant(ctx, req.(*MultiMemberGroupAdminRoleGrant_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MultiMemberGroupInvitationCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MultiMemberGroupInvitationCreate_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).MultiMemberGroupInvitationCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/MultiMemberGroupInvitationCreate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).MultiMemberGroupInvitationCreate(ctx, req.(*MultiMemberGroupInvitationCreate_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_AppMetadataSend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AppMetadataSend_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).AppMetadataSend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/AppMetadataSend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).AppMetadataSend(ctx, req.(*AppMetadataSend_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_AppMessageSend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AppMessageSend_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).AppMessageSend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/AppMessageSend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).AppMessageSend(ctx, req.(*AppMessageSend_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_GroupMetadataList_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GroupMetadataList_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).GroupMetadataList(m, &protocolServiceGroupMetadataListServer{stream})
}

type ProtocolService_GroupMetadataListServer interface {
	Send(*GroupMetadataEvent) error
	grpc.ServerStream
}

type protocolServiceGroupMetadataListServer struct {
	grpc.ServerStream
}

func (x *protocolServiceGroupMetadataListServer) Send(m *GroupMetadataEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_GroupMessageList_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GroupMessageList_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).GroupMessageList(m, &protocolServiceGroupMessageListServer{stream})
}

type ProtocolService_GroupMessageListServer interface {
	Send(*GroupMessageEvent) error
	grpc.ServerStream
}

type protocolServiceGroupMessageListServer struct {
	grpc.ServerStream
}

func (x *protocolServiceGroupMessageListServer) Send(m *GroupMessageEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_GroupInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupInfo_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).GroupInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/GroupInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).GroupInfo(ctx, req.(*GroupInfo_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ActivateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ActivateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ActivateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ActivateGroup(ctx, req.(*ActivateGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_DeactivateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeactivateGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).DeactivateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/DeactivateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).DeactivateGroup(ctx, req.(*DeactivateGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_MonitorGroup_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(MonitorGroup_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).MonitorGroup(m, &protocolServiceMonitorGroupServer{stream})
}

type ProtocolService_MonitorGroupServer interface {
	Send(*MonitorGroup_Reply) error
	grpc.ServerStream
}

type protocolServiceMonitorGroupServer struct {
	grpc.ServerStream
}

func (x *protocolServiceMonitorGroupServer) Send(m *MonitorGroup_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_DebugListGroups_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DebugListGroups_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).DebugListGroups(m, &protocolServiceDebugListGroupsServer{stream})
}

type ProtocolService_DebugListGroupsServer interface {
	Send(*DebugListGroups_Reply) error
	grpc.ServerStream
}

type protocolServiceDebugListGroupsServer struct {
	grpc.ServerStream
}

func (x *protocolServiceDebugListGroupsServer) Send(m *DebugListGroups_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_DebugInspectGroupStore_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DebugInspectGroupStore_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).DebugInspectGroupStore(m, &protocolServiceDebugInspectGroupStoreServer{stream})
}

type ProtocolService_DebugInspectGroupStoreServer interface {
	Send(*DebugInspectGroupStore_Reply) error
	grpc.ServerStream
}

type protocolServiceDebugInspectGroupStoreServer struct {
	grpc.ServerStream
}

func (x *protocolServiceDebugInspectGroupStoreServer) Send(m *DebugInspectGroupStore_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_DebugGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).DebugGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/DebugGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).DebugGroup(ctx, req.(*DebugGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_DebugAuthServiceSetToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugAuthServiceSetToken_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).DebugAuthServiceSetToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/DebugAuthServiceSetToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).DebugAuthServiceSetToken(ctx, req.(*DebugAuthServiceSetToken_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_SystemInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SystemInfo_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).SystemInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/SystemInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).SystemInfo(ctx, req.(*SystemInfo_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_AuthServiceInitFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthServiceInitFlow_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).AuthServiceInitFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/AuthServiceInitFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).AuthServiceInitFlow(ctx, req.(*AuthServiceInitFlow_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_AuthServiceCompleteFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthServiceCompleteFlow_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).AuthServiceCompleteFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/AuthServiceCompleteFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).AuthServiceCompleteFlow(ctx, req.(*AuthServiceCompleteFlow_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_ServicesTokenList_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ServicesTokenList_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).ServicesTokenList(m, &protocolServiceServicesTokenListServer{stream})
}

type ProtocolService_ServicesTokenListServer interface {
	Send(*ServicesTokenList_Reply) error
	grpc.ServerStream
}

type protocolServiceServicesTokenListServer struct {
	grpc.ServerStream
}

func (x *protocolServiceServicesTokenListServer) Send(m *ServicesTokenList_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_ReplicationServiceRegisterGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicationServiceRegisterGroup_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).ReplicationServiceRegisterGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/ReplicationServiceRegisterGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).ReplicationServiceRegisterGroup(ctx, req.(*ReplicationServiceRegisterGroup_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_PeerList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeerList_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PeerList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PeerList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PeerList(ctx, req.(*PeerList_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_AttachmentPrepare_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ProtocolServiceServer).AttachmentPrepare(&protocolServiceAttachmentPrepareServer{stream})
}

type ProtocolService_AttachmentPrepareServer interface {
	SendAndClose(*AttachmentPrepare_Reply) error
	Recv() (*AttachmentPrepare_Request, error)
	grpc.ServerStream
}

type protocolServiceAttachmentPrepareServer struct {
	grpc.ServerStream
}

func (x *protocolServiceAttachmentPrepareServer) SendAndClose(m *AttachmentPrepare_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func (x *protocolServiceAttachmentPrepareServer) Recv() (*AttachmentPrepare_Request, error) {
	m := new(AttachmentPrepare_Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ProtocolService_AttachmentRetrieve_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(AttachmentRetrieve_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProtocolServiceServer).AttachmentRetrieve(m, &protocolServiceAttachmentRetrieveServer{stream})
}

type ProtocolService_AttachmentRetrieveServer interface {
	Send(*AttachmentRetrieve_Reply) error
	grpc.ServerStream
}

type protocolServiceAttachmentRetrieveServer struct {
	grpc.ServerStream
}

func (x *protocolServiceAttachmentRetrieveServer) Send(m *AttachmentRetrieve_Reply) error {
	return x.ServerStream.SendMsg(m)
}

func _ProtocolService_PushReceive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushReceive_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PushReceive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PushReceive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PushReceive(ctx, req.(*PushReceive_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_PushSend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushSend_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PushSend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PushSend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PushSend(ctx, req.(*PushSend_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_PushShareToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushShareToken_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PushShareToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PushShareToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PushShareToken(ctx, req.(*PushShareToken_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_PushSetDeviceToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushSetDeviceToken_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PushSetDeviceToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PushSetDeviceToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PushSetDeviceToken(ctx, req.(*PushSetDeviceToken_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_PushSetServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushSetServer_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).PushSetServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/PushSetServer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).PushSetServer(ctx, req.(*PushSetServer_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProtocolService_RefreshContactRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshContactRequest_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProtocolServiceServer).RefreshContactRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/berty.protocol.v1.ProtocolService/RefreshContactRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProtocolServiceServer).RefreshContactRequest(ctx, req.(*RefreshContactRequest_Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProtocolService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "berty.protocol.v1.ProtocolService",
	HandlerType: (*ProtocolServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InstanceGetConfiguration",
			Handler:    _ProtocolService_InstanceGetConfiguration_Handler,
		},
		{
			MethodName: "ContactRequestReference",
			Handler:    _ProtocolService_ContactRequestReference_Handler,
		},
		{
			MethodName: "ContactRequestDisable",
			Handler:    _ProtocolService_ContactRequestDisable_Handler,
		},
		{
			MethodName: "ContactRequestEnable",
			Handler:    _ProtocolService_ContactRequestEnable_Handler,
		},
		{
			MethodName: "ContactRequestResetReference",
			Handler:    _ProtocolService_ContactRequestResetReference_Handler,
		},
		{
			MethodName: "ContactRequestSend",
			Handler:    _ProtocolService_ContactRequestSend_Handler,
		},
		{
			MethodName: "ContactRequestAccept",
			Handler:    _ProtocolService_ContactRequestAccept_Handler,
		},
		{
			MethodName: "ContactRequestDiscard",
			Handler:    _ProtocolService_ContactRequestDiscard_Handler,
		},
		{
			MethodName: "ContactBlock",
			Handler:    _ProtocolService_ContactBlock_Handler,
		},
		{
			MethodName: "ContactUnblock",
			Handler:    _ProtocolService_ContactUnblock_Handler,
		},
		{
			MethodName: "ContactAliasKeySend",
			Handler:    _ProtocolService_ContactAliasKeySend_Handler,
		},
		{
			MethodName: "MultiMemberGroupCreate",
			Handler:    _ProtocolService_MultiMemberGroupCreate_Handler,
		},
		{
			MethodName: "MultiMemberGroupJoin",
			Handler:    _ProtocolService_MultiMemberGroupJoin_Handler,
		},
		{
			MethodName: "MultiMemberGroupLeave",
			Handler:    _ProtocolService_MultiMemberGroupLeave_Handler,
		},
		{
			MethodName: "MultiMemberGroupAliasResolverDisclose",
			Handler:    _ProtocolService_MultiMemberGroupAliasResolverDisclose_Handler,
		},
		{
			MethodName: "MultiMemberGroupAdminRoleGrant",
			Handler:    _ProtocolService_MultiMemberGroupAdminRoleGrant_Handler,
		},
		{
			MethodName: "MultiMemberGroupInvitationCreate",
			Handler:    _ProtocolService_MultiMemberGroupInvitationCreate_Handler,
		},
		{
			MethodName: "AppMetadataSend",
			Handler:    _ProtocolService_AppMetadataSend_Handler,
		},
		{
			MethodName: "AppMessageSend",
			Handler:    _ProtocolService_AppMessageSend_Handler,
		},
		{
			MethodName: "GroupInfo",
			Handler:    _ProtocolService_GroupInfo_Handler,
		},
		{
			MethodName: "ActivateGroup",
			Handler:    _ProtocolService_ActivateGroup_Handler,
		},
		{
			MethodName: "DeactivateGroup",
			Handler:    _ProtocolService_DeactivateGroup_Handler,
		},
		{
			MethodName: "DebugGroup",
			Handler:    _ProtocolService_DebugGroup_Handler,
		},
		{
			MethodName: "DebugAuthServiceSetToken",
			Handler:    _ProtocolService_DebugAuthServiceSetToken_Handler,
		},
		{
			MethodName: "SystemInfo",
			Handler:    _ProtocolService_SystemInfo_Handler,
		},
		{
			MethodName: "AuthServiceInitFlow",
			Handler:    _ProtocolService_AuthServiceInitFlow_Handler,
		},
		{
			MethodName: "AuthServiceCompleteFlow",
			Handler:    _ProtocolService_AuthServiceCompleteFlow_Handler,
		},
		{
			MethodName: "ReplicationServiceRegisterGroup",
			Handler:    _ProtocolService_ReplicationServiceRegisterGroup_Handler,
		},
		{
			MethodName: "PeerList",
			Handler:    _ProtocolService_PeerList_Handler,
		},
		{
			MethodName: "PushReceive",
			Handler:    _ProtocolService_PushReceive_Handler,
		},
		{
			MethodName: "PushSend",
			Handler:    _ProtocolService_PushSend_Handler,
		},
		{
			MethodName: "PushShareToken",
			Handler:    _ProtocolService_PushShareToken_Handler,
		},
		{
			MethodName: "PushSetDeviceToken",
			Handler:    _ProtocolService_PushSetDeviceToken_Handler,
		},
		{
			MethodName: "PushSetServer",
			Handler:    _ProtocolService_PushSetServer_Handler,
		},
		{
			MethodName: "RefreshContactRequest",
			Handler:    _ProtocolService_RefreshContactRequest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "InstanceExportData",
			Handler:       _ProtocolService_InstanceExportData_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GroupMetadataList",
			Handler:       _ProtocolService_GroupMetadataList_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GroupMessageList",
			Handler:       _ProtocolService_GroupMessageList_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "MonitorGroup",
			Handler:       _ProtocolService_MonitorGroup_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DebugListGroups",
			Handler:       _ProtocolService_DebugListGroups_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DebugInspectGroupStore",
			Handler:       _ProtocolService_DebugInspectGroupStore_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ServicesTokenList",
			Handler:       _ProtocolService_ServicesTokenList_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "AttachmentPrepare",
			Handler:       _ProtocolService_AttachmentPrepare_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "AttachmentRetrieve",
			Handler:       _ProtocolService_AttachmentRetrieve_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "protocoltypes.proto",
}

func (m *Account) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Account) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Account) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.AliasPrivateKey) > 0 {
		i -= len(m.AliasPrivateKey)
		copy(dAtA[i:], m.AliasPrivateKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AliasPrivateKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AccountPrivateKey) > 0 {
		i -= len(m.AccountPrivateKey)
		copy(dAtA[i:], m.AccountPrivateKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AccountPrivateKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Group) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Group) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Group) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LinkKeySig) > 0 {
		i -= len(m.LinkKeySig)
		copy(dAtA[i:], m.LinkKeySig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.LinkKeySig)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.LinkKey) > 0 {
		i -= len(m.LinkKey)
		copy(dAtA[i:], m.LinkKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.LinkKey)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.SignPub) > 0 {
		i -= len(m.SignPub)
		copy(dAtA[i:], m.SignPub)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SignPub)))
		i--
		dAtA[i] = 0x2a
	}
	if m.GroupType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.GroupType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SecretSig) > 0 {
		i -= len(m.SecretSig)
		copy(dAtA[i:], m.SecretSig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SecretSig)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Secret) > 0 {
		i -= len(m.Secret)
		copy(dAtA[i:], m.Secret)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Secret)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PublicKey) > 0 {
		i -= len(m.PublicKey)
		copy(dAtA[i:], m.PublicKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupHeadsExport) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupHeadsExport) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupHeadsExport) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LinkKey) > 0 {
		i -= len(m.LinkKey)
		copy(dAtA[i:], m.LinkKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.LinkKey)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.MessagesHeadsCIDs) > 0 {
		for iNdEx := len(m.MessagesHeadsCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MessagesHeadsCIDs[iNdEx])
			copy(dAtA[i:], m.MessagesHeadsCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MessagesHeadsCIDs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.MetadataHeadsCIDs) > 0 {
		for iNdEx := len(m.MetadataHeadsCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MetadataHeadsCIDs[iNdEx])
			copy(dAtA[i:], m.MetadataHeadsCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MetadataHeadsCIDs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SignPub) > 0 {
		i -= len(m.SignPub)
		copy(dAtA[i:], m.SignPub)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SignPub)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PublicKey) > 0 {
		i -= len(m.PublicKey)
		copy(dAtA[i:], m.PublicKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProtocolMetadata != nil {
		{
			size, err := m.ProtocolMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Sig) > 0 {
		i -= len(m.Sig)
		copy(dAtA[i:], m.Sig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Sig)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x12
	}
	if m.EventType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.EventType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GroupEnvelope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupEnvelope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupEnvelope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EncryptedAttachmentCIDs) > 0 {
		for iNdEx := len(m.EncryptedAttachmentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EncryptedAttachmentCIDs[iNdEx])
			copy(dAtA[i:], m.EncryptedAttachmentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.EncryptedAttachmentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Event) > 0 {
		i -= len(m.Event)
		copy(dAtA[i:], m.Event)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Event)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MessageHeaders) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MessageHeaders) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MessageHeaders) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metadata) > 0 {
		for k := range m.Metadata {
			v := m.Metadata[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintProtocoltypes(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Sig) > 0 {
		i -= len(m.Sig)
		copy(dAtA[i:], m.Sig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Sig)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if m.Counter != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Counter))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProtocolMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProtocolMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProtocolMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentsSecrets) > 0 {
		for iNdEx := len(m.AttachmentsSecrets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AttachmentsSecrets[iNdEx])
			copy(dAtA[i:], m.AttachmentsSecrets[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentsSecrets[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *EncryptedMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptedMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncryptedMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProtocolMetadata != nil {
		{
			size, err := m.ProtocolMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Plaintext) > 0 {
		i -= len(m.Plaintext)
		copy(dAtA[i:], m.Plaintext)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Plaintext)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MessageEnvelope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MessageEnvelope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MessageEnvelope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EncryptedAttachmentCIDs) > 0 {
		for iNdEx := len(m.EncryptedAttachmentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EncryptedAttachmentCIDs[iNdEx])
			copy(dAtA[i:], m.EncryptedAttachmentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.EncryptedAttachmentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MessageHeaders) > 0 {
		i -= len(m.MessageHeaders)
		copy(dAtA[i:], m.MessageHeaders)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MessageHeaders)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventContext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventContext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentCIDs) > 0 {
		for iNdEx := len(m.AttachmentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AttachmentCIDs[iNdEx])
			copy(dAtA[i:], m.AttachmentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ParentIDs) > 0 {
		for iNdEx := len(m.ParentIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ParentIDs[iNdEx])
			copy(dAtA[i:], m.ParentIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ParentIDs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AppMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactAddAliasKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactAddAliasKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactAddAliasKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AliasPK) > 0 {
		i -= len(m.AliasPK)
		copy(dAtA[i:], m.AliasPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AliasPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupAddMemberDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupAddMemberDevice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupAddMemberDevice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MemberSig) > 0 {
		i -= len(m.MemberSig)
		copy(dAtA[i:], m.MemberSig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberSig)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MemberPK) > 0 {
		i -= len(m.MemberPK)
		copy(dAtA[i:], m.MemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeviceSecret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeviceSecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeviceSecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Counter != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Counter))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ChainKey) > 0 {
		i -= len(m.ChainKey)
		copy(dAtA[i:], m.ChainKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ChainKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupAddDeviceSecret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupAddDeviceSecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupAddDeviceSecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DestMemberPK) > 0 {
		i -= len(m.DestMemberPK)
		copy(dAtA[i:], m.DestMemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DestMemberPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAddAliasResolver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAddAliasResolver) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAddAliasResolver) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AliasProof) > 0 {
		i -= len(m.AliasProof)
		copy(dAtA[i:], m.AliasProof)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AliasProof)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AliasResolver) > 0 {
		i -= len(m.AliasResolver)
		copy(dAtA[i:], m.AliasResolver)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AliasResolver)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGrantAdminRole) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGrantAdminRole) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGrantAdminRole) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GranteeMemberPK) > 0 {
		i -= len(m.GranteeMemberPK)
		copy(dAtA[i:], m.GranteeMemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GranteeMemberPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberInitialMember) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberInitialMember) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberInitialMember) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MemberPK) > 0 {
		i -= len(m.MemberPK)
		copy(dAtA[i:], m.MemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupAddAdditionalRendezvousSeed) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupAddAdditionalRendezvousSeed) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupAddAdditionalRendezvousSeed) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Seed) > 0 {
		i -= len(m.Seed)
		copy(dAtA[i:], m.Seed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Seed)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupRemoveAdditionalRendezvousSeed) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupRemoveAdditionalRendezvousSeed) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupRemoveAdditionalRendezvousSeed) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Seed) > 0 {
		i -= len(m.Seed)
		copy(dAtA[i:], m.Seed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Seed)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountGroupJoined) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountGroupJoined) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountGroupJoined) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountGroupLeft) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountGroupLeft) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountGroupLeft) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestDisabled) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestDisabled) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestDisabled) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestEnabled) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestEnabled) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestEnabled) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestReferenceReset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestReferenceReset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestReferenceReset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestEnqueued) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestEnqueued) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestEnqueued) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OwnMetadata) > 0 {
		i -= len(m.OwnMetadata)
		copy(dAtA[i:], m.OwnMetadata)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.OwnMetadata)))
		i--
		dAtA[i] = 0x22
	}
	if m.Contact != nil {
		{
			size, err := m.Contact.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestSent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestSent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestSent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestReceived) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestReceived) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestReceived) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactMetadata) > 0 {
		i -= len(m.ContactMetadata)
		copy(dAtA[i:], m.ContactMetadata)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactMetadata)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ContactRendezvousSeed) > 0 {
		i -= len(m.ContactRendezvousSeed)
		copy(dAtA[i:], m.ContactRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactRendezvousSeed)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestDiscarded) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestDiscarded) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestDiscarded) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactRequestAccepted) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactRequestAccepted) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactRequestAccepted) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactBlocked) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactBlocked) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactBlocked) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountContactUnblocked) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountContactUnblocked) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountContactUnblocked) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountServiceTokenAdded) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountServiceTokenAdded) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountServiceTokenAdded) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ServiceToken != nil {
		{
			size, err := m.ServiceToken.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccountServiceTokenRemoved) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccountServiceTokenRemoved) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccountServiceTokenRemoved) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.TokenID) > 0 {
		i -= len(m.TokenID)
		copy(dAtA[i:], m.TokenID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.TokenID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupReplicating) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupReplicating) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupReplicating) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ReplicationServer) > 0 {
		i -= len(m.ReplicationServer)
		copy(dAtA[i:], m.ReplicationServer)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ReplicationServer)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AuthenticationURL) > 0 {
		i -= len(m.AuthenticationURL)
		copy(dAtA[i:], m.AuthenticationURL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AuthenticationURL)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InstanceExportData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceExportData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceExportData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *InstanceExportData_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceExportData_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceExportData_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *InstanceExportData_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceExportData_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceExportData_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExportedData) > 0 {
		i -= len(m.ExportedData)
		copy(dAtA[i:], m.ExportedData)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ExportedData)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InstanceGetConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceGetConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceGetConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *InstanceGetConfiguration_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceGetConfiguration_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceGetConfiguration_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *InstanceGetConfiguration_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceGetConfiguration_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceGetConfiguration_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DevicePushServer != nil {
		{
			size, err := m.DevicePushServer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.DevicePushToken != nil {
		{
			size, err := m.DevicePushToken.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.RelayEnabled != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.RelayEnabled))
		i--
		dAtA[i] = 0x48
	}
	if m.MdnsEnabled != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.MdnsEnabled))
		i--
		dAtA[i] = 0x40
	}
	if m.WifiP2PEnabled != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.WifiP2PEnabled))
		i--
		dAtA[i] = 0x38
	}
	if m.BleEnabled != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.BleEnabled))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Listeners) > 0 {
		for iNdEx := len(m.Listeners) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Listeners[iNdEx])
			copy(dAtA[i:], m.Listeners[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Listeners[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.PeerID) > 0 {
		i -= len(m.PeerID)
		copy(dAtA[i:], m.PeerID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerID)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.AccountGroupPK) > 0 {
		i -= len(m.AccountGroupPK)
		copy(dAtA[i:], m.AccountGroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AccountGroupPK)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AccountPK) > 0 {
		i -= len(m.AccountPK)
		copy(dAtA[i:], m.AccountPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AccountPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestReference_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestReference_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestReference_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestReference_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestReference_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestReference_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDisable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDisable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDisable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDisable_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDisable_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDisable_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDisable_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDisable_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDisable_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestEnable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestEnable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestEnable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestEnable_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestEnable_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestEnable_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestEnable_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestEnable_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestEnable_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestResetReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestResetReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestResetReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestResetReference_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestResetReference_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestResetReference_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestResetReference_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestResetReference_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestResetReference_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestSend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestSend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestSend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestSend_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestSend_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestSend_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OwnMetadata) > 0 {
		i -= len(m.OwnMetadata)
		copy(dAtA[i:], m.OwnMetadata)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.OwnMetadata)))
		i--
		dAtA[i] = 0x12
	}
	if m.Contact != nil {
		{
			size, err := m.Contact.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestSend_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestSend_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestSend_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestAccept) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestAccept) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestAccept) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestAccept_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestAccept_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestAccept_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestAccept_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestAccept_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestAccept_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDiscard) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDiscard) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDiscard) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDiscard_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDiscard_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDiscard_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactRequestDiscard_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactRequestDiscard_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactRequestDiscard_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactBlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactBlock_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactBlock_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactBlock_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactBlock_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactBlock_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactBlock_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactUnblock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactUnblock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactUnblock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactUnblock_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactUnblock_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactUnblock_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactUnblock_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactUnblock_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactUnblock_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactAliasKeySend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactAliasKeySend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactAliasKeySend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ContactAliasKeySend_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactAliasKeySend_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactAliasKeySend_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContactAliasKeySend_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContactAliasKeySend_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContactAliasKeySend_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupCreate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupCreate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupCreate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupCreate_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupCreate_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupCreate_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupCreate_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupCreate_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupCreate_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupJoin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupJoin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupJoin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupJoin_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupJoin_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupJoin_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupJoin_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupJoin_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupJoin_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupLeave) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupLeave) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupLeave) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupLeave_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupLeave_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupLeave_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupLeave_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupLeave_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupLeave_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAliasResolverDisclose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAliasResolverDisclose) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAliasResolverDisclose) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAdminRoleGrant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAdminRoleGrant) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAdminRoleGrant) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAdminRoleGrant_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAdminRoleGrant_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAdminRoleGrant_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MemberPK) > 0 {
		i -= len(m.MemberPK)
		copy(dAtA[i:], m.MemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupInvitationCreate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupInvitationCreate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupInvitationCreate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupInvitationCreate_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupInvitationCreate_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupInvitationCreate_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiMemberGroupInvitationCreate_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiMemberGroupInvitationCreate_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiMemberGroupInvitationCreate_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AppMetadataSend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMetadataSend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMetadataSend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AppMetadataSend_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMetadataSend_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMetadataSend_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentCIDs) > 0 {
		for iNdEx := len(m.AttachmentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AttachmentCIDs[iNdEx])
			copy(dAtA[i:], m.AttachmentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AppMetadataSend_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMetadataSend_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMetadataSend_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CID) > 0 {
		i -= len(m.CID)
		copy(dAtA[i:], m.CID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AppMessageSend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMessageSend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMessageSend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AppMessageSend_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMessageSend_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMessageSend_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentCIDs) > 0 {
		for iNdEx := len(m.AttachmentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AttachmentCIDs[iNdEx])
			copy(dAtA[i:], m.AttachmentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AppMessageSend_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppMessageSend_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AppMessageSend_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CID) > 0 {
		i -= len(m.CID)
		copy(dAtA[i:], m.CID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMetadataEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMetadataEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMetadataEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Event) > 0 {
		i -= len(m.Event)
		copy(dAtA[i:], m.Event)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Event)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.EventContext != nil {
		{
			size, err := m.EventContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMessageEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMessageEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMessageEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Headers != nil {
		{
			size, err := m.Headers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.EventContext != nil {
		{
			size, err := m.EventContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMetadataList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMetadataList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMetadataList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *GroupMetadataList_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMetadataList_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMetadataList_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReverseOrder {
		i--
		if m.ReverseOrder {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.UntilNow {
		i--
		if m.UntilNow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.UntilID) > 0 {
		i -= len(m.UntilID)
		copy(dAtA[i:], m.UntilID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.UntilID)))
		i--
		dAtA[i] = 0x22
	}
	if m.SinceNow {
		i--
		if m.SinceNow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.SinceID) > 0 {
		i -= len(m.SinceID)
		copy(dAtA[i:], m.SinceID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SinceID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMessageList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMessageList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMessageList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *GroupMessageList_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMessageList_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMessageList_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReverseOrder {
		i--
		if m.ReverseOrder {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.UntilNow {
		i--
		if m.UntilNow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.UntilID) > 0 {
		i -= len(m.UntilID)
		copy(dAtA[i:], m.UntilID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.UntilID)))
		i--
		dAtA[i] = 0x22
	}
	if m.SinceNow {
		i--
		if m.SinceNow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.SinceID) > 0 {
		i -= len(m.SinceID)
		copy(dAtA[i:], m.SinceID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SinceID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *GroupInfo_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupInfo_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupInfo_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupInfo_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupInfo_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupInfo_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.MemberPK) > 0 {
		i -= len(m.MemberPK)
		copy(dAtA[i:], m.MemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberPK)))
		i--
		dAtA[i] = 0x12
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ActivateGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivateGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivateGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ActivateGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivateGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivateGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LocalOnly {
		i--
		if m.LocalOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ActivateGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivateGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivateGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DeactivateGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeactivateGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeactivateGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DeactivateGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeactivateGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeactivateGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeactivateGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeactivateGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeactivateGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DriverName) > 0 {
		i -= len(m.DriverName)
		copy(dAtA[i:], m.DriverName)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DriverName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Maddrs) > 0 {
		for iNdEx := len(m.Maddrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Maddrs[iNdEx])
			copy(dAtA[i:], m.Maddrs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Maddrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PeerID) > 0 {
		i -= len(m.PeerID)
		copy(dAtA[i:], m.PeerID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_EventMonitorPeerFound) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_EventMonitorPeerFound) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_EventMonitorPeerFound) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DriverName) > 0 {
		i -= len(m.DriverName)
		copy(dAtA[i:], m.DriverName)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DriverName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Maddrs) > 0 {
		for iNdEx := len(m.Maddrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Maddrs[iNdEx])
			copy(dAtA[i:], m.Maddrs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Maddrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PeerID) > 0 {
		i -= len(m.PeerID)
		copy(dAtA[i:], m.PeerID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_EventMonitorPeerJoin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_EventMonitorPeerJoin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_EventMonitorPeerJoin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsSelf {
		i--
		if m.IsSelf {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Maddrs) > 0 {
		for iNdEx := len(m.Maddrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Maddrs[iNdEx])
			copy(dAtA[i:], m.Maddrs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Maddrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PeerID) > 0 {
		i -= len(m.PeerID)
		copy(dAtA[i:], m.PeerID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_EventMonitorPeerLeave) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_EventMonitorPeerLeave) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_EventMonitorPeerLeave) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsSelf {
		i--
		if m.IsSelf {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PeerID) > 0 {
		i -= len(m.PeerID)
		copy(dAtA[i:], m.PeerID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_EventMonitor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_EventMonitor) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_EventMonitor) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PeerLeave != nil {
		{
			size, err := m.PeerLeave.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.PeerJoin != nil {
		{
			size, err := m.PeerJoin.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.PeerFound != nil {
		{
			size, err := m.PeerFound.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.AdvertiseGroup != nil {
		{
			size, err := m.AdvertiseGroup.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MonitorGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MonitorGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MonitorGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x12
	}
	if m.Event != nil {
		{
			size, err := m.Event.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugListGroups) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugListGroups) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugListGroups) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DebugListGroups_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugListGroups_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugListGroups_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DebugListGroups_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugListGroups_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugListGroups_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0x1a
	}
	if m.GroupType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.GroupType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugInspectGroupStore) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugInspectGroupStore) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugInspectGroupStore) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DebugInspectGroupStore_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugInspectGroupStore_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugInspectGroupStore_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LogType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.LogType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugInspectGroupStore_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugInspectGroupStore_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugInspectGroupStore_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x22
	}
	if m.MetadataEventType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.MetadataEventType))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ParentCIDs) > 0 {
		for iNdEx := len(m.ParentCIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ParentCIDs[iNdEx])
			copy(dAtA[i:], m.ParentCIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ParentCIDs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.CID) > 0 {
		i -= len(m.CID)
		copy(dAtA[i:], m.CID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DebugGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PeerIDs) > 0 {
		for iNdEx := len(m.PeerIDs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PeerIDs[iNdEx])
			copy(dAtA[i:], m.PeerIDs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PeerIDs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AuthExchangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthExchangeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthExchangeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Services) > 0 {
		for k := range m.Services {
			v := m.Services[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintProtocoltypes(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ErrorDescription) > 0 {
		i -= len(m.ErrorDescription)
		copy(dAtA[i:], m.ErrorDescription)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ErrorDescription)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Scope) > 0 {
		i -= len(m.Scope)
		copy(dAtA[i:], m.Scope)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Scope)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AccessToken) > 0 {
		i -= len(m.AccessToken)
		copy(dAtA[i:], m.AccessToken)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AccessToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugAuthServiceSetToken) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugAuthServiceSetToken) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugAuthServiceSetToken) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *DebugAuthServiceSetToken_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugAuthServiceSetToken_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugAuthServiceSetToken_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AuthenticationURL) > 0 {
		i -= len(m.AuthenticationURL)
		copy(dAtA[i:], m.AuthenticationURL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AuthenticationURL)))
		i--
		dAtA[i] = 0x12
	}
	if m.Token != nil {
		{
			size, err := m.Token.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DebugAuthServiceSetToken_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DebugAuthServiceSetToken_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DebugAuthServiceSetToken_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ShareableContact) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShareableContact) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShareableContact) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metadata) > 0 {
		i -= len(m.Metadata)
		copy(dAtA[i:], m.Metadata)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Metadata)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PublicRendezvousSeed) > 0 {
		i -= len(m.PublicRendezvousSeed)
		copy(dAtA[i:], m.PublicRendezvousSeed)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PublicRendezvousSeed)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PK) > 0 {
		i -= len(m.PK)
		copy(dAtA[i:], m.PK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.PK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceTokenSupportedService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceTokenSupportedService) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceTokenSupportedService) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ServiceEndpoint) > 0 {
		i -= len(m.ServiceEndpoint)
		copy(dAtA[i:], m.ServiceEndpoint)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ServiceEndpoint)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ServiceType) > 0 {
		i -= len(m.ServiceType)
		copy(dAtA[i:], m.ServiceType)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ServiceType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceToken) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceToken) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceToken) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Expiration != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Expiration))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SupportedServices) > 0 {
		for iNdEx := len(m.SupportedServices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SupportedServices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.AuthenticationURL) > 0 {
		i -= len(m.AuthenticationURL)
		copy(dAtA[i:], m.AuthenticationURL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AuthenticationURL)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceCompleteFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceCompleteFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceCompleteFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceCompleteFlow_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceCompleteFlow_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceCompleteFlow_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CallbackURL) > 0 {
		i -= len(m.CallbackURL)
		copy(dAtA[i:], m.CallbackURL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CallbackURL)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceCompleteFlow_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceCompleteFlow_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceCompleteFlow_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.TokenID) > 0 {
		i -= len(m.TokenID)
		copy(dAtA[i:], m.TokenID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.TokenID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceInitFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceInitFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceInitFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceInitFlow_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceInitFlow_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceInitFlow_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Services) > 0 {
		for iNdEx := len(m.Services) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Services[iNdEx])
			copy(dAtA[i:], m.Services[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Services[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.AuthURL) > 0 {
		i -= len(m.AuthURL)
		copy(dAtA[i:], m.AuthURL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AuthURL)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthServiceInitFlow_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthServiceInitFlow_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthServiceInitFlow_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SecureURL {
		i--
		if m.SecureURL {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.URL) > 0 {
		i -= len(m.URL)
		copy(dAtA[i:], m.URL)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.URL)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServicesTokenList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicesTokenList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServicesTokenList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ServicesTokenList_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicesTokenList_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServicesTokenList_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ServicesTokenList_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicesTokenList_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServicesTokenList_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Service != nil {
		{
			size, err := m.Service.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.TokenID) > 0 {
		i -= len(m.TokenID)
		copy(dAtA[i:], m.TokenID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.TokenID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServicesTokenCode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicesTokenCode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServicesTokenCode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.TokenID) > 0 {
		i -= len(m.TokenID)
		copy(dAtA[i:], m.TokenID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.TokenID)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CodeChallenge) > 0 {
		i -= len(m.CodeChallenge)
		copy(dAtA[i:], m.CodeChallenge)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CodeChallenge)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Services) > 0 {
		for iNdEx := len(m.Services) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Services[iNdEx])
			copy(dAtA[i:], m.Services[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Services[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceRegisterGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceRegisterGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceRegisterGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceRegisterGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceRegisterGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceRegisterGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TokenID) > 0 {
		i -= len(m.TokenID)
		copy(dAtA[i:], m.TokenID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.TokenID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceRegisterGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceRegisterGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceRegisterGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceReplicateGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceReplicateGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceReplicateGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceReplicateGroup_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceReplicateGroup_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceReplicateGroup_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Group != nil {
		{
			size, err := m.Group.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationServiceReplicateGroup_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationServiceReplicateGroup_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationServiceReplicateGroup_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.OK {
		i--
		if m.OK {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Warns) > 0 {
		for iNdEx := len(m.Warns) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warns[iNdEx])
			copy(dAtA[i:], m.Warns[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Warns[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.OrbitDB != nil {
		{
			size, err := m.OrbitDB.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.P2P != nil {
		{
			size, err := m.P2P.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Process != nil {
		{
			size, err := m.Process.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_OrbitDB) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_OrbitDB) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_OrbitDB) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AccountMetadata != nil {
		{
			size, err := m.AccountMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Queued != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Queued))
		i--
		dAtA[i] = 0x20
	}
	if m.Buffered != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Buffered))
		i--
		dAtA[i] = 0x18
	}
	if m.Maximum != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Maximum))
		i--
		dAtA[i] = 0x10
	}
	if m.Progress != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Progress))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_P2P) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_P2P) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_P2P) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ConnectedPeers != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.ConnectedPeers))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo_Process) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo_Process) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo_Process) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SystemUsername) > 0 {
		i -= len(m.SystemUsername)
		copy(dAtA[i:], m.SystemUsername)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SystemUsername)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if len(m.WorkingDir) > 0 {
		i -= len(m.WorkingDir)
		copy(dAtA[i:], m.WorkingDir)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.WorkingDir)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if m.UID != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.UID))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.Priority != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.PPID != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.PPID))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.PID != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.PID))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.RlimitMax != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.RlimitMax))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if len(m.Arch) > 0 {
		i -= len(m.Arch)
		copy(dAtA[i:], m.Arch)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Arch)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.GoVersion) > 0 {
		i -= len(m.GoVersion)
		copy(dAtA[i:], m.GoVersion)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GoVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.NumCPU != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.NumCPU))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.TooManyOpenFiles {
		i--
		if m.TooManyOpenFiles {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.Nofile != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Nofile))
		i--
		dAtA[i] = 0x78
	}
	if m.NumGoroutine != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.NumGoroutine))
		i--
		dAtA[i] = 0x70
	}
	if m.RlimitCur != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.RlimitCur))
		i--
		dAtA[i] = 0x68
	}
	if m.StartedAt != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.StartedAt))
		i--
		dAtA[i] = 0x60
	}
	if m.SystemCPUTimeMS != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.SystemCPUTimeMS))
		i--
		dAtA[i] = 0x58
	}
	if m.UserCPUTimeMS != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.UserCPUTimeMS))
		i--
		dAtA[i] = 0x50
	}
	if m.UptimeMS != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.UptimeMS))
		i--
		dAtA[i] = 0x18
	}
	if len(m.VcsRef) > 0 {
		i -= len(m.VcsRef)
		copy(dAtA[i:], m.VcsRef)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.VcsRef)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PeerList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PeerList_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PeerList_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Peers) > 0 {
		for iNdEx := len(m.Peers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Peers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PeerList_Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList_Peer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList_Peer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Direction != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Direction))
		i--
		dAtA[i] = 0x38
	}
	if m.IsActive {
		i--
		if m.IsActive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.MinLatency != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.MinLatency))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Features) > 0 {
		dAtA30 := make([]byte, len(m.Features)*10)
		var j29 int
		for _, num := range m.Features {
			for num >= 1<<7 {
				dAtA30[j29] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j29++
			}
			dAtA30[j29] = uint8(num)
			j29++
		}
		i -= j29
		copy(dAtA[i:], dAtA30[:j29])
		i = encodeVarintProtocoltypes(dAtA, i, uint64(j29))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Errors[iNdEx])
			copy(dAtA[i:], m.Errors[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Errors[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PeerList_Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList_Route) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList_Route) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Streams) > 0 {
		for iNdEx := len(m.Streams) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Streams[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Latency != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Latency))
		i--
		dAtA[i] = 0x20
	}
	if m.Direction != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Direction))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x12
	}
	if m.IsActive {
		i--
		if m.IsActive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PeerList_Stream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerList_Stream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerList_Stream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentPrepare) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentPrepare) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentPrepare) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentPrepare_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentPrepare_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentPrepare_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DisableEncryption {
		i--
		if m.DisableEncryption {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Block) > 0 {
		i -= len(m.Block)
		copy(dAtA[i:], m.Block)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Block)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentPrepare_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentPrepare_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentPrepare_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentCID) > 0 {
		i -= len(m.AttachmentCID)
		copy(dAtA[i:], m.AttachmentCID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentCID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentRetrieve) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentRetrieve) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentRetrieve) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentRetrieve_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentRetrieve_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentRetrieve_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttachmentCID) > 0 {
		i -= len(m.AttachmentCID)
		copy(dAtA[i:], m.AttachmentCID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.AttachmentCID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachmentRetrieve_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachmentRetrieve_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachmentRetrieve_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Block) > 0 {
		i -= len(m.Block)
		copy(dAtA[i:], m.Block)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Block)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *Progress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Progress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Progress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Delay != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Delay))
		i--
		dAtA[i] = 0x30
	}
	if m.Total != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Total))
		i--
		dAtA[i] = 0x28
	}
	if m.Completed != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Completed))
		i--
		dAtA[i] = 0x20
	}
	if m.Progress != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Progress))))
		i--
		dAtA[i] = 0x1d
	}
	if len(m.Doing) > 0 {
		i -= len(m.Doing)
		copy(dAtA[i:], m.Doing)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Doing)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MemberWithDevices) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemberWithDevices) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemberWithDevices) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePKs) > 0 {
		for iNdEx := len(m.DevicePKs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DevicePKs[iNdEx])
			copy(dAtA[i:], m.DevicePKs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePKs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MemberPK) > 0 {
		i -= len(m.MemberPK)
		copy(dAtA[i:], m.MemberPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.MemberPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OutOfStoreMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutOfStoreMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OutOfStoreMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.EncryptedPayload) > 0 {
		i -= len(m.EncryptedPayload)
		copy(dAtA[i:], m.EncryptedPayload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.EncryptedPayload)))
		i--
		dAtA[i] = 0x32
	}
	if m.Flags != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(m.Flags))
		i--
		dAtA[i] = 0x2d
	}
	if len(m.Sig) > 0 {
		i -= len(m.Sig)
		copy(dAtA[i:], m.Sig)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Sig)))
		i--
		dAtA[i] = 0x22
	}
	if m.Counter != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Counter))
		i--
		dAtA[i] = 0x19
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CID) > 0 {
		i -= len(m.CID)
		copy(dAtA[i:], m.CID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushServiceReceiver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushServiceReceiver) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushServiceReceiver) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RecipientPublicKey) > 0 {
		i -= len(m.RecipientPublicKey)
		copy(dAtA[i:], m.RecipientPublicKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.RecipientPublicKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BundleID) > 0 {
		i -= len(m.BundleID)
		copy(dAtA[i:], m.BundleID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.BundleID)))
		i--
		dAtA[i] = 0x12
	}
	if m.TokenType != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.TokenType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PushServer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushServer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushServer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ServiceAddr) > 0 {
		i -= len(m.ServiceAddr)
		copy(dAtA[i:], m.ServiceAddr)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ServiceAddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ServerKey) > 0 {
		i -= len(m.ServerKey)
		copy(dAtA[i:], m.ServerKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ServerKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushDeviceTokenRegistered) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushDeviceTokenRegistered) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushDeviceTokenRegistered) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if m.Token != nil {
		{
			size, err := m.Token.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushDeviceServerRegistered) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushDeviceServerRegistered) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushDeviceServerRegistered) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x12
	}
	if m.Server != nil {
		{
			size, err := m.Server.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushMemberTokenUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushMemberTokenUpdate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushMemberTokenUpdate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DevicePK) > 0 {
		i -= len(m.DevicePK)
		copy(dAtA[i:], m.DevicePK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.DevicePK)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x12
	}
	if m.Server != nil {
		{
			size, err := m.Server.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushReceive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushReceive) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushReceive) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushReceive_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushReceive_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushReceive_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushReceive_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushReceive_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushReceive_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AlreadyReceived {
		i--
		if m.AlreadyReceived {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.GroupPublicKey) > 0 {
		i -= len(m.GroupPublicKey)
		copy(dAtA[i:], m.GroupPublicKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPublicKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Cleartext) > 0 {
		i -= len(m.Cleartext)
		copy(dAtA[i:], m.Cleartext)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Cleartext)))
		i--
		dAtA[i] = 0x12
	}
	if m.Message != nil {
		{
			size, err := m.Message.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushSend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushSend_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSend_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSend_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupMembers) > 0 {
		for iNdEx := len(m.GroupMembers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.GroupMembers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.GroupPublicKey) > 0 {
		i -= len(m.GroupPublicKey)
		copy(dAtA[i:], m.GroupPublicKey)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPublicKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CID) > 0 {
		i -= len(m.CID)
		copy(dAtA[i:], m.CID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.CID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushSend_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSend_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSend_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupMembers) > 0 {
		for iNdEx := len(m.GroupMembers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.GroupMembers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PushShareToken) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushShareToken) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushShareToken) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushShareToken_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushShareToken_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushShareToken_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Receiver != nil {
		{
			size, err := m.Receiver.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Server != nil {
		{
			size, err := m.Server.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.GroupPK) > 0 {
		i -= len(m.GroupPK)
		copy(dAtA[i:], m.GroupPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.GroupPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushShareToken_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushShareToken_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushShareToken_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushSetDeviceToken) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetDeviceToken) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetDeviceToken) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushSetDeviceToken_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetDeviceToken_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetDeviceToken_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Receiver != nil {
		{
			size, err := m.Receiver.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushSetDeviceToken_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetDeviceToken_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetDeviceToken_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushSetServer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetServer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetServer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PushSetServer_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetServer_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetServer_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Server != nil {
		{
			size, err := m.Server.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PushSetServer_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushSetServer_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushSetServer_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *FirstLastCounters) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FirstLastCounters) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FirstLastCounters) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Last != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Last))
		i--
		dAtA[i] = 0x10
	}
	if m.First != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.First))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OrbitDBMessageHeads) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrbitDBMessageHeads) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrbitDBMessageHeads) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RawRotation) > 0 {
		i -= len(m.RawRotation)
		copy(dAtA[i:], m.RawRotation)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.RawRotation)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SealedBox) > 0 {
		i -= len(m.SealedBox)
		copy(dAtA[i:], m.SealedBox)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.SealedBox)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *OrbitDBMessageHeads_Box) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrbitDBMessageHeads_Box) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrbitDBMessageHeads_Box) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Heads) > 0 {
		i -= len(m.Heads)
		copy(dAtA[i:], m.Heads)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Heads)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshContactRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshContactRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshContactRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *RefreshContactRequest_Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshContactRequest_Peer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshContactRequest_Peer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Addrs) > 0 {
		for iNdEx := len(m.Addrs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Addrs[iNdEx])
			copy(dAtA[i:], m.Addrs[iNdEx])
			i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.Addrs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshContactRequest_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshContactRequest_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshContactRequest_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Timeout != 0 {
		i = encodeVarintProtocoltypes(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContactPK) > 0 {
		i -= len(m.ContactPK)
		copy(dAtA[i:], m.ContactPK)
		i = encodeVarintProtocoltypes(dAtA, i, uint64(len(m.ContactPK)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshContactRequest_Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshContactRequest_Reply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshContactRequest_Reply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PeersFound) > 0 {
		for iNdEx := len(m.PeersFound) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PeersFound[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProtocoltypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintProtocoltypes(dAtA []byte, offset int, v uint64) int {
	offset -= sovProtocoltypes(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}

func (m *Account) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AccountPrivateKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AliasPrivateKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Group) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PublicKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Secret)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.SecretSig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.GroupType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.GroupType))
	}
	l = len(m.SignPub)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.LinkKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.LinkKeySig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupHeadsExport) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PublicKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.SignPub)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.MetadataHeadsCIDs) > 0 {
		for _, b := range m.MetadataHeadsCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if len(m.MessagesHeadsCIDs) > 0 {
		for _, b := range m.MessagesHeadsCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.LinkKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EventType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.EventType))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Sig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.ProtocolMetadata != nil {
		l = m.ProtocolMetadata.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupEnvelope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Event)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.EncryptedAttachmentCIDs) > 0 {
		for _, b := range m.EncryptedAttachmentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MessageHeaders) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Counter != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Counter))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Sig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovProtocoltypes(uint64(len(k))) + 1 + len(v) + sovProtocoltypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovProtocoltypes(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProtocolMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AttachmentsSecrets) > 0 {
		for _, b := range m.AttachmentsSecrets {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EncryptedMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Plaintext)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.ProtocolMetadata != nil {
		l = m.ProtocolMetadata.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MessageEnvelope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MessageHeaders)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.EncryptedAttachmentCIDs) > 0 {
		for _, b := range m.EncryptedAttachmentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.ParentIDs) > 0 {
		for _, b := range m.ParentIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.AttachmentCIDs) > 0 {
		for _, b := range m.AttachmentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactAddAliasKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AliasPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupAddMemberDevice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.MemberSig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeviceSecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ChainKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Counter != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Counter))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupAddDeviceSecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DestMemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAddAliasResolver) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AliasResolver)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AliasProof)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGrantAdminRole) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GranteeMemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberInitialMember) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupAddAdditionalRendezvousSeed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Seed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupRemoveAdditionalRendezvousSeed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Seed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountGroupJoined) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountGroupLeft) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestDisabled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestEnabled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestReferenceReset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestEnqueued) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Contact != nil {
		l = m.Contact.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.OwnMetadata)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestSent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestReceived) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactMetadata)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestDiscarded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactRequestAccepted) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactBlocked) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountContactUnblocked) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountServiceTokenAdded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.ServiceToken != nil {
		l = m.ServiceToken.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccountServiceTokenRemoved) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.TokenID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupReplicating) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AuthenticationURL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ReplicationServer)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceExportData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceExportData_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceExportData_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ExportedData)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceGetConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceGetConfiguration_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstanceGetConfiguration_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AccountPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AccountGroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.PeerID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Listeners) > 0 {
		for _, s := range m.Listeners {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.BleEnabled != 0 {
		n += 1 + sovProtocoltypes(uint64(m.BleEnabled))
	}
	if m.WifiP2PEnabled != 0 {
		n += 1 + sovProtocoltypes(uint64(m.WifiP2PEnabled))
	}
	if m.MdnsEnabled != 0 {
		n += 1 + sovProtocoltypes(uint64(m.MdnsEnabled))
	}
	if m.RelayEnabled != 0 {
		n += 1 + sovProtocoltypes(uint64(m.RelayEnabled))
	}
	if m.DevicePushToken != nil {
		l = m.DevicePushToken.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.DevicePushServer != nil {
		l = m.DevicePushServer.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestReference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestReference_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestReference_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Enabled {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDisable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDisable_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDisable_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestEnable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestEnable_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestEnable_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestResetReference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestResetReference_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestResetReference_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestSend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestSend_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Contact != nil {
		l = m.Contact.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.OwnMetadata)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestSend_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestAccept) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestAccept_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestAccept_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDiscard) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDiscard_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactRequestDiscard_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactBlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactBlock_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactBlock_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactUnblock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactUnblock_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactUnblock_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactAliasKeySend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactAliasKeySend_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContactAliasKeySend_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupCreate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupCreate_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupCreate_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupJoin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupJoin_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupJoin_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupLeave) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupLeave_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupLeave_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAliasResolverDisclose) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAdminRoleGrant) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAdminRoleGrant_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.MemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupInvitationCreate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupInvitationCreate_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MultiMemberGroupInvitationCreate_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMetadataSend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMetadataSend_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.AttachmentCIDs) > 0 {
		for _, b := range m.AttachmentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMetadataSend_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMessageSend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMessageSend_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.AttachmentCIDs) > 0 {
		for _, b := range m.AttachmentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppMessageSend_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMetadataEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EventContext != nil {
		l = m.EventContext.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Event)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMessageEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EventContext != nil {
		l = m.EventContext.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Headers != nil {
		l = m.Headers.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMetadataList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMetadataList_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.SinceID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.SinceNow {
		n += 2
	}
	l = len(m.UntilID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.UntilNow {
		n += 2
	}
	if m.ReverseOrder {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMessageList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMessageList_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.SinceID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.SinceNow {
		n += 2
	}
	l = len(m.UntilID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.UntilNow {
		n += 2
	}
	if m.ReverseOrder {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupInfo_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupInfo_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.MemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ActivateGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ActivateGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.LocalOnly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ActivateGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeactivateGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeactivateGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeactivateGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_EventMonitorAdvertiseGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PeerID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Maddrs) > 0 {
		for _, s := range m.Maddrs {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.DriverName)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_EventMonitorPeerFound) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PeerID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Maddrs) > 0 {
		for _, s := range m.Maddrs {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.DriverName)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_EventMonitorPeerJoin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PeerID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Maddrs) > 0 {
		for _, s := range m.Maddrs {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.IsSelf {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_EventMonitorPeerLeave) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PeerID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.IsSelf {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_EventMonitor) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Type))
	}
	if m.AdvertiseGroup != nil {
		l = m.AdvertiseGroup.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.PeerFound != nil {
		l = m.PeerFound.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.PeerJoin != nil {
		l = m.PeerJoin.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.PeerLeave != nil {
		l = m.PeerLeave.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MonitorGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Event != nil {
		l = m.Event.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugListGroups) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugListGroups_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugListGroups_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.GroupType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.GroupType))
	}
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugInspectGroupStore) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugInspectGroupStore_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.LogType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.LogType))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugInspectGroupStore_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.ParentCIDs) > 0 {
		for _, b := range m.ParentCIDs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.MetadataEventType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.MetadataEventType))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PeerIDs) > 0 {
		for _, s := range m.PeerIDs {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthExchangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AccessToken)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Scope)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ErrorDescription)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Services) > 0 {
		for k, v := range m.Services {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovProtocoltypes(uint64(len(k))) + 1 + len(v) + sovProtocoltypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovProtocoltypes(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugAuthServiceSetToken) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugAuthServiceSetToken_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Token != nil {
		l = m.Token.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AuthenticationURL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DebugAuthServiceSetToken_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ShareableContact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.PublicRendezvousSeed)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Metadata)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceTokenSupportedService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceType)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ServiceEndpoint)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceToken) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.AuthenticationURL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.SupportedServices) > 0 {
		for _, e := range m.SupportedServices {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.Expiration != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Expiration))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceCompleteFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceCompleteFlow_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CallbackURL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceCompleteFlow_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TokenID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceInitFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceInitFlow_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuthURL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Services) > 0 {
		for _, s := range m.Services {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthServiceInitFlow_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.SecureURL {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServicesTokenList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServicesTokenList_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServicesTokenList_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TokenID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServicesTokenCode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, s := range m.Services {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	l = len(m.CodeChallenge)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.TokenID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceRegisterGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceRegisterGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TokenID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceRegisterGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceReplicateGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceReplicateGroup_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationServiceReplicateGroup_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OK {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Process != nil {
		l = m.Process.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.P2P != nil {
		l = m.P2P.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.OrbitDB != nil {
		l = m.OrbitDB.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Warns) > 0 {
		for _, s := range m.Warns {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_OrbitDB) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AccountMetadata != nil {
		l = m.AccountMetadata.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_OrbitDB_ReplicationStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Progress != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Progress))
	}
	if m.Maximum != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Maximum))
	}
	if m.Buffered != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Buffered))
	}
	if m.Queued != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Queued))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_P2P) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConnectedPeers != 0 {
		n += 1 + sovProtocoltypes(uint64(m.ConnectedPeers))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemInfo_Process) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.VcsRef)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.UptimeMS != 0 {
		n += 1 + sovProtocoltypes(uint64(m.UptimeMS))
	}
	if m.UserCPUTimeMS != 0 {
		n += 1 + sovProtocoltypes(uint64(m.UserCPUTimeMS))
	}
	if m.SystemCPUTimeMS != 0 {
		n += 1 + sovProtocoltypes(uint64(m.SystemCPUTimeMS))
	}
	if m.StartedAt != 0 {
		n += 1 + sovProtocoltypes(uint64(m.StartedAt))
	}
	if m.RlimitCur != 0 {
		n += 1 + sovProtocoltypes(uint64(m.RlimitCur))
	}
	if m.NumGoroutine != 0 {
		n += 1 + sovProtocoltypes(uint64(m.NumGoroutine))
	}
	if m.Nofile != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Nofile))
	}
	if m.TooManyOpenFiles {
		n += 3
	}
	if m.NumCPU != 0 {
		n += 2 + sovProtocoltypes(uint64(m.NumCPU))
	}
	l = len(m.GoVersion)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.OperatingSystem)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.HostName)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Arch)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	if m.RlimitMax != 0 {
		n += 2 + sovProtocoltypes(uint64(m.RlimitMax))
	}
	if m.PID != 0 {
		n += 2 + sovProtocoltypes(uint64(m.PID))
	}
	if m.PPID != 0 {
		n += 2 + sovProtocoltypes(uint64(m.PPID))
	}
	if m.Priority != 0 {
		n += 2 + sovProtocoltypes(uint64(m.Priority))
	}
	if m.UID != 0 {
		n += 2 + sovProtocoltypes(uint64(m.UID))
	}
	l = len(m.WorkingDir)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.SystemUsername)
	if l > 0 {
		n += 2 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList_Peer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if len(m.Errors) > 0 {
		for _, s := range m.Errors {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if len(m.Features) > 0 {
		l = 0
		for _, e := range m.Features {
			l += sovProtocoltypes(uint64(e))
		}
		n += 1 + sovProtocoltypes(uint64(l)) + l
	}
	if m.MinLatency != 0 {
		n += 1 + sovProtocoltypes(uint64(m.MinLatency))
	}
	if m.IsActive {
		n += 2
	}
	if m.Direction != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Direction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList_Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IsActive {
		n += 2
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Direction != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Direction))
	}
	if m.Latency != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Latency))
	}
	if len(m.Streams) > 0 {
		for _, e := range m.Streams {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerList_Stream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentPrepare) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentPrepare_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Block)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.DisableEncryption {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentPrepare_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AttachmentCID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentRetrieve) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentRetrieve_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AttachmentCID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachmentRetrieve_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Block)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Progress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Doing)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Progress != 0 {
		n += 5
	}
	if m.Completed != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Completed))
	}
	if m.Total != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Total))
	}
	if m.Delay != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Delay))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemberWithDevices) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MemberPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.DevicePKs) > 0 {
		for _, b := range m.DevicePKs {
			l = len(b)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutOfStoreMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Counter != 0 {
		n += 9
	}
	l = len(m.Sig)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Flags != 0 {
		n += 5
	}
	l = len(m.EncryptedPayload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushServiceReceiver) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TokenType != 0 {
		n += 1 + sovProtocoltypes(uint64(m.TokenType))
	}
	l = len(m.BundleID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.RecipientPublicKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushServer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServerKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.ServiceAddr)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushDeviceTokenRegistered) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Token != nil {
		l = m.Token.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushDeviceServerRegistered) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushMemberTokenUpdate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.DevicePK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushReceive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushReceive_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushReceive_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Cleartext)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPublicKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.AlreadyReceived {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSend_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.GroupPublicKey)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.GroupMembers) > 0 {
		for _, e := range m.GroupMembers {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSend_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.GroupMembers) > 0 {
		for _, e := range m.GroupMembers {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushShareToken) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushShareToken_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Receiver != nil {
		l = m.Receiver.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushShareToken_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetDeviceToken) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetDeviceToken_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Receiver != nil {
		l = m.Receiver.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetDeviceToken_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetServer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetServer_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PushSetServer_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FirstLastCounters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.First != 0 {
		n += 1 + sovProtocoltypes(uint64(m.First))
	}
	if m.Last != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Last))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrbitDBMessageHeads) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SealedBox)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.RawRotation)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrbitDBMessageHeads_Box) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	l = len(m.Heads)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RefreshContactRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RefreshContactRequest_Peer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if len(m.Addrs) > 0 {
		for _, s := range m.Addrs {
			l = len(s)
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RefreshContactRequest_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContactPK)
	if l > 0 {
		n += 1 + l + sovProtocoltypes(uint64(l))
	}
	if m.Timeout != 0 {
		n += 1 + sovProtocoltypes(uint64(m.Timeout))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RefreshContactRequest_Reply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PeersFound) > 0 {
		for _, e := range m.PeersFound {
			l = e.Size()
			n += 1 + l + sovProtocoltypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProtocoltypes(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}

func sozProtocoltypes(x uint64) (n int) {
	return sovProtocoltypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}

func (m *Account) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Account: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Account: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Group == nil {
				m.Group = &Group{}
			}
			if err := m.Group.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountPrivateKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountPrivateKey = append(m.AccountPrivateKey[:0], dAtA[iNdEx:postIndex]...)
			if m.AccountPrivateKey == nil {
				m.AccountPrivateKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AliasPrivateKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AliasPrivateKey = append(m.AliasPrivateKey[:0], dAtA[iNdEx:postIndex]...)
			if m.AliasPrivateKey == nil {
				m.AliasPrivateKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicRendezvousSeed = append(m.PublicRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicRendezvousSeed == nil {
				m.PublicRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *Group) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Group: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Group: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicKey = append(m.PublicKey[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicKey == nil {
				m.PublicKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = append(m.Secret[:0], dAtA[iNdEx:postIndex]...)
			if m.Secret == nil {
				m.Secret = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretSig", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretSig = append(m.SecretSig[:0], dAtA[iNdEx:postIndex]...)
			if m.SecretSig == nil {
				m.SecretSig = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupType", wireType)
			}
			m.GroupType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupType |= GroupType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignPub", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignPub = append(m.SignPub[:0], dAtA[iNdEx:postIndex]...)
			if m.SignPub == nil {
				m.SignPub = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LinkKey = append(m.LinkKey[:0], dAtA[iNdEx:postIndex]...)
			if m.LinkKey == nil {
				m.LinkKey = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkKeySig", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LinkKeySig = append(m.LinkKeySig[:0], dAtA[iNdEx:postIndex]...)
			if m.LinkKeySig == nil {
				m.LinkKeySig = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupHeadsExport) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupHeadsExport: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupHeadsExport: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicKey = append(m.PublicKey[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicKey == nil {
				m.PublicKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignPub", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignPub = append(m.SignPub[:0], dAtA[iNdEx:postIndex]...)
			if m.SignPub == nil {
				m.SignPub = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataHeadsCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetadataHeadsCIDs = append(m.MetadataHeadsCIDs, make([]byte, postIndex-iNdEx))
			copy(m.MetadataHeadsCIDs[len(m.MetadataHeadsCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessagesHeadsCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MessagesHeadsCIDs = append(m.MessagesHeadsCIDs, make([]byte, postIndex-iNdEx))
			copy(m.MessagesHeadsCIDs[len(m.MessagesHeadsCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LinkKey = append(m.LinkKey[:0], dAtA[iNdEx:postIndex]...)
			if m.LinkKey == nil {
				m.LinkKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventType", wireType)
			}
			m.EventType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventType |= EventType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sig", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sig = append(m.Sig[:0], dAtA[iNdEx:postIndex]...)
			if m.Sig == nil {
				m.Sig = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProtocolMetadata == nil {
				m.ProtocolMetadata = &ProtocolMetadata{}
			}
			if err := m.ProtocolMetadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupEnvelope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupEnvelope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupEnvelope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = append(m.Nonce[:0], dAtA[iNdEx:postIndex]...)
			if m.Nonce == nil {
				m.Nonce = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Event", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Event = append(m.Event[:0], dAtA[iNdEx:postIndex]...)
			if m.Event == nil {
				m.Event = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptedAttachmentCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncryptedAttachmentCIDs = append(m.EncryptedAttachmentCIDs, make([]byte, postIndex-iNdEx))
			copy(m.EncryptedAttachmentCIDs[len(m.EncryptedAttachmentCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MessageHeaders) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MessageHeaders: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MessageHeaders: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counter", wireType)
			}
			m.Counter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Counter |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sig", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sig = append(m.Sig[:0], dAtA[iNdEx:postIndex]...)
			if m.Sig == nil {
				m.Sig = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocoltypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProtocoltypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthProtocoltypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthProtocoltypes
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProtocoltypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthProtocoltypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthProtocoltypes
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipProtocoltypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthProtocoltypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ProtocolMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProtocolMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProtocolMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachmentsSecrets", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttachmentsSecrets = append(m.AttachmentsSecrets, make([]byte, postIndex-iNdEx))
			copy(m.AttachmentsSecrets[len(m.AttachmentsSecrets)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *EncryptedMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptedMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptedMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plaintext", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Plaintext = append(m.Plaintext[:0], dAtA[iNdEx:postIndex]...)
			if m.Plaintext == nil {
				m.Plaintext = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProtocolMetadata == nil {
				m.ProtocolMetadata = &ProtocolMetadata{}
			}
			if err := m.ProtocolMetadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MessageEnvelope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MessageEnvelope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MessageEnvelope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageHeaders", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MessageHeaders = append(m.MessageHeaders[:0], dAtA[iNdEx:postIndex]...)
			if m.MessageHeaders == nil {
				m.MessageHeaders = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = append(m.Message[:0], dAtA[iNdEx:postIndex]...)
			if m.Message == nil {
				m.Message = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = append(m.Nonce[:0], dAtA[iNdEx:postIndex]...)
			if m.Nonce == nil {
				m.Nonce = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptedAttachmentCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncryptedAttachmentCIDs = append(m.EncryptedAttachmentCIDs, make([]byte, postIndex-iNdEx))
			copy(m.EncryptedAttachmentCIDs[len(m.EncryptedAttachmentCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *EventContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = append(m.ID[:0], dAtA[iNdEx:postIndex]...)
			if m.ID == nil {
				m.ID = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentIDs = append(m.ParentIDs, make([]byte, postIndex-iNdEx))
			copy(m.ParentIDs[len(m.ParentIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachmentCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttachmentCIDs = append(m.AttachmentCIDs, make([]byte, postIndex-iNdEx))
			copy(m.AttachmentCIDs[len(m.AttachmentCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = append(m.Message[:0], dAtA[iNdEx:postIndex]...)
			if m.Message == nil {
				m.Message = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactAddAliasKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactAddAliasKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactAddAliasKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AliasPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AliasPK = append(m.AliasPK[:0], dAtA[iNdEx:postIndex]...)
			if m.AliasPK == nil {
				m.AliasPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupAddMemberDevice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupAddMemberDevice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupAddMemberDevice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberPK = append(m.MemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.MemberPK == nil {
				m.MemberPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberSig", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberSig = append(m.MemberSig[:0], dAtA[iNdEx:postIndex]...)
			if m.MemberSig == nil {
				m.MemberSig = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *DeviceSecret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeviceSecret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeviceSecret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChainKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChainKey = append(m.ChainKey[:0], dAtA[iNdEx:postIndex]...)
			if m.ChainKey == nil {
				m.ChainKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counter", wireType)
			}
			m.Counter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Counter |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupAddDeviceSecret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupAddDeviceSecret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupAddDeviceSecret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestMemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestMemberPK = append(m.DestMemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.DestMemberPK == nil {
				m.DestMemberPK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAddAliasResolver) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupAddAliasResolver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupAddAliasResolver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AliasResolver", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AliasResolver = append(m.AliasResolver[:0], dAtA[iNdEx:postIndex]...)
			if m.AliasResolver == nil {
				m.AliasResolver = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AliasProof", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AliasProof = append(m.AliasProof[:0], dAtA[iNdEx:postIndex]...)
			if m.AliasProof == nil {
				m.AliasProof = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGrantAdminRole) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGrantAdminRole: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGrantAdminRole: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GranteeMemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GranteeMemberPK = append(m.GranteeMemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GranteeMemberPK == nil {
				m.GranteeMemberPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberInitialMember) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberInitialMember: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberInitialMember: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberPK = append(m.MemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.MemberPK == nil {
				m.MemberPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupAddAdditionalRendezvousSeed) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupAddAdditionalRendezvousSeed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupAddAdditionalRendezvousSeed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Seed = append(m.Seed[:0], dAtA[iNdEx:postIndex]...)
			if m.Seed == nil {
				m.Seed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupRemoveAdditionalRendezvousSeed) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupRemoveAdditionalRendezvousSeed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupRemoveAdditionalRendezvousSeed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Seed = append(m.Seed[:0], dAtA[iNdEx:postIndex]...)
			if m.Seed == nil {
				m.Seed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountGroupJoined) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountGroupJoined: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountGroupJoined: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Group == nil {
				m.Group = &Group{}
			}
			if err := m.Group.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountGroupLeft) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountGroupLeft: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountGroupLeft: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestDisabled) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestDisabled: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestDisabled: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestEnabled) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestEnabled: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestEnabled: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestReferenceReset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestReferenceReset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestReferenceReset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicRendezvousSeed = append(m.PublicRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicRendezvousSeed == nil {
				m.PublicRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestEnqueued) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestEnqueued: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestEnqueued: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Contact", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Contact == nil {
				m.Contact = &ShareableContact{}
			}
			if err := m.Contact.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OwnMetadata", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OwnMetadata = append(m.OwnMetadata[:0], dAtA[iNdEx:postIndex]...)
			if m.OwnMetadata == nil {
				m.OwnMetadata = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestSent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestSent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestSent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestReceived) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestReceived: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestReceived: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactRendezvousSeed = append(m.ContactRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactRendezvousSeed == nil {
				m.ContactRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactMetadata", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactMetadata = append(m.ContactMetadata[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactMetadata == nil {
				m.ContactMetadata = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestDiscarded) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestDiscarded: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestDiscarded: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactRequestAccepted) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactRequestAccepted: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactRequestAccepted: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactBlocked) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactBlocked: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactBlocked: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountContactUnblocked) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountContactUnblocked: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountContactUnblocked: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountServiceTokenAdded) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountServiceTokenAdded: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountServiceTokenAdded: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceToken", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServiceToken == nil {
				m.ServiceToken = &ServiceToken{}
			}
			if err := m.ServiceToken.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AccountServiceTokenRemoved) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccountServiceTokenRemoved: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccountServiceTokenRemoved: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TokenID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TokenID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupReplicating) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupReplicating: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupReplicating: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthenticationURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuthenticationURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationServer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationServer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceExportData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceExportData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceExportData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceExportData_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceExportData_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExportedData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExportedData = append(m.ExportedData[:0], dAtA[iNdEx:postIndex]...)
			if m.ExportedData == nil {
				m.ExportedData = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceGetConfiguration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceGetConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceGetConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceGetConfiguration_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *InstanceGetConfiguration_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountPK = append(m.AccountPK[:0], dAtA[iNdEx:postIndex]...)
			if m.AccountPK == nil {
				m.AccountPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountGroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountGroupPK = append(m.AccountGroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.AccountGroupPK == nil {
				m.AccountGroupPK = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listeners", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Listeners = append(m.Listeners, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BleEnabled", wireType)
			}
			m.BleEnabled = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BleEnabled |= InstanceGetConfiguration_SettingState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WifiP2PEnabled", wireType)
			}
			m.WifiP2PEnabled = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WifiP2PEnabled |= InstanceGetConfiguration_SettingState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MdnsEnabled", wireType)
			}
			m.MdnsEnabled = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MdnsEnabled |= InstanceGetConfiguration_SettingState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayEnabled", wireType)
			}
			m.RelayEnabled = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RelayEnabled |= InstanceGetConfiguration_SettingState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePushToken", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DevicePushToken == nil {
				m.DevicePushToken = &PushServiceReceiver{}
			}
			if err := m.DevicePushToken.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePushServer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DevicePushServer == nil {
				m.DevicePushServer = &PushServer{}
			}
			if err := m.DevicePushServer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestReference_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestReference_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicRendezvousSeed = append(m.PublicRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicRendezvousSeed == nil {
				m.PublicRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDisable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestDisable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestDisable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDisable_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDisable_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestEnable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestEnable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestEnable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestEnable_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestEnable_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicRendezvousSeed = append(m.PublicRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicRendezvousSeed == nil {
				m.PublicRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestResetReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestResetReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestResetReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestResetReference_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestResetReference_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicRendezvousSeed", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicRendezvousSeed = append(m.PublicRendezvousSeed[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicRendezvousSeed == nil {
				m.PublicRendezvousSeed = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestSend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestSend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestSend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestSend_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Contact", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Contact == nil {
				m.Contact = &ShareableContact{}
			}
			if err := m.Contact.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OwnMetadata", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OwnMetadata = append(m.OwnMetadata[:0], dAtA[iNdEx:postIndex]...)
			if m.OwnMetadata == nil {
				m.OwnMetadata = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestSend_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestAccept) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestAccept: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestAccept: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestAccept_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestAccept_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDiscard) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactRequestDiscard: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactRequestDiscard: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDiscard_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactRequestDiscard_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactBlock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactBlock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactBlock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactBlock_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactBlock_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactUnblock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactUnblock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactUnblock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactUnblock_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactUnblock_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactAliasKeySend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContactAliasKeySend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContactAliasKeySend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactAliasKeySend_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ContactAliasKeySend_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupCreate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupCreate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupCreate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupCreate_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupCreate_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupJoin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupJoin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupJoin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupJoin_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Group == nil {
				m.Group = &Group{}
			}
			if err := m.Group.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupJoin_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupLeave) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupLeave: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupLeave: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupLeave_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupLeave_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAliasResolverDisclose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupAliasResolverDisclose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupAliasResolverDisclose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAliasResolverDisclose_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAdminRoleGrant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupAdminRoleGrant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupAdminRoleGrant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAdminRoleGrant_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberPK = append(m.MemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.MemberPK == nil {
				m.MemberPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupAdminRoleGrant_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupInvitationCreate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiMemberGroupInvitationCreate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiMemberGroupInvitationCreate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupInvitationCreate_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *MultiMemberGroupInvitationCreate_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Group == nil {
				m.Group = &Group{}
			}
			if err := m.Group.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMetadataSend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppMetadataSend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppMetadataSend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMetadataSend_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachmentCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttachmentCIDs = append(m.AttachmentCIDs, make([]byte, postIndex-iNdEx))
			copy(m.AttachmentCIDs[len(m.AttachmentCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMetadataSend_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CID = append(m.CID[:0], dAtA[iNdEx:postIndex]...)
			if m.CID == nil {
				m.CID = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMessageSend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppMessageSend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppMessageSend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMessageSend_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachmentCIDs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttachmentCIDs = append(m.AttachmentCIDs, make([]byte, postIndex-iNdEx))
			copy(m.AttachmentCIDs[len(m.AttachmentCIDs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *AppMessageSend_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CID = append(m.CID[:0], dAtA[iNdEx:postIndex]...)
			if m.CID == nil {
				m.CID = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMetadataEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMetadataEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMetadataEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EventContext == nil {
				m.EventContext = &EventContext{}
			}
			if err := m.EventContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &GroupMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Event", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Event = append(m.Event[:0], dAtA[iNdEx:postIndex]...)
			if m.Event == nil {
				m.Event = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMessageEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMessageEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMessageEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EventContext == nil {
				m.EventContext = &EventContext{}
			}
			if err := m.EventContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = &MessageHeaders{}
			}
			if err := m.Headers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = append(m.Message[:0], dAtA[iNdEx:postIndex]...)
			if m.Message == nil {
				m.Message = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMetadataList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMetadataList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMetadataList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMetadataList_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SinceID = append(m.SinceID[:0], dAtA[iNdEx:postIndex]...)
			if m.SinceID == nil {
				m.SinceID = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceNow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SinceNow = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UntilID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UntilID = append(m.UntilID[:0], dAtA[iNdEx:postIndex]...)
			if m.UntilID == nil {
				m.UntilID = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UntilNow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UntilNow = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseOrder", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReverseOrder = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMessageList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMessageList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMessageList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupMessageList_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SinceID = append(m.SinceID[:0], dAtA[iNdEx:postIndex]...)
			if m.SinceID == nil {
				m.SinceID = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceNow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SinceNow = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UntilID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UntilID = append(m.UntilID[:0], dAtA[iNdEx:postIndex]...)
			if m.UntilID == nil {
				m.UntilID = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UntilNow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UntilNow = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseOrder", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReverseOrder = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupInfo_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupPK = append(m.GroupPK[:0], dAtA[iNdEx:postIndex]...)
			if m.GroupPK == nil {
				m.GroupPK = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContactPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContactPK = append(m.ContactPK[:0], dAtA[iNdEx:postIndex]...)
			if m.ContactPK == nil {
				m.ContactPK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *GroupInfo_Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Group == nil {
				m.Group = &Group{}
			}
			if err := m.Group.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberPK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberPK = append(m.MemberPK[:0], dAtA[iNdEx:postIndex]...)
			if m.MemberPK == nil {
				m.MemberPK = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePK", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocoltypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DevicePK = append(m.DevicePK[:0], dAtA[iNdEx:postIndex]...)
			if m.DevicePK == nil {
				m.DevicePK = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ActivateGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocoltypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActivateGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActivateGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProtocoltypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProtocoltypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}

func (m *ActivateGroup_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint