// Package handshake implements a capability-based handshake.
//
// Handshake Sequence Diagram:
// ---------------------------
// Handshake vastely inspired by Scuttlebutt's Capability-based Handshake
// https://scuttlebot.io/more/protocols/shs.pdf
//
// - a, b are ephemeral key pairs generated by respectively Requester and
//   Responder. Ephemeral keys are used for one handshake only and then
//   discarded. They guarantee the freshness of the messages and avoid
//   replay attacks.
// - A, B are the Account IDs of respectively Requester and Responder.
// - a.b denotes a secret derived from the two keys a and b.
// - | is the concatenation operator.
// - box[a.b](content) denotes the encryption of content using Nacl box
//   with a.b as key.
// - sig[A](content) denotes the signature of content verified by A.
//
//
//		+-----------+                       +-----------+
//		| Requester |                       | Responder |
//		+-----------+                       +-----------+
//			  | ---------------------\            |
//			  |-| 1. Requester Hello |            |
//			  | |--------------------|            |
//			  |                                   |
//			  | a                                 |
//			  |---------------------------------->|
//			  |            ---------------------\ |
//			  |            | 2. Responder Hello |-|
//			  |            |--------------------| |
//			  |                                   |
//			  |                                 b |
//			  |<----------------------------------|
//			  | ----------------------------\     |
//			  |-| 3. Requester Authenticate |     |
//			  | |---------------------------|     |
//			  |                                   |
//			  | box[a.b|a.B](A,sig[A](a.b))       |
//			  |---------------------------------->|
//			  |           ----------------------\ |
//			  |           | 4. Responder Accept |-|
//			  |           |---------------------| |
//			  |                                   |
//			  |         box[a.b|A.B](sig[B](a.b)) |
//			  |<----------------------------------|
//			  | ---------------------------\      |
//			  |-| 5. Requester Acknowledge |      |
//			  | |--------------------------|      |
//			  |                                   |
//			  | ok                                |
//			  |---------------------------------->|
//			  |                                   |
//
// See the documentation at https://berty.tech/protocol for more information.
package handshake
