package acmpca

import (
	"github.com/awslabs/goformation/v4/cloudformation/policies"
)

// CertificateAuthority_SubjectInformationAccess AWS CloudFormation Resource (AWS::ACMPCA::CertificateAuthority.SubjectInformationAccess)
// See: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subjectinformationaccess.html
type CertificateAuthority_SubjectInformationAccess struct {

	// SubjectInformationAccess AWS CloudFormation Property
	// Required: false
	// See: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subjectinformationaccess.html#cfn-acmpca-certificateauthority-subjectinformationaccess-subjectinformationaccess
	SubjectInformationAccess []CertificateAuthority_AccessDescription `json:"SubjectInformationAccess,omitempty"`

	// AWSCloudFormationDeletionPolicy represents a CloudFormation DeletionPolicy
	AWSCloudFormationDeletionPolicy policies.DeletionPolicy `json:"-"`

	// AWSCloudFormationUpdateReplacePolicy represents a CloudFormation UpdateReplacePolicy
	AWSCloudFormationUpdateReplacePolicy policies.UpdateReplacePolicy `json:"-"`

	// AWSCloudFormationDependsOn stores the logical ID of the resources to be created before this resource
	AWSCloudFormationDependsOn []string `json:"-"`

	// AWSCloudFormationMetadata stores structured data associated with this resource
	AWSCloudFormationMetadata map[string]interface{} `json:"-"`

	// AWSCloudFormationCondition stores the logical ID of the condition that must be satisfied for this resource to be created
	AWSCloudFormationCondition string `json:"-"`
}

// AWSCloudFormationType returns the AWS CloudFormation resource type
func (r *CertificateAuthority_SubjectInformationAccess) AWSCloudFormationType() string {
	return "AWS::ACMPCA::CertificateAuthority.SubjectInformationAccess"
}
