package resource

import (
	"fmt"
	"strings"
)

var mapping = map[string]ResourceType{
	"Alexa::ASK::Skill":                                           Unmapped,
	"AWS::AccessAnalyzer::Analyzer":                               AccessAnalyzerAnalyzer,
	"AWS::ACMPCA::Certificate":                                    Unmapped,
	"AWS::ACMPCA::CertificateAuthority":                           Unmapped,
	"AWS::ACMPCA::CertificateAuthorityActivation":                 Unmapped,
	"AWS::ACMPCA::Permission":                                     Unmapped,
	"AWS::APS::RuleGroupsNamespace":                               Unmapped,
	"AWS::APS::Workspace":                                         Unmapped,
	"AWS::AmazonMQ::Broker":                                       AmazonMQBroker,
	"AWS::AmazonMQ::Configuration":                                AmazonMQBrokerConfiguration,
	"AWS::AmazonMQ::ConfigurationAssociation":                     AmazonMQBroker,
	"AWS::Amplify::App":                                           AmplifyApp,
	"AWS::Amplify::Branch":                                        AmplifyBranch,
	"AWS::Amplify::Domain":                                        AmplifyDomain,
	"AWS::AmplifyUIBuilder::Component":                            Unmapped,
	"AWS::AmplifyUIBuilder::Theme":                                Unmapped,
	"AWS::ApiGateway::Account":                                    Unmapped,
	"AWS::ApiGateway::ApiKey":                                     ApiGatewayApiKey,
	"AWS::ApiGateway::Authorizer":                                 ApiGatewayAuthorizer,
	"AWS::ApiGateway::BasePathMapping":                            ApiGatewayBasePathMapping,
	"AWS::ApiGateway::ClientCertificate":                          Unmapped,
	"AWS::ApiGateway::Deployment":                                 ApiGatewayDeployment,
	"AWS::ApiGateway::DocumentationPart":                          ApiGatewayDocumentationPart,
	"AWS::ApiGateway::DocumentationVersion":                       Unmapped,
	"AWS::ApiGateway::DomainName":                                 ApiGatewayDomainName,
	"AWS::ApiGateway::GatewayResponse":                            ApiGatewayRestApi,
	"AWS::ApiGateway::Method":                                     ApiGatewayMethod,
	"AWS::ApiGateway::Model":                                      ApiGatewayModel,
	"AWS::ApiGateway::RequestValidator":                           ApiGatewayRequestValidator,
	"AWS::ApiGateway::Resource":                                   ApiGatewayResource,
	"AWS::ApiGateway::RestApi":                                    ApiGatewayRestApi,
	"AWS::ApiGateway::Stage":                                      ApiGatewayStage,
	"AWS::ApiGateway::UsagePlan":                                  ApiGatewayUsagePlan,
	"AWS::ApiGateway::UsagePlanKey":                               ApiGatewayUsagePlanKey,
	"AWS::ApiGateway::VpcLink":                                    ApiGatewayVpcLink,
	"AWS::ApiGatewayV2::Api":                                      ApiGatewayV2Api,
	"AWS::ApiGatewayV2::ApiGatewayManagedOverrides":               Unmapped,
	"AWS::ApiGatewayV2::ApiMapping":                               ApiGatewayV2ApiMapping,
	"AWS::ApiGatewayV2::Authorizer":                               ApiGatewayV2Authorizer,
	"AWS::ApiGatewayV2::Deployment":                               ApiGatewayV2Deployment,
	"AWS::ApiGatewayV2::DomainName":                               ApiGatewayV2DomainName,
	"AWS::ApiGatewayV2::Integration":                              ApiGatewayV2Integration,
	"AWS::ApiGatewayV2::IntegrationResponse":                      Unmapped,
	"AWS::ApiGatewayV2::Model":                                    ApiGatewayV2Model,
	"AWS::ApiGatewayV2::Route":                                    ApiGatewayV2Route,
	"AWS::ApiGatewayV2::RouteResponse":                            Unmapped,
	"AWS::ApiGatewayV2::Stage":                                    ApiGatewayV2Stage,
	"AWS::ApiGatewayV2::VpcLink":                                  Unmapped,
	"AWS::AppConfig::Application":                                 Unmapped,
	"AWS::AppConfig::ConfigurationProfile":                        Unmapped,
	"AWS::AppConfig::Deployment":                                  Unmapped,
	"AWS::AppConfig::DeploymentStrategy":                          Unmapped,
	"AWS::AppConfig::Environment":                                 Unmapped,
	"AWS::AppConfig::HostedConfigurationVersion":                  Unmapped,
	"AWS::AppFlow::ConnectorProfile":                              Unmapped,
	"AWS::AppFlow::Flow":                                          Unmapped,
	"AWS::AppIntegrations::EventIntegration":                      Unmapped,
	"AWS::AppMesh::GatewayRoute":                                  Unmapped,
	"AWS::AppMesh::Mesh":                                          AppMeshMesh,
	"AWS::AppMesh::Route":                                         AppMeshRoute,
	"AWS::AppMesh::VirtualGateway":                                AppMeshVirtualGateway,
	"AWS::AppMesh::VirtualNode":                                   AppMeshVirtualNode,
	"AWS::AppMesh::VirtualRouter":                                 AppMeshVirtualRouter,
	"AWS::AppMesh::VirtualService":                                AppMeshVirtualService,
	"AWS::AppRunner::Service":                                     Unmapped,
	"AWS::AppStream::AppBlock":                                    Unmapped,
	"AWS::AppStream::Application":                                 Unmapped,
	"AWS::AppStream::ApplicationFleetAssociation":                 Unmapped,
	"AWS::AppStream::DirectoryConfig":                             Unmapped,
	"AWS::AppStream::Fleet":                                       Unmapped,
	"AWS::AppStream::ImageBuilder":                                Unmapped,
	"AWS::AppStream::Stack":                                       Unmapped,
	"AWS::AppStream::StackFleetAssociation":                       Unmapped,
	"AWS::AppStream::StackUserAssociation":                        Unmapped,
	"AWS::AppStream::User":                                        Unmapped,
	"AWS::AppSync::ApiCache":                                      AppSyncApiCache,
	"AWS::AppSync::ApiKey":                                        AppSyncApiKey,
	"AWS::AppSync::DataSource":                                    AppSyncDataSource,
	"AWS::AppSync::DomainName":                                    Unmapped,
	"AWS::AppSync::DomainNameApiAssociation":                      Unmapped,
	"AWS::AppSync::FunctionConfiguration":                         AppSyncFunction,
	"AWS::AppSync::GraphQLApi":                                    AppSyncGraphQLApi,
	"AWS::AppSync::GraphQLSchema":                                 AppSyncGraphQLSchema,
	"AWS::AppSync::Resolver":                                      AppSyncResolver,
	"AWS::ApplicationAutoScaling::ScalableTarget":                 ApplicationAutoScalingScalableTarget,
	"AWS::ApplicationAutoScaling::ScalingPolicy":                  ApplicationAutoScalingScalablePolicy,
	"AWS::ApplicationInsights::Application":                       Unmapped,
	"AWS::Athena::DataCatalog":                                    AthenaDataCatalog,
	"AWS::Athena::NamedQuery":                                     AthenaNamedQuery,
	"AWS::Athena::PreparedStatement":                              Unmapped,
	"AWS::Athena::WorkGroup":                                      AthenaWorkGroup,
	"AWS::AuditManager::Assessment":                               Unmapped,
	"AWS::AutoScaling::AutoScalingGroup":                          AutoscalingGroup,
	"AWS::AutoScaling::LaunchConfiguration":                       AutoscalingLaunchConfig,
	"AWS::AutoScaling::LifecycleHook":                             AutoscalingLifecycleHook,
	"AWS::AutoScaling::ScalingPolicy":                             AutoscalingPolicy,
	"AWS::AutoScaling::ScheduledAction":                           AutoscalingScheduledAction,
	"AWS::AutoScaling::WarmPool":                                  Unmapped,
	"AWS::AutoScalingPlans::ScalingPlan":                          Unmapped,
	"AWS::Backup::BackupPlan":                                     BackupPlan,
	"AWS::Backup::BackupSelection":                                BackupSelection,
	"AWS::Backup::BackupVault":                                    BackupVault,
	"AWS::Backup::Framework":                                      Unmapped,
	"AWS::Backup::ReportPlan":                                     Unmapped,
	"AWS::Batch::ComputeEnvironment":                              BatchComputeEnvironment,
	"AWS::Batch::JobDefinition":                                   BatchJobDefinition,
	"AWS::Batch::JobQueue":                                        BatchJobQueue,
	"AWS::Batch::SchedulingPolicy":                                Unmapped,
	"AWS::Budgets::Budget":                                        BudgetsBudget,
	"AWS::Budgets::BudgetsAction":                                 Unmapped,
	"AWS::CE::AnomalyMonitor":                                     Unmapped,
	"AWS::CE::AnomalySubscription":                                Unmapped,
	"AWS::CE::CostCategory":                                       Unmapped,
	"AWS::CUR::ReportDefinition":                                  Unmapped,
	"AWS::Cassandra::Keyspace":                                    Unmapped,
	"AWS::Cassandra::Table":                                       Unmapped,
	"AWS::CertificateManager::Account":                            Unmapped,
	"AWS::CertificateManager::Certificate":                        AcmCertificate,
	"AWS::Chatbot::SlackChannelConfiguration":                     Unmapped,
	"AWS::Cloud9::EnvironmentEC2":                                 Cloud9Environment,
	"AWS::CloudFormation::CustomResource":                         Unnecessary,
	"AWS::CloudFormation::Macro":                                  Unnecessary,
	"AWS::CloudFormation::ModuleDefaultVersion":                   Unmapped,
	"AWS::CloudFormation::ModuleVersion":                          Unmapped,
	"AWS::CloudFormation::ResourceDefaultVersion":                 Unmapped,
	"AWS::CloudFormation::ResourceVersion":                        Unmapped,
	"AWS::CloudFormation::Stack":                                  CloudFormationStack,
	"AWS::CloudFormation::StackSet":                               CloudFormationStackSet,
	"AWS::CloudFormation::WaitCondition":                          Unnecessary,
	"AWS::CloudFormation::WaitConditionHandle":                    Unnecessary,
	"AWS::CloudFront::CachePolicy":                                CloudFrontCachePolicy,
	"AWS::CloudFront::CloudFrontOriginAccessIdentity":             CloudFrontOriginAccessIdentity,
	"AWS::CloudFront::Distribution":                               CloudFrontDistribution,
	"AWS::CloudFront::KeyGroup":                                   CloudFrontKeyGroup,
	"AWS::CloudFront::OriginRequestPolicy":                        CloudFrontOriginRequestPolicy,
	"AWS::CloudFront::PublicKey":                                  CloudFrontPublicKey,
	"AWS::CloudFront::ResponseHeadersPolicy":                      Unmapped,
	"AWS::CloudFormation::PublicTypeVersion":                      Unmapped,
	"AWS::CloudFormation::Publisher":                              Unmapped,
	"AWS::CloudFormation::TypeActivation":                         Unmapped,
	"AWS::CloudFront::Function":                                   Unmapped,
	"AWS::CloudFront::RealtimeLogConfig":                          Unmapped,
	"AWS::CloudFront::StreamingDistribution":                      CloudFrontStreamingDistribution,
	"AWS::CloudTrail::Trail":                                      CloudtrailTrail,
	"AWS::CloudWatch::Alarm":                                      CloudwatchAlarm,
	"AWS::CloudWatch::AnomalyDetector":                            Unmapped,
	"AWS::CloudWatch::CompositeAlarm":                             Unmapped,
	"AWS::CloudWatch::Dashboard":                                  CloudwatchDashboard,
	"AWS::CloudWatch::InsightRule":                                Unmapped,
	"AWS::CloudWatch::MetricStream":                               Unmapped,
	"AWS::CodeArtifact::Domain":                                   Unmapped,
	"AWS::CodeArtifact::Repository":                               Unmapped,
	"AWS::CodeBuild::Project":                                     CodeBuildProject,
	"AWS::CodeBuild::ReportGroup":                                 Unmapped,
	"AWS::CodeBuild::SourceCredential":                            CodeBuildSourceCredential,
	"AWS::CodeCommit::Repository":                                 CodeCommitRepository,
	"AWS::CodeDeploy::Application":                                CodeDeployApplication,
	"AWS::CodeDeploy::DeploymentConfig":                           CodeDeployDeploymentConfig,
	"AWS::CodeDeploy::DeploymentGroup":                            CodeDeployDeploymentGroup,
	"AWS::CodeGuruProfiler::ProfilingGroup":                       Unmapped,
	"AWS::CodeGuruReviewer::RepositoryAssociation":                Unmapped,
	"AWS::CodePipeline::CustomActionType":                         Unmapped,
	"AWS::CodePipeline::Pipeline":                                 CodePipelinePipeline,
	"AWS::CodePipeline::Webhook":                                  CodePipelineWebhook,
	"AWS::CodeStar::GitHubRepository":                             Unmapped,
	"AWS::CodeStarConnections::Connection":                        Unmapped,
	"AWS::CodeStarNotifications::NotificationRule":                Unmapped,
	"AWS::Cognito::IdentityPool":                                  CognitoIdentityPool,
	"AWS::Cognito::IdentityPoolRoleAttachment":                    CognitoIdentityPool,
	"AWS::Cognito::UserPool":                                      CognitoUserPool,
	"AWS::Cognito::UserPoolClient":                                CognitoUserPoolClient,
	"AWS::Cognito::UserPoolDomain":                                CognitoUserPool, // TODO might need to confirm this
	"AWS::Cognito::UserPoolGroup":                                 CognitoUserPoolGroup,
	"AWS::Cognito::UserPoolIdentityProvider":                      CognitoUserPoolIdentityProvider,
	"AWS::Cognito::UserPoolResourceServer":                        CognitoUserPoolResourceServer,
	"AWS::Cognito::UserPoolRiskConfigurationAttachment":           Unmapped,
	"AWS::Cognito::UserPoolUICustomizationAttachment":             Unmapped,
	"AWS::Cognito::UserPoolUser":                                  Unmapped,
	"AWS::Cognito::UserPoolUserToGroupAttachment":                 Unmapped,
	"AWS::Config::AggregationAuthorization":                       ConfigAggregationAuthorization,
	"AWS::Config::ConfigRule":                                     ConfigRule,
	"AWS::Config::ConfigurationAggregator":                        ConfigConfigurationAggregator,
	"AWS::Config::ConfigurationRecorder":                          ConfigConfigurationRecorder,
	"AWS::Config::ConformancePack":                                ConfigConformancePack,
	"AWS::Config::DeliveryChannel":                                ConfigDeliveryChannel,
	"AWS::Config::OrganizationConfigRule":                         ConfigOrganizationConfigRule,
	"AWS::Config::OrganizationConformancePack":                    ConfigOrganizationConformancePack,
	"AWS::Config::RemediationConfiguration":                       ConfigRemediationConfiguration,
	"AWS::Config::StoredQuery":                                    Unmapped,
	"AWS::Connect::ContactFlow":                                   Unmapped,
	"AWS::Connect::ContactFlowModule":                             Unmapped,
	"AWS::Connect::HoursOfOperation":                              Unmapped,
	"AWS::Connect::QuickConnect":                                  Unmapped,
	"AWS::Connect::User":                                          Unmapped,
	"AWS::Connect::UserHierarchyGroup":                            Unmapped,
	"AWS::CustomerProfiles::Domain":                               Unmapped,
	"AWS::CustomerProfiles::Integration":                          Unmapped,
	"AWS::CustomerProfiles::ObjectType":                           Unmapped,
	"AWS::DAX::Cluster":                                           DAXCluster,
	"AWS::DAX::ParameterGroup":                                    DAXParameterGroup,
	"AWS::DAX::SubnetGroup":                                       DAXSubnetGroup,
	"AWS::DLM::LifecyclePolicy":                                   Unmapped,
	"AWS::DMS::Certificate":                                       Unmapped,
	"AWS::DMS::Endpoint":                                          DMSEndpoint,
	"AWS::DMS::EventSubscription":                                 Unmapped,
	"AWS::DMS::ReplicationInstance":                               DMSReplicationInstance,
	"AWS::DMS::ReplicationSubnetGroup":                            DMSReplicationSubnetGroup,
	"AWS::DMS::ReplicationTask":                                   DMSReplicationTask,
	"AWS::DataBrew::Dataset":                                      Unmapped,
	"AWS::DataBrew::Job":                                          Unmapped,
	"AWS::DataBrew::Project":                                      Unmapped,
	"AWS::DataBrew::Recipe":                                       Unmapped,
	"AWS::DataBrew::Ruleset":                                      Unmapped,
	"AWS::DataBrew::Schedule":                                     Unmapped,
	"AWS::DataPipeline::Pipeline":                                 Unmapped,
	"AWS::DataSync::Agent":                                        Unmapped,
	"AWS::DataSync::LocationEFS":                                  Unmapped,
	"AWS::DataSync::LocationFSxWindows":                           Unmapped,
	"AWS::DataSync::LocationHDFS":                                 Unmapped,
	"AWS::DataSync::LocationNFS":                                  Unmapped,
	"AWS::DataSync::LocationObjectStorage":                        Unmapped,
	"AWS::DataSync::LocationS3":                                   Unmapped,
	"AWS::DataSync::LocationSMB":                                  Unmapped,
	"AWS::DataSync::Task":                                         Unmapped,
	"AWS::Detective::Graph":                                       Unmapped,
	"AWS::Detective::MemberInvitation":                            Unmapped,
	"AWS::DevOpsGuru::NotificationChannel":                        Unmapped,
	"AWS::DevOpsGuru::ResourceCollection":                         Unmapped,
	"AWS::DirectoryService::MicrosoftAD":                          Unmapped,
	"AWS::DirectoryService::SimpleAD":                             Unmapped,
	"AWS::DocDB::DBCluster":                                       DocDBCluster,
	"AWS::DocDB::DBClusterParameterGroup":                         DocDBParameterGroup,
	"AWS::DocDB::DBInstance":                                      DocDBInstance,
	"AWS::DocDB::DBSubnetGroup":                                   DocDBSubnetGroup,
	"AWS::DynamoDB::Table":                                        DynamoDbTable,
	"AWS::DynamoDB::GlobalTable":                                  Unmapped,
	"AWS::EC2::CapacityReservation":                               Unmapped,
	"AWS::EC2::CapacityReservationFleet":                          Unmapped,
	"AWS::EC2::CarrierGateway":                                    Unmapped,
	"AWS::EC2::ClientVpnAuthorizationRule":                        Unmapped,
	"AWS::EC2::ClientVpnEndpoint":                                 Unmapped,
	"AWS::EC2::ClientVpnRoute":                                    Unmapped,
	"AWS::EC2::ClientVpnTargetNetworkAssociation":                 Unmapped,
	"AWS::EC2::CustomerGateway":                                   Ec2CustomerGateway,
	"AWS::EC2::DHCPOptions":                                       Ec2DHCPOption,
	"AWS::EC2::EC2Fleet":                                          Unmapped,
	"AWS::EC2::EIP":                                               Ec2Eip,
	"AWS::EC2::EIPAssociation":                                    Ec2Eip,
	"AWS::EC2::EgressOnlyInternetGateway":                         Unmapped,
	"AWS::EC2::EnclaveCertificateIamRoleAssociation":              Unmapped,
	"AWS::EC2::FlowLog":                                           Ec2FlowLog,
	"AWS::EC2::GatewayRouteTableAssociation":                      Unmapped,
	"AWS::EC2::Host":                                              Unmapped,
	"AWS::EC2::Instance":                                          Ec2Instance,
	"AWS::EC2::InternetGateway":                                   Ec2InternetGateway,
	"AWS::EC2::IPAM":                                              Unmapped,
	"AWS::EC2::IPAMAllocation":                                    Unmapped,
	"AWS::EC2::IPAMPool":                                          Unmapped,
	"AWS::EC2::IPAMScope":                                         Unmapped,
	"AWS::EC2::LaunchTemplate":                                    Ec2LaunchTemplate,
	"AWS::EC2::LocalGatewayRoute":                                 Unmapped,
	"AWS::EC2::LocalGatewayRouteTableVPCAssociation":              Unmapped,
	"AWS::EC2::NatGateway":                                        Ec2NatGateway,
	"AWS::EC2::NetworkAcl":                                        Ec2NetworkACL,
	"AWS::EC2::NetworkAclEntry":                                   Ec2NetworkACL,
	"AWS::EC2::NetworkInsightsAnalysis":                           Unmapped,
	"AWS::EC2::NetworkInsightsPath":                               Unmapped,
	"AWS::EC2::NetworkInterface":                                  Ec2NetworkInterface,
	"AWS::EC2::NetworkInterfaceAttachment":                        Ec2NetworkInterface,
	"AWS::EC2::NetworkInterfacePermission":                        Unmapped,
	"AWS::EC2::PlacementGroup":                                    Unmapped,
	"AWS::EC2::PrefixList":                                        Unmapped,
	"AWS::EC2::Route":                                             Ec2Route,
	"AWS::EC2::RouteTable":                                        Ec2RouteTable,
	"AWS::EC2::SecurityGroup":                                     Ec2SecurityGroup,
	"AWS::EC2::SecurityGroupEgress":                               Ec2SecurityGroup,
	"AWS::EC2::SecurityGroupIngress":                              Ec2SecurityGroup,
	"AWS::EC2::SpotFleet":                                         Ec2SpotFleet,
	"AWS::EC2::Subnet":                                            Ec2Subnet,
	"AWS::EC2::SubnetCidrBlock":                                   Ec2Subnet,
	"AWS::EC2::SubnetNetworkAclAssociation":                       Ec2NetworkACL,
	"AWS::EC2::SubnetRouteTableAssociation":                       Ec2RouteTable,
	"AWS::EC2::TrafficMirrorFilter":                               Unmapped,
	"AWS::EC2::TrafficMirrorFilterRule":                           Unmapped,
	"AWS::EC2::TrafficMirrorSession":                              Unmapped,
	"AWS::EC2::TrafficMirrorTarget":                               Unmapped,
	"AWS::EC2::TransitGateway":                                    Ec2TransitGateway,
	"AWS::EC2::TransitGatewayAttachment":                          Ec2TransitGatewayAttachment,
	"AWS::EC2::TransitGatewayConnect":                             Unmapped,
	"AWS::EC2::TransitGatewayMulticastDomain":                     Unmapped,
	"AWS::EC2::TransitGatewayMulticastDomainAssociation":          Unmapped,
	"AWS::EC2::TransitGatewayMulticastGroupMember":                Unmapped,
	"AWS::EC2::TransitGatewayMulticastGroupSource":                Unmapped,
	"AWS::EC2::TransitGatewayPeeringAttachment":                   Unmapped,
	"AWS::EC2::TransitGatewayRoute":                               Unmapped,
	"AWS::EC2::TransitGatewayRouteTable":                          Ec2TransitGatewayRouteTable,
	"AWS::EC2::TransitGatewayRouteTableAssociation":               Ec2TransitGatewayRouteTable,
	"AWS::EC2::TransitGatewayRouteTablePropagation":               Ec2TransitGatewayRouteTable,
	"AWS::EC2::TransitGatewayVpcAttachment":                       Unmapped,
	"AWS::EC2::VPC":                                               Ec2Vpc,
	"AWS::EC2::VPCCidrBlock":                                      Ec2Vpc,
	"AWS::EC2::VPCDHCPOptionsAssociation":                         Ec2Vpc,
	"AWS::EC2::VPCEndpoint":                                       Ec2VpcEndpoint,
	"AWS::EC2::VPCEndpointConnectionNotification":                 Ec2VpcEndpointConnectionNotification,
	"AWS::EC2::VPCEndpointService":                                Ec2VpcEndpointService,
	"AWS::EC2::VPCEndpointServicePermissions":                     Ec2VpcEndpointService,
	"AWS::EC2::VPCGatewayAttachment":                              Ec2VpnGateway,
	"AWS::EC2::VPCPeeringConnection":                              Ec2VpcPeering,
	"AWS::EC2::VPNConnection":                                     Ec2VpnConnection,
	"AWS::EC2::VPNConnectionRoute":                                Ec2VpnConnection,
	"AWS::EC2::VPNGateway":                                        Ec2VpnGateway,
	"AWS::EC2::VPNGatewayRoutePropagation":                        Unmapped,
	"AWS::EC2::Volume":                                            Ec2Volume,
	"AWS::EC2::VolumeAttachment":                                  Ec2Volume,
	"AWS::ECR::RegistryPolicy":                                    Unmapped,
	"AWS::ECR::ReplicationConfiguration":                          Unmapped,
	"AWS::ECR::Repository":                                        EcrRepository,
	"AWS::ECR::PublicRepository":                                  Unmapped,
	"AWS::ECS::CapacityProvider":                                  EcsCapacityProvider,
	"AWS::ECS::Cluster":                                           EcsCluster,
	"AWS::ECS::ClusterCapacityProviderAssociations":               Unmapped,
	"AWS::ECS::PrimaryTaskSet":                                    Unmapped,
	"AWS::ECS::Service":                                           EcsService,
	"AWS::ECS::TaskDefinition":                                    EcsTaskDefinition,
	"AWS::ECS::TaskSet":                                           Unmapped,
	"AWS::EFS::AccessPoint":                                       EfsAccessPoint,
	"AWS::EFS::FileSystem":                                        EfsFileSystem,
	"AWS::EFS::MountTarget":                                       EfsMountTarget,
	"AWS::EKS::Addon":                                             Unmapped,
	"AWS::EKS::Cluster":                                           EksCluster,
	"AWS::EKS::FargateProfile":                                    EksFargateProfile,
	"AWS::EKS::Nodegroup":                                         EksNodeGroup,
	"AWS::EMR::Cluster":                                           EmrCluster,
	"AWS::EMR::InstanceFleetConfig":                               EmrInstanceFleetConfig,
	"AWS::EMR::InstanceGroupConfig":                               EmrInstanceGroupConfig,
	"AWS::EMR::SecurityConfiguration":                             EmrSecurityConfiguration,
	"AWS::EMR::Step":                                              EmrStep,
	"AWS::EMR::Studio":                                            Unmapped,
	"AWS::EMR::StudioSessionMapping":                              Unmapped,
	"AWS::EMRContainers::VirtualCluster":                          Unmapped,
	"AWS::ElastiCache::CacheCluster":                              ElasticacheCluster,
	"AWS::ElastiCache::GlobalReplicationGroup":                    Unmapped,
	"AWS::ElastiCache::ParameterGroup":                            ElasticacheParameterGroup,
	"AWS::ElastiCache::ReplicationGroup":                          ElasticacheReplicationGroup,
	"AWS::ElastiCache::SecurityGroup":                             ElasticacheSecurityGroup,
	"AWS::ElastiCache::SecurityGroupIngress":                      Unmapped,
	"AWS::ElastiCache::SubnetGroup":                               ElasticacheSubnetGroup,
	"AWS::ElastiCache::User":                                      Unmapped,
	"AWS::ElastiCache::UserGroup":                                 Unmapped,
	"AWS::ElasticBeanstalk::Application":                          ElasticBeanstalkApplication,
	"AWS::ElasticBeanstalk::ApplicationVersion":                   Unmapped,
	"AWS::ElasticBeanstalk::ConfigurationTemplate":                ElasticBeanstalkEnvironment,
	"AWS::ElasticBeanstalk::Environment":                          ElasticBeanstalkEnvironment,
	"AWS::ElasticLoadBalancing::LoadBalancer":                     ElbLoadBalancer,
	"AWS::ElasticLoadBalancingV2::Listener":                       ElbV2Listener,
	"AWS::ElasticLoadBalancingV2::ListenerCertificate":            Unmapped,
	"AWS::ElasticLoadBalancingV2::ListenerRule":                   ElbV2ListenerRule,
	"AWS::ElasticLoadBalancingV2::LoadBalancer":                   ElbV2LoadBalancer,
	"AWS::ElasticLoadBalancingV2::TargetGroup":                    ElbV2TargetGroup,
	"AWS::Elasticsearch::Domain":                                  ElasticsearchDomain,
	"AWS::Events::ApiDestination":                                 Unmapped,
	"AWS::Events::Archive":                                        Unmapped,
	"AWS::Events::Connection":                                     Unmapped,
	"AWS::Events::EventBus":                                       EventsBus,
	"AWS::Events::EventBusPolicy":                                 EventsBus,
	"AWS::Events::Rule":                                           EventsRule,
	"AWS::EventSchemas::Discoverer":                               Unmapped,
	"AWS::EventSchemas::Registry":                                 Unmapped,
	"AWS::EventSchemas::RegistryPolicy":                           Unmapped,
	"AWS::EventSchemas::Schema":                                   Unmapped,
	"AWS::Evidently::Experiment":                                  Unmapped,
	"AWS::Evidently::Feature":                                     Unmapped,
	"AWS::Evidently::Launch":                                      Unmapped,
	"AWS::Evidently::Project":                                     Unmapped,
	"AWS::FIS::ExperimentTemplate":                                Unmapped,
	"AWS::FMS::NotificationChannel":                               Unmapped,
	"AWS::FMS::Policy":                                            Unmapped,
	"AWS::FSx::FileSystem":                                        FSxFileSystem,
	"AWS::FinSpace::Environment":                                  Unmapped,
	"AWS::FraudDetector::Detector":                                Unmapped,
	"AWS::FraudDetector::EntityType":                              Unmapped,
	"AWS::FraudDetector::EventType":                               Unmapped,
	"AWS::FraudDetector::Label":                                   Unmapped,
	"AWS::FraudDetector::Outcome":                                 Unmapped,
	"AWS::FraudDetector::Variable":                                Unmapped,
	"AWS::GameLift::Alias":                                        Unmapped,
	"AWS::GameLift::Build":                                        Unmapped,
	"AWS::GameLift::Fleet":                                        Unmapped,
	"AWS::GameLift::GameServerGroup":                              Unmapped,
	"AWS::GameLift::GameSessionQueue":                             Unmapped,
	"AWS::GameLift::MatchmakingConfiguration":                     Unmapped,
	"AWS::GameLift::MatchmakingRuleSet":                           Unmapped,
	"AWS::GameLift::Script":                                       Unmapped,
	"AWS::GlobalAccelerator::Accelerator":                         Unmapped,
	"AWS::GlobalAccelerator::EndpointGroup":                       Unmapped,
	"AWS::GlobalAccelerator::Listener":                            Unmapped,
	"AWS::Glue::Classifier":                                       GlueClassifier,
	"AWS::Glue::Connection":                                       GlueConnection,
	"AWS::Glue::Crawler":                                          GlueCrawler,
	"AWS::Glue::DataCatalogEncryptionSettings":                    Unmapped,
	"AWS::Glue::Database":                                         GlueDatabase,
	"AWS::Glue::DevEndpoint":                                      Unmapped,
	"AWS::Glue::Job":                                              GlueJob,
	"AWS::Glue::MLTransform":                                      Unmapped,
	"AWS::Glue::Partition":                                        Unmapped,
	"AWS::Glue::Registry":                                         Unmapped,
	"AWS::Glue::Schema":                                           Unmapped,
	"AWS::Glue::SchemaVersion":                                    Unmapped,
	"AWS::Glue::SchemaVersionMetadata":                            Unmapped,
	"AWS::Glue::SecurityConfiguration":                            Unmapped,
	"AWS::Glue::Table":                                            GlueTable,
	"AWS::Glue::Trigger":                                          GlueTrigger,
	"AWS::Glue::Workflow":                                         GlueWorkflow,
	"AWS::Greengrass::ConnectorDefinition":                        GreengrassConnectorDefinition,
	"AWS::Greengrass::ConnectorDefinitionVersion":                 GreengrassConnectorDefinitionVersion,
	"AWS::Greengrass::CoreDefinition":                             GreengrassCoreDefinition,
	"AWS::Greengrass::CoreDefinitionVersion":                      GreengrassCoreDefinitionVersion,
	"AWS::Greengrass::DeviceDefinition":                           GreengrassDeviceDefinition,
	"AWS::Greengrass::DeviceDefinitionVersion":                    GreengrassDeviceDefinitionVersion,
	"AWS::Greengrass::FunctionDefinition":                         GreengrassFunctionDefinition,
	"AWS::Greengrass::FunctionDefinitionVersion":                  GreengrassFunctionDefinitionVersion,
	"AWS::Greengrass::Group":                                      GreengrassGroup,
	"AWS::Greengrass::GroupVersion":                               GreengrassGroupVersion,
	"AWS::Greengrass::LoggerDefinition":                           GreengrassLoggerDefinition,
	"AWS::Greengrass::LoggerDefinitionVersion":                    GreengrassLoggerDefinitionVersion,
	"AWS::Greengrass::ResourceDefinition":                         GreengrassResourceDefinition,
	"AWS::Greengrass::ResourceDefinitionVersion":                  GreengrassResourceDefinitionVersion,
	"AWS::Greengrass::SubscriptionDefinition":                     GreengrassSubscriptionDefinition,
	"AWS::Greengrass::SubscriptionDefinitionVersion":              GreengrassSubscriptionDefinitionVersion,
	"AWS::GreengrassV2::ComponentVersion":                         Unmapped,
	"AWS::GroundStation::Config":                                  Unmapped,
	"AWS::GroundStation::DataflowEndpointGroup":                   Unmapped,
	"AWS::GroundStation::MissionProfile":                          Unmapped,
	"AWS::GuardDuty::Detector":                                    GuardDutyDetector,
	"AWS::GuardDuty::Filter":                                      Unmapped,
	"AWS::GuardDuty::IPSet":                                       Unmapped,
	"AWS::GuardDuty::Master":                                      Unmapped,
	"AWS::GuardDuty::Member":                                      GuardDutyMember,
	"AWS::GuardDuty::ThreatIntelSet":                              Unmapped,
	"AWS::HealthLake::FHIRDatastore":                              Unmapped,
	"AWS::IAM::AccessKey":                                         IamAccessKey,
	"AWS::IAM::Group":                                             IamGroup,
	"AWS::IAM::InstanceProfile":                                   IamInstanceProfile,
	"AWS::IAM::ManagedPolicy":                                     IamPolicy,
	"AWS::IAM::OIDCProvider":                                      Unmapped,
	"AWS::IAM::Policy":                                            IamPolicy,
	"AWS::IAM::Role":                                              IamRole,
	"AWS::IAM::SAMLProvider":                                      Unmapped,
	"AWS::IAM::ServerCertificate":                                 Unmapped,
	"AWS::IAM::ServiceLinkedRole":                                 Unmapped,
	"AWS::IAM::User":                                              IamUser,
	"AWS::IAM::UserToGroupAddition":                               Unmapped,
	"AWS::IAM::VirtualMFADevice":                                  Unmapped,
	"AWS::IVS::Channel":                                           Unmapped,
	"AWS::IVS::PlaybackKeyPair":                                   Unmapped,
	"AWS::IVS::RecordingConfiguration":                            Unmapped,
	"AWS::IVS::StreamKey":                                         Unmapped,
	"AWS::ImageBuilder::Component":                                Unmapped,
	"AWS::ImageBuilder::ContainerRecipe":                          Unmapped,
	"AWS::ImageBuilder::DistributionConfiguration":                ImageBuilderDistributionConfiguration,
	"AWS::ImageBuilder::Image":                                    ImageBuilderImage,
	"AWS::ImageBuilder::ImagePipeline":                            ImageBuilderImagePipeline,
	"AWS::ImageBuilder::ImageRecipe":                              ImageBuilderImageRecipe,
	"AWS::ImageBuilder::InfrastructureConfiguration":              ImageBuilderInfrastructureConfiguration,
	"AWS::Inspector::AssessmentTarget":                            Unmapped,
	"AWS::Inspector::AssessmentTemplate":                          Unmapped,
	"AWS::Inspector::ResourceGroup":                               Unmapped,
	"AWS::IoT1Click::Device":                                      Unmapped,
	"AWS::IoT1Click::Placement":                                   Unmapped,
	"AWS::IoT1Click::Project":                                     Unmapped,
	"AWS::IoT::AccountAuditConfiguration":                         Unmapped,
	"AWS::IoT::Authorizer":                                        Unmapped,
	"AWS::IoT::Certificate":                                       IoTCertificate,
	"AWS::IoT::CustomMetric":                                      Unmapped,
	"AWS::IoT::Dimension":                                         Unmapped,
	"AWS::IoT::DomainConfiguration":                               Unmapped,
	"AWS::IoT::FleetMetric":                                       Unmapped,
	"AWS::IoT::JobTemplate":                                       Unmapped,
	"AWS::IoT::Logging":                                           Unmapped,
	"AWS::IoT::MitigationAction":                                  Unmapped,
	"AWS::IoT::Policy":                                            IoTPolicy,
	"AWS::IoT::PolicyPrincipalAttachment":                         Unmapped,
	"AWS::IoT::ProvisioningTemplate":                              Unmapped,
	"AWS::IoT::ResourceSpecificLogging":                           Unmapped,
	"AWS::IoT::ScheduledAudit":                                    Unmapped,
	"AWS::IoT::SecurityProfile":                                   Unmapped,
	"AWS::IoT::Thing":                                             IoTThing,
	"AWS::IoT::ThingPrincipalAttachment":                          Unmapped,
	"AWS::IoT::TopicRule":                                         IotTopicRule,
	"AWS::IoT::TopicRuleDestination":                              IotTopicRuleDestination,
	"AWS::IoTAnalytics::Channel":                                  Unmapped,
	"AWS::IoTAnalytics::Dataset":                                  Unmapped,
	"AWS::IoTAnalytics::Datastore":                                Unmapped,
	"AWS::IoTAnalytics::Pipeline":                                 Unmapped,
	"AWS::IoTCoreDeviceAdvisor::SuiteDefinition":                  Unmapped,
	"AWS::IoTEvents::DetectorModel":                               Unmapped,
	"AWS::IoTEvents::Input":                                       Unmapped,
	"AWS::IoTFleetHub::Application":                               Unmapped,
	"AWS::IoTSiteWise::AccessPolicy":                              Unmapped,
	"AWS::IoTSiteWise::Asset":                                     IoTSiteWiseAsset,
	"AWS::IoTSiteWise::AssetModel":                                IoTSiteWiseAssetModel,
	"AWS::IoTSiteWise::Dashboard":                                 Unmapped,
	"AWS::IoTSiteWise::Gateway":                                   IoTSiteWiseGateway,
	"AWS::IoTSiteWise::Portal":                                    Unmapped,
	"AWS::IoTSiteWise::Project":                                   Unmapped,
	"AWS::IoTThingsGraph::FlowTemplate":                           Unmapped,
	"AWS::IoTWireless::Destination":                               Unmapped,
	"AWS::IoTWireless::DeviceProfile":                             Unmapped,
	"AWS::IoTWireless::FuotaTask":                                 Unmapped,
	"AWS::IoTWireless::MulticastGroup":                            Unmapped,
	"AWS::IoTWireless::PartnerAccount":                            Unmapped,
	"AWS::IoTWireless::ServiceProfile":                            Unmapped,
	"AWS::IoTWireless::TaskDefinition":                            Unmapped,
	"AWS::IoTWireless::WirelessDevice":                            Unmapped,
	"AWS::IoTWireless::WirelessGateway":                           Unmapped,
	"AWS::KMS::Alias":                                             KmsAlias,
	"AWS::KMS::Key":                                               KmsKey,
	"AWS::KMS::ReplicaKey":                                        Unmapped,
	"AWS::Kendra::DataSource":                                     Unmapped,
	"AWS::Kendra::Faq":                                            Unmapped,
	"AWS::Kendra::Index":                                          Unmapped,
	"AWS::Kinesis::Stream":                                        KinesisStream,
	"AWS::Kinesis::StreamConsumer":                                Unmapped,
	"AWS::KinesisAnalytics::Application":                          Unmapped,
	"AWS::KinesisAnalytics::ApplicationOutput":                    Unmapped,
	"AWS::KinesisAnalytics::ApplicationReferenceDataSource":       Unmapped,
	"AWS::KinesisAnalyticsV2::Application":                        Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption": Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationOutput":                  Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource":     Unmapped,
	"AWS::KinesisFirehose::DeliveryStream":                        FirehoseDeliveryStream,
	"AWS::LakeFormation::DataLakeSettings":                        Unmapped,
	"AWS::LakeFormation::Permissions":                             Unmapped,
	"AWS::LakeFormation::Resource":                                Unmapped,
	"AWS::Lambda::Alias":                                          LambdaAlias,
	"AWS::Lambda::CodeSigningConfig":                              Unmapped,
	"AWS::Lambda::EventInvokeConfig":                              LambdaFunction, //LambdaEventInvokeConfig,
	"AWS::Lambda::EventSourceMapping":                             LambdaEventSourceMapping,
	"AWS::Lambda::Function":                                       LambdaFunction,
	"AWS::Lambda::LayerVersion":                                   LambdaLayerVersion,
	"AWS::Lambda::LayerVersionPermission":                         Unmapped,
	"AWS::Lambda::Permission":                                     Unnecessary,
	"AWS::Lambda::Version":                                        LambdaVersion,
	"AWS::Lex::Bot":                                               Unmapped,
	"AWS::Lex::BotAlias":                                          Unmapped,
	"AWS::Lex::BotVersion":                                        Unmapped,
	"AWS::Lex::ResourcePolicy":                                    Unmapped,
	"AWS::LicenseManager::Grant":                                  Unmapped,
	"AWS::LicenseManager::License":                                Unmapped,
	"AWS::Lightsail::Database":                                    Unmapped,
	"AWS::Lightsail::Disk":                                        Unmapped,
	"AWS::Lightsail::Instance":                                    Unmapped,
	"AWS::Lightsail::StaticIp":                                    Unmapped,
	"AWS::Location::GeofenceCollection":                           Unmapped,
	"AWS::Location::Map":                                          Unmapped,
	"AWS::Location::PlaceIndex":                                   Unmapped,
	"AWS::Location::RouteCalculator":                              Unmapped,
	"AWS::Location::Tracker":                                      Unmapped,
	"AWS::Location::TrackerConsumer":                              Unmapped,
	"AWS::Logs::Destination":                                      Unmapped,
	"AWS::Logs::LogGroup":                                         LogGroup,
	"AWS::Logs::LogStream":                                        LogStream,
	"AWS::Logs::MetricFilter":                                     LogMetricFilter,
	"AWS::Logs::QueryDefinition":                                  Unmapped,
	"AWS::Logs::ResourcePolicy":                                   Unmapped,
	"AWS::Logs::SubscriptionFilter":                               LogSubscriptionFilter,
	"AWS::LookoutEquipment::InferenceScheduler":                   Unmapped,
	"AWS::LookoutMetrics::Alert":                                  Unmapped,
	"AWS::LookoutMetrics::AnomalyDetector":                        Unmapped,
	"AWS::LookoutVision::Project":                                 Unmapped,
	"AWS::MSK::Cluster":                                           KafkaCluster,
	"AWS::MWAA::Environment":                                      Unmapped,
	"AWS::Macie::CustomDataIdentifier":                            Unmapped,
	"AWS::Macie::FindingsFilter":                                  Unmapped,
	"AWS::Macie::Session":                                         Unmapped,
	"AWS::ManagedBlockchain::Member":                              Unmapped,
	"AWS::ManagedBlockchain::Node":                                Unmapped,
	"AWS::MediaConnect::Flow":                                     Unmapped,
	"AWS::MediaConnect::FlowEntitlement":                          Unmapped,
	"AWS::MediaConnect::FlowOutput":                               Unmapped,
	"AWS::MediaConnect::FlowSource":                               Unmapped,
	"AWS::MediaConnect::FlowVpcInterface":                         Unmapped,
	"AWS::MediaConvert::JobTemplate":                              Unmapped,
	"AWS::MediaConvert::Preset":                                   Unmapped,
	"AWS::MediaConvert::Queue":                                    Unmapped,
	"AWS::MediaLive::Channel":                                     Unmapped,
	"AWS::MediaLive::Input":                                       Unmapped,
	"AWS::MediaLive::InputSecurityGroup":                          Unmapped,
	"AWS::MediaPackage::Asset":                                    Unmapped,
	"AWS::MediaPackage::Channel":                                  Unmapped,
	"AWS::MediaPackage::OriginEndpoint":                           Unmapped,
	"AWS::MediaPackage::PackagingConfiguration":                   Unmapped,
	"AWS::MediaPackage::PackagingGroup":                           Unmapped,
	"AWS::MediaStore::Container":                                  Unmapped,
	"AWS::MemoryDB::ACL":                                          Unmapped,
	"AWS::MemoryDB::Cluster":                                      Unmapped,
	"AWS::MemoryDB::ParameterGroup":                               Unmapped,
	"AWS::MemoryDB::SubnetGroup":                                  Unmapped,
	"AWS::MemoryDB::User":                                         Unmapped,
	"AWS::Neptune::DBCluster":                                     NeptuneDbCluster,
	"AWS::Neptune::DBClusterParameterGroup":                       NeptuneDbClusterParameterGroup,
	"AWS::Neptune::DBInstance":                                    NeptuneDbInstance,
	"AWS::Neptune::DBParameterGroup":                              NeptuneDbParameterGroup,
	"AWS::Neptune::DBSubnetGroup":                                 NeptuneDbSubnetGroup,
	"AWS::NetworkFirewall::Firewall":                              Unmapped,
	"AWS::NetworkFirewall::FirewallPolicy":                        Unmapped,
	"AWS::NetworkFirewall::LoggingConfiguration":                  Unmapped,
	"AWS::NetworkFirewall::RuleGroup":                             Unmapped,
	"AWS::NetworkManager::CustomerGatewayAssociation":             Unmapped,
	"AWS::NetworkManager::Device":                                 Unmapped,
	"AWS::NetworkManager::GlobalNetwork":                          Unmapped,
	"AWS::NetworkManager::Link":                                   Unmapped,
	"AWS::NetworkManager::LinkAssociation":                        Unmapped,
	"AWS::NetworkManager::Site":                                   Unmapped,
	"AWS::NetworkManager::TransitGatewayRegistration":             Unmapped,
	"AWS::NimbleStudio::LaunchProfile":                            Unmapped,
	"AWS::NimbleStudio::StreamingImage":                           Unmapped,
	"AWS::NimbleStudio::Studio":                                   Unmapped,
	"AWS::NimbleStudio::StudioComponent":                          Unmapped,
	"AWS::OpenSearchService::Domain":                              Unmapped,
	"AWS::OpsWorks::App":                                          Unmapped,
	"AWS::OpsWorks::ElasticLoadBalancerAttachment":                Unmapped,
	"AWS::OpsWorks::Instance":                                     Unmapped,
	"AWS::OpsWorks::Layer":                                        Unmapped,
	"AWS::OpsWorks::Stack":                                        Unmapped,
	"AWS::OpsWorks::UserProfile":                                  Unmapped,
	"AWS::OpsWorks::Volume":                                       Unmapped,
	"AWS::OpsWorksCM::Server":                                     Unmapped,
	"AWS::Panorama::ApplicationInstance":                          Unmapped,
	"AWS::Panorama::Package":                                      Unmapped,
	"AWS::Panorama::PackageVersion":                               Unmapped,
	"AWS::Pinpoint::ADMChannel":                                   Unmapped,
	"AWS::Pinpoint::APNSChannel":                                  Unmapped,
	"AWS::Pinpoint::APNSSandboxChannel":                           Unmapped,
	"AWS::Pinpoint::APNSVoipChannel":                              Unmapped,
	"AWS::Pinpoint::APNSVoipSandboxChannel":                       Unmapped,
	"AWS::Pinpoint::App":                                          Unmapped,
	"AWS::Pinpoint::ApplicationSettings":                          Unmapped,
	"AWS::Pinpoint::BaiduChannel":                                 Unmapped,
	"AWS::Pinpoint::Campaign":                                     Unmapped,
	"AWS::Pinpoint::EmailChannel":                                 Unmapped,
	"AWS::Pinpoint::EmailTemplate":                                Unmapped,
	"AWS::Pinpoint::EventStream":                                  Unmapped,
	"AWS::Pinpoint::GCMChannel":                                   Unmapped,
	"AWS::Pinpoint::InAppTemplate":                                Unmapped,
	"AWS::Pinpoint::PushTemplate":                                 Unmapped,
	"AWS::Pinpoint::SMSChannel":                                   Unmapped,
	"AWS::Pinpoint::SmsTemplate":                                  Unmapped,
	"AWS::Pinpoint::Segment":                                      Unmapped,
	"AWS::Pinpoint::VoiceChannel":                                 Unmapped,
	"AWS::PinpointEmail::ConfigurationSet":                        Unmapped,
	"AWS::PinpointEmail::ConfigurationSetEventDestination":        Unmapped,
	"AWS::PinpointEmail::DedicatedIpPool":                         Unmapped,
	"AWS::PinpointEmail::Identity":                                Unmapped,
	"AWS::QLDB::Ledger":                                           QLDBLedger,
	"AWS::QLDB::Stream":                                           Unmapped,
	"AWS::QuickSight::Analysis":                                   Unmapped,
	"AWS::QuickSight::Dashboard":                                  Unmapped,
	"AWS::QuickSight::DataSet":                                    Unmapped,
	"AWS::QuickSight::DataSource":                                 Unmapped,
	"AWS::QuickSight::Template":                                   Unmapped,
	"AWS::QuickSight::Theme":                                      Unmapped,
	"AWS::RAM::ResourceShare":                                     Unmapped,
	"AWS::RDS::DBCluster":                                         RdsDbCluster,
	"AWS::RDS::DBClusterParameterGroup":                           RdsDbClusterParameterGroup,
	"AWS::RDS::DBInstance":                                        RdsDbInstance,
	"AWS::RDS::DBParameterGroup":                                  RdsDbParameterGroup,
	"AWS::RDS::DBProxy":                                           RdsDbProxy,
	"AWS::RDS::DBProxyEndpoint":                                   Unmapped,
	"AWS::RDS::DBProxyTargetGroup":                                RdsDbProxyTargetGroup,
	"AWS::RDS::DBSecurityGroup":                                   Unmapped, // TODO: are these different than ec2 security groups?
	"AWS::RDS::DBSecurityGroupIngress":                            Unmapped,
	"AWS::RDS::DBSubnetGroup":                                     RdsDbSubnetGroup,
	"AWS::RDS::EventSubscription":                                 Unmapped,
	"AWS::RDS::GlobalCluster":                                     Unmapped,
	"AWS::RDS::OptionGroup":                                       Unmapped,
	"AWS::RUM::AppMonitor":                                        Unmapped,
	"AWS::Redshift::Cluster":                                      RedshiftCluster,
	"AWS::Redshift::ClusterParameterGroup":                        RedshiftParameterGroup,
	"AWS::Redshift::ClusterSecurityGroup":                         RedshiftSecurityGroup,
	"AWS::Redshift::ClusterSecurityGroupIngress":                  Unmapped,
	"AWS::Redshift::ClusterSubnetGroup":                           RedshiftSubnetGroup,
	"AWS::Redshift::EndpointAccess":                               Unmapped,
	"AWS::Redshift::EndpointAuthorization":                        Unmapped,
	"AWS::Redshift::EventSubscription":                            Unmapped,
	"AWS::Redshift::ScheduledAction":                              Unmapped,
	"AWS::RefactorSpaces::Application":                            Unmapped,
	"AWS::RefactorSpaces::Environment":                            Unmapped,
	"AWS::RefactorSpaces::Route":                                  Unmapped,
	"AWS::RefactorSpaces::Service":                                Unmapped,
	"AWS::Rekognition::Project":                                   Unmapped,
	"AWS::ResilienceHub::App":                                     Unmapped,
	"AWS::ResilienceHub::ResiliencyPolicy":                        Unmapped,
	"AWS::ResourceGroups::Group":                                  Unmapped,
	"AWS::RoboMaker::Fleet":                                       Unmapped,
	"AWS::RoboMaker::Robot":                                       Unmapped,
	"AWS::RoboMaker::RobotApplication":                            Unmapped,
	"AWS::RoboMaker::RobotApplicationVersion":                     Unmapped,
	"AWS::RoboMaker::SimulationApplication":                       Unmapped,
	"AWS::RoboMaker::SimulationApplicationVersion":                Unmapped,
	"AWS::Route53::DNSSEC":                                        Unmapped,
	"AWS::Route53::HealthCheck":                                   Route53HealthCheck,
	"AWS::Route53::HostedZone":                                    Route53HostedZone,
	"AWS::Route53::KeySigningKey":                                 Unmapped,
	"AWS::Route53::RecordSet":                                     Route53RecordSet,
	"AWS::Route53::RecordSetGroup":                                Unmapped,
	"AWS::Route53RecoveryControl::Cluster":                        Unmapped,
	"AWS::Route53RecoveryControl::ControlPanel":                   Unmapped,
	"AWS::Route53RecoveryControl::RoutingControl":                 Unmapped,
	"AWS::Route53RecoveryControl::SafetyRule":                     Unmapped,
	"AWS::Route53RecoveryReadiness::Cell":                         Unmapped,
	"AWS::Route53RecoveryReadiness::ReadinessCheck":               Unmapped,
	"AWS::Route53RecoveryReadiness::RecoveryGroup":                Unmapped,
	"AWS::Route53RecoveryReadiness::ResourceSet":                  Unmapped,
	"AWS::Route53Resolver::FirewallDomainList":                    Unmapped,
	"AWS::Route53Resolver::FirewallRuleGroup":                     Unmapped,
	"AWS::Route53Resolver::FirewallRuleGroupAssociation":          Unmapped,
	"AWS::Route53Resolver::ResolverConfig":                        Unmapped,
	"AWS::Route53Resolver::ResolverDNSSECConfig":                  Unmapped,
	"AWS::Route53Resolver::ResolverEndpoint":                      Unmapped,
	"AWS::Route53Resolver::ResolverQueryLoggingConfig":            Unmapped,
	"AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation": Unmapped,
	"AWS::Route53Resolver::ResolverRule":                          Unmapped,
	"AWS::Route53Resolver::ResolverRuleAssociation":               Unmapped,
	"AWS::S3::AccessPoint":                                        Unmapped,
	"AWS::S3::Bucket":                                             S3Bucket,
	"AWS::S3::BucketPolicy":                                       S3Bucket,
	"AWS::S3::MultiRegionAccessPoint":                             Unmapped,
	"AWS::S3::MultiRegionAccessPointPolicy":                       Unmapped,
	"AWS::S3::StorageLens":                                        Unmapped,
	"AWS::S3ObjectLambda::AccessPoint":                            Unmapped,
	"AWS::S3ObjectLambda::AccessPointPolicy":                      Unmapped,
	"AWS::S3Outposts::AccessPoint":                                Unmapped,
	"AWS::S3Outposts::Bucket":                                     Unmapped,
	"AWS::S3Outposts::BucketPolicy":                               Unmapped,
	"AWS::S3Outposts::Endpoint":                                   Unmapped,
	"AWS::SDB::Domain":                                            Unmapped,
	"AWS::SES::ConfigurationSet":                                  SesConfigurationSet,
	"AWS::SES::ConfigurationSetEventDestination":                  SesConfigurationSetEventDestination,
	"AWS::SES::ContactList":                                       Unmapped,
	"AWS::SES::ReceiptFilter":                                     SesReceiptFilter,
	"AWS::SES::ReceiptRule":                                       SesReceiptRule,
	"AWS::SES::ReceiptRuleSet":                                    SesReceiptRuleSet,
	"AWS::SES::Template":                                          SesTemplate,
	"AWS::SNS::Subscription":                                      SnsSubscription,
	"AWS::SNS::Topic":                                             SnsTopic,
	"AWS::SNS::TopicPolicy":                                       SnsTopic,
	"AWS::SQS::Queue":                                             SqsQueue,
	"AWS::SQS::QueuePolicy":                                       SqsQueue,
	"AWS::SSM::Association":                                       SsmAssociation,
	"AWS::SSM::Document":                                          SsmDocument,
	"AWS::SSM::MaintenanceWindow":                                 SsmMaintenanceWindow,
	"AWS::SSM::MaintenanceWindowTarget":                           SsmMaintenanceWindowTask,
	"AWS::SSM::MaintenanceWindowTask":                             SsmMaintenanceWindowTask,
	"AWS::SSM::Parameter":                                         SsmParameter,
	"AWS::SSM::PatchBaseline":                                     SsmPatchBaseline,
	"AWS::SSM::ResourceDataSync":                                  Unmapped,
	"AWS::SSMContacts::Contact":                                   Unmapped,
	"AWS::SSMContacts::ContactChannel":                            Unmapped,
	"AWS::SSMIncidents::ReplicationSet":                           Unmapped,
	"AWS::SSMIncidents::ResponsePlan":                             Unmapped,
	"AWS::SSO::Assignment":                                        Unmapped,
	"AWS::SSO::InstanceAccessControlAttributeConfiguration":       Unmapped,
	"AWS::SSO::PermissionSet":                                     Unmapped,
	"AWS::SageMaker::App":                                         Unmapped,
	"AWS::SageMaker::AppImageConfig":                              Unmapped,
	"AWS::SageMaker::CodeRepository":                              Unmapped,
	"AWS::SageMaker::DataQualityJobDefinition":                    Unmapped,
	"AWS::SageMaker::Device":                                      Unmapped,
	"AWS::SageMaker::DeviceFleet":                                 Unmapped,
	"AWS::SageMaker::Domain":                                      Unmapped,
	"AWS::SageMaker::Endpoint":                                    SagemakerEndpoint,
	"AWS::SageMaker::EndpointConfig":                              SagemakerEndpointConfig,
	"AWS::SageMaker::FeatureGroup":                                Unmapped,
	"AWS::SageMaker::Image":                                       Unmapped,
	"AWS::SageMaker::ImageVersion":                                Unmapped,
	"AWS::SageMaker::Model":                                       SagemakerModel,
	"AWS::SageMaker::ModelBiasJobDefinition":                      Unmapped,
	"AWS::SageMaker::ModelExplainabilityJobDefinition":            Unmapped,
	"AWS::SageMaker::ModelPackageGroup":                           Unmapped,
	"AWS::SageMaker::ModelQualityJobDefinition":                   Unmapped,
	"AWS::SageMaker::MonitoringSchedule":                          Unmapped,
	"AWS::SageMaker::NotebookInstance":                            SagemakerNotebookInstance,
	"AWS::SageMaker::NotebookInstanceLifecycleConfig":             SagemakerNotebookInstanceLifecycleConfig,
	"AWS::SageMaker::Pipeline":                                    Unmapped,
	"AWS::SageMaker::Project":                                     Unmapped,
	"AWS::SageMaker::UserProfile":                                 Unmapped,
	"AWS::SageMaker::Workteam":                                    Unmapped,
	"AWS::SecretsManager::ResourcePolicy":                         SecretManagerSecret,
	"AWS::SecretsManager::RotationSchedule":                       SecretManagerSecret,
	"AWS::SecretsManager::Secret":                                 SecretManagerSecret,
	"AWS::SecretsManager::SecretTargetAttachment":                 Unmapped,
	"AWS::SecurityHub::Hub":                                       Unmapped,
	"AWS::ServiceCatalog::AcceptedPortfolioShare":                 ServiceCatalogAcceptedPortfolioShare,
	"AWS::ServiceCatalog::CloudFormationProduct":                  Unmapped,
	"AWS::ServiceCatalog::CloudFormationProvisionedProduct":       Unmapped,
	"AWS::ServiceCatalog::LaunchNotificationConstraint":           Unmapped,
	"AWS::ServiceCatalog::LaunchRoleConstraint":                   Unmapped,
	"AWS::ServiceCatalog::LaunchTemplateConstraint":               Unmapped,
	"AWS::ServiceCatalog::Portfolio":                              ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::PortfolioPrincipalAssociation":          ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::PortfolioProductAssociation":            Unmapped,
	"AWS::ServiceCatalog::PortfolioShare":                         Unmapped,
	"AWS::ServiceCatalog::ResourceUpdateConstraint":               Unmapped,
	"AWS::ServiceCatalog::ServiceAction":                          Unmapped,
	"AWS::ServiceCatalog::ServiceActionAssociation":               Unmapped,
	"AWS::ServiceCatalog::StackSetConstraint":                     Unmapped,
	"AWS::ServiceCatalog::TagOption":                              ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::TagOptionAssociation":                   ServiceCatalogPortfolio,
	"AWS::ServiceCatalogAppRegistry::Application":                 Unmapped,
	"AWS::ServiceCatalogAppRegistry::AttributeGroup":              Unmapped,
	"AWS::ServiceCatalogAppRegistry::AttributeGroupAssociation":   Unmapped,
	"AWS::ServiceCatalogAppRegistry::ResourceAssociation":         Unmapped,
	"AWS::ServiceDiscovery::HttpNamespace":                        ServiceDiscoveryNamespace,
	"AWS::ServiceDiscovery::Instance":                             ServiceDiscoveryInstance,
	"AWS::ServiceDiscovery::PrivateDnsNamespace":                  ServiceDiscoveryNamespace,
	"AWS::ServiceDiscovery::PublicDnsNamespace":                   ServiceDiscoveryNamespace,
	"AWS::ServiceDiscovery::Service":                              ServiceDiscoveryService,
	"AWS::Signer::ProfilePermission":                              Unmapped,
	"AWS::Signer::SigningProfile":                                 SignerSigningProfile,
	"AWS::StepFunctions::Activity":                                Unmapped,
	"AWS::StepFunctions::StateMachine":                            StepFunctionStateMachine,
	"AWS::Synthetics::Canary":                                     Unmapped,
	"AWS::Timestream::Database":                                   Unmapped,
	"AWS::Timestream::ScheduledQuery":                             Unmapped,
	"AWS::Timestream::Table":                                      Unmapped,
	"AWS::Transfer::Server":                                       TransferServer,
	"AWS::Transfer::User":                                         TransferUser,
	"AWS::Transfer::Workflow":                                     Unmapped,
	"AWS::WAF::ByteMatchSet":                                      WafByteMatchSet,
	"AWS::WAF::IPSet":                                             WafIpSet,
	"AWS::WAF::Rule":                                              WafRule,
	"AWS::WAF::SizeConstraintSet":                                 WafSizeConstraintSet,
	"AWS::WAF::SqlInjectionMatchSet":                              WafSqlInjectionMatchSet,
	"AWS::WAF::WebACL":                                            WafWebACL,
	"AWS::WAF::XssMatchSet":                                       WafXssMatchSet,
	"AWS::WAFv2::IPSet":                                           Wafv2IpSet,
	"AWS::WAFv2::LoggingConfiguration":                            Unmapped,
	"AWS::WAFv2::RegexPatternSet":                                 Wafv2RegexPatternSet,
	"AWS::WAFv2::RuleGroup":                                       Wafv2RuleGroup,
	"AWS::WAFv2::WebACL":                                          Wafv2WebACL,
	"AWS::WAFv2::WebACLAssociation":                               Wafv2WebACL,
	"AWS::WAFRegional::ByteMatchSet":                              WafRegionalByteMatchSet,
	"AWS::WAFRegional::GeoMatchSet":                               WafRegionalGeoMatchSet,
	"AWS::WAFRegional::IPSet":                                     WafRegionalIpSet,
	"AWS::WAFRegional::RateBasedRule":                             WafRegionalRateBasedRule,
	"AWS::WAFRegional::RegexPatternSet":                           WafRegionalRegexPatternSet,
	"AWS::WAFRegional::Rule":                                      WafRegionalRule,
	"AWS::WAFRegional::SizeConstraintSet":                         WafRegionalSizeConstraint,
	"AWS::WAFRegional::SqlInjectionMatchSet":                      WafRegionalSqlInjectionMatchSet,
	"AWS::WAFRegional::WebACL":                                    WafRegionalWebACL,
	"AWS::WAFRegional::WebACLAssociation":                         WafRegionalWebACL,
	"AWS::WAFRegional::XssMatchSet":                               WafRegionalXssMatchSet,
	"AWS::Wisdom::Assistant":                                      Unmapped,
	"AWS::Wisdom::AssistantAssociation":                           Unmapped,
	"AWS::Wisdom::KnowledgeBase":                                  Unmapped,
	"AWS::WorkSpaces::ConnectionAlias":                            Unmapped,
	"AWS::WorkSpaces::Workspace":                                  WorkspacesWorkspace,
	"AWS::XRay::Group":                                            Unmapped,
	"AWS::XRay::SamplingRule":                                     Unmapped,
}

func FromCfn(input string) (ResourceType, error) {
	val, ok := mapping[input]
	if !ok || val == Unmapped {
		return ResourceType(strings.ReplaceAll(input, "::", "/")), fmt.Errorf("no type defined for %s", input)
	}
	return val, nil
}
