// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of vocabularies that match the specified criteria. If no criteria
// are specified, returns the entire list of vocabularies.
func (c *Client) ListVocabularies(ctx context.Context, params *ListVocabulariesInput, optFns ...func(*Options)) (*ListVocabulariesOutput, error) {
	if params == nil {
		params = &ListVocabulariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVocabularies", params, optFns, c.addOperationListVocabulariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVocabulariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVocabulariesInput struct {

	// The maximum number of vocabularies to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int32

	// When specified, the vocabularies returned in the list are limited to
	// vocabularies whose name contains the specified string. The search is not case
	// sensitive, ListVocabularies returns both "vocabularyname" and "VocabularyName"
	// in the response list.
	NameContains *string

	// If the result of the previous request to ListVocabularies was truncated, include
	// the NextToken to fetch the next set of jobs.
	NextToken *string

	// When specified, only returns vocabularies with the VocabularyState field equal
	// to the specified state.
	StateEquals types.VocabularyState

	noSmithyDocumentSerde
}

type ListVocabulariesOutput struct {

	// The ListVocabularies operation returns a page of vocabularies at a time. The
	// maximum size of the page is set in the MaxResults parameter. If there are more
	// jobs in the list than will fit on the page, Amazon Transcribe returns the
	// NextPage token. To return in the next page of jobs, include the token in the
	// next request to the ListVocabularies operation.
	NextToken *string

	// The requested vocabulary state.
	Status types.VocabularyState

	// A list of objects that describe the vocabularies that match the search criteria
	// in the request.
	Vocabularies []types.VocabularyInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVocabulariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListVocabularies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListVocabularies{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVocabularies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVocabulariesAPIClient is a client that implements the ListVocabularies
// operation.
type ListVocabulariesAPIClient interface {
	ListVocabularies(context.Context, *ListVocabulariesInput, ...func(*Options)) (*ListVocabulariesOutput, error)
}

var _ ListVocabulariesAPIClient = (*Client)(nil)

// ListVocabulariesPaginatorOptions is the paginator options for ListVocabularies
type ListVocabulariesPaginatorOptions struct {
	// The maximum number of vocabularies to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVocabulariesPaginator is a paginator for ListVocabularies
type ListVocabulariesPaginator struct {
	options   ListVocabulariesPaginatorOptions
	client    ListVocabulariesAPIClient
	params    *ListVocabulariesInput
	nextToken *string
	firstPage bool
}

// NewListVocabulariesPaginator returns a new ListVocabulariesPaginator
func NewListVocabulariesPaginator(client ListVocabulariesAPIClient, params *ListVocabulariesInput, optFns ...func(*ListVocabulariesPaginatorOptions)) *ListVocabulariesPaginator {
	if params == nil {
		params = &ListVocabulariesInput{}
	}

	options := ListVocabulariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVocabulariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVocabulariesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListVocabularies page.
func (p *ListVocabulariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVocabulariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListVocabularies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVocabularies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "ListVocabularies",
	}
}
