// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides more information about the call analytics categories that you've
// created. You can use the information in this list to find a specific category.
// You can then use the operation to get more information about it.
func (c *Client) ListCallAnalyticsCategories(ctx context.Context, params *ListCallAnalyticsCategoriesInput, optFns ...func(*Options)) (*ListCallAnalyticsCategoriesOutput, error) {
	if params == nil {
		params = &ListCallAnalyticsCategoriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCallAnalyticsCategories", params, optFns, c.addOperationListCallAnalyticsCategoriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCallAnalyticsCategoriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCallAnalyticsCategoriesInput struct {

	// The maximum number of categories to return in each page of results. If there are
	// fewer results than the value you specify, only the actual results are returned.
	// If you do not specify a value, the default of 5 is used.
	MaxResults *int32

	// When included, NextTokenfetches the next set of categories if the result of the
	// previous request was truncated.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCallAnalyticsCategoriesOutput struct {

	// A list of objects containing information about analytics categories.
	Categories []types.CategoryProperties

	// The operation returns a page of jobs at a time. The maximum size of the list is
	// set by the MaxResults parameter. If there are more categories in the list than
	// the page size, Amazon Transcribe returns the NextPage token. Include the token
	// in the next request to the operation to return the next page of analytics
	// categories.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCallAnalyticsCategoriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCallAnalyticsCategories{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCallAnalyticsCategories{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCallAnalyticsCategories(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCallAnalyticsCategoriesAPIClient is a client that implements the
// ListCallAnalyticsCategories operation.
type ListCallAnalyticsCategoriesAPIClient interface {
	ListCallAnalyticsCategories(context.Context, *ListCallAnalyticsCategoriesInput, ...func(*Options)) (*ListCallAnalyticsCategoriesOutput, error)
}

var _ ListCallAnalyticsCategoriesAPIClient = (*Client)(nil)

// ListCallAnalyticsCategoriesPaginatorOptions is the paginator options for
// ListCallAnalyticsCategories
type ListCallAnalyticsCategoriesPaginatorOptions struct {
	// The maximum number of categories to return in each page of results. If there are
	// fewer results than the value you specify, only the actual results are returned.
	// If you do not specify a value, the default of 5 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCallAnalyticsCategoriesPaginator is a paginator for
// ListCallAnalyticsCategories
type ListCallAnalyticsCategoriesPaginator struct {
	options   ListCallAnalyticsCategoriesPaginatorOptions
	client    ListCallAnalyticsCategoriesAPIClient
	params    *ListCallAnalyticsCategoriesInput
	nextToken *string
	firstPage bool
}

// NewListCallAnalyticsCategoriesPaginator returns a new
// ListCallAnalyticsCategoriesPaginator
func NewListCallAnalyticsCategoriesPaginator(client ListCallAnalyticsCategoriesAPIClient, params *ListCallAnalyticsCategoriesInput, optFns ...func(*ListCallAnalyticsCategoriesPaginatorOptions)) *ListCallAnalyticsCategoriesPaginator {
	if params == nil {
		params = &ListCallAnalyticsCategoriesInput{}
	}

	options := ListCallAnalyticsCategoriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCallAnalyticsCategoriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCallAnalyticsCategoriesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListCallAnalyticsCategories page.
func (p *ListCallAnalyticsCategoriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCallAnalyticsCategoriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListCallAnalyticsCategories(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListCallAnalyticsCategories(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "ListCallAnalyticsCategories",
	}
}
