// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Use this operation to describe a FeatureGroup. The response includes information
// on the creation time, FeatureGroup name, the unique identifier for each
// FeatureGroup, and more.
func (c *Client) DescribeFeatureGroup(ctx context.Context, params *DescribeFeatureGroupInput, optFns ...func(*Options)) (*DescribeFeatureGroupOutput, error) {
	if params == nil {
		params = &DescribeFeatureGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFeatureGroup", params, optFns, c.addOperationDescribeFeatureGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFeatureGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFeatureGroupInput struct {

	// The name of the FeatureGroup you want described.
	//
	// This member is required.
	FeatureGroupName *string

	// A token to resume pagination of the list of Features (FeatureDefinitions). 2,500
	// Features are returned by default.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFeatureGroupOutput struct {

	// A timestamp indicating when SageMaker created the FeatureGroup.
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the feature that stores the EventTime of a Record in a FeatureGroup.
	// An EventTime is a point in time when a new event occurs that corresponds to the
	// creation or update of a Record in a FeatureGroup. All Records in the
	// FeatureGroup have a corresponding EventTime.
	//
	// This member is required.
	EventTimeFeatureName *string

	// A list of the Features in the FeatureGroup. Each feature is defined by a
	// FeatureName and FeatureType.
	//
	// This member is required.
	FeatureDefinitions []types.FeatureDefinition

	// The Amazon Resource Name (ARN) of the FeatureGroup.
	//
	// This member is required.
	FeatureGroupArn *string

	// he name of the FeatureGroup.
	//
	// This member is required.
	FeatureGroupName *string

	// A token to resume pagination of the list of Features (FeatureDefinitions).
	//
	// This member is required.
	NextToken *string

	// The name of the Feature used for RecordIdentifier, whose value uniquely
	// identifies a record stored in the feature store.
	//
	// This member is required.
	RecordIdentifierFeatureName *string

	// A free form description of the feature group.
	Description *string

	// The reason that the FeatureGroup failed to be replicated in the OfflineStore.
	// This is failure can occur because:
	//
	// * The FeatureGroup could not be created in
	// the OfflineStore.
	//
	// * The FeatureGroup could not be deleted from the
	// OfflineStore.
	FailureReason *string

	// The status of the feature group.
	FeatureGroupStatus types.FeatureGroupStatus

	// The configuration of the OfflineStore, inducing the S3 location of the
	// OfflineStore, Amazon Web Services Glue or Amazon Web Services Hive data
	// catalogue configurations, and the security configuration.
	OfflineStoreConfig *types.OfflineStoreConfig

	// The status of the OfflineStore. Notifies you if replicating data into the
	// OfflineStore has failed. Returns either: Active or Blocked
	OfflineStoreStatus *types.OfflineStoreStatus

	// The configuration for the OnlineStore.
	OnlineStoreConfig *types.OnlineStoreConfig

	// The Amazon Resource Name (ARN) of the IAM execution role used to persist data
	// into the OfflineStore if an OfflineStoreConfig is provided.
	RoleArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFeatureGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFeatureGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFeatureGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeFeatureGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFeatureGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFeatureGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "DescribeFeatureGroup",
	}
}
