// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new DB cluster from a DB snapshot or DB cluster snapshot. This action
// only applies to Aurora DB clusters. The target DB cluster is created from the
// source snapshot with a default configuration. If you don't specify a security
// group, the new DB cluster is associated with the default security group. This
// action only restores the DB cluster, not the DB instances for that DB cluster.
// You must invoke the CreateDBInstance action to create DB instances for the
// restored DB cluster, specifying the identifier of the restored DB cluster in
// DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterFromSnapshot action has completed and the DB cluster is
// available. For more information on Amazon Aurora, see  What Is Amazon Aurora?
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide. This action only applies to Aurora DB clusters.
func (c *Client) RestoreDBClusterFromSnapshot(ctx context.Context, params *RestoreDBClusterFromSnapshotInput, optFns ...func(*Options)) (*RestoreDBClusterFromSnapshotOutput, error) {
	if params == nil {
		params = &RestoreDBClusterFromSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RestoreDBClusterFromSnapshot", params, optFns, c.addOperationRestoreDBClusterFromSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RestoreDBClusterFromSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

//
type RestoreDBClusterFromSnapshotInput struct {

	// The name of the DB cluster to create from the DB snapshot or DB cluster
	// snapshot. This parameter isn't case-sensitive. Constraints:
	//
	// * Must contain from
	// 1 to 63 letters, numbers, or hyphens
	//
	// * First character must be a letter
	//
	// *
	// Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example:
	// my-snapshot-id
	//
	// This member is required.
	DBClusterIdentifier *string

	// The database engine to use for the new DB cluster. Default: The same as source
	// Constraint: Must be compatible with the engine of the source
	//
	// This member is required.
	Engine *string

	// The identifier for the DB snapshot or DB cluster snapshot to restore from. You
	// can use either the name or the Amazon Resource Name (ARN) to specify a DB
	// cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
	// Constraints:
	//
	// * Must match the identifier of an existing Snapshot.
	//
	// This member is required.
	SnapshotIdentifier *string

	// Provides the list of Availability Zones (AZs) where instances in the restored DB
	// cluster can be created.
	AvailabilityZones []string

	// The target backtrack window, in seconds. To disable backtracking, set this value
	// to 0. Currently, Backtrack is only supported for Aurora MySQL DB clusters.
	// Default: 0 Constraints:
	//
	// * If specified, this value must be set to a number from
	// 0 to 259,200 (72 hours).
	BacktrackWindow *int64

	// A value that indicates whether to copy all tags from the restored DB cluster to
	// snapshots of the restored DB cluster. The default is not to copy them.
	CopyTagsToSnapshot *bool

	// The name of the DB cluster parameter group to associate with this DB cluster. If
	// this argument is omitted, the default DB cluster parameter group for the
	// specified engine is used. Constraints:
	//
	// * If supplied, must match the name of an
	// existing default DB cluster parameter group.
	//
	// * Must be 1 to 255 letters,
	// numbers, or hyphens.
	//
	// * First character must be a letter.
	//
	// * Can't end with a
	// hyphen or contain two consecutive hyphens.
	DBClusterParameterGroupName *string

	// The name of the DB subnet group to use for the new DB cluster. Constraints: If
	// supplied, must match the name of an existing DB subnet group. Example:
	// mySubnetgroup
	DBSubnetGroupName *string

	// The database name for the restored DB cluster.
	DatabaseName *string

	// A value that indicates whether the DB cluster has deletion protection enabled.
	// The database can't be deleted when deletion protection is enabled. By default,
	// deletion protection is disabled.
	DeletionProtection *bool

	// Specify the Active Directory directory ID to restore the DB cluster in. The
	// domain must be created prior to this operation. Currently, only MySQL, Microsoft
	// SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active
	// Directory Domain. For more information, see  Kerberos Authentication
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html)
	// in the Amazon RDS User Guide.
	Domain *string

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string

	// The list of logs that the restored DB cluster is to export to Amazon CloudWatch
	// Logs. The values in the list depend on the DB engine being used. For more
	// information, see Publishing Database Logs to Amazon CloudWatch Logs
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
	// in the Amazon Aurora User Guide.
	EnableCloudwatchLogsExports []string

	// A value that indicates whether to enable mapping of Amazon Web Services Identity
	// and Access Management (IAM) accounts to database accounts. By default, mapping
	// is disabled. For more information, see  IAM Database Authentication
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
	// in the Amazon Aurora User Guide.
	EnableIAMDatabaseAuthentication *bool

	// The DB engine mode of the DB cluster, either provisioned, serverless,
	// parallelquery, global, or multimaster. For more information, see
	// CreateDBCluster
	// (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
	EngineMode *string

	// The version of the database engine to use for the new DB cluster. To list all of
	// the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use
	// the following command: aws rds describe-db-engine-versions --engine aurora
	// --query "DBEngineVersions[].EngineVersion" To list all of the available engine
	// versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following
	// command: aws rds describe-db-engine-versions --engine aurora-mysql --query
	// "DBEngineVersions[].EngineVersion" To list all of the available engine versions
	// for aurora-postgresql, use the following command: aws rds
	// describe-db-engine-versions --engine aurora-postgresql --query
	// "DBEngineVersions[].EngineVersion" If you aren't using the default engine
	// version, then you must specify the engine version. Aurora MySQL Example:
	// 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5 Aurora
	// PostgreSQL Example: 9.6.3, 10.7
	EngineVersion *string

	// The Amazon Web Services KMS key identifier to use when restoring an encrypted DB
	// cluster from a DB snapshot or DB cluster snapshot. The Amazon Web Services KMS
	// key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon
	// Web Services KMS customer master key (CMK). To use a CMK in a different Amazon
	// Web Services account, specify the key ARN or alias ARN. When you don't specify a
	// value for the KmsKeyId parameter, then the following occurs:
	//
	// * If the DB
	// snapshot or DB cluster snapshot in SnapshotIdentifier is encrypted, then the
	// restored DB cluster is encrypted using the Amazon Web Services KMS CMK that was
	// used to encrypt the DB snapshot or DB cluster snapshot.
	//
	// * If the DB snapshot or
	// DB cluster snapshot in SnapshotIdentifier isn't encrypted, then the restored DB
	// cluster isn't encrypted.
	KmsKeyId *string

	// The name of the option group to use for the restored DB cluster.
	OptionGroupName *string

	// The port number on which the new DB cluster accepts connections. Constraints:
	// This value must be 1150-65535 Default: The same port as the original DB cluster.
	Port *int32

	// For DB clusters in serverless DB engine mode, the scaling properties of the DB
	// cluster.
	ScalingConfiguration *types.ScalingConfiguration

	// The tags to be assigned to the restored DB cluster.
	Tags []types.Tag

	// A list of VPC security groups that the new DB cluster will belong to.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

type RestoreDBClusterFromSnapshotOutput struct {

	// Contains the details of an Amazon Aurora DB cluster. This data type is used as a
	// response element in the DescribeDBClusters, StopDBCluster, and StartDBCluster
	// actions.
	DBCluster *types.DBCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRestoreDBClusterFromSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpRestoreDBClusterFromSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpRestoreDBClusterFromSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRestoreDBClusterFromSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRestoreDBClusterFromSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRestoreDBClusterFromSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rds",
		OperationName: "RestoreDBClusterFromSnapshot",
	}
}
