// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the folder resolved permissions. Permissions consists of both folder
// direct permissions and the inherited permissions from the ancestor folders.
func (c *Client) DescribeFolderResolvedPermissions(ctx context.Context, params *DescribeFolderResolvedPermissionsInput, optFns ...func(*Options)) (*DescribeFolderResolvedPermissionsOutput, error) {
	if params == nil {
		params = &DescribeFolderResolvedPermissionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFolderResolvedPermissions", params, optFns, c.addOperationDescribeFolderResolvedPermissionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFolderResolvedPermissionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFolderResolvedPermissionsInput struct {

	// The AWS account ID.
	//
	// This member is required.
	AwsAccountId *string

	// The folder ID.
	//
	// This member is required.
	FolderId *string

	noSmithyDocumentSerde
}

type DescribeFolderResolvedPermissionsOutput struct {

	// The Amazon Resource Name (ARN).
	Arn *string

	// The folder ID.
	FolderId *string

	// Information about the permissions on the dashboard.
	Permissions []types.ResourcePermission

	// The request ID.
	RequestId *string

	// The status. If succeeded, the status is SC_OK
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFolderResolvedPermissionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeFolderResolvedPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeFolderResolvedPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeFolderResolvedPermissionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFolderResolvedPermissions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFolderResolvedPermissions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "quicksight",
		OperationName: "DescribeFolderResolvedPermissions",
	}
}
