// Code generated by smithy-go-codegen DO NOT EDIT.

package iotdeviceadvisor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the runs of the specified Device Advisor test suite. You can list all runs
// of the test suite, or the runs of a specific version of the test suite.
func (c *Client) ListSuiteRuns(ctx context.Context, params *ListSuiteRunsInput, optFns ...func(*Options)) (*ListSuiteRunsOutput, error) {
	if params == nil {
		params = &ListSuiteRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSuiteRuns", params, optFns, c.addOperationListSuiteRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSuiteRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSuiteRunsInput struct {

	// The maximum number of results to return at once.
	MaxResults int32

	// A token to retrieve the next set of results.
	NextToken *string

	// Lists the test suite runs of the specified test suite based on suite definition
	// Id.
	SuiteDefinitionId *string

	// Must be passed along with suiteDefinitionId. Lists the test suite runs of the
	// specified test suite based on suite definition version.
	SuiteDefinitionVersion *string

	noSmithyDocumentSerde
}

type ListSuiteRunsOutput struct {

	// A token to retrieve the next set of results.
	NextToken *string

	// An array of objects that provide summaries of information about the suite runs
	// in the list.
	SuiteRunsList []types.SuiteRunInformation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSuiteRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSuiteRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSuiteRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSuiteRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSuiteRunsAPIClient is a client that implements the ListSuiteRuns operation.
type ListSuiteRunsAPIClient interface {
	ListSuiteRuns(context.Context, *ListSuiteRunsInput, ...func(*Options)) (*ListSuiteRunsOutput, error)
}

var _ ListSuiteRunsAPIClient = (*Client)(nil)

// ListSuiteRunsPaginatorOptions is the paginator options for ListSuiteRuns
type ListSuiteRunsPaginatorOptions struct {
	// The maximum number of results to return at once.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSuiteRunsPaginator is a paginator for ListSuiteRuns
type ListSuiteRunsPaginator struct {
	options   ListSuiteRunsPaginatorOptions
	client    ListSuiteRunsAPIClient
	params    *ListSuiteRunsInput
	nextToken *string
	firstPage bool
}

// NewListSuiteRunsPaginator returns a new ListSuiteRunsPaginator
func NewListSuiteRunsPaginator(client ListSuiteRunsAPIClient, params *ListSuiteRunsInput, optFns ...func(*ListSuiteRunsPaginatorOptions)) *ListSuiteRunsPaginator {
	if params == nil {
		params = &ListSuiteRunsInput{}
	}

	options := ListSuiteRunsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSuiteRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSuiteRunsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListSuiteRuns page.
func (p *ListSuiteRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSuiteRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListSuiteRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSuiteRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "iotdeviceadvisor",
		OperationName: "ListSuiteRuns",
	}
}
