// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more Traffic Mirror filters.
func (c *Client) DescribeTrafficMirrorFilters(ctx context.Context, params *DescribeTrafficMirrorFiltersInput, optFns ...func(*Options)) (*DescribeTrafficMirrorFiltersOutput, error) {
	if params == nil {
		params = &DescribeTrafficMirrorFiltersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrafficMirrorFilters", params, optFns, c.addOperationDescribeTrafficMirrorFiltersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrafficMirrorFiltersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrafficMirrorFiltersInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// One or more filters. The possible values are:
	//
	// * description: The Traffic Mirror
	// filter description.
	//
	// * traffic-mirror-filter-id: The ID of the Traffic Mirror
	// filter.
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The ID of the Traffic Mirror filter.
	TrafficMirrorFilterIds []string

	noSmithyDocumentSerde
}

type DescribeTrafficMirrorFiltersOutput struct {

	// The token to use to retrieve the next page of results. The value is null when
	// there are no more results to return.
	NextToken *string

	// Information about one or more Traffic Mirror filters.
	TrafficMirrorFilters []types.TrafficMirrorFilter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrafficMirrorFiltersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeTrafficMirrorFilters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeTrafficMirrorFilters{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrafficMirrorFilters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeTrafficMirrorFiltersAPIClient is a client that implements the
// DescribeTrafficMirrorFilters operation.
type DescribeTrafficMirrorFiltersAPIClient interface {
	DescribeTrafficMirrorFilters(context.Context, *DescribeTrafficMirrorFiltersInput, ...func(*Options)) (*DescribeTrafficMirrorFiltersOutput, error)
}

var _ DescribeTrafficMirrorFiltersAPIClient = (*Client)(nil)

// DescribeTrafficMirrorFiltersPaginatorOptions is the paginator options for
// DescribeTrafficMirrorFilters
type DescribeTrafficMirrorFiltersPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeTrafficMirrorFiltersPaginator is a paginator for
// DescribeTrafficMirrorFilters
type DescribeTrafficMirrorFiltersPaginator struct {
	options   DescribeTrafficMirrorFiltersPaginatorOptions
	client    DescribeTrafficMirrorFiltersAPIClient
	params    *DescribeTrafficMirrorFiltersInput
	nextToken *string
	firstPage bool
}

// NewDescribeTrafficMirrorFiltersPaginator returns a new
// DescribeTrafficMirrorFiltersPaginator
func NewDescribeTrafficMirrorFiltersPaginator(client DescribeTrafficMirrorFiltersAPIClient, params *DescribeTrafficMirrorFiltersInput, optFns ...func(*DescribeTrafficMirrorFiltersPaginatorOptions)) *DescribeTrafficMirrorFiltersPaginator {
	if params == nil {
		params = &DescribeTrafficMirrorFiltersInput{}
	}

	options := DescribeTrafficMirrorFiltersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeTrafficMirrorFiltersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeTrafficMirrorFiltersPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeTrafficMirrorFilters page.
func (p *DescribeTrafficMirrorFiltersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeTrafficMirrorFiltersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeTrafficMirrorFilters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeTrafficMirrorFilters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "DescribeTrafficMirrorFilters",
	}
}
