// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A time range that specifies when DevOps Guru opens and then closes an anomaly.
// This is different from AnomalyTimeRange, which specifies the time range when
// DevOps Guru actually observes the anomalous behavior.
type AnomalyReportedTimeRange struct {

	// The time when an anomaly is opened.
	//
	// This member is required.
	OpenTime *time.Time

	// The time when an anomaly is closed.
	CloseTime *time.Time

	noSmithyDocumentSerde
}

// Details about the source of the anomalous operational data that triggered the
// anomaly. The one supported source is Amazon CloudWatch metrics.
type AnomalySourceDetails struct {

	// An array of CloudWatchMetricsDetail object that contains information about the
	// analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []CloudWatchMetricsDetail

	noSmithyDocumentSerde
}

// A time range that specifies when the observed unusual behavior in an anomaly
// started and ended. This is different from AnomalyReportedTimeRange, which
// specifies the time range when DevOps Guru opens and then closes an anomaly.
type AnomalyTimeRange struct {

	// The time when the anomalous behavior started.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the anomalous behavior ended.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Information about AWS CloudFormation stacks. You can use up to 500 stacks to
// specify which AWS resources in your account to analyze. For more information,
// see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the AWS CloudFormation User Guide.
type CloudFormationCollection struct {

	// An array of CloudFormation stack names.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about AWS CloudFormation stacks. You can use up to 500 stacks to
// specify which AWS resources in your account to analyze. For more information,
// see Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the AWS CloudFormation User Guide.
type CloudFormationCollectionFilter struct {

	// An array of CloudFormation stack names.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about an AWS CloudFormation stack used to create a monthly cost
// estimate for DevOps Guru to analyze AWS resources. The maximum number of stacks
// you can specify for a cost estimate is one. The estimate created is for the cost
// to analyze the AWS resources defined by the stack. For more information, see
// Stacks
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
// the AWS CloudFormation User Guide.
type CloudFormationCostEstimationResourceCollectionFilter struct {

	// An array of CloudFormation stack names. Its size is fixed at 1 item.
	StackNames []string

	noSmithyDocumentSerde
}

// Information about the health of AWS resources in your account that are specified
// by an AWS CloudFormation stack.
type CloudFormationHealth struct {

	// Information about the health of the AWS resources in your account that are
	// specified by an AWS CloudFormation stack, including the number of open
	// proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed
	// insights.
	Insight *InsightHealth

	// The name of the CloudFormation stack.
	StackName *string

	noSmithyDocumentSerde
}

// Information about an Amazon CloudWatch metric.
type CloudWatchMetricsDetail struct {

	// An array of CloudWatch dimensions associated with
	Dimensions []CloudWatchMetricsDimension

	// The name of the CloudWatch metric.
	MetricName *string

	// The namespace of the CloudWatch metric. A namespace is a container for
	// CloudWatch metrics.
	Namespace *string

	// The length of time associated with the CloudWatch metric in number of seconds.
	Period int32

	// The type of statistic associated with the CloudWatch metric. For more
	// information, see Statistics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	Stat CloudWatchMetricsStat

	// The unit of measure used for the CloudWatch metric. For example, Bytes, Seconds,
	// Count, and Percent.
	Unit *string

	noSmithyDocumentSerde
}

// The dimension of a Amazon CloudWatch metric that is used when DevOps Guru
// analyzes the resources in your account for operational problems and anomalous
// behavior. A dimension is a name/value pair that is part of the identity of a
// metric. A metric can have up to 10 dimensions. For more information, see
// Dimensions
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension)
// in the Amazon CloudWatch User Guide.
type CloudWatchMetricsDimension struct {

	// The name of the CloudWatch dimension.
	Name *string

	// The value of the CloudWatch dimension.
	Value *string

	noSmithyDocumentSerde
}

// Information about a filter used to specify which AWS resources are analyzed to
// create a monthly DevOps Guru cost estimate. For more information, see Estimate
// your Amazon DevOps Guru costs
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type CostEstimationResourceCollectionFilter struct {

	// An object that specifies the CloudFormation stack that defines the AWS resources
	// used to create a monthly estimate for DevOps Guru.
	CloudFormation *CloudFormationCostEstimationResourceCollectionFilter

	noSmithyDocumentSerde
}

// The time range of a cost estimation.
type CostEstimationTimeRange struct {

	// The end time of the cost estimation.
	EndTime *time.Time

	// The start time of the cost estimation.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A range of time that specifies when anomalous behavior in an anomaly or insight
// ended.
type EndTimeRange struct {

	// The earliest end time in the time range.
	FromTime *time.Time

	// The latest end time in the time range.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// An AWS resource event. AWS resource events and metrics are analyzed by DevOps
// Guru to find anomalous behavior and provide recommendations to improve your
// operational solutions.
type Event struct {

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, where DevOps Guru analysis found
	// the event.
	DataSource EventDataSource

	// The class of the event. The class specifies what the event is related to, such
	// as an infrastructure change, a deployment, or a schema change.
	EventClass EventClass

	// The AWS source that emitted the event.
	EventSource *string

	// The ID of the event.
	Id *string

	// The name of the event.
	Name *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// An EventResource object that contains information about the resource that
	// emitted the event.
	Resources []EventResource

	// A Timestamp that specifies the time the event occurred.
	Time *time.Time

	noSmithyDocumentSerde
}

// The AWS resource that emitted an event. AWS resource events and metrics are
// analyzed by DevOps Guru to find anomalous behavior and provide recommendations
// to improve your operational solutions.
type EventResource struct {

	// The Amazon Resource Name (ARN) of the resource that emitted an event.
	Arn *string

	// The name of the resource that emitted an event.
	Name *string

	// The type of resource that emitted an event.
	Type *string

	noSmithyDocumentSerde
}

// The time range during which an AWS event occurred. AWS resource events and
// metrics are analyzed by DevOps Guru to find anomalous behavior and provide
// recommendations to improve your operational solutions.
type EventTimeRange struct {

	// The time when the event started.
	//
	// This member is required.
	FromTime *time.Time

	// The time when the event ended.
	//
	// This member is required.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// Information about insight feedback received from a customer.
type InsightFeedback struct {

	// The feedback provided by the customer.
	Feedback InsightFeedbackOption

	// The insight feedback ID.
	Id *string

	noSmithyDocumentSerde
}

// Information about the number of open reactive and proactive insights that can be
// used to gauge the health of your system.
type InsightHealth struct {

	// The Meant Time to Recover (MTTR) for the insight.
	MeanTimeToRecoverInMilliseconds *int64

	// The number of open proactive insights.
	OpenProactiveInsights int32

	// The number of open reactive insights.
	OpenReactiveInsights int32

	noSmithyDocumentSerde
}

// A time ranged that specifies when the observed behavior in an insight started
// and ended.
type InsightTimeRange struct {

	// The time when the behavior described in an insight started.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the behavior described in an insight ended.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Filters you can use to specify which events are returned when ListEvents is
// called.
type ListEventsFilters struct {

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, of the events you want returned.
	DataSource EventDataSource

	// The class of the events you want to filter for, such as an infrastructure
	// change, a deployment, or a schema change.
	EventClass EventClass

	// The AWS source that emitted the events you want to filter for.
	EventSource *string

	// A time range during which you want the filtered events to have occurred.
	EventTimeRange *EventTimeRange

	// An ID of an insight that is related to the events you want to filter for.
	InsightId *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	noSmithyDocumentSerde
}

// Used to filter for insights that have any status.
type ListInsightsAnyStatusFilter struct {

	// A time range used to specify when the behavior of the filtered insights started.
	//
	// This member is required.
	StartTimeRange *StartTimeRange

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// Used to filter for insights that have the status CLOSED.
type ListInsightsClosedStatusFilter struct {

	// A time range used to specify when the behavior of the filtered insights ended.
	//
	// This member is required.
	EndTimeRange *EndTimeRange

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// Used to filter for insights that have the status ONGOING.
type ListInsightsOngoingStatusFilter struct {

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// This member is required.
	Type InsightType

	noSmithyDocumentSerde
}

// A filter used by ListInsights to specify which insights to return.
type ListInsightsStatusFilter struct {

	// A ListInsightsAnyStatusFilter that specifies insights of any status that are
	// either REACTIVE or PROACTIVE.
	Any *ListInsightsAnyStatusFilter

	// A ListInsightsClosedStatusFilter that specifies closed insights that are either
	// REACTIVE or PROACTIVE.
	Closed *ListInsightsClosedStatusFilter

	// A ListInsightsAnyStatusFilter that specifies ongoing insights that are either
	// REACTIVE or PROACTIVE.
	Ongoing *ListInsightsOngoingStatusFilter

	noSmithyDocumentSerde
}

// Information about a notification channel. A notification channel is used to
// notify you when DevOps Guru creates an insight. The one supported notification
// channel is Amazon Simple Notification Service (Amazon SNS). If you use an Amazon
// SNS topic in another account, you must attach a policy to it that grants DevOps
// Guru permission to it notifications. DevOps Guru adds the required policy on
// your behalf to send notifications using Amazon SNS in your account. For more
// information, see Permissions for cross account Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
// Service customer-managed key (CMK), then you must add permissions to the CMK.
// For more information, see Permissions for AWS KMS–encrypted Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type NotificationChannel struct {

	// A NotificationChannelConfig object that contains information about configured
	// notification channels.
	Config *NotificationChannelConfig

	// The ID of a notification channel.
	Id *string

	noSmithyDocumentSerde
}

// Information about notification channels you have configured with DevOps Guru.
// The one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
type NotificationChannelConfig struct {

	// Information about a notification channel configured in DevOps Guru to send
	// notifications when insights are created. If you use an Amazon SNS topic in
	// another account, you must attach a policy to it that grants DevOps Guru
	// permission to it notifications. DevOps Guru adds the required policy on your
	// behalf to send notifications using Amazon SNS in your account. For more
	// information, see Permissions for cross account Amazon SNS topics
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
	// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
	// Service customer-managed key (CMK), then you must add permissions to the CMK.
	// For more information, see Permissions for AWS KMS–encrypted Amazon SNS topics
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
	//
	// This member is required.
	Sns *SnsChannelConfig

	noSmithyDocumentSerde
}

// Information about whether DevOps Guru is configured to create an OpsItem in AWS
// Systems Manager OpsCenter for each created insight.
type OpsCenterIntegration struct {

	// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for
	// each created insight.
	OptInStatus OptInStatus

	noSmithyDocumentSerde
}

// Information about whether DevOps Guru is configured to create an OpsItem in AWS
// Systems Manager OpsCenter for each created insight.
type OpsCenterIntegrationConfig struct {

	// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for
	// each created insight.
	OptInStatus OptInStatus

	noSmithyDocumentSerde
}

// The time range during which anomalous behavior in a proactive anomaly or an
// insight is expected to occur.
type PredictionTimeRange struct {

	// The time range during which a metric limit is expected to be exceeded. This
	// applies to proactive insights only.
	//
	// This member is required.
	StartTime *time.Time

	// The time when the behavior in a proactive insight is expected to end.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Information about an anomaly. This object is returned by ListAnomalies.
type ProactiveAnomaly struct {

	// A AnomalyReportedTimeRange object that specifies the time range between when the
	// anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of a proactive anomaly.
	Id *string

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
	// threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of a proactive anomaly.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of a proactive anomaly.
	Status AnomalyStatus

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Details about a proactive anomaly. This object is returned by DescribeAnomaly.
type ProactiveAnomalySummary struct {

	// A AnomalyReportedTimeRange object that specifies the time range between when the
	// anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the anomaly.
	Id *string

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
	// threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the anomaly.
	Status AnomalyStatus

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Details about a proactive insight. This object is returned by ListInsights.
type ProactiveInsight struct {

	// The ID of the proactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the proactive insight.
	Name *string

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the proactive insight.
	Severity InsightSeverity

	// The ID of the AWS System Manager OpsItem created for this insight. You must
	// enable the creation of OpstItems insights before they are created for each
	// insight.
	SsmOpsItemId *string

	// The status of the proactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveInsightSummary struct {

	// The ID of the proactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of the proactive insight.
	Name *string

	// The time range during which anomalous behavior in a proactive anomaly or an
	// insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of AWS services.
	ServiceCollection *ServiceCollection

	// The severity of the proactive insight.
	Severity InsightSeverity

	// The status of the proactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Details about a reactive anomaly. This object is returned by ListAnomalies.
type ReactiveAnomaly struct {

	// A AnomalyReportedTimeRange object that specifies the time range between when the
	// anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the reactive anomaly.
	Id *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the anomaly.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the anomaly.
	Status AnomalyStatus

	noSmithyDocumentSerde
}

// Details about a reactive anomaly. This object is returned by DescribeAnomaly.
type ReactiveAnomalySummary struct {

	// A AnomalyReportedTimeRange object that specifies the time range between when the
	// anomaly is opened and the time when it is closed.
	AnomalyReportedTimeRange *AnomalyReportedTimeRange

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended. This is different from AnomalyReportedTimeRange, which
	// specifies the time range when DevOps Guru opens and then closes an anomaly.
	AnomalyTimeRange *AnomalyTimeRange

	// The ID of the insight that contains this anomaly. An insight is composed of
	// related anomalies.
	AssociatedInsightId *string

	// The ID of the reactive anomaly.
	Id *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of the reactive anomaly.
	Severity AnomalySeverity

	// Details about the source of the analyzed operational data that triggered the
	// anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails

	// The status of the reactive anomaly.
	Status AnomalyStatus

	noSmithyDocumentSerde
}

// Information about a reactive insight. This object is returned by ListInsights.
type ReactiveInsight struct {

	// The ID of a reactive insight.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of a reactive insight.
	Name *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// The severity of a reactive insight.
	Severity InsightSeverity

	// The ID of the AWS System Manager OpsItem created for this insight. You must
	// enable the creation of OpstItems insights before they are created for each
	// insight.
	SsmOpsItemId *string

	// The status of a reactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Information about a reactive insight. This object is returned by
// DescribeInsight.
type ReactiveInsightSummary struct {

	// The ID of a reactive summary.
	Id *string

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange

	// The name of a reactive insight.
	Name *string

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of AWS services.
	ServiceCollection *ServiceCollection

	// The severity of a reactive insight.
	Severity InsightSeverity

	// The status of a reactive insight.
	Status InsightStatus

	noSmithyDocumentSerde
}

// Recommendation information to help you remediate detected anomalous behavior
// that generated an insight.
type Recommendation struct {

	// A description of the problem.
	Description *string

	// A hyperlink to information to help you address the problem.
	Link *string

	// The name of the recommendation.
	Name *string

	// The reason DevOps Guru flagged the anomalous behavior as a problem.
	Reason *string

	// Anomalies that are related to the problem. Use these Anomalies to learn more
	// about what's happening and to help address the issue.
	RelatedAnomalies []RecommendationRelatedAnomaly

	// Events that are related to the problem. Use these events to learn more about
	// what's happening and to help address the issue.
	RelatedEvents []RecommendationRelatedEvent

	noSmithyDocumentSerde
}

// Information about an anomaly that is related to a recommendation.
type RecommendationRelatedAnomaly struct {

	// An array of objects that represent resources in which DevOps Guru detected
	// anomalous behavior. Each object contains the name and type of the resource.
	Resources []RecommendationRelatedAnomalyResource

	// Information about where the anomalous behavior related the recommendation was
	// found. For example, details in Amazon CloudWatch metrics.
	SourceDetails []RecommendationRelatedAnomalySourceDetail

	noSmithyDocumentSerde
}

// Information about a resource in which DevOps Guru detected anomalous behavior.
type RecommendationRelatedAnomalyResource struct {

	// The name of the resource.
	Name *string

	// The type of the resource.
	Type *string

	noSmithyDocumentSerde
}

// Contains an array of RecommendationRelatedCloudWatchMetricsSourceDetail objects
// that contain the name and namespace of an Amazon CloudWatch metric.
type RecommendationRelatedAnomalySourceDetail struct {

	// An array of CloudWatchMetricsDetail objects that contains information about the
	// analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []RecommendationRelatedCloudWatchMetricsSourceDetail

	noSmithyDocumentSerde
}

// Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru.
// It is one of many analyzed metrics that are used to generate insights.
type RecommendationRelatedCloudWatchMetricsSourceDetail struct {

	// The name of the CloudWatch metric.
	MetricName *string

	// The namespace of the CloudWatch metric. A namespace is a container for
	// CloudWatch metrics.
	Namespace *string

	noSmithyDocumentSerde
}

// Information about an event that is related to a recommendation.
type RecommendationRelatedEvent struct {

	// The name of the event. This corresponds to the Name field in an Event object.
	Name *string

	// A ResourceCollection object that contains arrays of the names of AWS
	// CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
	Resources []RecommendationRelatedEventResource

	noSmithyDocumentSerde
}

// Information about an AWS resource that emitted and event that is related to a
// recommendation in an insight.
type RecommendationRelatedEventResource struct {

	// The name of the resource that emitted the event. This corresponds to the Name
	// field in an EventResource object.
	Name *string

	// The type of the resource that emitted the event. This corresponds to the Type
	// field in an EventResource object.
	Type *string

	noSmithyDocumentSerde
}

// A collection of AWS resources supported by DevOps Guru. The one type of AWS
// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
// configured to analyze only the AWS resources that are defined in the stacks. You
// can specify up to 500 AWS CloudFormation stacks.
type ResourceCollection struct {

	// An array of the names of AWS CloudFormation stacks. The stacks define AWS
	// resources that DevOps Guru analyzes. You can specify up to 500 AWS
	// CloudFormation stacks.
	CloudFormation *CloudFormationCollection

	noSmithyDocumentSerde
}

// Information about a filter used to specify which AWS resources are analyzed for
// anomalous behavior by DevOps Guru.
type ResourceCollectionFilter struct {

	// Information about AWS CloudFormation stacks. You can use up to 500 stacks to
	// specify which AWS resources in your account to analyze. For more information,
	// see Stacks
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in
	// the AWS CloudFormation User Guide.
	CloudFormation *CloudFormationCollectionFilter

	noSmithyDocumentSerde
}

// Specifies one or more severity values and one or more status values that are
// used to search for insights.
type SearchInsightsFilters struct {

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can be
	// configured to analyze only the AWS resources that are defined in the stacks. You
	// can specify up to 500 AWS CloudFormation stacks.
	ResourceCollection *ResourceCollection

	// A collection of the names of AWS services.
	ServiceCollection *ServiceCollection

	// An array of severity values used to search for insights.
	Severities []InsightSeverity

	// An array of status values used to search for insights.
	Statuses []InsightStatus

	noSmithyDocumentSerde
}

// A collection of the names of AWS services.
type ServiceCollection struct {

	// An array of strings that each specifies the name of an AWS service.
	ServiceNames []ServiceName

	noSmithyDocumentSerde
}

// Represents the health of an AWS service.
type ServiceHealth struct {

	// Represents the health of an AWS service. This is a ServiceInsightHealth that
	// contains the number of open proactive and reactive insights for this service.
	Insight *ServiceInsightHealth

	// The name of the AWS service.
	ServiceName ServiceName

	noSmithyDocumentSerde
}

// Contains the number of open proactive and reactive insights in an analyzed AWS
// service.
type ServiceInsightHealth struct {

	// The number of open proactive insights in the AWS service
	OpenProactiveInsights int32

	// The number of open reactive insights in the AWS service
	OpenReactiveInsights int32

	noSmithyDocumentSerde
}

// Information about the integration of DevOps Guru with another AWS service, such
// as AWS Systems Manager.
type ServiceIntegrationConfig struct {

	// Information about whether DevOps Guru is configured to create an OpsItem in AWS
	// Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegration

	noSmithyDocumentSerde
}

// An object that contains information about the estimated monthly cost to analyze
// an AWS resource. For more information, see Estimate your Amazon DevOps Guru
// costs
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
type ServiceResourceCost struct {

	// The total estimated monthly cost to analyze the active resources for this
	// resource.
	Cost float64

	// The number of active resources analyzed for this service to create a monthly
	// cost estimate.
	Count int32

	// The state of the resource. The resource is ACTIVE if it produces metrics,
	// events, or logs within an hour, otherwise it is INACTIVE. You pay for the number
	// of active AWS resource hours analyzed for each resource. Inactive resources are
	// not charged.
	State CostEstimationServiceResourceState

	// The type of the AWS resource.
	Type *string

	// The price per hour to analyze the resources in the service. For more
	// information, see Estimate your Amazon DevOps Guru costs
	// (https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html)
	// and Amazon DevOps Guru pricing (http://aws.amazon.com/devops-guru/pricing/).
	UnitCost float64

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service
// topic. If you use an Amazon SNS topic in another account, you must attach a
// policy to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon SNS
// in your account. For more information, see Permissions for cross account Amazon
// SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
// Service customer-managed key (CMK), then you must add permissions to the CMK.
// For more information, see Permissions for AWS KMS–encrypted Amazon SNS topics
// (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type SnsChannelConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
	TopicArn *string

	noSmithyDocumentSerde
}

// A time range used to specify when the behavior of an insight or anomaly started.
type StartTimeRange struct {

	// The start time of the time range.
	FromTime *time.Time

	// The end time of the time range.
	ToTime *time.Time

	noSmithyDocumentSerde
}

// Contains the names of AWS CloudFormation stacks used to update a collection of
// stacks. You can specify up to 500 AWS CloudFormation stacks.
type UpdateCloudFormationCollectionFilter struct {

	// An array of the names of the AWS CloudFormation stacks to update. You can
	// specify up to 500 AWS CloudFormation stacks.
	StackNames []string

	noSmithyDocumentSerde
}

// Contains information used to update a collection of AWS resources.
type UpdateResourceCollectionFilter struct {

	// An collection of AWS CloudFormation stacks. You can specify up to 500 AWS
	// CloudFormation stacks.
	CloudFormation *UpdateCloudFormationCollectionFilter

	noSmithyDocumentSerde
}

// Information about updating the integration status of an AWS service, such as AWS
// Systems Manager, with DevOps Guru.
type UpdateServiceIntegrationConfig struct {

	// Information about whether DevOps Guru is configured to create an OpsItem in AWS
	// Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegrationConfig

	noSmithyDocumentSerde
}

// The field associated with the validation exception.
type ValidationExceptionField struct {

	// The message associated with the validation exception with information to help
	// determine its cause.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
