// Code generated by smithy-go-codegen DO NOT EDIT.

package detective

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/detective/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends a request to invite the specified AWS accounts to be member accounts in
// the behavior graph. This operation can only be called by the administrator
// account for a behavior graph. CreateMembers verifies the accounts and then
// invites the verified accounts. The administrator can optionally specify to not
// send invitation emails to the member accounts. This would be used when the
// administrator manages their member accounts centrally. The request provides the
// behavior graph ARN and the list of accounts to invite. The response separates
// the requested accounts into two lists:
//
// * The accounts that CreateMembers was
// able to start the verification for. This list includes member accounts that are
// being verified, that have passed verification and are to be invited, and that
// have failed verification.
//
// * The accounts that CreateMembers was unable to
// process. This list includes accounts that were already invited to be member
// accounts in the behavior graph.
func (c *Client) CreateMembers(ctx context.Context, params *CreateMembersInput, optFns ...func(*Options)) (*CreateMembersOutput, error) {
	if params == nil {
		params = &CreateMembersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMembers", params, optFns, c.addOperationCreateMembersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMembersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMembersInput struct {

	// The list of AWS accounts to invite to become member accounts in the behavior
	// graph. You can invite up to 50 accounts at a time. For each invited account, the
	// account list contains the account identifier and the AWS account root user email
	// address.
	//
	// This member is required.
	Accounts []types.Account

	// The ARN of the behavior graph to invite the member accounts to contribute their
	// data to.
	//
	// This member is required.
	GraphArn *string

	// if set to true, then the member accounts do not receive email notifications. By
	// default, this is set to false, and the member accounts receive email
	// notifications.
	DisableEmailNotification bool

	// Customized message text to include in the invitation email message to the
	// invited member accounts.
	Message *string

	noSmithyDocumentSerde
}

type CreateMembersOutput struct {

	// The set of member account invitation requests that Detective was able to
	// process. This includes accounts that are being verified, that failed
	// verification, and that passed verification and are being sent an invitation.
	Members []types.MemberDetail

	// The list of accounts for which Detective was unable to process the invitation
	// request. For each account, the list provides the reason why the request could
	// not be processed. The list includes accounts that are already member accounts in
	// the behavior graph.
	UnprocessedAccounts []types.UnprocessedAccount

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMembersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMembers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMembers{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateMembersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMembers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMembers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "detective",
		OperationName: "CreateMembers",
	}
}
