// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Structure that contains the results of the account gate function which
// CloudFormation invokes, if present, before proceeding with a stack set operation
// in an account and Region. For each account and Region, CloudFormation lets you
// specify a Lambda function that encapsulates any requirements that must be met
// before CloudFormation can proceed with a stack set operation in that account and
// Region. CloudFormation invokes the function each time a stack set operation is
// requested for that account and Region; if the function returns FAILED,
// CloudFormation cancels the operation in that account and Region, and sets the
// stack set operation result status for that account and Region to FAILED. For
// more information, see Configuring a target account gate
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html).
type AccountGateResult struct {

	// The status of the account gate function.
	//
	// * SUCCEEDED: The account gate function
	// has determined that the account and Region passes any requirements for a stack
	// set operation to occur. CloudFormation proceeds with the stack operation in that
	// account and Region.
	//
	// * FAILED: The account gate function has determined that the
	// account and Region does not meet the requirements for a stack set operation to
	// occur. AWS CloudFormation cancels the stack set operation in that account and
	// Region, and sets the stack set operation result status for that account and
	// Region to FAILED.
	//
	// * SKIPPED: CloudFormation has skipped calling the account
	// gate function for this account and Region, for one of the following reasons:
	//
	// *
	// An account gate function has not been specified for the account and Region.
	// CloudFormation proceeds with the stack set operation in this account and
	// Region.
	//
	// * The AWSCloudFormationStackSetExecutionRole of the stack set
	// adminstration account lacks permissions to invoke the function. CloudFormation
	// proceeds with the stack set operation in this account and Region.
	//
	// * Either no
	// action is necessary, or no action is possible, on the stack. CloudFormation
	// skips the stack set operation in this account and Region.
	Status AccountGateStatus

	// The reason for the account gate status assigned to this account and Region for
	// the stack set operation.
	StatusReason *string

	noSmithyDocumentSerde
}

// The AccountLimit data type. CloudFormation has the following limits per
// account:
//
// * Number of concurrent resources
//
// * Number of stacks
//
// * Number of
// stack outputs
//
// For more information about these account limits, and other
// CloudFormation limits, see CloudFormation Limits
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the CloudFormation User Guide.
type AccountLimit struct {

	// The name of the account limit. Values: ConcurrentResourcesLimit | StackLimit |
	// StackOutputsLimit
	Name *string

	// The value that is associated with the account limit name.
	Value *int32

	noSmithyDocumentSerde
}

// [Service-managed permissions] Describes whether StackSets automatically deploys
// to Organizations accounts that are added to a target organization or
// organizational unit (OU).
type AutoDeployment struct {

	// If set to true, StackSets automatically deploys additional stack instances to
	// Organizations accounts that are added to a target organization or organizational
	// unit (OU) in the specified Regions. If an account is removed from a target
	// organization or OU, StackSets deletes stack instances from the account in the
	// specified Regions.
	Enabled *bool

	// If set to true, stack resources are retained when an account is removed from a
	// target organization or OU. If set to false, stack resources are deleted. Specify
	// only if Enabled is set to True.
	RetainStacksOnAccountRemoval *bool

	noSmithyDocumentSerde
}

// Detailed information concerning an error generated during the setting of
// configuration data for a CloudFormation extension.
type BatchDescribeTypeConfigurationsError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	ErrorMessage *string

	// Identifying information for the configuration of a CloudFormation extension.
	TypeConfigurationIdentifier *TypeConfigurationIdentifier

	noSmithyDocumentSerde
}

// The Change structure describes the changes CloudFormation will perform if you
// execute the change set.
type Change struct {

	// A ResourceChange structure that describes the resource and action that
	// CloudFormation will perform.
	ResourceChange *ResourceChange

	// The type of entity that CloudFormation changes. Currently, the only entity type
	// is Resource.
	Type ChangeType

	noSmithyDocumentSerde
}

// The ChangeSetSummary structure describes a change set, its status, and the stack
// with which it's associated.
type ChangeSetSummary struct {

	// The ID of the change set.
	ChangeSetId *string

	// The name of the change set.
	ChangeSetName *string

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time

	// Descriptive information about the change set.
	Description *string

	// If the change set execution status is AVAILABLE, you can execute the change set.
	// If you can’t execute the change set, the status indicates why. For example, a
	// change set might be in an UNAVAILABLE state because CloudFormation is still
	// creating it or in an OBSOLETE state because the stack was already updated.
	ExecutionStatus ExecutionStatus

	// Specifies the current setting of IncludeNestedStacks for the change set.
	IncludeNestedStacks *bool

	// The parent change set ID.
	ParentChangeSetId *string

	// The root change set ID.
	RootChangeSetId *string

	// The ID of the stack with which the change set is associated.
	StackId *string

	// The name of the stack with which the change set is associated.
	StackName *string

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE, or
	// FAILED.
	Status ChangeSetStatus

	// A description of the change set's status. For example, if your change set is in
	// the FAILED state, CloudFormation shows the error message.
	StatusReason *string

	noSmithyDocumentSerde
}

// [Service-managed permissions] The Organizations accounts to which StackSets
// deploys. StackSets does not deploy stack instances to the organization
// management account, even if the organization management account is in your
// organization or in an OU in your organization. For update operations, you can
// specify either Accounts or OrganizationalUnitIds. For create and delete
// operations, specify OrganizationalUnitIds.
type DeploymentTargets struct {

	// The names of one or more Amazon Web Services accounts for which you want to
	// deploy stack set updates.
	Accounts []string

	// Returns the value of the AccountsUrl property.
	AccountsUrl *string

	// The organization root ID or organizational unit (OU) IDs to which StackSets
	// deploys.
	OrganizationalUnitIds []string

	noSmithyDocumentSerde
}

// The Export structure describes the exported output values for a stack.
type Export struct {

	// The stack that contains the exported output name and value.
	ExportingStackId *string

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string

	// The value of the exported output, such as a resource physical ID. This value is
	// defined in the Export field in the associated stack's Outputs section.
	Value *string

	noSmithyDocumentSerde
}

// Contains logging configuration information for an extension.
type LoggingConfig struct {

	// The Amazon CloudWatch log group to which CloudFormation sends error logging
	// information when invoking the extension's handlers.
	//
	// This member is required.
	LogGroupName *string

	// The ARN of the role that CloudFormation should assume when sending log entries
	// to CloudWatch logs.
	//
	// This member is required.
	LogRoleArn *string

	noSmithyDocumentSerde
}

// Contains information about the module from which the resource was created, if
// the resource was created from a module included in the stack template. For more
// information on modules, see Using modules to encapsulate and reuse resource
// configurations in the CloudFormation User Guide.
type ModuleInfo struct {

	// A concantenated list of the logical IDs of the module or modules containing the
	// resource. Modules are listed starting with the inner-most nested module, and
	// separated by /. In the following example, the resource was created from a
	// module, moduleA, that is nested inside a parent module, moduleB. moduleA/moduleB
	// For more information, see Referencing resources in a module in the
	// CloudFormation User Guide.
	LogicalIdHierarchy *string

	// A concantenated list of the the module type or types containing the resource.
	// Module types are listed starting with the inner-most nested module, and
	// separated by /. In the following example, the resource was created from a module
	// of type AWS::First::Example::MODULE, that is nested inside a parent module of
	// type AWS::Second::Example::MODULE.
	// AWS::First::Example::MODULE/AWS::Second::Example::MODULE
	TypeHierarchy *string

	noSmithyDocumentSerde
}

// The Output data type.
type Output struct {

	// User defined description associated with the output.
	Description *string

	// The name of the export associated with the output.
	ExportName *string

	// The key associated with the output.
	OutputKey *string

	// The value associated with the output.
	OutputValue *string

	noSmithyDocumentSerde
}

// The Parameter data type.
type Parameter struct {

	// The key associated with the parameter. If you don't specify a key and value for
	// a particular parameter, CloudFormation uses the default value that is specified
	// in your template.
	ParameterKey *string

	// The input value associated with the parameter.
	ParameterValue *string

	// Read-only. The value that corresponds to a Systems Manager parameter key. This
	// field is returned only for SSM parameter types
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types)
	// in the template.
	ResolvedValue *string

	// During a stack update, use the existing parameter value that the stack is using
	// for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool

	noSmithyDocumentSerde
}

// A set of criteria that CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template,
// CloudFormation returns only the AllowedValues property.
type ParameterConstraints struct {

	// A list of values that are permitted for a parameter.
	AllowedValues []string

	noSmithyDocumentSerde
}

// The ParameterDeclaration data type.
type ParameterDeclaration struct {

	// The default value of the parameter.
	DefaultValue *string

	// The description that is associate with the parameter.
	Description *string

	// Flag that indicates whether the parameter value is shown as plain text in logs
	// and in the Amazon Web Services Management Console.
	NoEcho *bool

	// The criteria that CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints

	// The name that is associated with the parameter.
	ParameterKey *string

	// The type of parameter.
	ParameterType *string

	noSmithyDocumentSerde
}

// Context information that enables CloudFormation to uniquely identify a resource.
// CloudFormation uses context key-value pairs in cases where a resource's logical
// and physical IDs are not enough to uniquely identify that resource. Each context
// key-value pair specifies a resource that contains the targeted resource.
type PhysicalResourceIdContextKeyValuePair struct {

	// The resource context key.
	//
	// This member is required.
	Key *string

	// The resource context value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about a resource property whose actual value differs from its
// expected value, as defined in the stack template and any values specified as
// template parameters. These will be present only for resources whose
// StackResourceDriftStatus is MODIFIED. For more information, see Detecting
// Unregulated Configuration Changes to Stacks and Resources
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
type PropertyDifference struct {

	// The actual property value of the resource property.
	//
	// This member is required.
	ActualValue *string

	// The type of property difference.
	//
	// * ADD: A value has been added to a resource
	// property that is an array or list data type.
	//
	// * REMOVE: The property has been
	// removed from the current resource configuration.
	//
	// * NOT_EQUAL: The current
	// property value differs from its expected value (as defined in the stack template
	// and any values specified as template parameters).
	//
	// This member is required.
	DifferenceType DifferenceType

	// The expected property value of the resource property, as defined in the stack
	// template and any values specified as template parameters.
	//
	// This member is required.
	ExpectedValue *string

	// The fully-qualified path to the resource property.
	//
	// This member is required.
	PropertyPath *string

	noSmithyDocumentSerde
}

// For extensions that are modules, a public third-party extension that must be
// activated in your account in order for the module itself to be activated. For
// more information, see Activating public modules for use in your account
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html#module-enabling)
// in the CloudFormation User Guide.
type RequiredActivatedType struct {

	// The type name of the public extension. If you specified a TypeNameAlias when
	// enabling the extension in this account and region, CloudFormation treats that
	// alias as the extension's type name within the account and region, not the type
	// name of the public extension. For more information, see Specifying aliases to
	// refer to extensions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias)
	// in the CloudFormation User Guide.
	OriginalTypeName *string

	// The publisher ID of the extension publisher.
	PublisherId *string

	// A list of the major versions of the extension type that the macro supports.
	SupportedMajorVersions []int32

	// An alias assigned to the public extension, in this account and region. If you
	// specify an alias for the extension, CloudFormation treats the alias as the
	// extension type name within this account and region. You must use the alias to
	// refer to the extension in your templates, API calls, and CloudFormation console.
	TypeNameAlias *string

	noSmithyDocumentSerde
}

// The ResourceChange structure describes the resource and the action that
// CloudFormation will perform on it if you execute this change set.
type ResourceChange struct {

	// The action that CloudFormation takes on the resource, such as Add (adds a new
	// resource), Modify (changes a resource), Remove (deletes a resource), Import
	// (imports a resource), or Dynamic (exact action for the resource cannot be
	// determined).
	Action ChangeAction

	// The change set ID of the nested change set.
	ChangeSetId *string

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that CloudFormation will make to the resource.
	Details []ResourceChangeDetail

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string

	// Contains information about the module from which the resource was created, if
	// the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo

	// The resource's physical ID (resource name). Resources that you are adding don't
	// have physical IDs because they haven't been created.
	PhysicalResourceId *string

	// For the Modify action, indicates whether CloudFormation will replace the
	// resource by creating a new one and deleting the old one. This value depends on
	// the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation field
	// is Always and the Evaluation field is Dynamic, Replacement is Conditionally. If
	// you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A
	// RequiresRecreation value of Always has the most impact, followed by
	// Conditionally, and then Never.
	Replacement Replacement

	// The type of CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties, or
	// Tags.
	Scope []ResourceAttribute

	noSmithyDocumentSerde
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes CloudFormation will make to that resource.
type ResourceChangeDetail struct {

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that is specified by the ChangeSource field. For example, if you
	// modified the value of the KeyPairName parameter, the CausingEntity is the name
	// of the parameter (KeyPairName). If the ChangeSource value is DirectModification,
	// no value is given for CausingEntity.
	CausingEntity *string

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	// * ResourceReference entities are Ref intrinsic functions that refer to
	// resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	// *
	// ParameterReference entities are Ref intrinsic functions that get template
	// parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	// *
	// ResourceAttribute entities are Fn::GetAtt intrinsic functions that get resource
	// attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	// "PublicDnsName" ] }.
	//
	// * DirectModification entities are changes that are made
	// directly to the template.
	//
	// * Automatic entities are AWS::CloudFormation::Stack
	// resource types, which are also known as nested stacks. If you made no changes to
	// the AWS::CloudFormation::Stack resource, CloudFormation sets the ChangeSource to
	// Automatic because the nested stack's template might have changed. Changes to a
	// nested stack's template aren't visible to CloudFormation until you run an update
	// on the parent stack.
	ChangeSource ChangeSource

	// Indicates whether CloudFormation can determine the target value, and whether the
	// target value will change before you execute a change set. For Static
	// evaluations, CloudFormation can determine that the target value will change, and
	// its value. For example, if you directly modify the InstanceType property of an
	// EC2 instance, CloudFormation knows that this property value will change, and its
	// value, so this is a Static evaluation. For Dynamic evaluations, cannot determine
	// the target value because it depends on the result of an intrinsic function, such
	// as a Ref or Fn::GetAtt intrinsic function, when the stack is updated. For
	// example, if your template includes a reference to a resource that is
	// conditionally recreated, the value of the reference (the physical ID of the
	// resource) might change, depending on if the resource is recreated. If the
	// resource is recreated, it will have a new physical ID, so all references to that
	// resource will also be updated.
	Evaluation EvaluationType

	// A ResourceTargetDefinition structure that describes the field that
	// CloudFormation will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition

	noSmithyDocumentSerde
}

// Describes the target resources of a specific type in your import template (for
// example, all AWS::S3::Bucket resources) and the properties you can provide
// during the import to identify resources of that type.
type ResourceIdentifierSummary struct {

	// The logical IDs of the target resources of the specified ResourceType, as
	// defined in the import template.
	LogicalResourceIds []string

	// The resource properties you can provide during the import to identify your
	// target resources. For example, BucketName is a possible identifier property for
	// AWS::S3::Bucket resources.
	ResourceIdentifiers []string

	// The template resource type of the target resources, such as AWS::S3::Bucket.
	ResourceType *string

	noSmithyDocumentSerde
}

// The field that CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
type ResourceTargetDefinition struct {

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute ResourceAttribute

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always, or
	// Conditionally. To determine the conditions for a Conditionally recreation, see
	// the update behavior for that property
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	RequiresRecreation RequiresRecreation

	noSmithyDocumentSerde
}

// Describes the target resource of an import operation.
type ResourceToImport struct {

	// The logical ID of the target resource as specified in the template.
	//
	// This member is required.
	LogicalResourceId *string

	// A key-value pair that identifies the target resource. The key is an identifier
	// property (for example, BucketName for AWS::S3::Bucket resources) and the value
	// is the actual property value (for example, MyS3Bucket).
	//
	// This member is required.
	ResourceIdentifier map[string]string

	// The type of resource to import into your stack, such as AWS::S3::Bucket. For a
	// list of supported resource types, see Resources that support import operations
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// in the CloudFormation User Guide.
	//
	// This member is required.
	ResourceType *string

	noSmithyDocumentSerde
}

// Structure containing the rollback triggers for CloudFormation to monitor during
// stack creation and updating operations, and for the specified monitoring period
// afterwards. Rollback triggers enable you to have CloudFormation monitor the
// state of your application during stack creation and updating, and to roll back
// that operation if the application breaches the threshold of any of the alarms
// you've specified. For more information, see Monitor and Roll Back Stack
// Operations
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html).
type RollbackConfiguration struct {

	// The amount of time, in minutes, during which CloudFormation should monitor all
	// the rollback triggers after the stack creation or update operation deploys all
	// necessary resources. The default is 0 minutes. If you specify a monitoring
	// period but do not specify any rollback triggers, CloudFormation still waits the
	// specified period of time before cleaning up old resources after update
	// operations. You can use this monitoring period to perform any manual stack
	// validation desired, and manually cancel the stack creation or update (using
	// CancelUpdateStack
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html),
	// for example) as necessary. If you specify 0 for this parameter, CloudFormation
	// still monitors the specified rollback triggers during stack creation and update
	// operations. Then, for update operations, it begins disposing of old resources
	// immediately once the operation completes.
	MonitoringTimeInMinutes *int32

	// The triggers to monitor during stack creation or update actions. By default,
	// CloudFormation saves the rollback triggers specified for a stack and applies
	// them to any subsequent update operations for the stack, unless you specify
	// otherwise. If you do specify rollback triggers for this parameter, those
	// triggers replace any list of triggers previously specified for the stack. This
	// means:
	//
	// * To use the rollback triggers previously specified for this stack, if
	// any, don't specify this parameter.
	//
	// * To specify new or updated rollback
	// triggers, you must specify all the triggers that you want used for this stack,
	// even triggers you've specifed before (for example, when creating the stack or
	// during a previous stack update). Any triggers that you don't include in the
	// updated list of triggers are no longer applied to the stack.
	//
	// * To remove all
	// currently specified triggers, specify an empty list for this parameter.
	//
	// If a
	// specified trigger is missing, the entire stack operation fails and is rolled
	// back.
	RollbackTriggers []RollbackTrigger

	noSmithyDocumentSerde
}

// A rollback trigger CloudFormation monitors during creation and updating of
// stacks. If any of the alarms you specify goes to ALARM state during the stack
// operation or within the specified monitoring period afterwards, CloudFormation
// rolls back the entire stack operation.
type RollbackTrigger struct {

	// The Amazon Resource Name (ARN) of the rollback trigger. If a specified trigger
	// is missing, the entire stack operation fails and is rolled back.
	//
	// This member is required.
	Arn *string

	// The resource type of the rollback trigger. Currently, AWS::CloudWatch::Alarm
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html)
	// is the only supported resource type.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// The Stack data type.
type Stack struct {

	// The time at which the stack was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name associated with the stack.
	//
	// This member is required.
	StackName *string

	// Current status of the stack.
	//
	// This member is required.
	StackStatus StackStatus

	// The capabilities allowed in the stack.
	Capabilities []Capability

	// The unique ID of the change set.
	ChangeSetId *string

	// The time the stack was deleted.
	DeletionTime *time.Time

	// A user-defined description associated with the stack.
	Description *string

	// Boolean to enable or disable rollback on stack creation failures:
	//
	// * true:
	// disable rollback
	//
	// * false: enable rollback
	DisableRollback *bool

	// Information on whether a stack's actual configuration differs, or has drifted,
	// from it's expected configuration, as defined in the stack template and any
	// values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformation

	// Whether termination protection is enabled for the stack. For nested stacks
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack. For more information, see Protecting a Stack From Being
	// Deleted
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the CloudFormation User Guide.
	EnableTerminationProtection *bool

	// The time the stack was last updated. This field will only be returned if the
	// stack has been updated at least once.
	LastUpdatedTime *time.Time

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []string

	// A list of output structures.
	Outputs []Output

	// A list of Parameter structures.
	Parameters []Parameter

	// For nested stacks--stacks created as resources for another stack--the stack ID
	// of the direct parent of this stack. For the first level of nested stacks, the
	// root stack is also the parent stack. For more information, see Working with
	// Nested Stacks
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	ParentId *string

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
	// that is associated with the stack. During a stack operation, CloudFormation uses
	// this role's credentials to make calls on your behalf.
	RoleARN *string

	// The rollback triggers for CloudFormation to monitor during stack creation and
	// updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration

	// For nested stacks--stacks created as resources for another stack--the stack ID
	// of the top-level stack to which the nested stack ultimately belongs. For more
	// information, see Working with Nested Stacks
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	RootId *string

	// Unique identifier of the stack.
	StackId *string

	// Success/failure message associated with the stack status.
	StackStatusReason *string

	// A list of Tags that specify information about the stack.
	Tags []Tag

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int32

	noSmithyDocumentSerde
}

// Contains information about whether the stack's actual configuration differs, or
// has drifted, from its expected configuration, as defined in the stack template
// and any values specified as template parameters. A stack is considered to have
// drifted if one or more of its resources have drifted.
type StackDriftInformation struct {

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	// * DRIFTED: The stack differs from its expected template
	// configuration. A stack is considered to have drifted if one or more of its
	// resources have drifted.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the
	// stack differs from its expected template configuration.
	//
	// * IN_SYNC: The stack's
	// actual configuration matches its expected template configuration.
	//
	// * UNKNOWN:
	// This value is reserved for future use.
	//
	// This member is required.
	StackDriftStatus StackDriftStatus

	// Most recent time when a drift detection operation was initiated on the stack, or
	// any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about whether the stack's actual configuration differs, or
// has drifted, from its expected configuration, as defined in the stack template
// and any values specified as template parameters. A stack is considered to have
// drifted if one or more of its resources have drifted.
type StackDriftInformationSummary struct {

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	// * DRIFTED: The stack differs from its expected template
	// configuration. A stack is considered to have drifted if one or more of its
	// resources have drifted.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the
	// stack differs from its expected template configuration.
	//
	// * IN_SYNC: The stack's
	// actual configuration matches its expected template configuration.
	//
	// * UNKNOWN:
	// This value is reserved for future use.
	//
	// This member is required.
	StackDriftStatus StackDriftStatus

	// Most recent time when a drift detection operation was initiated on the stack, or
	// any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time

	noSmithyDocumentSerde
}

// The StackEvent data type.
type StackEvent struct {

	// The unique ID of this event.
	//
	// This member is required.
	EventId *string

	// The unique ID name of the instance of the stack.
	//
	// This member is required.
	StackId *string

	// The name associated with a stack.
	//
	// This member is required.
	StackName *string

	// Time the status was updated.
	//
	// This member is required.
	Timestamp *time.Time

	// The token passed to the operation that generated this event. All events
	// triggered by a given stack operation are assigned the same client request token,
	// which you can use to track operations. For example, if you execute a CreateStack
	// operation with the token token1, then all the StackEvents generated by that
	// operation will have ClientRequestToken set as token1. In the console, stack
	// operations display the client request token on the Events tab. Stack operations
	// that are initiated from the console use the token format
	// Console-StackOperation-ID, which helps you easily identify the stack operation .
	// For example, if you create a stack using the console, each stack event would be
	// assigned the same token in the following format:
	// Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string

	// The logical name of the resource specified in the template.
	LogicalResourceId *string

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string

	// BLOB of the properties used to create the resource.
	ResourceProperties *string

	// Current status of the resource.
	ResourceStatus ResourceStatus

	// Success/failure message associated with the resource.
	ResourceStatusReason *string

	// Type of resource. (For more information, go to Amazon Web Services Resource
	// Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	ResourceType *string

	noSmithyDocumentSerde
}

// An CloudFormation stack, in a specific account and Region, that's part of a
// stack set operation. A stack instance is a reference to an attempted or actual
// stack in a given account within a given Region. A stack instance can exist
// without a stack—for example, if the stack couldn't be created for some reason. A
// stack instance is associated with only one stack set. Each stack instance
// contains the ID of its associated stack set, as well as the ID of the actual
// stack and the stack status.
type StackInstance struct {

	// [Self-managed permissions] The name of the Amazon Web Services account that the
	// stack instance is associated with.
	Account *string

	// Status of the stack instance's actual configuration compared to the expected
	// template and parameter configuration of the stack set to which it belongs.
	//
	// *
	// DRIFTED: The stack differs from the expected template and parameter
	// configuration of the stack set to which it belongs. A stack instance is
	// considered to have drifted if one or more of the resources in the associated
	// stack have drifted.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the stack
	// instance differs from its expected stack set configuration.
	//
	// * IN_SYNC: The
	// stack instance's actual configuration matches its expected stack set
	// configuration.
	//
	// * UNKNOWN: This value is reserved for future use.
	DriftStatus StackDriftStatus

	// Most recent time when CloudFormation performed a drift detection operation on
	// the stack instance. This value will be NULL for any stack instance on which
	// drift detection has not yet been performed.
	LastDriftCheckTimestamp *time.Time

	// [Service-managed permissions] The organization root ID or organizational unit
	// (OU) IDs that you specified for DeploymentTargets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string

	// A list of parameters from the stack set template whose values have been
	// overridden in this stack instance.
	ParameterOverrides []Parameter

	// The name of the Amazon Web Services Region that the stack instance is associated
	// with.
	Region *string

	// The ID of the stack instance.
	StackId *string

	// The detailed status of the stack instance.
	StackInstanceStatus *StackInstanceComprehensiveStatus

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	// * INOPERABLE: A DeleteStackInstances operation has failed
	// and left the stack in an unstable state. Stacks in this state are excluded from
	// further UpdateStackSet operations. You might need to perform a
	// DeleteStackInstances operation, with RetainStacks set to true, to delete the
	// stack instance, and then delete the stack manually.
	//
	// * OUTDATED: The stack isn't
	// currently up to date with the stack set because:
	//
	// * The associated stack failed
	// during a CreateStackSet or UpdateStackSet operation.
	//
	// * The stack was part of a
	// CreateStackSet or UpdateStackSet operation that failed or was stopped before the
	// stack was created or updated.
	//
	// * CURRENT: The stack is currently up to date with
	// the stack set.
	Status StackInstanceStatus

	// The explanation for the specific status code that is assigned to this stack
	// instance.
	StatusReason *string

	noSmithyDocumentSerde
}

// The detailed status of the stack instance.
type StackInstanceComprehensiveStatus struct {

	// * CANCELLED: The operation in the specified account and Region has been
	// cancelled. This is either because a user has stopped the stack set operation, or
	// because the failure tolerance of the stack set operation has been exceeded.
	//
	// *
	// FAILED: The operation in the specified account and Region failed. If the stack
	// set operation fails in enough accounts within a Region, the failure tolerance
	// for the stack set operation as a whole might be exceeded.
	//
	// * INOPERABLE: A
	// DeleteStackInstances operation has failed and left the stack in an unstable
	// state. Stacks in this state are excluded from further UpdateStackSet operations.
	// You might need to perform a DeleteStackInstances operation, with RetainStacks
	// set to true, to delete the stack instance, and then delete the stack
	// manually.
	//
	// * PENDING: The operation in the specified account and Region has yet
	// to start.
	//
	// * RUNNING: The operation in the specified account and Region is
	// currently in progress.
	//
	// * SUCCEEDED: The operation in the specified account and
	// Region completed successfully.
	DetailedStatus StackInstanceDetailedStatus

	noSmithyDocumentSerde
}

// The status that stack instances are filtered by.
type StackInstanceFilter struct {

	// The type of filter to apply.
	Name StackInstanceFilterName

	// The status to filter by.
	Values *string

	noSmithyDocumentSerde
}

// The structure that contains summary information about a stack instance.
type StackInstanceSummary struct {

	// [Self-managed permissions] The name of the Amazon Web Services account that the
	// stack instance is associated with.
	Account *string

	// Status of the stack instance's actual configuration compared to the expected
	// template and parameter configuration of the stack set to which it belongs.
	//
	// *
	// DRIFTED: The stack differs from the expected template and parameter
	// configuration of the stack set to which it belongs. A stack instance is
	// considered to have drifted if one or more of the resources in the associated
	// stack have drifted.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the stack
	// instance differs from its expected stack set configuration.
	//
	// * IN_SYNC: The
	// stack instance's actual configuration matches its expected stack set
	// configuration.
	//
	// * UNKNOWN: This value is reserved for future use.
	DriftStatus StackDriftStatus

	// Most recent time when CloudFormation performed a drift detection operation on
	// the stack instance. This value will be NULL for any stack instance on which
	// drift detection has not yet been performed.
	LastDriftCheckTimestamp *time.Time

	// [Service-managed permissions] The organization root ID or organizational unit
	// (OU) IDs that you specified for DeploymentTargets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string

	// The name of the Amazon Web Services Region that the stack instance is associated
	// with.
	Region *string

	// The ID of the stack instance.
	StackId *string

	// The detailed status of the stack instance.
	StackInstanceStatus *StackInstanceComprehensiveStatus

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	// * INOPERABLE: A DeleteStackInstances operation has failed
	// and left the stack in an unstable state. Stacks in this state are excluded from
	// further UpdateStackSet operations. You might need to perform a
	// DeleteStackInstances operation, with RetainStacks set to true, to delete the
	// stack instance, and then delete the stack manually.
	//
	// * OUTDATED: The stack isn't
	// currently up to date with the stack set because:
	//
	// * The associated stack failed
	// during a CreateStackSet or UpdateStackSet operation.
	//
	// * The stack was part of a
	// CreateStackSet or UpdateStackSet operation that failed or was stopped before the
	// stack was created or updated.
	//
	// * CURRENT: The stack is currently up to date with
	// the stack set.
	Status StackInstanceStatus

	// The explanation for the specific status code assigned to this stack instance.
	StatusReason *string

	noSmithyDocumentSerde
}

// The StackResource data type.
type StackResource struct {

	// The logical name of the resource specified in the template.
	//
	// This member is required.
	LogicalResourceId *string

	// Current status of the resource.
	//
	// This member is required.
	ResourceStatus ResourceStatus

	// Type of resource. (For more information, go to Amazon Web Services Resource
	// Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	//
	// This member is required.
	ResourceType *string

	// Time the status was updated.
	//
	// This member is required.
	Timestamp *time.Time

	// User defined description associated with the resource.
	Description *string

	// Information about whether the resource's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template and
	// any values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation

	// Contains information about the module from which the resource was created, if
	// the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo

	// The name or unique identifier that corresponds to a physical instance ID of a
	// resource supported by CloudFormation.
	PhysicalResourceId *string

	// Success/failure message associated with the resource.
	ResourceStatusReason *string

	// Unique identifier of the stack.
	StackId *string

	// The name associated with the stack.
	StackName *string

	noSmithyDocumentSerde
}

// Contains detailed information about the specified stack resource.
type StackResourceDetail struct {

	// Time the status was updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	// The logical name of the resource specified in the template.
	//
	// This member is required.
	LogicalResourceId *string

	// Current status of the resource.
	//
	// This member is required.
	ResourceStatus ResourceStatus

	// Type of resource. ((For more information, go to Amazon Web Services Resource
	// Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	//
	// This member is required.
	ResourceType *string

	// User defined description associated with the resource.
	Description *string

	// Information about whether the resource's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template and
	// any values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the CloudFormation User Guide.
	Metadata *string

	// Contains information about the module from which the resource was created, if
	// the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo

	// The name or unique identifier that corresponds to a physical instance ID of a
	// resource supported by CloudFormation.
	PhysicalResourceId *string

	// Success/failure message associated with the resource.
	ResourceStatusReason *string

	// Unique identifier of the stack.
	StackId *string

	// The name associated with the stack.
	StackName *string

	noSmithyDocumentSerde
}

// Contains the drift information for a resource that has been checked for drift.
// This includes actual and expected property values for resources in which
// CloudFormation has detected drift. Only resource properties explicitly defined
// in the stack template are checked for drift. For more information, see Detecting
// Unregulated Configuration Changes to Stacks and Resources
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
// Resources that do not currently support drift detection cannot be checked. For a
// list of resources that support drift detection, see Resources that Support Drift
// Detection
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
type StackResourceDrift struct {

	// The logical name of the resource specified in the template.
	//
	// This member is required.
	LogicalResourceId *string

	// The type of the resource.
	//
	// This member is required.
	ResourceType *string

	// The ID of the stack.
	//
	// This member is required.
	StackId *string

	// Status of the resource's actual configuration compared to its expected
	// configuration
	//
	// * DELETED: The resource differs from its expected template
	// configuration because the resource has been deleted.
	//
	// * MODIFIED: One or more
	// resource properties differ from their expected values (as defined in the stack
	// template and any values specified as template parameters).
	//
	// * IN_SYNC: The
	// resources's actual configuration matches its expected template configuration.
	//
	// *
	// NOT_CHECKED: CloudFormation does not currently return this value.
	//
	// This member is required.
	StackResourceDriftStatus StackResourceDriftStatus

	// Time at which CloudFormation performed drift detection on the stack resource.
	//
	// This member is required.
	Timestamp *time.Time

	// A JSON structure containing the actual property values of the stack resource.
	// For resources whose StackResourceDriftStatus is DELETED, this structure will not
	// be present.
	ActualProperties *string

	// A JSON structure containing the expected property values of the stack resource,
	// as defined in the stack template and any values specified as template
	// parameters. For resources whose StackResourceDriftStatus is DELETED, this
	// structure will not be present.
	ExpectedProperties *string

	// Contains information about the module from which the resource was created, if
	// the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo

	// The name or unique identifier that corresponds to a physical instance ID of a
	// resource supported by CloudFormation.
	PhysicalResourceId *string

	// Context information that enables CloudFormation to uniquely identify a resource.
	// CloudFormation uses context key-value pairs in cases where a resource's logical
	// and physical IDs are not enough to uniquely identify that resource. Each context
	// key-value pair specifies a unique resource that contains the targeted resource.
	PhysicalResourceIdContext []PhysicalResourceIdContextKeyValuePair

	// A collection of the resource properties whose actual values differ from their
	// expected values. These will be present only for resources whose
	// StackResourceDriftStatus is MODIFIED.
	PropertyDifferences []PropertyDifference

	noSmithyDocumentSerde
}

// Contains information about whether the resource's actual configuration differs,
// or has drifted, from its expected configuration.
type StackResourceDriftInformation struct {

	// Status of the resource's actual configuration compared to its expected
	// configuration
	//
	// * DELETED: The resource differs from its expected configuration
	// in that it has been deleted.
	//
	// * MODIFIED: The resource differs from its expected
	// configuration.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the resource
	// differs from its expected configuration. Any resources that do not currently
	// support drift detection have a status of NOT_CHECKED. For more information, see
	// Resources that Support Drift Detection
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	// *
	// IN_SYNC: The resources's actual configuration matches its expected
	// configuration.
	//
	// This member is required.
	StackResourceDriftStatus StackResourceDriftStatus

	// When CloudFormation last checked if the resource had drifted from its expected
	// configuration.
	LastCheckTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summarizes information about whether the resource's actual configuration
// differs, or has drifted, from its expected configuration.
type StackResourceDriftInformationSummary struct {

	// Status of the resource's actual configuration compared to its expected
	// configuration
	//
	// * DELETED: The resource differs from its expected configuration
	// in that it has been deleted.
	//
	// * MODIFIED: The resource differs from its expected
	// configuration.
	//
	// * NOT_CHECKED: CloudFormation has not checked if the resource
	// differs from its expected configuration. Any resources that do not currently
	// support drift detection have a status of NOT_CHECKED. For more information, see
	// Resources that Support Drift Detection
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	// If you performed an ContinueUpdateRollback operation on a stack, any resources
	// included in ResourcesToSkip will also have a status of NOT_CHECKED. For more
	// information on skipping resources during rollback operations, see Continue
	// Rolling Back an Update
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html)
	// in the CloudFormation User Guide.
	//
	// * IN_SYNC: The resources's actual
	// configuration matches its expected configuration.
	//
	// This member is required.
	StackResourceDriftStatus StackResourceDriftStatus

	// When CloudFormation last checked if the resource had drifted from its expected
	// configuration.
	LastCheckTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains high-level information about the specified stack resource.
type StackResourceSummary struct {

	// Time the status was updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	// The logical name of the resource specified in the template.
	//
	// This member is required.
	LogicalResourceId *string

	// Current status of the resource.
	//
	// This member is required.
	ResourceStatus ResourceStatus

	// Type of resource. (For more information, go to Amazon Web Services Resource
	// Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	//
	// This member is required.
	ResourceType *string

	// Information about whether the resource's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template and
	// any values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformationSummary

	// Contains information about the module from which the resource was created, if
	// the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo

	// The name or unique identifier that corresponds to a physical instance ID of the
	// resource.
	PhysicalResourceId *string

	// Success/failure message associated with the resource.
	ResourceStatusReason *string

	noSmithyDocumentSerde
}

// A structure that contains information about a stack set. A stack set enables you
// to provision stacks into Amazon Web Services accounts and across Regions by
// using a single CloudFormation template. In the stack set, you specify the
// template to use, as well as any parameters and capabilities that the template
// requires.
type StackSet struct {

	// The Amazon Resource Number (ARN) of the IAM role used to create or update the
	// stack set. Use customized administrator roles to control which users or groups
	// can manage specific stack sets within the same administrator account. For more
	// information, see Prerequisites: Granting Permissions for Stack Set Operations
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the CloudFormation User Guide.
	AdministrationRoleARN *string

	// [Service-managed permissions] Describes whether StackSets automatically deploys
	// to Organizations accounts that are added to a target organization or
	// organizational unit (OU).
	AutoDeployment *AutoDeployment

	// The capabilities that are allowed in the stack set. Some stack set templates
	// might include resources that can affect permissions in your Amazon Web Services
	// account—for example, by creating new Identity and Access Management (IAM) users.
	// For more information, see Acknowledging IAM Resources in CloudFormation
	// Templates.
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []Capability

	// A description of the stack set that you specify when the stack set is created or
	// updated.
	Description *string

	// The name of the IAM execution role used to create or update the stack set. Use
	// customized execution roles to control which stack resources users and groups can
	// include in their stack sets.
	ExecutionRoleName *string

	// [Service-managed permissions] The organization root ID or organizational unit
	// (OU) IDs that you specified for DeploymentTargets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitIds []string

	// A list of input parameters for a stack set.
	Parameters []Parameter

	// Describes how the IAM roles required for stack set operations are created.
	//
	// *
	// With self-managed permissions, you must create the administrator and execution
	// roles required to deploy to target accounts. For more information, see Grant
	// Self-Managed Stack Set Permissions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
	//
	// *
	// With service-managed permissions, StackSets automatically creates the IAM roles
	// required to deploy to accounts managed by Organizations. For more information,
	// see Grant Service-Managed Stack Set Permissions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
	PermissionModel PermissionModels

	// The Amazon Resource Number (ARN) of the stack set.
	StackSetARN *string

	// Detailed information about the drift status of the stack set. For stack sets,
	// contains information about the last completed drift operation performed on the
	// stack set. Information about drift operations currently in progress is not
	// included.
	StackSetDriftDetectionDetails *StackSetDriftDetectionDetails

	// The ID of the stack set.
	StackSetId *string

	// The name that's associated with the stack set.
	StackSetName *string

	// The status of the stack set.
	Status StackSetStatus

	// A list of tags that specify information about the stack set. A maximum number of
	// 50 tags can be specified.
	Tags []Tag

	// The structure that contains the body of the template that was used to create or
	// update the stack set.
	TemplateBody *string

	noSmithyDocumentSerde
}

// Detailed information about the drift status of the stack set. For stack sets,
// contains information about the last completed drift operation performed on the
// stack set. Information about drift operations in-progress is not included. For
// stack set operations, includes information about drift operations currently
// being performed on the stack set. For more information, see Detecting Unmanaged
// Changes in Stack Sets
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html)
// in the CloudFormation User Guide.
type StackSetDriftDetectionDetails struct {

	// The status of the stack set drift detection operation.
	//
	// * COMPLETED: The drift
	// detection operation completed without failing on any stack instances.
	//
	// * FAILED:
	// The drift detection operation exceeded the specified failure tolerance.
	//
	// *
	// PARTIAL_SUCCESS: The drift detection operation completed without exceeding the
	// failure tolerance for the operation.
	//
	// * IN_PROGRESS: The drift detection
	// operation is currently being performed.
	//
	// * STOPPED: The user has cancelled the
	// drift detection operation.
	DriftDetectionStatus StackSetDriftDetectionStatus

	// Status of the stack set's actual configuration compared to its expected template
	// and parameter configuration. A stack set is considered to have drifted if one or
	// more of its stack instances have drifted from their expected template and
	// parameter configuration.
	//
	// * DRIFTED: One or more of the stack instances
	// belonging to the stack set stack differs from the expected template and
	// parameter configuration. A stack instance is considered to have drifted if one
	// or more of the resources in the associated stack have drifted.
	//
	// * NOT_CHECKED:
	// CloudFormation has not checked the stack set for drift.
	//
	// * IN_SYNC: All of the
	// stack instances belonging to the stack set stack match from the expected
	// template and parameter configuration.
	DriftStatus StackSetDriftStatus

	// The number of stack instances that have drifted from the expected template and
	// parameter configuration of the stack set. A stack instance is considered to have
	// drifted if one or more of the resources in the associated stack do not match
	// their expected configuration.
	DriftedStackInstancesCount int32

	// The number of stack instances for which the drift detection operation failed.
	FailedStackInstancesCount int32

	// The number of stack instances that are currently being checked for drift.
	InProgressStackInstancesCount int32

	// The number of stack instances which match the expected template and parameter
	// configuration of the stack set.
	InSyncStackInstancesCount int32

	// Most recent time when CloudFormation performed a drift detection operation on
	// the stack set. This value will be NULL for any stack set on which drift
	// detection has not yet been performed.
	LastDriftCheckTimestamp *time.Time

	// The total number of stack instances belonging to this stack set. The total
	// number of stack instances is equal to the total of:
	//
	// * Stack instances that
	// match the stack set configuration.
	//
	// * Stack instances that have drifted from the
	// stack set configuration.
	//
	// * Stack instances where the drift detection operation
	// has failed.
	//
	// * Stack instances currently being checked for drift.
	TotalStackInstancesCount int32

	noSmithyDocumentSerde
}

// The structure that contains information about a stack set operation.
type StackSetOperation struct {

	// The type of stack set operation: CREATE, UPDATE, or DELETE. Create and delete
	// operations affect only the specified stack set instances that are associated
	// with the specified stack set. Update operations affect both the stack set
	// itself, as well as all associated stack set instances.
	Action StackSetOperationAction

	// The Amazon Resource Number (ARN) of the IAM role used to perform this stack set
	// operation. Use customized administrator roles to control which users or groups
	// can manage specific stack sets within the same administrator account. For more
	// information, see Define Permissions for Multiple Administrators
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the CloudFormation User Guide.
	AdministrationRoleARN *string

	// The time at which the operation was initiated. Note that the creation times for
	// the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested Regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time

	// [Service-managed permissions] The Organizations accounts affected by the stack
	// operation.
	DeploymentTargets *DeploymentTargets

	// The time at which the stack set operation ended, across all accounts and Regions
	// specified. Note that this doesn't necessarily mean that the stack set operation
	// was successful, or even attempted, in each account or Region.
	EndTimestamp *time.Time

	// The name of the IAM execution role used to create or update the stack set. Use
	// customized execution roles to control which stack resources users and groups can
	// include in their stack sets.
	ExecutionRoleName *string

	// The unique ID of a stack set operation.
	OperationId *string

	// The preferences for how CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences

	// For stack set operations of action type DELETE, specifies whether to remove the
	// stack instances from the specified stack set, but doesn't delete the stacks. You
	// can't reassociate a retained stack, or add an existing, saved stack to a new
	// stack set.
	RetainStacks *bool

	// Detailed information about the drift status of the stack set. This includes
	// information about drift operations currently being performed on the stack set.
	// this information will only be present for stack set operations whose Action type
	// is DETECT_DRIFT. For more information, see Detecting Unmanaged Changes in Stack
	// Sets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html)
	// in the CloudFormation User Guide.
	StackSetDriftDetectionDetails *StackSetDriftDetectionDetails

	// The ID of the stack set.
	StackSetId *string

	// The status of the operation.
	//
	// * FAILED: The operation exceeded the specified
	// failure tolerance. The failure tolerance value that you've set for an operation
	// is applied for each Region during stack create and update operations. If the
	// number of failed stacks within a Region exceeds the failure tolerance, the
	// status of the operation in the Region is set to FAILED. This in turn sets the
	// status of the operation as a whole to FAILED, and CloudFormation cancels the
	// operation in any remaining Regions.
	//
	// * QUEUED: [Service-managed permissions] For
	// automatic deployments that require a sequence of operations, the operation is
	// queued to be performed. For more information, see the stack set operation status
	// codes
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes)
	// in the CloudFormation User Guide.
	//
	// * RUNNING: The operation is currently being
	// performed.
	//
	// * STOPPED: The user has cancelled the operation.
	//
	// * STOPPING: The
	// operation is in the process of stopping, at user request.
	//
	// * SUCCEEDED: The
	// operation completed creating or updating all the specified stacks without
	// exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus

	noSmithyDocumentSerde
}

// The user-specified preferences for how CloudFormation performs a stack set
// operation. For more information on maximum concurrent accounts and failure
// tolerance, see Stack set operation options
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
type StackSetOperationPreferences struct {

	// The number of accounts, per Region, for which this operation can fail before
	// CloudFormation stops the operation in that Region. If the operation is stopped
	// in a Region, CloudFormation doesn't attempt the operation in any subsequent
	// Regions. Conditional: You must specify either FailureToleranceCount or
	// FailureTolerancePercentage (but not both). By default, 0 is specified.
	FailureToleranceCount *int32

	// The percentage of accounts, per Region, for which this stack operation can fail
	// before CloudFormation stops the operation in that Region. If the operation is
	// stopped in a Region, CloudFormation doesn't attempt the operation in any
	// subsequent Regions. When calculating the number of accounts based on the
	// specified percentage, CloudFormation rounds down to the next whole number.
	// Conditional: You must specify either FailureToleranceCount or
	// FailureTolerancePercentage, but not both. By default, 0 is specified.
	FailureTolerancePercentage *int32

	// The maximum number of accounts in which to perform this operation at one time.
	// This is dependent on the value of FailureToleranceCount. MaxConcurrentCount is
	// at most one more than the FailureToleranceCount. Note that this setting lets you
	// specify the maximum for operations. For large deployments, under certain
	// circumstances the actual number of accounts acted upon concurrently may be lower
	// due to service throttling. Conditional: You must specify either
	// MaxConcurrentCount or MaxConcurrentPercentage, but not both. By default, 1 is
	// specified.
	MaxConcurrentCount *int32

	// The maximum percentage of accounts in which to perform this operation at one
	// time. When calculating the number of accounts based on the specified percentage,
	// CloudFormation rounds down to the next whole number. This is true except in
	// cases where rounding down would result is zero. In this case, CloudFormation
	// sets the number as one instead. Note that this setting lets you specify the
	// maximum for operations. For large deployments, under certain circumstances the
	// actual number of accounts acted upon concurrently may be lower due to service
	// throttling. Conditional: You must specify either MaxConcurrentCount or
	// MaxConcurrentPercentage, but not both. By default, 1 is specified.
	MaxConcurrentPercentage *int32

	// The concurrency type of deploying StackSets operations in Regions, could be in
	// parallel or one Region at a time.
	RegionConcurrencyType RegionConcurrencyType

	// The order of the Regions in where you want to perform the stack operation.
	RegionOrder []string

	noSmithyDocumentSerde
}

// The structure that contains information about a specified operation's results
// for a given account in a given Region.
type StackSetOperationResultSummary struct {

	// [Self-managed permissions] The name of the Amazon Web Services account for this
	// operation result.
	Account *string

	// The results of the account gate function CloudFormation invokes, if present,
	// before proceeding with stack set operations in an account
	AccountGateResult *AccountGateResult

	// [Service-managed permissions] The organization root ID or organizational unit
	// (OU) IDs that you specified for DeploymentTargets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string

	// The name of the Amazon Web Services Region for this operation result.
	Region *string

	// The result status of the stack set operation for the given account in the given
	// Region.
	//
	// * CANCELLED: The operation in the specified account and Region has been
	// cancelled. This is either because a user has stopped the stack set operation, or
	// because the failure tolerance of the stack set operation has been exceeded.
	//
	// *
	// FAILED: The operation in the specified account and Region failed. If the stack
	// set operation fails in enough accounts within a Region, the failure tolerance
	// for the stack set operation as a whole might be exceeded.
	//
	// * RUNNING: The
	// operation in the specified account and Region is currently in progress.
	//
	// *
	// PENDING: The operation in the specified account and Region has yet to start.
	//
	// *
	// SUCCEEDED: The operation in the specified account and Region completed
	// successfully.
	Status StackSetOperationResultStatus

	// The reason for the assigned result status.
	StatusReason *string

	noSmithyDocumentSerde
}

// The structures that contain summary information about the specified operation.
type StackSetOperationSummary struct {

	// The type of operation: CREATE, UPDATE, or DELETE. Create and delete operations
	// affect only the specified stack instances that are associated with the specified
	// stack set. Update operations affect both the stack set itself as well as all
	// associated stack set instances.
	Action StackSetOperationAction

	// The time at which the operation was initiated. Note that the creation times for
	// the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested Regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time

	// The time at which the stack set operation ended, across all accounts and Regions
	// specified. Note that this doesn't necessarily mean that the stack set operation
	// was successful, or even attempted, in each account or Region.
	EndTimestamp *time.Time

	// The unique ID of the stack set operation.
	OperationId *string

	// The overall status of the operation.
	//
	// * FAILED: The operation exceeded the
	// specified failure tolerance. The failure tolerance value that you've set for an
	// operation is applied for each Region during stack create and update operations.
	// If the number of failed stacks within a Region exceeds the failure tolerance,
	// the status of the operation in the Region is set to FAILED. This in turn sets
	// the status of the operation as a whole to FAILED, and CloudFormation cancels the
	// operation in any remaining Regions.
	//
	// * QUEUED: [Service-managed permissions] For
	// automatic deployments that require a sequence of operations, the operation is
	// queued to be performed. For more information, see the stack set operation status
	// codes
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes)
	// in the CloudFormation User Guide.
	//
	// * RUNNING: The operation is currently being
	// performed.
	//
	// * STOPPED: The user has cancelled the operation.
	//
	// * STOPPING: The
	// operation is in the process of stopping, at user request.
	//
	// * SUCCEEDED: The
	// operation completed creating or updating all the specified stacks without
	// exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus

	noSmithyDocumentSerde
}

// The structures that contain summary information about the specified stack set.
type StackSetSummary struct {

	// [Service-managed permissions] Describes whether StackSets automatically deploys
	// to Organizations accounts that are added to a target organizational unit (OU).
	AutoDeployment *AutoDeployment

	// A description of the stack set that you specify when the stack set is created or
	// updated.
	Description *string

	// Status of the stack set's actual configuration compared to its expected template
	// and parameter configuration. A stack set is considered to have drifted if one or
	// more of its stack instances have drifted from their expected template and
	// parameter configuration.
	//
	// * DRIFTED: One or more of the stack instances
	// belonging to the stack set stack differs from the expected template and
	// parameter configuration. A stack instance is considered to have drifted if one
	// or more of the resources in the associated stack have drifted.
	//
	// * NOT_CHECKED:
	// CloudFormation has not checked the stack set for drift.
	//
	// * IN_SYNC: All of the
	// stack instances belonging to the stack set stack match from the expected
	// template and parameter configuration.
	//
	// * UNKNOWN: This value is reserved for
	// future use.
	DriftStatus StackDriftStatus

	// Most recent time when CloudFormation performed a drift detection operation on
	// the stack set. This value will be NULL for any stack set on which drift
	// detection has not yet been performed.
	LastDriftCheckTimestamp *time.Time

	// Describes how the IAM roles required for stack set operations are created.
	//
	// *
	// With self-managed permissions, you must create the administrator and execution
	// roles required to deploy to target accounts. For more information, see Grant
	// Self-Managed Stack Set Permissions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
	//
	// *
	// With service-managed permissions, StackSets automatically creates the IAM roles
	// required to deploy to accounts managed by Organizations. For more information,
	// see Grant Service-Managed Stack Set Permissions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
	PermissionModel PermissionModels

	// The ID of the stack set.
	StackSetId *string

	// The name of the stack set.
	StackSetName *string

	// The status of the stack set.
	Status StackSetStatus

	noSmithyDocumentSerde
}

// The StackSummary Data Type
type StackSummary struct {

	// The time the stack was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name associated with the stack.
	//
	// This member is required.
	StackName *string

	// The current status of the stack.
	//
	// This member is required.
	StackStatus StackStatus

	// The time the stack was deleted.
	DeletionTime *time.Time

	// Summarizes information on whether a stack's actual configuration differs, or has
	// drifted, from it's expected configuration, as defined in the stack template and
	// any values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformationSummary

	// The time the stack was last updated. This field will only be returned if the
	// stack has been updated at least once.
	LastUpdatedTime *time.Time

	// For nested stacks--stacks created as resources for another stack--the stack ID
	// of the direct parent of this stack. For the first level of nested stacks, the
	// root stack is also the parent stack. For more information, see Working with
	// Nested Stacks
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	ParentId *string

	// For nested stacks--stacks created as resources for another stack--the stack ID
	// of the top-level stack to which the nested stack ultimately belongs. For more
	// information, see Working with Nested Stacks
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	RootId *string

	// Unique stack identifier.
	StackId *string

	// Success/Failure message associated with the stack status.
	StackStatusReason *string

	// The template description of the template used to create the stack.
	TemplateDescription *string

	noSmithyDocumentSerde
}

// The Tag type enables you to specify a key-value pair that can be used to store
// information about an CloudFormation stack.
type Tag struct {

	// Required. A string used to identify this tag. You can specify a maximum of 128
	// characters for a tag key. Tags owned by Amazon Web Services (Amazon Web
	// Services) have the reserved prefix: aws:.
	//
	// This member is required.
	Key *string

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The TemplateParameter data type.
type TemplateParameter struct {

	// The default value associated with the parameter.
	DefaultValue *string

	// User defined description associated with the parameter.
	Description *string

	// Flag indicating whether the parameter should be displayed as plain text in logs
	// and UIs.
	NoEcho *bool

	// The name associated with the parameter.
	ParameterKey *string

	noSmithyDocumentSerde
}

// Detailed information concerning the specification of a CloudFormation extension
// in a given account and region. For more information, see Configuring extensions
// at the account level
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration)
// in the CloudFormation User Guide.
type TypeConfigurationDetails struct {

	// The alias specified for this configuration, if one was specified when the
	// configuration was set.
	Alias *string

	// The Amazon Resource Name (ARN) for the configuration data, in this account and
	// region.
	Arn *string

	// A JSON string specifying the configuration data for the extension, in this
	// account and region. If a configuration has not been set for a specified
	// extension, CloudFormation returns {}.
	Configuration *string

	// Whether or not this configuration data is the default configuration for the
	// extension.
	IsDefaultConfiguration *bool

	// When the configuration data was last updated for this extension. If a
	// configuration has not been set for a specified extension, CloudFormation returns
	// null.
	LastUpdated *time.Time

	// The Amazon Resource Name (ARN) for the extension, in this account and region.
	// For public extensions, this will be the ARN assigned when you activate the type
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// in this account and region. For private extensions, this will be the ARN
	// assigned when you register the type
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
	// in this account and region.
	TypeArn *string

	// The name of the extension.
	TypeName *string

	noSmithyDocumentSerde
}

// Identifying information for the configuration of a CloudFormation extension.
type TypeConfigurationIdentifier struct {

	// The type of extension.
	Type ThirdPartyType

	// The Amazon Resource Name (ARN) for the extension, in this account and region.
	// For public extensions, this will be the ARN assigned when you activate the type
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// in this account and region. For private extensions, this will be the ARN
	// assigned when you register the type
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
	// in this account and region.
	TypeArn *string

	// The alias specified for this configuration, if one was specified when the
	// configuration was set.
	TypeConfigurationAlias *string

	// The Amazon Resource Name (ARN) for the configuration, in this account and
	// region.
	TypeConfigurationArn *string

	// The name of the extension type to which this configuration applies.
	TypeName *string

	noSmithyDocumentSerde
}

// Filter criteria to use in determining which extensions to return.
type TypeFilters struct {

	// The category of extensions to return.
	//
	// * REGISTERED: Private extensions that
	// have been registered for this account and region.
	//
	// * ACTIVATED: Public
	// extensions that have been activated for this account and region.
	//
	// * THIRD-PARTY:
	// Extensions available for use from publishers other than Amazon. This
	// includes:
	//
	// * Private extensions registered in the account.
	//
	// * Public extensions
	// from publishers other than Amazon, whether activated or not.
	//
	// * AWS-TYPES:
	// Extensions available for use from Amazon.
	Category Category

	// The id of the publisher of the extension. Extensions published by Amazon are not
	// assigned a publisher ID. Use the AWS-TYPES category to specify a list of types
	// published by Amazon.
	PublisherId *string

	// A prefix to use as a filter for results.
	TypeNamePrefix *string

	noSmithyDocumentSerde
}

// Contains summary information about the specified CloudFormation extension.
type TypeSummary struct {

	// The ID of the default version of the extension. The default version is used when
	// the extension version is not specified. This applies only to private extensions
	// you have registered in your account. For public extensions, both those provided
	// by Amazon and published by third parties, CloudFormation returns null. For more
	// information, see RegisterType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	// To set the default version of an extension, use SetTypeDefaultVersion.
	DefaultVersionId *string

	// The description of the extension.
	Description *string

	// Whether or not the extension is activated for this account and region. This
	// applies only to third-party public extensions. Extensions published by Amazon
	// are activated by default.
	IsActivated *bool

	// When the specified extension version was registered. This applies only to:
	//
	// *
	// Private extensions you have registered in your account. For more information,
	// see RegisterType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	// *
	// Public extensions you have activated in your account with auto-update specified.
	// For more information, see ActivateType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
	//
	// For
	// all other extension types, CloudFormation returns null.
	LastUpdated *time.Time

	// For public extensions that have been activated for this account and region, the
	// latest version of the public extension that is available. For any extensions
	// other than activated third-arty extensions, CloudFormation returns null. How you
	// specified AutoUpdate when enabling the extension affects whether CloudFormation
	// automatically updates the extention in this account and region when a new
	// version is released. For more information, see Setting CloudFormation to
	// automatically use new versions of extensions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	LatestPublicVersion *string

	// For public extensions that have been activated for this account and region, the
	// type name of the public extension. If you specified a TypeNameAlias when
	// enabling the extension in this account and region, CloudFormation treats that
	// alias as the extension's type name within the account and region, not the type
	// name of the public extension. For more information, see Specifying aliases to
	// refer to extensions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias)
	// in the CloudFormation User Guide.
	OriginalTypeName *string

	// For public extensions that have been activated for this account and region, the
	// version of the public extension to be used for CloudFormation operations in this
	// account and region. How you specified AutoUpdate when enabling the extension
	// affects whether CloudFormation automatically updates the extention in this
	// account and region when a new version is released. For more information, see
	// Setting CloudFormation to automatically use new versions of extensions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	PublicVersionNumber *string

	// The ID of the extension publisher, if the extension is published by a third
	// party. Extensions published by Amazon do not return a publisher ID.
	PublisherId *string

	// The service used to verify the publisher identity. For more information, see
	// Registering your account to publish CloudFormation extensions
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html)
	// in the CFN-CLI User Guide for Extension Development.
	PublisherIdentity IdentityProvider

	// The publisher name, as defined in the public profile for that publisher in the
	// service used to verify the publisher identity.
	PublisherName *string

	// The kind of extension.
	Type RegistryType

	// The Amazon Resource Name (ARN) of the extension.
	TypeArn *string

	// The name of the extension. If you specified a TypeNameAlias when you activate
	// this extension
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// in your account and region, CloudFormation considers that alias as the type
	// name.
	TypeName *string

	noSmithyDocumentSerde
}

// Contains summary information about a specific version of a CloudFormation
// extension.
type TypeVersionSummary struct {

	// The Amazon Resource Name (ARN) of the extension version.
	Arn *string

	// The description of the extension version.
	Description *string

	// Whether the specified extension version is set as the default version. This
	// applies only to private extensions you have registered in your account, and
	// extensions published by Amazon. For public third-party extensions, whether or
	// not they are activated in your account, CloudFormation returns null.
	IsDefaultVersion *bool

	// For public extensions that have been activated for this account and region, the
	// version of the public extension to be used for CloudFormation operations in this
	// account and region. For any extensions other than activated third-arty
	// extensions, CloudFormation returns null. How you specified AutoUpdate when
	// enabling the extension affects whether CloudFormation automatically updates the
	// extention in this account and region when a new version is released. For more
	// information, see Setting CloudFormation to automatically use new versions of
	// extensions
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	PublicVersionNumber *string

	// When the version was registered.
	TimeCreated *time.Time

	// The kind of extension.
	Type RegistryType

	// The name of the extension.
	TypeName *string

	// The ID of a specific version of the extension. The version ID is the value at
	// the end of the Amazon Resource Name (ARN) assigned to the extension version when
	// it is registered.
	VersionId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
