// Code generated by smithy-go-codegen DO NOT EDIT.

package clouddirectory

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the major version families of each managed schema. If a major version ARN
// is provided as SchemaArn, the minor version revisions in that family are listed
// instead.
func (c *Client) ListManagedSchemaArns(ctx context.Context, params *ListManagedSchemaArnsInput, optFns ...func(*Options)) (*ListManagedSchemaArnsOutput, error) {
	if params == nil {
		params = &ListManagedSchemaArnsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedSchemaArns", params, optFns, c.addOperationListManagedSchemaArnsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedSchemaArnsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedSchemaArnsInput struct {

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// The response for ListManagedSchemaArns. When this parameter is used, all minor
	// version ARNs for a major version are listed.
	SchemaArn *string

	noSmithyDocumentSerde
}

type ListManagedSchemaArnsOutput struct {

	// The pagination token.
	NextToken *string

	// The ARNs for all AWS managed schemas.
	SchemaArns []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedSchemaArnsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedSchemaArns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedSchemaArns{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedSchemaArns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListManagedSchemaArnsAPIClient is a client that implements the
// ListManagedSchemaArns operation.
type ListManagedSchemaArnsAPIClient interface {
	ListManagedSchemaArns(context.Context, *ListManagedSchemaArnsInput, ...func(*Options)) (*ListManagedSchemaArnsOutput, error)
}

var _ ListManagedSchemaArnsAPIClient = (*Client)(nil)

// ListManagedSchemaArnsPaginatorOptions is the paginator options for
// ListManagedSchemaArns
type ListManagedSchemaArnsPaginatorOptions struct {
	// The maximum number of results to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedSchemaArnsPaginator is a paginator for ListManagedSchemaArns
type ListManagedSchemaArnsPaginator struct {
	options   ListManagedSchemaArnsPaginatorOptions
	client    ListManagedSchemaArnsAPIClient
	params    *ListManagedSchemaArnsInput
	nextToken *string
	firstPage bool
}

// NewListManagedSchemaArnsPaginator returns a new ListManagedSchemaArnsPaginator
func NewListManagedSchemaArnsPaginator(client ListManagedSchemaArnsAPIClient, params *ListManagedSchemaArnsInput, optFns ...func(*ListManagedSchemaArnsPaginatorOptions)) *ListManagedSchemaArnsPaginator {
	if params == nil {
		params = &ListManagedSchemaArnsInput{}
	}

	options := ListManagedSchemaArnsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedSchemaArnsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedSchemaArnsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListManagedSchemaArns page.
func (p *ListManagedSchemaArnsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedSchemaArnsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListManagedSchemaArns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListManagedSchemaArns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "clouddirectory",
		OperationName: "ListManagedSchemaArns",
	}
}
