// Code generated by smithy-go-codegen DO NOT EDIT.

package clouddirectory

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists schema major versions applied to a directory. If SchemaArn is provided,
// lists the minor version.
func (c *Client) ListAppliedSchemaArns(ctx context.Context, params *ListAppliedSchemaArnsInput, optFns ...func(*Options)) (*ListAppliedSchemaArnsOutput, error) {
	if params == nil {
		params = &ListAppliedSchemaArnsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAppliedSchemaArns", params, optFns, c.addOperationListAppliedSchemaArnsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAppliedSchemaArnsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAppliedSchemaArnsInput struct {

	// The ARN of the directory you are listing.
	//
	// This member is required.
	DirectoryArn *string

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// The response for ListAppliedSchemaArns when this parameter is used will list all
	// minor version ARNs for a major version.
	SchemaArn *string

	noSmithyDocumentSerde
}

type ListAppliedSchemaArnsOutput struct {

	// The pagination token.
	NextToken *string

	// The ARNs of schemas that are applied to the directory.
	SchemaArns []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAppliedSchemaArnsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAppliedSchemaArns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAppliedSchemaArns{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAppliedSchemaArnsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAppliedSchemaArns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAppliedSchemaArnsAPIClient is a client that implements the
// ListAppliedSchemaArns operation.
type ListAppliedSchemaArnsAPIClient interface {
	ListAppliedSchemaArns(context.Context, *ListAppliedSchemaArnsInput, ...func(*Options)) (*ListAppliedSchemaArnsOutput, error)
}

var _ ListAppliedSchemaArnsAPIClient = (*Client)(nil)

// ListAppliedSchemaArnsPaginatorOptions is the paginator options for
// ListAppliedSchemaArns
type ListAppliedSchemaArnsPaginatorOptions struct {
	// The maximum number of results to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAppliedSchemaArnsPaginator is a paginator for ListAppliedSchemaArns
type ListAppliedSchemaArnsPaginator struct {
	options   ListAppliedSchemaArnsPaginatorOptions
	client    ListAppliedSchemaArnsAPIClient
	params    *ListAppliedSchemaArnsInput
	nextToken *string
	firstPage bool
}

// NewListAppliedSchemaArnsPaginator returns a new ListAppliedSchemaArnsPaginator
func NewListAppliedSchemaArnsPaginator(client ListAppliedSchemaArnsAPIClient, params *ListAppliedSchemaArnsInput, optFns ...func(*ListAppliedSchemaArnsPaginatorOptions)) *ListAppliedSchemaArnsPaginator {
	if params == nil {
		params = &ListAppliedSchemaArnsInput{}
	}

	options := ListAppliedSchemaArnsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAppliedSchemaArnsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAppliedSchemaArnsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListAppliedSchemaArns page.
func (p *ListAppliedSchemaArnsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAppliedSchemaArnsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAppliedSchemaArns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAppliedSchemaArns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "clouddirectory",
		OperationName: "ListAppliedSchemaArns",
	}
}
