// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmessaging

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchCreateChannelMembership struct {
}

func (*awsRestjson1_serializeOpBatchCreateChannelMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchCreateChannelMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreateChannelMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/memberships?operation=batch-create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchCreateChannelMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchCreateChannelMembershipInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchCreateChannelMembershipInput(v *BatchCreateChannelMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchCreateChannelMembershipInput(v *BatchCreateChannelMembershipInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MemberArns != nil {
		ok := object.Key("MemberArns")
		if err := awsRestjson1_serializeDocumentMemberArns(v.MemberArns, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannel struct {
}

func (*awsRestjson1_serializeOpCreateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelInput(v *CreateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelInput(v *CreateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppInstanceArn != nil {
		ok := object.Key("AppInstanceArn")
		ok.String(*v.AppInstanceArn)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Privacy) > 0 {
		ok := object.Key("Privacy")
		ok.String(string(v.Privacy))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannelBan struct {
}

func (*awsRestjson1_serializeOpCreateChannelBan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannelBan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelBanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/bans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelBanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelBanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelBanInput(v *CreateChannelBanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelBanInput(v *CreateChannelBanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MemberArn != nil {
		ok := object.Key("MemberArn")
		ok.String(*v.MemberArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannelMembership struct {
}

func (*awsRestjson1_serializeOpCreateChannelMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannelMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/memberships")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelMembershipInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelMembershipInput(v *CreateChannelMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelMembershipInput(v *CreateChannelMembershipInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MemberArn != nil {
		ok := object.Key("MemberArn")
		ok.String(*v.MemberArn)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannelModerator struct {
}

func (*awsRestjson1_serializeOpCreateChannelModerator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannelModerator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelModeratorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/moderators")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelModeratorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelModeratorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelModeratorInput(v *CreateChannelModeratorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelModeratorInput(v *CreateChannelModeratorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelModeratorArn != nil {
		ok := object.Key("ChannelModeratorArn")
		ok.String(*v.ChannelModeratorArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannel struct {
}

func (*awsRestjson1_serializeOpDeleteChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(v *DeleteChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelBan struct {
}

func (*awsRestjson1_serializeOpDeleteChannelBan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelBan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelBanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/bans/{MemberArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelBanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelBanInput(v *DeleteChannelBanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MemberArn == nil || len(*v.MemberArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberArn must not be empty")}
	}
	if v.MemberArn != nil {
		if err := encoder.SetURI("MemberArn").String(*v.MemberArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelMembership struct {
}

func (*awsRestjson1_serializeOpDeleteChannelMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/memberships/{MemberArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelMembershipInput(v *DeleteChannelMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MemberArn == nil || len(*v.MemberArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberArn must not be empty")}
	}
	if v.MemberArn != nil {
		if err := encoder.SetURI("MemberArn").String(*v.MemberArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelMessage struct {
}

func (*awsRestjson1_serializeOpDeleteChannelMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages/{MessageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelMessageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelMessageInput(v *DeleteChannelMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MessageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("MessageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelModerator struct {
}

func (*awsRestjson1_serializeOpDeleteChannelModerator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelModerator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelModeratorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/moderators/{ChannelModeratorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelModeratorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelModeratorInput(v *DeleteChannelModeratorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChannelModeratorArn == nil || len(*v.ChannelModeratorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelModeratorArn must not be empty")}
	}
	if v.ChannelModeratorArn != nil {
		if err := encoder.SetURI("ChannelModeratorArn").String(*v.ChannelModeratorArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannel struct {
}

func (*awsRestjson1_serializeOpDescribeChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(v *DescribeChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannelBan struct {
}

func (*awsRestjson1_serializeOpDescribeChannelBan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannelBan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelBanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/bans/{MemberArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelBanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelBanInput(v *DescribeChannelBanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MemberArn == nil || len(*v.MemberArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberArn must not be empty")}
	}
	if v.MemberArn != nil {
		if err := encoder.SetURI("MemberArn").String(*v.MemberArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannelMembership struct {
}

func (*awsRestjson1_serializeOpDescribeChannelMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannelMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/memberships/{MemberArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelMembershipInput(v *DescribeChannelMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MemberArn == nil || len(*v.MemberArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberArn must not be empty")}
	}
	if v.MemberArn != nil {
		if err := encoder.SetURI("MemberArn").String(*v.MemberArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannelMembershipForAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpDescribeChannelMembershipForAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannelMembershipForAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelMembershipForAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}?scope=app-instance-user-membership")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelMembershipForAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelMembershipForAppInstanceUserInput(v *DescribeChannelMembershipForAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn != nil {
		encoder.SetQuery("app-instance-user-arn").String(*v.AppInstanceUserArn)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannelModeratedByAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpDescribeChannelModeratedByAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannelModeratedByAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelModeratedByAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}?scope=app-instance-user-moderated-channel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelModeratedByAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelModeratedByAppInstanceUserInput(v *DescribeChannelModeratedByAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn != nil {
		encoder.SetQuery("app-instance-user-arn").String(*v.AppInstanceUserArn)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannelModerator struct {
}

func (*awsRestjson1_serializeOpDescribeChannelModerator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannelModerator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelModeratorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/moderators/{ChannelModeratorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelModeratorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelModeratorInput(v *DescribeChannelModeratorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChannelModeratorArn == nil || len(*v.ChannelModeratorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelModeratorArn must not be empty")}
	}
	if v.ChannelModeratorArn != nil {
		if err := encoder.SetURI("ChannelModeratorArn").String(*v.ChannelModeratorArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

type awsRestjson1_serializeOpGetChannelMessage struct {
}

func (*awsRestjson1_serializeOpGetChannelMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannelMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages/{MessageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelMessageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelMessageInput(v *GetChannelMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MessageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("MessageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMessagingSessionEndpoint struct {
}

func (*awsRestjson1_serializeOpGetMessagingSessionEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMessagingSessionEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMessagingSessionEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/endpoints/messaging-session")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMessagingSessionEndpointInput(v *GetMessagingSessionEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListChannelBans struct {
}

func (*awsRestjson1_serializeOpListChannelBans) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelBans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelBansInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/bans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelBansInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelBansInput(v *ListChannelBansInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListChannelMemberships struct {
}

func (*awsRestjson1_serializeOpListChannelMemberships) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelMemberships) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelMembershipsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/memberships")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelMembershipsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelMembershipsInput(v *ListChannelMembershipsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("type").String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpListChannelMembershipsForAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpListChannelMembershipsForAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelMembershipsForAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelMembershipsForAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels?scope=app-instance-user-memberships")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelMembershipsForAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelMembershipsForAppInstanceUserInput(v *ListChannelMembershipsForAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn != nil {
		encoder.SetQuery("app-instance-user-arn").String(*v.AppInstanceUserArn)
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListChannelMessages struct {
}

func (*awsRestjson1_serializeOpListChannelMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelMessagesInput(v *ListChannelMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.NotAfter != nil {
		encoder.SetQuery("not-after").String(smithytime.FormatDateTime(*v.NotAfter))
	}

	if v.NotBefore != nil {
		encoder.SetQuery("not-before").String(smithytime.FormatDateTime(*v.NotBefore))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sort-order").String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListChannelModerators struct {
}

func (*awsRestjson1_serializeOpListChannelModerators) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelModerators) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelModeratorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/moderators")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelModeratorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelModeratorsInput(v *ListChannelModeratorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListChannels struct {
}

func (*awsRestjson1_serializeOpListChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsInput(v *ListChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn != nil {
		encoder.SetQuery("app-instance-arn").String(*v.AppInstanceArn)
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if len(v.Privacy) > 0 {
		encoder.SetQuery("privacy").String(string(v.Privacy))
	}

	return nil
}

type awsRestjson1_serializeOpListChannelsModeratedByAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpListChannelsModeratedByAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannelsModeratedByAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsModeratedByAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels?scope=app-instance-user-moderated-channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsModeratedByAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsModeratedByAppInstanceUserInput(v *ListChannelsModeratedByAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn != nil {
		encoder.SetQuery("app-instance-user-arn").String(*v.AppInstanceUserArn)
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpRedactChannelMessage struct {
}

func (*awsRestjson1_serializeOpRedactChannelMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRedactChannelMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RedactChannelMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages/{MessageId}?operation=redact")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRedactChannelMessageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRedactChannelMessageInput(v *RedactChannelMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MessageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("MessageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSendChannelMessage struct {
}

func (*awsRestjson1_serializeOpSendChannelMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendChannelMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendChannelMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSendChannelMessageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSendChannelMessageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendChannelMessageInput(v *SendChannelMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSendChannelMessageInput(v *SendChannelMessageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if len(v.Persistence) > 0 {
		ok := object.Key("Persistence")
		ok.String(string(v.Persistence))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannel struct {
}

func (*awsRestjson1_serializeOpUpdateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(v *UpdateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelInput(v *UpdateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannelMessage struct {
}

func (*awsRestjson1_serializeOpUpdateChannelMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannelMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/messages/{MessageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelMessageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelMessageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelMessageInput(v *UpdateChannelMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MessageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("MessageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelMessageInput(v *UpdateChannelMessageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannelReadMarker struct {
}

func (*awsRestjson1_serializeOpUpdateChannelReadMarker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannelReadMarker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelReadMarkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{ChannelArn}/readMarker")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelReadMarkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelReadMarkerInput(v *UpdateChannelReadMarkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelArn == nil || len(*v.ChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelArn must not be empty")}
	}
	if v.ChannelArn != nil {
		if err := encoder.SetURI("ChannelArn").String(*v.ChannelArn); err != nil {
			return err
		}
	}

	if v.ChimeBearer != nil && len(*v.ChimeBearer) > 0 {
		locationName := "X-Amz-Chime-Bearer"
		encoder.SetHeader(locationName).String(*v.ChimeBearer)
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
