// Code generated by smithy-go-codegen DO NOT EDIT.

package athena

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/athena/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the metadata for the tables in the specified data catalog database.
func (c *Client) ListTableMetadata(ctx context.Context, params *ListTableMetadataInput, optFns ...func(*Options)) (*ListTableMetadataOutput, error) {
	if params == nil {
		params = &ListTableMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTableMetadata", params, optFns, c.addOperationListTableMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTableMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTableMetadataInput struct {

	// The name of the data catalog for which table metadata should be returned.
	//
	// This member is required.
	CatalogName *string

	// The name of the database for which table metadata should be returned.
	//
	// This member is required.
	DatabaseName *string

	// A regex filter that pattern-matches table names. If no expression is supplied,
	// metadata for all tables are listed.
	Expression *string

	// Specifies the maximum number of results to return.
	MaxResults *int32

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of pages,
	// pass in the NextToken from the response object of the previous page call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTableMetadataOutput struct {

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of pages,
	// pass in the NextToken from the response object of the previous page call.
	NextToken *string

	// A list of table metadata.
	TableMetadataList []types.TableMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTableMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListTableMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTableMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTableMetadataAPIClient is a client that implements the ListTableMetadata
// operation.
type ListTableMetadataAPIClient interface {
	ListTableMetadata(context.Context, *ListTableMetadataInput, ...func(*Options)) (*ListTableMetadataOutput, error)
}

var _ ListTableMetadataAPIClient = (*Client)(nil)

// ListTableMetadataPaginatorOptions is the paginator options for ListTableMetadata
type ListTableMetadataPaginatorOptions struct {
	// Specifies the maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTableMetadataPaginator is a paginator for ListTableMetadata
type ListTableMetadataPaginator struct {
	options   ListTableMetadataPaginatorOptions
	client    ListTableMetadataAPIClient
	params    *ListTableMetadataInput
	nextToken *string
	firstPage bool
}

// NewListTableMetadataPaginator returns a new ListTableMetadataPaginator
func NewListTableMetadataPaginator(client ListTableMetadataAPIClient, params *ListTableMetadataInput, optFns ...func(*ListTableMetadataPaginatorOptions)) *ListTableMetadataPaginator {
	if params == nil {
		params = &ListTableMetadataInput{}
	}

	options := ListTableMetadataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTableMetadataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTableMetadataPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListTableMetadata page.
func (p *ListTableMetadataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTableMetadataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListTableMetadata(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTableMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "athena",
		OperationName: "ListTableMetadata",
	}
}
