// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists rule groups namespaces.
func (c *Client) ListRuleGroupsNamespaces(ctx context.Context, params *ListRuleGroupsNamespacesInput, optFns ...func(*Options)) (*ListRuleGroupsNamespacesOutput, error) {
	if params == nil {
		params = &ListRuleGroupsNamespacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRuleGroupsNamespaces", params, optFns, c.addOperationListRuleGroupsNamespacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRuleGroupsNamespacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a ListRuleGroupsNamespaces operation.
type ListRuleGroupsNamespacesInput struct {

	// The ID of the workspace.
	//
	// This member is required.
	WorkspaceId *string

	// Maximum results to return in response (default=100, maximum=1000).
	MaxResults *int32

	// Optional filter for rule groups namespace name. Only the rule groups namespace
	// that begin with this value will be returned.
	Name *string

	// Pagination token to request the next page in a paginated list. This token is
	// obtained from the output of the previous ListRuleGroupsNamespaces request.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListRuleGroupsNamespaces operation.
type ListRuleGroupsNamespacesOutput struct {

	// The list of the selected rule groups namespaces.
	//
	// This member is required.
	RuleGroupsNamespaces []types.RuleGroupsNamespaceSummary

	// Pagination token to use when requesting the next page in this list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRuleGroupsNamespacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRuleGroupsNamespaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRuleGroupsNamespaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListRuleGroupsNamespacesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRuleGroupsNamespaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRuleGroupsNamespacesAPIClient is a client that implements the
// ListRuleGroupsNamespaces operation.
type ListRuleGroupsNamespacesAPIClient interface {
	ListRuleGroupsNamespaces(context.Context, *ListRuleGroupsNamespacesInput, ...func(*Options)) (*ListRuleGroupsNamespacesOutput, error)
}

var _ ListRuleGroupsNamespacesAPIClient = (*Client)(nil)

// ListRuleGroupsNamespacesPaginatorOptions is the paginator options for
// ListRuleGroupsNamespaces
type ListRuleGroupsNamespacesPaginatorOptions struct {
	// Maximum results to return in response (default=100, maximum=1000).
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRuleGroupsNamespacesPaginator is a paginator for ListRuleGroupsNamespaces
type ListRuleGroupsNamespacesPaginator struct {
	options   ListRuleGroupsNamespacesPaginatorOptions
	client    ListRuleGroupsNamespacesAPIClient
	params    *ListRuleGroupsNamespacesInput
	nextToken *string
	firstPage bool
}

// NewListRuleGroupsNamespacesPaginator returns a new
// ListRuleGroupsNamespacesPaginator
func NewListRuleGroupsNamespacesPaginator(client ListRuleGroupsNamespacesAPIClient, params *ListRuleGroupsNamespacesInput, optFns ...func(*ListRuleGroupsNamespacesPaginatorOptions)) *ListRuleGroupsNamespacesPaginator {
	if params == nil {
		params = &ListRuleGroupsNamespacesInput{}
	}

	options := ListRuleGroupsNamespacesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRuleGroupsNamespacesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRuleGroupsNamespacesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListRuleGroupsNamespaces page.
func (p *ListRuleGroupsNamespacesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRuleGroupsNamespacesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListRuleGroupsNamespaces(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListRuleGroupsNamespaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "aps",
		OperationName: "ListRuleGroupsNamespaces",
	}
}
