// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an access preview.
type AccessPreview struct {

	// The ARN of the analyzer used to generate the access preview.
	//
	// This member is required.
	AnalyzerArn *string

	// A map of resource ARNs for the proposed resource configuration.
	//
	// This member is required.
	Configurations map[string]Configuration

	// The time at which the access preview was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique ID for the access preview.
	//
	// This member is required.
	Id *string

	// The status of the access preview.
	//
	// * Creating - The access preview creation is
	// in progress.
	//
	// * Completed - The access preview is complete. You can preview
	// findings for external access to the resource.
	//
	// * Failed - The access preview
	// creation has failed.
	//
	// This member is required.
	Status AccessPreviewStatus

	// Provides more details about the current status of the access preview. For
	// example, if the creation of the access preview fails, a Failed status is
	// returned. This failure can be due to an internal issue with the analysis or due
	// to an invalid resource configuration.
	StatusReason *AccessPreviewStatusReason

	noSmithyDocumentSerde
}

// An access preview finding generated by the access preview.
type AccessPreviewFinding struct {

	// Provides context on how the access preview finding compares to existing access
	// identified in IAM Access Analyzer.
	//
	// * New - The finding is for newly-introduced
	// access.
	//
	// * Unchanged - The preview finding is an existing finding that would
	// remain unchanged.
	//
	// * Changed - The preview finding is an existing finding with a
	// change in status.
	//
	// For example, a Changed finding with preview status Resolved
	// and existing status Active indicates the existing Active finding would become
	// Resolved as a result of the proposed permissions change.
	//
	// This member is required.
	ChangeType FindingChangeType

	// The time at which the access preview finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the access preview finding. This ID uniquely identifies the element in
	// the list of access preview findings and is not related to the finding ID in
	// Access Analyzer.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource. For most Amazon Web
	// Services resources, the owning account is the account in which the resource was
	// created.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that can be accessed in the finding.
	//
	// This member is required.
	ResourceType ResourceType

	// The preview status of the finding. This is what the status of the finding would
	// be after permissions deployment. For example, a Changed finding with preview
	// status Resolved and existing status Active indicates the existing Active finding
	// would become Resolved as a result of the proposed permissions change.
	//
	// This member is required.
	Status FindingStatus

	// The action in the analyzed policy statement that an external principal has
	// permission to perform.
	Action []string

	// The condition in the analyzed policy statement that resulted in a finding.
	Condition map[string]string

	// An error.
	Error *string

	// The existing ID of the finding in IAM Access Analyzer, provided only for
	// existing findings.
	ExistingFindingId *string

	// The existing status of the finding, provided only for existing findings.
	ExistingFindingStatus FindingStatus

	// Indicates whether the policy that generated the finding allows public access to
	// the resource.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that an external principal has access to. This is the resource
	// associated with the access preview.
	Resource *string

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Provides more details about the current status of the access preview. For
// example, if the creation of the access preview fails, a Failed status is
// returned. This failure can be due to an internal issue with the analysis or due
// to an invalid proposed resource configuration.
type AccessPreviewStatusReason struct {

	// The reason code for the current status of the access preview.
	//
	// This member is required.
	Code AccessPreviewStatusReasonCode

	noSmithyDocumentSerde
}

// Contains a summary of information about an access preview.
type AccessPreviewSummary struct {

	// The ARN of the analyzer used to generate the access preview.
	//
	// This member is required.
	AnalyzerArn *string

	// The time at which the access preview was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique ID for the access preview.
	//
	// This member is required.
	Id *string

	// The status of the access preview.
	//
	// * Creating - The access preview creation is
	// in progress.
	//
	// * Completed - The access preview is complete and previews the
	// findings for external access to the resource.
	//
	// * Failed - The access preview
	// creation has failed.
	//
	// This member is required.
	Status AccessPreviewStatus

	// Provides more details about the current status of the access preview. For
	// example, if the creation of the access preview fails, a Failed status is
	// returned. This failure can be due to an internal issue with the analysis or due
	// to an invalid proposed resource configuration.
	StatusReason *AccessPreviewStatusReason

	noSmithyDocumentSerde
}

// You specify each grantee as a type-value pair using one of these types. You can
// specify only one type of grantee. For more information, see PutBucketAcl
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html).
//
// The following types satisfy this interface:
//  AclGranteeMemberId
//  AclGranteeMemberUri
type AclGrantee interface {
	isAclGrantee()
}

// The value specified is the canonical user ID of an Amazon Web Services account.
type AclGranteeMemberId struct {
	Value string

	noSmithyDocumentSerde
}

func (*AclGranteeMemberId) isAclGrantee() {}

// Used for granting permissions to a predefined group.
type AclGranteeMemberUri struct {
	Value string

	noSmithyDocumentSerde
}

func (*AclGranteeMemberUri) isAclGrantee() {}

// Contains details about the analyzed resource.
type AnalyzedResource struct {

	// The time at which the resource was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Indicates whether the policy that generated the finding grants public access to
	// the resource.
	//
	// This member is required.
	IsPublic *bool

	// The ARN of the resource that was analyzed.
	//
	// This member is required.
	ResourceArn *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that was analyzed.
	//
	// This member is required.
	ResourceType ResourceType

	// The time at which the finding was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The actions that an external principal is granted permission to use by the
	// policy that generated the finding.
	Actions []string

	// An error message.
	Error *string

	// Indicates how the access that generated the finding is granted. This is
	// populated for Amazon S3 bucket findings.
	SharedVia []string

	// The current status of the finding generated from the analyzed resource.
	Status FindingStatus

	noSmithyDocumentSerde
}

// Contains the ARN of the analyzed resource.
type AnalyzedResourceSummary struct {

	// The ARN of the analyzed resource.
	//
	// This member is required.
	ResourceArn *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of resource that was analyzed.
	//
	// This member is required.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Contains information about the analyzer.
type AnalyzerSummary struct {

	// The ARN of the analyzer.
	//
	// This member is required.
	Arn *string

	// A timestamp for the time at which the analyzer was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the analyzer.
	//
	// This member is required.
	Name *string

	// The status of the analyzer. An Active analyzer successfully monitors supported
	// resources and generates new findings. The analyzer is Disabled when a user
	// action, such as removing trusted access for Identity and Access Management
	// Access Analyzer from Organizations, causes the analyzer to stop generating new
	// findings. The status is Creating when the analyzer creation is in progress and
	// Failed when the analyzer creation has failed.
	//
	// This member is required.
	Status AnalyzerStatus

	// The type of analyzer, which corresponds to the zone of trust chosen for the
	// analyzer.
	//
	// This member is required.
	Type Type

	// The resource that was most recently analyzed by the analyzer.
	LastResourceAnalyzed *string

	// The time at which the most recently analyzed resource was analyzed.
	LastResourceAnalyzedAt *time.Time

	// The statusReason provides more details about the current status of the analyzer.
	// For example, if the creation for the analyzer fails, a Failed status is
	// returned. For an analyzer with organization as the type, this failure can be due
	// to an issue with creating the service-linked roles required in the member
	// accounts of the Amazon Web Services organization.
	StatusReason *StatusReason

	// The tags added to the analyzer.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about an archive rule.
type ArchiveRuleSummary struct {

	// The time at which the archive rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// A filter used to define the archive rule.
	//
	// This member is required.
	Filter map[string]Criterion

	// The name of the archive rule.
	//
	// This member is required.
	RuleName *string

	// The time at which the archive rule was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about CloudTrail access.
type CloudTrailDetails struct {

	// The ARN of the service role that IAM Access Analyzer uses to access your
	// CloudTrail trail and service last accessed information.
	//
	// This member is required.
	AccessRole *string

	// The start of the time range for which IAM Access Analyzer reviews your
	// CloudTrail events. Events with a timestamp before this time are not considered
	// to generate a policy.
	//
	// This member is required.
	StartTime *time.Time

	// A Trail object that contains settings for a trail.
	//
	// This member is required.
	Trails []Trail

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate a
	// policy. If this is not included in the request, the default value is the current
	// time.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Contains information about CloudTrail access.
type CloudTrailProperties struct {

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate a
	// policy. If this is not included in the request, the default value is the current
	// time.
	//
	// This member is required.
	EndTime *time.Time

	// The start of the time range for which IAM Access Analyzer reviews your
	// CloudTrail events. Events with a timestamp before this time are not considered
	// to generate a policy.
	//
	// This member is required.
	StartTime *time.Time

	// A TrailProperties object that contains settings for trail properties.
	//
	// This member is required.
	TrailProperties []TrailProperties

	noSmithyDocumentSerde
}

// Access control configuration structures for your resource. You specify the
// configuration as a type-value pair. You can specify only one type of access
// control configuration.
//
// The following types satisfy this interface:
//  ConfigurationMemberIamRole
//  ConfigurationMemberKmsKey
//  ConfigurationMemberSecretsManagerSecret
//  ConfigurationMemberS3Bucket
//  ConfigurationMemberSqsQueue
type Configuration interface {
	isConfiguration()
}

// The access control configuration is for an IAM role.
type ConfigurationMemberIamRole struct {
	Value IamRoleConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberIamRole) isConfiguration() {}

// The access control configuration is for a KMS key.
type ConfigurationMemberKmsKey struct {
	Value KmsKeyConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberKmsKey) isConfiguration() {}

// The access control configuration is for a Secrets Manager secret.
type ConfigurationMemberSecretsManagerSecret struct {
	Value SecretsManagerSecretConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberSecretsManagerSecret) isConfiguration() {}

// The access control configuration is for an Amazon S3 Bucket.
type ConfigurationMemberS3Bucket struct {
	Value S3BucketConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberS3Bucket) isConfiguration() {}

// The access control configuration is for an Amazon SQS queue.
type ConfigurationMemberSqsQueue struct {
	Value SqsQueueConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberSqsQueue) isConfiguration() {}

// The criteria to use in the filter that defines the archive rule.
type Criterion struct {

	// A "contains" operator to match for the filter used to create the rule.
	Contains []string

	// An "equals" operator to match for the filter used to create the rule.
	Eq []string

	// An "exists" operator to match for the filter used to create the rule.
	Exists *bool

	// A "not equals" operator to match for the filter used to create the rule.
	Neq []string

	noSmithyDocumentSerde
}

// Contains information about a finding.
type Finding struct {

	// The time at which the resource was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// This member is required.
	Condition map[string]string

	// The time at which the finding was generated.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource identified in the finding.
	//
	// This member is required.
	ResourceType ResourceType

	// The current status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The time at which the finding was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string

	// An error.
	Error *string

	// Indicates whether the policy that generated the finding allows public access to
	// the resource.
	IsPublic *bool

	// The external principal that access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that an external principal has access to.
	Resource *string

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// The source of the finding. This indicates how the access that generated the
// finding is granted. It is populated for Amazon S3 bucket findings.
type FindingSource struct {

	// Indicates the type of access that generated the finding.
	//
	// This member is required.
	Type FindingSourceType

	// Includes details about how the access that generated the finding is granted.
	// This is populated for Amazon S3 bucket findings.
	Detail *FindingSourceDetail

	noSmithyDocumentSerde
}

// Includes details about how the access that generated the finding is granted.
// This is populated for Amazon S3 bucket findings.
type FindingSourceDetail struct {

	// The ARN of the access point that generated the finding. The ARN format depends
	// on whether the ARN represents an access point or a multi-region access point.
	AccessPointArn *string

	noSmithyDocumentSerde
}

// Contains information about a finding.
type FindingSummary struct {

	// The time at which the resource-based policy that generated the finding was
	// analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// This member is required.
	Condition map[string]string

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that the external principal has access to.
	//
	// This member is required.
	ResourceType ResourceType

	// The status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The time at which the finding was most recently updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string

	// The error that resulted in an Error finding.
	Error *string

	// Indicates whether the finding reports a resource that has a policy that allows
	// public access.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that the external principal has access to.
	Resource *string

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Contains the text for the generated policy.
type GeneratedPolicy struct {

	// The text to use as the content for the new policy. The policy is created using
	// the CreatePolicy
	// (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html)
	// action.
	//
	// This member is required.
	Policy *string

	noSmithyDocumentSerde
}

// Contains the generated policy details.
type GeneratedPolicyProperties struct {

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	// Lists details about the Trail used to generated policy.
	CloudTrailProperties *CloudTrailProperties

	// This value is set to true if the generated policy contains all possible actions
	// for a service that IAM Access Analyzer identified from the CloudTrail trail that
	// you specified, and false otherwise.
	IsComplete *bool

	noSmithyDocumentSerde
}

// Contains the text for the generated policy and its details.
type GeneratedPolicyResult struct {

	// A GeneratedPolicyProperties object that contains properties of the generated
	// policy.
	//
	// This member is required.
	Properties *GeneratedPolicyProperties

	// The text to use as the content for the new policy. The policy is created using
	// the CreatePolicy
	// (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html)
	// action.
	GeneratedPolicies []GeneratedPolicy

	noSmithyDocumentSerde
}

// The proposed access control configuration for an IAM role. You can propose a
// configuration for a new IAM role or an existing IAM role that you own by
// specifying the trust policy. If the configuration is for a new IAM role, you
// must specify the trust policy. If the configuration is for an existing IAM role
// that you own and you do not propose the trust policy, the access preview uses
// the existing trust policy for the role. The proposed trust policy cannot be an
// empty string. For more information about role trust policy limits, see IAM and
// STS quotas
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html).
type IamRoleConfiguration struct {

	// The proposed trust policy for the IAM role.
	TrustPolicy *string

	noSmithyDocumentSerde
}

// An criterion statement in an archive rule. Each archive rule may have multiple
// criteria.
type InlineArchiveRule struct {

	// The condition and values for a criterion.
	//
	// This member is required.
	Filter map[string]Criterion

	// The name of the rule.
	//
	// This member is required.
	RuleName *string

	noSmithyDocumentSerde
}

// This configuration sets the network origin for the Amazon S3 access point or
// multi-region access point to Internet.
type InternetConfiguration struct {
	noSmithyDocumentSerde
}

// Contains details about the policy generation request.
type JobDetails struct {

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId can
	// be used with GetGeneratedPolicy to retrieve the generated policies or used with
	// CancelPolicyGeneration to cancel the policy generation request.
	//
	// This member is required.
	JobId *string

	// A timestamp of when the job was started.
	//
	// This member is required.
	StartedOn *time.Time

	// The status of the job request.
	//
	// This member is required.
	Status JobStatus

	// A timestamp of when the job was completed.
	CompletedOn *time.Time

	// The job error for the policy generation request.
	JobError *JobError

	noSmithyDocumentSerde
}

// Contains the details about the policy generation error.
type JobError struct {

	// The job error code.
	//
	// This member is required.
	Code JobErrorCode

	// Specific information about the error. For example, which service quota was
	// exceeded or which resource was not found.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// A proposed grant configuration for a KMS key. For more information, see
// CreateGrant
// (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html).
type KmsGrantConfiguration struct {

	// The principal that is given permission to perform the operations that the grant
	// permits.
	//
	// This member is required.
	GranteePrincipal *string

	// The Amazon Web Services account under which the grant was issued. The account is
	// used to propose KMS grants issued by accounts other than the owner of the key.
	//
	// This member is required.
	IssuingAccount *string

	// A list of operations that the grant permits.
	//
	// This member is required.
	Operations []KmsGrantOperation

	// Use this structure to propose allowing cryptographic operations
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// in the grant only when the operation request includes the specified encryption
	// context
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
	Constraints *KmsGrantConstraints

	// The principal that is given permission to retire the grant by using RetireGrant
	// (https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html)
	// operation.
	RetiringPrincipal *string

	noSmithyDocumentSerde
}

// Use this structure to propose allowing cryptographic operations
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
// in the grant only when the operation request includes the specified encryption
// context
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
// You can specify only one type of encryption context. An empty map is treated as
// not specified. For more information, see GrantConstraints
// (https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html).
type KmsGrantConstraints struct {

	// A list of key-value pairs that must match the encryption context in the
	// cryptographic operation
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the operation only when the encryption context in the
	// request is the same as the encryption context specified in this constraint.
	EncryptionContextEquals map[string]string

	// A list of key-value pairs that must be included in the encryption context of the
	// cryptographic operation
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the cryptographic operation only when the encryption
	// context in the request includes the key-value pairs specified in this
	// constraint, although it can include additional key-value pairs.
	EncryptionContextSubset map[string]string

	noSmithyDocumentSerde
}

// Proposed access control configuration for a KMS key. You can propose a
// configuration for a new KMS key or an existing KMS key that you own by
// specifying the key policy and KMS grant configuration. If the configuration is
// for an existing key and you do not specify the key policy, the access preview
// uses the existing policy for the key. If the access preview is for a new
// resource and you do not specify the key policy, then the access preview uses the
// default key policy. The proposed key policy cannot be an empty string. For more
// information, see Default key policy
// (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
// For more information about key policy limits, see Resource quotas
// (https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html).
type KmsKeyConfiguration struct {

	// A list of proposed grant configurations for the KMS key. If the proposed grant
	// configuration is for an existing key, the access preview uses the proposed list
	// of grant configurations in place of the existing grants. Otherwise, the access
	// preview uses the existing grants for the key.
	Grants []KmsGrantConfiguration

	// Resource policy configuration for the KMS key. The only valid value for the name
	// of the key policy is default. For more information, see Default key policy
	// (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
	KeyPolicies map[string]string

	noSmithyDocumentSerde
}

// A location in a policy that is represented as a path through the JSON
// representation and a corresponding span.
type Location struct {

	// A path in a policy, represented as a sequence of path elements.
	//
	// This member is required.
	Path []PathElement

	// A span in a policy.
	//
	// This member is required.
	Span *Span

	noSmithyDocumentSerde
}

// The proposed InternetConfiguration or VpcConfiguration to apply to the Amazon S3
// access point. VpcConfiguration does not apply to multi-region access points. You
// can make the access point accessible from the internet, or you can specify that
// all requests made through that access point must originate from a specific
// virtual private cloud (VPC). You can specify only one type of network
// configuration. For more information, see Creating access points
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).
//
// The following types satisfy this interface:
//  NetworkOriginConfigurationMemberVpcConfiguration
//  NetworkOriginConfigurationMemberInternetConfiguration
type NetworkOriginConfiguration interface {
	isNetworkOriginConfiguration()
}

// The proposed virtual private cloud (VPC) configuration for the Amazon S3 access
// point. VPC configuration does not apply to multi-region access points. For more
// information, see VpcConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html).
type NetworkOriginConfigurationMemberVpcConfiguration struct {
	Value VpcConfiguration

	noSmithyDocumentSerde
}

func (*NetworkOriginConfigurationMemberVpcConfiguration) isNetworkOriginConfiguration() {}

// The configuration for the Amazon S3 access point or multi-region access point
// with an Internet origin.
type NetworkOriginConfigurationMemberInternetConfiguration struct {
	Value InternetConfiguration

	noSmithyDocumentSerde
}

func (*NetworkOriginConfigurationMemberInternetConfiguration) isNetworkOriginConfiguration() {}

// A single element in a path through the JSON representation of a policy.
//
// The following types satisfy this interface:
//  PathElementMemberIndex
//  PathElementMemberKey
//  PathElementMemberSubstring
//  PathElementMemberValue
type PathElement interface {
	isPathElement()
}

// Refers to an index in a JSON array.
type PathElementMemberIndex struct {
	Value int32

	noSmithyDocumentSerde
}

func (*PathElementMemberIndex) isPathElement() {}

// Refers to a key in a JSON object.
type PathElementMemberKey struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathElementMemberKey) isPathElement() {}

// Refers to a substring of a literal string in a JSON object.
type PathElementMemberSubstring struct {
	Value Substring

	noSmithyDocumentSerde
}

func (*PathElementMemberSubstring) isPathElement() {}

// Refers to the value associated with a given key in a JSON object.
type PathElementMemberValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathElementMemberValue) isPathElement() {}

// Contains details about the policy generation status and properties.
type PolicyGeneration struct {

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId can
	// be used with GetGeneratedPolicy to retrieve the generated policies or used with
	// CancelPolicyGeneration to cancel the policy generation request.
	//
	// This member is required.
	JobId *string

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	// A timestamp of when the policy generation started.
	//
	// This member is required.
	StartedOn *time.Time

	// The status of the policy generation request.
	//
	// This member is required.
	Status JobStatus

	// A timestamp of when the policy generation was completed.
	CompletedOn *time.Time

	noSmithyDocumentSerde
}

// Contains the ARN details about the IAM entity for which the policy is generated.
type PolicyGenerationDetails struct {

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	noSmithyDocumentSerde
}

// A position in a policy.
type Position struct {

	// The column of the position, starting from 0.
	//
	// This member is required.
	Column *int32

	// The line of the position, starting from 1.
	//
	// This member is required.
	Line *int32

	// The offset within the policy that corresponds to the position, starting from 0.
	//
	// This member is required.
	Offset *int32

	noSmithyDocumentSerde
}

// The configuration for an Amazon S3 access point or multi-region access point for
// the bucket. You can propose up to 10 access points or multi-region access points
// per bucket. If the proposed Amazon S3 access point configuration is for an
// existing bucket, the access preview uses the proposed access point configuration
// in place of the existing access points. To propose an access point without a
// policy, you can provide an empty string as the access point policy. For more
// information, see Creating access points
// (https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).
// For more information about access point policy limits, see Access points
// restrictions and limitations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html).
type S3AccessPointConfiguration struct {

	// The access point or multi-region access point policy.
	AccessPointPolicy *string

	// The proposed Internet and VpcConfiguration to apply to this Amazon S3 access
	// point. VpcConfiguration does not apply to multi-region access points. If the
	// access preview is for a new resource and neither is specified, the access
	// preview uses Internet for the network origin. If the access preview is for an
	// existing resource and neither is specified, the access preview uses the exiting
	// network origin.
	NetworkOrigin NetworkOriginConfiguration

	// The proposed S3PublicAccessBlock configuration to apply to this Amazon S3 access
	// point or multi-region access point.
	PublicAccessBlock *S3PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// A proposed access control list grant configuration for an Amazon S3 bucket. For
// more information, see How to Specify an ACL
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls).
type S3BucketAclGrantConfiguration struct {

	// The grantee to whom you’re assigning access rights.
	//
	// This member is required.
	Grantee AclGrantee

	// The permissions being granted.
	//
	// This member is required.
	Permission AclPermission

	noSmithyDocumentSerde
}

// Proposed access control configuration for an Amazon S3 bucket. You can propose a
// configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that
// you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket BPA
// settings, Amazon S3 access points, and multi-region access points attached to
// the bucket. If the configuration is for an existing Amazon S3 bucket and you do
// not specify the Amazon S3 bucket policy, the access preview uses the existing
// policy attached to the bucket. If the access preview is for a new resource and
// you do not specify the Amazon S3 bucket policy, the access preview assumes a
// bucket without a policy. To propose deletion of an existing bucket policy, you
// can specify an empty string. For more information about bucket policy limits,
// see Bucket Policy Examples
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html).
type S3BucketConfiguration struct {

	// The configuration of Amazon S3 access points or multi-region access points for
	// the bucket. You can propose up to 10 new access points per bucket.
	AccessPoints map[string]S3AccessPointConfiguration

	// The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to
	// 100 ACL grants per bucket. If the proposed grant configuration is for an
	// existing bucket, the access preview uses the proposed list of grant
	// configurations in place of the existing grants. Otherwise, the access preview
	// uses the existing grants for the bucket.
	BucketAclGrants []S3BucketAclGrantConfiguration

	// The proposed bucket policy for the Amazon S3 bucket.
	BucketPolicy *string

	// The proposed block public access configuration for the Amazon S3 bucket.
	BucketPublicAccessBlock *S3PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// The PublicAccessBlock configuration to apply to this Amazon S3 bucket. If the
// proposed configuration is for an existing Amazon S3 bucket and the configuration
// is not specified, the access preview uses the existing setting. If the proposed
// configuration is for a new bucket and the configuration is not specified, the
// access preview uses false. If the proposed configuration is for a new access
// point or multi-region access point and the access point BPA configuration is not
// specified, the access preview uses true. For more information, see
// PublicAccessBlockConfiguration
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html).
type S3PublicAccessBlockConfiguration struct {

	// Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket.
	//
	// This member is required.
	IgnorePublicAcls *bool

	// Specifies whether Amazon S3 should restrict public bucket policies for this
	// bucket.
	//
	// This member is required.
	RestrictPublicBuckets *bool

	noSmithyDocumentSerde
}

// The configuration for a Secrets Manager secret. For more information, see
// CreateSecret
// (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html).
// You can propose a configuration for a new secret or an existing secret that you
// own by specifying the secret policy and optional KMS encryption key. If the
// configuration is for an existing secret and you do not specify the secret
// policy, the access preview uses the existing policy for the secret. If the
// access preview is for a new resource and you do not specify the policy, the
// access preview assumes a secret without a policy. To propose deletion of an
// existing policy, you can specify an empty string. If the proposed configuration
// is for a new secret and you do not specify the KMS key ID, the access preview
// uses the default CMK of the Amazon Web Services account. If you specify an empty
// string for the KMS key ID, the access preview uses the default CMK of the Amazon
// Web Services account. For more information about secret policy limits, see
// Quotas for Secrets Manager.
// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html).
type SecretsManagerSecretConfiguration struct {

	// The proposed ARN, key ID, or alias of the KMS customer master key (CMK).
	KmsKeyId *string

	// The proposed resource policy defining who can access or manage the secret.
	SecretPolicy *string

	noSmithyDocumentSerde
}

// The criteria used to sort.
type SortCriteria struct {

	// The name of the attribute to sort on.
	AttributeName *string

	// The sort order, ascending or descending.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// A span in a policy. The span consists of a start position (inclusive) and end
// position (exclusive).
type Span struct {

	// The end position of the span (exclusive).
	//
	// This member is required.
	End *Position

	// The start position of the span (inclusive).
	//
	// This member is required.
	Start *Position

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon SQS queue. You can
// propose a configuration for a new Amazon SQS queue or an existing Amazon SQS
// queue that you own by specifying the Amazon SQS policy. If the configuration is
// for an existing Amazon SQS queue and you do not specify the Amazon SQS policy,
// the access preview uses the existing Amazon SQS policy for the queue. If the
// access preview is for a new resource and you do not specify the policy, the
// access preview assumes an Amazon SQS queue without a policy. To propose deletion
// of an existing Amazon SQS queue policy, you can specify an empty string for the
// Amazon SQS policy. For more information about Amazon SQS policy limits, see
// Quotas related to policies
// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html).
type SqsQueueConfiguration struct {

	// The proposed resource policy for the Amazon SQS queue.
	QueuePolicy *string

	noSmithyDocumentSerde
}

// Provides more details about the current status of the analyzer. For example, if
// the creation for the analyzer fails, a Failed status is returned. For an
// analyzer with organization as the type, this failure can be due to an issue with
// creating the service-linked roles required in the member accounts of the Amazon
// Web Services organization.
type StatusReason struct {

	// The reason code for the current status of the analyzer.
	//
	// This member is required.
	Code ReasonCode

	noSmithyDocumentSerde
}

// A reference to a substring of a literal string in a JSON document.
type Substring struct {

	// The length of the substring.
	//
	// This member is required.
	Length *int32

	// The start index of the substring, starting from 0.
	//
	// This member is required.
	Start *int32

	noSmithyDocumentSerde
}

// Contains details about the CloudTrail trail being analyzed to generate a policy.
type Trail struct {

	// Specifies the ARN of the trail. The format of a trail ARN is
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
	//
	// This member is required.
	CloudTrailArn *string

	// Possible values are true or false. If set to true, IAM Access Analyzer retrieves
	// CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []string

	noSmithyDocumentSerde
}

// Contains details about the CloudTrail trail being analyzed to generate a policy.
type TrailProperties struct {

	// Specifies the ARN of the trail. The format of a trail ARN is
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
	//
	// This member is required.
	CloudTrailArn *string

	// Possible values are true or false. If set to true, IAM Access Analyzer retrieves
	// CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []string

	noSmithyDocumentSerde
}

// A finding in a policy. Each finding is an actionable recommendation that can be
// used to improve the policy.
type ValidatePolicyFinding struct {

	// A localized message that explains the finding and provides guidance on how to
	// address it.
	//
	// This member is required.
	FindingDetails *string

	// The impact of the finding. Security warnings report when the policy allows
	// access that we consider overly permissive. Errors report when a part of the
	// policy is not functional. Warnings report non-security issues when a policy does
	// not conform to policy writing best practices. Suggestions recommend stylistic
	// improvements in the policy that do not impact access.
	//
	// This member is required.
	FindingType ValidatePolicyFindingType

	// The issue code provides an identifier of the issue associated with this finding.
	//
	// This member is required.
	IssueCode *string

	// A link to additional documentation about the type of finding.
	//
	// This member is required.
	LearnMoreLink *string

	// The list of locations in the policy document that are related to the finding.
	// The issue code provides a summary of an issue identified by the finding.
	//
	// This member is required.
	Locations []Location

	noSmithyDocumentSerde
}

// Contains information about a validation exception.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The proposed virtual private cloud (VPC) configuration for the Amazon S3 access
// point. VPC configuration does not apply to multi-region access points. For more
// information, see VpcConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html).
type VpcConfiguration struct {

	// If this field is specified, this access point will only allow connections from
	// the specified VPC ID.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAclGrantee()                 {}
func (*UnknownUnionMember) isConfiguration()              {}
func (*UnknownUnionMember) isNetworkOriginConfiguration() {}
func (*UnknownUnionMember) isPathElement()                {}
