// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// WAF couldn’t perform the operation because your resource is being used by
// another resource or it’s associated with another resource.
type WAFAssociatedItemException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFAssociatedItemException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFAssociatedItemException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFAssociatedItemException) ErrorCode() string             { return "WAFAssociatedItemException" }
func (e *WAFAssociatedItemException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF couldn’t perform the operation because the resource that you tried to save
// is a duplicate of an existing one.
type WAFDuplicateItemException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFDuplicateItemException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFDuplicateItemException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFDuplicateItemException) ErrorCode() string             { return "WAFDuplicateItemException" }
func (e *WAFDuplicateItemException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified version for the managed rule group
// has expired. You can retrieve the available versions for the managed rule group
// by calling ListAvailableManagedRuleGroupVersions.
type WAFExpiredManagedRuleGroupVersionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFExpiredManagedRuleGroupVersionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFExpiredManagedRuleGroupVersionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFExpiredManagedRuleGroupVersionException) ErrorCode() string {
	return "WAFExpiredManagedRuleGroupVersionException"
}
func (e *WAFExpiredManagedRuleGroupVersionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request is valid, but WAF couldn’t perform the operation because of a
// system problem. Retry your request.
type WAFInternalErrorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFInternalErrorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFInternalErrorException) ErrorCode() string             { return "WAFInternalErrorException" }
func (e *WAFInternalErrorException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The operation isn't valid.
type WAFInvalidOperationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFInvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFInvalidOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFInvalidOperationException) ErrorCode() string             { return "WAFInvalidOperationException" }
func (e *WAFInvalidOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because WAF didn't recognize a parameter in the request.
// For example:
//
// * You specified a parameter name or value that isn't valid.
//
// *
// Your nested statement isn't valid. You might have tried to nest a statement that
// can’t be nested.
//
// * You tried to update a WebACL with a DefaultAction that isn't
// among the types available at DefaultAction.
//
// * Your request references an ARN
// that is malformed, or corresponds to a resource with which a web ACL can't be
// associated.
type WAFInvalidParameterException struct {
	Message *string

	Field     ParameterExceptionField
	Parameter *string
	Reason    *string

	noSmithyDocumentSerde
}

func (e *WAFInvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFInvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFInvalidParameterException) ErrorCode() string             { return "WAFInvalidParameterException" }
func (e *WAFInvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified policy isn't in the proper format.
// The policy specifications must conform to the following:
//
// * The policy must be
// composed using IAM Policy version 2012-10-17 or version 2015-01-01.
//
// * The
// policy must include specifications for Effect, Action, and Principal.
//
// * Effect
// must specify Allow.
//
// * Action must specify wafv2:CreateWebACL,
// wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups. WAF rejects any
// extra actions or wildcard actions in the policy.
//
// * The policy must not include
// a Resource parameter.
//
// For more information, see IAM Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
type WAFInvalidPermissionPolicyException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFInvalidPermissionPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFInvalidPermissionPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFInvalidPermissionPolicyException) ErrorCode() string {
	return "WAFInvalidPermissionPolicyException"
}
func (e *WAFInvalidPermissionPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// WAF couldn’t perform the operation because the resource that you requested isn’t
// valid. Check the resource, and try again.
type WAFInvalidResourceException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFInvalidResourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFInvalidResourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFInvalidResourceException) ErrorCode() string             { return "WAFInvalidResourceException" }
func (e *WAFInvalidResourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF couldn’t perform the operation because you exceeded your resource limit. For
// example, the maximum number of WebACL objects that you can create for an Amazon
// Web Services account. For more information, see WAF quotas
// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
// Developer Guide.
type WAFLimitsExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFLimitsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFLimitsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFLimitsExceededException) ErrorCode() string             { return "WAFLimitsExceededException" }
func (e *WAFLimitsExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF couldn’t perform the operation because your resource doesn’t exist.
type WAFNonexistentItemException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFNonexistentItemException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFNonexistentItemException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFNonexistentItemException) ErrorCode() string             { return "WAFNonexistentItemException" }
func (e *WAFNonexistentItemException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF couldn’t save your changes because you tried to update or delete a resource
// that has changed since you last retrieved it. Get the resource again, make any
// changes you need to make to the new copy, and retry your operation.
type WAFOptimisticLockException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFOptimisticLockException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFOptimisticLockException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFOptimisticLockException) ErrorCode() string             { return "WAFOptimisticLockException" }
func (e *WAFOptimisticLockException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF is not able to access the service linked role. This can be caused by a
// previous PutLoggingConfiguration request, which can lock the service linked role
// for about 20 seconds. Please try your request again. The service linked role can
// also be locked by a previous DeleteServiceLinkedRole request, which can lock the
// role for 15 minutes or more. If you recently made a call to
// DeleteServiceLinkedRole, wait at least 15 minutes and try the request again. If
// you receive this same exception again, you will have to wait additional time
// until the role is unlocked.
type WAFServiceLinkedRoleErrorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFServiceLinkedRoleErrorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFServiceLinkedRoleErrorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFServiceLinkedRoleErrorException) ErrorCode() string {
	return "WAFServiceLinkedRoleErrorException"
}
func (e *WAFServiceLinkedRoleErrorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You tried to use a managed rule group that's available by subscription, but you
// aren't subscribed to it yet.
type WAFSubscriptionNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFSubscriptionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFSubscriptionNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFSubscriptionNotFoundException) ErrorCode() string {
	return "WAFSubscriptionNotFoundException"
}
func (e *WAFSubscriptionNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An error occurred during the tagging operation. Retry your request.
type WAFTagOperationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFTagOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFTagOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFTagOperationException) ErrorCode() string             { return "WAFTagOperationException" }
func (e *WAFTagOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// WAF couldn’t perform your tagging operation because of an internal error. Retry
// your request.
type WAFTagOperationInternalErrorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFTagOperationInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFTagOperationInternalErrorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFTagOperationInternalErrorException) ErrorCode() string {
	return "WAFTagOperationInternalErrorException"
}
func (e *WAFTagOperationInternalErrorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultServer
}

// WAF couldn’t retrieve the resource that you requested. Retry your request.
type WAFUnavailableEntityException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *WAFUnavailableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WAFUnavailableEntityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WAFUnavailableEntityException) ErrorCode() string             { return "WAFUnavailableEntityException" }
func (e *WAFUnavailableEntityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
