// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure representing a screenshot that is used as a baseline during visual
// monitoring comparisons made by the canary.
type BaseScreenshot struct {

	// The name of the screenshot. This is generated the first time the canary is run
	// after the UpdateCanary operation that specified for this canary to perform
	// visual monitoring.
	//
	// This member is required.
	ScreenshotName *string

	// Coordinates that define the part of a screen to ignore during screenshot
	// comparisons. To obtain the coordinates to use here, use the CloudWatch Logs
	// console to draw the boundaries on the screen. For more information, see {LINK}
	IgnoreCoordinates []string

	noSmithyDocumentSerde
}

// This structure contains all information about one canary in your account.
type Canary struct {

	// The location in Amazon S3 where Synthetics stores artifacts from the runs of
	// this canary. Artifacts include the log file, screenshots, and HAR files.
	ArtifactS3Location *string

	// This structure contains information about the canary's Lambda handler and where
	// its code is stored by CloudWatch Synthetics.
	Code *CanaryCodeOutput

	// The ARN of the Lambda function that is used as your canary's engine. For more
	// information about Lambda ARN format, see Resources and Conditions for Lambda
	// Actions
	// (https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html).
	EngineArn *string

	// The ARN of the IAM role used to run the canary. This role must include
	// lambda.amazonaws.com as a principal in the trust policy.
	ExecutionRoleArn *string

	// The number of days to retain data about failed runs of this canary.
	FailureRetentionPeriodInDays *int32

	// The unique ID of this canary.
	Id *string

	// The name of the canary.
	Name *string

	// A structure that contains information about a canary run.
	RunConfig *CanaryRunConfigOutput

	// Specifies the runtime version to use for the canary. For more information about
	// runtime versions, see  Canary Runtime Versions
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	RuntimeVersion *string

	// A structure that contains information about how often the canary is to run, and
	// when these runs are to stop.
	Schedule *CanaryScheduleOutput

	// A structure that contains information about the canary's status.
	Status *CanaryStatus

	// The number of days to retain data about successful runs of this canary.
	SuccessRetentionPeriodInDays *int32

	// The list of key-value pairs that are associated with the canary.
	Tags map[string]string

	// A structure that contains information about when the canary was created,
	// modified, and most recently run.
	Timeline *CanaryTimeline

	// If this canary performs visual monitoring by comparing screenshots, this
	// structure contains the ID of the canary run to use as the baseline for
	// screenshots, and the coordinates of any parts of the screen to ignore during the
	// visual monitoring comparison.
	VisualReference *VisualReferenceOutput

	// If this canary is to test an endpoint in a VPC, this structure contains
	// information about the subnets and security groups of the VPC endpoint. For more
	// information, see  Running a Canary in a VPC
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigOutput

	noSmithyDocumentSerde
}

// Use this structure to input your script code for the canary. This structure
// contains the Lambda handler with the location where the canary should start
// running the script. If the script is stored in an S3 bucket, the bucket name,
// key, and version are also included. If the script was passed into the canary
// directly, the script code is contained in the value of Zipfile.
type CanaryCodeInput struct {

	// The entry point to use for the source code when running the canary. This value
	// must end with the string .handler. The string is limited to 29 characters or
	// fewer.
	//
	// This member is required.
	Handler *string

	// If your canary script is located in S3, specify the bucket name here. Do not
	// include s3:// as the start of the bucket name.
	S3Bucket *string

	// The S3 key of your script. For more information, see Working with Amazon S3
	// Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).
	S3Key *string

	// The S3 version ID of your script.
	S3Version *string

	// If you input your canary script directly into the canary instead of referring to
	// an S3 location, the value of this parameter is the base64-encoded contents of
	// the .zip file that contains the script. It must be smaller than 256 Kb.
	ZipFile []byte

	noSmithyDocumentSerde
}

// This structure contains information about the canary's Lambda handler and where
// its code is stored by CloudWatch Synthetics.
type CanaryCodeOutput struct {

	// The entry point to use for the source code when running the canary.
	Handler *string

	// The ARN of the Lambda layer where Synthetics stores the canary script code.
	SourceLocationArn *string

	noSmithyDocumentSerde
}

// This structure contains information about the most recent run of a single
// canary.
type CanaryLastRun struct {

	// The name of the canary.
	CanaryName *string

	// The results from this canary's most recent run.
	LastRun *CanaryRun

	noSmithyDocumentSerde
}

// This structure contains the details about one run of one canary.
type CanaryRun struct {

	// The location where the canary stored artifacts from the run. Artifacts include
	// the log file, screenshots, and HAR files.
	ArtifactS3Location *string

	// A unique ID that identifies this canary run.
	Id *string

	// The name of the canary.
	Name *string

	// The status of this run.
	Status *CanaryRunStatus

	// A structure that contains the start and end times of this run.
	Timeline *CanaryRunTimeline

	noSmithyDocumentSerde
}

// A structure that contains input information for a canary run.
type CanaryRunConfigInput struct {

	// Specifies whether this canary is to use active X-Ray tracing when it runs.
	// Active tracing enables this canary run to be displayed in the ServiceLens and
	// X-Ray service maps even if the canary does not hit an endpoint that has X-Ray
	// tracing enabled. Using X-Ray tracing incurs charges. For more information, see
	// Canaries and X-Ray tracing
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html).
	// You can enable active tracing only for canaries that use version syn-nodejs-2.0
	// or later for their canary runtime.
	ActiveTracing *bool

	// Specifies the keys and values to use for any environment variables used in the
	// canary script. Use the following format: { "key1" : "value1", "key2" : "value2",
	// ...} Keys must start with a letter and be at least two characters. The total
	// size of your environment variables cannot exceed 4 KB. You can't specify any
	// Lambda reserved environment variables as the keys for your environment
	// variables. For more information about reserved keys, see  Runtime environment
	// variables
	// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime).
	EnvironmentVariables map[string]string

	// The maximum amount of memory available to the canary while it is running, in MB.
	// This value must be a multiple of 64.
	MemoryInMB *int32

	// How long the canary is allowed to run before it must stop. You can't set this
	// time to be longer than the frequency of the runs of this canary. If you omit
	// this field, the frequency of the canary is used as this value, up to a maximum
	// of 14 minutes.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// A structure that contains information about a canary run.
type CanaryRunConfigOutput struct {

	// Displays whether this canary run used active X-Ray tracing.
	ActiveTracing *bool

	// The maximum amount of memory available to the canary while it is running, in MB.
	// This value must be a multiple of 64.
	MemoryInMB *int32

	// How long the canary is allowed to run before it must stop.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// This structure contains the status information about a canary run.
type CanaryRunStatus struct {

	// The current state of the run.
	State CanaryRunState

	// If run of the canary failed, this field contains the reason for the error.
	StateReason *string

	// If this value is CANARY_FAILURE, an exception occurred in the canary code. If
	// this value is EXECUTION_FAILURE, an exception occurred in CloudWatch Synthetics.
	StateReasonCode CanaryRunStateReasonCode

	noSmithyDocumentSerde
}

// This structure contains the start and end times of a single canary run.
type CanaryRunTimeline struct {

	// The end time of the run.
	Completed *time.Time

	// The start time of the run.
	Started *time.Time

	noSmithyDocumentSerde
}

// This structure specifies how often a canary is to make runs and the date and
// time when it should stop making runs.
type CanaryScheduleInput struct {

	// A rate expression or a cron expression that defines how often the canary is to
	// run. For a rate expression, The syntax is rate(number unit). unit can be minute,
	// minutes, or hour. For example, rate(1 minute) runs the canary once a minute,
	// rate(10 minutes) runs it once every 10 minutes, and rate(1 hour) runs it once
	// every hour. You can specify a frequency between rate(1 minute) and rate(1 hour).
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes the
	// canary to run only once when it is started. Use cron(expression) to specify a
	// cron expression. You can't schedule a canary to wait for more than a year before
	// running. For information about the syntax for cron expressions, see  Scheduling
	// canary runs using cron
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
	//
	// This member is required.
	Expression *string

	// How long, in seconds, for the canary to continue making regular runs according
	// to the schedule in the Expression value. If you specify 0, the canary continues
	// making runs until you stop it. If you omit this field, the default of 0 is used.
	DurationInSeconds *int64

	noSmithyDocumentSerde
}

// How long, in seconds, for the canary to continue making regular runs according
// to the schedule in the Expression value.
type CanaryScheduleOutput struct {

	// How long, in seconds, for the canary to continue making regular runs after it
	// was created. The runs are performed according to the schedule in the Expression
	// value.
	DurationInSeconds *int64

	// A rate expression or a cron expression that defines how often the canary is to
	// run. For a rate expression, The syntax is rate(number unit). unit can be minute,
	// minutes, or hour. For example, rate(1 minute) runs the canary once a minute,
	// rate(10 minutes) runs it once every 10 minutes, and rate(1 hour) runs it once
	// every hour. You can specify a frequency between rate(1 minute) and rate(1 hour).
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes the
	// canary to run only once when it is started. Use cron(expression) to specify a
	// cron expression. For information about the syntax for cron expressions, see
	// Scheduling canary runs using cron
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
	Expression *string

	noSmithyDocumentSerde
}

// A structure that contains the current state of the canary.
type CanaryStatus struct {

	// The current state of the canary.
	State CanaryState

	// If the canary has insufficient permissions to run, this field provides more
	// details.
	StateReason *string

	// If the canary cannot run or has failed, this field displays the reason.
	StateReasonCode CanaryStateReasonCode

	noSmithyDocumentSerde
}

// This structure contains information about when the canary was created and
// modified.
type CanaryTimeline struct {

	// The date and time the canary was created.
	Created *time.Time

	// The date and time the canary was most recently modified.
	LastModified *time.Time

	// The date and time that the canary's most recent run started.
	LastStarted *time.Time

	// The date and time that the canary's most recent run ended.
	LastStopped *time.Time

	noSmithyDocumentSerde
}

// This structure contains information about one canary runtime version. For more
// information about runtime versions, see  Canary Runtime Versions
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
type RuntimeVersion struct {

	// If this runtime version is deprecated, this value is the date of deprecation.
	DeprecationDate *time.Time

	// A description of the runtime version, created by Amazon.
	Description *string

	// The date that the runtime version was released.
	ReleaseDate *time.Time

	// The name of the runtime version. For a list of valid runtime versions, see
	// Canary Runtime Versions
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	VersionName *string

	noSmithyDocumentSerde
}

// An object that specifies what screenshots to use as a baseline for visual
// monitoring by this canary, and optionally the parts of the screenshots to ignore
// during the visual monitoring comparison. Visual monitoring is supported only on
// canaries running the syn-puppeteer-node-3.2 runtime or later. For more
// information, see  Visual monitoring
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html)
// and  Visual monitoring blueprint
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html)
type VisualReferenceInput struct {

	// Specifies which canary run to use the screenshots from as the baseline for
	// future visual monitoring with this canary. Valid values are nextrun to use the
	// screenshots from the next run after this update is made, lastrun to use the
	// screenshots from the most recent run before this update was made, or the value
	// of Id in the  CanaryRun
	// (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html)
	// from any past run of this canary.
	//
	// This member is required.
	BaseCanaryRunId *string

	// An array of screenshots that will be used as the baseline for visual monitoring
	// in future runs of this canary. If there is a screenshot that you don't want to
	// be used for visual monitoring, remove it from this array.
	BaseScreenshots []BaseScreenshot

	noSmithyDocumentSerde
}

// If this canary performs visual monitoring by comparing screenshots, this
// structure contains the ID of the canary run that is used as the baseline for
// screenshots, and the coordinates of any parts of those screenshots that are
// ignored during visual monitoring comparison. Visual monitoring is supported only
// on canaries running the syn-puppeteer-node-3.2 runtime or later.
type VisualReferenceOutput struct {

	// The ID of the canary run that produced the screenshots that are used as the
	// baseline for visual monitoring comparisons during future runs of this canary.
	BaseCanaryRunId *string

	// An array of screenshots that are used as the baseline for comparisons during
	// visual monitoring.
	BaseScreenshots []BaseScreenshot

	noSmithyDocumentSerde
}

// If this canary is to test an endpoint in a VPC, this structure contains
// information about the subnets and security groups of the VPC endpoint. For more
// information, see  Running a Canary in a VPC
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigInput struct {

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string

	noSmithyDocumentSerde
}

// If this canary is to test an endpoint in a VPC, this structure contains
// information about the subnets and security groups of the VPC endpoint. For more
// information, see  Running a Canary in a VPC
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigOutput struct {

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string

	// The IDs of the VPC where this canary is to run.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
