// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Provides information about a specified data ingestion job, including dataset
// information, data ingestion configuration, and status.
type DataIngestionJobSummary struct {

	// The Amazon Resource Name (ARN) of the dataset used in the data ingestion job.
	DatasetArn *string

	// The name of the dataset used for the data ingestion job.
	DatasetName *string

	// Specifies information for the input data for the data inference job, including
	// data S3 location parameters.
	IngestionInputConfiguration *IngestionInputConfiguration

	// Indicates the job ID of the data ingestion job.
	JobId *string

	// Indicates the status of the data ingestion job.
	Status IngestionJobStatus

	noSmithyDocumentSerde
}

// The configuration is the TargetSamplingRate, which is the sampling rate of the
// data after post processing by Amazon Lookout for Equipment. For example, if you
// provide data that has been collected at a 1 second level and you want the system
// to resample the data at a 1 minute rate before training, the TargetSamplingRate
// is 1 minute. When providing a value for the TargetSamplingRate, you must attach
// the prefix "PT" to the rate you want. The value for a 1 second rate is therefore
// PT1S, the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
// is PT1H
type DataPreProcessingConfiguration struct {

	// The sampling rate of the data after post processing by Amazon Lookout for
	// Equipment. For example, if you provide data that has been collected at a 1
	// second level and you want the system to resample the data at a 1 minute rate
	// before training, the TargetSamplingRate is 1 minute. When providing a value for
	// the TargetSamplingRate, you must attach the prefix "PT" to the rate you want.
	// The value for a 1 second rate is therefore PT1S, the value for a 15 minute rate
	// is PT15M, and the value for a 1 hour rate is PT1H
	TargetSamplingRate TargetSamplingRate

	noSmithyDocumentSerde
}

// Provides information about the data schema used with the given dataset.
type DatasetSchema struct {

	//
	//
	// This value conforms to the media type: application/json
	InlineDataSchema *string

	noSmithyDocumentSerde
}

// Contains information about the specific data set, including name, ARN, and
// status.
type DatasetSummary struct {

	// The time at which the dataset was created in Amazon Lookout for Equipment.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the specified dataset.
	DatasetArn *string

	// The name of the dataset.
	DatasetName *string

	// Indicates the status of the dataset.
	Status DatasetStatus

	noSmithyDocumentSerde
}

// Contains information about the specific inference execution, including input and
// output data configuration, inference scheduling information, status, and so on.
type InferenceExecutionSummary struct {

	//
	CustomerResultObject *S3Object

	// Indicates the time reference in the dataset at which the inference execution
	// stopped.
	DataEndTime *time.Time

	// Specifies configuration information for the input data for the inference
	// scheduler, including delimiter, format, and dataset location.
	DataInputConfiguration *InferenceInputConfiguration

	// Specifies configuration information for the output results from for the
	// inference execution, including the output S3 location.
	DataOutputConfiguration *InferenceOutputConfiguration

	// Indicates the time reference in the dataset at which the inference execution
	// began.
	DataStartTime *time.Time

	// Specifies the reason for failure when an inference execution has failed.
	FailedReason *string

	// The Amazon Resource Name (ARN) of the inference scheduler being used for the
	// inference execution.
	InferenceSchedulerArn *string

	// The name of the inference scheduler being used for the inference execution.
	InferenceSchedulerName *string

	// The Amazon Resource Name (ARN) of the ML model used for the inference execution.
	ModelArn *string

	// The name of the ML model being used for the inference execution.
	ModelName *string

	// Indicates the start time at which the inference scheduler began the specific
	// inference execution.
	ScheduledStartTime *time.Time

	// Indicates the status of the inference execution.
	Status InferenceExecutionStatus

	noSmithyDocumentSerde
}

// Specifies configuration information for the input data for the inference,
// including S3 location of input data..
type InferenceInputConfiguration struct {

	// Specifies configuration information for the input data for the inference,
	// including timestamp format and delimiter.
	InferenceInputNameConfiguration *InferenceInputNameConfiguration

	// Indicates the difference between your time zone and Greenwich Mean Time (GMT).
	InputTimeZoneOffset *string

	// Specifies configuration information for the input data for the inference,
	// including S3 location of input data..
	S3InputConfiguration *InferenceS3InputConfiguration

	noSmithyDocumentSerde
}

// Specifies configuration information for the input data for the inference,
// including timestamp format and delimiter.
type InferenceInputNameConfiguration struct {

	// Indicates the delimiter character used between items in the data.
	ComponentTimestampDelimiter *string

	// The format of the timestamp, whether Epoch time, or standard, with or without
	// hyphens (-).
	TimestampFormat *string

	noSmithyDocumentSerde
}

// Specifies configuration information for the output results from for the
// inference, including KMS key ID and output S3 location.
type InferenceOutputConfiguration struct {

	// Specifies configuration information for the output results from for the
	// inference, output S3 location.
	//
	// This member is required.
	S3OutputConfiguration *InferenceS3OutputConfiguration

	// The ID number for the AWS KMS key used to encrypt the inference output.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies configuration information for the input data for the inference,
// including input data S3 location.
type InferenceS3InputConfiguration struct {

	// The bucket containing the input dataset for the inference.
	//
	// This member is required.
	Bucket *string

	// The prefix for the S3 bucket used for the input data for the inference.
	Prefix *string

	noSmithyDocumentSerde
}

// Specifies configuration information for the output results from the inference,
// including output S3 location.
type InferenceS3OutputConfiguration struct {

	// The bucket containing the output results from the inference
	//
	// This member is required.
	Bucket *string

	// The prefix for the S3 bucket used for the output results from the inference.
	Prefix *string

	noSmithyDocumentSerde
}

// Contains information about the specific inference scheduler, including data
// delay offset, model name and ARN, status, and so on.
type InferenceSchedulerSummary struct {

	// A period of time (in minutes) by which inference on the data is delayed after
	// the data starts. For instance, if an offset delay time of five minutes was
	// selected, inference will not begin on the data until the first data measurement
	// after the five minute mark. For example, if five minutes is selected, the
	// inference scheduler will wake up at the configured frequency with the additional
	// five minute delay time to check the customer S3 bucket. The customer can upload
	// data at the same frequency and they don't need to stop and restart the scheduler
	// when uploading new data.
	DataDelayOffsetInMinutes *int64

	// How often data is uploaded to the source S3 bucket for the input data. This
	// value is the length of time between data uploads. For instance, if you select 5
	// minutes, Amazon Lookout for Equipment will upload the real-time data to the
	// source bucket once every 5 minutes. This frequency also determines how often
	// Amazon Lookout for Equipment starts a scheduled inference on your data. In this
	// example, it starts once every 5 minutes.
	DataUploadFrequency DataUploadFrequency

	// The Amazon Resource Name (ARN) of the inference scheduler.
	InferenceSchedulerArn *string

	// The name of the inference scheduler.
	InferenceSchedulerName *string

	// The Amazon Resource Name (ARN) of the ML model used by the inference scheduler.
	ModelArn *string

	// The name of the ML model used for the inference scheduler.
	ModelName *string

	// Indicates the status of the inference scheduler.
	Status InferenceSchedulerStatus

	noSmithyDocumentSerde
}

// Specifies configuration information for the input data for the data ingestion
// job, including input data S3 location.
type IngestionInputConfiguration struct {

	// The location information for the S3 bucket used for input data for the data
	// ingestion.
	//
	// This member is required.
	S3InputConfiguration *IngestionS3InputConfiguration

	noSmithyDocumentSerde
}

// Specifies S3 configuration information for the input data for the data ingestion
// job.
type IngestionS3InputConfiguration struct {

	// The name of the S3 bucket used for the input data for the data ingestion.
	//
	// This member is required.
	Bucket *string

	// The prefix for the S3 location being used for the input data for the data
	// ingestion.
	Prefix *string

	noSmithyDocumentSerde
}

// Contains the configuration information for the S3 location being used to hold
// label data.
type LabelsInputConfiguration struct {

	// Contains location information for the S3 location being used for label data.
	//
	// This member is required.
	S3InputConfiguration *LabelsS3InputConfiguration

	noSmithyDocumentSerde
}

// The location information (prefix and bucket name) for the s3 location being used
// for label data.
type LabelsS3InputConfiguration struct {

	// The name of the S3 bucket holding the label data.
	//
	// This member is required.
	Bucket *string

	// The prefix for the S3 bucket used for the label data.
	Prefix *string

	noSmithyDocumentSerde
}

// Provides information about the specified ML model, including dataset and model
// names and ARNs, as well as status.
type ModelSummary struct {

	// The time at which the specific model was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the dataset used to create the model.
	DatasetArn *string

	// The name of the dataset being used for the ML model.
	DatasetName *string

	// The Amazon Resource Name (ARN) of the ML model.
	ModelArn *string

	// The name of the ML model.
	ModelName *string

	// Indicates the status of the ML model.
	Status ModelStatus

	noSmithyDocumentSerde
}

// Contains information about an S3 bucket.
type S3Object struct {

	// The name of the specific S3 bucket.
	//
	// This member is required.
	Bucket *string

	// The AWS Key Management Service (AWS KMS) key being used to encrypt the S3
	// object. Without this key, data in the bucket is not accessible.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// A tag is a key-value pair that can be added to a resource as metadata.
type Tag struct {

	// The key for the specified tag.
	//
	// This member is required.
	Key *string

	// The value for the specified tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
