// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets information about all of the versions of a bot. The ListBotVersions
// operation returns a summary of each version of a bot. For example, if a bot has
// three numbered versions, the ListBotVersions operation returns for summaries,
// one for each numbered version and one for the DRAFT version. The ListBotVersions
// operation always returns at least one version, the DRAFT version.
func (c *Client) ListBotVersions(ctx context.Context, params *ListBotVersionsInput, optFns ...func(*Options)) (*ListBotVersionsOutput, error) {
	if params == nil {
		params = &ListBotVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBotVersions", params, optFns, c.addOperationListBotVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBotVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBotVersionsInput struct {

	// The identifier of the bot to list versions for.
	//
	// This member is required.
	BotId *string

	// The maximum number of versions to return in each page of results. If there are
	// fewer results than the max page size, only the actual number of results are
	// returned.
	MaxResults *int32

	// If the response to the ListBotVersion operation contains more results than
	// specified in the maxResults parameter, a token is returned in the response. Use
	// that token in the nextToken parameter to return the next page of results.
	NextToken *string

	// Specifies sorting parameters for the list of versions. You can specify that the
	// list be sorted by version name in either ascending or descending order.
	SortBy *types.BotVersionSortBy

	noSmithyDocumentSerde
}

type ListBotVersionsOutput struct {

	// The identifier of the bot to list versions for.
	BotId *string

	// Summary information for the bot versions that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more versions available, the nextToken field
	// contains a token to get the next page of results.
	BotVersionSummaries []types.BotVersionSummary

	// A token that indicates whether there are more results to return in a response to
	// the ListBotVersions operation. If the nextToken field is present, you send the
	// contents as the nextToken parameter of a ListBotAliases operation request to get
	// the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBotVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListBotVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListBotVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListBotVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBotVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBotVersionsAPIClient is a client that implements the ListBotVersions
// operation.
type ListBotVersionsAPIClient interface {
	ListBotVersions(context.Context, *ListBotVersionsInput, ...func(*Options)) (*ListBotVersionsOutput, error)
}

var _ ListBotVersionsAPIClient = (*Client)(nil)

// ListBotVersionsPaginatorOptions is the paginator options for ListBotVersions
type ListBotVersionsPaginatorOptions struct {
	// The maximum number of versions to return in each page of results. If there are
	// fewer results than the max page size, only the actual number of results are
	// returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBotVersionsPaginator is a paginator for ListBotVersions
type ListBotVersionsPaginator struct {
	options   ListBotVersionsPaginatorOptions
	client    ListBotVersionsAPIClient
	params    *ListBotVersionsInput
	nextToken *string
	firstPage bool
}

// NewListBotVersionsPaginator returns a new ListBotVersionsPaginator
func NewListBotVersionsPaginator(client ListBotVersionsAPIClient, params *ListBotVersionsInput, optFns ...func(*ListBotVersionsPaginatorOptions)) *ListBotVersionsPaginator {
	if params == nil {
		params = &ListBotVersionsInput{}
	}

	options := ListBotVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBotVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBotVersionsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListBotVersions page.
func (p *ListBotVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBotVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListBotVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListBotVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "ListBotVersions",
	}
}
