// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticsearchservice

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/elasticsearchservice/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptInboundCrossClusterSearchConnection struct {
}

func (*validateOpAcceptInboundCrossClusterSearchConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptInboundCrossClusterSearchConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptInboundCrossClusterSearchConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptInboundCrossClusterSearchConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddTags struct {
}

func (*validateOpAddTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociatePackage struct {
}

func (*validateOpAssociatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelElasticsearchServiceSoftwareUpdate struct {
}

func (*validateOpCancelElasticsearchServiceSoftwareUpdate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelElasticsearchServiceSoftwareUpdate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelElasticsearchServiceSoftwareUpdateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelElasticsearchServiceSoftwareUpdateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateElasticsearchDomain struct {
}

func (*validateOpCreateElasticsearchDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateElasticsearchDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateElasticsearchDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateElasticsearchDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateOutboundCrossClusterSearchConnection struct {
}

func (*validateOpCreateOutboundCrossClusterSearchConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateOutboundCrossClusterSearchConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateOutboundCrossClusterSearchConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateOutboundCrossClusterSearchConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePackage struct {
}

func (*validateOpCreatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteElasticsearchDomain struct {
}

func (*validateOpDeleteElasticsearchDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteElasticsearchDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteElasticsearchDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteElasticsearchDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInboundCrossClusterSearchConnection struct {
}

func (*validateOpDeleteInboundCrossClusterSearchConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInboundCrossClusterSearchConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInboundCrossClusterSearchConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInboundCrossClusterSearchConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteOutboundCrossClusterSearchConnection struct {
}

func (*validateOpDeleteOutboundCrossClusterSearchConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteOutboundCrossClusterSearchConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteOutboundCrossClusterSearchConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteOutboundCrossClusterSearchConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePackage struct {
}

func (*validateOpDeletePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainAutoTunes struct {
}

func (*validateOpDescribeDomainAutoTunes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainAutoTunes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainAutoTunesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainAutoTunesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeElasticsearchDomainConfig struct {
}

func (*validateOpDescribeElasticsearchDomainConfig) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeElasticsearchDomainConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeElasticsearchDomainConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeElasticsearchDomainConfigInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeElasticsearchDomain struct {
}

func (*validateOpDescribeElasticsearchDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeElasticsearchDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeElasticsearchDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeElasticsearchDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeElasticsearchDomains struct {
}

func (*validateOpDescribeElasticsearchDomains) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeElasticsearchDomains) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeElasticsearchDomainsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeElasticsearchDomainsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeElasticsearchInstanceTypeLimits struct {
}

func (*validateOpDescribeElasticsearchInstanceTypeLimits) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeElasticsearchInstanceTypeLimits) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeElasticsearchInstanceTypeLimitsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeElasticsearchInstanceTypeLimitsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDissociatePackage struct {
}

func (*validateOpDissociatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDissociatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DissociatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDissociatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPackageVersionHistory struct {
}

func (*validateOpGetPackageVersionHistory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPackageVersionHistory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPackageVersionHistoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPackageVersionHistoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetUpgradeHistory struct {
}

func (*validateOpGetUpgradeHistory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetUpgradeHistory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetUpgradeHistoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetUpgradeHistoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetUpgradeStatus struct {
}

func (*validateOpGetUpgradeStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetUpgradeStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetUpgradeStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetUpgradeStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDomainsForPackage struct {
}

func (*validateOpListDomainsForPackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDomainsForPackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDomainsForPackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDomainsForPackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListElasticsearchInstanceTypes struct {
}

func (*validateOpListElasticsearchInstanceTypes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListElasticsearchInstanceTypes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListElasticsearchInstanceTypesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListElasticsearchInstanceTypesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPackagesForDomain struct {
}

func (*validateOpListPackagesForDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPackagesForDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPackagesForDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPackagesForDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTags struct {
}

func (*validateOpListTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPurchaseReservedElasticsearchInstanceOffering struct {
}

func (*validateOpPurchaseReservedElasticsearchInstanceOffering) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPurchaseReservedElasticsearchInstanceOffering) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PurchaseReservedElasticsearchInstanceOfferingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPurchaseReservedElasticsearchInstanceOfferingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectInboundCrossClusterSearchConnection struct {
}

func (*validateOpRejectInboundCrossClusterSearchConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectInboundCrossClusterSearchConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectInboundCrossClusterSearchConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectInboundCrossClusterSearchConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveTags struct {
}

func (*validateOpRemoveTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartElasticsearchServiceSoftwareUpdate struct {
}

func (*validateOpStartElasticsearchServiceSoftwareUpdate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartElasticsearchServiceSoftwareUpdate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartElasticsearchServiceSoftwareUpdateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartElasticsearchServiceSoftwareUpdateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateElasticsearchDomainConfig struct {
}

func (*validateOpUpdateElasticsearchDomainConfig) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateElasticsearchDomainConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateElasticsearchDomainConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateElasticsearchDomainConfigInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePackage struct {
}

func (*validateOpUpdatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpgradeElasticsearchDomain struct {
}

func (*validateOpUpgradeElasticsearchDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpgradeElasticsearchDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpgradeElasticsearchDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpgradeElasticsearchDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptInboundCrossClusterSearchConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptInboundCrossClusterSearchConnection{}, middleware.After)
}

func addOpAddTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddTags{}, middleware.After)
}

func addOpAssociatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociatePackage{}, middleware.After)
}

func addOpCancelElasticsearchServiceSoftwareUpdateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelElasticsearchServiceSoftwareUpdate{}, middleware.After)
}

func addOpCreateElasticsearchDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateElasticsearchDomain{}, middleware.After)
}

func addOpCreateOutboundCrossClusterSearchConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateOutboundCrossClusterSearchConnection{}, middleware.After)
}

func addOpCreatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePackage{}, middleware.After)
}

func addOpDeleteElasticsearchDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteElasticsearchDomain{}, middleware.After)
}

func addOpDeleteInboundCrossClusterSearchConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInboundCrossClusterSearchConnection{}, middleware.After)
}

func addOpDeleteOutboundCrossClusterSearchConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteOutboundCrossClusterSearchConnection{}, middleware.After)
}

func addOpDeletePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePackage{}, middleware.After)
}

func addOpDescribeDomainAutoTunesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainAutoTunes{}, middleware.After)
}

func addOpDescribeElasticsearchDomainConfigValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeElasticsearchDomainConfig{}, middleware.After)
}

func addOpDescribeElasticsearchDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeElasticsearchDomain{}, middleware.After)
}

func addOpDescribeElasticsearchDomainsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeElasticsearchDomains{}, middleware.After)
}

func addOpDescribeElasticsearchInstanceTypeLimitsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeElasticsearchInstanceTypeLimits{}, middleware.After)
}

func addOpDissociatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDissociatePackage{}, middleware.After)
}

func addOpGetPackageVersionHistoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPackageVersionHistory{}, middleware.After)
}

func addOpGetUpgradeHistoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetUpgradeHistory{}, middleware.After)
}

func addOpGetUpgradeStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetUpgradeStatus{}, middleware.After)
}

func addOpListDomainsForPackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDomainsForPackage{}, middleware.After)
}

func addOpListElasticsearchInstanceTypesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListElasticsearchInstanceTypes{}, middleware.After)
}

func addOpListPackagesForDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPackagesForDomain{}, middleware.After)
}

func addOpListTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTags{}, middleware.After)
}

func addOpPurchaseReservedElasticsearchInstanceOfferingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPurchaseReservedElasticsearchInstanceOffering{}, middleware.After)
}

func addOpRejectInboundCrossClusterSearchConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectInboundCrossClusterSearchConnection{}, middleware.After)
}

func addOpRemoveTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveTags{}, middleware.After)
}

func addOpStartElasticsearchServiceSoftwareUpdateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartElasticsearchServiceSoftwareUpdate{}, middleware.After)
}

func addOpUpdateElasticsearchDomainConfigValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateElasticsearchDomainConfig{}, middleware.After)
}

func addOpUpdatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePackage{}, middleware.After)
}

func addOpUpgradeElasticsearchDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpgradeElasticsearchDomain{}, middleware.After)
}

func validateAdvancedSecurityOptionsInput(v *types.AdvancedSecurityOptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AdvancedSecurityOptionsInput"}
	if v.SAMLOptions != nil {
		if err := validateSAMLOptionsInput(v.SAMLOptions); err != nil {
			invalidParams.AddNested("SAMLOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateColdStorageOptions(v *types.ColdStorageOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ColdStorageOptions"}
	if v.Enabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Enabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDomainInformation(v *types.DomainInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DomainInformation"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateElasticsearchClusterConfig(v *types.ElasticsearchClusterConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ElasticsearchClusterConfig"}
	if v.ColdStorageOptions != nil {
		if err := validateColdStorageOptions(v.ColdStorageOptions); err != nil {
			invalidParams.AddNested("ColdStorageOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAMLIdp(v *types.SAMLIdp) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAMLIdp"}
	if v.MetadataContent == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataContent"))
	}
	if v.EntityId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAMLOptionsInput(v *types.SAMLOptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAMLOptionsInput"}
	if v.Idp != nil {
		if err := validateSAMLIdp(v.Idp); err != nil {
			invalidParams.AddNested("Idp", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptInboundCrossClusterSearchConnectionInput(v *AcceptInboundCrossClusterSearchConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptInboundCrossClusterSearchConnectionInput"}
	if v.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddTagsInput(v *AddTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if v.TagList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagList"))
	} else if v.TagList != nil {
		if err := validateTagList(v.TagList); err != nil {
			invalidParams.AddNested("TagList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociatePackageInput(v *AssociatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelElasticsearchServiceSoftwareUpdateInput(v *CancelElasticsearchServiceSoftwareUpdateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelElasticsearchServiceSoftwareUpdateInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateElasticsearchDomainInput(v *CreateElasticsearchDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateElasticsearchDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.ElasticsearchClusterConfig != nil {
		if err := validateElasticsearchClusterConfig(v.ElasticsearchClusterConfig); err != nil {
			invalidParams.AddNested("ElasticsearchClusterConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdvancedSecurityOptions != nil {
		if err := validateAdvancedSecurityOptionsInput(v.AdvancedSecurityOptions); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.TagList != nil {
		if err := validateTagList(v.TagList); err != nil {
			invalidParams.AddNested("TagList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateOutboundCrossClusterSearchConnectionInput(v *CreateOutboundCrossClusterSearchConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOutboundCrossClusterSearchConnectionInput"}
	if v.SourceDomainInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceDomainInfo"))
	} else if v.SourceDomainInfo != nil {
		if err := validateDomainInformation(v.SourceDomainInfo); err != nil {
			invalidParams.AddNested("SourceDomainInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationDomainInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationDomainInfo"))
	} else if v.DestinationDomainInfo != nil {
		if err := validateDomainInformation(v.DestinationDomainInfo); err != nil {
			invalidParams.AddNested("DestinationDomainInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectionAlias == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionAlias"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePackageInput(v *CreatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePackageInput"}
	if v.PackageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageName"))
	}
	if len(v.PackageType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PackageType"))
	}
	if v.PackageSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteElasticsearchDomainInput(v *DeleteElasticsearchDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteElasticsearchDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInboundCrossClusterSearchConnectionInput(v *DeleteInboundCrossClusterSearchConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInboundCrossClusterSearchConnectionInput"}
	if v.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteOutboundCrossClusterSearchConnectionInput(v *DeleteOutboundCrossClusterSearchConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteOutboundCrossClusterSearchConnectionInput"}
	if v.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePackageInput(v *DeletePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainAutoTunesInput(v *DescribeDomainAutoTunesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainAutoTunesInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeElasticsearchDomainConfigInput(v *DescribeElasticsearchDomainConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeElasticsearchDomainConfigInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeElasticsearchDomainInput(v *DescribeElasticsearchDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeElasticsearchDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeElasticsearchDomainsInput(v *DescribeElasticsearchDomainsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeElasticsearchDomainsInput"}
	if v.DomainNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeElasticsearchInstanceTypeLimitsInput(v *DescribeElasticsearchInstanceTypeLimitsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeElasticsearchInstanceTypeLimitsInput"}
	if len(v.InstanceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceType"))
	}
	if v.ElasticsearchVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ElasticsearchVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDissociatePackageInput(v *DissociatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DissociatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPackageVersionHistoryInput(v *GetPackageVersionHistoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPackageVersionHistoryInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetUpgradeHistoryInput(v *GetUpgradeHistoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetUpgradeHistoryInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetUpgradeStatusInput(v *GetUpgradeStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetUpgradeStatusInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDomainsForPackageInput(v *ListDomainsForPackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDomainsForPackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListElasticsearchInstanceTypesInput(v *ListElasticsearchInstanceTypesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListElasticsearchInstanceTypesInput"}
	if v.ElasticsearchVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ElasticsearchVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPackagesForDomainInput(v *ListPackagesForDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPackagesForDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsInput(v *ListTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPurchaseReservedElasticsearchInstanceOfferingInput(v *PurchaseReservedElasticsearchInstanceOfferingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PurchaseReservedElasticsearchInstanceOfferingInput"}
	if v.ReservedElasticsearchInstanceOfferingId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReservedElasticsearchInstanceOfferingId"))
	}
	if v.ReservationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReservationName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectInboundCrossClusterSearchConnectionInput(v *RejectInboundCrossClusterSearchConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectInboundCrossClusterSearchConnectionInput"}
	if v.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveTagsInput(v *RemoveTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartElasticsearchServiceSoftwareUpdateInput(v *StartElasticsearchServiceSoftwareUpdateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartElasticsearchServiceSoftwareUpdateInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateElasticsearchDomainConfigInput(v *UpdateElasticsearchDomainConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateElasticsearchDomainConfigInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.ElasticsearchClusterConfig != nil {
		if err := validateElasticsearchClusterConfig(v.ElasticsearchClusterConfig); err != nil {
			invalidParams.AddNested("ElasticsearchClusterConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdvancedSecurityOptions != nil {
		if err := validateAdvancedSecurityOptionsInput(v.AdvancedSecurityOptions); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePackageInput(v *UpdatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.PackageSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpgradeElasticsearchDomainInput(v *UpgradeElasticsearchDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpgradeElasticsearchDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.TargetVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
