// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Geocodes free-form text, such as an address, name, city, or region to allow you
// to search for Places or points of interest. Includes the option to apply
// additional parameters to narrow your list of results. You can search for places
// near a given position using BiasPosition, or filter results within a bounding
// box using FilterBBox. Providing both parameters simultaneously returns an error.
func (c *Client) SearchPlaceIndexForText(ctx context.Context, params *SearchPlaceIndexForTextInput, optFns ...func(*Options)) (*SearchPlaceIndexForTextOutput, error) {
	if params == nil {
		params = &SearchPlaceIndexForTextInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchPlaceIndexForText", params, optFns, c.addOperationSearchPlaceIndexForTextMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchPlaceIndexForTextOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchPlaceIndexForTextInput struct {

	// The name of the place index resource you want to use for the search.
	//
	// This member is required.
	IndexName *string

	// The address, name, city, or region to be used in the search. In free-form text
	// format. For example, 123 Any Street.
	//
	// This member is required.
	Text *string

	// Searches for results closest to the given position. An optional parameter
	// defined by longitude, and latitude.
	//
	// * The first bias position is the X
	// coordinate, or longitude.
	//
	// * The second bias position is the Y coordinate, or
	// latitude.
	//
	// For example, bias=xLongitude&bias=yLatitude.
	BiasPosition []float64

	// Filters the results by returning only Places within the provided bounding box.
	// An optional parameter. The first 2 bbox parameters describe the lower southwest
	// corner:
	//
	// * The first bbox position is the X coordinate or longitude of the lower
	// southwest corner.
	//
	// * The second bbox position is the Y coordinate or latitude of
	// the lower southwest corner.
	//
	// For example, bbox=xLongitudeSW&bbox=yLatitudeSW.
	// The next bbox parameters describe the upper northeast corner:
	//
	// * The third bbox
	// position is the X coordinate, or longitude of the upper northeast corner.
	//
	// * The
	// fourth bbox position is the Y coordinate, or longitude of the upper northeast
	// corner.
	//
	// For example, bbox=xLongitudeNE&bbox=yLatitudeNE
	FilterBBox []float64

	// Limits the search to the given a list of countries/regions. An optional
	// parameter.
	//
	// * Use the ISO 3166 (https://www.iso.org/iso-3166-country-codes.html)
	// 3-digit country code. For example, Australia uses three upper-case characters:
	// AUS.
	FilterCountries []string

	// An optional parameter. The maximum number of results returned per request. The
	// default: 50
	MaxResults int32

	noSmithyDocumentSerde
}

type SearchPlaceIndexForTextOutput struct {

	// A list of Places closest to the specified position. Each result contains
	// additional information about the specific point of interest.
	//
	// This member is required.
	Results []types.SearchForTextResult

	// Contains a summary of the request. Contains the BiasPosition, DataSource,
	// FilterBBox, FilterCountries, MaxResults, ResultBBox, and Text.
	//
	// This member is required.
	Summary *types.SearchPlaceIndexForTextSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchPlaceIndexForTextMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchPlaceIndexForText{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchPlaceIndexForText{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSearchPlaceIndexForTextValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchPlaceIndexForText(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSearchPlaceIndexForText(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "geo",
		OperationName: "SearchPlaceIndexForText",
	}
}
