// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAddLayerVersionPermission struct {
}

func (*awsRestjson1_serializeOpAddLayerVersionPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddLayerVersionPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddLayerVersionPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddLayerVersionPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddLayerVersionPermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddLayerVersionPermissionInput(v *AddLayerVersionPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	if v.RevisionId != nil {
		encoder.SetQuery("RevisionId").String(*v.RevisionId)
	}

	{
		if err := encoder.SetURI("VersionNumber").Long(v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddLayerVersionPermissionInput(v *AddLayerVersionPermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		ok.String(*v.Action)
	}

	if v.OrganizationId != nil {
		ok := object.Key("OrganizationId")
		ok.String(*v.OrganizationId)
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	if v.StatementId != nil {
		ok := object.Key("StatementId")
		ok.String(*v.StatementId)
	}

	return nil
}

type awsRestjson1_serializeOpAddPermission struct {
}

func (*awsRestjson1_serializeOpAddPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddPermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddPermissionInput(v *AddPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddPermissionInput(v *AddPermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		ok.String(*v.Action)
	}

	if v.EventSourceToken != nil {
		ok := object.Key("EventSourceToken")
		ok.String(*v.EventSourceToken)
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	if v.SourceAccount != nil {
		ok := object.Key("SourceAccount")
		ok.String(*v.SourceAccount)
	}

	if v.SourceArn != nil {
		ok := object.Key("SourceArn")
		ok.String(*v.SourceArn)
	}

	if v.StatementId != nil {
		ok := object.Key("StatementId")
		ok.String(*v.StatementId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAlias struct {
}

func (*awsRestjson1_serializeOpCreateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAliasInput(v *CreateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAliasInput(v *CreateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FunctionVersion != nil {
		ok := object.Key("FunctionVersion")
		ok.String(*v.FunctionVersion)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoutingConfig != nil {
		ok := object.Key("RoutingConfig")
		if err := awsRestjson1_serializeDocumentAliasRoutingConfiguration(v.RoutingConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpCreateCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCodeSigningConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCodeSigningConfigInput(v *CreateCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCodeSigningConfigInput(v *CreateCodeSigningConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedPublishers != nil {
		ok := object.Key("AllowedPublishers")
		if err := awsRestjson1_serializeDocumentAllowedPublishers(v.AllowedPublishers, ok); err != nil {
			return err
		}
	}

	if v.CodeSigningPolicies != nil {
		ok := object.Key("CodeSigningPolicies")
		if err := awsRestjson1_serializeDocumentCodeSigningPolicies(v.CodeSigningPolicies, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpCreateEventSourceMapping struct {
}

func (*awsRestjson1_serializeOpCreateEventSourceMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEventSourceMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEventSourceMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/event-source-mappings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEventSourceMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEventSourceMappingInput(v *CreateEventSourceMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEventSourceMappingInput(v *CreateEventSourceMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.BisectBatchOnFunctionError != nil {
		ok := object.Key("BisectBatchOnFunctionError")
		ok.Boolean(*v.BisectBatchOnFunctionError)
	}

	if v.DestinationConfig != nil {
		ok := object.Key("DestinationConfig")
		if err := awsRestjson1_serializeDocumentDestinationConfig(v.DestinationConfig, ok); err != nil {
			return err
		}
	}

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.EventSourceArn != nil {
		ok := object.Key("EventSourceArn")
		ok.String(*v.EventSourceArn)
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.FunctionResponseTypes != nil {
		ok := object.Key("FunctionResponseTypes")
		if err := awsRestjson1_serializeDocumentFunctionResponseTypeList(v.FunctionResponseTypes, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	if v.Queues != nil {
		ok := object.Key("Queues")
		if err := awsRestjson1_serializeDocumentQueues(v.Queues, ok); err != nil {
			return err
		}
	}

	if v.SelfManagedEventSource != nil {
		ok := object.Key("SelfManagedEventSource")
		if err := awsRestjson1_serializeDocumentSelfManagedEventSource(v.SelfManagedEventSource, ok); err != nil {
			return err
		}
	}

	if v.SourceAccessConfigurations != nil {
		ok := object.Key("SourceAccessConfigurations")
		if err := awsRestjson1_serializeDocumentSourceAccessConfigurations(v.SourceAccessConfigurations, ok); err != nil {
			return err
		}
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	if v.StartingPositionTimestamp != nil {
		ok := object.Key("StartingPositionTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartingPositionTimestamp))
	}

	if v.Topics != nil {
		ok := object.Key("Topics")
		if err := awsRestjson1_serializeDocumentTopics(v.Topics, ok); err != nil {
			return err
		}
	}

	if v.TumblingWindowInSeconds != nil {
		ok := object.Key("TumblingWindowInSeconds")
		ok.Integer(*v.TumblingWindowInSeconds)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFunction struct {
}

func (*awsRestjson1_serializeOpCreateFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFunctionInput(v *CreateFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFunctionInput(v *CreateFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("Code")
		if err := awsRestjson1_serializeDocumentFunctionCode(v.Code, ok); err != nil {
			return err
		}
	}

	if v.CodeSigningConfigArn != nil {
		ok := object.Key("CodeSigningConfigArn")
		ok.String(*v.CodeSigningConfigArn)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentEnvironment(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.FileSystemConfigs != nil {
		ok := object.Key("FileSystemConfigs")
		if err := awsRestjson1_serializeDocumentFileSystemConfigList(v.FileSystemConfigs, ok); err != nil {
			return err
		}
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.Handler != nil {
		ok := object.Key("Handler")
		ok.String(*v.Handler)
	}

	if v.ImageConfig != nil {
		ok := object.Key("ImageConfig")
		if err := awsRestjson1_serializeDocumentImageConfig(v.ImageConfig, ok); err != nil {
			return err
		}
	}

	if v.KMSKeyArn != nil {
		ok := object.Key("KMSKeyArn")
		ok.String(*v.KMSKeyArn)
	}

	if v.Layers != nil {
		ok := object.Key("Layers")
		if err := awsRestjson1_serializeDocumentLayerList(v.Layers, ok); err != nil {
			return err
		}
	}

	if v.MemorySize != nil {
		ok := object.Key("MemorySize")
		ok.Integer(*v.MemorySize)
	}

	if len(v.PackageType) > 0 {
		ok := object.Key("PackageType")
		ok.String(string(v.PackageType))
	}

	if v.Publish {
		ok := object.Key("Publish")
		ok.Boolean(v.Publish)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if len(v.Runtime) > 0 {
		ok := object.Key("Runtime")
		ok.String(string(v.Runtime))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if v.TracingConfig != nil {
		ok := object.Key("TracingConfig")
		if err := awsRestjson1_serializeDocumentTracingConfig(v.TracingConfig, ok); err != nil {
			return err
		}
	}

	if v.VpcConfig != nil {
		ok := object.Key("VpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAlias struct {
}

func (*awsRestjson1_serializeOpDeleteAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/aliases/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAliasInput(v *DeleteAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpDeleteCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs/{CodeSigningConfigArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCodeSigningConfigInput(v *DeleteCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeSigningConfigArn == nil || len(*v.CodeSigningConfigArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeSigningConfigArn must not be empty")}
	}
	if v.CodeSigningConfigArn != nil {
		if err := encoder.SetURI("CodeSigningConfigArn").String(*v.CodeSigningConfigArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEventSourceMapping struct {
}

func (*awsRestjson1_serializeOpDeleteEventSourceMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEventSourceMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEventSourceMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/event-source-mappings/{UUID}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEventSourceMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEventSourceMappingInput(v *DeleteEventSourceMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.UUID == nil || len(*v.UUID) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UUID must not be empty")}
	}
	if v.UUID != nil {
		if err := encoder.SetURI("UUID").String(*v.UUID); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFunction struct {
}

func (*awsRestjson1_serializeOpDeleteFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFunctionInput(v *DeleteFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFunctionCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpDeleteFunctionCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFunctionCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-06-30/functions/{FunctionName}/code-signing-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFunctionCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFunctionCodeSigningConfigInput(v *DeleteFunctionCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFunctionConcurrency struct {
}

func (*awsRestjson1_serializeOpDeleteFunctionConcurrency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFunctionConcurrency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionConcurrencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-10-31/functions/{FunctionName}/concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFunctionConcurrencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFunctionConcurrencyInput(v *DeleteFunctionConcurrencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFunctionEventInvokeConfig struct {
}

func (*awsRestjson1_serializeOpDeleteFunctionEventInvokeConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFunctionEventInvokeConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionEventInvokeConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-25/functions/{FunctionName}/event-invoke-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFunctionEventInvokeConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFunctionEventInvokeConfigInput(v *DeleteFunctionEventInvokeConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLayerVersion struct {
}

func (*awsRestjson1_serializeOpDeleteLayerVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLayerVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLayerVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions/{VersionNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLayerVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLayerVersionInput(v *DeleteLayerVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	{
		if err := encoder.SetURI("VersionNumber").Long(v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProvisionedConcurrencyConfig struct {
}

func (*awsRestjson1_serializeOpDeleteProvisionedConcurrencyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProvisionedConcurrencyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProvisionedConcurrencyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-30/functions/{FunctionName}/provisioned-concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProvisionedConcurrencyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProvisionedConcurrencyConfigInput(v *DeleteProvisionedConcurrencyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetAccountSettings struct {
}

func (*awsRestjson1_serializeOpGetAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2016-08-19/account-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAccountSettingsInput(v *GetAccountSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetAlias struct {
}

func (*awsRestjson1_serializeOpGetAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/aliases/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAliasInput(v *GetAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpGetCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs/{CodeSigningConfigArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCodeSigningConfigInput(v *GetCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeSigningConfigArn == nil || len(*v.CodeSigningConfigArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeSigningConfigArn must not be empty")}
	}
	if v.CodeSigningConfigArn != nil {
		if err := encoder.SetURI("CodeSigningConfigArn").String(*v.CodeSigningConfigArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEventSourceMapping struct {
}

func (*awsRestjson1_serializeOpGetEventSourceMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEventSourceMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEventSourceMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/event-source-mappings/{UUID}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEventSourceMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEventSourceMappingInput(v *GetEventSourceMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.UUID == nil || len(*v.UUID) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UUID must not be empty")}
	}
	if v.UUID != nil {
		if err := encoder.SetURI("UUID").String(*v.UUID); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFunction struct {
}

func (*awsRestjson1_serializeOpGetFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionInput(v *GetFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetFunctionCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpGetFunctionCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunctionCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-06-30/functions/{FunctionName}/code-signing-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionCodeSigningConfigInput(v *GetFunctionCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFunctionConcurrency struct {
}

func (*awsRestjson1_serializeOpGetFunctionConcurrency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunctionConcurrency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionConcurrencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-30/functions/{FunctionName}/concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionConcurrencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionConcurrencyInput(v *GetFunctionConcurrencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFunctionConfiguration struct {
}

func (*awsRestjson1_serializeOpGetFunctionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunctionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionConfigurationInput(v *GetFunctionConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetFunctionEventInvokeConfig struct {
}

func (*awsRestjson1_serializeOpGetFunctionEventInvokeConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunctionEventInvokeConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionEventInvokeConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-25/functions/{FunctionName}/event-invoke-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionEventInvokeConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionEventInvokeConfigInput(v *GetFunctionEventInvokeConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetLayerVersion struct {
}

func (*awsRestjson1_serializeOpGetLayerVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLayerVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLayerVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions/{VersionNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLayerVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLayerVersionInput(v *GetLayerVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	{
		if err := encoder.SetURI("VersionNumber").Long(v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLayerVersionByArn struct {
}

func (*awsRestjson1_serializeOpGetLayerVersionByArn) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLayerVersionByArn) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLayerVersionByArnInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers?find=LayerVersion")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLayerVersionByArnInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLayerVersionByArnInput(v *GetLayerVersionByArnInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn != nil {
		encoder.SetQuery("Arn").String(*v.Arn)
	}

	return nil
}

type awsRestjson1_serializeOpGetLayerVersionPolicy struct {
}

func (*awsRestjson1_serializeOpGetLayerVersionPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLayerVersionPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLayerVersionPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLayerVersionPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLayerVersionPolicyInput(v *GetLayerVersionPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	{
		if err := encoder.SetURI("VersionNumber").Long(v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPolicy struct {
}

func (*awsRestjson1_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPolicyInput(v *GetPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetProvisionedConcurrencyConfig struct {
}

func (*awsRestjson1_serializeOpGetProvisionedConcurrencyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetProvisionedConcurrencyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetProvisionedConcurrencyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-30/functions/{FunctionName}/provisioned-concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetProvisionedConcurrencyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetProvisionedConcurrencyConfigInput(v *GetProvisionedConcurrencyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpInvoke struct {
}

func (*awsRestjson1_serializeOpInvoke) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvoke) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/invocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Payload != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := bytes.NewReader(input.Payload)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeInput(v *InvokeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientContext != nil && len(*v.ClientContext) > 0 {
		locationName := "X-Amz-Client-Context"
		encoder.SetHeader(locationName).String(*v.ClientContext)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if len(v.InvocationType) > 0 {
		locationName := "X-Amz-Invocation-Type"
		encoder.SetHeader(locationName).String(string(v.InvocationType))
	}

	if len(v.LogType) > 0 {
		locationName := "X-Amz-Log-Type"
		encoder.SetHeader(locationName).String(string(v.LogType))
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

type awsRestjson1_serializeOpInvokeAsync struct {
}

func (*awsRestjson1_serializeOpInvokeAsync) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeAsync) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeAsyncInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2014-11-13/functions/{FunctionName}/invoke-async")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeAsyncInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InvokeArgs != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := input.InvokeArgs
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeAsyncInput(v *InvokeAsyncInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAliases struct {
}

func (*awsRestjson1_serializeOpListAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAliasesInput(v *ListAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.FunctionVersion != nil {
		encoder.SetQuery("FunctionVersion").String(*v.FunctionVersion)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListCodeSigningConfigs struct {
}

func (*awsRestjson1_serializeOpListCodeSigningConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCodeSigningConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCodeSigningConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCodeSigningConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCodeSigningConfigsInput(v *ListCodeSigningConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListEventSourceMappings struct {
}

func (*awsRestjson1_serializeOpListEventSourceMappings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEventSourceMappings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEventSourceMappingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/event-source-mappings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEventSourceMappingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEventSourceMappingsInput(v *ListEventSourceMappingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EventSourceArn != nil {
		encoder.SetQuery("EventSourceArn").String(*v.EventSourceArn)
	}

	if v.FunctionName != nil {
		encoder.SetQuery("FunctionName").String(*v.FunctionName)
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListFunctionEventInvokeConfigs struct {
}

func (*awsRestjson1_serializeOpListFunctionEventInvokeConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFunctionEventInvokeConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFunctionEventInvokeConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-25/functions/{FunctionName}/event-invoke-config/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFunctionEventInvokeConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFunctionEventInvokeConfigsInput(v *ListFunctionEventInvokeConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListFunctions struct {
}

func (*awsRestjson1_serializeOpListFunctions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFunctions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFunctionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFunctionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFunctionsInput(v *ListFunctionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.FunctionVersion) > 0 {
		encoder.SetQuery("FunctionVersion").String(string(v.FunctionVersion))
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MasterRegion != nil {
		encoder.SetQuery("MasterRegion").String(*v.MasterRegion)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListFunctionsByCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpListFunctionsByCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFunctionsByCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFunctionsByCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs/{CodeSigningConfigArn}/functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFunctionsByCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFunctionsByCodeSigningConfigInput(v *ListFunctionsByCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeSigningConfigArn == nil || len(*v.CodeSigningConfigArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeSigningConfigArn must not be empty")}
	}
	if v.CodeSigningConfigArn != nil {
		if err := encoder.SetURI("CodeSigningConfigArn").String(*v.CodeSigningConfigArn); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListLayers struct {
}

func (*awsRestjson1_serializeOpListLayers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLayers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLayersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLayersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLayersInput(v *ListLayersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.CompatibleRuntime) > 0 {
		encoder.SetQuery("CompatibleRuntime").String(string(v.CompatibleRuntime))
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListLayerVersions struct {
}

func (*awsRestjson1_serializeOpListLayerVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLayerVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLayerVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLayerVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLayerVersionsInput(v *ListLayerVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.CompatibleRuntime) > 0 {
		encoder.SetQuery("CompatibleRuntime").String(string(v.CompatibleRuntime))
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListProvisionedConcurrencyConfigs struct {
}

func (*awsRestjson1_serializeOpListProvisionedConcurrencyConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisionedConcurrencyConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisionedConcurrencyConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-30/functions/{FunctionName}/provisioned-concurrency?List=ALL")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisionedConcurrencyConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisionedConcurrencyConfigsInput(v *ListProvisionedConcurrencyConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpListTags struct {
}

func (*awsRestjson1_serializeOpListTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-03-31/tags/{Resource}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsInput(v *ListTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource == nil || len(*v.Resource) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Resource must not be empty")}
	}
	if v.Resource != nil {
		if err := encoder.SetURI("Resource").String(*v.Resource); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListVersionsByFunction struct {
}

func (*awsRestjson1_serializeOpListVersionsByFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVersionsByFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVersionsByFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVersionsByFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVersionsByFunctionInput(v *ListVersionsByFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("Marker").String(*v.Marker)
	}

	if v.MaxItems != nil {
		encoder.SetQuery("MaxItems").Integer(*v.MaxItems)
	}

	return nil
}

type awsRestjson1_serializeOpPublishLayerVersion struct {
}

func (*awsRestjson1_serializeOpPublishLayerVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPublishLayerVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PublishLayerVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPublishLayerVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPublishLayerVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPublishLayerVersionInput(v *PublishLayerVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPublishLayerVersionInput(v *PublishLayerVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompatibleRuntimes != nil {
		ok := object.Key("CompatibleRuntimes")
		if err := awsRestjson1_serializeDocumentCompatibleRuntimes(v.CompatibleRuntimes, ok); err != nil {
			return err
		}
	}

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentLayerVersionContentInput(v.Content, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LicenseInfo != nil {
		ok := object.Key("LicenseInfo")
		ok.String(*v.LicenseInfo)
	}

	return nil
}

type awsRestjson1_serializeOpPublishVersion struct {
}

func (*awsRestjson1_serializeOpPublishVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPublishVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PublishVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPublishVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPublishVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPublishVersionInput(v *PublishVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPublishVersionInput(v *PublishVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeSha256 != nil {
		ok := object.Key("CodeSha256")
		ok.String(*v.CodeSha256)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	return nil
}

type awsRestjson1_serializeOpPutFunctionCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpPutFunctionCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFunctionCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFunctionCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-06-30/functions/{FunctionName}/code-signing-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutFunctionCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFunctionCodeSigningConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFunctionCodeSigningConfigInput(v *PutFunctionCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFunctionCodeSigningConfigInput(v *PutFunctionCodeSigningConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeSigningConfigArn != nil {
		ok := object.Key("CodeSigningConfigArn")
		ok.String(*v.CodeSigningConfigArn)
	}

	return nil
}

type awsRestjson1_serializeOpPutFunctionConcurrency struct {
}

func (*awsRestjson1_serializeOpPutFunctionConcurrency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFunctionConcurrency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFunctionConcurrencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-10-31/functions/{FunctionName}/concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutFunctionConcurrencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFunctionConcurrencyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFunctionConcurrencyInput(v *PutFunctionConcurrencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFunctionConcurrencyInput(v *PutFunctionConcurrencyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReservedConcurrentExecutions != nil {
		ok := object.Key("ReservedConcurrentExecutions")
		ok.Integer(*v.ReservedConcurrentExecutions)
	}

	return nil
}

type awsRestjson1_serializeOpPutFunctionEventInvokeConfig struct {
}

func (*awsRestjson1_serializeOpPutFunctionEventInvokeConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFunctionEventInvokeConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFunctionEventInvokeConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-25/functions/{FunctionName}/event-invoke-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutFunctionEventInvokeConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFunctionEventInvokeConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFunctionEventInvokeConfigInput(v *PutFunctionEventInvokeConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFunctionEventInvokeConfigInput(v *PutFunctionEventInvokeConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationConfig != nil {
		ok := object.Key("DestinationConfig")
		if err := awsRestjson1_serializeDocumentDestinationConfig(v.DestinationConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumEventAgeInSeconds != nil {
		ok := object.Key("MaximumEventAgeInSeconds")
		ok.Integer(*v.MaximumEventAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	return nil
}

type awsRestjson1_serializeOpPutProvisionedConcurrencyConfig struct {
}

func (*awsRestjson1_serializeOpPutProvisionedConcurrencyConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutProvisionedConcurrencyConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutProvisionedConcurrencyConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-30/functions/{FunctionName}/provisioned-concurrency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutProvisionedConcurrencyConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutProvisionedConcurrencyConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutProvisionedConcurrencyConfigInput(v *PutProvisionedConcurrencyConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutProvisionedConcurrencyConfigInput(v *PutProvisionedConcurrencyConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProvisionedConcurrentExecutions != nil {
		ok := object.Key("ProvisionedConcurrentExecutions")
		ok.Integer(*v.ProvisionedConcurrentExecutions)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveLayerVersionPermission struct {
}

func (*awsRestjson1_serializeOpRemoveLayerVersionPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveLayerVersionPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveLayerVersionPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveLayerVersionPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveLayerVersionPermissionInput(v *RemoveLayerVersionPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LayerName == nil || len(*v.LayerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LayerName must not be empty")}
	}
	if v.LayerName != nil {
		if err := encoder.SetURI("LayerName").String(*v.LayerName); err != nil {
			return err
		}
	}

	if v.RevisionId != nil {
		encoder.SetQuery("RevisionId").String(*v.RevisionId)
	}

	if v.StatementId == nil || len(*v.StatementId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StatementId must not be empty")}
	}
	if v.StatementId != nil {
		if err := encoder.SetURI("StatementId").String(*v.StatementId); err != nil {
			return err
		}
	}

	{
		if err := encoder.SetURI("VersionNumber").Long(v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemovePermission struct {
}

func (*awsRestjson1_serializeOpRemovePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemovePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemovePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/policy/{StatementId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemovePermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemovePermissionInput(v *RemovePermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	if v.RevisionId != nil {
		encoder.SetQuery("RevisionId").String(*v.RevisionId)
	}

	if v.StatementId == nil || len(*v.StatementId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StatementId must not be empty")}
	}
	if v.StatementId != nil {
		if err := encoder.SetURI("StatementId").String(*v.StatementId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-03-31/tags/{Resource}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource == nil || len(*v.Resource) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Resource must not be empty")}
	}
	if v.Resource != nil {
		if err := encoder.SetURI("Resource").String(*v.Resource); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-03-31/tags/{Resource}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Resource == nil || len(*v.Resource) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Resource must not be empty")}
	}
	if v.Resource != nil {
		if err := encoder.SetURI("Resource").String(*v.Resource); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAlias struct {
}

func (*awsRestjson1_serializeOpUpdateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/aliases/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAliasInput(v *UpdateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAliasInput(v *UpdateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FunctionVersion != nil {
		ok := object.Key("FunctionVersion")
		ok.String(*v.FunctionVersion)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	if v.RoutingConfig != nil {
		ok := object.Key("RoutingConfig")
		if err := awsRestjson1_serializeDocumentAliasRoutingConfiguration(v.RoutingConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCodeSigningConfig struct {
}

func (*awsRestjson1_serializeOpUpdateCodeSigningConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCodeSigningConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCodeSigningConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-04-22/code-signing-configs/{CodeSigningConfigArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateCodeSigningConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateCodeSigningConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCodeSigningConfigInput(v *UpdateCodeSigningConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CodeSigningConfigArn == nil || len(*v.CodeSigningConfigArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CodeSigningConfigArn must not be empty")}
	}
	if v.CodeSigningConfigArn != nil {
		if err := encoder.SetURI("CodeSigningConfigArn").String(*v.CodeSigningConfigArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateCodeSigningConfigInput(v *UpdateCodeSigningConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedPublishers != nil {
		ok := object.Key("AllowedPublishers")
		if err := awsRestjson1_serializeDocumentAllowedPublishers(v.AllowedPublishers, ok); err != nil {
			return err
		}
	}

	if v.CodeSigningPolicies != nil {
		ok := object.Key("CodeSigningPolicies")
		if err := awsRestjson1_serializeDocumentCodeSigningPolicies(v.CodeSigningPolicies, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEventSourceMapping struct {
}

func (*awsRestjson1_serializeOpUpdateEventSourceMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEventSourceMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEventSourceMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/event-source-mappings/{UUID}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEventSourceMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEventSourceMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEventSourceMappingInput(v *UpdateEventSourceMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.UUID == nil || len(*v.UUID) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UUID must not be empty")}
	}
	if v.UUID != nil {
		if err := encoder.SetURI("UUID").String(*v.UUID); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEventSourceMappingInput(v *UpdateEventSourceMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.BisectBatchOnFunctionError != nil {
		ok := object.Key("BisectBatchOnFunctionError")
		ok.Boolean(*v.BisectBatchOnFunctionError)
	}

	if v.DestinationConfig != nil {
		ok := object.Key("DestinationConfig")
		if err := awsRestjson1_serializeDocumentDestinationConfig(v.DestinationConfig, ok); err != nil {
			return err
		}
	}

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.FunctionResponseTypes != nil {
		ok := object.Key("FunctionResponseTypes")
		if err := awsRestjson1_serializeDocumentFunctionResponseTypeList(v.FunctionResponseTypes, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	if v.SourceAccessConfigurations != nil {
		ok := object.Key("SourceAccessConfigurations")
		if err := awsRestjson1_serializeDocumentSourceAccessConfigurations(v.SourceAccessConfigurations, ok); err != nil {
			return err
		}
	}

	if v.TumblingWindowInSeconds != nil {
		ok := object.Key("TumblingWindowInSeconds")
		ok.Integer(*v.TumblingWindowInSeconds)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFunctionCode struct {
}

func (*awsRestjson1_serializeOpUpdateFunctionCode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFunctionCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFunctionCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/code")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFunctionCodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFunctionCodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFunctionCodeInput(v *UpdateFunctionCodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFunctionCodeInput(v *UpdateFunctionCodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.ImageUri != nil {
		ok := object.Key("ImageUri")
		ok.String(*v.ImageUri)
	}

	if v.Publish {
		ok := object.Key("Publish")
		ok.Boolean(v.Publish)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3Key != nil {
		ok := object.Key("S3Key")
		ok.String(*v.S3Key)
	}

	if v.S3ObjectVersion != nil {
		ok := object.Key("S3ObjectVersion")
		ok.String(*v.S3ObjectVersion)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.Base64EncodeBytes(v.ZipFile)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFunctionConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateFunctionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFunctionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFunctionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2015-03-31/functions/{FunctionName}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFunctionConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFunctionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFunctionConfigurationInput(v *UpdateFunctionConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFunctionConfigurationInput(v *UpdateFunctionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentEnvironment(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.FileSystemConfigs != nil {
		ok := object.Key("FileSystemConfigs")
		if err := awsRestjson1_serializeDocumentFileSystemConfigList(v.FileSystemConfigs, ok); err != nil {
			return err
		}
	}

	if v.Handler != nil {
		ok := object.Key("Handler")
		ok.String(*v.Handler)
	}

	if v.ImageConfig != nil {
		ok := object.Key("ImageConfig")
		if err := awsRestjson1_serializeDocumentImageConfig(v.ImageConfig, ok); err != nil {
			return err
		}
	}

	if v.KMSKeyArn != nil {
		ok := object.Key("KMSKeyArn")
		ok.String(*v.KMSKeyArn)
	}

	if v.Layers != nil {
		ok := object.Key("Layers")
		if err := awsRestjson1_serializeDocumentLayerList(v.Layers, ok); err != nil {
			return err
		}
	}

	if v.MemorySize != nil {
		ok := object.Key("MemorySize")
		ok.Integer(*v.MemorySize)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if len(v.Runtime) > 0 {
		ok := object.Key("Runtime")
		ok.String(string(v.Runtime))
	}

	if v.Timeout != nil {
		ok := object.Key("Timeout")
		ok.Integer(*v.Timeout)
	}

	if v.TracingConfig != nil {
		ok := object.Key("TracingConfig")
		if err := awsRestjson1_serializeDocumentTracingConfig(v.TracingConfig, ok); err != nil {
			return err
		}
	}

	if v.VpcConfig != nil {
		ok := object.Key("VpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFunctionEventInvokeConfig struct {
}

func (*awsRestjson1_serializeOpUpdateFunctionEventInvokeConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFunctionEventInvokeConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFunctionEventInvokeConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2019-09-25/functions/{FunctionName}/event-invoke-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFunctionEventInvokeConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFunctionEventInvokeConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFunctionEventInvokeConfigInput(v *UpdateFunctionEventInvokeConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FunctionName == nil || len(*v.FunctionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FunctionName must not be empty")}
	}
	if v.FunctionName != nil {
		if err := encoder.SetURI("FunctionName").String(*v.FunctionName); err != nil {
			return err
		}
	}

	if v.Qualifier != nil {
		encoder.SetQuery("Qualifier").String(*v.Qualifier)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFunctionEventInvokeConfigInput(v *UpdateFunctionEventInvokeConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationConfig != nil {
		ok := object.Key("DestinationConfig")
		if err := awsRestjson1_serializeDocumentDestinationConfig(v.DestinationConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumEventAgeInSeconds != nil {
		ok := object.Key("MaximumEventAgeInSeconds")
		ok.Integer(*v.MaximumEventAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalVersionWeights(v map[string]float64, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		switch {
		case math.IsNaN(v[key]):
			om.String("NaN")

		case math.IsInf(v[key], 1):
			om.String("Infinity")

		case math.IsInf(v[key], -1):
			om.String("-Infinity")

		default:
			om.Double(v[key])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAliasRoutingConfiguration(v *types.AliasRoutingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalVersionWeights != nil {
		ok := object.Key("AdditionalVersionWeights")
		if err := awsRestjson1_serializeDocumentAdditionalVersionWeights(v.AdditionalVersionWeights, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAllowedPublishers(v *types.AllowedPublishers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SigningProfileVersionArns != nil {
		ok := object.Key("SigningProfileVersionArns")
		if err := awsRestjson1_serializeDocumentSigningProfileVersionArns(v.SigningProfileVersionArns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeSigningPolicies(v *types.CodeSigningPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.UntrustedArtifactOnDeployment) > 0 {
		ok := object.Key("UntrustedArtifactOnDeployment")
		ok.String(string(v.UntrustedArtifactOnDeployment))
	}

	return nil
}

func awsRestjson1_serializeDocumentCompatibleRuntimes(v []types.Runtime, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDeadLetterConfig(v *types.DeadLetterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetArn != nil {
		ok := object.Key("TargetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationConfig(v *types.DestinationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OnFailure != nil {
		ok := object.Key("OnFailure")
		if err := awsRestjson1_serializeDocumentOnFailure(v.OnFailure, ok); err != nil {
			return err
		}
	}

	if v.OnSuccess != nil {
		ok := object.Key("OnSuccess")
		if err := awsRestjson1_serializeDocumentOnSuccess(v.OnSuccess, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointLists(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEndpoints(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentEndpointLists(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEnvironment(v *types.Environment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Variables != nil {
		ok := object.Key("Variables")
		if err := awsRestjson1_serializeDocumentEnvironmentVariables(v.Variables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEnvironmentVariables(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentFileSystemConfig(v *types.FileSystemConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.LocalMountPath != nil {
		ok := object.Key("LocalMountPath")
		ok.String(*v.LocalMountPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentFileSystemConfigList(v []types.FileSystemConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFileSystemConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFunctionCode(v *types.FunctionCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImageUri != nil {
		ok := object.Key("ImageUri")
		ok.String(*v.ImageUri)
	}

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3Key != nil {
		ok := object.Key("S3Key")
		ok.String(*v.S3Key)
	}

	if v.S3ObjectVersion != nil {
		ok := object.Key("S3ObjectVersion")
		ok.String(*v.S3ObjectVersion)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.Base64EncodeBytes(v.ZipFile)
	}

	return nil
}

func awsRestjson1_serializeDocumentFunctionResponseTypeList(v []types.FunctionResponseType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentImageConfig(v *types.ImageConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsRestjson1_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.EntryPoint != nil {
		ok := object.Key("EntryPoint")
		if err := awsRestjson1_serializeDocumentStringList(v.EntryPoint, ok); err != nil {
			return err
		}
	}

	if v.WorkingDirectory != nil {
		ok := object.Key("WorkingDirectory")
		ok.String(*v.WorkingDirectory)
	}

	return nil
}

func awsRestjson1_serializeDocumentLayerList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLayerVersionContentInput(v *types.LayerVersionContentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3Key != nil {
		ok := object.Key("S3Key")
		ok.String(*v.S3Key)
	}

	if v.S3ObjectVersion != nil {
		ok := object.Key("S3ObjectVersion")
		ok.String(*v.S3ObjectVersion)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.Base64EncodeBytes(v.ZipFile)
	}

	return nil
}

func awsRestjson1_serializeDocumentOnFailure(v *types.OnFailure, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		ok.String(*v.Destination)
	}

	return nil
}

func awsRestjson1_serializeDocumentOnSuccess(v *types.OnSuccess, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		ok.String(*v.Destination)
	}

	return nil
}

func awsRestjson1_serializeDocumentQueues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelfManagedEventSource(v *types.SelfManagedEventSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoints != nil {
		ok := object.Key("Endpoints")
		if err := awsRestjson1_serializeDocumentEndpoints(v.Endpoints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSigningProfileVersionArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSourceAccessConfiguration(v *types.SourceAccessConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.URI != nil {
		ok := object.Key("URI")
		ok.String(*v.URI)
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceAccessConfigurations(v []types.SourceAccessConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSourceAccessConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTopics(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTracingConfig(v *types.TracingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcConfig(v *types.VpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}
