// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The request was rejected because it attempted to create a resource that already
// exists.
type AlreadyExistsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlreadyExistsException) ErrorCode() string             { return "AlreadyExistsException" }
func (e *AlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified AWS CloudHSM cluster is already
// associated with a custom key store or it shares a backup history with a cluster
// that is associated with a custom key store. Each custom key store must be
// associated with a different AWS CloudHSM cluster. Clusters that share a backup
// history have the same cluster certificate. To view the cluster certificate of a
// cluster, use the DescribeClusters
// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
// operation.
type CloudHsmClusterInUseException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudHsmClusterInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmClusterInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmClusterInUseException) ErrorCode() string             { return "CloudHsmClusterInUseException" }
func (e *CloudHsmClusterInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the associated AWS CloudHSM cluster did not
// meet the configuration requirements for a custom key store.
//
// * The cluster must
// be configured with private subnets in at least two different Availability Zones
// in the Region.
//
// * The security group for the cluster
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
// (cloudhsm-cluster--sg) must include inbound rules and outbound rules that allow
// TCP traffic on ports 2223-2225. The Source in the inbound rules and the
// Destination in the outbound rules must match the security group ID. These rules
// are set by default when you create the cluster. Do not delete or change them. To
// get information about a particular security group, use the
// DescribeSecurityGroups
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
// operation.
//
// * The cluster must contain at least as many HSMs as the operation
// requires. To add HSMs, use the AWS CloudHSM CreateHsm
// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
// operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
// operations, the AWS CloudHSM cluster must have at least two active HSMs, each in
// a different Availability Zone. For the ConnectCustomKeyStore operation, the AWS
// CloudHSM must contain at least one active HSM.
//
// For information about the
// requirements for an AWS CloudHSM cluster that is associated with a custom key
// store, see Assemble the Prerequisites
// (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
// in the AWS Key Management Service Developer Guide. For information about
// creating a private subnet for an AWS CloudHSM cluster, see Create a Private
// Subnet
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html) in
// the AWS CloudHSM User Guide. For information about cluster security groups, see
// Configure a Default Security Group
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html) in the
// AWS CloudHSM User Guide .
type CloudHsmClusterInvalidConfigurationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudHsmClusterInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmClusterInvalidConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmClusterInvalidConfigurationException) ErrorCode() string {
	return "CloudHsmClusterInvalidConfigurationException"
}
func (e *CloudHsmClusterInvalidConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the AWS CloudHSM cluster that is associated
// with the custom key store is not active. Initialize and activate the cluster and
// try the command again. For detailed instructions, see Getting Started
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html) in
// the AWS CloudHSM User Guide.
type CloudHsmClusterNotActiveException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudHsmClusterNotActiveException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmClusterNotActiveException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmClusterNotActiveException) ErrorCode() string {
	return "CloudHsmClusterNotActiveException"
}
func (e *CloudHsmClusterNotActiveException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because AWS KMS cannot find the AWS CloudHSM cluster
// with the specified cluster ID. Retry the request with a different cluster ID.
type CloudHsmClusterNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudHsmClusterNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmClusterNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmClusterNotFoundException) ErrorCode() string {
	return "CloudHsmClusterNotFoundException"
}
func (e *CloudHsmClusterNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified AWS CloudHSM cluster has a
// different cluster certificate than the original cluster. You cannot use the
// operation to specify an unrelated cluster. Specify a cluster that shares a
// backup history with the original cluster. This includes clusters that were
// created from a backup of the current cluster, and clusters that were created
// from the same backup that produced the current cluster. Clusters that share a
// backup history have the same cluster certificate. To view the cluster
// certificate of a cluster, use the DescribeClusters
// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
// operation.
type CloudHsmClusterNotRelatedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudHsmClusterNotRelatedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudHsmClusterNotRelatedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudHsmClusterNotRelatedException) ErrorCode() string {
	return "CloudHsmClusterNotRelatedException"
}
func (e *CloudHsmClusterNotRelatedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the custom key store contains AWS KMS customer
// master keys (CMKs). After verifying that you do not need to use the CMKs, use
// the ScheduleKeyDeletion operation to delete the CMKs. After they are deleted,
// you can delete the custom key store.
type CustomKeyStoreHasCMKsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CustomKeyStoreHasCMKsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomKeyStoreHasCMKsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomKeyStoreHasCMKsException) ErrorCode() string             { return "CustomKeyStoreHasCMKsException" }
func (e *CustomKeyStoreHasCMKsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because of the ConnectionState of the custom key store.
// To get the ConnectionState of a custom key store, use the
// DescribeCustomKeyStores operation. This exception is thrown under the following
// conditions:
//
// * You requested the CreateKey or GenerateRandom operation in a
// custom key store that is not connected. These operations are valid only when the
// custom key store ConnectionState is CONNECTED.
//
// * You requested the
// UpdateCustomKeyStore or DeleteCustomKeyStore operation on a custom key store
// that is not disconnected. This operation is valid only when the custom key store
// ConnectionState is DISCONNECTED.
//
// * You requested the ConnectCustomKeyStore
// operation on a custom key store with a ConnectionState of DISCONNECTING or
// FAILED. This operation is valid for all other ConnectionState values.
type CustomKeyStoreInvalidStateException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CustomKeyStoreInvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomKeyStoreInvalidStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomKeyStoreInvalidStateException) ErrorCode() string {
	return "CustomKeyStoreInvalidStateException"
}
func (e *CustomKeyStoreInvalidStateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the specified custom key store name is already
// assigned to another custom key store in the account. Try again with a custom key
// store name that is unique in the account.
type CustomKeyStoreNameInUseException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CustomKeyStoreNameInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomKeyStoreNameInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomKeyStoreNameInUseException) ErrorCode() string {
	return "CustomKeyStoreNameInUseException"
}
func (e *CustomKeyStoreNameInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because AWS KMS cannot find a custom key store with the
// specified key store name or ID.
type CustomKeyStoreNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CustomKeyStoreNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomKeyStoreNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomKeyStoreNotFoundException) ErrorCode() string {
	return "CustomKeyStoreNotFoundException"
}
func (e *CustomKeyStoreNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The system timed out while trying to fulfill the request. The request can be
// retried.
type DependencyTimeoutException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DependencyTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DependencyTimeoutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DependencyTimeoutException) ErrorCode() string             { return "DependencyTimeoutException" }
func (e *DependencyTimeoutException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request was rejected because the specified CMK is not enabled.
type DisabledException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DisabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DisabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DisabledException) ErrorCode() string             { return "DisabledException" }
func (e *DisabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified import token is expired. Use
// GetParametersForImport to get a new import token and public key, use the new
// public key to encrypt the key material, and then try the request again.
type ExpiredImportTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ExpiredImportTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExpiredImportTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExpiredImportTokenException) ErrorCode() string             { return "ExpiredImportTokenException" }
func (e *ExpiredImportTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified CMK cannot decrypt the data. The
// KeyId in a Decrypt request and the SourceKeyId in a ReEncrypt request must
// identify the same CMK that was used to encrypt the ciphertext.
type IncorrectKeyException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IncorrectKeyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncorrectKeyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncorrectKeyException) ErrorCode() string             { return "IncorrectKeyException" }
func (e *IncorrectKeyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the key material in the request is, expired,
// invalid, or is not the same key material that was previously imported into this
// customer master key (CMK).
type IncorrectKeyMaterialException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IncorrectKeyMaterialException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncorrectKeyMaterialException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncorrectKeyMaterialException) ErrorCode() string             { return "IncorrectKeyMaterialException" }
func (e *IncorrectKeyMaterialException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the trust anchor certificate in the request is
// not the trust anchor certificate for the specified AWS CloudHSM cluster. When
// you initialize the cluster
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr),
// you create the trust anchor certificate and save it in the customerCA.crt file.
type IncorrectTrustAnchorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IncorrectTrustAnchorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncorrectTrustAnchorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncorrectTrustAnchorException) ErrorCode() string             { return "IncorrectTrustAnchorException" }
func (e *IncorrectTrustAnchorException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified alias name is not valid.
type InvalidAliasNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidAliasNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAliasNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAliasNameException) ErrorCode() string             { return "InvalidAliasNameException" }
func (e *InvalidAliasNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because a specified ARN, or an ARN in a key policy, is
// not valid.
type InvalidArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArnException) ErrorCode() string             { return "InvalidArnException" }
func (e *InvalidArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// From the Decrypt or ReEncrypt operation, the request was rejected because the
// specified ciphertext, or additional authenticated data incorporated into the
// ciphertext, such as the encryption context, is corrupted, missing, or otherwise
// invalid. From the ImportKeyMaterial operation, the request was rejected because
// AWS KMS could not decrypt the encrypted (wrapped) key material.
type InvalidCiphertextException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidCiphertextException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCiphertextException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCiphertextException) ErrorCode() string             { return "InvalidCiphertextException" }
func (e *InvalidCiphertextException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified GrantId is not valid.
type InvalidGrantIdException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidGrantIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGrantIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGrantIdException) ErrorCode() string             { return "InvalidGrantIdException" }
func (e *InvalidGrantIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified grant token is not valid.
type InvalidGrantTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidGrantTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGrantTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGrantTokenException) ErrorCode() string             { return "InvalidGrantTokenException" }
func (e *InvalidGrantTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the provided import token is invalid or is
// associated with a different customer master key (CMK).
type InvalidImportTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidImportTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidImportTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidImportTokenException) ErrorCode() string             { return "InvalidImportTokenException" }
func (e *InvalidImportTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected for one of the following reasons:
//
// * The KeyUsage value
// of the CMK is incompatible with the API operation.
//
// * The encryption algorithm
// or signing algorithm specified for the operation is incompatible with the type
// of key material in the CMK (CustomerMasterKeySpec).
//
// For encrypting, decrypting,
// re-encrypting, and generating data keys, the KeyUsage must be ENCRYPT_DECRYPT.
// For signing and verifying, the KeyUsage must be SIGN_VERIFY. To find the
// KeyUsage of a CMK, use the DescribeKey operation. To find the encryption or
// signing algorithms supported for a particular CMK, use the DescribeKey
// operation.
type InvalidKeyUsageException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidKeyUsageException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKeyUsageException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKeyUsageException) ErrorCode() string             { return "InvalidKeyUsageException" }
func (e *InvalidKeyUsageException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the marker that specifies where pagination
// should next begin is not valid.
type InvalidMarkerException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidMarkerException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMarkerException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMarkerException) ErrorCode() string             { return "InvalidMarkerException" }
func (e *InvalidMarkerException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified CMK was not available. You can
// retry the request.
type KeyUnavailableException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KeyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KeyUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KeyUnavailableException) ErrorCode() string             { return "KeyUnavailableException" }
func (e *KeyUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request was rejected because an internal exception occurred. The request can
// be retried.
type KMSInternalException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KMSInternalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSInternalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSInternalException) ErrorCode() string             { return "KMSInternalException" }
func (e *KMSInternalException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request was rejected because the signature verification failed. Signature
// verification fails when it cannot confirm that signature was produced by signing
// the specified message with the specified CMK and signing algorithm.
type KMSInvalidSignatureException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KMSInvalidSignatureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSInvalidSignatureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSInvalidSignatureException) ErrorCode() string             { return "KMSInvalidSignatureException" }
func (e *KMSInvalidSignatureException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the state of the specified resource is not
// valid for this request. For more information about how key state affects the use
// of a CMK, see How Key State Affects Use of a Customer Master Key
// (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html) in the
// AWS Key Management Service Developer Guide .
type KMSInvalidStateException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KMSInvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSInvalidStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSInvalidStateException) ErrorCode() string             { return "KMSInvalidStateException" }
func (e *KMSInvalidStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because a quota was exceeded. For more information, see
// Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html) in
// the AWS Key Management Service Developer Guide.
type LimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified policy is not syntactically or
// semantically correct.
type MalformedPolicyDocumentException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedPolicyDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedPolicyDocumentException) ErrorCode() string {
	return "MalformedPolicyDocumentException"
}
func (e *MalformedPolicyDocumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the specified entity or resource could not be
// found.
type NotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotFoundException) ErrorCode() string             { return "NotFoundException" }
func (e *NotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because one or more tags are not valid.
type TagException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagException) ErrorCode() string             { return "TagException" }
func (e *TagException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because a specified parameter is not supported or a
// specified resource is not valid for this operation.
type UnsupportedOperationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string             { return "UnsupportedOperationException" }
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
