// Code generated by smithy-go-codegen DO NOT EDIT.

package greengrassv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/greengrassv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves metadata for a Greengrass core device.
func (c *Client) GetCoreDevice(ctx context.Context, params *GetCoreDeviceInput, optFns ...func(*Options)) (*GetCoreDeviceOutput, error) {
	if params == nil {
		params = &GetCoreDeviceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCoreDevice", params, optFns, c.addOperationGetCoreDeviceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCoreDeviceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCoreDeviceInput struct {

	// The name of the core device. This is also the name of the IoT thing.
	//
	// This member is required.
	CoreDeviceThingName *string

	noSmithyDocumentSerde
}

type GetCoreDeviceOutput struct {

	// The computer architecture of the core device.
	Architecture *string

	// The name of the core device. This is also the name of the IoT thing.
	CoreDeviceThingName *string

	// The version of the IoT Greengrass Core software that the core device runs. This
	// version is equivalent to the version of the Greengrass nucleus component that
	// runs on the core device. For more information, see the Greengrass nucleus
	// component
	// (https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html)
	// in the IoT Greengrass V2 Developer Guide.
	CoreVersion *string

	// The time at which the core device's status last updated, expressed in ISO 8601
	// format.
	LastStatusUpdateTimestamp *time.Time

	// The operating system platform that the core device runs.
	Platform *string

	// The status of the core device. The core device status can be:
	//
	// * HEALTHY – The
	// IoT Greengrass Core software and all components run on the core device without
	// issue.
	//
	// * UNHEALTHY – The IoT Greengrass Core software or a component is in a
	// failed state on the core device.
	Status types.CoreDeviceStatus

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tag your resources
	// (https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in
	// the IoT Greengrass V2 Developer Guide.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCoreDeviceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCoreDevice{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCoreDevice{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetCoreDeviceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCoreDevice(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCoreDevice(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "greengrass",
		OperationName: "GetCoreDevice",
	}
}
