// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A collection of accounts and regions.
type AccountAggregationSource struct {

	// The 12-digit account ID of the account being aggregated.
	//
	// This member is required.
	AccountIds []string

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions bool

	// The source regions being aggregated.
	AwsRegions []string

	noSmithyDocumentSerde
}

// Indicates whether an AWS Config rule is compliant based on account ID, region,
// compliance, and rule name. A rule is compliant if all of the resources that the
// rule evaluated comply with it. It is noncompliant if any of these resources do
// not comply.
type AggregateComplianceByConfigRule struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region from where the data is aggregated.
	AwsRegion *string

	// Indicates whether an AWS resource or AWS Config rule is compliant and provides
	// the number of contributors that affect the compliance.
	Compliance *Compliance

	// The name of the AWS Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Provides aggregate compliance of the conformance pack. Indicates whether a
// conformance pack is compliant based on the name of the conformance pack, account
// ID, and region. A conformance pack is compliant if all of the rules in a
// conformance packs are compliant. It is noncompliant if any of the rules are not
// compliant. The compliance status of a conformance pack is INSUFFICIENT_DATA only
// if all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the
// compliance status of other rules in that same conformance pack is
// INSUFFICIENT_DATA, the conformance pack shows compliant.
type AggregateComplianceByConformancePack struct {

	// The 12-digit AWS account ID of the source account.
	AccountId *string

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string

	// The compliance status of the conformance pack.
	Compliance *AggregateConformancePackCompliance

	// The name of the conformance pack.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
type AggregateComplianceCount struct {

	// The number of compliant and noncompliant AWS Config rules.
	ComplianceSummary *ComplianceSummary

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string

	noSmithyDocumentSerde
}

// Provides the number of compliant and noncompliant rules within a conformance
// pack. Also provides the compliance status of the conformance pack and the total
// rule count which includes compliant rules, noncompliant rules, and rules that
// cannot be evaluated due to insufficient data. A conformance pack is compliant if
// all of the rules in a conformance packs are compliant. It is noncompliant if any
// of the rules are not compliant. The compliance status of a conformance pack is
// INSUFFICIENT_DATA only if all rules within a conformance pack cannot be
// evaluated due to insufficient data. If some of the rules in a conformance pack
// are compliant but the compliance status of other rules in that same conformance
// pack is INSUFFICIENT_DATA, the conformance pack shows compliant.
type AggregateConformancePackCompliance struct {

	// The compliance status of the conformance pack.
	ComplianceType ConformancePackComplianceType

	// The number of compliant AWS Config Rules.
	CompliantRuleCount int32

	// The number of noncompliant AWS Config Rules.
	NonCompliantRuleCount int32

	// Total number of compliant rules, noncompliant rules, and the rules that do not
	// have any applicable resources to evaluate upon resulting in insufficient data.
	TotalRuleCount int32

	noSmithyDocumentSerde
}

// The number of conformance packs that are compliant and noncompliant.
type AggregateConformancePackComplianceCount struct {

	// Number of compliant conformance packs.
	CompliantConformancePackCount int32

	// Number of noncompliant conformance packs.
	NonCompliantConformancePackCount int32

	noSmithyDocumentSerde
}

// Filters the conformance packs based on an account ID, region, compliance type,
// and the name of the conformance pack.
type AggregateConformancePackComplianceFilters struct {

	// The 12-digit AWS account ID of the source account.
	AccountId *string

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string

	// The compliance status of the conformance pack.
	ComplianceType ConformancePackComplianceType

	// The name of the conformance pack.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Provides a summary of compliance based on either account ID or region.
type AggregateConformancePackComplianceSummary struct {

	// Returns an AggregateConformancePackComplianceCount object.
	ComplianceSummary *AggregateConformancePackComplianceCount

	// Groups the result based on AWS Account ID or AWS Region.
	GroupName *string

	noSmithyDocumentSerde
}

// Filters the results based on account ID and region.
type AggregateConformancePackComplianceSummaryFilters struct {

	// The 12-digit AWS account ID of the source account.
	AccountId *string

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string

	noSmithyDocumentSerde
}

// The current sync status between the source and the aggregator account.
type AggregatedSourceStatus struct {

	// The region authorized to collect aggregated data.
	AwsRegion *string

	// The error code that AWS Config returned when the source account aggregation last
	// failed.
	LastErrorCode *string

	// The message indicating that the source account aggregation failed due to an
	// error.
	LastErrorMessage *string

	// Filters the last updated status type.
	//
	// * Valid value FAILED indicates errors
	// while moving data.
	//
	// * Valid value SUCCEEDED indicates the data was successfully
	// moved.
	//
	// * Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus AggregatedSourceStatusType

	// The time of the last update.
	LastUpdateTime *time.Time

	// The source account ID or an organization.
	SourceId *string

	// The source account or an organization.
	SourceType AggregatedSourceType

	noSmithyDocumentSerde
}

// The details of an AWS Config evaluation for an account ID and region in an
// aggregator. Provides the AWS resource that was evaluated, the compliance of the
// resource, related time stamps, and supplementary information.
type AggregateEvaluationResult struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string

	// The source region from where the data is aggregated.
	AwsRegion *string

	// The resource compliance status. For the AggregationEvaluationResult data type,
	// AWS Config supports only the COMPLIANT and NON_COMPLIANT. AWS Config does not
	// support the NOT_APPLICABLE and INSUFFICIENT_DATA value.
	ComplianceType ComplianceType

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when AWS Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time

	noSmithyDocumentSerde
}

// The details that identify a resource that is collected by AWS Config aggregator,
// including the resource type, ID, (if available) the custom resource name, the
// source account, and source region.
type AggregateResourceIdentifier struct {

	// The ID of the AWS resource.
	//
	// This member is required.
	ResourceId *string

	// The type of the AWS resource.
	//
	// This member is required.
	ResourceType ResourceType

	// The 12-digit account ID of the source account.
	//
	// This member is required.
	SourceAccountId *string

	// The source region where data is aggregated.
	//
	// This member is required.
	SourceRegion *string

	// The name of the AWS resource.
	ResourceName *string

	noSmithyDocumentSerde
}

// An object that represents the authorizations granted to aggregator accounts and
// regions.
type AggregationAuthorization struct {

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time

	noSmithyDocumentSerde
}

// The detailed configuration of a specified resource.
type BaseConfigurationItem struct {

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The Availability Zone associated with the resource.
	AvailabilityZone *string

	// The region where the resource resides.
	AwsRegion *string

	// The description of the resource configuration.
	Configuration *string

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time

	// The configuration item status. The valid values are:
	//
	// * OK – The resource
	// configuration has been updated
	//
	// * ResourceDiscovered – The resource was newly
	// discovered
	//
	// * ResourceNotRecorded – The resource was discovered but its
	// configuration was not recorded since the recorder excludes the recording of
	// resources of this type
	//
	// * ResourceDeleted – The resource was deleted
	//
	// *
	// ResourceDeletedNotRecorded – The resource was deleted but its configuration was
	// not recorded since the recorder excludes the recording of resources of this
	// type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus ConfigurationItemStatus

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string

	// The custom name of the resource, if available.
	ResourceName *string

	// The type of AWS resource.
	ResourceType ResourceType

	// Configuration attributes that AWS Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string

	// The version number of the resource configuration.
	Version *string

	noSmithyDocumentSerde
}

// Indicates whether an AWS resource or AWS Config rule is compliant and provides
// the number of contributors that affect the compliance.
type Compliance struct {

	// The number of AWS resources or AWS Config rules that cause a result of
	// NON_COMPLIANT, up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount

	// Indicates whether an AWS resource or AWS Config rule is compliant. A resource is
	// compliant if it complies with all of the AWS Config rules that evaluate it. A
	// resource is noncompliant if it does not comply with one or more of these rules.
	// A rule is compliant if all of the resources that the rule evaluates comply with
	// it. A rule is noncompliant if any of these resources do not comply. AWS Config
	// returns the INSUFFICIENT_DATA value when no evaluation results are available for
	// the AWS resource or AWS Config rule. For the Compliance data type, AWS Config
	// supports only COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA values. AWS Config
	// does not support the NOT_APPLICABLE value for the Compliance data type.
	ComplianceType ComplianceType

	noSmithyDocumentSerde
}

// Indicates whether an AWS Config rule is compliant. A rule is compliant if all of
// the resources that the rule evaluated comply with it. A rule is noncompliant if
// any of these resources do not comply.
type ComplianceByConfigRule struct {

	// Indicates whether the AWS Config rule is compliant.
	Compliance *Compliance

	// The name of the AWS Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Indicates whether an AWS resource that is evaluated according to one or more AWS
// Config rules is compliant. A resource is compliant if it complies with all of
// the rules that evaluate it. A resource is noncompliant if it does not comply
// with one or more of these rules.
type ComplianceByResource struct {

	// Indicates whether the AWS resource complies with all of the AWS Config rules
	// that evaluated it.
	Compliance *Compliance

	// The ID of the AWS resource that was evaluated.
	ResourceId *string

	// The type of the AWS resource that was evaluated.
	ResourceType *string

	noSmithyDocumentSerde
}

// The number of AWS resources or AWS Config rules responsible for the current
// compliance of the item, up to a maximum number.
type ComplianceContributorCount struct {

	// Indicates whether the maximum count is reached.
	CapExceeded bool

	// The number of AWS resources or AWS Config rules responsible for the current
	// compliance of the item.
	CappedCount int32

	noSmithyDocumentSerde
}

// The number of AWS Config rules or AWS resources that are compliant and
// noncompliant.
type ComplianceSummary struct {

	// The time that AWS Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time

	// The number of AWS Config rules or AWS resources that are compliant, up to a
	// maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount

	// The number of AWS Config rules or AWS resources that are noncompliant, up to a
	// maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount

	noSmithyDocumentSerde
}

// The number of AWS resources of a specific type that are compliant or
// noncompliant, up to a maximum of 100 for each.
type ComplianceSummaryByResourceType struct {

	// The number of AWS resources that are compliant or noncompliant, up to a maximum
	// of 100 for each.
	ComplianceSummary *ComplianceSummary

	// The type of AWS resource.
	ResourceType *string

	noSmithyDocumentSerde
}

// Provides status of the delivery of the snapshot or the configuration history to
// the specified Amazon S3 bucket. Also provides the status of notifications about
// the Amazon S3 delivery to the specified Amazon SNS topic.
type ConfigExportDeliveryInfo struct {

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time

	// The error code from the last attempted delivery.
	LastErrorCode *string

	// The error message from the last attempted delivery.
	LastErrorMessage *string

	// Status of the last attempted delivery.
	LastStatus DeliveryStatus

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time

	noSmithyDocumentSerde
}

// An AWS Config rule represents an AWS Lambda function that you create for a
// custom rule or a predefined function for an AWS managed rule. The function
// evaluates configuration items to assess whether your AWS resources comply with
// your desired configurations. This function can run when AWS Config detects a
// configuration change to an AWS resource and at a periodic frequency that you
// choose (for example, every 24 hours). You can use the AWS CLI and AWS SDKs if
// you want to create a rule that triggers evaluations for your resources when AWS
// Config delivers the configuration snapshot. For more information, see
// ConfigSnapshotDeliveryProperties. For more information about developing and
// using AWS Config rules, see Evaluating AWS Resource Configurations with AWS
// Config
// (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
type ConfigRule struct {

	// Provides the rule owner (AWS or customer), the rule identifier, and the
	// notifications that cause the function to evaluate your AWS resources.
	//
	// This member is required.
	Source *Source

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string

	// The ID of the AWS Config rule.
	ConfigRuleId *string

	// The name that you assign to the AWS Config rule. The name is required if you are
	// adding a new rule.
	ConfigRuleName *string

	// Indicates whether the AWS Config rule is active or is currently being deleted by
	// AWS Config. It can also indicate the evaluation status for the AWS Config rule.
	// AWS Config sets the state of the rule to EVALUATING temporarily after you use
	// the StartConfigRulesEvaluation request to evaluate your resources against the
	// AWS Config rule. AWS Config sets the state of the rule to DELETING_RESULTS
	// temporarily after you use the DeleteEvaluationResults request to delete the
	// current evaluation results for the AWS Config rule. AWS Config temporarily sets
	// the state of a rule to DELETING after you use the DeleteConfigRule request to
	// delete the rule. After AWS Config deletes the rule, the rule and all of its
	// evaluations are erased and are no longer available.
	ConfigRuleState ConfigRuleState

	// Service principal name of the service that created the rule. The field is
	// populated only if the service linked rule is created by a service. The field is
	// empty if you create your own rule.
	CreatedBy *string

	// The description that you provide for the AWS Config rule.
	Description *string

	// A string, in JSON format, that is passed to the AWS Config rule Lambda function.
	InputParameters *string

	// The maximum frequency with which AWS Config runs evaluations for a rule. You can
	// specify a value for MaximumExecutionFrequency when:
	//
	// * You are using an AWS
	// managed rule that is triggered at a periodic frequency.
	//
	// * Your custom rule is
	// triggered when AWS Config delivers the configuration snapshot. For more
	// information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a
	// periodic trigger are evaluated every 24 hours. To change the frequency, specify
	// a valid value for the MaximumExecutionFrequency parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// Defines which resources can trigger an evaluation for the rule. The scope can
	// include one or more resource types, a combination of one resource type and one
	// resource ID, or a combination of a tag key and value. Specify a scope to
	// constrain the resources that can trigger an evaluation for the rule. If you do
	// not specify a scope, evaluations are triggered when any resource in the
	// recording group changes. The scope can be empty.
	Scope *Scope

	noSmithyDocumentSerde
}

// Filters the compliance results based on account ID, region, compliance type, and
// rule name.
type ConfigRuleComplianceFilters struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region where the data is aggregated.
	AwsRegion *string

	// The rule compliance status. For the ConfigRuleComplianceFilters data type, AWS
	// Config supports only COMPLIANT and NON_COMPLIANT. AWS Config does not support
	// the NOT_APPLICABLE and the INSUFFICIENT_DATA values.
	ComplianceType ComplianceType

	// The name of the AWS Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Filters the results based on the account IDs and regions.
type ConfigRuleComplianceSummaryFilters struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region where the data is aggregated.
	AwsRegion *string

	noSmithyDocumentSerde
}

// Status information for your AWS managed Config rules. The status includes
// information such as the last time the rule ran, the last time it failed, and the
// related error for the last failure. This action does not return status
// information about custom AWS Config rules.
type ConfigRuleEvaluationStatus struct {

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string

	// The ID of the AWS Config rule.
	ConfigRuleId *string

	// The name of the AWS Config rule.
	ConfigRuleName *string

	// The time that you first activated the AWS Config rule.
	FirstActivatedTime *time.Time

	// Indicates whether AWS Config has evaluated your resources against the rule at
	// least once.
	//
	// * true - AWS Config has evaluated your AWS resources against the
	// rule at least once.
	//
	// * false - AWS Config has not once finished evaluating your
	// AWS resources against the rule.
	FirstEvaluationStarted bool

	// The time that you last turned off the AWS Config rule.
	LastDeactivatedTime *time.Time

	// The error code that AWS Config returned when the rule last failed.
	LastErrorCode *string

	// The error message that AWS Config returned when the rule last failed.
	LastErrorMessage *string

	// The time that AWS Config last failed to evaluate your AWS resources against the
	// rule.
	LastFailedEvaluationTime *time.Time

	// The time that AWS Config last failed to invoke the AWS Config rule to evaluate
	// your AWS resources.
	LastFailedInvocationTime *time.Time

	// The time that AWS Config last successfully evaluated your AWS resources against
	// the rule.
	LastSuccessfulEvaluationTime *time.Time

	// The time that AWS Config last successfully invoked the AWS Config rule to
	// evaluate your AWS resources.
	LastSuccessfulInvocationTime *time.Time

	noSmithyDocumentSerde
}

// Provides options for how often AWS Config delivers configuration snapshots to
// the Amazon S3 bucket in your delivery channel. The frequency for a rule that
// triggers evaluations for your resources when AWS Config delivers the
// configuration snapshot is set by one of two values, depending on which is less
// frequent:
//
// * The value for the deliveryFrequency parameter within the delivery
// channel configuration, which sets how often AWS Config delivers configuration
// snapshots. This value also sets how often AWS Config invokes evaluations for AWS
// Config rules.
//
// * The value for the MaximumExecutionFrequency parameter, which
// sets the maximum frequency with which AWS Config invokes evaluations for the
// rule. For more information, see ConfigRule.
//
// If the deliveryFrequency value is
// less frequent than the MaximumExecutionFrequency value for a rule, AWS Config
// invokes the rule only as often as the deliveryFrequency value.
//
// * For example,
// you want your rule to run evaluations when AWS Config delivers the configuration
// snapshot.
//
// * You specify the MaximumExecutionFrequency value for Six_Hours.
//
// *
// You then specify the delivery channel deliveryFrequency value for
// TwentyFour_Hours.
//
// * Because the value for deliveryFrequency is less frequent
// than MaximumExecutionFrequency, AWS Config invokes evaluations for the rule
// every 24 hours.
//
// You should set the MaximumExecutionFrequency value to be at
// least as frequent as the deliveryFrequency value. You can view the
// deliveryFrequency value by using the DescribeDeliveryChannnels action. To update
// the deliveryFrequency with which AWS Config delivers your configuration
// snapshots, use the PutDeliveryChannel action.
type ConfigSnapshotDeliveryProperties struct {

	// The frequency with which AWS Config delivers configuration snapshots.
	DeliveryFrequency MaximumExecutionFrequency

	noSmithyDocumentSerde
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
type ConfigStreamDeliveryInfo struct {

	// The error code from the last attempted delivery.
	LastErrorCode *string

	// The error message from the last attempted delivery.
	LastErrorMessage *string

	// Status of the last attempted delivery. Note Providing an SNS topic on a
	// DeliveryChannel
	// (https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for AWS Config is optional. If the SNS delivery is turned off, the last status
	// will be Not_Applicable.
	LastStatus DeliveryStatus

	// The time from the last status change.
	LastStatusChangeTime *time.Time

	noSmithyDocumentSerde
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
type ConfigurationAggregator struct {

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []AccountAggregationSource

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string

	// The name of the aggregator.
	ConfigurationAggregatorName *string

	// AWS service that created the configuration aggregator.
	CreatedBy *string

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time

	// The time of the last update.
	LastUpdatedTime *time.Time

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource

	noSmithyDocumentSerde
}

// A list that contains detailed configurations of a specified resource.
type ConfigurationItem struct {

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string

	// Amazon Resource Name (ARN) associated with the resource.
	Arn *string

	// The Availability Zone associated with the resource.
	AvailabilityZone *string

	// The region where the resource resides.
	AwsRegion *string

	// The description of the resource configuration.
	Configuration *string

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time

	// Unique MD5 hash that represents the configuration item's state. You can use MD5
	// hash to compare the states of two or more configuration items that are
	// associated with the same resource.
	ConfigurationItemMD5Hash *string

	// The configuration item status. The valid values are:
	//
	// * OK – The resource
	// configuration has been updated
	//
	// * ResourceDiscovered – The resource was newly
	// discovered
	//
	// * ResourceNotRecorded – The resource was discovered but its
	// configuration was not recorded since the recorder excludes the recording of
	// resources of this type
	//
	// * ResourceDeleted – The resource was deleted
	//
	// *
	// ResourceDeletedNotRecorded – The resource was deleted but its configuration was
	// not recorded since the recorder excludes the recording of resources of this
	// type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus ConfigurationItemStatus

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string

	// A list of CloudTrail event IDs. A populated field indicates that the current
	// configuration was initiated by the events recorded in the CloudTrail log. For
	// more information about CloudTrail, see What Is AWS CloudTrail
	// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
	// An empty field indicates that the current configuration was not initiated by any
	// event. As of Version 1.3, the relatedEvents field is empty. You can access the
	// LookupEvents API
	// (https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html)
	// in the AWS CloudTrail API Reference to retrieve the events for the resource.
	RelatedEvents []string

	// A list of related AWS resources.
	Relationships []Relationship

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string

	// The custom name of the resource, if available.
	ResourceName *string

	// The type of AWS resource.
	ResourceType ResourceType

	// Configuration attributes that AWS Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string

	// A mapping of key value tags associated with the resource.
	Tags map[string]string

	// The version number of the resource configuration.
	Version *string

	noSmithyDocumentSerde
}

// An object that represents the recording of configuration changes of an AWS
// resource.
type ConfigurationRecorder struct {

	// The name of the recorder. By default, AWS Config automatically assigns the name
	// "default" when creating the configuration recorder. You cannot change the
	// assigned name.
	Name *string

	// Specifies the types of AWS resources for which AWS Config records configuration
	// changes.
	RecordingGroup *RecordingGroup

	// Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources
	// associated with the account.
	RoleARN *string

	noSmithyDocumentSerde
}

// The current status of the configuration recorder.
type ConfigurationRecorderStatus struct {

	// The error code indicating that the recording failed.
	LastErrorCode *string

	// The message indicating that the recording failed due to an error.
	LastErrorMessage *string

	// The time the recorder was last started.
	LastStartTime *time.Time

	// The last (previous) status of the recorder.
	LastStatus RecorderStatus

	// The time when the status was last changed.
	LastStatusChangeTime *time.Time

	// The time the recorder was last stopped.
	LastStopTime *time.Time

	// The name of the configuration recorder.
	Name *string

	// Specifies whether or not the recorder is currently recording.
	Recording bool

	noSmithyDocumentSerde
}

// Filters the conformance pack by compliance types and AWS Config rule names.
type ConformancePackComplianceFilters struct {

	// Filters the results by compliance. The allowed values are COMPLIANT and
	// NON_COMPLIANT. INSUFFICIENT_DATA is not supported.
	ComplianceType ConformancePackComplianceType

	// Filters the results by AWS Config rule names.
	ConfigRuleNames []string

	noSmithyDocumentSerde
}

// Summary includes the name and status of the conformance pack.
type ConformancePackComplianceSummary struct {

	// The status of the conformance pack. The allowed values are COMPLIANT,
	// NON_COMPLIANT and INSUFFICIENT_DATA.
	//
	// This member is required.
	ConformancePackComplianceStatus ConformancePackComplianceType

	// The name of the conformance pack name.
	//
	// This member is required.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Returns details of a conformance pack. A conformance pack is a collection of AWS
// Config rules and remediation actions that can be easily deployed in an account
// and a region.
type ConformancePackDetail struct {

	// Amazon Resource Name (ARN) of the conformance pack.
	//
	// This member is required.
	ConformancePackArn *string

	// ID of the conformance pack.
	//
	// This member is required.
	ConformancePackId *string

	// Name of the conformance pack.
	//
	// This member is required.
	ConformancePackName *string

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []ConformancePackInputParameter

	// AWS service that created the conformance pack.
	CreatedBy *string

	// Amazon S3 bucket where AWS Config stores conformance pack templates. This field
	// is optional.
	DeliveryS3Bucket *string

	// The prefix for the Amazon S3 bucket. This field is optional.
	DeliveryS3KeyPrefix *string

	// Last time when conformation pack update was requested.
	LastUpdateRequestedTime *time.Time

	noSmithyDocumentSerde
}

// Filters a conformance pack by AWS Config rule names, compliance types, AWS
// resource types, and resource IDs.
type ConformancePackEvaluationFilters struct {

	// Filters the results by compliance. The allowed values are COMPLIANT and
	// NON_COMPLIANT. INSUFFICIENT_DATA is not supported.
	ComplianceType ConformancePackComplianceType

	// Filters the results by AWS Config rule names.
	ConfigRuleNames []string

	// Filters the results by resource IDs. This is valid only when you provide
	// resource type. If there is no resource type, you will see an error.
	ResourceIds []string

	// Filters the results by the resource type (for example, "AWS::EC2::Instance").
	ResourceType *string

	noSmithyDocumentSerde
}

// The details of a conformance pack evaluation. Provides AWS Config rule and AWS
// resource type that was evaluated, the compliance of the conformance pack,
// related time stamps, and supplementary information.
type ConformancePackEvaluationResult struct {

	// The compliance type. The allowed values are COMPLIANT and NON_COMPLIANT.
	// INSUFFICIENT_DATA is not supported.
	//
	// This member is required.
	ComplianceType ConformancePackComplianceType

	// The time when AWS Config rule evaluated AWS resource.
	//
	// This member is required.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies an evaluation result.
	//
	// This member is required.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when AWS Config recorded the evaluation result.
	//
	// This member is required.
	ResultRecordedTime *time.Time

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	noSmithyDocumentSerde
}

// Input parameters in the form of key-value pairs for the conformance pack, both
// of which you define. Keys can have a maximum character length of 255 characters,
// and values can have a maximum length of 4096 characters.
type ConformancePackInputParameter struct {

	// One part of a key-value pair.
	//
	// This member is required.
	ParameterName *string

	// Another part of the key-value pair.
	//
	// This member is required.
	ParameterValue *string

	noSmithyDocumentSerde
}

// Compliance information of one or more AWS Config rules within a conformance
// pack. You can filter using AWS Config rule names and compliance types.
type ConformancePackRuleCompliance struct {

	// Compliance of the AWS Config rule. The allowed values are COMPLIANT,
	// NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceType ConformancePackComplianceType

	// Name of the config rule.
	ConfigRuleName *string

	// Controls for the conformance pack. A control is a process to prevent or detect
	// problems while meeting objectives. A control can align with a specific
	// compliance regime or map to internal controls defined by an organization.
	Controls []string

	noSmithyDocumentSerde
}

// Status details of a conformance pack.
type ConformancePackStatusDetail struct {

	// Amazon Resource Name (ARN) of comformance pack.
	//
	// This member is required.
	ConformancePackArn *string

	// ID of the conformance pack.
	//
	// This member is required.
	ConformancePackId *string

	// Name of the conformance pack.
	//
	// This member is required.
	ConformancePackName *string

	// Indicates deployment status of conformance pack. AWS Config sets the state of
	// the conformance pack to:
	//
	// * CREATE_IN_PROGRESS when a conformance pack creation
	// is in progress for an account.
	//
	// * CREATE_COMPLETE when a conformance pack has
	// been successfully created in your account.
	//
	// * CREATE_FAILED when a conformance
	// pack creation failed in your account.
	//
	// * DELETE_IN_PROGRESS when a conformance
	// pack deletion is in progress.
	//
	// * DELETE_FAILED when a conformance pack deletion
	// failed in your account.
	//
	// This member is required.
	ConformancePackState ConformancePackState

	// Last time when conformation pack creation and update was requested.
	//
	// This member is required.
	LastUpdateRequestedTime *time.Time

	// Amazon Resource Name (ARN) of AWS CloudFormation stack.
	//
	// This member is required.
	StackArn *string

	// The reason of conformance pack creation failure.
	ConformancePackStatusReason *string

	// Last time when conformation pack creation and update was successful.
	LastUpdateCompletedTime *time.Time

	noSmithyDocumentSerde
}

// The channel through which AWS Config delivers notifications and updated
// configuration states.
type DeliveryChannel struct {

	// The options for how often AWS Config delivers configuration snapshots to the
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties

	// The name of the delivery channel. By default, AWS Config assigns the name
	// "default" when creating the delivery channel. To change the delivery channel
	// name, you must use the DeleteDeliveryChannel action to delete your current
	// delivery channel, and then you must use the PutDeliveryChannel command to create
	// a delivery channel that has the desired name.
	Name *string

	// The name of the Amazon S3 bucket to which AWS Config delivers configuration
	// snapshots and configuration history files. If you specify a bucket that belongs
	// to another AWS account, that bucket must have policies that grant access
	// permissions to AWS Config. For more information, see Permissions for the Amazon
	// S3 Bucket
	// (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the AWS Config Developer Guide.
	S3BucketName *string

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) customer
	// managed key (CMK) used to encrypt objects delivered by AWS Config. Must belong
	// to the same Region as the destination S3 bucket.
	S3KmsKeyArn *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends
	// notifications about configuration changes. If you choose a topic from another
	// account, the topic must have policies that grant access permissions to AWS
	// Config. For more information, see Permissions for the Amazon SNS Topic
	// (https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the AWS Config Developer Guide.
	SnsTopicARN *string

	noSmithyDocumentSerde
}

// The status of a specified delivery channel. Valid values: Success | Failure
type DeliveryChannelStatus struct {

	// A list that contains the status of the delivery of the configuration history to
	// the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo

	// The name of the delivery channel.
	Name *string

	noSmithyDocumentSerde
}

// Identifies an AWS resource and indicates whether it complies with the AWS Config
// rule that it was evaluated against.
type Evaluation struct {

	// The ID of the AWS resource that was evaluated.
	//
	// This member is required.
	ComplianceResourceId *string

	// The type of AWS resource that was evaluated.
	//
	// This member is required.
	ComplianceResourceType *string

	// Indicates whether the AWS resource complies with the AWS Config rule that it was
	// evaluated against. For the Evaluation data type, AWS Config supports only the
	// COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE values. AWS Config does not support
	// the INSUFFICIENT_DATA value for this data type. Similarly, AWS Config does not
	// accept INSUFFICIENT_DATA as the value for ComplianceType from a PutEvaluations
	// request. For example, an AWS Lambda function for a custom AWS Config rule cannot
	// pass an INSUFFICIENT_DATA value to AWS Config.
	//
	// This member is required.
	ComplianceType ComplianceType

	// The time of the event in AWS Config that triggered the evaluation. For
	// event-based evaluations, the time indicates when AWS Config created the
	// configuration item that triggered the evaluation. For periodic evaluations, the
	// time indicates when AWS Config triggered the evaluation at the frequency that
	// you specified (for example, every 24 hours).
	//
	// This member is required.
	OrderingTimestamp *time.Time

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	noSmithyDocumentSerde
}

// The details of an AWS Config evaluation. Provides the AWS resource that was
// evaluated, the compliance of the resource, related time stamps, and
// supplementary information.
type EvaluationResult struct {

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// evaluated it. For the EvaluationResult data type, AWS Config supports only the
	// COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE values. AWS Config does not support
	// the INSUFFICIENT_DATA value for the EvaluationResult data type.
	ComplianceType ComplianceType

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when AWS Config recorded the evaluation result.
	ResultRecordedTime *time.Time

	// An encrypted token that associates an evaluation with an AWS Config rule. The
	// token identifies the rule, the AWS resource being evaluated, and the event that
	// triggered the evaluation.
	ResultToken *string

	noSmithyDocumentSerde
}

// Uniquely identifies an evaluation result.
type EvaluationResultIdentifier struct {

	// Identifies an AWS Config rule used to evaluate an AWS resource, and provides the
	// type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier

	// The time of the event that triggered the evaluation of your AWS resources. The
	// time can indicate when AWS Config delivered a configuration item change
	// notification, or it can indicate when AWS Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time

	noSmithyDocumentSerde
}

// Identifies an AWS Config rule that evaluated an AWS resource, and provides the
// type and ID of the resource that the rule evaluated.
type EvaluationResultQualifier struct {

	// The name of the AWS Config rule that was used in the evaluation.
	ConfigRuleName *string

	// The ID of the evaluated AWS resource.
	ResourceId *string

	// The type of AWS resource that was evaluated.
	ResourceType *string

	noSmithyDocumentSerde
}

// The controls that AWS Config uses for executing remediations.
type ExecutionControls struct {

	// A SsmControls object.
	SsmControls *SsmControls

	noSmithyDocumentSerde
}

// Identifies an AWS resource and indicates whether it complies with the AWS Config
// rule that it was evaluated against.
type ExternalEvaluation struct {

	// The evaluated compliance resource ID. AWS Config accepts only AWS account ID.
	//
	// This member is required.
	ComplianceResourceId *string

	// The evaluated compliance resource type. AWS Config accepts AWS::::Account
	// resource type.
	//
	// This member is required.
	ComplianceResourceType *string

	// The compliance of the AWS resource. The valid values are COMPLIANT,
	// NON_COMPLIANT,  and NOT_APPLICABLE.
	//
	// This member is required.
	ComplianceType ComplianceType

	// The time when the compliance was recorded.
	//
	// This member is required.
	OrderingTimestamp *time.Time

	// Supplementary information about the reason of compliance. For example, this task
	// was completed on a specific date.
	Annotation *string

	noSmithyDocumentSerde
}

// List of each of the failed delete remediation exceptions with specific reasons.
type FailedDeleteRemediationExceptionsBatch struct {

	// Returns remediation exception resource key object of the failed items.
	FailedItems []RemediationExceptionResourceKey

	// Returns a failure message for delete remediation exception. For example, AWS
	// Config creates an exception due to an internal error.
	FailureMessage *string

	noSmithyDocumentSerde
}

// List of each of the failed remediations with specific reasons.
type FailedRemediationBatch struct {

	// Returns remediation configurations of the failed items.
	FailedItems []RemediationConfiguration

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string

	noSmithyDocumentSerde
}

// List of each of the failed remediation exceptions with specific reasons.
type FailedRemediationExceptionBatch struct {

	// Returns remediation exception resource key object of the failed items.
	FailedItems []RemediationException

	// Returns a failure message. For example, the auto-remediation has failed.
	FailureMessage *string

	noSmithyDocumentSerde
}

// Details about the fields such as name of the field.
type FieldInfo struct {

	// Name of the field.
	Name *string

	noSmithyDocumentSerde
}

// The count of resources that are grouped by the group name.
type GroupedResourceCount struct {

	// The name of the group that can be region, account ID, or resource type. For
	// example, region1, region2 if the region was chosen as GroupByKey.
	//
	// This member is required.
	GroupName *string

	// The number of resources in the group.
	//
	// This member is required.
	ResourceCount int64

	noSmithyDocumentSerde
}

// Organization config rule creation or deletion status in each member account.
// This includes the name of the rule, the status, error code and error message
// when the rule creation or deletion failed.
type MemberAccountStatus struct {

	// The 12-digit account ID of a member account.
	//
	// This member is required.
	AccountId *string

	// The name of config rule deployed in the member account.
	//
	// This member is required.
	ConfigRuleName *string

	// Indicates deployment status for config rule in the member account. When master
	// account calls PutOrganizationConfigRule action for the first time, config rule
	// status is created in the member account. When master account calls
	// PutOrganizationConfigRule action for the second time, config rule status is
	// updated in the member account. Config rule status is deleted when the master
	// account deletes OrganizationConfigRule and disables service access for
	// config-multiaccountsetup.amazonaws.com. AWS Config sets the state of the rule
	// to:
	//
	// * CREATE_SUCCESSFUL when config rule has been created in the member
	// account.
	//
	// * CREATE_IN_PROGRESS when config rule is being created in the member
	// account.
	//
	// * CREATE_FAILED when config rule creation has failed in the member
	// account.
	//
	// * DELETE_FAILED when config rule deletion has failed in the member
	// account.
	//
	// * DELETE_IN_PROGRESS when config rule is being deleted in the member
	// account.
	//
	// * DELETE_SUCCESSFUL when config rule has been deleted in the member
	// account.
	//
	// * UPDATE_SUCCESSFUL when config rule has been updated in the member
	// account.
	//
	// * UPDATE_IN_PROGRESS when config rule is being updated in the member
	// account.
	//
	// * UPDATE_FAILED when config rule deletion has failed in the member
	// account.
	//
	// This member is required.
	MemberAccountRuleStatus MemberAccountRuleStatus

	// An error code that is returned when config rule creation or deletion failed in
	// the member account.
	ErrorCode *string

	// An error message indicating that config rule account creation or deletion has
	// failed due to an error in the member account.
	ErrorMessage *string

	// The timestamp of the last status update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// This object contains regions to set up the aggregator and an IAM role to
// retrieve organization details.
type OrganizationAggregationSource struct {

	// ARN of the IAM role used to retrieve AWS Organization details associated with
	// the aggregator account.
	//
	// This member is required.
	RoleArn *string

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions bool

	// The source regions being aggregated.
	AwsRegions []string

	noSmithyDocumentSerde
}

// An organization config rule that has information about config rules that AWS
// Config creates in member accounts.
type OrganizationConfigRule struct {

	// Amazon Resource Name (ARN) of organization config rule.
	//
	// This member is required.
	OrganizationConfigRuleArn *string

	// The name that you assign to organization config rule.
	//
	// This member is required.
	OrganizationConfigRuleName *string

	// A comma-separated list of accounts excluded from organization config rule.
	ExcludedAccounts []string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata

	noSmithyDocumentSerde
}

// Returns the status for an organization config rule in an organization.
type OrganizationConfigRuleStatus struct {

	// The name that you assign to organization config rule.
	//
	// This member is required.
	OrganizationConfigRuleName *string

	// Indicates deployment status of an organization config rule. When master account
	// calls PutOrganizationConfigRule action for the first time, config rule status is
	// created in all the member accounts. When master account calls
	// PutOrganizationConfigRule action for the second time, config rule status is
	// updated in all the member accounts. Additionally, config rule status is updated
	// when one or more member accounts join or leave an organization. Config rule
	// status is deleted when the master account deletes OrganizationConfigRule in all
	// the member accounts and disables service access for
	// config-multiaccountsetup.amazonaws.com. AWS Config sets the state of the rule
	// to:
	//
	// * CREATE_SUCCESSFUL when an organization config rule has been successfully
	// created in all the member accounts.
	//
	// * CREATE_IN_PROGRESS when an organization
	// config rule creation is in progress.
	//
	// * CREATE_FAILED when an organization
	// config rule creation failed in one or more member accounts within that
	// organization.
	//
	// * DELETE_FAILED when an organization config rule deletion failed
	// in one or more member accounts within that organization.
	//
	// * DELETE_IN_PROGRESS
	// when an organization config rule deletion is in progress.
	//
	// * DELETE_SUCCESSFUL
	// when an organization config rule has been successfully deleted from all the
	// member accounts.
	//
	// * UPDATE_SUCCESSFUL when an organization config rule has been
	// successfully updated in all the member accounts.
	//
	// * UPDATE_IN_PROGRESS when an
	// organization config rule update is in progress.
	//
	// * UPDATE_FAILED when an
	// organization config rule update failed in one or more member accounts within
	// that organization.
	//
	// This member is required.
	OrganizationRuleStatus OrganizationRuleStatus

	// An error code that is returned when organization config rule creation or
	// deletion has failed.
	ErrorCode *string

	// An error message indicating that organization config rule creation or deletion
	// failed due to an error.
	ErrorMessage *string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// An organization conformance pack that has information about conformance packs
// that AWS Config creates in member accounts.
type OrganizationConformancePack struct {

	// Last time when organization conformation pack was updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// Amazon Resource Name (ARN) of organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackArn *string

	// The name you assign to an organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackName *string

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []ConformancePackInputParameter

	// Amazon S3 bucket where AWS Config stores conformance pack templates. This field
	// is optional.
	DeliveryS3Bucket *string

	// Any folder structure you want to add to an Amazon S3 bucket. This field is
	// optional.
	DeliveryS3KeyPrefix *string

	// A comma-separated list of accounts excluded from organization conformance pack.
	ExcludedAccounts []string

	noSmithyDocumentSerde
}

// Organization conformance pack creation or deletion status in each member
// account. This includes the name of the conformance pack, the status, error code
// and error message when the conformance pack creation or deletion failed.
type OrganizationConformancePackDetailedStatus struct {

	// The 12-digit account ID of a member account.
	//
	// This member is required.
	AccountId *string

	// The name of conformance pack deployed in the member account.
	//
	// This member is required.
	ConformancePackName *string

	// Indicates deployment status for conformance pack in a member account. When
	// master account calls PutOrganizationConformancePack action for the first time,
	// conformance pack status is created in the member account. When master account
	// calls PutOrganizationConformancePack action for the second time, conformance
	// pack status is updated in the member account. Conformance pack status is deleted
	// when the master account deletes OrganizationConformancePack and disables service
	// access for config-multiaccountsetup.amazonaws.com. AWS Config sets the state of
	// the conformance pack to:
	//
	// * CREATE_SUCCESSFUL when conformance pack has been
	// created in the member account.
	//
	// * CREATE_IN_PROGRESS when conformance pack is
	// being created in the member account.
	//
	// * CREATE_FAILED when conformance pack
	// creation has failed in the member account.
	//
	// * DELETE_FAILED when conformance
	// pack deletion has failed in the member account.
	//
	// * DELETE_IN_PROGRESS when
	// conformance pack is being deleted in the member account.
	//
	// * DELETE_SUCCESSFUL
	// when conformance pack has been deleted in the member account.
	//
	// *
	// UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	// account.
	//
	// * UPDATE_IN_PROGRESS when conformance pack is being updated in the
	// member account.
	//
	// * UPDATE_FAILED when conformance pack deletion has failed in
	// the member account.
	//
	// This member is required.
	Status OrganizationResourceDetailedStatus

	// An error code that is returned when conformance pack creation or deletion failed
	// in the member account.
	ErrorCode *string

	// An error message indicating that conformance pack account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string

	// The timestamp of the last status update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// Returns the status for an organization conformance pack in an organization.
type OrganizationConformancePackStatus struct {

	// The name that you assign to organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackName *string

	// Indicates deployment status of an organization conformance pack. When master
	// account calls PutOrganizationConformancePack for the first time, conformance
	// pack status is created in all the member accounts. When master account calls
	// PutOrganizationConformancePack for the second time, conformance pack status is
	// updated in all the member accounts. Additionally, conformance pack status is
	// updated when one or more member accounts join or leave an organization.
	// Conformance pack status is deleted when the master account deletes
	// OrganizationConformancePack in all the member accounts and disables service
	// access for config-multiaccountsetup.amazonaws.com. AWS Config sets the state of
	// the conformance pack to:
	//
	// * CREATE_SUCCESSFUL when an organization conformance
	// pack has been successfully created in all the member accounts.
	//
	// *
	// CREATE_IN_PROGRESS when an organization conformance pack creation is in
	// progress.
	//
	// * CREATE_FAILED when an organization conformance pack creation failed
	// in one or more member accounts within that organization.
	//
	// * DELETE_FAILED when
	// an organization conformance pack deletion failed in one or more member accounts
	// within that organization.
	//
	// * DELETE_IN_PROGRESS when an organization conformance
	// pack deletion is in progress.
	//
	// * DELETE_SUCCESSFUL when an organization
	// conformance pack has been successfully deleted from all the member accounts.
	//
	// *
	// UPDATE_SUCCESSFUL when an organization conformance pack has been successfully
	// updated in all the member accounts.
	//
	// * UPDATE_IN_PROGRESS when an organization
	// conformance pack update is in progress.
	//
	// * UPDATE_FAILED when an organization
	// conformance pack update failed in one or more member accounts within that
	// organization.
	//
	// This member is required.
	Status OrganizationResourceStatus

	// An error code that is returned when organization conformance pack creation or
	// deletion has failed in a member account.
	ErrorCode *string

	// An error message indicating that organization conformance pack creation or
	// deletion failed due to an error.
	ErrorMessage *string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// An object that specifies organization custom rule metadata such as resource
// type, resource ID of AWS resource, Lamdba function ARN, and organization trigger
// types that trigger AWS Config to evaluate your AWS resources against a rule. It
// also provides the frequency with which you want AWS Config to run evaluations
// for the rule if the trigger type is periodic.
type OrganizationCustomRuleMetadata struct {

	// The lambda function ARN.
	//
	// This member is required.
	LambdaFunctionArn *string

	// The type of notification that triggers AWS Config to run an evaluation for a
	// rule. You can specify the following notification types:
	//
	// *
	// ConfigurationItemChangeNotification - Triggers an evaluation when AWS Config
	// delivers a configuration item as a result of a resource change.
	//
	// *
	// OversizedConfigurationItemChangeNotification - Triggers an evaluation when AWS
	// Config delivers an oversized configuration item. AWS Config may generate this
	// notification type when a resource changes and the notification exceeds the
	// maximum size allowed by Amazon SNS.
	//
	// * ScheduledNotification - Triggers a
	// periodic evaluation at the frequency specified for MaximumExecutionFrequency.
	//
	// This member is required.
	OrganizationConfigRuleTriggerTypes []OrganizationConfigRuleTriggerType

	// The description that you provide for organization config rule.
	Description *string

	// A string, in JSON format, that is passed to organization config rule Lambda
	// function.
	InputParameters *string

	// The maximum frequency with which AWS Config runs evaluations for a rule. Your
	// custom rule is triggered when AWS Config delivers the configuration snapshot.
	// For more information, see ConfigSnapshotDeliveryProperties. By default, rules
	// with a periodic trigger are evaluated every 24 hours. To change the frequency,
	// specify a valid value for the MaximumExecutionFrequency parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The ID of the AWS resource that was evaluated.
	ResourceIdScope *string

	// The type of the AWS resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// An object that specifies organization managed rule metadata such as resource
// type and ID of AWS resource along with the rule identifier. It also provides the
// frequency with which you want AWS Config to run evaluations for the rule if the
// trigger type is periodic.
type OrganizationManagedRuleMetadata struct {

	// For organization config managed rules, a predefined identifier from a list. For
	// example, IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see
	// Using AWS Managed Config Rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	//
	// This member is required.
	RuleIdentifier *string

	// The description that you provide for organization config rule.
	Description *string

	// A string, in JSON format, that is passed to organization config rule Lambda
	// function.
	InputParameters *string

	// The maximum frequency with which AWS Config runs evaluations for a rule. You are
	// using an AWS managed rule that is triggered at a periodic frequency. By default,
	// rules with a periodic trigger are evaluated every 24 hours. To change the
	// frequency, specify a valid value for the MaximumExecutionFrequency parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The ID of the AWS resource that was evaluated.
	ResourceIdScope *string

	// The type of the AWS resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// Status filter object to filter results based on specific member account ID or
// status type for an organization conformance pack.
type OrganizationResourceDetailedStatusFilters struct {

	// The 12-digit account ID of the member account within an organization.
	AccountId *string

	// Indicates deployment status for conformance pack in a member account. When
	// master account calls PutOrganizationConformancePack action for the first time,
	// conformance pack status is created in the member account. When master account
	// calls PutOrganizationConformancePack action for the second time, conformance
	// pack status is updated in the member account. Conformance pack status is deleted
	// when the master account deletes OrganizationConformancePack and disables service
	// access for config-multiaccountsetup.amazonaws.com. AWS Config sets the state of
	// the conformance pack to:
	//
	// * CREATE_SUCCESSFUL when conformance pack has been
	// created in the member account.
	//
	// * CREATE_IN_PROGRESS when conformance pack is
	// being created in the member account.
	//
	// * CREATE_FAILED when conformance pack
	// creation has failed in the member account.
	//
	// * DELETE_FAILED when conformance
	// pack deletion has failed in the member account.
	//
	// * DELETE_IN_PROGRESS when
	// conformance pack is being deleted in the member account.
	//
	// * DELETE_SUCCESSFUL
	// when conformance pack has been deleted in the member account.
	//
	// *
	// UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	// account.
	//
	// * UPDATE_IN_PROGRESS when conformance pack is being updated in the
	// member account.
	//
	// * UPDATE_FAILED when conformance pack deletion has failed in
	// the member account.
	Status OrganizationResourceDetailedStatus

	noSmithyDocumentSerde
}

// An object that represents the account ID and region of an aggregator account
// that is requesting authorization but is not yet authorized.
type PendingAggregationRequest struct {

	// The 12-digit account ID of the account requesting to aggregate data.
	RequesterAccountId *string

	// The region requesting to aggregate data.
	RequesterAwsRegion *string

	noSmithyDocumentSerde
}

// Details about the query.
type QueryInfo struct {

	// Returns a FieldInfo object.
	SelectFields []FieldInfo

	noSmithyDocumentSerde
}

// Specifies the types of AWS resource for which AWS Config records configuration
// changes. In the recording group, you specify whether all supported types or
// specific types of resources are recorded. By default, AWS Config records
// configuration changes for all supported types of regional resources that AWS
// Config discovers in the region in which it is running. Regional resources are
// tied to a region and can be used only in that region. Examples of regional
// resources are EC2 instances and EBS volumes. You can also have AWS Config record
// configuration changes for supported types of global resources (for example, IAM
// resources). Global resources are not tied to an individual region and can be
// used in all regions. The configuration details for any global resource are the
// same in all regions. If you customize AWS Config in multiple regions to record
// global resources, it will create multiple configuration items each time a global
// resource changes: one configuration item for each region. These configuration
// items will contain identical data. To prevent duplicate configuration items, you
// should consider customizing AWS Config in only one region to record global
// resources, unless you want the configuration items to be available in multiple
// regions. If you don't want AWS Config to record all resources, you can specify
// which types of resources it will record with the resourceTypes parameter. For a
// list of supported resource types, see Supported Resource Types
// (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
// For more information, see Selecting Which Resources AWS Config Records
// (https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html).
type RecordingGroup struct {

	// Specifies whether AWS Config records configuration changes for every supported
	// type of regional resource. If you set this option to true, when AWS Config adds
	// support for a new type of regional resource, it starts recording resources of
	// that type automatically. If you set this option to true, you cannot enumerate a
	// list of resourceTypes.
	AllSupported bool

	// Specifies whether AWS Config includes all supported types of global resources
	// (for example, IAM resources) with the resources that it records. Before you can
	// set this option to true, you must set the allSupported option to true. If you
	// set this option to true, when AWS Config adds support for a new type of global
	// resource, it starts recording resources of that type automatically. The
	// configuration details for any global resource are the same in all regions. To
	// prevent duplicate configuration items, you should consider customizing AWS
	// Config in only one region to record global resources.
	IncludeGlobalResourceTypes bool

	// A comma-separated list that specifies the types of AWS resources for which AWS
	// Config records configuration changes (for example, AWS::EC2::Instance or
	// AWS::CloudTrail::Trail). To record all configuration changes, you must set the
	// allSupported option to true. If you set this option to false, when AWS Config
	// adds support for a new type of resource, it will not record resources of that
	// type unless you manually add that type to your recording group. For a list of
	// valid resourceTypes values, see the resourceType Value column in Supported AWS
	// Resource Types
	// (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
	ResourceTypes []ResourceType

	noSmithyDocumentSerde
}

// The relationship of the related resource to the main resource.
type Relationship struct {

	// The type of relationship with the related resource.
	RelationshipName *string

	// The ID of the related resource (for example, sg-xxxxxx).
	ResourceId *string

	// The custom name of the related resource, if available.
	ResourceName *string

	// The resource type of the related resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// An object that represents the details about the remediation configuration that
// includes the remediation action, parameters, and data to execute the action.
type RemediationConfiguration struct {

	// The name of the AWS Config rule.
	//
	// This member is required.
	ConfigRuleName *string

	// Target ID is the name of the public document.
	//
	// This member is required.
	TargetId *string

	// The type of the target. Target executes remediation. For example, SSM document.
	//
	// This member is required.
	TargetType RemediationTargetType

	// Amazon Resource Name (ARN) of remediation configuration.
	Arn *string

	// The remediation is triggered automatically.
	Automatic bool

	// Name of the service that owns the service linked rule, if applicable.
	CreatedByService *string

	// An ExecutionControls object.
	ExecutionControls *ExecutionControls

	// The maximum number of failed attempts for auto-remediation. If you do not select
	// a number, the default is 5. For example, if you specify MaximumAutomaticAttempts
	// as 5 with RetryAttemptSeconds as 50 seconds, AWS Config will put a
	// RemediationException on your behalf for the failing resource after the 5th
	// failed attempt within 50 seconds.
	MaximumAutomaticAttempts *int32

	// An object of the RemediationParameterValue.
	Parameters map[string]RemediationParameterValue

	// The type of a resource.
	ResourceType *string

	// Maximum time in seconds that AWS Config runs auto-remediation. If you do not
	// select a number, the default is 60 seconds. For example, if you specify
	// RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5, AWS Config
	// will run auto-remediations 5 times within 50 seconds before throwing an
	// exception.
	RetryAttemptSeconds *int64

	// Version of the target. For example, version of the SSM document. If you make
	// backward incompatible changes to the SSM document, you must call
	// PutRemediationConfiguration API again to ensure the remediations can run.
	TargetVersion *string

	noSmithyDocumentSerde
}

// An object that represents the details about the remediation exception. The
// details include the rule name, an explanation of an exception, the time when the
// exception will be deleted, the resource ID, and resource type.
type RemediationException struct {

	// The name of the AWS Config rule.
	//
	// This member is required.
	ConfigRuleName *string

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// This member is required.
	ResourceId *string

	// The type of a resource.
	//
	// This member is required.
	ResourceType *string

	// The time when the remediation exception will be deleted.
	ExpirationTime *time.Time

	// An explanation of an remediation exception.
	Message *string

	noSmithyDocumentSerde
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
type RemediationExceptionResourceKey struct {

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string

	// The type of a resource.
	ResourceType *string

	noSmithyDocumentSerde
}

// Provides details of the current status of the invoked remediation action for
// that resource.
type RemediationExecutionStatus struct {

	// Start time when the remediation was executed.
	InvocationTime *time.Time

	// The time when the remediation execution was last updated.
	LastUpdatedTime *time.Time

	// The details that identify a resource within AWS Config, including the resource
	// type and resource ID.
	ResourceKey *ResourceKey

	// ENUM of the values.
	State RemediationExecutionState

	// Details of every step.
	StepDetails []RemediationExecutionStep

	noSmithyDocumentSerde
}

// Name of the step from the SSM document.
type RemediationExecutionStep struct {

	// An error message if the step was interrupted during execution.
	ErrorMessage *string

	// The details of the step.
	Name *string

	// The time when the step started.
	StartTime *time.Time

	// The valid status of the step.
	State RemediationExecutionStepState

	// The time when the step stopped.
	StopTime *time.Time

	noSmithyDocumentSerde
}

// The value is either a dynamic (resource) value or a static value. You must
// select either a dynamic value or a static value.
type RemediationParameterValue struct {

	// The value is dynamic and changes at run-time.
	ResourceValue *ResourceValue

	// The value is static and does not change at run-time.
	StaticValue *StaticValue

	noSmithyDocumentSerde
}

// An object that contains the resource type and the number of resources.
type ResourceCount struct {

	// The number of resources.
	Count int64

	// The resource type (for example, "AWS::EC2::Instance").
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Filters the resource count based on account ID, region, and resource type.
type ResourceCountFilters struct {

	// The 12-digit ID of the account.
	AccountId *string

	// The region where the account is located.
	Region *string

	// The type of the AWS resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Filters the results by resource account ID, region, resource ID, and resource
// name.
type ResourceFilters struct {

	// The 12-digit source account ID.
	AccountId *string

	// The source region.
	Region *string

	// The ID of the resource.
	ResourceId *string

	// The name of the resource.
	ResourceName *string

	noSmithyDocumentSerde
}

// The details that identify a resource that is discovered by AWS Config, including
// the resource type, ID, and (if available) the custom resource name.
type ResourceIdentifier struct {

	// The time that the resource was deleted.
	ResourceDeletionTime *time.Time

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string

	// The custom name of the resource (if available).
	ResourceName *string

	// The type of resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
type ResourceKey struct {

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// This member is required.
	ResourceId *string

	// The resource type.
	//
	// This member is required.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The dynamic value of the resource.
type ResourceValue struct {

	// The value is a resource ID.
	//
	// This member is required.
	Value ResourceValueType

	noSmithyDocumentSerde
}

// An object with the name of the retention configuration and the retention period
// in days. The object stores the configuration for data retention in AWS Config.
type RetentionConfiguration struct {

	// The name of the retention configuration object.
	//
	// This member is required.
	Name *string

	// Number of days AWS Config stores your historical information. Currently, only
	// applicable to the configuration item history.
	//
	// This member is required.
	RetentionPeriodInDays int32

	noSmithyDocumentSerde
}

// Defines which resources trigger an evaluation for an AWS Config rule. The scope
// can include one or more resource types, a combination of a tag key and value, or
// a combination of one resource type and one resource ID. Specify a scope to
// constrain which resources trigger an evaluation for a rule. Otherwise,
// evaluations for the rule are triggered when any resource in your recording group
// changes in configuration.
type Scope struct {

	// The ID of the only AWS resource that you want to trigger an evaluation for the
	// rule. If you specify a resource ID, you must specify one resource type for
	// ComplianceResourceTypes.
	ComplianceResourceId *string

	// The resource types of only those AWS resources that you want to trigger an
	// evaluation for the rule. You can only specify one type if you also specify a
	// resource ID for ComplianceResourceId.
	ComplianceResourceTypes []string

	// The tag key that is applied to only those AWS resources that you want to trigger
	// an evaluation for the rule.
	TagKey *string

	// The tag value applied to only those AWS resources that you want to trigger an
	// evaluation for the rule. If you specify a value for TagValue, you must also
	// specify a value for TagKey.
	TagValue *string

	noSmithyDocumentSerde
}

// Provides the AWS Config rule owner (AWS or customer), the rule identifier, and
// the events that trigger the evaluation of your AWS resources.
type Source struct {

	// Indicates whether AWS or the customer owns and manages the AWS Config rule.
	//
	// This member is required.
	Owner Owner

	// For AWS Config managed rules, a predefined identifier from a list. For example,
	// IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see Using
	// AWS Managed Config Rules
	// (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	// For custom rules, the identifier is the Amazon Resource Name (ARN) of the rule's
	// AWS Lambda function, such as
	// arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name.
	//
	// This member is required.
	SourceIdentifier *string

	// Provides the source and type of the event that causes AWS Config to evaluate
	// your AWS resources.
	SourceDetails []SourceDetail

	noSmithyDocumentSerde
}

// Provides the source and the message types that trigger AWS Config to evaluate
// your AWS resources against a rule. It also provides the frequency with which you
// want AWS Config to run evaluations for the rule if the trigger type is periodic.
// You can specify the parameter values for SourceDetail only for custom rules.
type SourceDetail struct {

	// The source of the event, such as an AWS service, that triggers AWS Config to
	// evaluate your AWS resources.
	EventSource EventSource

	// The frequency at which you want AWS Config to run evaluations for a custom rule
	// with a periodic trigger. If you specify a value for MaximumExecutionFrequency,
	// then MessageType must use the ScheduledNotification value. By default, rules
	// with a periodic trigger are evaluated every 24 hours. To change the frequency,
	// specify a valid value for the MaximumExecutionFrequency parameter. Based on the
	// valid value you choose, AWS Config runs evaluations once for each valid value.
	// For example, if you choose Three_Hours, AWS Config runs evaluations once every
	// three hours. In this case, Three_Hours is the frequency of this rule.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The type of notification that triggers AWS Config to run an evaluation for a
	// rule. You can specify the following notification types:
	//
	// *
	// ConfigurationItemChangeNotification - Triggers an evaluation when AWS Config
	// delivers a configuration item as a result of a resource change.
	//
	// *
	// OversizedConfigurationItemChangeNotification - Triggers an evaluation when AWS
	// Config delivers an oversized configuration item. AWS Config may generate this
	// notification type when a resource changes and the notification exceeds the
	// maximum size allowed by Amazon SNS.
	//
	// * ScheduledNotification - Triggers a
	// periodic evaluation at the frequency specified for MaximumExecutionFrequency.
	//
	// *
	// ConfigurationSnapshotDeliveryCompleted - Triggers a periodic evaluation when AWS
	// Config delivers a configuration snapshot.
	//
	// If you want your custom rule to be
	// triggered by configuration changes, specify two SourceDetail objects, one for
	// ConfigurationItemChangeNotification and one for
	// OversizedConfigurationItemChangeNotification.
	MessageType MessageType

	noSmithyDocumentSerde
}

// AWS Systems Manager (SSM) specific remediation controls.
type SsmControls struct {

	// The maximum percentage of remediation actions allowed to run in parallel on the
	// non-compliant resources for that specific rule. You can specify a percentage,
	// such as 10%. The default value is 10.
	ConcurrentExecutionRatePercentage *int32

	// The percentage of errors that are allowed before SSM stops running automations
	// on non-compliant resources for that specific rule. You can specify a percentage
	// of errors, for example 10%. If you do not specifiy a percentage, the default is
	// 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant
	// resources, then SSM stops running the automations when the fifth error is
	// received.
	ErrorPercentage *int32

	noSmithyDocumentSerde
}

// The static value of the resource.
type StaticValue struct {

	// A list of values. For example, the ARN of the assumed role.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Status filter object to filter results based on specific member account ID or
// status type for an organization config rule.
type StatusDetailFilters struct {

	// The 12-digit account ID of the member account within an organization.
	AccountId *string

	// Indicates deployment status for config rule in the member account. When master
	// account calls PutOrganizationConfigRule action for the first time, config rule
	// status is created in the member account. When master account calls
	// PutOrganizationConfigRule action for the second time, config rule status is
	// updated in the member account. Config rule status is deleted when the master
	// account deletes OrganizationConfigRule and disables service access for
	// config-multiaccountsetup.amazonaws.com. AWS Config sets the state of the rule
	// to:
	//
	// * CREATE_SUCCESSFUL when config rule has been created in the member
	// account.
	//
	// * CREATE_IN_PROGRESS when config rule is being created in the member
	// account.
	//
	// * CREATE_FAILED when config rule creation has failed in the member
	// account.
	//
	// * DELETE_FAILED when config rule deletion has failed in the member
	// account.
	//
	// * DELETE_IN_PROGRESS when config rule is being deleted in the member
	// account.
	//
	// * DELETE_SUCCESSFUL when config rule has been deleted in the member
	// account.
	//
	// * UPDATE_SUCCESSFUL when config rule has been updated in the member
	// account.
	//
	// * UPDATE_IN_PROGRESS when config rule is being updated in the member
	// account.
	//
	// * UPDATE_FAILED when config rule deletion has failed in the member
	// account.
	MemberAccountRuleStatus MemberAccountRuleStatus

	noSmithyDocumentSerde
}

// Provides the details of a stored query.
type StoredQuery struct {

	// The name of the query.
	//
	// This member is required.
	QueryName *string

	// A unique description for the query.
	Description *string

	// The expression of the query. For example, SELECT resourceId, resourceType,
	// supplementaryConfiguration.BucketVersioningConfiguration.status WHERE
	// resourceType = 'AWS::S3::Bucket' AND
	// supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.
	Expression *string

	// Amazon Resource Name (ARN) of the query. For example,
	// arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	QueryArn *string

	// The ID of the query.
	QueryId *string

	noSmithyDocumentSerde
}

// Returns details of a specific query.
type StoredQueryMetadata struct {

	// Amazon Resource Name (ARN) of the query. For example,
	// arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	//
	// This member is required.
	QueryArn *string

	// The ID of the query.
	//
	// This member is required.
	QueryId *string

	// The name of the query.
	//
	// This member is required.
	QueryName *string

	// A unique description for the query.
	Description *string

	noSmithyDocumentSerde
}

// The tags for the resource. The metadata that you apply to a resource to help you
// categorize and organize them. Each tag consists of a key and an optional value,
// both of which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
type Tag struct {

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	Key *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
