// Code generated by smithy-go-codegen DO NOT EDIT.

package s3vectors

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
//
// Returns a list of all the vector buckets that are owned by the authenticated
// sender of the request.
//
// Permissions You must have the s3vectors:ListVectorBuckets permission to use
// this operation.
func (c *Client) ListVectorBuckets(ctx context.Context, params *ListVectorBucketsInput, optFns ...func(*Options)) (*ListVectorBucketsOutput, error) {
	if params == nil {
		params = &ListVectorBucketsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVectorBuckets", params, optFns, c.addOperationListVectorBucketsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVectorBucketsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVectorBucketsInput struct {

	// The maximum number of vector buckets to be returned in the response.
	MaxResults *int32

	// The previous pagination token.
	NextToken *string

	// Limits the response to vector buckets that begin with the specified prefix.
	Prefix *string

	noSmithyDocumentSerde
}

type ListVectorBucketsOutput struct {

	// The list of vector buckets owned by the requester.
	//
	// This member is required.
	VectorBuckets []types.VectorBucketSummary

	// The element is included in the response when there are more buckets to be
	// listed with pagination.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVectorBucketsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVectorBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVectorBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVectorBuckets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVectorBuckets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListVectorBucketsPaginatorOptions is the paginator options for ListVectorBuckets
type ListVectorBucketsPaginatorOptions struct {
	// The maximum number of vector buckets to be returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVectorBucketsPaginator is a paginator for ListVectorBuckets
type ListVectorBucketsPaginator struct {
	options   ListVectorBucketsPaginatorOptions
	client    ListVectorBucketsAPIClient
	params    *ListVectorBucketsInput
	nextToken *string
	firstPage bool
}

// NewListVectorBucketsPaginator returns a new ListVectorBucketsPaginator
func NewListVectorBucketsPaginator(client ListVectorBucketsAPIClient, params *ListVectorBucketsInput, optFns ...func(*ListVectorBucketsPaginatorOptions)) *ListVectorBucketsPaginator {
	if params == nil {
		params = &ListVectorBucketsInput{}
	}

	options := ListVectorBucketsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVectorBucketsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVectorBucketsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVectorBuckets page.
func (p *ListVectorBucketsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVectorBucketsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListVectorBuckets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListVectorBucketsAPIClient is a client that implements the ListVectorBuckets
// operation.
type ListVectorBucketsAPIClient interface {
	ListVectorBuckets(context.Context, *ListVectorBucketsInput, ...func(*Options)) (*ListVectorBucketsOutput, error)
}

var _ ListVectorBucketsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListVectorBuckets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVectorBuckets",
	}
}
