// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Begins the flushing of traffic from the firewall, according to the filters you
// define. When the operation starts, impacted flows are temporarily marked as
// timed out before the Suricata engine prunes, or flushes, the flows from the
// firewall table.
//
// While the flush completes, impacted flows are processed as midstream traffic.
// This may result in a temporary increase in midstream traffic metrics. We
// recommend that you double check your stream exception policy before you perform
// a flush operation.
func (c *Client) StartFlowFlush(ctx context.Context, params *StartFlowFlushInput, optFns ...func(*Options)) (*StartFlowFlushOutput, error) {
	if params == nil {
		params = &StartFlowFlushInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartFlowFlush", params, optFns, c.addOperationStartFlowFlushMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartFlowFlushOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartFlowFlushInput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	//
	// This member is required.
	FlowFilters []types.FlowFilter

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The reqested FlowOperation ignores flows with an age (in seconds) lower than
	// MinimumFlowAgeInSeconds . You provide this for start commands.
	MinimumFlowAgeInSeconds *int32

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	// A unique identifier for the primary endpoint associated with a firewall.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

type StartFlowFlushOutput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	FlowOperationId *string

	// Returns the status of the flow operation. This string is returned in the
	// responses to start, list, and describe commands.
	//
	// If the status is COMPLETED_WITH_ERRORS , results may be returned with any number
	// of Flows missing from the response. If the status is FAILED , Flows returned
	// will be empty.
	FlowOperationStatus types.FlowOperationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartFlowFlushMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartFlowFlush{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartFlowFlush{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartFlowFlush"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartFlowFlushValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartFlowFlush(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartFlowFlush(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartFlowFlush",
	}
}
