// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Copy the destination image set.
type CopyDestinationImageSet struct {

	// The image set identifier for the destination image set.
	//
	// This member is required.
	ImageSetId *string

	// The latest version identifier for the destination image set.
	//
	// This member is required.
	LatestVersionId *string

	noSmithyDocumentSerde
}

// Copy the image set properties of the destination image set.
type CopyDestinationImageSetProperties struct {

	// The image set identifier of the copied image set properties.
	//
	// This member is required.
	ImageSetId *string

	// The latest version identifier for the destination image set properties.
	//
	// This member is required.
	LatestVersionId *string

	// The timestamp when the destination image set properties were created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) assigned to the destination image set.
	ImageSetArn *string

	// The image set state of the destination image set properties.
	ImageSetState ImageSetState

	// The image set workflow status of the destination image set properties.
	ImageSetWorkflowStatus ImageSetWorkflowStatus

	// The timestamp when the destination image set properties were last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Copy image set information.
type CopyImageSetInformation struct {

	// The source image set.
	//
	// This member is required.
	SourceImageSet *CopySourceImageSetInformation

	// The destination image set.
	DestinationImageSet *CopyDestinationImageSet

	noSmithyDocumentSerde
}

// Copy source image set information.
type CopySourceImageSetInformation struct {

	// The latest version identifier for the source image set.
	//
	// This member is required.
	LatestVersionId *string

	// Contains MetadataCopies structure and wraps information related to specific
	// copy use cases. For example, when copying subsets.
	DICOMCopies *MetadataCopies

	noSmithyDocumentSerde
}

// Copy source image set properties.
type CopySourceImageSetProperties struct {

	// The image set identifier for the copied source image set.
	//
	// This member is required.
	ImageSetId *string

	// The latest version identifier for the copied source image set.
	//
	// This member is required.
	LatestVersionId *string

	// The timestamp when the source image set properties were created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) assigned to the source image set.
	ImageSetArn *string

	// The image set state of the copied source image set.
	ImageSetState ImageSetState

	// The workflow status of the copied source image set.
	ImageSetWorkflowStatus ImageSetWorkflowStatus

	// The timestamp when the source image set properties were updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The properties associated with the data store.
type DatastoreProperties struct {

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The data store name.
	//
	// This member is required.
	DatastoreName *string

	// The data store status.
	//
	// This member is required.
	DatastoreStatus DatastoreStatus

	// The timestamp when the data store was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) for the data store.
	DatastoreArn *string

	// The Amazon Resource Name (ARN) assigned to the Key Management Service (KMS) key
	// for accessing encrypted data.
	KmsKeyArn *string

	// The timestamp when the data store was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// List of summaries of data stores.
type DatastoreSummary struct {

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The data store name.
	//
	// This member is required.
	DatastoreName *string

	// The data store status.
	//
	// This member is required.
	DatastoreStatus DatastoreStatus

	// The timestamp when the data store was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) for the data store.
	DatastoreArn *string

	// The timestamp when the data store was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Properties of the import job.
type DICOMImportJobProperties struct {

	// The Amazon Resource Name (ARN) that grants permissions to access medical
	// imaging resources.
	//
	// This member is required.
	DataAccessRoleArn *string

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The input prefix path for the S3 bucket that contains the DICOM P10 files to be
	// imported.
	//
	// This member is required.
	InputS3Uri *string

	// The import job identifier.
	//
	// This member is required.
	JobId *string

	// The import job name.
	//
	// This member is required.
	JobName *string

	// The filters for listing import jobs based on status.
	//
	// This member is required.
	JobStatus JobStatus

	// The output prefix of the S3 bucket to upload the results of the DICOM import
	// job.
	//
	// This member is required.
	OutputS3Uri *string

	// The timestamp for when the import job was ended.
	EndedAt *time.Time

	// The error message thrown if an import job fails.
	Message *string

	// The timestamp for when the import job was submitted.
	SubmittedAt *time.Time

	noSmithyDocumentSerde
}

// Summary of import job.
type DICOMImportJobSummary struct {

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The import job identifier.
	//
	// This member is required.
	JobId *string

	// The import job name.
	//
	// This member is required.
	JobName *string

	// The filters for listing import jobs based on status.
	//
	// This member is required.
	JobStatus JobStatus

	// The Amazon Resource Name (ARN) that grants permissions to access medical
	// imaging resources.
	DataAccessRoleArn *string

	// The timestamp when an import job ended.
	EndedAt *time.Time

	// The error message thrown if an import job fails.
	Message *string

	// The timestamp when an import job was submitted.
	SubmittedAt *time.Time

	noSmithyDocumentSerde
}

// The aggregated structure to store DICOM study date and study time for search
// capabilities.
type DICOMStudyDateAndTime struct {

	// The DICOM study date provided in yyMMdd format.
	//
	// This member is required.
	DICOMStudyDate *string

	// The DICOM study time provided in HHmmss.FFFFFF format.
	DICOMStudyTime *string

	noSmithyDocumentSerde
}

// The DICOM attributes returned as a part of a response. Each image set has these
// properties as part of a search result.
type DICOMTags struct {

	// The accession number for the DICOM study.
	DICOMAccessionNumber *string

	// The total number of instances in the DICOM study.
	DICOMNumberOfStudyRelatedInstances int32

	// The total number of series in the DICOM study.
	DICOMNumberOfStudyRelatedSeries int32

	// The patient birth date.
	DICOMPatientBirthDate *string

	// The unique identifier for a patient in a DICOM Study.
	DICOMPatientId *string

	// The patient name.
	DICOMPatientName *string

	// The patient sex.
	DICOMPatientSex *string

	// The DICOM provided identifier for the series Body Part Examined.
	DICOMSeriesBodyPart *string

	// The DICOM provided identifier for the Series Instance UID.
	DICOMSeriesInstanceUID *string

	// The DICOM provided identifier for the series Modality.
	DICOMSeriesModality *string

	// The DICOM provided identifier for the Series Number.
	DICOMSeriesNumber *int32

	// The study date.
	DICOMStudyDate *string

	// The DICOM provided Study Description.
	DICOMStudyDescription *string

	// The DICOM provided identifier for the Study ID.
	DICOMStudyId *string

	// The DICOM provided identifier for the Study Instance UID.
	DICOMStudyInstanceUID *string

	// The study time.
	DICOMStudyTime *string

	noSmithyDocumentSerde
}

// The object containing removableAttributes and updatableAttributes .
type DICOMUpdates struct {

	// The DICOM tags to be removed from ImageSetMetadata .
	RemovableAttributes []byte

	// The DICOM tags that need to be updated in ImageSetMetadata .
	UpdatableAttributes []byte

	noSmithyDocumentSerde
}

// Information about the image frame (pixel data) identifier.
type ImageFrameInformation struct {

	// The image frame (pixel data) identifier.
	//
	// This member is required.
	ImageFrameId *string

	noSmithyDocumentSerde
}

// The image set properties.
type ImageSetProperties struct {

	// The image set identifier.
	//
	// This member is required.
	ImageSetId *string

	// The image set state.
	//
	// This member is required.
	ImageSetState ImageSetState

	// The image set version identifier.
	//
	// This member is required.
	VersionId *string

	// The timestamp when the image set properties were created.
	CreatedAt *time.Time

	// The timestamp when the image set properties were deleted.
	DeletedAt *time.Time

	// The image set workflow status.
	ImageSetWorkflowStatus ImageSetWorkflowStatus

	// The flag to determine whether the image set is primary or not.
	IsPrimary *bool

	// The error message thrown if an image set action fails.
	Message *string

	// Contains details on overrides used when creating the returned version of an
	// image set. For example, if forced exists, the forced flag was used when
	// creating the image set.
	Overrides *Overrides

	// The timestamp when the image set properties were updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary of the image set metadata.
type ImageSetsMetadataSummary struct {

	// The image set identifier.
	//
	// This member is required.
	ImageSetId *string

	// The time an image set is created. Sample creation date is provided in
	// 1985-04-12T23:20:50.52Z format.
	CreatedAt *time.Time

	// The DICOM tags associated with the image set.
	DICOMTags *DICOMTags

	// The flag to determine whether the image set is primary or not.
	IsPrimary *bool

	// The time an image set was last updated.
	UpdatedAt *time.Time

	// The image set version.
	Version *int32

	noSmithyDocumentSerde
}

// Contains copiable Attributes structure and wraps information related to
// specific copy use cases. For example, when copying subsets.
type MetadataCopies struct {

	// The JSON string used to specify a subset of SOP Instances to copy from source
	// to destination image set.
	//
	// This member is required.
	CopiableAttributes *string

	noSmithyDocumentSerde
}

// Contains DICOMUpdates.
//
// The following types satisfy this interface:
//
//	MetadataUpdatesMemberDICOMUpdates
//	MetadataUpdatesMemberRevertToVersionId
type MetadataUpdates interface {
	isMetadataUpdates()
}

// The object containing removableAttributes and updatableAttributes .
type MetadataUpdatesMemberDICOMUpdates struct {
	Value DICOMUpdates

	noSmithyDocumentSerde
}

func (*MetadataUpdatesMemberDICOMUpdates) isMetadataUpdates() {}

// Specifies the previous image set version ID to revert the current image set
// back to.
//
// You must provide either revertToVersionId or DICOMUpdates in your request. A
// ValidationException error is thrown if both parameters are provided at the same
// time.
type MetadataUpdatesMemberRevertToVersionId struct {
	Value string

	noSmithyDocumentSerde
}

func (*MetadataUpdatesMemberRevertToVersionId) isMetadataUpdates() {}

// Specifies the overrides used in image set modification calls to CopyImageSet
// and UpdateImageSetMetadata .
type Overrides struct {

	// Providing this parameter will force completion of the CopyImageSet and
	// UpdateImageSetMetadata actions, even if metadata is inconsistent at the Patient,
	// Study, and/or Series levels.
	Forced *bool

	noSmithyDocumentSerde
}

// The search input attribute value.
//
// The following types satisfy this interface:
//
//	SearchByAttributeValueMemberCreatedAt
//	SearchByAttributeValueMemberDICOMAccessionNumber
//	SearchByAttributeValueMemberDICOMPatientId
//	SearchByAttributeValueMemberDICOMSeriesInstanceUID
//	SearchByAttributeValueMemberDICOMStudyDateAndTime
//	SearchByAttributeValueMemberDICOMStudyId
//	SearchByAttributeValueMemberDICOMStudyInstanceUID
//	SearchByAttributeValueMemberIsPrimary
//	SearchByAttributeValueMemberUpdatedAt
type SearchByAttributeValue interface {
	isSearchByAttributeValue()
}

// The created at time of the image set provided for search.
type SearchByAttributeValueMemberCreatedAt struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberCreatedAt) isSearchByAttributeValue() {}

// The DICOM accession number for search.
type SearchByAttributeValueMemberDICOMAccessionNumber struct {
	Value string

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMAccessionNumber) isSearchByAttributeValue() {}

// The patient ID input for search.
type SearchByAttributeValueMemberDICOMPatientId struct {
	Value string

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMPatientId) isSearchByAttributeValue() {}

// The Series Instance UID input for search.
type SearchByAttributeValueMemberDICOMSeriesInstanceUID struct {
	Value string

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMSeriesInstanceUID) isSearchByAttributeValue() {}

// The aggregated structure containing DICOM study date and study time for search.
type SearchByAttributeValueMemberDICOMStudyDateAndTime struct {
	Value DICOMStudyDateAndTime

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMStudyDateAndTime) isSearchByAttributeValue() {}

// The DICOM study ID for search.
type SearchByAttributeValueMemberDICOMStudyId struct {
	Value string

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMStudyId) isSearchByAttributeValue() {}

// The DICOM study instance UID for search.
type SearchByAttributeValueMemberDICOMStudyInstanceUID struct {
	Value string

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberDICOMStudyInstanceUID) isSearchByAttributeValue() {}

// The primary image set flag provided for search.
type SearchByAttributeValueMemberIsPrimary struct {
	Value bool

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberIsPrimary) isSearchByAttributeValue() {}

// The timestamp input for search.
type SearchByAttributeValueMemberUpdatedAt struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*SearchByAttributeValueMemberUpdatedAt) isSearchByAttributeValue() {}

// The search criteria.
type SearchCriteria struct {

	// The filters for the search criteria.
	Filters []SearchFilter

	// The sort input for search criteria.
	Sort *Sort

	noSmithyDocumentSerde
}

// The search filter.
type SearchFilter struct {

	// The search filter operator for imageSetDateTime .
	//
	// This member is required.
	Operator Operator

	// The search filter values.
	//
	// This member is required.
	Values []SearchByAttributeValue

	noSmithyDocumentSerde
}

// Sort search results.
type Sort struct {

	// The sort field for search criteria.
	//
	// This member is required.
	SortField SortField

	// The sort order for search criteria.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isMetadataUpdates()        {}
func (*UnknownUnionMember) isSearchByAttributeValue() {}
