// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacemetering

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/marketplacemetering/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// API to emit metering records. For identical requests, the API is idempotent and
// returns the metering record ID. This is used for metering flexible consumption
// pricing (FCP) Amazon Machine Images (AMI) and container products.
//
// MeterUsage is authenticated on the buyer's Amazon Web Services account using
// credentials from the Amazon EC2 instance, Amazon ECS task, or Amazon EKS pod.
//
// MeterUsage can optionally include multiple usage allocations, to provide
// customers with usage data split into buckets by tags that you define (or allow
// the customer to define).
//
// Usage records are expected to be submitted as quickly as possible after the
// event that is being recorded, and are not accepted more than 6 hours after the
// event.
//
// For Amazon Web Services Regions that support MeterUsage , see [MeterUsage Region support for Amazon EC2] and [MeterUsage Region support for Amazon ECS and Amazon EKS].
//
// [MeterUsage Region support for Amazon ECS and Amazon EKS]: https://docs.aws.amazon.com/marketplace/latest/APIReference/metering-regions.html#meterusage-region-support-ecs-eks
// [MeterUsage Region support for Amazon EC2]: https://docs.aws.amazon.com/marketplace/latest/APIReference/metering-regions.html#meterusage-region-support-ec2
func (c *Client) MeterUsage(ctx context.Context, params *MeterUsageInput, optFns ...func(*Options)) (*MeterUsageOutput, error) {
	if params == nil {
		params = &MeterUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "MeterUsage", params, optFns, c.addOperationMeterUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*MeterUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type MeterUsageInput struct {

	// Product code is used to uniquely identify a product in Amazon Web Services
	// Marketplace. The product code should be the same as the one used during the
	// publishing of a new product.
	//
	// This member is required.
	ProductCode *string

	// Timestamp, in UTC, for which the usage is being reported. Your application can
	// meter usage for up to six hours in the past. Make sure the timestamp value is
	// not before the start of the software usage.
	//
	// This member is required.
	Timestamp *time.Time

	// It will be one of the fcp dimension name provided during the publishing of the
	// product.
	//
	// This member is required.
	UsageDimension *string

	// Checks whether you have the permissions required for the action, but does not
	// make the request. If you have the permissions, the request returns
	// DryRunOperation ; otherwise, it returns UnauthorizedException . Defaults to
	// false if not specified.
	DryRun *bool

	// The set of UsageAllocations to submit.
	//
	// The sum of all UsageAllocation quantities must equal the UsageQuantity of the
	// MeterUsage request, and each UsageAllocation must have a unique set of tags
	// (include no tags).
	UsageAllocations []types.UsageAllocation

	// Consumption value for the hour. Defaults to 0 if not specified.
	UsageQuantity *int32

	noSmithyDocumentSerde
}

type MeterUsageOutput struct {

	// Metering record id.
	MeteringRecordId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationMeterUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpMeterUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpMeterUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "MeterUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpMeterUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opMeterUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opMeterUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "MeterUsage",
	}
}
