// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalyticsv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption struct {
}

func (*awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationCloudWatchLoggingOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationCloudWatchLoggingOption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationCloudWatchLoggingOptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationInput struct {
}

func (*awsAwsjson11_serializeOpAddApplicationInput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationInput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration struct {
}

func (*awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationInputProcessingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationInputProcessingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationInputProcessingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationOutput struct {
}

func (*awsAwsjson11_serializeOpAddApplicationOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationOutput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationReferenceDataSource struct {
}

func (*awsAwsjson11_serializeOpAddApplicationReferenceDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationReferenceDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationReferenceDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationReferenceDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationReferenceDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationVpcConfiguration struct {
}

func (*awsAwsjson11_serializeOpAddApplicationVpcConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationVpcConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationVpcConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.AddApplicationVpcConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationVpcConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateApplication struct {
}

func (*awsAwsjson11_serializeOpCreateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.CreateApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateApplicationPresignedUrl struct {
}

func (*awsAwsjson11_serializeOpCreateApplicationPresignedUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateApplicationPresignedUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationPresignedUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.CreateApplicationPresignedUrl")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateApplicationPresignedUrlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateApplicationSnapshot struct {
}

func (*awsAwsjson11_serializeOpCreateApplicationSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateApplicationSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.CreateApplicationSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateApplicationSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplication struct {
}

func (*awsAwsjson11_serializeOpDeleteApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationCloudWatchLoggingOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationCloudWatchLoggingOption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationCloudWatchLoggingOptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInputProcessingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationInputProcessingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationInputProcessingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationOutput struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationOutput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationReferenceDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationReferenceDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationReferenceDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationSnapshot struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationVpcConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationVpcConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationVpcConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationVpcConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DeleteApplicationVpcConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationVpcConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplication struct {
}

func (*awsAwsjson11_serializeOpDescribeApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DescribeApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplicationOperation struct {
}

func (*awsAwsjson11_serializeOpDescribeApplicationOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplicationOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DescribeApplicationOperation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationOperationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplicationSnapshot struct {
}

func (*awsAwsjson11_serializeOpDescribeApplicationSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplicationSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DescribeApplicationSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplicationVersion struct {
}

func (*awsAwsjson11_serializeOpDescribeApplicationVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplicationVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DescribeApplicationVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDiscoverInputSchema struct {
}

func (*awsAwsjson11_serializeOpDiscoverInputSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDiscoverInputSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DiscoverInputSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.DiscoverInputSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDiscoverInputSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplicationOperations struct {
}

func (*awsAwsjson11_serializeOpListApplicationOperations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplicationOperations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationOperationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.ListApplicationOperations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationOperationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplications struct {
}

func (*awsAwsjson11_serializeOpListApplications) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.ListApplications")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplicationSnapshots struct {
}

func (*awsAwsjson11_serializeOpListApplicationSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplicationSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.ListApplicationSnapshots")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationSnapshotsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplicationVersions struct {
}

func (*awsAwsjson11_serializeOpListApplicationVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplicationVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.ListApplicationVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRollbackApplication struct {
}

func (*awsAwsjson11_serializeOpRollbackApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRollbackApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RollbackApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.RollbackApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRollbackApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartApplication struct {
}

func (*awsAwsjson11_serializeOpStartApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.StartApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopApplication struct {
}

func (*awsAwsjson11_serializeOpStopApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.StopApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateApplication struct {
}

func (*awsAwsjson11_serializeOpUpdateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.UpdateApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateApplicationMaintenanceConfiguration struct {
}

func (*awsAwsjson11_serializeOpUpdateApplicationMaintenanceConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateApplicationMaintenanceConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationMaintenanceConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20180523.UpdateApplicationMaintenanceConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateApplicationMaintenanceConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentApplicationCodeConfiguration(v *types.ApplicationCodeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeContent != nil {
		ok := object.Key("CodeContent")
		if err := awsAwsjson11_serializeDocumentCodeContent(v.CodeContent, ok); err != nil {
			return err
		}
	}

	if len(v.CodeContentType) > 0 {
		ok := object.Key("CodeContentType")
		ok.String(string(v.CodeContentType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationCodeConfigurationUpdate(v *types.ApplicationCodeConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CodeContentTypeUpdate) > 0 {
		ok := object.Key("CodeContentTypeUpdate")
		ok.String(string(v.CodeContentTypeUpdate))
	}

	if v.CodeContentUpdate != nil {
		ok := object.Key("CodeContentUpdate")
		if err := awsAwsjson11_serializeDocumentCodeContentUpdate(v.CodeContentUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationConfiguration(v *types.ApplicationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationCodeConfiguration != nil {
		ok := object.Key("ApplicationCodeConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationCodeConfiguration(v.ApplicationCodeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ApplicationEncryptionConfiguration != nil {
		ok := object.Key("ApplicationEncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationEncryptionConfiguration(v.ApplicationEncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ApplicationSnapshotConfiguration != nil {
		ok := object.Key("ApplicationSnapshotConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationSnapshotConfiguration(v.ApplicationSnapshotConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ApplicationSystemRollbackConfiguration != nil {
		ok := object.Key("ApplicationSystemRollbackConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationSystemRollbackConfiguration(v.ApplicationSystemRollbackConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentProperties != nil {
		ok := object.Key("EnvironmentProperties")
		if err := awsAwsjson11_serializeDocumentEnvironmentProperties(v.EnvironmentProperties, ok); err != nil {
			return err
		}
	}

	if v.FlinkApplicationConfiguration != nil {
		ok := object.Key("FlinkApplicationConfiguration")
		if err := awsAwsjson11_serializeDocumentFlinkApplicationConfiguration(v.FlinkApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SqlApplicationConfiguration != nil {
		ok := object.Key("SqlApplicationConfiguration")
		if err := awsAwsjson11_serializeDocumentSqlApplicationConfiguration(v.SqlApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.VpcConfigurations != nil {
		ok := object.Key("VpcConfigurations")
		if err := awsAwsjson11_serializeDocumentVpcConfigurations(v.VpcConfigurations, ok); err != nil {
			return err
		}
	}

	if v.ZeppelinApplicationConfiguration != nil {
		ok := object.Key("ZeppelinApplicationConfiguration")
		if err := awsAwsjson11_serializeDocumentZeppelinApplicationConfiguration(v.ZeppelinApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationConfigurationUpdate(v *types.ApplicationConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationCodeConfigurationUpdate != nil {
		ok := object.Key("ApplicationCodeConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationCodeConfigurationUpdate(v.ApplicationCodeConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ApplicationEncryptionConfigurationUpdate != nil {
		ok := object.Key("ApplicationEncryptionConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationEncryptionConfigurationUpdate(v.ApplicationEncryptionConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ApplicationSnapshotConfigurationUpdate != nil {
		ok := object.Key("ApplicationSnapshotConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationSnapshotConfigurationUpdate(v.ApplicationSnapshotConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ApplicationSystemRollbackConfigurationUpdate != nil {
		ok := object.Key("ApplicationSystemRollbackConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationSystemRollbackConfigurationUpdate(v.ApplicationSystemRollbackConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentPropertyUpdates != nil {
		ok := object.Key("EnvironmentPropertyUpdates")
		if err := awsAwsjson11_serializeDocumentEnvironmentPropertyUpdates(v.EnvironmentPropertyUpdates, ok); err != nil {
			return err
		}
	}

	if v.FlinkApplicationConfigurationUpdate != nil {
		ok := object.Key("FlinkApplicationConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentFlinkApplicationConfigurationUpdate(v.FlinkApplicationConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.SqlApplicationConfigurationUpdate != nil {
		ok := object.Key("SqlApplicationConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentSqlApplicationConfigurationUpdate(v.SqlApplicationConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.VpcConfigurationUpdates != nil {
		ok := object.Key("VpcConfigurationUpdates")
		if err := awsAwsjson11_serializeDocumentVpcConfigurationUpdates(v.VpcConfigurationUpdates, ok); err != nil {
			return err
		}
	}

	if v.ZeppelinApplicationConfigurationUpdate != nil {
		ok := object.Key("ZeppelinApplicationConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentZeppelinApplicationConfigurationUpdate(v.ZeppelinApplicationConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationEncryptionConfiguration(v *types.ApplicationEncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyId != nil {
		ok := object.Key("KeyId")
		ok.String(*v.KeyId)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("KeyType")
		ok.String(string(v.KeyType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationEncryptionConfigurationUpdate(v *types.ApplicationEncryptionConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdUpdate != nil {
		ok := object.Key("KeyIdUpdate")
		ok.String(*v.KeyIdUpdate)
	}

	if len(v.KeyTypeUpdate) > 0 {
		ok := object.Key("KeyTypeUpdate")
		ok.String(string(v.KeyTypeUpdate))
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationMaintenanceConfigurationUpdate(v *types.ApplicationMaintenanceConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationMaintenanceWindowStartTimeUpdate != nil {
		ok := object.Key("ApplicationMaintenanceWindowStartTimeUpdate")
		ok.String(*v.ApplicationMaintenanceWindowStartTimeUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationRestoreConfiguration(v *types.ApplicationRestoreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApplicationRestoreType) > 0 {
		ok := object.Key("ApplicationRestoreType")
		ok.String(string(v.ApplicationRestoreType))
	}

	if v.SnapshotName != nil {
		ok := object.Key("SnapshotName")
		ok.String(*v.SnapshotName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationSnapshotConfiguration(v *types.ApplicationSnapshotConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SnapshotsEnabled != nil {
		ok := object.Key("SnapshotsEnabled")
		ok.Boolean(*v.SnapshotsEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationSnapshotConfigurationUpdate(v *types.ApplicationSnapshotConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SnapshotsEnabledUpdate != nil {
		ok := object.Key("SnapshotsEnabledUpdate")
		ok.Boolean(*v.SnapshotsEnabledUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationSystemRollbackConfiguration(v *types.ApplicationSystemRollbackConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RollbackEnabled != nil {
		ok := object.Key("RollbackEnabled")
		ok.Boolean(*v.RollbackEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationSystemRollbackConfigurationUpdate(v *types.ApplicationSystemRollbackConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RollbackEnabledUpdate != nil {
		ok := object.Key("RollbackEnabledUpdate")
		ok.Boolean(*v.RollbackEnabledUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogConfiguration(v *types.CatalogConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlueDataCatalogConfiguration != nil {
		ok := object.Key("GlueDataCatalogConfiguration")
		if err := awsAwsjson11_serializeDocumentGlueDataCatalogConfiguration(v.GlueDataCatalogConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCatalogConfigurationUpdate(v *types.CatalogConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlueDataCatalogConfigurationUpdate != nil {
		ok := object.Key("GlueDataCatalogConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentGlueDataCatalogConfigurationUpdate(v.GlueDataCatalogConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCheckpointConfiguration(v *types.CheckpointConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckpointingEnabled != nil {
		ok := object.Key("CheckpointingEnabled")
		ok.Boolean(*v.CheckpointingEnabled)
	}

	if v.CheckpointInterval != nil {
		ok := object.Key("CheckpointInterval")
		ok.Long(*v.CheckpointInterval)
	}

	if len(v.ConfigurationType) > 0 {
		ok := object.Key("ConfigurationType")
		ok.String(string(v.ConfigurationType))
	}

	if v.MinPauseBetweenCheckpoints != nil {
		ok := object.Key("MinPauseBetweenCheckpoints")
		ok.Long(*v.MinPauseBetweenCheckpoints)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCheckpointConfigurationUpdate(v *types.CheckpointConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckpointingEnabledUpdate != nil {
		ok := object.Key("CheckpointingEnabledUpdate")
		ok.Boolean(*v.CheckpointingEnabledUpdate)
	}

	if v.CheckpointIntervalUpdate != nil {
		ok := object.Key("CheckpointIntervalUpdate")
		ok.Long(*v.CheckpointIntervalUpdate)
	}

	if len(v.ConfigurationTypeUpdate) > 0 {
		ok := object.Key("ConfigurationTypeUpdate")
		ok.String(string(v.ConfigurationTypeUpdate))
	}

	if v.MinPauseBetweenCheckpointsUpdate != nil {
		ok := object.Key("MinPauseBetweenCheckpointsUpdate")
		ok.Long(*v.MinPauseBetweenCheckpointsUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOption(v *types.CloudWatchLoggingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogStreamARN != nil {
		ok := object.Key("LogStreamARN")
		ok.String(*v.LogStreamARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v []types.CloudWatchLoggingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdate(v *types.CloudWatchLoggingOptionUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLoggingOptionId != nil {
		ok := object.Key("CloudWatchLoggingOptionId")
		ok.String(*v.CloudWatchLoggingOptionId)
	}

	if v.LogStreamARNUpdate != nil {
		ok := object.Key("LogStreamARNUpdate")
		ok.String(*v.LogStreamARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdates(v []types.CloudWatchLoggingOptionUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCodeContent(v *types.CodeContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3ContentLocation != nil {
		ok := object.Key("S3ContentLocation")
		if err := awsAwsjson11_serializeDocumentS3ContentLocation(v.S3ContentLocation, ok); err != nil {
			return err
		}
	}

	if v.TextContent != nil {
		ok := object.Key("TextContent")
		ok.String(*v.TextContent)
	}

	if v.ZipFileContent != nil {
		ok := object.Key("ZipFileContent")
		ok.Base64EncodeBytes(v.ZipFileContent)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCodeContentUpdate(v *types.CodeContentUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3ContentLocationUpdate != nil {
		ok := object.Key("S3ContentLocationUpdate")
		if err := awsAwsjson11_serializeDocumentS3ContentLocationUpdate(v.S3ContentLocationUpdate, ok); err != nil {
			return err
		}
	}

	if v.TextContentUpdate != nil {
		ok := object.Key("TextContentUpdate")
		ok.String(*v.TextContentUpdate)
	}

	if v.ZipFileContentUpdate != nil {
		ok := object.Key("ZipFileContentUpdate")
		ok.Base64EncodeBytes(v.ZipFileContentUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCSVMappingParameters(v *types.CSVMappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumnDelimiter != nil {
		ok := object.Key("RecordColumnDelimiter")
		ok.String(*v.RecordColumnDelimiter)
	}

	if v.RecordRowDelimiter != nil {
		ok := object.Key("RecordRowDelimiter")
		ok.String(*v.RecordRowDelimiter)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomArtifactConfiguration(v *types.CustomArtifactConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ArtifactType) > 0 {
		ok := object.Key("ArtifactType")
		ok.String(string(v.ArtifactType))
	}

	if v.MavenReference != nil {
		ok := object.Key("MavenReference")
		if err := awsAwsjson11_serializeDocumentMavenReference(v.MavenReference, ok); err != nil {
			return err
		}
	}

	if v.S3ContentLocation != nil {
		ok := object.Key("S3ContentLocation")
		if err := awsAwsjson11_serializeDocumentS3ContentLocation(v.S3ContentLocation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomArtifactsConfigurationList(v []types.CustomArtifactConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCustomArtifactConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeployAsApplicationConfiguration(v *types.DeployAsApplicationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3ContentLocation != nil {
		ok := object.Key("S3ContentLocation")
		if err := awsAwsjson11_serializeDocumentS3ContentBaseLocation(v.S3ContentLocation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeployAsApplicationConfigurationUpdate(v *types.DeployAsApplicationConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3ContentLocationUpdate != nil {
		ok := object.Key("S3ContentLocationUpdate")
		if err := awsAwsjson11_serializeDocumentS3ContentBaseLocationUpdate(v.S3ContentLocationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDestinationSchema(v *types.DestinationSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RecordFormatType) > 0 {
		ok := object.Key("RecordFormatType")
		ok.String(string(v.RecordFormatType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentProperties(v *types.EnvironmentProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PropertyGroups != nil {
		ok := object.Key("PropertyGroups")
		if err := awsAwsjson11_serializeDocumentPropertyGroups(v.PropertyGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentPropertyUpdates(v *types.EnvironmentPropertyUpdates, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PropertyGroups != nil {
		ok := object.Key("PropertyGroups")
		if err := awsAwsjson11_serializeDocumentPropertyGroups(v.PropertyGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFlinkApplicationConfiguration(v *types.FlinkApplicationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckpointConfiguration != nil {
		ok := object.Key("CheckpointConfiguration")
		if err := awsAwsjson11_serializeDocumentCheckpointConfiguration(v.CheckpointConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MonitoringConfiguration != nil {
		ok := object.Key("MonitoringConfiguration")
		if err := awsAwsjson11_serializeDocumentMonitoringConfiguration(v.MonitoringConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ParallelismConfiguration != nil {
		ok := object.Key("ParallelismConfiguration")
		if err := awsAwsjson11_serializeDocumentParallelismConfiguration(v.ParallelismConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFlinkApplicationConfigurationUpdate(v *types.FlinkApplicationConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckpointConfigurationUpdate != nil {
		ok := object.Key("CheckpointConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentCheckpointConfigurationUpdate(v.CheckpointConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.MonitoringConfigurationUpdate != nil {
		ok := object.Key("MonitoringConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentMonitoringConfigurationUpdate(v.MonitoringConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ParallelismConfigurationUpdate != nil {
		ok := object.Key("ParallelismConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentParallelismConfigurationUpdate(v.ParallelismConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFlinkRunConfiguration(v *types.FlinkRunConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowNonRestoredState != nil {
		ok := object.Key("AllowNonRestoredState")
		ok.Boolean(*v.AllowNonRestoredState)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueDataCatalogConfiguration(v *types.GlueDataCatalogConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseARN != nil {
		ok := object.Key("DatabaseARN")
		ok.String(*v.DatabaseARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGlueDataCatalogConfigurationUpdate(v *types.GlueDataCatalogConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseARNUpdate != nil {
		ok := object.Key("DatabaseARNUpdate")
		ok.String(*v.DatabaseARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInput(v *types.Input, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputParallelism != nil {
		ok := object.Key("InputParallelism")
		if err := awsAwsjson11_serializeDocumentInputParallelism(v.InputParallelism, ok); err != nil {
			return err
		}
	}

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InputSchema != nil {
		ok := object.Key("InputSchema")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.InputSchema, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseInput != nil {
		ok := object.Key("KinesisFirehoseInput")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseInput(v.KinesisFirehoseInput, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsInput != nil {
		ok := object.Key("KinesisStreamsInput")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsInput(v.KinesisStreamsInput, ok); err != nil {
			return err
		}
	}

	if v.NamePrefix != nil {
		ok := object.Key("NamePrefix")
		ok.String(*v.NamePrefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputLambdaProcessor(v *types.InputLambdaProcessor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputLambdaProcessorUpdate(v *types.InputLambdaProcessorUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputParallelism(v *types.InputParallelism, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Count != nil {
		ok := object.Key("Count")
		ok.Integer(*v.Count)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputParallelismUpdate(v *types.InputParallelismUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CountUpdate != nil {
		ok := object.Key("CountUpdate")
		ok.Integer(*v.CountUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputProcessingConfiguration(v *types.InputProcessingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputLambdaProcessor != nil {
		ok := object.Key("InputLambdaProcessor")
		if err := awsAwsjson11_serializeDocumentInputLambdaProcessor(v.InputLambdaProcessor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputProcessingConfigurationUpdate(v *types.InputProcessingConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputLambdaProcessorUpdate != nil {
		ok := object.Key("InputLambdaProcessorUpdate")
		if err := awsAwsjson11_serializeDocumentInputLambdaProcessorUpdate(v.InputLambdaProcessorUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputs(v []types.Input, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInputSchemaUpdate(v *types.InputSchemaUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumnUpdates != nil {
		ok := object.Key("RecordColumnUpdates")
		if err := awsAwsjson11_serializeDocumentRecordColumns(v.RecordColumnUpdates, ok); err != nil {
			return err
		}
	}

	if v.RecordEncodingUpdate != nil {
		ok := object.Key("RecordEncodingUpdate")
		ok.String(*v.RecordEncodingUpdate)
	}

	if v.RecordFormatUpdate != nil {
		ok := object.Key("RecordFormatUpdate")
		if err := awsAwsjson11_serializeDocumentRecordFormat(v.RecordFormatUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v *types.InputStartingPositionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputStartingPosition) > 0 {
		ok := object.Key("InputStartingPosition")
		ok.String(string(v.InputStartingPosition))
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputUpdate(v *types.InputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	if v.InputParallelismUpdate != nil {
		ok := object.Key("InputParallelismUpdate")
		if err := awsAwsjson11_serializeDocumentInputParallelismUpdate(v.InputParallelismUpdate, ok); err != nil {
			return err
		}
	}

	if v.InputProcessingConfigurationUpdate != nil {
		ok := object.Key("InputProcessingConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfigurationUpdate(v.InputProcessingConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.InputSchemaUpdate != nil {
		ok := object.Key("InputSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentInputSchemaUpdate(v.InputSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseInputUpdate != nil {
		ok := object.Key("KinesisFirehoseInputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseInputUpdate(v.KinesisFirehoseInputUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsInputUpdate != nil {
		ok := object.Key("KinesisStreamsInputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsInputUpdate(v.KinesisStreamsInputUpdate, ok); err != nil {
			return err
		}
	}

	if v.NamePrefixUpdate != nil {
		ok := object.Key("NamePrefixUpdate")
		ok.String(*v.NamePrefixUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputUpdates(v []types.InputUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInputUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJSONMappingParameters(v *types.JSONMappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordRowPath != nil {
		ok := object.Key("RecordRowPath")
		ok.String(*v.RecordRowPath)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseInput(v *types.KinesisFirehoseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseInputUpdate(v *types.KinesisFirehoseInputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseOutput(v *types.KinesisFirehoseOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseOutputUpdate(v *types.KinesisFirehoseOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsInput(v *types.KinesisStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsInputUpdate(v *types.KinesisStreamsInputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsOutput(v *types.KinesisStreamsOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsOutputUpdate(v *types.KinesisStreamsOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaOutput(v *types.LambdaOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaOutputUpdate(v *types.LambdaOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMappingParameters(v *types.MappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CSVMappingParameters != nil {
		ok := object.Key("CSVMappingParameters")
		if err := awsAwsjson11_serializeDocumentCSVMappingParameters(v.CSVMappingParameters, ok); err != nil {
			return err
		}
	}

	if v.JSONMappingParameters != nil {
		ok := object.Key("JSONMappingParameters")
		if err := awsAwsjson11_serializeDocumentJSONMappingParameters(v.JSONMappingParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentMavenReference(v *types.MavenReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArtifactId != nil {
		ok := object.Key("ArtifactId")
		ok.String(*v.ArtifactId)
	}

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMonitoringConfiguration(v *types.MonitoringConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfigurationType) > 0 {
		ok := object.Key("ConfigurationType")
		ok.String(string(v.ConfigurationType))
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("LogLevel")
		ok.String(string(v.LogLevel))
	}

	if len(v.MetricsLevel) > 0 {
		ok := object.Key("MetricsLevel")
		ok.String(string(v.MetricsLevel))
	}

	return nil
}

func awsAwsjson11_serializeDocumentMonitoringConfigurationUpdate(v *types.MonitoringConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfigurationTypeUpdate) > 0 {
		ok := object.Key("ConfigurationTypeUpdate")
		ok.String(string(v.ConfigurationTypeUpdate))
	}

	if len(v.LogLevelUpdate) > 0 {
		ok := object.Key("LogLevelUpdate")
		ok.String(string(v.LogLevelUpdate))
	}

	if len(v.MetricsLevelUpdate) > 0 {
		ok := object.Key("MetricsLevelUpdate")
		ok.String(string(v.MetricsLevelUpdate))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutput(v *types.Output, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationSchema != nil {
		ok := object.Key("DestinationSchema")
		if err := awsAwsjson11_serializeDocumentDestinationSchema(v.DestinationSchema, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseOutput != nil {
		ok := object.Key("KinesisFirehoseOutput")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseOutput(v.KinesisFirehoseOutput, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsOutput != nil {
		ok := object.Key("KinesisStreamsOutput")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsOutput(v.KinesisStreamsOutput, ok); err != nil {
			return err
		}
	}

	if v.LambdaOutput != nil {
		ok := object.Key("LambdaOutput")
		if err := awsAwsjson11_serializeDocumentLambdaOutput(v.LambdaOutput, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputs(v []types.Output, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOutput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOutputUpdate(v *types.OutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationSchemaUpdate != nil {
		ok := object.Key("DestinationSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentDestinationSchema(v.DestinationSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseOutputUpdate != nil {
		ok := object.Key("KinesisFirehoseOutputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseOutputUpdate(v.KinesisFirehoseOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsOutputUpdate != nil {
		ok := object.Key("KinesisStreamsOutputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsOutputUpdate(v.KinesisStreamsOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.LambdaOutputUpdate != nil {
		ok := object.Key("LambdaOutputUpdate")
		if err := awsAwsjson11_serializeDocumentLambdaOutputUpdate(v.LambdaOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.NameUpdate != nil {
		ok := object.Key("NameUpdate")
		ok.String(*v.NameUpdate)
	}

	if v.OutputId != nil {
		ok := object.Key("OutputId")
		ok.String(*v.OutputId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputUpdates(v []types.OutputUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOutputUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentParallelismConfiguration(v *types.ParallelismConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingEnabled != nil {
		ok := object.Key("AutoScalingEnabled")
		ok.Boolean(*v.AutoScalingEnabled)
	}

	if len(v.ConfigurationType) > 0 {
		ok := object.Key("ConfigurationType")
		ok.String(string(v.ConfigurationType))
	}

	if v.Parallelism != nil {
		ok := object.Key("Parallelism")
		ok.Integer(*v.Parallelism)
	}

	if v.ParallelismPerKPU != nil {
		ok := object.Key("ParallelismPerKPU")
		ok.Integer(*v.ParallelismPerKPU)
	}

	return nil
}

func awsAwsjson11_serializeDocumentParallelismConfigurationUpdate(v *types.ParallelismConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingEnabledUpdate != nil {
		ok := object.Key("AutoScalingEnabledUpdate")
		ok.Boolean(*v.AutoScalingEnabledUpdate)
	}

	if len(v.ConfigurationTypeUpdate) > 0 {
		ok := object.Key("ConfigurationTypeUpdate")
		ok.String(string(v.ConfigurationTypeUpdate))
	}

	if v.ParallelismPerKPUUpdate != nil {
		ok := object.Key("ParallelismPerKPUUpdate")
		ok.Integer(*v.ParallelismPerKPUUpdate)
	}

	if v.ParallelismUpdate != nil {
		ok := object.Key("ParallelismUpdate")
		ok.Integer(*v.ParallelismUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPropertyGroup(v *types.PropertyGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PropertyGroupId != nil {
		ok := object.Key("PropertyGroupId")
		ok.String(*v.PropertyGroupId)
	}

	if v.PropertyMap != nil {
		ok := object.Key("PropertyMap")
		if err := awsAwsjson11_serializeDocumentPropertyMap(v.PropertyMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPropertyGroups(v []types.PropertyGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPropertyGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPropertyMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecordColumn(v *types.RecordColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mapping != nil {
		ok := object.Key("Mapping")
		ok.String(*v.Mapping)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SqlType != nil {
		ok := object.Key("SqlType")
		ok.String(*v.SqlType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecordColumns(v []types.RecordColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRecordColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecordFormat(v *types.RecordFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MappingParameters != nil {
		ok := object.Key("MappingParameters")
		if err := awsAwsjson11_serializeDocumentMappingParameters(v.MappingParameters, ok); err != nil {
			return err
		}
	}

	if len(v.RecordFormatType) > 0 {
		ok := object.Key("RecordFormatType")
		ok.String(string(v.RecordFormatType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSource(v *types.ReferenceDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceSchema != nil {
		ok := object.Key("ReferenceSchema")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.ReferenceSchema, ok); err != nil {
			return err
		}
	}

	if v.S3ReferenceDataSource != nil {
		ok := object.Key("S3ReferenceDataSource")
		if err := awsAwsjson11_serializeDocumentS3ReferenceDataSource(v.S3ReferenceDataSource, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSources(v []types.ReferenceDataSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentReferenceDataSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSourceUpdate(v *types.ReferenceDataSourceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceId != nil {
		ok := object.Key("ReferenceId")
		ok.String(*v.ReferenceId)
	}

	if v.ReferenceSchemaUpdate != nil {
		ok := object.Key("ReferenceSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.ReferenceSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.S3ReferenceDataSourceUpdate != nil {
		ok := object.Key("S3ReferenceDataSourceUpdate")
		if err := awsAwsjson11_serializeDocumentS3ReferenceDataSourceUpdate(v.S3ReferenceDataSourceUpdate, ok); err != nil {
			return err
		}
	}

	if v.TableNameUpdate != nil {
		ok := object.Key("TableNameUpdate")
		ok.String(*v.TableNameUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSourceUpdates(v []types.ReferenceDataSourceUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentReferenceDataSourceUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRunConfiguration(v *types.RunConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationRestoreConfiguration != nil {
		ok := object.Key("ApplicationRestoreConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationRestoreConfiguration(v.ApplicationRestoreConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FlinkRunConfiguration != nil {
		ok := object.Key("FlinkRunConfiguration")
		if err := awsAwsjson11_serializeDocumentFlinkRunConfiguration(v.FlinkRunConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SqlRunConfigurations != nil {
		ok := object.Key("SqlRunConfigurations")
		if err := awsAwsjson11_serializeDocumentSqlRunConfigurations(v.SqlRunConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRunConfigurationUpdate(v *types.RunConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationRestoreConfiguration != nil {
		ok := object.Key("ApplicationRestoreConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationRestoreConfiguration(v.ApplicationRestoreConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FlinkRunConfiguration != nil {
		ok := object.Key("FlinkRunConfiguration")
		if err := awsAwsjson11_serializeDocumentFlinkRunConfiguration(v.FlinkRunConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Configuration(v *types.S3Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.FileKey != nil {
		ok := object.Key("FileKey")
		ok.String(*v.FileKey)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ContentBaseLocation(v *types.S3ContentBaseLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BasePath != nil {
		ok := object.Key("BasePath")
		ok.String(*v.BasePath)
	}

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ContentBaseLocationUpdate(v *types.S3ContentBaseLocationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BasePathUpdate != nil {
		ok := object.Key("BasePathUpdate")
		ok.String(*v.BasePathUpdate)
	}

	if v.BucketARNUpdate != nil {
		ok := object.Key("BucketARNUpdate")
		ok.String(*v.BucketARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ContentLocation(v *types.S3ContentLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.FileKey != nil {
		ok := object.Key("FileKey")
		ok.String(*v.FileKey)
	}

	if v.ObjectVersion != nil {
		ok := object.Key("ObjectVersion")
		ok.String(*v.ObjectVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ContentLocationUpdate(v *types.S3ContentLocationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARNUpdate != nil {
		ok := object.Key("BucketARNUpdate")
		ok.String(*v.BucketARNUpdate)
	}

	if v.FileKeyUpdate != nil {
		ok := object.Key("FileKeyUpdate")
		ok.String(*v.FileKeyUpdate)
	}

	if v.ObjectVersionUpdate != nil {
		ok := object.Key("ObjectVersionUpdate")
		ok.String(*v.ObjectVersionUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ReferenceDataSource(v *types.S3ReferenceDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.FileKey != nil {
		ok := object.Key("FileKey")
		ok.String(*v.FileKey)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ReferenceDataSourceUpdate(v *types.S3ReferenceDataSourceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARNUpdate != nil {
		ok := object.Key("BucketARNUpdate")
		ok.String(*v.BucketARNUpdate)
	}

	if v.FileKeyUpdate != nil {
		ok := object.Key("FileKeyUpdate")
		ok.String(*v.FileKeyUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSourceSchema(v *types.SourceSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumns != nil {
		ok := object.Key("RecordColumns")
		if err := awsAwsjson11_serializeDocumentRecordColumns(v.RecordColumns, ok); err != nil {
			return err
		}
	}

	if v.RecordEncoding != nil {
		ok := object.Key("RecordEncoding")
		ok.String(*v.RecordEncoding)
	}

	if v.RecordFormat != nil {
		ok := object.Key("RecordFormat")
		if err := awsAwsjson11_serializeDocumentRecordFormat(v.RecordFormat, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlApplicationConfiguration(v *types.SqlApplicationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("Outputs")
		if err := awsAwsjson11_serializeDocumentOutputs(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.ReferenceDataSources != nil {
		ok := object.Key("ReferenceDataSources")
		if err := awsAwsjson11_serializeDocumentReferenceDataSources(v.ReferenceDataSources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlApplicationConfigurationUpdate(v *types.SqlApplicationConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputUpdates != nil {
		ok := object.Key("InputUpdates")
		if err := awsAwsjson11_serializeDocumentInputUpdates(v.InputUpdates, ok); err != nil {
			return err
		}
	}

	if v.OutputUpdates != nil {
		ok := object.Key("OutputUpdates")
		if err := awsAwsjson11_serializeDocumentOutputUpdates(v.OutputUpdates, ok); err != nil {
			return err
		}
	}

	if v.ReferenceDataSourceUpdates != nil {
		ok := object.Key("ReferenceDataSourceUpdates")
		if err := awsAwsjson11_serializeDocumentReferenceDataSourceUpdates(v.ReferenceDataSourceUpdates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlRunConfiguration(v *types.SqlRunConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	if v.InputStartingPositionConfiguration != nil {
		ok := object.Key("InputStartingPositionConfiguration")
		if err := awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v.InputStartingPositionConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqlRunConfigurations(v []types.SqlRunConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSqlRunConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVpcConfiguration(v *types.VpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentVpcConfigurations(v []types.VpcConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentVpcConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVpcConfigurationUpdate(v *types.VpcConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIdUpdates != nil {
		ok := object.Key("SecurityGroupIdUpdates")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIds(v.SecurityGroupIdUpdates, ok); err != nil {
			return err
		}
	}

	if v.SubnetIdUpdates != nil {
		ok := object.Key("SubnetIdUpdates")
		if err := awsAwsjson11_serializeDocumentSubnetIds(v.SubnetIdUpdates, ok); err != nil {
			return err
		}
	}

	if v.VpcConfigurationId != nil {
		ok := object.Key("VpcConfigurationId")
		ok.String(*v.VpcConfigurationId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVpcConfigurationUpdates(v []types.VpcConfigurationUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentVpcConfigurationUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentZeppelinApplicationConfiguration(v *types.ZeppelinApplicationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogConfiguration != nil {
		ok := object.Key("CatalogConfiguration")
		if err := awsAwsjson11_serializeDocumentCatalogConfiguration(v.CatalogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomArtifactsConfiguration != nil {
		ok := object.Key("CustomArtifactsConfiguration")
		if err := awsAwsjson11_serializeDocumentCustomArtifactsConfigurationList(v.CustomArtifactsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DeployAsApplicationConfiguration != nil {
		ok := object.Key("DeployAsApplicationConfiguration")
		if err := awsAwsjson11_serializeDocumentDeployAsApplicationConfiguration(v.DeployAsApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MonitoringConfiguration != nil {
		ok := object.Key("MonitoringConfiguration")
		if err := awsAwsjson11_serializeDocumentZeppelinMonitoringConfiguration(v.MonitoringConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentZeppelinApplicationConfigurationUpdate(v *types.ZeppelinApplicationConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogConfigurationUpdate != nil {
		ok := object.Key("CatalogConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentCatalogConfigurationUpdate(v.CatalogConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.CustomArtifactsConfigurationUpdate != nil {
		ok := object.Key("CustomArtifactsConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentCustomArtifactsConfigurationList(v.CustomArtifactsConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.DeployAsApplicationConfigurationUpdate != nil {
		ok := object.Key("DeployAsApplicationConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentDeployAsApplicationConfigurationUpdate(v.DeployAsApplicationConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.MonitoringConfigurationUpdate != nil {
		ok := object.Key("MonitoringConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentZeppelinMonitoringConfigurationUpdate(v.MonitoringConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentZeppelinMonitoringConfiguration(v *types.ZeppelinMonitoringConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogLevel) > 0 {
		ok := object.Key("LogLevel")
		ok.String(string(v.LogLevel))
	}

	return nil
}

func awsAwsjson11_serializeDocumentZeppelinMonitoringConfigurationUpdate(v *types.ZeppelinMonitoringConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogLevelUpdate) > 0 {
		ok := object.Key("LogLevelUpdate")
		ok.String(string(v.LogLevelUpdate))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationCloudWatchLoggingOptionInput(v *AddApplicationCloudWatchLoggingOptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOption != nil {
		ok := object.Key("CloudWatchLoggingOption")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOption(v.CloudWatchLoggingOption, ok); err != nil {
			return err
		}
	}

	if v.ConditionalToken != nil {
		ok := object.Key("ConditionalToken")
		ok.String(*v.ConditionalToken)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationInputInput(v *AddApplicationInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.Input != nil {
		ok := object.Key("Input")
		if err := awsAwsjson11_serializeDocumentInput(v.Input, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationInputProcessingConfigurationInput(v *AddApplicationInputProcessingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationOutputInput(v *AddApplicationOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.Output != nil {
		ok := object.Key("Output")
		if err := awsAwsjson11_serializeDocumentOutput(v.Output, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationReferenceDataSourceInput(v *AddApplicationReferenceDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.ReferenceDataSource != nil {
		ok := object.Key("ReferenceDataSource")
		if err := awsAwsjson11_serializeDocumentReferenceDataSource(v.ReferenceDataSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationVpcConfigurationInput(v *AddApplicationVpcConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.ConditionalToken != nil {
		ok := object.Key("ConditionalToken")
		ok.String(*v.ConditionalToken)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsAwsjson11_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateApplicationInput(v *CreateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationConfiguration != nil {
		ok := object.Key("ApplicationConfiguration")
		if err := awsAwsjson11_serializeDocumentApplicationConfiguration(v.ApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ApplicationDescription != nil {
		ok := object.Key("ApplicationDescription")
		ok.String(*v.ApplicationDescription)
	}

	if len(v.ApplicationMode) > 0 {
		ok := object.Key("ApplicationMode")
		ok.String(string(v.ApplicationMode))
	}

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if len(v.RuntimeEnvironment) > 0 {
		ok := object.Key("RuntimeEnvironment")
		ok.String(string(v.RuntimeEnvironment))
	}

	if v.ServiceExecutionRole != nil {
		ok := object.Key("ServiceExecutionRole")
		ok.String(*v.ServiceExecutionRole)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateApplicationPresignedUrlInput(v *CreateApplicationPresignedUrlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.SessionExpirationDurationInSeconds != nil {
		ok := object.Key("SessionExpirationDurationInSeconds")
		ok.Long(*v.SessionExpirationDurationInSeconds)
	}

	if len(v.UrlType) > 0 {
		ok := object.Key("UrlType")
		ok.String(string(v.UrlType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateApplicationSnapshotInput(v *CreateApplicationSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.SnapshotName != nil {
		ok := object.Key("SnapshotName")
		ok.String(*v.SnapshotName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationCloudWatchLoggingOptionInput(v *DeleteApplicationCloudWatchLoggingOptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOptionId != nil {
		ok := object.Key("CloudWatchLoggingOptionId")
		ok.String(*v.CloudWatchLoggingOptionId)
	}

	if v.ConditionalToken != nil {
		ok := object.Key("ConditionalToken")
		ok.String(*v.ConditionalToken)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationInput(v *DeleteApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CreateTimestamp != nil {
		ok := object.Key("CreateTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreateTimestamp))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationInputProcessingConfigurationInput(v *DeleteApplicationInputProcessingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationOutputInput(v *DeleteApplicationOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.OutputId != nil {
		ok := object.Key("OutputId")
		ok.String(*v.OutputId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationReferenceDataSourceInput(v *DeleteApplicationReferenceDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.ReferenceId != nil {
		ok := object.Key("ReferenceId")
		ok.String(*v.ReferenceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationSnapshotInput(v *DeleteApplicationSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.SnapshotCreationTimestamp != nil {
		ok := object.Key("SnapshotCreationTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.SnapshotCreationTimestamp))
	}

	if v.SnapshotName != nil {
		ok := object.Key("SnapshotName")
		ok.String(*v.SnapshotName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationVpcConfigurationInput(v *DeleteApplicationVpcConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.ConditionalToken != nil {
		ok := object.Key("ConditionalToken")
		ok.String(*v.ConditionalToken)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.VpcConfigurationId != nil {
		ok := object.Key("VpcConfigurationId")
		ok.String(*v.VpcConfigurationId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationInput(v *DescribeApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.IncludeAdditionalDetails != nil {
		ok := object.Key("IncludeAdditionalDetails")
		ok.Boolean(*v.IncludeAdditionalDetails)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationOperationInput(v *DescribeApplicationOperationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.OperationId != nil {
		ok := object.Key("OperationId")
		ok.String(*v.OperationId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationSnapshotInput(v *DescribeApplicationSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.SnapshotName != nil {
		ok := object.Key("SnapshotName")
		ok.String(*v.SnapshotName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationVersionInput(v *DescribeApplicationVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.ApplicationVersionId != nil {
		ok := object.Key("ApplicationVersionId")
		ok.Long(*v.ApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDiscoverInputSchemaInput(v *DiscoverInputSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InputStartingPositionConfiguration != nil {
		ok := object.Key("InputStartingPositionConfiguration")
		if err := awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v.InputStartingPositionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3Configuration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.ServiceExecutionRole != nil {
		ok := object.Key("ServiceExecutionRole")
		ok.String(*v.ServiceExecutionRole)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationOperationsInput(v *ListApplicationOperationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Operation != nil {
		ok := object.Key("Operation")
		ok.String(*v.Operation)
	}

	if len(v.OperationStatus) > 0 {
		ok := object.Key("OperationStatus")
		ok.String(string(v.OperationStatus))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationsInput(v *ListApplicationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationSnapshotsInput(v *ListApplicationSnapshotsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationVersionsInput(v *ListApplicationVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRollbackApplicationInput(v *RollbackApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartApplicationInput(v *StartApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.RunConfiguration != nil {
		ok := object.Key("RunConfiguration")
		if err := awsAwsjson11_serializeDocumentRunConfiguration(v.RunConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopApplicationInput(v *StopApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.Force != nil {
		ok := object.Key("Force")
		ok.Boolean(*v.Force)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateApplicationInput(v *UpdateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationConfigurationUpdate != nil {
		ok := object.Key("ApplicationConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationConfigurationUpdate(v.ApplicationConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOptionUpdates != nil {
		ok := object.Key("CloudWatchLoggingOptionUpdates")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdates(v.CloudWatchLoggingOptionUpdates, ok); err != nil {
			return err
		}
	}

	if v.ConditionalToken != nil {
		ok := object.Key("ConditionalToken")
		ok.String(*v.ConditionalToken)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.RunConfigurationUpdate != nil {
		ok := object.Key("RunConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentRunConfigurationUpdate(v.RunConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if len(v.RuntimeEnvironmentUpdate) > 0 {
		ok := object.Key("RuntimeEnvironmentUpdate")
		ok.String(string(v.RuntimeEnvironmentUpdate))
	}

	if v.ServiceExecutionRoleUpdate != nil {
		ok := object.Key("ServiceExecutionRoleUpdate")
		ok.String(*v.ServiceExecutionRoleUpdate)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateApplicationMaintenanceConfigurationInput(v *UpdateApplicationMaintenanceConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationMaintenanceConfigurationUpdate != nil {
		ok := object.Key("ApplicationMaintenanceConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationMaintenanceConfigurationUpdate(v.ApplicationMaintenanceConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	return nil
}
