// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservicedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservicedata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns member information for the specified group.
//
// This operation supports pagination with the use of the NextToken request and
// response parameters. If more results are available, the
// ListGroupMembers.NextToken member contains a token that you pass in the next
// call to ListGroupMembers . This retrieves the next set of items.
//
// You can also specify a maximum number of return results with the MaxResults
// parameter.
func (c *Client) ListGroupMembers(ctx context.Context, params *ListGroupMembersInput, optFns ...func(*Options)) (*ListGroupMembersOutput, error) {
	if params == nil {
		params = &ListGroupMembersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGroupMembers", params, optFns, c.addOperationListGroupMembersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGroupMembersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGroupMembersInput struct {

	//  The identifier (ID) of the directory that's associated with the group.
	//
	// This member is required.
	DirectoryId *string

	//  The name of the group.
	//
	// This member is required.
	SAMAccountName *string

	//  The maximum number of results to be returned per request.
	MaxResults *int32

	//  The domain name that's associated with the group member. This parameter
	// defaults to the Managed Microsoft AD domain.
	//
	// This parameter is optional and case insensitive.
	MemberRealm *string

	// An encoded paging token for paginated calls that can be passed back to retrieve
	// the next page.
	NextToken *string

	//  The domain name that's associated with the group.
	//
	// This parameter is optional, so you can return members from a group outside of
	// your Managed Microsoft AD domain. When no value is defined, only members of your
	// Managed Microsoft AD groups are returned.
	//
	// This value is case insensitive.
	Realm *string

	noSmithyDocumentSerde
}

type ListGroupMembersOutput struct {

	// Identifier (ID) of the directory associated with the group.
	DirectoryId *string

	//  The domain name that's associated with the member.
	MemberRealm *string

	//  The member information that the request returns.
	Members []types.Member

	//  An encoded paging token for paginated calls that can be passed back to
	// retrieve the next page.
	NextToken *string

	//  The domain name that's associated with the group.
	Realm *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGroupMembersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListGroupMembers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListGroupMembers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGroupMembers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListGroupMembersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGroupMembers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListGroupMembersPaginatorOptions is the paginator options for ListGroupMembers
type ListGroupMembersPaginatorOptions struct {
	//  The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListGroupMembersPaginator is a paginator for ListGroupMembers
type ListGroupMembersPaginator struct {
	options   ListGroupMembersPaginatorOptions
	client    ListGroupMembersAPIClient
	params    *ListGroupMembersInput
	nextToken *string
	firstPage bool
}

// NewListGroupMembersPaginator returns a new ListGroupMembersPaginator
func NewListGroupMembersPaginator(client ListGroupMembersAPIClient, params *ListGroupMembersInput, optFns ...func(*ListGroupMembersPaginatorOptions)) *ListGroupMembersPaginator {
	if params == nil {
		params = &ListGroupMembersInput{}
	}

	options := ListGroupMembersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListGroupMembersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListGroupMembersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListGroupMembers page.
func (p *ListGroupMembersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListGroupMembersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListGroupMembers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListGroupMembersAPIClient is a client that implements the ListGroupMembers
// operation.
type ListGroupMembersAPIClient interface {
	ListGroupMembers(context.Context, *ListGroupMembersInput, ...func(*Options)) (*ListGroupMembersOutput, error)
}

var _ ListGroupMembersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListGroupMembers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGroupMembers",
	}
}
