// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists existing environment actions.
func (c *Client) ListEnvironmentActions(ctx context.Context, params *ListEnvironmentActionsInput, optFns ...func(*Options)) (*ListEnvironmentActionsOutput, error) {
	if params == nil {
		params = &ListEnvironmentActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEnvironmentActions", params, optFns, c.addOperationListEnvironmentActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEnvironmentActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEnvironmentActionsInput struct {

	// The ID of the Amazon DataZone domain in which the environment actions are
	// listed.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the envrironment whose environment actions are listed.
	//
	// This member is required.
	EnvironmentIdentifier *string

	// The maximum number of environment actions to return in a single call to
	// ListEnvironmentActions . When the number of environment actions to be listed is
	// greater than the value of MaxResults , the response contains a NextToken value
	// that you can use in a subsequent call to ListEnvironmentActions to list the
	// next set of environment actions.
	MaxResults *int32

	// When the number of environment actions is greater than the default value for
	// the MaxResults parameter, or if you explicitly specify a value for MaxResults
	// that is less than the number of environment actions, the response includes a
	// pagination token named NextToken . You can specify this NextToken value in a
	// subsequent call to ListEnvironmentActions to list the next set of environment
	// actions.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEnvironmentActionsOutput struct {

	// The results of ListEnvironmentActions .
	Items []types.EnvironmentActionSummary

	// When the number of environment actions is greater than the default value for
	// the MaxResults parameter, or if you explicitly specify a value for MaxResults
	// that is less than the number of environment actions, the response includes a
	// pagination token named NextToken . You can specify this NextToken value in a
	// subsequent call to ListEnvironmentActions to list the next set of environment
	// actions.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEnvironmentActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEnvironmentActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEnvironmentActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEnvironmentActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEnvironmentActionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEnvironmentActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEnvironmentActionsPaginatorOptions is the paginator options for
// ListEnvironmentActions
type ListEnvironmentActionsPaginatorOptions struct {
	// The maximum number of environment actions to return in a single call to
	// ListEnvironmentActions . When the number of environment actions to be listed is
	// greater than the value of MaxResults , the response contains a NextToken value
	// that you can use in a subsequent call to ListEnvironmentActions to list the
	// next set of environment actions.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEnvironmentActionsPaginator is a paginator for ListEnvironmentActions
type ListEnvironmentActionsPaginator struct {
	options   ListEnvironmentActionsPaginatorOptions
	client    ListEnvironmentActionsAPIClient
	params    *ListEnvironmentActionsInput
	nextToken *string
	firstPage bool
}

// NewListEnvironmentActionsPaginator returns a new ListEnvironmentActionsPaginator
func NewListEnvironmentActionsPaginator(client ListEnvironmentActionsAPIClient, params *ListEnvironmentActionsInput, optFns ...func(*ListEnvironmentActionsPaginatorOptions)) *ListEnvironmentActionsPaginator {
	if params == nil {
		params = &ListEnvironmentActionsInput{}
	}

	options := ListEnvironmentActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEnvironmentActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEnvironmentActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEnvironmentActions page.
func (p *ListEnvironmentActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEnvironmentActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEnvironmentActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEnvironmentActionsAPIClient is a client that implements the
// ListEnvironmentActions operation.
type ListEnvironmentActionsAPIClient interface {
	ListEnvironmentActions(context.Context, *ListEnvironmentActionsInput, ...func(*Options)) (*ListEnvironmentActionsOutput, error)
}

var _ ListEnvironmentActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEnvironmentActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEnvironmentActions",
	}
}
