// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about an Automated Reasoning policy build
// workflow, including its status, configuration, and metadata.
func (c *Client) GetAutomatedReasoningPolicyBuildWorkflow(ctx context.Context, params *GetAutomatedReasoningPolicyBuildWorkflowInput, optFns ...func(*Options)) (*GetAutomatedReasoningPolicyBuildWorkflowOutput, error) {
	if params == nil {
		params = &GetAutomatedReasoningPolicyBuildWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomatedReasoningPolicyBuildWorkflow", params, optFns, c.addOperationGetAutomatedReasoningPolicyBuildWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomatedReasoningPolicyBuildWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomatedReasoningPolicyBuildWorkflowInput struct {

	// The unique identifier of the build workflow to retrieve.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build
	// workflow you want to retrieve.
	//
	// This member is required.
	PolicyArn *string

	noSmithyDocumentSerde
}

type GetAutomatedReasoningPolicyBuildWorkflowOutput struct {

	// The unique identifier of the build workflow.
	//
	// This member is required.
	BuildWorkflowId *string

	// The type of build workflow being executed (e.g., DOCUMENT_INGESTION,
	// POLICY_REPAIR).
	//
	// This member is required.
	BuildWorkflowType types.AutomatedReasoningPolicyBuildWorkflowType

	// The timestamp when the build workflow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy.
	//
	// This member is required.
	PolicyArn *string

	// The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED,
	// CANCELLED).
	//
	// This member is required.
	Status types.AutomatedReasoningPolicyBuildWorkflowStatus

	// The timestamp when the build workflow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The content type of the source document (e.g., text/plain, application/pdf).
	DocumentContentType types.AutomatedReasoningPolicyBuildDocumentContentType

	// A detailed description of the document's content and how it should be used in
	// the policy generation process.
	DocumentDescription *string

	// The name of the source document used in the build workflow.
	DocumentName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomatedReasoningPolicyBuildWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAutomatedReasoningPolicyBuildWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAutomatedReasoningPolicyBuildWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomatedReasoningPolicyBuildWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAutomatedReasoningPolicyBuildWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyBuildWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyBuildWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomatedReasoningPolicyBuildWorkflow",
	}
}
