// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpApprovePlanExecutionStep struct {
}

func (*validateOpApprovePlanExecutionStep) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpApprovePlanExecutionStep) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ApprovePlanExecutionStepInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpApprovePlanExecutionStepInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelPlanExecution struct {
}

func (*validateOpCancelPlanExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelPlanExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelPlanExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePlan struct {
}

func (*validateOpCreatePlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePlan struct {
}

func (*validateOpDeletePlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPlanEvaluationStatus struct {
}

func (*validateOpGetPlanEvaluationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPlanEvaluationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPlanEvaluationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPlanEvaluationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPlanExecution struct {
}

func (*validateOpGetPlanExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPlanExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPlanExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPlan struct {
}

func (*validateOpGetPlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPlanInRegion struct {
}

func (*validateOpGetPlanInRegion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPlanInRegion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPlanInRegionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPlanInRegionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPlanExecutionEvents struct {
}

func (*validateOpListPlanExecutionEvents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPlanExecutionEvents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPlanExecutionEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPlanExecutionEventsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPlanExecutions struct {
}

func (*validateOpListPlanExecutions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPlanExecutions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPlanExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPlanExecutionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListRoute53HealthChecks struct {
}

func (*validateOpListRoute53HealthChecks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListRoute53HealthChecks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListRoute53HealthChecksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListRoute53HealthChecksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartPlanExecution struct {
}

func (*validateOpStartPlanExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartPlanExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartPlanExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePlanExecution struct {
}

func (*validateOpUpdatePlanExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePlanExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePlanExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePlanExecutionStep struct {
}

func (*validateOpUpdatePlanExecutionStep) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePlanExecutionStep) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePlanExecutionStepInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePlanExecutionStepInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePlan struct {
}

func (*validateOpUpdatePlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpApprovePlanExecutionStepValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpApprovePlanExecutionStep{}, middleware.After)
}

func addOpCancelPlanExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelPlanExecution{}, middleware.After)
}

func addOpCreatePlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePlan{}, middleware.After)
}

func addOpDeletePlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePlan{}, middleware.After)
}

func addOpGetPlanEvaluationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPlanEvaluationStatus{}, middleware.After)
}

func addOpGetPlanExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPlanExecution{}, middleware.After)
}

func addOpGetPlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPlan{}, middleware.After)
}

func addOpGetPlanInRegionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPlanInRegion{}, middleware.After)
}

func addOpListPlanExecutionEventsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPlanExecutionEvents{}, middleware.After)
}

func addOpListPlanExecutionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPlanExecutions{}, middleware.After)
}

func addOpListRoute53HealthChecksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListRoute53HealthChecks{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartPlanExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartPlanExecution{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdatePlanExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePlanExecution{}, middleware.After)
}

func addOpUpdatePlanExecutionStepValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePlanExecutionStep{}, middleware.After)
}

func addOpUpdatePlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePlan{}, middleware.After)
}

func validateArcRoutingControlConfiguration(v *types.ArcRoutingControlConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArcRoutingControlConfiguration"}
	if v.RegionAndRoutingControls == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RegionAndRoutingControls"))
	} else if v.RegionAndRoutingControls != nil {
		if err := validateRegionAndRoutingControls(v.RegionAndRoutingControls); err != nil {
			invalidParams.AddNested("RegionAndRoutingControls", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateArcRoutingControlState(v *types.ArcRoutingControlState) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArcRoutingControlState"}
	if v.RoutingControlArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoutingControlArn"))
	}
	if len(v.State) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("State"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateArcRoutingControlStates(v []types.ArcRoutingControlState) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArcRoutingControlStates"}
	for i := range v {
		if err := validateArcRoutingControlState(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssociatedAlarm(v *types.AssociatedAlarm) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociatedAlarm"}
	if v.ResourceIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceIdentifier"))
	}
	if len(v.AlarmType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssociatedAlarmMap(v map[string]types.AssociatedAlarm) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociatedAlarmMap"}
	for key := range v {
		value := v[key]
		if err := validateAssociatedAlarm(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomActionLambdaConfiguration(v *types.CustomActionLambdaConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomActionLambdaConfiguration"}
	if v.Lambdas == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Lambdas"))
	}
	if v.RetryIntervalMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetryIntervalMinutes"))
	}
	if len(v.RegionToRun) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RegionToRun"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2AsgCapacityIncreaseConfiguration(v *types.Ec2AsgCapacityIncreaseConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2AsgCapacityIncreaseConfiguration"}
	if v.Asgs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Asgs"))
	}
	if v.Ungraceful != nil {
		if err := validateEc2Ungraceful(v.Ungraceful); err != nil {
			invalidParams.AddNested("Ungraceful", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2Ungraceful(v *types.Ec2Ungraceful) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2Ungraceful"}
	if v.MinimumSuccessPercentage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinimumSuccessPercentage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcsCapacityIncreaseConfiguration(v *types.EcsCapacityIncreaseConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcsCapacityIncreaseConfiguration"}
	if v.Services == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Services"))
	}
	if v.Ungraceful != nil {
		if err := validateEcsUngraceful(v.Ungraceful); err != nil {
			invalidParams.AddNested("Ungraceful", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcsUngraceful(v *types.EcsUngraceful) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcsUngraceful"}
	if v.MinimumSuccessPercentage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinimumSuccessPercentage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksCluster(v *types.EksCluster) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksCluster"}
	if v.ClusterArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksClusters(v []types.EksCluster) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksClusters"}
	for i := range v {
		if err := validateEksCluster(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksResourceScalingConfiguration(v *types.EksResourceScalingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksResourceScalingConfiguration"}
	if v.KubernetesResourceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KubernetesResourceType"))
	} else if v.KubernetesResourceType != nil {
		if err := validateKubernetesResourceType(v.KubernetesResourceType); err != nil {
			invalidParams.AddNested("KubernetesResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScalingResources != nil {
		if err := validateKubernetesScalingApps(v.ScalingResources); err != nil {
			invalidParams.AddNested("ScalingResources", err.(smithy.InvalidParamsError))
		}
	}
	if v.EksClusters != nil {
		if err := validateEksClusters(v.EksClusters); err != nil {
			invalidParams.AddNested("EksClusters", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ungraceful != nil {
		if err := validateEksResourceScalingUngraceful(v.Ungraceful); err != nil {
			invalidParams.AddNested("Ungraceful", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksResourceScalingUngraceful(v *types.EksResourceScalingUngraceful) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksResourceScalingUngraceful"}
	if v.MinimumSuccessPercentage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinimumSuccessPercentage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExecutionApprovalConfiguration(v *types.ExecutionApprovalConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecutionApprovalConfiguration"}
	if v.ApprovalRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApprovalRole"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExecutionBlockConfiguration(v types.ExecutionBlockConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecutionBlockConfiguration"}
	switch uv := v.(type) {
	case *types.ExecutionBlockConfigurationMemberArcRoutingControlConfig:
		if err := validateArcRoutingControlConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[arcRoutingControlConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberCustomActionLambdaConfig:
		if err := validateCustomActionLambdaConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[customActionLambdaConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig:
		if err := validateEc2AsgCapacityIncreaseConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[ec2AsgCapacityIncreaseConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig:
		if err := validateEcsCapacityIncreaseConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[ecsCapacityIncreaseConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberEksResourceScalingConfig:
		if err := validateEksResourceScalingConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[eksResourceScalingConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberExecutionApprovalConfig:
		if err := validateExecutionApprovalConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[executionApprovalConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberGlobalAuroraConfig:
		if err := validateGlobalAuroraConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[globalAuroraConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberParallelConfig:
		if err := validateParallelExecutionBlockConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[parallelConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberRegionSwitchPlanConfig:
		if err := validateRegionSwitchPlanConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[regionSwitchPlanConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.ExecutionBlockConfigurationMemberRoute53HealthCheckConfig:
		if err := validateRoute53HealthCheckConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[route53HealthCheckConfig]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGlobalAuroraConfiguration(v *types.GlobalAuroraConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GlobalAuroraConfiguration"}
	if len(v.Behavior) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Behavior"))
	}
	if v.GlobalClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GlobalClusterIdentifier"))
	}
	if v.DatabaseClusterArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatabaseClusterArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKubernetesResourceType(v *types.KubernetesResourceType) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KubernetesResourceType"}
	if v.ApiVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiVersion"))
	}
	if v.Kind == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Kind"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKubernetesScalingApplication(v map[string]map[string]types.KubernetesScalingResource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KubernetesScalingApplication"}
	for key := range v {
		if err := validateRegionalScalingResource(v[key]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKubernetesScalingApps(v []map[string]map[string]types.KubernetesScalingResource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KubernetesScalingApps"}
	for i := range v {
		if err := validateKubernetesScalingApplication(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKubernetesScalingResource(v *types.KubernetesScalingResource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KubernetesScalingResource"}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateParallelExecutionBlockConfiguration(v *types.ParallelExecutionBlockConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ParallelExecutionBlockConfiguration"}
	if v.Steps == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Steps"))
	} else if v.Steps != nil {
		if err := validateSteps(v.Steps); err != nil {
			invalidParams.AddNested("Steps", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRegionalScalingResource(v map[string]types.KubernetesScalingResource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegionalScalingResource"}
	for key := range v {
		value := v[key]
		if err := validateKubernetesScalingResource(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRegionAndRoutingControls(v map[string][]types.ArcRoutingControlState) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegionAndRoutingControls"}
	for key := range v {
		if err := validateArcRoutingControlStates(v[key]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRegionSwitchPlanConfiguration(v *types.RegionSwitchPlanConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegionSwitchPlanConfiguration"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRoute53HealthCheckConfiguration(v *types.Route53HealthCheckConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Route53HealthCheckConfiguration"}
	if v.HostedZoneId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HostedZoneId"))
	}
	if v.RecordName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStep(v *types.Step) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Step"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ExecutionBlockConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionBlockConfiguration"))
	} else if v.ExecutionBlockConfiguration != nil {
		if err := validateExecutionBlockConfiguration(v.ExecutionBlockConfiguration); err != nil {
			invalidParams.AddNested("ExecutionBlockConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.ExecutionBlockType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionBlockType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSteps(v []types.Step) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Steps"}
	for i := range v {
		if err := validateStep(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrigger(v *types.Trigger) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Trigger"}
	if v.TargetRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetRegion"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if v.Conditions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Conditions"))
	} else if v.Conditions != nil {
		if err := validateTriggerConditionList(v.Conditions); err != nil {
			invalidParams.AddNested("Conditions", err.(smithy.InvalidParamsError))
		}
	}
	if v.MinDelayMinutesBetweenExecutions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinDelayMinutesBetweenExecutions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTriggerCondition(v *types.TriggerCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TriggerCondition"}
	if v.AssociatedAlarmName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssociatedAlarmName"))
	}
	if len(v.Condition) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Condition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTriggerConditionList(v []types.TriggerCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TriggerConditionList"}
	for i := range v {
		if err := validateTriggerCondition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTriggerList(v []types.Trigger) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TriggerList"}
	for i := range v {
		if err := validateTrigger(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWorkflow(v *types.Workflow) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Workflow"}
	if v.Steps != nil {
		if err := validateSteps(v.Steps); err != nil {
			invalidParams.AddNested("Steps", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.WorkflowTargetAction) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("WorkflowTargetAction"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWorkflowList(v []types.Workflow) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WorkflowList"}
	for i := range v {
		if err := validateWorkflow(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpApprovePlanExecutionStepInput(v *ApprovePlanExecutionStepInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApprovePlanExecutionStepInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if v.StepName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StepName"))
	}
	if len(v.Approval) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Approval"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelPlanExecutionInput(v *CancelPlanExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelPlanExecutionInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePlanInput(v *CreatePlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePlanInput"}
	if v.Workflows == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Workflows"))
	} else if v.Workflows != nil {
		if err := validateWorkflowList(v.Workflows); err != nil {
			invalidParams.AddNested("Workflows", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExecutionRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRole"))
	}
	if v.AssociatedAlarms != nil {
		if err := validateAssociatedAlarmMap(v.AssociatedAlarms); err != nil {
			invalidParams.AddNested("AssociatedAlarms", err.(smithy.InvalidParamsError))
		}
	}
	if v.Triggers != nil {
		if err := validateTriggerList(v.Triggers); err != nil {
			invalidParams.AddNested("Triggers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Regions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Regions"))
	}
	if len(v.RecoveryApproach) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RecoveryApproach"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePlanInput(v *DeletePlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePlanInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPlanEvaluationStatusInput(v *GetPlanEvaluationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPlanEvaluationStatusInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPlanExecutionInput(v *GetPlanExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPlanExecutionInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPlanInput(v *GetPlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPlanInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPlanInRegionInput(v *GetPlanInRegionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPlanInRegionInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPlanExecutionEventsInput(v *ListPlanExecutionEventsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPlanExecutionEventsInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPlanExecutionsInput(v *ListPlanExecutionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPlanExecutionsInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListRoute53HealthChecksInput(v *ListRoute53HealthChecksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListRoute53HealthChecksInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartPlanExecutionInput(v *StartPlanExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartPlanExecutionInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.TargetRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetRegion"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.ResourceTagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePlanExecutionInput(v *UpdatePlanExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePlanExecutionInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePlanExecutionStepInput(v *UpdatePlanExecutionStepInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePlanExecutionStepInput"}
	if v.PlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlanArn"))
	}
	if v.ExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionId"))
	}
	if v.Comment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Comment"))
	}
	if v.StepName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StepName"))
	}
	if len(v.ActionToTake) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ActionToTake"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePlanInput(v *UpdatePlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePlanInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.Workflows == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Workflows"))
	} else if v.Workflows != nil {
		if err := validateWorkflowList(v.Workflows); err != nil {
			invalidParams.AddNested("Workflows", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExecutionRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRole"))
	}
	if v.AssociatedAlarms != nil {
		if err := validateAssociatedAlarmMap(v.AssociatedAlarms); err != nil {
			invalidParams.AddNested("AssociatedAlarms", err.(smithy.InvalidParamsError))
		}
	}
	if v.Triggers != nil {
		if err := validateTriggerList(v.Triggers); err != nil {
			invalidParams.AddNested("Triggers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
