// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to programmatically list all data integration events for the
// provided Amazon Web Services Supply Chain instance.
func (c *Client) ListDataIntegrationEvents(ctx context.Context, params *ListDataIntegrationEventsInput, optFns ...func(*Options)) (*ListDataIntegrationEventsOutput, error) {
	if params == nil {
		params = &ListDataIntegrationEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataIntegrationEvents", params, optFns, c.addOperationListDataIntegrationEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataIntegrationEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters for ListDataIntegrationEvents.
type ListDataIntegrationEventsInput struct {

	// The Amazon Web Services Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// List data integration events for the specified eventType.
	EventType types.DataIntegrationEventType

	// Specify the maximum number of data integration events to fetch in one paginated
	// request.
	MaxResults *int32

	// The pagination token to fetch the next page of the data integration events.
	NextToken *string

	noSmithyDocumentSerde
}

// The response parameters for ListDataIntegrationEvents.
type ListDataIntegrationEventsOutput struct {

	// The list of data integration events.
	//
	// This member is required.
	Events []types.DataIntegrationEvent

	// The pagination token to fetch the next page of the ListDataIntegrationEvents.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataIntegrationEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataIntegrationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataIntegrationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataIntegrationEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataIntegrationEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataIntegrationEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataIntegrationEventsPaginatorOptions is the paginator options for
// ListDataIntegrationEvents
type ListDataIntegrationEventsPaginatorOptions struct {
	// Specify the maximum number of data integration events to fetch in one paginated
	// request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataIntegrationEventsPaginator is a paginator for ListDataIntegrationEvents
type ListDataIntegrationEventsPaginator struct {
	options   ListDataIntegrationEventsPaginatorOptions
	client    ListDataIntegrationEventsAPIClient
	params    *ListDataIntegrationEventsInput
	nextToken *string
	firstPage bool
}

// NewListDataIntegrationEventsPaginator returns a new
// ListDataIntegrationEventsPaginator
func NewListDataIntegrationEventsPaginator(client ListDataIntegrationEventsAPIClient, params *ListDataIntegrationEventsInput, optFns ...func(*ListDataIntegrationEventsPaginatorOptions)) *ListDataIntegrationEventsPaginator {
	if params == nil {
		params = &ListDataIntegrationEventsInput{}
	}

	options := ListDataIntegrationEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataIntegrationEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataIntegrationEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataIntegrationEvents page.
func (p *ListDataIntegrationEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataIntegrationEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataIntegrationEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataIntegrationEventsAPIClient is a client that implements the
// ListDataIntegrationEvents operation.
type ListDataIntegrationEventsAPIClient interface {
	ListDataIntegrationEvents(context.Context, *ListDataIntegrationEventsInput, ...func(*Options)) (*ListDataIntegrationEventsOutput, error)
}

var _ ListDataIntegrationEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataIntegrationEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataIntegrationEvents",
	}
}
