// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a virtual tape by using your own barcode. You write data to the virtual
// tape and then archive the tape. A barcode is unique and cannot be reused if it
// has already been used on a tape. This applies to barcodes used on deleted tapes.
// This operation is only supported in the tape gateway type.
//
// Cache storage must be allocated to the gateway before you can create a virtual
// tape. Use the AddCacheoperation to add cache storage to a gateway.
func (c *Client) CreateTapeWithBarcode(ctx context.Context, params *CreateTapeWithBarcodeInput, optFns ...func(*Options)) (*CreateTapeWithBarcodeOutput, error) {
	if params == nil {
		params = &CreateTapeWithBarcodeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTapeWithBarcode", params, optFns, c.addOperationCreateTapeWithBarcodeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTapeWithBarcodeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateTapeWithBarcodeInput
type CreateTapeWithBarcodeInput struct {

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tape with. Use the ListGatewaysoperation to return a list of gateways for your
	// account and Amazon Web Services Region.
	//
	// This member is required.
	GatewayARN *string

	// The barcode that you want to assign to the tape.
	//
	// Barcodes cannot be reused. This includes barcodes used for tapes that have been
	// deleted.
	//
	// This member is required.
	TapeBarcode *string

	// The size, in bytes, of the virtual tape that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 bytes).
	//
	// This member is required.
	TapeSizeInBytes *int64

	// Set to true to use Amazon S3 server-side encryption with your own KMS key, or
	// false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support
	// asymmetric CMKs. This value can only be set when KMSEncrypted is true . Optional.
	KMSKey *string

	// The ID of the pool that you want to add your tape to for archiving. The tape in
	// this pool is archived in the S3 storage class that is associated with the pool.
	// When you use your backup application to eject the tape, the tape is archived
	// directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds
	// to the pool.
	PoolId *string

	// A list of up to 50 tags that can be assigned to a virtual tape that has a
	// barcode. Each tag is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers
	// representable in UTF-8 format, and the following special characters: + - = . _ :
	// / @. The maximum length of a tag's key is 128 characters, and the maximum length
	// for a tag's value is 256.
	Tags []types.Tag

	// Set to TRUE if the tape you are creating is to be configured as a
	// write-once-read-many (WORM) tape.
	Worm bool

	noSmithyDocumentSerde
}

// CreateTapeOutput
type CreateTapeWithBarcodeOutput struct {

	// A unique Amazon Resource Name (ARN) that represents the virtual tape that was
	// created.
	TapeARN *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTapeWithBarcodeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateTapeWithBarcode{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateTapeWithBarcode{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTapeWithBarcode"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTapeWithBarcodeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTapeWithBarcode(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTapeWithBarcode(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTapeWithBarcode",
	}
}
