// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunegraph

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptunegraph/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new Neptune Analytics graph.
func (c *Client) CreateGraph(ctx context.Context, params *CreateGraphInput, optFns ...func(*Options)) (*CreateGraphOutput, error) {
	if params == nil {
		params = &CreateGraphInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGraph", params, optFns, c.addOperationCreateGraphMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGraphOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGraphInput struct {

	// A name for the new Neptune Analytics graph to be created.
	//
	// The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
	// character must be a letter. It cannot end with a hyphen or contain two
	// consecutive hyphens. Only lowercase letters are allowed.
	//
	// This member is required.
	GraphName *string

	// The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the
	// graph. Min = 16
	//
	// This member is required.
	ProvisionedMemory *int32

	// Indicates whether or not to enable deletion protection on the graph. The graph
	// can’t be deleted when deletion protection is enabled. ( true or false ).
	DeletionProtection *bool

	// Specifies a KMS key to use to encrypt data in the new graph.
	KmsKeyIdentifier *string

	// Specifies whether or not the graph can be reachable over the internet. All
	// access to graphs is IAM authenticated. ( true to enable, or false to disable.
	PublicConnectivity *bool

	// The number of replicas in other AZs. Min =0, Max = 2, Default = 1.
	//
	// Additional charges equivalent to the m-NCUs selected for the graph apply for
	// each replica.
	ReplicaCount *int32

	// Adds metadata tags to the new graph. These tags can also be used with cost
	// allocation reporting, or used in a Condition statement in an IAM policy.
	Tags map[string]string

	// Specifies the number of dimensions for vector embeddings that will be loaded
	// into the graph. The value is specified as dimension= value. Max = 65,535
	VectorSearchConfiguration *types.VectorSearchConfiguration

	noSmithyDocumentSerde
}

func (in *CreateGraphInput) bindEndpointParams(p *EndpointParameters) {

	p.ApiType = ptr.String("ControlPlane")
}

type CreateGraphOutput struct {

	// The ARN of the graph.
	//
	// This member is required.
	Arn *string

	// The ID of the graph.
	//
	// This member is required.
	Id *string

	// The graph name. For example: my-graph-1 .
	//
	// The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
	// character must be a letter. It cannot end with a hyphen or contain two
	// consecutive hyphens. Only lowercase letters are allowed.
	//
	// This member is required.
	Name *string

	// The build number of the graph software.
	BuildNumber *string

	// The time when the graph was created.
	CreateTime *time.Time

	// A value that indicates whether the graph has deletion protection enabled. The
	// graph can't be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// The graph endpoint.
	Endpoint *string

	// Specifies the KMS key used to encrypt data in the new graph.
	KmsKeyIdentifier *string

	// The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the
	// graph.
	//
	// Min = 16
	ProvisionedMemory *int32

	// Specifies whether or not the graph can be reachable over the internet. All
	// access to graphs is IAM authenticated.
	//
	// If enabling public connectivity for the first time, there will be a delay while
	// it is enabled.
	PublicConnectivity *bool

	// The number of replicas in other AZs.
	//
	// Default: If not specified, the default value is 1.
	ReplicaCount *int32

	// The ID of the source graph.
	SourceSnapshotId *string

	// The current status of the graph.
	Status types.GraphStatus

	// The reason the status was given.
	StatusReason *string

	// The vector-search configuration for the graph, which specifies the vector
	// dimension to use in the vector index, if any.
	VectorSearchConfiguration *types.VectorSearchConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGraphMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGraph{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGraph{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGraph"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGraphValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGraph(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGraph(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGraph",
	}
}
