// Code generated by smithy-go-codegen DO NOT EDIT.

package iotwireless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotwireless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the network analyzer configurations.
func (c *Client) ListNetworkAnalyzerConfigurations(ctx context.Context, params *ListNetworkAnalyzerConfigurationsInput, optFns ...func(*Options)) (*ListNetworkAnalyzerConfigurationsOutput, error) {
	if params == nil {
		params = &ListNetworkAnalyzerConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListNetworkAnalyzerConfigurations", params, optFns, c.addOperationListNetworkAnalyzerConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListNetworkAnalyzerConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListNetworkAnalyzerConfigurationsInput struct {

	// The maximum number of results to return in this operation.
	MaxResults int32

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListNetworkAnalyzerConfigurationsOutput struct {

	// The list of network analyzer configurations.
	NetworkAnalyzerConfigurationList []types.NetworkAnalyzerConfigurations

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListNetworkAnalyzerConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListNetworkAnalyzerConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListNetworkAnalyzerConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListNetworkAnalyzerConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListNetworkAnalyzerConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListNetworkAnalyzerConfigurationsPaginatorOptions is the paginator options for
// ListNetworkAnalyzerConfigurations
type ListNetworkAnalyzerConfigurationsPaginatorOptions struct {
	// The maximum number of results to return in this operation.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListNetworkAnalyzerConfigurationsPaginator is a paginator for
// ListNetworkAnalyzerConfigurations
type ListNetworkAnalyzerConfigurationsPaginator struct {
	options   ListNetworkAnalyzerConfigurationsPaginatorOptions
	client    ListNetworkAnalyzerConfigurationsAPIClient
	params    *ListNetworkAnalyzerConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListNetworkAnalyzerConfigurationsPaginator returns a new
// ListNetworkAnalyzerConfigurationsPaginator
func NewListNetworkAnalyzerConfigurationsPaginator(client ListNetworkAnalyzerConfigurationsAPIClient, params *ListNetworkAnalyzerConfigurationsInput, optFns ...func(*ListNetworkAnalyzerConfigurationsPaginatorOptions)) *ListNetworkAnalyzerConfigurationsPaginator {
	if params == nil {
		params = &ListNetworkAnalyzerConfigurationsInput{}
	}

	options := ListNetworkAnalyzerConfigurationsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListNetworkAnalyzerConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListNetworkAnalyzerConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListNetworkAnalyzerConfigurations page.
func (p *ListNetworkAnalyzerConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListNetworkAnalyzerConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListNetworkAnalyzerConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListNetworkAnalyzerConfigurationsAPIClient is a client that implements the
// ListNetworkAnalyzerConfigurations operation.
type ListNetworkAnalyzerConfigurationsAPIClient interface {
	ListNetworkAnalyzerConfigurations(context.Context, *ListNetworkAnalyzerConfigurationsInput, ...func(*Options)) (*ListNetworkAnalyzerConfigurationsOutput, error)
}

var _ ListNetworkAnalyzerConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListNetworkAnalyzerConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListNetworkAnalyzerConfigurations",
	}
}
