// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get the over-the-air (OTA) task.
func (c *Client) GetOtaTask(ctx context.Context, params *GetOtaTaskInput, optFns ...func(*Options)) (*GetOtaTaskOutput, error) {
	if params == nil {
		params = &GetOtaTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetOtaTask", params, optFns, c.addOperationGetOtaTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetOtaTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetOtaTaskInput struct {

	// The over-the-air (OTA) task id.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetOtaTaskOutput struct {

	// The timestamp value of when the over-the-air (OTA) task was created.
	CreatedAt *time.Time

	// The description of the over-the-air (OTA) task.
	Description *string

	// The timestamp value of when the over-the-air (OTA) task was last updated at.
	LastUpdatedAt *time.Time

	// The deployment mechanism for the over-the-air (OTA) task.
	OtaMechanism types.OtaMechanism

	// Over-the-air (OTA) task scheduling config.
	OtaSchedulingConfig *types.OtaTaskSchedulingConfig

	// The query string to add things to the thing group.
	OtaTargetQueryString *string

	// Over-the-air (OTA) task retry config.
	OtaTaskExecutionRetryConfig *types.OtaTaskExecutionRetryConfig

	// The frequency type for the over-the-air (OTA) task.
	OtaType types.OtaType

	// The connection protocol the over-the-air (OTA) task uses to update the device.
	Protocol types.OtaProtocol

	// The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
	S3Url *string

	// The status of the over-the-air (OTA) task.
	Status types.OtaStatus

	// The device targeted for the over-the-air (OTA) task.
	Target []string

	// The Amazon Resource Name (ARN) of the over-the-air (OTA) task
	TaskArn *string

	// The identifier for the over-the-air (OTA) task configuration.
	TaskConfigurationId *string

	// The id of the over-the-air (OTA) task.
	TaskId *string

	// The processing details of all over-the-air (OTA) tasks.
	TaskProcessingDetails *types.TaskProcessingDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetOtaTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetOtaTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetOtaTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetOtaTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetOtaTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetOtaTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetOtaTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetOtaTask",
	}
}
