// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all the Glue usage profiles.
func (c *Client) ListUsageProfiles(ctx context.Context, params *ListUsageProfilesInput, optFns ...func(*Options)) (*ListUsageProfilesOutput, error) {
	if params == nil {
		params = &ListUsageProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListUsageProfiles", params, optFns, c.addOperationListUsageProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListUsageProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListUsageProfilesInput struct {

	// The maximum number of usage profiles to return in a single response.
	MaxResults *int32

	// A continuation token, included if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListUsageProfilesOutput struct {

	// A continuation token, present if the current list segment is not the last.
	NextToken *string

	// A list of usage profile ( UsageProfileDefinition ) objects.
	Profiles []types.UsageProfileDefinition

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListUsageProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListUsageProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListUsageProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListUsageProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListUsageProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListUsageProfilesPaginatorOptions is the paginator options for ListUsageProfiles
type ListUsageProfilesPaginatorOptions struct {
	// The maximum number of usage profiles to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListUsageProfilesPaginator is a paginator for ListUsageProfiles
type ListUsageProfilesPaginator struct {
	options   ListUsageProfilesPaginatorOptions
	client    ListUsageProfilesAPIClient
	params    *ListUsageProfilesInput
	nextToken *string
	firstPage bool
}

// NewListUsageProfilesPaginator returns a new ListUsageProfilesPaginator
func NewListUsageProfilesPaginator(client ListUsageProfilesAPIClient, params *ListUsageProfilesInput, optFns ...func(*ListUsageProfilesPaginatorOptions)) *ListUsageProfilesPaginator {
	if params == nil {
		params = &ListUsageProfilesInput{}
	}

	options := ListUsageProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListUsageProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListUsageProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListUsageProfiles page.
func (p *ListUsageProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListUsageProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListUsageProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListUsageProfilesAPIClient is a client that implements the ListUsageProfiles
// operation.
type ListUsageProfilesAPIClient interface {
	ListUsageProfiles(context.Context, *ListUsageProfilesInput, ...func(*Options)) (*ListUsageProfilesOutput, error)
}

var _ ListUsageProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListUsageProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListUsageProfiles",
	}
}
